import { CanActivate, ExecutionContext, Injectable } from '@nestjs/common';
import { AppService } from './app.service';
import { getUserFromContext } from './utility/mycard-auth';
import { BlankReturnMessageDto } from './dto/ReturnMessage.dto';

@Injectable()
export class MyCardAppMaintainerGuard implements CanActivate {
  constructor(private readonly appService: AppService) {}
  async canActivate(context: ExecutionContext): Promise<boolean> {
    const user = await getUserFromContext(context);
    if (!user) {
      throw new BlankReturnMessageDto(401, 'Invalid user').toException();
    }
    if (!(await this.appService.isUserCanMaintainApp(user))) {
      throw new BlankReturnMessageDto(403, 'Permission denied').toException();
    }
    return true;
  }
}
