import { NestFactory } from '@nestjs/core';
import { DocumentBuilder, SwaggerModule } from '@nestjs/swagger';
import { NestExpressApplication } from '@nestjs/platform-express';
import { AppModule } from './app.module';
import mustacheExpress from 'mustache-express';
import bodyParser from 'body-parser';
import path from 'path';

async function bootstrap() {
  const app = await NestFactory.create<NestExpressApplication>(AppModule);
  app.enableCors();
  app.set('trust proxy', ['172.16.0.0/12', 'loopback']);

  app.setBaseViewsDir(path.join(__dirname, '..', 'views'));
  const engine = mustacheExpress();
  app.engine('mustache', engine);
  app.setViewEngine('mustache');

  const documentConfig = new DocumentBuilder()
    .setTitle('mycard-console-api')
    .setDescription('萌卡 APP 更新发布后台')
    .setVersion('1.0')
    .addTag('admin', '只有萌卡管理员可以用')
    .addTag('update', '萌卡客户端使用的')
    .build();

  const document = SwaggerModule.createDocument(app, documentConfig);
  SwaggerModule.setup('docs', app, document);

  app.use(bodyParser.json({ limit: '10gb' }));
  app.use(
    bodyParser.urlencoded({
      limit: '10gb',
      extended: true,
      parameterLimit: 100000,
    })
  );

  await app.listen(3000);
}
bootstrap();
