import { Column, Entity, Index, ManyToOne, OneToMany, PrimaryGeneratedColumn } from 'typeorm';
import { App } from './App.entity';
import { Build } from './Build.entity';
import { TimeBase } from './TimeBase.entity';
import { DepotLike } from '../dto/Depot.dto';

@Index((d) => [d.app, d.locale, d.platform, d.arch], { unique: true })
@Entity()
export class Depot extends TimeBase implements DepotLike {
  @PrimaryGeneratedColumn()
  id: number;

  @Index()
  @Column({ default: 'generic' })
  locale: string;

  @Index()
  @Column({ default: 'generic' })
  platform: string;

  @Index()
  @Column({ default: 'generic' })
  arch: string;

  @ManyToOne((type) => App, (app) => app.depots)
  app: App;

  @OneToMany(() => Build, (build) => build.depot)
  builds: Build[];
}
