import { SearchOutlined } from "@ant-design/icons";
import { Avatar, Button, Input, List } from "antd";
import React, { useState } from "react";
import { proxy, useSnapshot } from "valtio";

import { CardMeta, sendSelectOptionResponse } from "@/api";
import { getCardImgUrl } from "@/ui/Shared";

import { NeosModal } from "../NeosModal";
import styles from "./index.module.scss";

interface Props {
  isOpen: boolean;
  opcodes: number[];
}

const defaultProps = {
  isOpen: false,
  opcodes: [],
};

const store = proxy<Props>(defaultProps);

export const AnnounceModal: React.FC = () => {
  const { isOpen } = useSnapshot(store);
  const [searchWord, setSearchWord] = useState("");
  const [cardList, setCardList] = useState<CardMeta[]>([]);
  const [selected, setSelected] = useState<number | undefined>(undefined);

  const handleSearch = () => {};
  const onSummit = () => {
    if (selected !== undefined) {
      sendSelectOptionResponse(selected);
      rs();
      setSearchWord("");
      setCardList([]);
    }
  };

  return (
    <NeosModal
      title="请输入关键字并选择宣言的卡"
      open={isOpen}
      footer={
        <Button disabled={selected === undefined} onClick={onSummit}>
          确定
        </Button>
      }
    >
      <div className={styles.container}>
        <Input
          className={styles.input}
          placeholder="请输入宣言卡名(或关键字)"
          bordered={false}
          value={searchWord}
          onChange={(e) => setSearchWord(e.target.value)}
          suffix={
            <Button
              type="text"
              icon={<SearchOutlined />}
              onClick={() => handleSearch()}
            />
          }
          onKeyUp={(e) => e.key === "Enter" && handleSearch()}
          allowClear
        />
        <List
          pagination={{ position: "bottom", align: "center" }}
          dataSource={cardList}
          renderItem={(item, index) => (
            <List.Item key={index}>
              <List.Item.Meta
                avatar={<Avatar src={getCardImgUrl(item.id)} />}
                title={<a>{item.text.name}</a>}
                description={item.text.desc}
              />
            </List.Item>
          )}
        />
      </div>
    </NeosModal>
  );
};

let rs: (v?: any) => void = () => {};
