import { BufferReader } from "rust-src";

import { ygopro } from "../../../idl/ocgcore";
import MsgWin = ygopro.StocGameMessage.MsgWin;
import { AudioActionType, changeScene } from "@/infra/audio";
import { matStore } from "@/stores";

/*
 * Msg Win
 *
 * @param player - 玩家编号
 * @param winType - 结果类型
 * */
export default (data: Uint8Array) => {
  const reader = new BufferReader(data);

  const win_player = reader.readUint8();
  const reason = reader.readUint8();
  // 双打需要改这里判断
  if (matStore.isMe(win_player)) {
    changeScene(AudioActionType.BGM_WIN);
  } else {
    changeScene(AudioActionType.BGM_LOSE);
  }

  return new MsgWin({
    win_player,
    reason,
  });
};
