import { useConfig } from "@/config";

import styles from "./index.module.scss";

const { assetsPath } = useConfig();

export const BgChain: React.FC<{ chains: readonly number[] }> = ({
  chains,
}) => (
  <div className={styles.container}>
    {chains.map((chain) => (
      <div className={styles.chain} key={chain}>
        <img src={`${assetsPath}/chain.png`} />
        <div className={styles.text}>{chain}</div>
      </div>
    ))}
  </div>
);
