/*
 * 旨在跳过登录界面，直接进入游戏(和AI对战、后续可能增加自动的PVP)。
 * 仅在开发环境下生效，便于开发者快速调节决斗界面。
 */

interface AutoModeConfig {
  defaultPlayer?: string;
  defaultDeck?: string;
  defaultPassword?: string;
  defaultMora?: string;
  isAiMode?: boolean;
  isAiFirst?: boolean;
}

const autoModeConfig: AutoModeConfig = {
  defaultPlayer: "",
  defaultDeck: "",
  defaultPassword: "",
};

const aiModeConfig: AutoModeConfig = {
  defaultPlayer: "AiKiller",
  defaultDeck: import.meta.env.VITE_AI_MODE_DEFAULT_DECK ?? "hero",
  defaultPassword: "AI",
  defaultMora: "scissors",
  isAiMode: true,
  isAiFirst: import.meta.env.VITE_IS_AI_FIRST === "true",
};

export function useAutoMode(): AutoModeConfig {
  if (!import.meta.env.DEV) return {};

  if (import.meta.env.VITE_IS_AI_MODE === "true") {
    return aiModeConfig;
  }

  return autoModeConfig;
}
