import { DECKS } from "./structureDeck";

const DeckManager = _objToMap(DECKS);

/*
 * 返回卡组资源。
 *
 * @param deck- 卡组名称
 * @returns 卡组数据
 *
 * @todo - 这里应该为萌卡实现卡组存储
 * */
export async function fetchDeck(deck: string): Promise<IDeck> {
  const res = DeckManager.get(deck);

  return res ?? { deckName: "undefined", main: [], extra: [], side: [] };
}

function _objToMap(object: IDeck[]): Map<string, IDeck> {
  const map: Map<string, IDeck> = new Map();

  object.forEach((value) => map.set(value.deckName, value));

  return map;
}

export interface IDeck {
  deckName: string;
  main: number[];
  extra: number[];
  side: number[];
}
