import { App, Button, Modal } from "antd";
import React from "react";
import { DndProvider } from "react-dnd";
import { HTML5Backend } from "react-dnd-html5-backend";

import { deckStore } from "@/stores";

import { DeckEditor } from "../BuildDeck";
import { editDeckStore } from "../BuildDeck/store";
import { iDeckToEditingDeck } from "../BuildDeck/utils";
import { Background } from "../Shared";

export const Component: React.FC = () => {
  const deck = deckStore.decks[0];
  const { message } = App.useApp();
  return (
    <Modal
      title="请选择更换副卡组"
      open={true}
      width={700}
      footer={<Button onClick={() => {}}>副卡组更换完毕</Button>}
    >
      <DndProvider backend={HTML5Backend}>
        <Background />
        <DeckEditor
          deck={deck}
          onClear={() => message.error("对局中清空卡组不怕找不回来吗?!")}
          onSave={() => message.error("点击右下角按钮确认副卡组更换完毕")}
          onReset={async () => {
            editDeckStore.set(await iDeckToEditingDeck(deck));
          }}
        />
      </DndProvider>
    </Modal>
  );
};
