import { CheckOutlined, UndoOutlined } from "@ant-design/icons";
import { Button, Space } from "antd";
import React from "react";
import { DndProvider } from "react-dnd";
import { HTML5Backend } from "react-dnd-html5-backend";

import { CardDetail } from "../BuildDeck/CardDetail";
import { Background, ScrollableArea } from "../Shared";
import { Chat } from "../WaitRoom/Chat";
import styles from "./index.module.scss";

export const Component: React.FC = () => {
  return (
    <DndProvider backend={HTML5Backend}>
      <Background />
      <div className={styles.container}>
        <div className={styles.sider}>
          <Chat />
        </div>
        <div className={styles.content}>
          <div className={styles["deck-container"]}>
            <Space className={styles.title}>
              <div>请拖动更换副卡组</div>
              <Space style={{ marginRight: 6 }}>
                <Button type="text" size="small" icon={<UndoOutlined />}>
                  重置
                </Button>
                <Button type="primary" size="small" icon={<CheckOutlined />}>
                  确定
                </Button>
              </Space>
            </Space>
            <ScrollableArea className={styles["deck-zone"]}></ScrollableArea>
          </div>
        </div>
        <div className={styles["detail-container"]}>
          <CardDetail code={10000} open={true} onClose={() => {}} />
        </div>
      </div>
    </DndProvider>
  );
};
