import classnames from "classnames";

import { useConfig } from "@/config";

import styles from "./index.module.scss";

const { assetsPath } = useConfig();

export interface ChainProps {
  chains: readonly number[];
  banish?: boolean;
  graveyard?: boolean;
  extra?: boolean;
  op?: boolean;
}

export const BgChain: React.FC<ChainProps> = ({
  chains,
  banish,
  graveyard,
  extra,
  op,
}) => (
  <div
    className={classnames(styles.container, {
      [styles.banish]: banish,
      [styles.graveyard]: graveyard,
      [styles["extra-deck"]]: extra,
      [styles.op]: op,
    })}
  >
    {chains.map((chain) => (
      <div className={styles.chain} key={chain}>
        <img src={`${assetsPath}/chain.png`} />
        <div className={styles.text}>{chain}</div>
      </div>
    ))}
  </div>
);
