import moment from 'moment';
import { ApiProperty } from '@nestjs/swagger';
import { Response } from 'express';

export interface CxcyReturnMessageLike<T> {
  success: boolean;
  timestamp: number;
  request_id: string;
  status_code: number;
  message?: string;
  data?: T;
}

export class CxcyReturnMessageDto<T> implements CxcyReturnMessageLike<T> {
  @ApiProperty({ description: '是否成功' })
  success: boolean;
  @ApiProperty({ description: '请求日期' })
  timestamp: number;
  @ApiProperty({ description: '请求中的请求 ID。' })
  public request_id: string;
  @ApiProperty({ description: '状态码' })
  public status_code: number;
  @ApiProperty({ description: '提示信息' })
  public message?: string;
  @ApiProperty({ description: '返回内容' })
  public data?: T;
  constructor(
    request_id: string,
    status_code: number,
    message?: string,
    data?: T,
  ) {
    this.request_id = request_id;
    this.status_code = status_code;
    this.message = message;
    this.data = data;
    this.success = status_code < 400;
    this.timestamp = moment().unix();
  }

  writeResponse(res: Response) {
    res.status(this.status_code).json(this);
  }
}
