import { NestFactory } from '@nestjs/core';
import { AppModule } from './app.module';
import { DocumentBuilder, SwaggerModule } from '@nestjs/swagger';

async function bootstrap() {
  const app = await NestFactory.create(AppModule);
  app.enableCors();

  const documentConfig = new DocumentBuilder()
    .setTitle('cxcy-scoresheet')
    .setDescription('创新创业报告生成模块')
    .setVersion('1.0')
    .addTag('user', '用户接口')
    .build();

  const document = SwaggerModule.createDocument(app, documentConfig);
  SwaggerModule.setup('docs', app, document);

  await app.listen(3000);
}
bootstrap();
