import { Injectable } from '@nestjs/common';
import { AppLogger } from './app.logger';
import mustache from 'mustache';
import * as fs from 'fs';
import mdToPdf from 'md-to-pdf';

export interface NameWise {
  name: string;
}

export interface ScoreSheetData {
  name: string;
  displaySex: string;
  id: string;
  collegeString: string;
  professionString: string;
  projects: NameWise[];
  theses: NameWise[];
  patents: NameWise[];
}

@Injectable()
export class AppService {
  template: string;
  constructor(private log: AppLogger) {
    this.log.setContext('app');
    this.template = fs.readFileSync('./report.md.mustache', 'utf8');
  }

  async getPdf(data: ScoreSheetData) {
    this.log.log(data);
    const renderedMarkdownContent = mustache.render(this.template, data, null, {
      escape: (v) => v,
    });
    this.log.log(renderedMarkdownContent);
    const { content } = await mdToPdf({ content: renderedMarkdownContent });
    return content;
  }
}
