import { Body, Controller, Get, Post, Query, Res } from '@nestjs/common';
import { AppService, ScoreSheetData } from './app.service';
import { Response } from 'express';

@Controller()
export class AppController {
  constructor(private readonly appService: AppService) {}

  @Get('report.pdf')
  async getPdf(@Query('data') dataRaw: string, @Res() res: Response) {
    let data: any;
    try {
      data = JSON.parse(dataRaw);
    } catch (e) {
      res.status(400).end({ message: 'bad JSON' });
      return;
    }
    if (!data || !data.id || !data.name) {
      res.status(400).end({ message: 'bad student data' });
    }
    const pdf = await this.appService.getPdf(data);
    res.set({
      'Content-Type': 'application/pdf',
      'Content-Disposition': `attachment; filename=${data.id}-${data.name}.pdf`,
      'Content-Length': pdf.length,

      // prevent cache
      'Cache-Control': 'no-cache, no-store, must-revalidate',
      Pragma: 'no-cache',
      Expires: 0,
    });
    res.end(pdf);
  }
}
