import { promises as fs } from 'fs';
import { AppsJson } from '../app/apps-json-type';
import * as _ from 'lodash';

async function main() {
    const apps: AppsJson.App[] = JSON.parse(await fs.readFile(process.argv[2], 'utf-8'));
    for (const app of apps) {
        console.log(`Reading ${app.id}`);
        const actions = app.actions;
        actions.linux = _.cloneDeep(actions.darwin);
        for (const [actionName, action] of Object.entries(actions.linux)) {
            if (action.open === 'wine') {
                console.log(`Patching Linux action ${app.id}-${actionName}`);
                action.open = undefined;
                action.interpreter = 'wine';
            }
        }
    }
    await fs.writeFile(process.argv[2], JSON.stringify(apps, null, 2));
}
main();
