"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const _ = require("lodash");
function main() {
    return __awaiter(this, void 0, void 0, function* () {
        const apps = JSON.parse(yield fs_1.promises.readFile(process.argv[2], 'utf-8'));
        for (const app of apps) {
            console.log(`Reading ${app.id}`);
            const actions = app.actions;
            actions.linux = _.cloneDeep(actions.darwin);
            for (const [actionName, action] of Object.entries(actions.linux)) {
                if (action.open === 'wine') {
                    console.log(`Patching Linux action ${app.id}-${actionName}`);
                    action.open = undefined;
                    action.interpreter = 'wine';
                }
            }
        }
        yield fs_1.promises.writeFile(process.argv[2], JSON.stringify(apps, null, 2));
    });
}
main();
//# sourceMappingURL=patch-linux-wine.js.map