import { ChangeDetectorRef, Component, ElementRef, Inject, LOCALE_ID, OnInit, ViewChild } from '@angular/core';
import { shell } from 'electron';
import * as remote from '@electron/remote';
import $ from 'jquery';
import { LoginService } from '../login/login.service';
import { SettingsService } from '../settings.service';
import { Tooltip } from 'bootstrap';
import Store from 'electron-store';

const autoUpdater: Electron.AutoUpdater = remote.getGlobal('autoUpdater');
const konami_code_logger: string[] = [];

@Component({
  selector: 'mycard',
  templateUrl: 'mycard.component.html',
  styleUrls: ['mycard.component.css'],
})
export class MyCardComponent implements OnInit {
  currentPage: string = 'lobby';

  update_status: string | undefined = remote.getGlobal('update_status');
  update_error: string | undefined;
  currentWindow = remote.getCurrentWindow();
  window = window;

  @ViewChild('error')
  error: ElementRef;
  @ViewChild('checking_for_update')
  checking_for_update: ElementRef;
  @ViewChild('update_available')
  update_available: ElementRef;
  @ViewChild('update_downloaded')
  update_downloaded: ElementRef;
  update_elements: Map<string, ElementRef>;

  localeNew: string = this.locale;

  resizing: HTMLElement | null;

  @ViewChild('moesound')
  moesound: ElementRef;
  lastTooltip: Tooltip;

  constructor(public loginService: LoginService, private ref: ChangeDetectorRef, @Inject(LOCALE_ID) public locale: string) {
    // renderer.listenGlobal('window', 'message', (event) => {
    //     console.log(event);
    //     // Do something with 'event'
    // });

    this.currentWindow.on('maximize', () => this.ref.detectChanges());
    this.currentWindow.on('unmaximize', () => this.ref.detectChanges());

    autoUpdater.on('error', (error) => {
      console.dir(error);
      this.set_update_status('error');
    });
    autoUpdater.on('checking-for-update', () => {
      this.set_update_status('checking-for-update');
    });
    autoUpdater.on('update-available', () => {
      this.set_update_status('update-available');
    });
    autoUpdater.on('update-not-available', () => {
      this.set_update_status('update-not-available');
    });
    autoUpdater.on('update-downloaded', (event) => {
      this.set_update_status('update-downloaded');
    });
  }

  ngOnInit() {
    this.update_elements = new Map(
      Object.entries({
        error: this.error,
        'checking-for-update': this.checking_for_update,
        'update-available': this.update_available,
        'update-downloaded': this.update_downloaded,
      })
    );
    $('#settings-modal').on('keyup', (event) => {
      konami_code_logger.unshift(event.key);
      if (
        konami_code_logger[9] == 'ArrowUp' &&
        konami_code_logger[8] == 'ArrowUp' &&
        konami_code_logger[7] == 'ArrowDown' &&
        konami_code_logger[6] == 'ArrowDown' &&
        konami_code_logger[5] == 'ArrowLeft' &&
        konami_code_logger[4] == 'ArrowRight' &&
        konami_code_logger[3] == 'ArrowLeft' &&
        konami_code_logger[2] == 'ArrowRight' &&
        konami_code_logger[1].toLowerCase() == 'b' &&
        konami_code_logger[0].toLowerCase() == 'a'
      ) {
        this.currentWindow.webContents.openDevTools();
      }
    });
    // document.addEventListener('drop', (event)=>{
    //     console.log('drop', event);
    //     event.preventDefault();
    //
    // });
  }

  update_retry() {
    autoUpdater.checkForUpdates();
  }

  update_install() {
    autoUpdater.quitAndInstall();
  }

  set_update_status(status: string) {
    console.log('autoUpdater', status);
    if (this.lastTooltip) {
      this.lastTooltip.dispose();
    }

    this.update_status = status;
    this.ref.detectChanges();

    let element = this.update_elements.get(this.update_status)!;
    this.lastTooltip = new Tooltip(element.nativeElement, { placement: 'bottom', container: 'body' });
  }

  openExternal(url: string) {
    shell.openExternal(url);
  }

  submit() {
    if (this.localeNew !== this.locale) {
      const store = new Store();
      store.set(SettingsService.SETTING_LOCALE, this.localeNew);
      remote.app.relaunch();
      remote.app.quit();
    }
  }

  //
  // moesound_loaded() {
  //     this.moesound.nativeElement.insertCSS(`
  //         body > section > header, #bjax-target > div.row.m-t-lg.m-b-lg, #bjax-target > section {
  //             display: none;
  //         }
  //         body > section > section {
  //             top: 0!important;
  //         }
  //     `);
  // }
  //
  // moesound_newwindow(url: string) {
  //     console.log(url);
  // }
}
