const raw = require('raw-socket');
const socket = raw.createSocket({ protocol: raw.Protocol.UDP });
const handler = {
  connect(local_port, remote_port, remote_address) {
    const buffer = Buffer.alloc(9);
    buffer.writeUInt16BE(local_port, 0);
    buffer.writeUInt16BE(remote_port, 2);
    buffer.writeUInt16BE(buffer.length, 4);
    socket.send(buffer, 0, buffer.length, remote_address, () => {});
  },
};

process.on('message', (message) => {
  handler[message.action](...message.arguments);
});
process.on('disconnect', process.exit);
process.send('initialized');
