export namespace AppsJson {

    export interface Name {
        'zh-CN': string;
        'en-US': string;
    }

    export interface Description {
        'zh-CN': string;
        'en-US': string;
    }

    export interface ZhCN {
        name: string;
        url: string;
    }

    export interface Developers {
        'zh-CN': ZhCN[];
    }

    export interface ZhCN2 {
        name: string;
        url: string;
    }

    export interface Publishers {
        'zh-CN': ZhCN2[];
    }

    export interface Trailer {
        type: string;
        url: string;
        url2: string;
    }

    export interface Dependencies {
        win32: string[];
        darwin: string[];
        linux: any[];
    }

    export interface References {
        win32: string[];
        darwin: string[];
    }

    export interface Env {
    }

	export interface Action {
		interpreter?: string;
        execute: string;
        args: any[];
        env: Record<string, string>;
        open: string;
    }

    export interface Env2 {
    }

    export interface Custom {
        execute: string;
        args: any[];
        env: Env2;
    }

    export interface Install {
        execute: string;
        args: string[];
    }

    export interface Env3 {
    }

    export interface Network {
        execute: string;
        args: any[];
        env: Env3;
	}

    export interface Env4 {
        LANG: string;
        WINEDEBUG: string;
    }

    export interface Main2 {
        execute: string;
        args: any[];
        open: string;
        env: Env4;
    }

    export interface Env5 {
        LANG: string;
    }

    export interface Custom2 {
        execute: string;
        args: any[];
        open: string;
        env: Env5;
    }

    export interface Install2 {
        execute: string;
        args: string[];
        open: string;
    }

    export interface Env6 {
        LANG: string;
    }

    export interface Network2 {
        execute: string;
        args: any[];
        open: string;
        env: Env6;
    }

    export interface Env7 {
    }

    export interface Main3 {
        execute: string;
        args: any[];
        env: Env7;
    }

    export interface Linux {
        main: Main3;
	}

	export type PlatformAction = Record<string, Action>;

    export interface Actions {
        win32: PlatformAction;
        darwin: PlatformAction;
        linux: PlatformAction;
    }

    export interface Version {
        win32: string;
        darwin: string;
        linux: string;
    }

    export interface Server {
        id: string;
        url: string;
    }

    export interface Network3 {
        protocol: string;
        port: number;
        servers: Server[];
    }

    export interface DeckYdk {
        sync: boolean;
    }

    export interface SingleLua {
        sync: boolean;
    }

    export interface ReplayYrp {
        sync: boolean;
    }

    export interface Files {
        'deck/*.ydk': DeckYdk;
        'single/*.lua': SingleLua;
        'replay/*.yrp': ReplayYrp;
    }

    export interface Windbot {
        'zh-CN': string[];
        'en-US': string[];
    }

    export interface Data {
        windbot: Windbot;
    }

    export interface Price {
        cny: number;
        usd: number;
    }

    export interface App {
        id: string;
        name: Name;
        description: Description;
        developers: Developers;
        publishers: Publishers;
        released_at: string;
        category: string;
        tags: string[];
        trailer: Trailer[];
        dependencies: Dependencies;
        references: References;
        author: string;
        homepage: string;
        locales: string[];
        actions: Actions;
        version: Version;
        news: any;
        conference: string;
        icon: string;
        cover: string;
        background: string;
        parent: string;
        network: Network3;
        updated_at: string;
        files: Files;
        data: Data;
        price: Price;
    }

}
