export namespace AppsJson {

    export enum Locale {
        zh_CN = 'zh-CN',
        en_US = 'en-US',
        ja_JP = 'ja-JP',
        ko_KR = 'ko-KR',
        pt_BR = 'pt-BR',
        zh_HK = 'zh-HK',
        zh_TW = 'zh-TW',
    }
    export enum Platform {
        Linux = 'linux',
        macOS = 'darwin',
        Windows = 'win32',
    }

    export type LocaleWise<T> = Record<Locale, T>;

    export type PlatformWise<T> = Record<Platform, T>;

    export interface Developer {
        name: string;
        url: string;
    }

    export interface Trailer {
        type: string;
        url: string;
        url2?: string;
    }

    export interface Action {
        interpreter?: string;
        execute: string;
        args: any[];
        env: Record<string, string>;
        open?: string;
    }

    export type PlatformAction = Record<string, Action>;

    export interface News {
        url: string;
        image: string;
        title: string;
        text: string;
        updated_at: string;
    }

    export interface NetworkServer {
        id: string;
        url: string;
    }

    export interface Network {
        protocol: string;
        port: number;
        servers: NetworkServer[];
    }

    export interface Syncable {
        sync: boolean;
    }

    export interface Price {
        cny: number;
        usd: number;
    }

    export interface App {
        id: string;
        key?: string;
        name?: LocaleWise<string>;
        description?: LocaleWise<string>;
        developers?: LocaleWise<Developer[]>;
        publishers?: LocaleWise<Developer[]>;
        released_at?: string;
        category?: string;
        tags?: string[];
        trailer?: Trailer[];
        dependencies?: PlatformWise<string[]>;
        references?: PlatformWise<string[]>;
        author?: string;
        homepage?: string;
        locales?: string[];
        actions?: PlatformWise<PlatformAction>;
        version?: PlatformWise<string>;
        news?: LocaleWise<News[]>;
        conference?: string;
        icon?: string;
        cover?: string;
        background?: string;
        parent?: string;
        network?: Network;
        updated_at?: string;
        files?: Record<string, Syncable>;
        data?: any;
        price?: Price;
    }

}
