const CopyPlugin = require('copy-webpack-plugin');

module.exports = {
  target: 'electron-renderer',
  externals: Object.fromEntries(['bufferutil', 'utf-8-validate'].map((pkg) => [pkg, `commonjs2 ${pkg}`])),
  plugins: [
    new CopyPlugin({
      patterns: [{ from: 'node_modules/candy/res', to: 'candy/res' }],
    }),
  ],
  module: {
    rules: [
      {
        test: require.resolve('candy'),
        use: [
          {
            loader: 'imports-loader',
            options: {
              imports: ['default jquery jQuery', 'default mustache Mustache'],
            },
          },
          {
            loader: 'exports-loader',
            options: {
              exports: ['Candy'],
            },
          },
        ],
      },
      {
        test: require.resolve('jquery-i18n/jquery.i18n.js'),
        loader: 'imports-loader',
        options: {
          type: 'commonjs',
          imports: 'single jquery jQuery',
        },
      },
      {
        test: require.resolve('candy-shop/notifyme/candy.js'),
        use: [
          {
            loader: 'imports-loader',
            options: {
              imports: ['default jquery jQuery', 'named candy Candy'],
            },
          },
          {
            loader: 'exports-loader',
            options: {
              exports: ['default CandyShop.NotifyMe'],
            },
          },
        ],
      },
      {
        test: require.resolve('candy-shop/namecomplete/candy.js'),
        use: [
          {
            loader: 'imports-loader',
            options: {
              imports: ['default jquery jQuery', 'named candy Candy'],
            },
          },
          {
            loader: 'exports-loader',
            options: {
              exports: ['default CandyShop.NameComplete'],
            },
          },
        ],
      },
      {
        test: require.resolve('candy-shop/modify-role/candy.js'),
        use: [
          {
            loader: 'imports-loader',
            options: {
              imports: ['default jquery jQuery', 'named candy Candy'],
            },
          },
          {
            loader: 'exports-loader',
            options: {
              exports: ['default CandyShop.ModifyRole'],
            },
          },
        ],
      },
      {
        test: require.resolve('candy-shop/me-does/candy.js'),
        use: [
          {
            loader: 'imports-loader',
            options: {
              imports: ['default jquery jQuery', 'named candy Candy'],
            },
          },
          {
            loader: 'exports-loader',
            options: {
              exports: ['default CandyShop.MeDoes'],
            },
          },
        ],
      },
      {
        test: require.resolve('candy-shop/notifications/candy.js'),
        use: [
          {
            loader: 'imports-loader',
            options: {
              imports: ['default jquery jQuery', 'named candy Candy'],
            },
          },
          {
            loader: 'exports-loader',
            options: {
              exports: ['default CandyShop.Notifications'],
            },
          },
        ],
      },
      {
        test: require.resolve('candy-shop/refocus/candy.js'),
        use: [
          {
            loader: 'imports-loader',
            options: {
              imports: ['default jquery jQuery', 'named candy Candy'],
            },
          },
          {
            loader: 'exports-loader',
            options: {
              exports: ['default CandyShop.Refocus'],
            },
          },
        ],
      },
    ],
  },
};
