import {clipboard} from 'electron';
import {Component, Injectable, Input} from '@angular/core';
import {AppsService} from '../apps.service';
import {App} from '../shared/app';

@Component({
  selector: 'network',
  templateUrl: 'network.component.html',
  styleUrls: ['network.component.css'],
})
@Injectable()
export class NetworkComponent {
  @Input()
  currentApp: App;

  constructor(public appsService: AppsService) {
    console.log('constructor');
  }

  copy(text: string) {
    clipboard.writeText(text);
  }
}
