import crypto from 'crypto';
import 'url-api-polyfill';

let sso;
const ssoString = new URL(window.location).searchParams.get('sso');

if (ssoString) {
  sso = new URLSearchParams(Buffer.from(ssoString, 'base64').toString());
}

const callback = new URL(window.location).searchParams.get('callback');

const parseObjectPath = (obj, path, params) => {
  const cbPatterns = path.split('.');
  const first = cbPatterns[0];
  if (cbPatterns.length === 1) {
    return obj[first](...params);
  }
  return parseObjectPath(obj[first], cbPatterns.slice(1).join('.'), params);
}

export const handleSSO = (user, token) => {
  if (callback) {
    parseObjectPath(window, callback, [JSON.stringify({ ...user, token }), '']);
  }
  if (sso) {
    const params = new URLSearchParams();
    const url = new URL(sso.get('return_sso_url'));

    for (const [key, value] of Object.entries(user)) {
      params.set(key, value);
    }
    params.set('return_sso_url', sso.get('return_sso_url'));
    if (sso.get('nonce')) {
      params.set('nonce', sso.get('nonce'));
    }
    params.set('external_id', user.id);
    params.set('avatar_url', user.avatar);
    params.set('avatar_force_update', 'true');
    if (!user.active) {
      params.set('require_activation', 'true');
    }
    if (token) {
      params.set('token', token);
    }

    const payload = Buffer.from(params.toString()).toString('base64');    
    
    url.searchParams.set('sso', payload);
    url.searchParams.set('sig', crypto.createHmac('sha256', 'zsZv6LXHDwwtUAGa').update(payload).digest('hex'));

    window.location.href = url;
    return true;
  }
  return false;
};
