import fetch from 'dva/fetch';
import config from '../config';

function parseJSON(response) {
  return response.json();
}

async function checkStatus(response) {
  if (response.status >= 200 && response.status < 300) {
    return response;
  }

  let message;
  try {
    message = (await response.json()).message;
  } catch (error) {
    message = response.statusText;
  }

  const error = new Error(message);
  error.response = response;
  throw error;
}

let vaptchaObj = null;
function refreshVaptchaObject() {
  vaptcha({
    vid: '668bf0efd3784602950e94a8',
    type: 'invisible',
    scene: 0,
    area: 'auto',
  }).then((v) => {
    vaptchaObj = v;
  });
}

refreshVaptchaObject();

/**
 * Requests a URL, returning a promise.
 *
 * @param  {string} url       The URL we want to request
 * @param  {object} [options] The options we want to pass to "fetch"
 * @return {object}           An object containing either "data" or "err"
 */
export default function request(relativeUrl, options) {
  if (options.vaptcha) {
    return new Promise((resolve, reject) => {
      vaptchaObj.listen('pass', () => {
        options.vaptcha = undefined;
        const token = vaptchaObj.getServerToken();
        console.log('vaptcha pass', token.server, token.token);
        options.headers = {
          ...options.headers || { 'content-type': 'application/json' },
          'x-vaptcha-server': token.server,
          'x-vaptcha-token': token.token,
        };
        request(relativeUrl, options).then(resolve).catch(reject);
        refreshVaptchaObject();
      });
      vaptchaObj.listen('close', () => { 
        console.log('vaptcha close');
        reject(new Error('vaptcha close'));
        refreshVaptchaObject();
      })
      vaptchaObj.validate();
    });
  }
  const url = `${config.apiRoot}${relativeUrl}`;
  if (options && !options.headers) {
    Object.assign(options, {
      headers: {
        'content-type': 'application/json',
      },
    });
  }
  console.log(options);
  return fetch(url, options)
    .then(checkStatus)
    .then(parseJSON)
    .then(data => ({ data }));
  // .catch(err => ({ err }));
};
