import { Button, Form, Input } from 'antd';
import React from 'react';
import { connect } from 'react-redux';
import SubmitButton from './SubmitButton';

const FormItem = Form.Item;
const formItemLayout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 15 },
};


class EmailForm extends React.Component {
  state = {
    countdown: 0,
    inCountdown: false, // Whether the countdown is active
  };
  componentDidMount() {
    const { dispatch } = this.props;
    dispatch({ type: 'auth/allowChangeUsername' });
  }
  onSubmit = (e) => {
    const { form, dispatch, user: { id } } = this.props;

    if (e) {
      e.preventDefault();
    }
    form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        console.log('Received values of form: ', values);
        const { username, password } = values;
        dispatch({ type: 'user/updateAccount', payload: { username, password, user_id: id } });
        this.setState({ countdown: 5, inCountdown: true });
        this.countdownTimer = setInterval(this.handleCountdown, 1000);
      }
    });
  };
  handleCountdown = () => {
    // 倒计时减1
    this.setState(prevState => ({ countdown: prevState.countdown - 1 }));
    if (this.state.countdown === 0) {
      // 清除倒计时
      clearInterval(this.countdownTimer);
      // 设置倒计时状态为false
      this.setState({ inCountdown: false });
      // 倒计时结束后调用退出
      this.handleLogout();
    }
  };
  handleLogout = () => {
    clearInterval(this.countdownTimer);
    window.localStorage.removeItem('token');
    if (window.ygopro) {
      window.ygopro.logoutUser('YGOMobile萌卡已登出');
    }
    const url = new URL(window.location.href);
    const redirect = url.searchParams.get('redirect') || '/';
    window.location.href = redirect;
  };

  handleLogoutNow = () => {
    this.setState({ countdown: 0 }, () => {
      this.handleLogout();
    });
  };
  checkPassword = (rule, value, callback) => {
    const { form, messages } = this.props;
    // const { intl: { messages } } = this.context;
    if (value && value !== form.getFieldValue('new_password')) {
      callback(messages['Incorrect-password.2']);
    } else {
      callback();
    }
  };

  checkConfirm = (rule, value, callback) => {
    const form = this.props.form;
    if (value) {
      form.validateFields(['confirm'], { force: true });
    }
    callback();
  };

  render() {
    const { form, dispatch, user, checkUsername, isUserNameExists, allowChangeUsername, messages } = this.props;
    const { getFieldDecorator } = form;
    const { id, username } = user;
    const logoutNowText = this.props.messages.LogoutNow;
    const loggingOutInText = this.props.messages.LoggingOutIn;
    const secondsText = this.props.messages.Seconds;
    const temporaryPromptText = this.props.messages.TemporaryPrompt;
    const ChangeSuccessText = this.props.messages.ChangeSuccess;
    const usernameProps = {
      fromItem: {
        label: messages.username,
        hasFeedback: true,
        validateStatus: checkUsername,
        extra: isUserNameExists ? messages.i_username_exists_or_invalid : '',
        ...formItemLayout,
      },
      decorator: {
        initialValue: username,
      },
      input: {
        placeholder: messages.username,
        onBlur: () => dispatch({ type: 'auth/checkUsername', payload: { ...form.getFieldsValue(), user_id: id } }),
      },
    };

    const passwordProps = {
      fromItem: {
        label: messages.password,
        ...formItemLayout,
      },
      decorator: {
        rules: [
          {
            required: true,
            message: messages['Password-length-must-be-between-8-and-24-characters.'],
            pattern: /^.{8,24}$/,
          },
        ],
      },
      input: {
        placeholder: messages.password,
        type: 'password',
      },
    };
    const { inCountdown, countdown } = this.state;
    return (
      <div>
        {inCountdown ? (
          <div style={{ display: 'flex', flexDirection: 'column', alignItems: 'center', height: '100vh' }}>
            <div style={{ flex: 9 / 10, textAlign: 'center' }}>
              <h3>{ChangeSuccessText}</h3>
              <h3>
                {loggingOutInText}
                <span style={{ color: '#4da9ee', fontSize: '2em' }}>&nbsp;{`${countdown}`}</span>
                <span>&nbsp;{secondsText}</span>
              </h3>
              <br/>
              <Button type="link" onClick={this.handleLogoutNow}>
                {logoutNowText}
              </Button>
            </div>
          </div>
        ) : (
          <Form onSubmit={this.onSubmit}>
            <FormItem {...usernameProps.fromItem}>
              {getFieldDecorator('username', { ...usernameProps.decorator })(
                <Input {...usernameProps.input} disabled={!allowChangeUsername} />,
              )}
              {
                <div className="alert alert-warning" role="alert">{temporaryPromptText}</div>
              }

            </FormItem>

            <FormItem {...passwordProps.fromItem}>
              {getFieldDecorator('password', { ...passwordProps.decorator })(
                <Input {...passwordProps.input} />,
              )}
            </FormItem>

            <FormItem>
              <SubmitButton/>
            </FormItem>
          </Form>
        )}
      </div>
    );
  }
}

function mapStateToProps(state) {
  const {
    user: { user },
    auth: { isUserNameExists, checkUsername, allowChangeUsername },
    common: { messages },
  } = state;
  return {
    user,
    messages,
    checkUsername,
    isUserNameExists,
    allowChangeUsername,
  };
}

const WrapperEmailForm = Form.create()(EmailForm);

export default connect(mapStateToProps)(WrapperEmailForm);
