import { Form, Input, Button } from 'antd';
import React from 'react';
import { connect } from 'react-redux';
import SubmitButton from './SubmitButton';

const FormItem = Form.Item;

const formItemLayout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 15 },
};


class EmailForm extends React.Component {
  state = {
    countdown: 0,
    inCountdown: false, // 是否处于倒计时状态
  };
  onSubmit = (e) => {
    const { form, dispatch, user: { id } } = this.props;

    if (e) {
      e.preventDefault();
    }
    form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        console.log('Received values of form: ', values);

        const { new_password, password } = values;

        dispatch({ type: 'user/updateAccount', payload: { new_password, password, user_id: id } });

        // 设置倒计时状态为5秒
        this.setState({ countdown: 5, inCountdown: true });
        // 启动倒计时
        this.countdownTimer = setInterval(this.handleCountdown, 1000);
      }
    });
  };
  handleCountdown = () => {
    // 倒计时减1
    this.setState(prevState => ({ countdown: prevState.countdown - 1 }));
    if (this.state.countdown === 0) {
      // 清除倒计时
      clearInterval(this.countdownTimer);
      // 设置倒计时状态为false
      this.setState({ inCountdown: false });
      // 倒计时结束后调用退出
      this.handleLogout();
    }
  };
  handleLogout = () => {
    clearInterval(this.countdownTimer);
    window.localStorage.removeItem('token');
    if (window.ygopro) {
      window.ygopro.logoutUser('YGOMobile萌卡已登出');
    }
    const url = new URL(window.location.href);
    const redirect = url.searchParams.get('redirect') || '/';
    window.location.href = redirect;
  };

  handleLogoutNow = () => {
    this.setState({ countdown: 0 }, () => {
      this.handleLogout();
    });
  };


  checkPassword = (rule, value, callback) => {
    const { form, messages } = this.props;
    // const { intl: { messages } } = this.context;
    if (value && value !== form.getFieldValue('new_password')) {
      callback(messages['Incorrect-password.2']);
    } else {
      callback();
    }
  };

  checkConfirm = (rule, value, callback) => {
    const form = this.props.form;
    if (value) {
      form.validateFields(['confirm'], { force: true });
    }
    callback();
  };


  render() {
    const { form, messages } = this.props;
    const { getFieldDecorator } = form;
    const logoutNowText = this.props.messages.LogoutNow;
    const loggingOutInText = this.props.messages.LoggingOutIn;
    const secondsText = this.props.messages.Seconds;
    const ChangeSuccessText = this.props.messages.ChangeSuccess;
    const passwordProps = {
      fromItem: {
        label: messages['old-password'],
        ...formItemLayout,
      },
      decorator: {
        rules: [
          {
            required: true,
            message: messages['Password-length-must-be-between-8-and-24-characters.'],
            pattern: /^.{8,24}$/,
          },
          { validator: this.checkConfirm },
        ],
      },
      input: {
        placeholder: messages['old-password'],
        type: 'password',
      },
      input2: {
        placeholder: messages['new-password'],
        type: 'password',
      },
    };

    const confirmProps = {
      fromItem: {
        label: messages['password-again'],
        ...formItemLayout,
      },
      decorator: {
        rules: [
          {
            required: true,
            message: messages['Password-length-must-be-between-8-and-24-characters.'],
            pattern: /^.{8,24}$/,
          },
          { validator: this.checkPassword },
        ],
      },
      input: {
        placeholder: messages['password-again'],
        type: 'password',
      },
    };
    const { inCountdown, countdown } = this.state;
    return (
      <div>
        {inCountdown ? (
          <div style={{ display: 'flex', flexDirection: 'column', alignItems: 'center', height: '100vh' }}>
            <div style={{ flex: 9 / 10, textAlign: 'center' }}>
              <h3>{ChangeSuccessText}</h3>
              <h3>
                {loggingOutInText}
                <span style={{ color: '#4da9ee', fontSize: '2em' }}>&nbsp;{`${countdown}`}</span>
                <span>&nbsp;{secondsText}</span>
              </h3>
              <br/>
              <Button type="link" onClick={this.handleLogoutNow}>
                {logoutNowText}
              </Button>
            </div>
          </div>
        ) : (
          <Form onSubmit={this.onSubmit}>
            <FormItem {...passwordProps.fromItem} label={messages['old-password']}>
              {getFieldDecorator('password')(
                <Input {...passwordProps.input} />,
              )}
            </FormItem>

            <FormItem {...passwordProps.fromItem} label={messages['new-password']}>
              {getFieldDecorator('new_password', { ...passwordProps.decorator })(
                <Input {...passwordProps.input2} />,
              )}
            </FormItem>

            <FormItem {...confirmProps.fromItem}>
              {getFieldDecorator('confirm', { ...confirmProps.decorator })(
                <Input {...confirmProps.input} />,
              )}
            </FormItem>

            <FormItem>
              <SubmitButton />
            </FormItem>
          </Form>
        )}
      </div>
    );
  }
}


function mapStateToProps(state) {
  const {
    user: { user },
    common: { messages },
  } = state;

  return {
    messages,
    user,
  };
}

const WrapperEmailForm = Form.create()(EmailForm);

export default connect(mapStateToProps)(WrapperEmailForm);

