/// <reference types="react-scripts" />
/// <reference types="vite/client" />
/// <reference types="eventemitter3" />

interface ImportMetaEnv {
  readonly VITE_IS_AI_MODE: boolean;
  readonly VITE_IS_AI_FIRST: boolean;
  readonly VITE_AI_MODE_DEFAULT_DECK: string;
}

interface ImportMeta {
  readonly env: ImportMetaEnv;
}

/* eslint @typescript-eslint/no-unused-vars: 0 */
import type { MessageInstance } from "antd/es/message/interface";
import type { ModalStaticFunctions } from "antd/es/modal/confirm";
import type { NotificationInstance } from "antd/es/notification/interface";
import { EventEmitter } from "eventemitter3";

declare global {
  var myExtraDeckCodes: number[] = [];
  interface Console {
    color: (
      color: string,
      backgroundColor?: string,
    ) => (...args: Parameters<console.log>) => void;
  }
  var message: MessageInstance;
  var notification: NotificationInstance;
  var modal: ModalStaticFunctions;
}

declare module "react-router-dom" {
  export declare function useLoaderData<T>(): T;
}
