import { Button } from "antd";
import { useSnapshot } from "valtio";

import { CardType, matStore } from "@/stores";
import { Footer, genModal, ReactFcWithOnResult, Title } from "@/ui/Shared";
import { CardMeta, type ygopro } from "@/api";

interface Props {
  min: number;
  max: number;
  single: boolean;
  selecteds: Option[]; // 已经选择了的卡
  selectables: Option[]; // 最多选择多少卡
  mustSelects: Option[]; // 单选
  cancelable: boolean; // 能否取消
  finishable: boolean; // 选择足够了之后，能否确认
  totalLevels: number; // 需要的总等级数（用于同调/仪式/...）
  overflow: boolean; // 选择等级时候，是否可以溢出
}

interface Result {
  result: Option[];
}

export interface Option {
  // card id
  meta: CardMeta;
  location?: ygopro.CardLocation;
  // 效果
  effectDesc?: string;
  // 作为素材的cost，比如同调召唤的星级
  level1?: number;
  level2?: number;
  response?: number;
  // 便于直接返回这个信息
  card?: CardType;
}

const Content: ReactFcWithOnResult<Props, Result> = ({
  min,
  max,
  single,
  selecteds,
  selectables,
  mustSelects,
  cancelable,
  finishable,
  totalLevels,
  overflow,
  onResult,
}) => {
  const { hint } = useSnapshot(matStore);
  const preHintMsg = hint?.esHint ?? "";
  return <></>;
};

const showSelectCardsModal = genModal({ Content });
