import { useConfig } from "@/config";
import sqliteMiddleWare, { sqliteCmd } from "@/middleware/sqlite";
import { initStore } from "@/stores";

const { cardsDbUrl } = useConfig();

export const initSqlite = async () => {
  const { sqlite } = initStore;
  sqlite.progress = 0.01;
  await sqliteMiddleWare({
    cmd: sqliteCmd.INIT,
    initInfo: { dbUrl: cardsDbUrl },
  });
  sqlite.progress = 1;
};
