export * from "./I18NContext";
export * from "./I18NSelector";

import i18next from "i18next";
import { initReactI18next } from "react-i18next";

/* Import all translation files */
import translationBrazilian from "./Source/Brazilian/translation.json";
import translationChinese from "./Source/Chinese/translation.json";
import translationEnglish from "./Source/English/translation.json";
import translationFrench from "./Source/French/translation.json";
import translationJapanese from "./Source/Japanese/translation.json";
import translationPortuguese from "./Source/Portuguese/translation.json";
import translationSpanish from "./Source/Spanish/translation.json";

const resources = {
  cn: {
    Header: translationChinese.Header,
    Start: translationChinese.Start,
    Match: translationChinese.Match,
    BuildDeck: translationChinese.BuildDeck,
    Filter: translationChinese.Filter,
    CardDetails: translationChinese.CardDetails,
    WaitRoom: translationChinese.WaitRoom,
    CustomRoomContent: translationChinese.CustomRoomContent,
    WatchContent: translationChinese.WatchContent,
    DeckSelect: translationChinese.DeckSelect,
    Chat: translationChinese.Chat,
    MatchModal: translationChinese.MatchModal,
    ReplayModal: translationChinese.ReplayModal,
    Popover: translationChinese.Popover,
    Menu: translationChinese.Menu,
    SelectCardModal: translationChinese.SelectCardModal,
    SystemSettings: translationChinese.SystemSettings,
    DeckResults: translationChinese.DeckResults,
  },
  en: {
    Header: translationEnglish.Header,
    Start: translationEnglish.Start,
    Match: translationEnglish.Match,
    BuildDeck: translationEnglish.BuildDeck,
    Filter: translationEnglish.Filter,
    CardDetails: translationEnglish.CardDetails,
    WaitRoom: translationEnglish.WaitRoom,
    CustomRoomContent: translationEnglish.CustomRoomContent,
    WatchContent: translationEnglish.WatchContent,
    DeckSelect: translationEnglish.DeckSelect,
    Chat: translationEnglish.Chat,
    MatchModal: translationEnglish.MatchModal,
    ReplayModal: translationEnglish.ReplayModal,
    Popover: translationEnglish.Popover,
    Menu: translationEnglish.Menu,
    SelectCardModal: translationEnglish.SelectCardModal,
    SystemSettings: translationEnglish.SystemSettings,
    DeckResults: translationEnglish.DeckResults,
  },
  es: {
    Header: translationSpanish.Header,
    Start: translationSpanish.Start,
    Match: translationSpanish.Match,
    BuildDeck: translationSpanish.BuildDeck,
    Filter: translationSpanish.Filter,
    CardDetails: translationSpanish.CardDetails,
    WaitRoom: translationSpanish.WaitRoom,
    CustomRoomContent: translationSpanish.CustomRoomContent,
    WatchContent: translationSpanish.WatchContent,
    DeckSelect: translationSpanish.DeckSelect,
    Chat: translationSpanish.Chat,
    MatchModal: translationSpanish.MatchModal,
    ReplayModal: translationSpanish.ReplayModal,
    Popover: translationSpanish.Popover,
    Menu: translationSpanish.Menu,
    SelectCardModal: translationSpanish.SelectCardModal,
    SystemSettings: translationSpanish.SystemSettings,
    DeckResults: translationSpanish.DeckResults,
  },
  fr: {
    Header: translationFrench.Header,
    Start: translationFrench.Start,
    Match: translationFrench.Match,
    BuildDeck: translationFrench.BuildDeck,
    Filter: translationFrench.Filter,
    CardDetails: translationFrench.CardDetails,
    WaitRoom: translationFrench.WaitRoom,
    CustomRoomContent: translationFrench.CustomRoomContent,
    WatchContent: translationFrench.WatchContent,
    DeckSelect: translationFrench.DeckSelect,
    Chat: translationFrench.Chat,
    MatchModal: translationFrench.MatchModal,
    ReplayModal: translationFrench.ReplayModal,
    Popover: translationFrench.Popover,
    Menu: translationFrench.Menu,
    SelectCardModal: translationFrench.SelectCardModal,
    SystemSettings: translationFrench.SystemSettings,
    DeckResults: translationFrench.DeckResults,
  },
  ja: {
    Header: translationJapanese.Header,
    Start: translationJapanese.Start,
    Match: translationJapanese.Match,
    BuildDeck: translationJapanese.BuildDeck,
    Filter: translationJapanese.Filter,
    CardDetails: translationJapanese.CardDetails,
    WaitRoom: translationJapanese.WaitRoom,
    CustomRoomContent: translationJapanese.CustomRoomContent,
    WatchContent: translationJapanese.WatchContent,
    DeckSelect: translationJapanese.DeckSelect,
    Chat: translationJapanese.Chat,
    MatchModal: translationJapanese.MatchModal,
    ReplayModal: translationJapanese.ReplayModal,
    Popover: translationJapanese.Popover,
    Menu: translationJapanese.Menu,
    SelectCardModal: translationJapanese.SelectCardModal,
    SystemSettings: translationJapanese.SystemSettings,
    DeckResults: translationJapanese.DeckResults,
  },
  br: {
    Header: translationBrazilian.Header,
    Start: translationBrazilian.Start,
    Match: translationBrazilian.Match,
    BuildDeck: translationBrazilian.BuildDeck,
    Filter: translationBrazilian.Filter,
    CardDetails: translationBrazilian.CardDetails,
    WaitRoom: translationBrazilian.WaitRoom,
    CustomRoomContent: translationBrazilian.CustomRoomContent,
    WatchContent: translationBrazilian.WatchContent,
    DeckSelect: translationBrazilian.DeckSelect,
    Chat: translationBrazilian.Chat,
    MatchModal: translationBrazilian.MatchModal,
    ReplayModal: translationBrazilian.ReplayModal,
    Popover: translationBrazilian.Popover,
    Menu: translationBrazilian.Menu,
    SelectCardModal: translationBrazilian.SelectCardModal,
    SystemSettings: translationBrazilian.SystemSettings,
    DeckResults: translationBrazilian.DeckResults,
  },
  pt: {
    Header: translationPortuguese.Header,
    Start: translationPortuguese.Start,
    Match: translationPortuguese.Match,
    BuildDeck: translationPortuguese.BuildDeck,
    Filter: translationPortuguese.Filter,
    CardDetails: translationPortuguese.CardDetails,
    WaitRoom: translationPortuguese.WaitRoom,
    CustomRoomContent: translationPortuguese.CustomRoomContent,
    WatchContent: translationPortuguese.WatchContent,
    DeckSelect: translationPortuguese.DeckSelect,
    Chat: translationPortuguese.Chat,
    MatchModal: translationPortuguese.MatchModal,
    ReplayModal: translationPortuguese.ReplayModal,
    Popover: translationPortuguese.Popover,
    Menu: translationPortuguese.Menu,
    SelectCardModal: translationPortuguese.SelectCardModal,
    SystemSettings: translationPortuguese.SystemSettings,
    DeckResults: translationPortuguese.DeckResults,
  },
};

i18next.use(initReactI18next).init({
  resources,
  lng: localStorage.getItem("language") ?? "cn", //default language
});

export default i18next;
