export * from "./accountStore";
export * from "./cardStore";
export * from "./chatStore";
export * from "./matStore";
export * from "./placeStore";
export * from "./replayStore";
export * from "./roomStore";

import { devtools } from "valtio/utils";

import { accountStore } from "./accountStore";
import { cardStore } from "./cardStore";
import { chatStore } from "./chatStore";
import { matStore } from "./matStore";
import { placeStore } from "./placeStore";
import { replayStore } from "./replayStore";
import { roomStore } from "./roomStore";

devtools(chatStore, { name: "chat", enabled: true });
devtools(matStore, { name: "mat", enabled: true });
devtools(cardStore, { name: "card", enabled: true });
devtools(placeStore, { name: "place", enabled: true });
devtools(replayStore, { name: "replay", enabled: true });
devtools(accountStore, { name: "account", enabled: true });
devtools(roomStore, { name: "room", enabled: true });

// 重置所有`Store`
export const resetUniverse = () => {
  roomStore.reset();
  cardStore.reset();
  chatStore.reset();
  matStore.reset();
  placeStore.reset();
  replayStore.reset();
};
