﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindBot;
using WindBot.Game;
using WindBot.Game.AI;
using YGOSharp.OCGWrapper.Enums;

namespace WindBot.Game.AI.Decks
{
    [Deck("THC_DSReimu", "AI_THC_DSReimu")]
    class THC_DSReimuExecutor : DefaultExecutor
    {
        public class CardId
        {
            public const int 女神天子 = 74561020;
            public const int 天子翼 = 74561023;
            public const int 萨丽艾尔 = 74562017;
            public const int 暴风文 = 74561011;
            public const int 星态死士 = 14000267;
            public const int 美兔 = 82434;
            public const int 枫 = 82435;
            public const int 猎梦者 = 16000006;
            public const int 梦想天生 = 10020;
            public const int 光影 = 86379728;
            public const int 有顶天永续 = 14050018;
            public const int 有顶天场地 = 14050011;
            public const int 多面体 = 74563011;
            public const int 茧墨场地 = 16011501;
            public const int 灵符 = 10278;
            public const int 茧墨怪 = 16010003;

            public const int 幼女化 = 74561045;
            public const int 天狗L2 = 23504;
            public const int 叮当 = 17030980;
        }

        readonly int[] 叮当素材 = { CardId.幼女化, CardId.女神天子, CardId.天子翼, CardId.萨丽艾尔, 16019999};
        public THC_DSReimuExecutor(GameAI ai, Duel duel)
            : base(ai, duel)
        {
            AddExecutor(ExecutorType.Activate, CardId.梦想天生);
            AddExecutor(ExecutorType.SpSummon, CardId.幼女化, 守备特召);
            AddExecutor(ExecutorType.SpSummon, CardId.茧墨怪, () => NeedToFreeSZone());
            AddExecutor(ExecutorType.Activate, CardId.茧墨怪, () => NeedToFreeSZone());
            AddExecutor(ExecutorType.Summon, CardId.女神天子, 通召女神天子);
            AddExecutor(ExecutorType.Summon, CardId.萨丽艾尔,
                () => !AlreadySucceeded() && !HasNonTunerOnField() && HasSpSummonableDSTuner(Card));
            AddExecutor(ExecutorType.Summon, CardId.星态死士,
                () => (!AlreadySucceeded() && !HasDSTunerOnField() && HasSpSummonableNonTuner(Card)) || NeedToFreeSZone());
            AddExecutor(ExecutorType.Activate, CardId.星态死士, 星态死士检索);
            AddExecutor(ExecutorType.Activate, CardId.猎梦者, 星态死士等级提升);
            AddExecutor(ExecutorType.Activate, CardId.暴风文, 暴风文检索);
            AddExecutor(ExecutorType.Activate, CardId.女神天子, 女神天子等级提升);
            AddExecutor(ExecutorType.Activate, CardId.天子翼, 特召天子翼);
            AddExecutor(ExecutorType.SpSummon, CardId.美兔, 特召彩虹);
            AddExecutor(ExecutorType.SpSummon, CardId.枫, 特召彩虹);
            AddExecutor(ExecutorType.Activate, CardId.光影, 光影检索);
            AddExecutor(ExecutorType.SpSummon, CardId.天狗L2, 天狗L2特召);
            AddExecutor(ExecutorType.Activate, CardId.天狗L2, 天狗L2弹卡);
            AddExecutor(ExecutorType.Activate, CardId.茧墨场地, 茧墨特召);
            AddExecutor(ExecutorType.Activate, CardId.多面体,
                () => (Bot.GetSpellCountWithoutField() < 4 && Bot.LifePoints <= 4000) || (Bot.GetSpellCountWithoutField() < 3));
            AddExecutor(ExecutorType.Activate, CardId.有顶天永续, 有顶天永续抽卡);
            AddExecutor(ExecutorType.Activate, CardId.有顶天场地,
                () => !(AlreadySucceeded() && Bot.HasInHand(CardId.梦想天生)));
            AddExecutor(ExecutorType.Activate, CardId.灵符);
            AddExecutor(ExecutorType.SpSummon, CardId.叮当, 叮当特召);


        }
        private bool JMUsed = false;
        public override void OnNewTurn()
        {
            JMUsed = false;
            base.OnNewTurn();
        }
        public override bool OnSelectHand()
        {
            // go first
            return true;
        }
        public override CardPosition OnSelectPosition(int cardId, IList<CardPosition> positions)
        {
            if (cardId == CardId.萨丽艾尔 && positions.Contains(CardPosition.FaceUpAttack))
            {
                return CardPosition.FaceUpAttack;
            }
            return base.OnSelectPosition(cardId, positions);
        }
        public override IList<ClientCard> OnSelectCard(IList<ClientCard> cards, int min, int max, int hint, bool cancelable)
        {
            if (hint == HintMsg.Discard)
            {
                var g = cards.GetMatchingCards((c) => !c.IsCode(CardId.梦想天生));
                if (g == null)
                {
                    return null;
                }
                if (g.Count < min)
                {
                    return null;
                }
                else
                {
                    return g.Take(min).ToList();
                }
            }
            return null;
        }
        private bool 通召女神天子()
        {
            if (ActivateDescription != Util.GetStringId(CardId.女神天子, 2))
            {
                return false;
            }
            return (!HasDSTunerOnField() && HasSpSummonableNonTuner(Card)) || NeedToFreeSZone();
        }
        private bool 女神天子等级提升()
        {
            AI.SelectCard(CardId.暴风文);
            return true;
        }
        private bool 星态死士检索()
        {
            AI.SelectCard(CardId.猎梦者);
            return true;
        }
        private bool 星态死士等级提升()
        {
            AI.SelectCard(CardId.星态死士);
            return true;
        }
        private bool 暴风文检索()
        {
            if (AlreadySucceeded() || ActivateDescription == Util.GetStringId(CardId.暴风文,0))
            {
                return false;
            }
            if (HasSpSummonableNonTuner(Card) && Bot.Hand.IsExistingMatchingCard((ClientCard c) => c.IsCode(CardId.星态死士) && c.Level == 4))
            {
                AI.SelectCard(CardId.猎梦者);
                return true;
            }
            AI.SelectCard(CardId.天子翼, CardId.女神天子);
            return true;
        }
        private bool 特召天子翼()
        {
            if (NeedToFreeSZone() && !HasDSTunerOnField())
            {
                return true;
            }
            if (HasDSTunerOnField())
            {
                return false;
            }
            if (!HasSpSummonableNonTuner(null))
            {
                if (HasNonTunerOnField())
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            else
            {
                return true;
            }
        }
        private bool 特召彩虹()
        {
            if (AlreadySucceeded() || HasNonTunerOnField())
            {
                return false;
            }
            if (HasDSTunerOnField())
            {
                var tc = Bot.GetMonsters().GetFirstMatchingFaceupCard((ClientCard c) => c.IsTuner() && c.HasSetcode(0x6208) && c.Level == 12);
                if (tc != null)
                {
                    AI.SelectCard(tc);
                    return true;
                }
                else
                {
                    return false;
                }
            }
            return false;
        }
        private bool 光影检索()
        {
            if (AlreadySucceeded())
            {
                return false;
            }
            if (HasSpSummonableDSTuner(Card) && !HasSpSummonableNonTuner(Card) && !HasSummonableNonTuner(Card) && Bot.GetMonsterCount() == 0)
            {
                AI.SelectCard(CardId.萨丽艾尔);
                return true;
            }
            if ((HasSummonableNonTuner(Card) || HasNonTunerOnField()) && !HasSpSummonableDSTuner(Card))
            {
                AI.SelectCard(CardId.天子翼);
                return true;
            }
            if (HasSpSummonableNonTuner(Card) && !HasSpSummonableDSTuner(Card) && !HasSummonableDSTuner(Card))
            {
                AI.SelectCard(CardId.天子翼, CardId.女神天子);
                return true;
            }
            return false;
        }
        private bool 茧墨特召()
        {
            
            if (ActivateDescription == Util.GetStringId(CardId.茧墨场地, 1))
            {
                return false;
            }
            if (AlreadySucceeded())
            {
                AI.SelectCard(CardId.萨丽艾尔, CardId.天子翼);
                return true;
            }
            if (Card.Location == CardLocation.Hand &&
                !(Bot.GetFieldSpellCard() != null && Bot.GetFieldSpellCard().IsCode(CardId.茧墨场地) && !Bot.GetFieldSpellCard().IsDisabled() && !JMUsed) ||
                NeedToFreeSZone())
            {
                JMUsed = false;
                return true;
            }
            if (Card.Location == CardLocation.FieldZone && NeedToFreeSZone())
            {
                JMUsed = true;
                AI.SelectCard(CardId.萨丽艾尔, CardId.天子翼);
                return true;
            }
            if (HasSpSummonableDSTuner(Card) || HasSummonableDSTuner(Card) || HasDSTunerOnField())
            {
                JMUsed = true;
                AI.SelectCard(CardId.萨丽艾尔);
                return true;
            }
            if (HasSpSummonableNonTuner(Card) || HasNonTunerOnField())
            {
                JMUsed = true;
                AI.SelectCard(CardId.天子翼);
                return true;
            }
            return false;
        }
        private bool 守备特召()
        {
            if (Bot.HasInMonstersZone(CardId.叮当))
            {
                return false;
            }
            AI.SelectPosition(CardPosition.FaceUpDefence);
            return true;
        }
        private bool 天狗L2特召()
        {
            var material = Bot.GetMonstersInMainZone().GetMatchingCards((c) => !c.IsCode(CardId.幼女化));
            bool hasMaterial = material.Count >= 2;
            if (hasMaterial && NeedToFreeSZone())
            {
                AI.SelectMaterials(material);
                return true;
            }
            return false;
        }
        private bool 天狗L2弹卡()
        {
            if (!NeedToFreeSZone() || ActivateDescription != Util.GetStringId(CardId.天狗L2, 1))
            {
                return false;
            }
            AI.SelectCard(Bot.GetSpells());
            return true;
        }
        private bool 有顶天永续抽卡()
        {
            if (ActivateDescription == -1)
            {
                if (Bot.GetSpellCountWithoutField() < 4 && !(AlreadySucceeded() && Bot.HasInHand(CardId.梦想天生)))
                {
                    return true;
                }
                return false;
            }
            return true;            
        }
        private bool 叮当特召()
        {
            if (AlreadySucceeded() && Bot.HasInHand(CardId.梦想天生) || Duel.Turn == 1)
            {
                return false;
            }
            var material = Bot.GetMonsters().GetMatchingCards((c) => 叮当素材.Contains(c.Id));
            var matCount = material.Count - Enemy.GetMonsterCount() * 2;
            if (matCount > 1)
            {
                var ddCount = matCount / 2;
                var attackCards = Enemy.GetMonsters().GetMatchingCards((c) => c.IsAttack());
                List<ClientCard> targets = new List<ClientCard>();
                int totalDamage = 0;
                while (targets.Count < ddCount && attackCards.Count > 0)
                {
                    var card = attackCards.GetLowestAttackMonster();
                    targets.Add(card);
                    attackCards.Remove(card);
                    totalDamage += 7200 - card.Attack;
                }
                totalDamage += 7200 * (ddCount - targets.Count);
                if (totalDamage >= Enemy.LifePoints || totalDamage > 5000)
                {
                    AI.SelectMaterials(叮当素材);
                    return true;
                }
            }
            return false;
        }
        
        private bool HasSpSummonableNonTuner(ClientCard ex)
        {
            return Bot.Hand.IsExistingMatchingCard((ClientCard c) => c.IsCode(CardId.美兔, CardId.枫, CardId.茧墨场地) && !ReferenceEquals(c,ex));
        }
        private bool HasSpSummonableDSTuner(ClientCard ex)
        {
            return Bot.Hand.IsExistingMatchingCard((ClientCard c) => c.IsCode(CardId.天子翼, CardId.光影, CardId.茧墨场地, CardId.暴风文) && !ReferenceEquals(c, ex));
        }
        private bool HasSummonableNonTuner(ClientCard ex)
        {
            return Bot.Hand.IsExistingMatchingCard((ClientCard c) => c.IsCode(CardId.光影, CardId.萨丽艾尔) && !ReferenceEquals(c, ex));
        }
        private bool HasSummonableDSTuner(ClientCard ex)
        {
            return Bot.Hand.IsExistingMatchingCard((ClientCard c) => c.IsCode(CardId.暴风文, CardId.光影, CardId.女神天子) && !ReferenceEquals(c, ex));
        }
        private bool HasNonTunerOnField()
        {
            return Bot.GetMonsters().IsExistingMatchingCard((ClientCard c) => !c.IsTuner());
        }
        private bool HasDSTunerOnField()
        {
            return Bot.GetMonsters().IsExistingMatchingCard((ClientCard c) => c.IsTuner() && c.HasSetcode(0x6208) && c.Level == 12);
        }
        private bool AlreadySucceeded()
        {
            return Bot.HasInMonstersZone(CardId.幼女化, true, false, true) || (HasNonTunerOnField() && HasDSTunerOnField());
        }
        private bool NeedToFreeSZone()
        {
            return AlreadySucceeded() && Bot.HasInHand(CardId.梦想天生) && Bot.GetSpellCountWithoutField() >= 5;
        }
    }
}
