import { Button, Popover, Space } from "antd";
import { useState } from "react";

import { eventEmitter, Task } from "@/infra";

import { IconFont } from "../Shared";

export enum Mora {
  Rock = "rock",
  Scissors = "scissors",
  Paper = "paper",
}

export enum Tp {
  First = 1,
  Second = 2,
}

export const MoraPopover: React.FC<React.PropsWithChildren> = ({
  children,
}) => {
  const [open, setOpen] = useState(false);

  // 需要在mora的service之中，emit一个事件，让这个组件监听到，然后打开popover
  eventEmitter.on(Task.Mora, () => {
    setOpen(true);
  });

  const onClick = (result: Mora) => {
    result; // 这里send猜拳的结果给服务器
    setOpen(false);
  };

  const map = {
    [Mora.Rock]: "石头",
    [Mora.Scissors]: "剪刀",
    [Mora.Paper]: "布",
  };

  return (
    <Popover
      overlayStyle={{ backdropFilter: "blur(10px)" }}
      content={
        <Space>
          {[Mora.Rock, Mora.Scissors, Mora.Paper].map((mora) => (
            <Button
              key={mora}
              size="large"
              type="text"
              icon={<IconFont type={`icon-hand-${mora}`} size={16} />}
              onClick={() => onClick(mora)}
            >
              {map[mora]}
            </Button>
          ))}
        </Space>
      }
      open={open}
      placement="bottom"
    >
      {children}
    </Popover>
  );
};

export const TpPopover: React.FC<React.PropsWithChildren> = ({ children }) => {
  const [open, setOpen] = useState(false);

  // 需要在mora的service之中，emit一个事件，让这个组件监听到，然后打开popover
  eventEmitter.on(Task.Tp, () => {
    setOpen(true);
  });

  const onClick = (result: Tp) => {
    result; // 这里send结果给服务器
    setOpen(false);
  };

  const map = {
    [Tp.First]: "先手",
    [Tp.Second]: "后手",
  };

  return (
    <Popover
      overlayStyle={{ backdropFilter: "blur(10px)" }}
      content={
        <Space>
          {[Tp.First, Tp.Second].map((item) => (
            <Button
              key={item}
              size="large"
              type="text"
              icon={
                <IconFont
                  type={`icon-${item === Tp.First ? "one" : "two"}`}
                  size={16}
                />
              }
              onClick={() => onClick(item)}
            >
              {map[item]}
            </Button>
          ))}
        </Space>
      }
      open={open}
      placement="bottom"
    >
      {children}
    </Popover>
  );
};
