import { ygopro } from "@/api";
import { roomStore } from "@/stores";
import SelfType = ygopro.StocTypeChange.SelfType;

export default function handleTypeChange(pb: ygopro.YgoStocMsg) {
  const selfType = pb.stoc_type_change.self_type;
  const assertHost = pb.stoc_type_change.is_host;

  roomStore.isHost = assertHost;
  roomStore.selfType = selfType;

  if (assertHost) {
    switch (selfType) {
      case SelfType.UNKNOWN:
      case SelfType.OBSERVER: {
        console.warn("<HandleTypeChange>selfType is UNKNOWN or OBSERVER");
        break;
      }
      default: {
        const player = roomStore.players[selfType - 1];
        const state = ygopro.StocHsPlayerChange.State.NO_READY;
        if (player) {
          player.state = state;
        } else {
          roomStore.players.push({ name: "?", state });
        }
        break;
      }
    }
  }
}
