import { createBrowserRouter, RouterProvider } from "react-router-dom";

import { AudioActionType, changeScene } from "@/plugins/audio";

import { Component, loader } from "./Layout";

const router = createBrowserRouter([
  {
    path: "/",
    Component,
    loader,
    children: [
      {
        path: "/",
        loader: async () => {
          changeScene(AudioActionType.BGM_MENU);
          return null;
        },
        lazy: () => import("./Start"),
      },
      {
        path: "/match/*",
        loader: async () => {
          changeScene(AudioActionType.BGM_MENU);
          return null;
        },
        lazy: () => import("./Match"),
      },
      {
        path: "/build",
        loader: async () => {
          changeScene(AudioActionType.BGM_DECK);
          return null;
        },
        lazy: () => import("./BuildDeck"),
      },
      {
        path: "/waitroom",
        loader: async () => {
          changeScene(AudioActionType.BGM_MENU);
          return null;
        },
        lazy: () => import("./WaitRoom"),
      },
      {
        path: "/duel",
        loader: async () => {
          changeScene(AudioActionType.BGM_DUEL);
          return null;
        },
        lazy: () => import("./Duel/Main"),
      },
      {
        path: "/side",
        loader: async () => {
          changeScene(AudioActionType.BGM_DECK);
          return null;
        },
        lazy: () => import("./Side"),
      },
    ],
  },
]);

export const NeosRouter = () => <RouterProvider router={router} />;
