import { subscribe } from "valtio";

import { settingStore } from "@/stores/settingStore";

import { audioContextManger } from "../core/manager";
import { AudioActionType } from "../type";

// 监听设置改动
subscribe(settingStore.audio, () => {
  if (audioContextManger.enableBGM && !settingStore.audio.enableMusic) {
    console.log("disable");
    audioContextManger.disableMusic();
  }
  if (!audioContextManger.enableBGM && settingStore.audio.enableMusic) {
    console.log("enable");
    audioContextManger.enableMusic();
  }

  audioContextManger.updateMusicVolume(settingStore.audio.musicVolume);
});

// 切换场景
export function changeScene(scene: AudioActionType) {
  if (audioContextManger.scene !== scene) {
    audioContextManger.scene = scene;
  }
}

audioContextManger.updateMusicVolume(settingStore.audio.musicVolume);
audioContextManger.enableBGM = settingStore.audio.enableMusic ?? false;
