import Cookies from "cookies-ts";

const cookies = new Cookies();

export enum CookieKeys {
  USER = "user",
}

export const getCookie = <T>(key: CookieKeys) => {
  return cookies.get(key) as unknown as T | null;
};

export const setCookie = <T>(key: CookieKeys, value: T) => {
  cookies.set(key, value);
};
