/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import org.jivesoftware.smack.SmackInitialization;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.debugger.ReflectionDebuggerFactory;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.parsing.ExceptionThrowingCallback;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;

public final class SmackConfiguration {
    private static int defaultPacketReplyTimeout = 5000;
    private static int packetCollectorSize = 5000;
    private static List<String> defaultMechs = new ArrayList<String>();
    static Set<String> disabledSmackClasses = new HashSet<String>();
    static final List<XMPPInputOutputStream> compressionHandlers = new ArrayList<XMPPInputOutputStream>(2);
    static boolean smackInitialized = false;
    private static SmackDebuggerFactory debuggerFactory = new ReflectionDebuggerFactory();
    public static boolean DEBUG = false;
    private static ParsingExceptionCallback defaultCallback = new ExceptionThrowingCallback();
    private static HostnameVerifier defaultHostnameVerififer;

    public static String getVersion() {
        return SmackInitialization.SMACK_VERSION;
    }

    @Deprecated
    public static int getDefaultPacketReplyTimeout() {
        return SmackConfiguration.getDefaultReplyTimeout();
    }

    @Deprecated
    public static void setDefaultPacketReplyTimeout(int timeout) {
        SmackConfiguration.setDefaultReplyTimeout(timeout);
    }

    public static int getDefaultReplyTimeout() {
        if (defaultPacketReplyTimeout <= 0) {
            defaultPacketReplyTimeout = 5000;
        }
        return defaultPacketReplyTimeout;
    }

    public static void setDefaultReplyTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException();
        }
        defaultPacketReplyTimeout = timeout;
    }

    public static int getStanzaCollectorSize() {
        return packetCollectorSize;
    }

    public static void setStanzaCollectorSize(int collectorSize) {
        packetCollectorSize = collectorSize;
    }

    public static void addSaslMech(String mech) {
        if (!defaultMechs.contains(mech)) {
            defaultMechs.add(mech);
        }
    }

    public static void addSaslMechs(Collection<String> mechs) {
        for (String mech : mechs) {
            SmackConfiguration.addSaslMech(mech);
        }
    }

    public static void setDebuggerFactory(SmackDebuggerFactory debuggerFactory) {
        SmackConfiguration.debuggerFactory = debuggerFactory;
    }

    public static SmackDebuggerFactory getDebuggerFactory() {
        return debuggerFactory;
    }

    public static SmackDebugger createDebugger(XMPPConnection connection, Writer writer, Reader reader) {
        SmackDebuggerFactory factory = SmackConfiguration.getDebuggerFactory();
        if (factory == null) {
            return null;
        }
        return factory.create(connection, writer, reader);
    }

    public static void removeSaslMech(String mech) {
        defaultMechs.remove(mech);
    }

    public static void removeSaslMechs(Collection<String> mechs) {
        defaultMechs.removeAll(mechs);
    }

    public static List<String> getSaslMechs() {
        return Collections.unmodifiableList(defaultMechs);
    }

    public static void setDefaultParsingExceptionCallback(ParsingExceptionCallback callback) {
        defaultCallback = callback;
    }

    public static ParsingExceptionCallback getDefaultParsingExceptionCallback() {
        return defaultCallback;
    }

    public static void addCompressionHandler(XMPPInputOutputStream xmppInputOutputStream) {
        compressionHandlers.add(xmppInputOutputStream);
    }

    public static List<XMPPInputOutputStream> getCompresionHandlers() {
        ArrayList<XMPPInputOutputStream> res = new ArrayList<XMPPInputOutputStream>(compressionHandlers.size());
        for (XMPPInputOutputStream ios : compressionHandlers) {
            if (!ios.isSupported()) continue;
            res.add(ios);
        }
        return res;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier verifier) {
        defaultHostnameVerififer = verifier;
    }

    public static void addDisabledSmackClass(Class<?> clz) {
        SmackConfiguration.addDisabledSmackClass(clz.getName());
    }

    public static void addDisabledSmackClass(String className) {
        disabledSmackClasses.add(className);
    }

    public static void addDisabledSmackClasses(String ... classNames) {
        for (String className : classNames) {
            SmackConfiguration.addDisabledSmackClass(className);
        }
    }

    public static boolean isDisabledSmackClass(String className) {
        for (String disabledClassOrPackage : disabledSmackClasses) {
            if (disabledClassOrPackage.equals(className)) {
                return true;
            }
            int lastDotIndex = disabledClassOrPackage.lastIndexOf(46);
            if (disabledClassOrPackage.length() <= lastDotIndex || Character.isUpperCase(disabledClassOrPackage.charAt(lastDotIndex + 1)) || !className.startsWith(disabledClassOrPackage)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSmackInitialized() {
        return smackInitialized;
    }

    static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerififer;
    }
}

