/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.xml.splitter;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jxmpp.xml.splitter.XmlSplitter;
import org.jxmpp.xml.splitter.XmppElementCallback;

public class XmppXmlSplitter
extends XmlSplitter {
    private final XmppElementCallback xmppElementCallback;
    private final int maxElementSize;
    private String streamPrefix;

    public XmppXmlSplitter(XmppElementCallback xmppElementCallback) {
        this(10000, xmppElementCallback);
    }

    public XmppXmlSplitter(int maxElementSize, XmppElementCallback xmppElementCallback) {
        super(maxElementSize, xmppElementCallback);
        this.maxElementSize = maxElementSize;
        this.xmppElementCallback = xmppElementCallback;
    }

    @Override
    protected void onNextChar() throws IOException {
        if (this.getCurrentElementSize() >= this.maxElementSize) {
            throw new IOException("Max element size exceeded");
        }
    }

    @Override
    protected void onStartTag(String prefix, String localpart, Map<String, String> attributes) {
        if (!"stream".equals(localpart)) {
            return;
        }
        if ("http://etherx.jabber.org/streams".equals(attributes.get("xmlns:" + prefix))) {
            this.streamPrefix = prefix;
            this.newTopLevelElement();
            this.xmppElementCallback.streamOpened(prefix, Collections.unmodifiableMap(attributes));
        }
    }

    @Override
    protected void onEndTag(String qName) {
        if (this.streamPrefix == null || !qName.startsWith(this.streamPrefix)) {
            return;
        }
        if ((this.streamPrefix + ":stream").equals(qName)) {
            this.xmppElementCallback.streamClosed();
        }
    }
}

