/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

public class ItemsExtension
extends NodeExtension
implements EmbeddedPacketExtension {
    protected ItemsElementType type;
    protected Boolean notify;
    protected List<? extends ExtensionElement> items;

    public ItemsExtension(ItemsElementType itemsType, String nodeId, List<? extends ExtensionElement> items) {
        super(itemsType.getNodeElement(), nodeId);
        this.type = itemsType;
        this.items = items;
    }

    public ItemsExtension(String nodeId, List<? extends ExtensionElement> items, boolean notify) {
        super(ItemsElementType.retract.getNodeElement(), nodeId);
        this.type = ItemsElementType.retract;
        this.items = items;
        this.notify = notify;
    }

    public ItemsElementType getItemsElementType() {
        return this.type;
    }

    @Override
    public List<ExtensionElement> getExtensions() {
        return this.getItems();
    }

    public List<? extends ExtensionElement> getItems() {
        return this.items;
    }

    public boolean getNotify() {
        return this.notify;
    }

    @Override
    public CharSequence toXML() {
        if (this.items == null || this.items.size() == 0) {
            return super.toXML();
        }
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.getElementName());
        builder.append(" node='");
        builder.append(this.getNode());
        if (this.notify != null) {
            builder.append("' ");
            builder.append(this.type.getElementAttribute());
            builder.append("='");
            builder.append(this.notify.equals(Boolean.TRUE) ? 1 : 0);
            builder.append("'>");
        } else {
            builder.append("'>");
            for (ExtensionElement extensionElement : this.items) {
                builder.append(extensionElement.toXML());
            }
        }
        builder.append("</");
        builder.append(this.getElementName());
        builder.append('>');
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "Content [" + this.toXML() + "]";
    }

    public static enum ItemsElementType {
        items(PubSubElementType.ITEMS, "max_items"),
        retract(PubSubElementType.RETRACT, "notify");

        private final PubSubElementType elem;
        private final String att;

        private ItemsElementType(PubSubElementType nodeElement, String attribute) {
            this.elem = nodeElement;
            this.att = attribute;
        }

        public PubSubElementType getNodeElement() {
            return this.elem;
        }

        public String getElementAttribute() {
            return this.att;
        }
    }
}

