/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.dnssec;

import de.measite.minidns.MiniDNSException;
import de.measite.minidns.dnssec.UnverifiedReason;
import java.util.Collections;
import java.util.Set;

public class DNSSECResultNotAuthenticException
extends MiniDNSException {
    private static final long serialVersionUID = 1L;
    private final Set<UnverifiedReason> unverifiedReasons;

    private DNSSECResultNotAuthenticException(String message, Set<UnverifiedReason> unverifiedReasons) {
        super(message);
        if (unverifiedReasons.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.unverifiedReasons = Collections.unmodifiableSet(unverifiedReasons);
    }

    public static DNSSECResultNotAuthenticException from(Set<UnverifiedReason> unverifiedReasons) {
        StringBuilder sb = new StringBuilder();
        sb.append("DNSSEC result not authentic. Reasons: ");
        for (UnverifiedReason reason : unverifiedReasons) {
            sb.append(reason).append('.');
        }
        return new DNSSECResultNotAuthenticException(sb.toString(), unverifiedReasons);
    }

    public Set<UnverifiedReason> getUnverifiedReasons() {
        return this.unverifiedReasons;
    }
}

