/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpAddressUtil {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");

    public static boolean isIPv4LiteralAddress(String string) {
        Matcher matcher = IPV4_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int ipSegmentInt;
            String ipSegment = matcher.group(i);
            try {
                ipSegmentInt = Integer.valueOf(ipSegment);
            }
            catch (NumberFormatException e) {
                throw new AssertionError((Object)e);
            }
            if (ipSegmentInt <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean isIPv6LiteralAddress(String string) {
        String[] octets = string.split(":");
        return octets.length == 8;
    }

    public static boolean isIpAddress(String string) {
        return IpAddressUtil.isIPv4LiteralAddress(string) || IpAddressUtil.isIPv6LiteralAddress(string);
    }
}

