/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.xml.splitter;

import java.io.IOException;
import java.io.OutputStream;
import org.jxmpp.xml.splitter.XmppElementCallback;
import org.jxmpp.xml.splitter.XmppXmlSplitter;

public class Utf8ByteXmppXmlSplitter
extends OutputStream {
    private final XmppXmlSplitter xmppXmlSplitter;
    private final char[] writeBuffer = new char[2];
    private final byte[] buffer = new byte[6];
    private byte count;
    private byte expectedLength;

    public Utf8ByteXmppXmlSplitter(XmppElementCallback xmppElementCallback) {
        this.xmppXmlSplitter = new XmppXmlSplitter(xmppElementCallback);
    }

    public void write(byte b) throws IOException {
        this.buffer[this.count] = b;
        if (this.count == 0) {
            int firstByte = this.buffer[0] & 0xFF;
            if (firstByte < 128) {
                this.expectedLength = 1;
            } else if (firstByte < 224) {
                this.expectedLength = (byte)2;
            } else if (firstByte < 240) {
                this.expectedLength = (byte)3;
            } else if (firstByte < 248) {
                this.expectedLength = (byte)4;
            } else {
                throw new IOException("Invalid first UTF-8 byte: " + firstByte);
            }
        }
        if ((this.count = (byte)(this.count + 1)) == this.expectedLength) {
            int len;
            int codepoint;
            if (this.expectedLength == 1) {
                codepoint = this.buffer[0] & 0x7F;
            } else {
                switch (this.expectedLength) {
                    case 2: {
                        codepoint = this.buffer[0] & 0x1F;
                        codepoint <<= 6;
                        break;
                    }
                    case 3: {
                        codepoint = this.buffer[0] & 0xF;
                        codepoint <<= 12;
                        break;
                    }
                    case 4: {
                        codepoint = this.buffer[0] & 6;
                        codepoint <<= 18;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                for (int i = 1; i < this.expectedLength; ++i) {
                    int bits = this.buffer[i] & 0x3F;
                    codepoint |= (bits <<= 6 * (this.expectedLength - 1 - i));
                }
            }
            if (codepoint < 65536) {
                len = 1;
                this.writeBuffer[0] = (char)codepoint;
            } else {
                len = 2;
                this.writeBuffer[0] = (char)(55296 + (codepoint & 0xFFA00000));
                this.writeBuffer[1] = (char)(56320 + (codepoint & 0x3FF));
            }
            this.xmppXmlSplitter.write(this.writeBuffer, 0, len);
            this.count = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write((byte)(b & 0xFF));
    }
}

