/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns.dane;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ExpectingTrustManager
implements X509TrustManager {
    private CertificateException exception;
    private final X509TrustManager trustManager;

    public ExpectingTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager == null ? ExpectingTrustManager.getDefaultTrustManager() : trustManager;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public CertificateException getException() {
        CertificateException e = this.exception;
        this.exception = null;
        return e;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.exception = e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.exception = e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    private static X509TrustManager getDefaultTrustManager() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            for (TrustManager trustManager : tmf.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManager;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException("X.509 not supported.", e);
        }
        return null;
    }
}

