/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class Form {
    private DataForm dataForm;

    public static Form getFormFrom(Stanza packet) {
        DataForm dataForm = DataForm.from(packet);
        if (dataForm != null && dataForm.getReportedData() == null) {
            return new Form(dataForm);
        }
        return null;
    }

    public Form(DataForm dataForm) {
        this.dataForm = dataForm;
    }

    public Form(DataForm.Type type) {
        this.dataForm = new DataForm(type);
    }

    public void addField(FormField field) {
        this.dataForm.addField(field);
    }

    public void setAnswer(String variable, String value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        switch (field.getType()) {
            case text_multi: 
            case text_private: 
            case text_single: 
            case jid_single: 
            case hidden: {
                break;
            }
            default: {
                throw new IllegalArgumentException("This field is not of type String.");
            }
        }
        this.setAnswer(field, (Object)value);
    }

    public void setAnswer(String variable, int value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        Form.validateThatFieldIsText(field);
        this.setAnswer(field, (Object)value);
    }

    public void setAnswer(String variable, long value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        Form.validateThatFieldIsText(field);
        this.setAnswer(field, (Object)value);
    }

    public void setAnswer(String variable, float value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        Form.validateThatFieldIsText(field);
        this.setAnswer(field, Float.valueOf(value));
    }

    public void setAnswer(String variable, double value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        Form.validateThatFieldIsText(field);
        this.setAnswer(field, (Object)value);
    }

    private static void validateThatFieldIsText(FormField field) {
        switch (field.getType()) {
            case text_multi: 
            case text_private: 
            case text_single: {
                break;
            }
            default: {
                throw new IllegalArgumentException("This field is not of type text (multi, private or single).");
            }
        }
    }

    public void setAnswer(String variable, boolean value) {
        FormField field = this.getField(variable);
        if (field == null) {
            throw new IllegalArgumentException("Field not found for the specified variable name.");
        }
        if (field.getType() != FormField.Type.bool) {
            throw new IllegalArgumentException("This field is not of type boolean.");
        }
        this.setAnswer(field, (Object)(value ? "1" : "0"));
    }

    private void setAnswer(FormField field, Object value) {
        if (!this.isSubmitType()) {
            throw new IllegalStateException("Cannot set an answer if the form is not of type \"submit\"");
        }
        field.resetValues();
        field.addValue(value.toString());
    }

    public void setAnswer(String variable, List<String> values) {
        if (!this.isSubmitType()) {
            throw new IllegalStateException("Cannot set an answer if the form is not of type \"submit\"");
        }
        FormField field = this.getField(variable);
        if (field != null) {
            switch (field.getType()) {
                case text_multi: 
                case hidden: 
                case jid_multi: 
                case list_multi: 
                case list_single: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This field only accept list of values.");
                }
            }
        } else {
            throw new IllegalArgumentException("Couldn't find a field for the specified variable.");
        }
        field.resetValues();
        field.addValues(values);
    }

    public void setDefaultAnswer(String variable) {
        if (!this.isSubmitType()) {
            throw new IllegalStateException("Cannot set an answer if the form is not of type \"submit\"");
        }
        FormField field = this.getField(variable);
        if (field != null) {
            field.resetValues();
            for (String value : field.getValues()) {
                field.addValue(value);
            }
        } else {
            throw new IllegalArgumentException("Couldn't find a field for the specified variable.");
        }
    }

    public List<FormField> getFields() {
        return this.dataForm.getFields();
    }

    public FormField getField(String variable) {
        return this.dataForm.getField(variable);
    }

    public boolean hasField(String variable) {
        return this.dataForm.hasField(variable);
    }

    public String getInstructions() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = this.dataForm.getInstructions().iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getTitle() {
        return this.dataForm.getTitle();
    }

    public DataForm.Type getType() {
        return this.dataForm.getType();
    }

    public void setInstructions(String instructions) {
        ArrayList<String> instructionsList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(instructions, "\n");
        while (st.hasMoreTokens()) {
            instructionsList.add(st.nextToken());
        }
        this.dataForm.setInstructions(instructionsList);
    }

    public void setTitle(String title) {
        this.dataForm.setTitle(title);
    }

    public DataForm getDataFormToSend() {
        if (this.isSubmitType()) {
            DataForm dataFormToSend = new DataForm(this.getType());
            for (FormField field : this.getFields()) {
                if (field.getValues().isEmpty()) continue;
                dataFormToSend.addField(field);
            }
            return dataFormToSend;
        }
        return this.dataForm;
    }

    private boolean isFormType() {
        return DataForm.Type.form == this.dataForm.getType();
    }

    private boolean isSubmitType() {
        return DataForm.Type.submit == this.dataForm.getType();
    }

    public Form createAnswerForm() {
        if (!this.isFormType()) {
            throw new IllegalStateException("Only forms of type \"form\" could be answered");
        }
        Form form = new Form(DataForm.Type.submit);
        for (FormField field : this.getFields()) {
            if (field.getVariable() == null) continue;
            FormField newField = new FormField(field.getVariable());
            newField.setType(field.getType());
            form.addField(newField);
            if (field.getType() != FormField.Type.hidden) continue;
            ArrayList<String> values = new ArrayList<String>();
            for (String value : field.getValues()) {
                values.add(value);
            }
            form.setAnswer(field.getVariable(), values);
        }
        return form;
    }
}

