/* Generated by bsincgen, do not edit! */

static_assert(BSINC_SCALE_COUNT == 16, "Unexpected BSINC_SCALE_COUNT value!");
static_assert(BSINC_PHASE_COUNT == 16, "Unexpected BSINC_PHASE_COUNT value!");
static_assert(FRACTIONONE == 4096, "Unexpected FRACTIONONE value!");

typedef struct BSincTable {
    const float scaleBase, scaleRange;
    const int m[BSINC_SCALE_COUNT];
    const int filterOffset[BSINC_SCALE_COUNT];
    alignas(16) const float Tab[];
} BSincTable;

/* This 23rd order filter has a rejection of -60dB, yielding a transition width
 * of ~0.158 (normalized frequency). Order increases when downsampling to a
 * limit of one octave, after which the quality of the filter (transition
 * width) suffers to reduce the CPU cost. The bandlimiting will cut all sound
 * after downsampling by ~3.67 octaves.
 */
const BSincTable bsinc24 = {
    /* scaleBase */ 7.881281313e-02f, /* scaleRange */ 1.085555698e+00f,
    /* m */ { 48, 48, 48, 48, 48, 48, 48, 48, 44, 40, 36, 32, 28, 28, 24, 24 },
    /* filterOffset */ { 0, 3072, 6144, 9216, 12288, 15360, 18432, 21504, 24576, 27392, 29952, 32256, 34304, 36096, 37888, 39424 },

    /* Tab (40960 entries) */ {
        /*  0, 0 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -4.796439624e-04f, -7.229492121e-04f, -9.648886183e-04f, -1.152303939e-03f, -1.213307251e-03f, -1.059372565e-03f, -5.898051232e-04f, +3.014766656e-04f, +1.717195100e-03f, +3.746628758e-03f, +6.455051836e-03f, +9.873721368e-03f, +1.399149756e-02f, +1.874912662e-02f, +2.403703938e-02f, +2.969723410e-02f, +3.552944303e-02f, +4.130136645e-02f, +4.676233873e-02f, +5.165941558e-02f, +5.575458332e-02f, +5.884162493e-02f, +6.076115668e-02f, +6.141247912e-02f, +6.076115668e-02f, +5.884162493e-02f, +5.575458332e-02f, +5.165941558e-02f, +4.676233873e-02f, +4.130136645e-02f, +3.552944303e-02f, +2.969723410e-02f, +2.403703938e-02f, +1.874912662e-02f, +1.399149756e-02f, +9.873721368e-03f, +6.455051836e-03f, +3.746628758e-03f, +1.717195100e-03f, +3.014766656e-04f, -5.898051232e-04f, -1.059372565e-03f, -1.213307251e-03f, -1.152303939e-03f, -9.648886183e-04f, -7.229492121e-04f, -4.796439624e-04f, -2.694957250e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.436875469e-05f, +1.561612709e-05f, +1.417141484e-05f, +8.846225192e-06f, -1.492899882e-06f, -1.777981991e-05f, -4.059923501e-05f, -7.004937168e-05f, -1.056348136e-04f, -1.462059716e-04f, -1.899581021e-04f, -2.344972762e-04f, -2.769737986e-04f, -3.142760250e-04f, -3.432701935e-04f, -3.610656819e-04f, -3.652808343e-04f, -3.542827868e-04f, -3.273758978e-04f, -2.849174469e-04f, -2.283458597e-04f, -1.601151740e-04f, -8.353887009e-05f, -2.555508337e-06f, +7.856322346e-05f, +1.555353731e-04f, +2.243925418e-04f, +2.817745994e-04f, +3.251683254e-04f, +3.530689224e-04f, +3.650514058e-04f, +3.617481497e-04f, +3.447383033e-04f, +3.163633379e-04f, +2.794897176e-04f, +2.372439164e-04f, +1.927463657e-04f, +1.488693749e-04f, +1.080399453e-04f, +7.210228972e-05f, +4.224758644e-05f, +1.901092689e-05f, +2.328453823e-06f, -8.357927672e-06f, -1.396459906e-05f, -1.561691254e-05f, -1.450376051e-05f, -1.175075544e-05f,
        /*  0, 1 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -4.652752077e-04f, -7.073330850e-04f, -9.507172034e-04f, -1.143457714e-03f, -1.214800150e-03f, -1.077152385e-03f, -6.304043582e-04f, +2.314272939e-04f, +1.611560287e-03f, +3.600422786e-03f, +6.265093734e-03f, +9.639224092e-03f, +1.371452376e-02f, +1.843485059e-02f, +2.369376918e-02f, +2.933616842e-02f, +3.516416220e-02f, +4.094708366e-02f, +4.643496283e-02f, +5.137449813e-02f, +5.552623746e-02f, +5.868150975e-02f, +6.067761781e-02f, +6.140992362e-02f, +6.083971990e-02f, +5.899716030e-02f, +5.597897586e-02f, +5.194119018e-02f, +4.708750705e-02f, +4.165443537e-02f, +3.589449444e-02f, +3.005898225e-02f, +2.438177768e-02f, +1.906548995e-02f, +1.427098728e-02f, +1.011096528e-02f, +6.647798202e-03f, +3.895498133e-03f, +1.825235046e-03f, +3.735789553e-04f, -5.475575367e-04f, -1.040361638e-03f, -1.210978797e-03f, -1.160661867e-03f, -9.788532173e-04f, -7.385661247e-04f, -4.941477229e-04f, -2.812464804e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.422765568e-05f, +1.560484981e-05f, +1.436305556e-05f, +9.314872538e-06f, -6.806932534e-07f, -1.657438954e-05f, -3.897697936e-05f, -6.802063440e-05f, -1.032493727e-04f, -1.435551879e-04f, -1.871730634e-04f, -2.317426657e-04f, -2.744376758e-04f, -3.121561799e-04f, -3.417581727e-04f, -3.603299209e-04f, -3.654505292e-04f, -3.554341621e-04f, -3.295223672e-04f, -2.880048316e-04f, -2.322533521e-04f, -1.646621696e-04f, -8.849719227e-05f, -7.665992852e-06f, +7.357127629e-05f, +1.509236733e-04f, +2.203941213e-04f, +2.785767791e-04f, +3.228998788e-04f, +3.517925311e-04f, +3.647619571e-04f, +3.623768266e-04f, +3.461618466e-04f, +3.184173686e-04f, +2.819846545e-04f, +2.399818431e-04f, +1.955372004e-04f, +1.515448748e-04f, +1.104644002e-04f, +7.417918467e-05f, +4.392198589e-05f, +2.026779777e-05f, +3.187546744e-06f, -7.849719961e-06f, -1.374231680e-05f, -1.560691722e-05f, -1.463241434e-05f, -1.195157556e-05f,
        /*  0, 2 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -4.510475520e-04f, -6.917282352e-04f, -9.363541479e-04f, -1.134142841e-03f, -1.215480844e-03f, -1.093726775e-03f, -6.693813375e-04f, +1.634066595e-04f, +1.508310914e-03f, +3.456867598e-03f, +6.077920671e-03f, +9.407481427e-03f, +1.344008609e-02f, +1.812269441e-02f, +2.335201101e-02f, +2.897583849e-02f, +3.479871167e-02f, +4.059164950e-02f, +4.610544046e-02f, +5.108649330e-02f, +5.529398411e-02f, +5.851684758e-02f, +6.058912062e-02f, +6.140225762e-02f, +6.091329118e-02f, +5.914808397e-02f, +5.619936998e-02f, +5.221976696e-02f, +4.741040693e-02f, +4.200622791e-02f, +3.625925639e-02f, +3.042135907e-02f, +2.472793953e-02f, +1.938390732e-02f, +1.455297193e-02f, +1.035094713e-02f, +6.843335402e-03f, +4.047043008e-03f, +1.935699446e-03f, +4.477581400e-04f, -5.036355508e-04f, -1.020093841e-03f, -1.207791250e-03f, -1.168511587e-03f, -9.925955341e-04f, -7.541730419e-04f, -5.087801372e-04f, -2.931980560e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.408071968e-05f, +1.558336850e-05f, +1.453981342e-05f, +9.764132757e-06f, +1.083630892e-07f, -1.539454099e-05f, -3.738085809e-05f, -6.601627161e-05f, -1.008839801e-04f, -1.409175379e-04f, -1.843918961e-04f, -2.289808241e-04f, -2.718821271e-04f, -3.100045565e-04f, -3.402029042e-04f, -3.595413759e-04f, -3.655607915e-04f, -3.565231022e-04f, -3.316075217e-04f, -2.910362794e-04f, -2.361143096e-04f, -1.691754631e-04f, -9.343717126e-05f, -1.277488105e-05f, +6.856405736e-05f, +1.462809907e-04f, +2.163513340e-04f, +2.753244915e-04f, +3.205708032e-04f, +3.504535917e-04f, +3.644122164e-04f, +3.629512268e-04f, +3.475401762e-04f, +3.204373710e-04f, +2.844578309e-04f, +2.427103092e-04f, +1.983299454e-04f, +1.542319388e-04f, +1.129078005e-04f, +7.627984250e-05f, +4.562237634e-05f, +2.155051224e-05f, +4.070364810e-06f, -7.321345221e-06f, -1.350427756e-05f, -1.558585112e-05f, -1.475445480e-05f, -1.214962021e-05f,
        /*  0, 3 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -4.369668323e-04f, -6.761448667e-04f, -9.218143344e-04f, -1.124378708e-03f, -1.215372481e-03f, -1.109121316e-03f, -7.067621956e-04f, +9.739038789e-05f, +1.407426934e-03f, +3.315950061e-03f, +5.893528775e-03f, +9.178500602e-03f, +1.316820396e-02f, +1.781268985e-02f, +2.301180811e-02f, +2.861629712e-02f, +3.443315088e-02f, +4.023512640e-02f, +4.577383294e-02f, +5.079545702e-02f, +5.505786980e-02f, +5.834767212e-02f, +6.049568345e-02f, +6.138948274e-02f, +6.098185524e-02f, +5.929436496e-02f, +5.641572132e-02f, +5.249509145e-02f, +4.773097773e-02f, +4.235668150e-02f, +3.662366861e-02f, +3.078431030e-02f, +2.507547970e-02f, +1.970434469e-02f, +1.483742976e-02f, +1.059365744e-02f, +7.041665348e-03f, +4.201274946e-03f, +2.048607246e-03f, +5.240379825e-04f, -4.580131745e-04f, -9.985433285e-04f, -1.203720885e-03f, -1.175832932e-03f, -1.006099812e-03f, -7.697588930e-04f, -5.235345920e-04f, -3.053476762e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.392820018e-05f, +1.555196970e-05f, +1.470198130e-05f, +1.019427178e-05f, +8.744713867e-07f, -1.424017206e-05f, -3.581090067e-05f, -6.403646691e-05f, -9.853898309e-05f, -1.382935265e-04f, -1.816152396e-04f, -2.262124861e-04f, -2.693079297e-04f, -3.078219119e-04f, -3.386050587e-04f, -3.587005674e-04f, -3.656119364e-04f, -3.575496773e-04f, -3.336311662e-04f, -2.940113321e-04f, -2.399280361e-04f, -1.736541678e-04f, -9.835779378e-05f, -1.788110924e-05f, +6.354259999e-05f, +1.416082500e-04f, +2.122649289e-04f, +2.720182574e-04f, +3.181813609e-04f, +3.490520992e-04f, +3.640019265e-04f, +3.634708763e-04f, +3.488726530e-04f, +3.224226032e-04f, +2.869084686e-04f, +2.454285640e-04f, +2.011239334e-04f, +1.569300258e-04f, +1.153697583e-04f, +7.840403901e-05f, +4.734869143e-05f, +2.285914223e-05f, +4.977088548e-06f, -6.772549939e-06f, -1.325019189e-05f, -1.555342333e-05f, -1.486961808e-05f, -1.234467317e-05f,
        /*  0, 4 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -4.230386322e-04f, -6.605928970e-04f, -9.071123531e-04f, -1.114184437e-03f, -1.214498009e-03f, -1.123361488e-03f, -7.425730963e-04f, +3.335392098e-05f, +1.308887951e-03f, +3.177656534e-03f, +5.711913535e-03f, +8.952288116e-03f, +1.289889603e-02f, +1.750486794e-02f, +2.267320305e-02f, +2.825759655e-02f, +3.406753894e-02f, +3.987757672e-02f, +4.544020177e-02f, +5.050144569e-02f, +5.481794176e-02f, +5.817401795e-02f, +6.039732565e-02f, +6.137160163e-02f, +6.104539784e-02f, +5.943597321e-02f, +5.662798625e-02f, +5.276710971e-02f, +4.804915909e-02f, +4.270573360e-02f, +3.698767054e-02f, +3.114778118e-02f, +2.542435236e-02f, +2.002676730e-02f, +1.512433823e-02f, +1.083908600e-02f, +7.242789281e-03f, +4.358204972e-03f, +2.163977005e-03f, +6.024420215e-04f, -4.106644831e-04f, -9.756841862e-04f, -1.198743797e-03f, -1.182605482e-03f, -1.019350004e-03f, -7.853123163e-04f, -5.384042101e-04f, -3.176923494e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.377034793e-05f, +1.551093858e-05f, +1.484985257e-05f, +1.060555829e-05f, +1.617838952e-06f, -1.311117335e-05f, -3.426712759e-05f, -6.208139387e-05f, -9.621471868e-05f, -1.356836490e-04f, -1.788437260e-04f, -2.234383818e-04f, -2.667158598e-04f, -3.056090065e-04f, -3.369653145e-04f, -3.578080270e-04f, -3.656042935e-04f, -3.585139737e-04f, -3.355931220e-04f, -2.969295472e-04f, -2.436938494e-04f, -1.780974071e-04f, -1.032580523e-04f, -2.298361455e-05f, +5.850794175e-05f, +1.369063854e-04f, +2.081356675e-04f, +2.686586134e-04f, +3.157318305e-04f, +3.475880652e-04f, +3.635308455e-04f, +3.639353135e-04f, +3.501586466e-04f, +3.243723279e-04f, +2.893357895e-04f, +2.481358533e-04f, +2.039184901e-04f, +1.596385855e-04f, +1.178498758e-04f, +8.055153976e-05f, +4.910085537e-05f, +2.419375182e-05f, +5.907892698e-06f, -6.203084070e-06f, -1.297977154e-05f, -1.550934211e-05f, -1.497763796e-05f, -1.253651480e-05f,
        /*  0, 5 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -4.092682842e-04f, -6.450819584e-04f, -8.922625006e-04f, -1.103578878e-03f, -1.212880170e-03f, -1.136472661e-03f, -7.768402239e-04f, -2.872747289e-05f, +1.212673232e-03f, +3.041972885e-03f, +5.533069809e-03f, +8.728849735e-03f, +1.263218017e-02f, +1.719925894e-02f, +2.233623773e-02f, +2.789978852e-02f, +3.370193465e-02f, +3.951906275e-02f, +4.510460865e-02f, +5.020451614e-02f, +5.457424791e-02f, +5.799592054e-02f, +6.029406760e-02f, +6.134861802e-02f, +6.110390578e-02f, +5.957287960e-02f, +5.683612192e-02f, +5.303576832e-02f, +4.836489092e-02f, +4.305332166e-02f, +3.735120138e-02f, +3.151171649e-02f, +2.577451100e-02f, +2.035113962e-02f, +1.541367402e-02f, +1.108722185e-02f, +7.446707771e-03f, +4.517843558e-03f, +2.281826881e-03f, +6.829935612e-04f, -3.615636277e-04f, -9.514904344e-04f, -1.192835904e-03f, -1.188808566e-03f, -1.032329775e-03f, -8.008216584e-04f, -5.533818481e-04f, -3.302288642e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.360741082e-05f, +1.546055886e-05f, +1.498372103e-05f, +1.099826356e-05f, +2.338678028e-06f, -1.200742830e-05f, -3.274955044e-05f, -6.015121602e-05f, -9.391151370e-05f, -1.330883916e-04f, -1.760779795e-04f, -2.206592368e-04f, -2.641066927e-04f, -3.033666037e-04f, -3.352843568e-04f, -3.568642973e-04f, -3.655382063e-04f, -3.594160939e-04f, -3.374932277e-04f, -2.997904985e-04f, -2.474110810e-04f, -1.825043147e-04f, -1.081369454e-04f, -2.808133519e-05f, +5.346112415e-05f, +1.321763393e-04f, +2.039643239e-04f, +2.652461110e-04f, +3.132225075e-04f, +3.460615178e-04f, +3.629987460e-04f, +3.643440891e-04f, +3.513975353e-04f, +3.262858124e-04f, +2.917390162e-04f, +2.508314194e-04f, +2.067129352e-04f, +1.623570592e-04f, +1.203477449e-04f, +8.272210008e-05f, +5.087878289e-05f, +2.555439710e-05f, +6.862946083e-06f, -5.612701183e-06f, -1.269272958e-05f, -1.545331501e-05f, -1.507824593e-05f, -1.272492213e-05f,
        /*  0, 6 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -3.956608734e-04f, -6.296213996e-04f, -8.772787795e-04f, -1.092580615e-03f, -1.210541492e-03f, -1.148480090e-03f, -8.095897743e-04f, -8.887868891e-05f, +1.118761719e-03f, +2.908884493e-03f, +5.356991830e-03f, +8.508190498e-03f, +1.236807348e-02f, +1.689589233e-02f, +2.200095338e-02f, +2.754292423e-02f, +3.333639644e-02f, +3.915964666e-02f, +4.476711542e-02f, +4.990472564e-02f, +5.432683683e-02f, +5.781341623e-02f, +6.018593065e-02f, +6.132053668e-02f, +6.115736690e-02f, +5.970505594e-02f, +5.704008624e-02f, +5.330101443e-02f, +4.867811343e-02f, +4.339938318e-02f, +3.771420013e-02f, +3.187606058e-02f, +2.612590854e-02f, +2.067742544e-02f, +1.570541304e-02f, +1.133805327e-02f, +7.653420706e-03f, +4.680200617e-03f, +2.402174625e-03f, +7.657156613e-04f, -3.106848448e-04f, -9.259360373e-04f, -1.185972958e-03f, -1.194421267e-03f, -1.045022505e-03f, -8.162749735e-04f, -5.684600940e-04f, -3.429537863e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.343963384e-05f, +1.540111268e-05f, +1.510388072e-05f, +1.137266132e-05f, +3.037205637e-06f, -1.092881336e-05f, -3.125817198e-05f, -5.824608692e-05f, -9.162968470e-05f, -1.305082307e-04f, -1.733186168e-04f, -2.178757715e-04f, -2.614812022e-04f, -3.010954694e-04f, -3.335628777e-04f, -3.558699317e-04f, -3.654140322e-04f, -3.602561561e-04f, -3.393313383e-04f, -3.025937756e-04f, -2.510790765e-04f, -1.868740351e-04f, -1.129934779e-04f, -3.317321082e-05f, +4.840319232e-05f, +1.274190627e-04f, +1.997516844e-04f, +2.617813169e-04f, +3.106537038e-04f, +3.444725018e-04f, +3.624054162e-04f, +3.646967662e-04f, +3.525887067e-04f, +3.281623292e-04f, +2.941173722e-04f, +2.535145019e-04f, +2.095065816e-04f, +1.650848794e-04f, +1.228629477e-04f, +8.491546506e-05f, +5.268237913e-05f, +2.694112611e-05f, +7.842411460e-06f, -5.001158613e-06f, -1.238878055e-05f, -1.538504899e-05f, -1.517117127e-05f, -1.290966885e-05f,
        /*  0, 7 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -3.822212396e-04f, -6.142202869e-04f, -8.621748988e-04f, -1.081207953e-03f, -1.207504287e-03f, -1.159408903e-03f, -8.408479463e-04f, -1.471247758e-04f, +1.027132034e-03f, +2.778376263e-03f, +5.183673213e-03f, +8.290314726e-03f, +1.210659227e-02f, +1.659479686e-02f, +2.166739050e-02f, +2.718705429e-02f, +3.297098241e-02f, +3.879939050e-02f, +4.442778408e-02f, +4.960213187e-02f, +5.407575776e-02f, +5.762654220e-02f, +6.007293718e-02f, +6.128736347e-02f, +6.120577010e-02f, +5.983247500e-02f, +5.723983792e-02f, +5.356279575e-02f, +4.898876714e-02f, +4.374385568e-02f, +3.807660555e-02f, +3.224075735e-02f, +2.647849724e-02f, +2.100558777e-02f, +1.599953041e-02f, +1.159156778e-02f, +7.862927288e-03f, +4.845285496e-03f, +2.525037573e-03f, +8.506311264e-04f, -2.580024657e-04f, -8.989949112e-04f, -1.178130546e-03f, -1.199422426e-03f, -1.057411285e-03f, -8.316600224e-04f, -5.836312653e-04f, -3.558634551e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.326725904e-05f, +1.533288052e-05f, +1.521062582e-05f, +1.172902759e-05f, +3.713643442e-06f, -9.875198106e-06f, -2.979298624e-05f, -5.636615021e-05f, -8.936953796e-05f, -1.279436332e-04f, -1.705662467e-04f, -2.150887015e-04f, -2.588401603e-04f, -2.987963721e-04f, -3.318015757e-04f, -3.548254937e-04f, -3.652321423e-04f, -3.610342947e-04f, -3.411073257e-04f, -3.053389846e-04f, -2.546971958e-04f, -1.912057239e-04f, -1.178266614e-04f, -3.825818285e-05f, +4.333519473e-05f, +1.226355145e-04f, +1.954985477e-04f, +2.582648130e-04f, +3.080257478e-04f, +3.428210784e-04f, +3.617506595e-04f, +3.649929210e-04f, +3.537315574e-04f, +3.300011559e-04f, +2.964700822e-04f, +2.561843375e-04f, +2.122987367e-04f, +1.678214700e-04f, +1.253950564e-04f, +8.713136950e-05f, +5.451153963e-05f, +2.835397865e-05f, +8.846445392e-06f, -4.368217600e-06f, -1.206764059e-05f, -1.530425055e-05f, -1.525614110e-05f, -1.309052541e-05f,
        /*  0, 8 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -3.689539805e-04f, -5.988874064e-04f, -8.469642730e-04f, -1.069478926e-03f, -1.203790643e-03f, -1.169284101e-03f, -8.706409326e-04f, -2.034909260e-04f, +9.377624959e-04f, +2.650432629e-03f, +5.013106966e-03f, +8.075226025e-03f, +1.184775211e-02f, +1.629600049e-02f, +2.133558892e-02f, +2.683222880e-02f, +3.260575027e-02f, +3.843835620e-02f, +4.408667676e-02f, +4.929679288e-02f, +5.382106056e-02f, +5.743533647e-02f, +5.995511052e-02f, +6.124910529e-02f, +6.124910529e-02f, +5.995511052e-02f, +5.743533647e-02f, +5.382106056e-02f, +4.929679288e-02f, +4.408667676e-02f, +3.843835620e-02f, +3.260575027e-02f, +2.683222880e-02f, +2.133558892e-02f, +1.629600049e-02f, +1.184775211e-02f, +8.075226025e-03f, +5.013106966e-03f, +2.650432629e-03f, +9.377624959e-04f, -2.034909260e-04f, -8.706409326e-04f, -1.169284101e-03f, -1.203790643e-03f, -1.069478926e-03f, -8.469642730e-04f, -5.988874064e-04f, -3.689539805e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.309052541e-05f, +1.525614110e-05f, +1.530425055e-05f, +1.206764059e-05f, +4.368217600e-06f, -8.846445392e-06f, -2.835397865e-05f, -5.451153963e-05f, -8.713136950e-05f, -1.253950564e-04f, -1.678214700e-04f, -2.122987367e-04f, -2.561843375e-04f, -2.964700822e-04f, -3.300011559e-04f, -3.537315574e-04f, -3.649929210e-04f, -3.617506595e-04f, -3.428210784e-04f, -3.080257478e-04f, -2.582648130e-04f, -1.954985477e-04f, -1.226355145e-04f, -4.333519473e-05f, +3.825818285e-05f, +1.178266614e-04f, +1.912057239e-04f, +2.546971958e-04f, +3.053389846e-04f, +3.411073257e-04f, +3.610342947e-04f, +3.652321423e-04f, +3.548254937e-04f, +3.318015757e-04f, +2.987963721e-04f, +2.588401603e-04f, +2.150887015e-04f, +1.705662467e-04f, +1.279436332e-04f, +8.936953796e-05f, +5.636615021e-05f, +2.979298624e-05f, +9.875198106e-06f, -3.713643442e-06f, -1.172902759e-05f, -1.521062582e-05f, -1.533288052e-05f, -1.326725904e-05f,
        /*  0, 9 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -3.558634551e-04f, -5.836312653e-04f, -8.316600224e-04f, -1.057411285e-03f, -1.199422426e-03f, -1.178130546e-03f, -8.989949112e-04f, -2.580024657e-04f, +8.506311264e-04f, +2.525037573e-03f, +4.845285496e-03f, +7.862927288e-03f, +1.159156778e-02f, +1.599953041e-02f, +2.100558777e-02f, +2.647849724e-02f, +3.224075735e-02f, +3.807660555e-02f, +4.374385568e-02f, +4.898876714e-02f, +5.356279575e-02f, +5.723983792e-02f, +5.983247500e-02f, +6.120577010e-02f, +6.128736347e-02f, +6.007293718e-02f, +5.762654220e-02f, +5.407575776e-02f, +4.960213187e-02f, +4.442778408e-02f, +3.879939050e-02f, +3.297098241e-02f, +2.718705429e-02f, +2.166739050e-02f, +1.659479686e-02f, +1.210659227e-02f, +8.290314726e-03f, +5.183673213e-03f, +2.778376263e-03f, +1.027132034e-03f, -1.471247758e-04f, -8.408479463e-04f, -1.159408903e-03f, -1.207504287e-03f, -1.081207953e-03f, -8.621748988e-04f, -6.142202869e-04f, -3.822212396e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.290966885e-05f, +1.517117127e-05f, +1.538504899e-05f, +1.238878055e-05f, +5.001158613e-06f, -7.842411460e-06f, -2.694112611e-05f, -5.268237913e-05f, -8.491546506e-05f, -1.228629477e-04f, -1.650848794e-04f, -2.095065816e-04f, -2.535145019e-04f, -2.941173722e-04f, -3.281623292e-04f, -3.525887067e-04f, -3.646967662e-04f, -3.624054162e-04f, -3.444725018e-04f, -3.106537038e-04f, -2.617813169e-04f, -1.997516844e-04f, -1.274190627e-04f, -4.840319232e-05f, +3.317321082e-05f, +1.129934779e-04f, +1.868740351e-04f, +2.510790765e-04f, +3.025937756e-04f, +3.393313383e-04f, +3.602561561e-04f, +3.654140322e-04f, +3.558699317e-04f, +3.335628777e-04f, +3.010954694e-04f, +2.614812022e-04f, +2.178757715e-04f, +1.733186168e-04f, +1.305082307e-04f, +9.162968470e-05f, +5.824608692e-05f, +3.125817198e-05f, +1.092881336e-05f, -3.037205637e-06f, -1.137266132e-05f, -1.510388072e-05f, -1.540111268e-05f, -1.343963384e-05f,
        /*  0,10 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -3.429537863e-04f, -5.684600940e-04f, -8.162749735e-04f, -1.045022505e-03f, -1.194421267e-03f, -1.185972958e-03f, -9.259360373e-04f, -3.106848448e-04f, +7.657156613e-04f, +2.402174625e-03f, +4.680200617e-03f, +7.653420706e-03f, +1.133805327e-02f, +1.570541304e-02f, +2.067742544e-02f, +2.612590854e-02f, +3.187606058e-02f, +3.771420013e-02f, +4.339938318e-02f, +4.867811343e-02f, +5.330101443e-02f, +5.704008624e-02f, +5.970505594e-02f, +6.115736690e-02f, +6.132053668e-02f, +6.018593065e-02f, +5.781341623e-02f, +5.432683683e-02f, +4.990472564e-02f, +4.476711542e-02f, +3.915964666e-02f, +3.333639644e-02f, +2.754292423e-02f, +2.200095338e-02f, +1.689589233e-02f, +1.236807348e-02f, +8.508190498e-03f, +5.356991830e-03f, +2.908884493e-03f, +1.118761719e-03f, -8.887868891e-05f, -8.095897743e-04f, -1.148480090e-03f, -1.210541492e-03f, -1.092580615e-03f, -8.772787795e-04f, -6.296213996e-04f, -3.956608734e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.272492213e-05f, +1.507824593e-05f, +1.545331501e-05f, +1.269272958e-05f, +5.612701183e-06f, -6.862946083e-06f, -2.555439710e-05f, -5.087878289e-05f, -8.272210008e-05f, -1.203477449e-04f, -1.623570592e-04f, -2.067129352e-04f, -2.508314194e-04f, -2.917390162e-04f, -3.262858124e-04f, -3.513975353e-04f, -3.643440891e-04f, -3.629987460e-04f, -3.460615178e-04f, -3.132225075e-04f, -2.652461110e-04f, -2.039643239e-04f, -1.321763393e-04f, -5.346112415e-05f, +2.808133519e-05f, +1.081369454e-04f, +1.825043147e-04f, +2.474110810e-04f, +2.997904985e-04f, +3.374932277e-04f, +3.594160939e-04f, +3.655382063e-04f, +3.568642973e-04f, +3.352843568e-04f, +3.033666037e-04f, +2.641066927e-04f, +2.206592368e-04f, +1.760779795e-04f, +1.330883916e-04f, +9.391151370e-05f, +6.015121602e-05f, +3.274955044e-05f, +1.200742830e-05f, -2.338678028e-06f, -1.099826356e-05f, -1.498372103e-05f, -1.546055886e-05f, -1.360741082e-05f,
        /*  0,11 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -3.302288642e-04f, -5.533818481e-04f, -8.008216584e-04f, -1.032329775e-03f, -1.188808566e-03f, -1.192835904e-03f, -9.514904344e-04f, -3.615636277e-04f, +6.829935612e-04f, +2.281826881e-03f, +4.517843558e-03f, +7.446707771e-03f, +1.108722185e-02f, +1.541367402e-02f, +2.035113962e-02f, +2.577451100e-02f, +3.151171649e-02f, +3.735120138e-02f, +4.305332166e-02f, +4.836489092e-02f, +5.303576832e-02f, +5.683612192e-02f, +5.957287960e-02f, +6.110390578e-02f, +6.134861802e-02f, +6.029406760e-02f, +5.799592054e-02f, +5.457424791e-02f, +5.020451614e-02f, +4.510460865e-02f, +3.951906275e-02f, +3.370193465e-02f, +2.789978852e-02f, +2.233623773e-02f, +1.719925894e-02f, +1.263218017e-02f, +8.728849735e-03f, +5.533069809e-03f, +3.041972885e-03f, +1.212673232e-03f, -2.872747289e-05f, -7.768402239e-04f, -1.136472661e-03f, -1.212880170e-03f, -1.103578878e-03f, -8.922625006e-04f, -6.450819584e-04f, -4.092682842e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.253651480e-05f, +1.497763796e-05f, +1.550934211e-05f, +1.297977154e-05f, +6.203084070e-06f, -5.907892698e-06f, -2.419375182e-05f, -4.910085537e-05f, -8.055153976e-05f, -1.178498758e-04f, -1.596385855e-04f, -2.039184901e-04f, -2.481358533e-04f, -2.893357895e-04f, -3.243723279e-04f, -3.501586466e-04f, -3.639353135e-04f, -3.635308455e-04f, -3.475880652e-04f, -3.157318305e-04f, -2.686586134e-04f, -2.081356675e-04f, -1.369063854e-04f, -5.850794175e-05f, +2.298361455e-05f, +1.032580523e-04f, +1.780974071e-04f, +2.436938494e-04f, +2.969295472e-04f, +3.355931220e-04f, +3.585139737e-04f, +3.656042935e-04f, +3.578080270e-04f, +3.369653145e-04f, +3.056090065e-04f, +2.667158598e-04f, +2.234383818e-04f, +1.788437260e-04f, +1.356836490e-04f, +9.621471868e-05f, +6.208139387e-05f, +3.426712759e-05f, +1.311117335e-05f, -1.617838952e-06f, -1.060555829e-05f, -1.484985257e-05f, -1.551093858e-05f, -1.377034793e-05f,
        /*  0,12 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -3.176923494e-04f, -5.384042101e-04f, -7.853123163e-04f, -1.019350004e-03f, -1.182605482e-03f, -1.198743797e-03f, -9.756841862e-04f, -4.106644831e-04f, +6.024420215e-04f, +2.163977005e-03f, +4.358204972e-03f, +7.242789281e-03f, +1.083908600e-02f, +1.512433823e-02f, +2.002676730e-02f, +2.542435236e-02f, +3.114778118e-02f, +3.698767054e-02f, +4.270573360e-02f, +4.804915909e-02f, +5.276710971e-02f, +5.662798625e-02f, +5.943597321e-02f, +6.104539784e-02f, +6.137160163e-02f, +6.039732565e-02f, +5.817401795e-02f, +5.481794176e-02f, +5.050144569e-02f, +4.544020177e-02f, +3.987757672e-02f, +3.406753894e-02f, +2.825759655e-02f, +2.267320305e-02f, +1.750486794e-02f, +1.289889603e-02f, +8.952288116e-03f, +5.711913535e-03f, +3.177656534e-03f, +1.308887951e-03f, +3.335392098e-05f, -7.425730963e-04f, -1.123361488e-03f, -1.214498009e-03f, -1.114184437e-03f, -9.071123531e-04f, -6.605928970e-04f, -4.230386322e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.234467317e-05f, +1.486961808e-05f, +1.555342333e-05f, +1.325019189e-05f, +6.772549939e-06f, -4.977088548e-06f, -2.285914223e-05f, -4.734869143e-05f, -7.840403901e-05f, -1.153697583e-04f, -1.569300258e-04f, -2.011239334e-04f, -2.454285640e-04f, -2.869084686e-04f, -3.224226032e-04f, -3.488726530e-04f, -3.634708763e-04f, -3.640019265e-04f, -3.490520992e-04f, -3.181813609e-04f, -2.720182574e-04f, -2.122649289e-04f, -1.416082500e-04f, -6.354259999e-05f, +1.788110924e-05f, +9.835779378e-05f, +1.736541678e-04f, +2.399280361e-04f, +2.940113321e-04f, +3.336311662e-04f, +3.575496773e-04f, +3.656119364e-04f, +3.587005674e-04f, +3.386050587e-04f, +3.078219119e-04f, +2.693079297e-04f, +2.262124861e-04f, +1.816152396e-04f, +1.382935265e-04f, +9.853898309e-05f, +6.403646691e-05f, +3.581090067e-05f, +1.424017206e-05f, -8.744713867e-07f, -1.019427178e-05f, -1.470198130e-05f, -1.555196970e-05f, -1.392820018e-05f,
        /*  0,13 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -3.053476762e-04f, -5.235345920e-04f, -7.697588930e-04f, -1.006099812e-03f, -1.175832932e-03f, -1.203720885e-03f, -9.985433285e-04f, -4.580131745e-04f, +5.240379825e-04f, +2.048607246e-03f, +4.201274946e-03f, +7.041665348e-03f, +1.059365744e-02f, +1.483742976e-02f, +1.970434469e-02f, +2.507547970e-02f, +3.078431030e-02f, +3.662366861e-02f, +4.235668150e-02f, +4.773097773e-02f, +5.249509145e-02f, +5.641572132e-02f, +5.929436496e-02f, +6.098185524e-02f, +6.138948274e-02f, +6.049568345e-02f, +5.834767212e-02f, +5.505786980e-02f, +5.079545702e-02f, +4.577383294e-02f, +4.023512640e-02f, +3.443315088e-02f, +2.861629712e-02f, +2.301180811e-02f, +1.781268985e-02f, +1.316820396e-02f, +9.178500602e-03f, +5.893528775e-03f, +3.315950061e-03f, +1.407426934e-03f, +9.739038789e-05f, -7.067621956e-04f, -1.109121316e-03f, -1.215372481e-03f, -1.124378708e-03f, -9.218143344e-04f, -6.761448667e-04f, -4.369668323e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.214962021e-05f, +1.475445480e-05f, +1.558585112e-05f, +1.350427756e-05f, +7.321345221e-06f, -4.070364810e-06f, -2.155051224e-05f, -4.562237634e-05f, -7.627984250e-05f, -1.129078005e-04f, -1.542319388e-04f, -1.983299454e-04f, -2.427103092e-04f, -2.844578309e-04f, -3.204373710e-04f, -3.475401762e-04f, -3.629512268e-04f, -3.644122164e-04f, -3.504535917e-04f, -3.205708032e-04f, -2.753244915e-04f, -2.163513340e-04f, -1.462809907e-04f, -6.856405736e-05f, +1.277488105e-05f, +9.343717126e-05f, +1.691754631e-04f, +2.361143096e-04f, +2.910362794e-04f, +3.316075217e-04f, +3.565231022e-04f, +3.655607915e-04f, +3.595413759e-04f, +3.402029042e-04f, +3.100045565e-04f, +2.718821271e-04f, +2.289808241e-04f, +1.843918961e-04f, +1.409175379e-04f, +1.008839801e-04f, +6.601627161e-05f, +3.738085809e-05f, +1.539454099e-05f, -1.083630892e-07f, -9.764132757e-06f, -1.453981342e-05f, -1.558336850e-05f, -1.408071968e-05f,
        /*  0,14 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -2.931980560e-04f, -5.087801372e-04f, -7.541730419e-04f, -9.925955341e-04f, -1.168511587e-03f, -1.207791250e-03f, -1.020093841e-03f, -5.036355508e-04f, +4.477581400e-04f, +1.935699446e-03f, +4.047043008e-03f, +6.843335402e-03f, +1.035094713e-02f, +1.455297193e-02f, +1.938390732e-02f, +2.472793953e-02f, +3.042135907e-02f, +3.625925639e-02f, +4.200622791e-02f, +4.741040693e-02f, +5.221976696e-02f, +5.619936998e-02f, +5.914808397e-02f, +6.091329118e-02f, +6.140225762e-02f, +6.058912062e-02f, +5.851684758e-02f, +5.529398411e-02f, +5.108649330e-02f, +4.610544046e-02f, +4.059164950e-02f, +3.479871167e-02f, +2.897583849e-02f, +2.335201101e-02f, +1.812269441e-02f, +1.344008609e-02f, +9.407481427e-03f, +6.077920671e-03f, +3.456867598e-03f, +1.508310914e-03f, +1.634066595e-04f, -6.693813375e-04f, -1.093726775e-03f, -1.215480844e-03f, -1.134142841e-03f, -9.363541479e-04f, -6.917282352e-04f, -4.510475520e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.195157556e-05f, +1.463241434e-05f, +1.560691722e-05f, +1.374231680e-05f, +7.849719961e-06f, -3.187546744e-06f, -2.026779777e-05f, -4.392198589e-05f, -7.417918467e-05f, -1.104644002e-04f, -1.515448748e-04f, -1.955372004e-04f, -2.399818431e-04f, -2.819846545e-04f, -3.184173686e-04f, -3.461618466e-04f, -3.623768266e-04f, -3.647619571e-04f, -3.517925311e-04f, -3.228998788e-04f, -2.785767791e-04f, -2.203941213e-04f, -1.509236733e-04f, -7.357127629e-05f, +7.665992852e-06f, +8.849719227e-05f, +1.646621696e-04f, +2.322533521e-04f, +2.880048316e-04f, +3.295223672e-04f, +3.554341621e-04f, +3.654505292e-04f, +3.603299209e-04f, +3.417581727e-04f, +3.121561799e-04f, +2.744376758e-04f, +2.317426657e-04f, +1.871730634e-04f, +1.435551879e-04f, +1.032493727e-04f, +6.802063440e-05f, +3.897697936e-05f, +1.657438954e-05f, +6.806932534e-07f, -9.314872538e-06f, -1.436305556e-05f, -1.560484981e-05f, -1.422765568e-05f,
        /*  0,15 (48) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -2.812464804e-04f, -4.941477229e-04f, -7.385661247e-04f, -9.788532173e-04f, -1.160661867e-03f, -1.210978797e-03f, -1.040361638e-03f, -5.475575367e-04f, +3.735789553e-04f, +1.825235046e-03f, +3.895498133e-03f, +6.647798202e-03f, +1.011096528e-02f, +1.427098728e-02f, +1.906548995e-02f, +2.438177768e-02f, +3.005898225e-02f, +3.589449444e-02f, +4.165443537e-02f, +4.708750705e-02f, +5.194119018e-02f, +5.597897586e-02f, +5.899716030e-02f, +6.083971990e-02f, +6.140992362e-02f, +6.067761781e-02f, +5.868150975e-02f, +5.552623746e-02f, +5.137449813e-02f, +4.643496283e-02f, +4.094708366e-02f, +3.516416220e-02f, +2.933616842e-02f, +2.369376918e-02f, +1.843485059e-02f, +1.371452376e-02f, +9.639224092e-03f, +6.265093734e-03f, +3.600422786e-03f, +1.611560287e-03f, +2.314272939e-04f, -6.304043582e-04f, -1.077152385e-03f, -1.214800150e-03f, -1.143457714e-03f, -9.507172034e-04f, -7.073330850e-04f, -4.652752077e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.175075544e-05f, +1.450376051e-05f, +1.561691254e-05f, +1.396459906e-05f, +8.357927672e-06f, -2.328453823e-06f, -1.901092689e-05f, -4.224758644e-05f, -7.210228972e-05f, -1.080399453e-04f, -1.488693749e-04f, -1.927463657e-04f, -2.372439164e-04f, -2.794897176e-04f, -3.163633379e-04f, -3.447383033e-04f, -3.617481497e-04f, -3.650514058e-04f, -3.530689224e-04f, -3.251683254e-04f, -2.817745994e-04f, -2.243925418e-04f, -1.555353731e-04f, -7.856322346e-05f, +2.555508337e-06f, +8.353887009e-05f, +1.601151740e-04f, +2.283458597e-04f, +2.849174469e-04f, +3.273758978e-04f, +3.542827868e-04f, +3.652808343e-04f, +3.610656819e-04f, +3.432701935e-04f, +3.142760250e-04f, +2.769737986e-04f, +2.344972762e-04f, +1.899581021e-04f, +1.462059716e-04f, +1.056348136e-04f, +7.004937168e-05f, +4.059923501e-05f, +1.777981991e-05f, +1.492899882e-06f, -8.846225192e-06f, -1.417141484e-05f, -1.561612709e-05f, -1.436875469e-05f,
        /*  1, 0 (48) */
        -4.796439624e-04f, -7.229492121e-04f, -9.648886183e-04f, -1.152303939e-03f, -1.213307251e-03f, -1.059372565e-03f, -5.898051232e-04f, +3.014766656e-04f, +1.717195100e-03f, +3.746628758e-03f, +6.455051836e-03f, +9.873721368e-03f, +1.399149756e-02f, +1.874912662e-02f, +2.403703938e-02f, +2.969723410e-02f, +3.552944303e-02f, +4.130136645e-02f, +4.676233873e-02f, +5.165941558e-02f, +5.575458332e-02f, +5.884162493e-02f, +6.076115668e-02f, +6.141247912e-02f, +6.076115668e-02f, +5.884162493e-02f, +5.575458332e-02f, +5.165941558e-02f, +4.676233873e-02f, +4.130136645e-02f, +3.552944303e-02f, +2.969723410e-02f, +2.403703938e-02f, +1.874912662e-02f, +1.399149756e-02f, +9.873721368e-03f, +6.455051836e-03f, +3.746628758e-03f, +1.717195100e-03f, +3.014766656e-04f, -5.898051232e-04f, -1.059372565e-03f, -1.213307251e-03f, -1.152303939e-03f, -9.648886183e-04f, -7.229492121e-04f, -4.796439624e-04f, -2.694957250e-04f,
        +7.400711575e-04f, +1.375020608e-03f, +2.149280883e-03f, +2.889370620e-03f, +3.314167096e-03f, +3.062969010e-03f, +1.758157367e-03f, -9.035293376e-04f, -5.046849967e-03f, -1.052447103e-02f, -1.686036328e-02f, -2.325321288e-02f, -2.865282346e-02f, -3.190731847e-02f, -3.196179918e-02f, -2.807404400e-02f, -2.000388698e-02f, -8.133017718e-03f, +6.517945993e-03f, +2.238959427e-02f, +3.759199639e-02f, +5.018871167e-02f, +5.850644264e-02f, +6.141247912e-02f, +5.850644264e-02f, +5.018871167e-02f, +3.759199639e-02f, +2.238959427e-02f, +6.517945993e-03f, -8.133017718e-03f, -2.000388698e-02f, -2.807404400e-02f, -3.196179918e-02f, -3.190731847e-02f, -2.865282346e-02f, -2.325321288e-02f, -1.686036328e-02f, -1.052447103e-02f, -5.046849967e-03f, -9.035293376e-04f, +1.758157367e-03f, +3.062969010e-03f, +3.314167096e-03f, +2.889370620e-03f, +2.149280883e-03f, +1.375020608e-03f, +7.400711575e-04f, +3.136419749e-04f,
        +1.436875469e-05f, +1.561612709e-05f, +1.417141484e-05f, +8.846225192e-06f, -1.492899882e-06f, -1.777981991e-05f, -4.059923501e-05f, -7.004937168e-05f, -1.056348136e-04f, -1.462059716e-04f, -1.899581021e-04f, -2.344972762e-04f, -2.769737986e-04f, -3.142760250e-04f, -3.432701935e-04f, -3.610656819e-04f, -3.652808343e-04f, -3.542827868e-04f, -3.273758978e-04f, -2.849174469e-04f, -2.283458597e-04f, -1.601151740e-04f, -8.353887009e-05f, -2.555508337e-06f, +7.856322346e-05f, +1.555353731e-04f, +2.243925418e-04f, +2.817745994e-04f, +3.251683254e-04f, +3.530689224e-04f, +3.650514058e-04f, +3.617481497e-04f, +3.447383033e-04f, +3.163633379e-04f, +2.794897176e-04f, +2.372439164e-04f, +1.927463657e-04f, +1.488693749e-04f, +1.080399453e-04f, +7.210228972e-05f, +4.224758644e-05f, +1.901092689e-05f, +2.328453823e-06f, -8.357927672e-06f, -1.396459906e-05f, -1.561691254e-05f, -1.450376051e-05f, -1.175075544e-05f,
        -3.298796763e-05f, -4.497254386e-05f, -4.975291943e-05f, -4.042907987e-05f, -1.073671011e-05f, +4.281170552e-05f, +1.188365932e-04f, +2.096675045e-04f, +3.011639964e-04f, +3.741484107e-04f, +4.074621699e-04f, +3.822318455e-04f, +2.865420942e-04f, +1.194703409e-04f, -1.065721740e-04f, -3.659939596e-04f, -6.229874085e-04f, -8.370019861e-04f, -9.698167423e-04f, -9.928547411e-04f, -8.932168303e-04f, -6.770885329e-04f, -3.696692020e-04f, -1.148458052e-05f, +3.482868123e-04f, +6.601946496e-04f, +8.829516200e-04f, +9.902567432e-04f, +9.746956122e-04f, +8.480412722e-04f, +6.380463451e-04f, +3.825376741e-04f, +1.221374013e-04f, -1.068677635e-04f, -2.781320935e-04f, -3.783873075e-04f, -4.077685417e-04f, -3.776097676e-04f, -3.064853506e-04f, -2.155449835e-04f, -1.241951985e-04f, -4.695088128e-05f, +8.102898992e-06f, +3.922482936e-05f, +4.965574704e-05f, +4.555149778e-05f, +3.382854534e-05f, +2.043206678e-05f,
        /*  1, 1 (48) */
        -4.652752077e-04f, -7.073330850e-04f, -9.507172034e-04f, -1.143457714e-03f, -1.214800150e-03f, -1.077152385e-03f, -6.304043582e-04f, +2.314272939e-04f, +1.611560287e-03f, +3.600422786e-03f, +6.265093734e-03f, +9.639224092e-03f, +1.371452376e-02f, +1.843485059e-02f, +2.369376918e-02f, +2.933616842e-02f, +3.516416220e-02f, +4.094708366e-02f, +4.643496283e-02f, +5.137449813e-02f, +5.552623746e-02f, +5.868150975e-02f, +6.067761781e-02f, +6.140992362e-02f, +6.083971990e-02f, +5.899716030e-02f, +5.597897586e-02f, +5.194119018e-02f, +4.708750705e-02f, +4.165443537e-02f, +3.589449444e-02f, +3.005898225e-02f, +2.438177768e-02f, +1.906548995e-02f, +1.427098728e-02f, +1.011096528e-02f, +6.647798202e-03f, +3.895498133e-03f, +1.825235046e-03f, +3.735789553e-04f, -5.475575367e-04f, -1.040361638e-03f, -1.210978797e-03f, -1.160661867e-03f, -9.788532173e-04f, -7.385661247e-04f, -4.941477229e-04f, -2.812464804e-04f,
        +7.070831898e-04f, +1.330048064e-03f, +2.099527963e-03f, +2.848941540e-03f, +3.303430386e-03f, +3.105780715e-03f, +1.876993960e-03f, -6.938618331e-04f, -4.745685971e-03f, -1.015032262e-02f, -1.645290111e-02f, -2.287098103e-02f, -2.836628136e-02f, -3.178784813e-02f, -3.206837136e-02f, -2.844003796e-02f, -2.062687439e-02f, -8.970019704e-03f, +5.548129250e-03f, +2.139673953e-02f, +3.669877956e-02f, +4.951162314e-02f, +5.813677344e-02f, +6.140099454e-02f, +5.885472945e-02f, +5.084890632e-02f, +3.847494801e-02f, +2.337985102e-02f, +7.492641605e-03f, -7.284976446e-03f, -1.936584064e-02f, -2.769150633e-02f, -3.183966178e-02f, -3.201418624e-02f, -2.893095555e-02f, -2.363160019e-02f, -1.726813182e-02f, -1.090208080e-02f, -5.353335318e-03f, -1.119074321e-03f, +1.633962169e-03f, +3.016018128e-03f, +3.322269995e-03f, +2.928595450e-03f, +2.198936630e-03f, +1.420572106e-03f, +7.738997028e-04f, +3.340740417e-04f,
        +1.422765568e-05f, +1.560484981e-05f, +1.436305556e-05f, +9.314872538e-06f, -6.806932534e-07f, -1.657438954e-05f, -3.897697936e-05f, -6.802063440e-05f, -1.032493727e-04f, -1.435551879e-04f, -1.871730634e-04f, -2.317426657e-04f, -2.744376758e-04f, -3.121561799e-04f, -3.417581727e-04f, -3.603299209e-04f, -3.654505292e-04f, -3.554341621e-04f, -3.295223672e-04f, -2.880048316e-04f, -2.322533521e-04f, -1.646621696e-04f, -8.849719227e-05f, -7.665992852e-06f, +7.357127629e-05f, +1.509236733e-04f, +2.203941213e-04f, +2.785767791e-04f, +3.228998788e-04f, +3.517925311e-04f, +3.647619571e-04f, +3.623768266e-04f, +3.461618466e-04f, +3.184173686e-04f, +2.819846545e-04f, +2.399818431e-04f, +1.955372004e-04f, +1.515448748e-04f, +1.104644002e-04f, +7.417918467e-05f, +4.392198589e-05f, +2.026779777e-05f, +3.187546744e-06f, -7.849719961e-06f, -1.374231680e-05f, -1.560691722e-05f, -1.463241434e-05f, -1.195157556e-05f,
        -3.214276087e-05f, -4.436582473e-05f, -4.979481204e-05f, -4.155286413e-05f, -1.327572638e-05f, +3.876242354e-05f, +1.135379940e-04f, +2.037943320e-04f, +2.957710268e-04f, +3.705313687e-04f, +4.069248265e-04f, +3.857975120e-04f, +2.946688243e-04f, +1.318381643e-04f, -9.114075986e-05f, -3.494423697e-04f, -6.077598419e-04f, -8.256423296e-04f, -9.645038563e-04f, -9.949671927e-04f, -9.030206730e-04f, -6.936207075e-04f, -3.908504078e-04f, -3.444745270e-05f, +3.267147364e-04f, +6.429475305e-04f, +8.722291410e-04f, +9.871724207e-04f, +9.791352228e-04f, +8.587516819e-04f, +6.529265948e-04f, +3.990637556e-04f, +1.378286001e-04f, -9.403526962e-05f, -2.694402545e-04f, -3.742622091e-04f, -4.078399572e-04f, -3.809102841e-04f, -3.117299173e-04f, -2.214225220e-04f, -1.296110609e-04f, -5.117885245e-05f, +5.373957843e-06f, +3.793880645e-05f, +4.950156984e-05f, +4.610103897e-05f, +3.466326372e-05f, +2.123200363e-05f,
        /*  1, 2 (48) */
        -4.510475520e-04f, -6.917282352e-04f, -9.363541479e-04f, -1.134142841e-03f, -1.215480844e-03f, -1.093726775e-03f, -6.693813375e-04f, +1.634066595e-04f, +1.508310914e-03f, +3.456867598e-03f, +6.077920671e-03f, +9.407481427e-03f, +1.344008609e-02f, +1.812269441e-02f, +2.335201101e-02f, +2.897583849e-02f, +3.479871167e-02f, +4.059164950e-02f, +4.610544046e-02f, +5.108649330e-02f, +5.529398411e-02f, +5.851684758e-02f, +6.058912062e-02f, +6.140225762e-02f, +6.091329118e-02f, +5.914808397e-02f, +5.619936998e-02f, +5.221976696e-02f, +4.741040693e-02f, +4.200622791e-02f, +3.625925639e-02f, +3.042135907e-02f, +2.472793953e-02f, +1.938390732e-02f, +1.455297193e-02f, +1.035094713e-02f, +6.843335402e-03f, +4.047043008e-03f, +1.935699446e-03f, +4.477581400e-04f, -5.036355508e-04f, -1.020093841e-03f, -1.207791250e-03f, -1.168511587e-03f, -9.925955341e-04f, -7.541730419e-04f, -5.087801372e-04f, -2.931980560e-04f,
        +6.749404290e-04f, +1.285682239e-03f, +2.049733151e-03f, +2.807388676e-03f, +3.290154659e-03f, +3.144543139e-03f, +1.990531954e-03f, -4.900675011e-04f, -4.449914944e-03f, -9.779791249e-03f, -1.604597628e-02f, -2.248518352e-02f, -2.807161254e-02f, -3.165600997e-02f, -3.215951212e-02f, -2.878948033e-02f, -2.123463423e-02f, -9.795662033e-03f, +4.583625394e-03f, +2.040177234e-02f, +3.579575888e-02f, +4.881800243e-02f, +5.774592303e-02f, +6.136654709e-02f, +5.918144419e-02f, +5.149185385e-02f, +3.934717715e-02f, +2.436702344e-02f, +8.471776828e-03f, -6.426224764e-03f, -1.871291404e-02f, -2.729244257e-02f, -3.170183318e-02f, -3.210822151e-02f, -2.920039581e-02f, -2.400586239e-02f, -1.767597177e-02f, -1.128299108e-02f, -5.665065235e-03f, -1.340496843e-03f, +1.504351108e-03f, +2.964839276e-03f, +3.327643953e-03f, +2.966534256e-03f, +2.248438199e-03f, +1.466673145e-03f, +8.085629665e-04f, +3.553060453e-04f,
        +1.408071968e-05f, +1.558336850e-05f, +1.453981342e-05f, +9.764132757e-06f, +1.083630892e-07f, -1.539454099e-05f, -3.738085809e-05f, -6.601627161e-05f, -1.008839801e-04f, -1.409175379e-04f, -1.843918961e-04f, -2.289808241e-04f, -2.718821271e-04f, -3.100045565e-04f, -3.402029042e-04f, -3.595413759e-04f, -3.655607915e-04f, -3.565231022e-04f, -3.316075217e-04f, -2.910362794e-04f, -2.361143096e-04f, -1.691754631e-04f, -9.343717126e-05f, -1.277488105e-05f, +6.856405736e-05f, +1.462809907e-04f, +2.163513340e-04f, +2.753244915e-04f, +3.205708032e-04f, +3.504535917e-04f, +3.644122164e-04f, +3.629512268e-04f, +3.475401762e-04f, +3.204373710e-04f, +2.844578309e-04f, +2.427103092e-04f, +1.983299454e-04f, +1.542319388e-04f, +1.129078005e-04f, +7.627984250e-05f, +4.562237634e-05f, +2.155051224e-05f, +4.070364810e-06f, -7.321345221e-06f, -1.350427756e-05f, -1.558585112e-05f, -1.475445480e-05f, -1.214962021e-05f,
        -3.129412251e-05f, -4.373296981e-05f, -4.978315839e-05f, -4.259753072e-05f, -1.572035894e-05f, +3.480403449e-05f, +1.083020469e-04f, +1.979296317e-04f, +2.903115805e-04f, +3.667638307e-04f, +4.061606045e-04f, +3.890861680e-04f, +3.025110613e-04f, +1.439666045e-04f, -7.585083792e-05f, -3.328925852e-04f, -5.923737374e-04f, -8.139709591e-04f, -9.587624439e-04f, -9.965951766e-04f, -9.123593490e-04f, -7.097829418e-04f, -4.118190680e-04f, -5.739146255e-05f, +3.049646014e-04f, +6.253558851e-04f, +8.610537897e-04f, +9.836012974e-04f, +9.831305814e-04f, +8.691248663e-04f, +6.676181426e-04f, +4.155623762e-04f, +1.536377706e-04f, -8.097790407e-05f, -2.604682208e-04f, -3.698550369e-04f, -4.076725437e-04f, -3.840448432e-04f, -3.168924946e-04f, -2.272957940e-04f, -1.350813291e-04f, -5.549442053e-05f, +2.549629309e-06f, +3.656974964e-05f, +4.928867322e-05f, +4.661950316e-05f, +3.549086016e-05f, +2.204092248e-05f,
        /*  1, 3 (48) */
        -4.369668323e-04f, -6.761448667e-04f, -9.218143344e-04f, -1.124378708e-03f, -1.215372481e-03f, -1.109121316e-03f, -7.067621956e-04f, +9.739038789e-05f, +1.407426934e-03f, +3.315950061e-03f, +5.893528775e-03f, +9.178500602e-03f, +1.316820396e-02f, +1.781268985e-02f, +2.301180811e-02f, +2.861629712e-02f, +3.443315088e-02f, +4.023512640e-02f, +4.577383294e-02f, +5.079545702e-02f, +5.505786980e-02f, +5.834767212e-02f, +6.049568345e-02f, +6.138948274e-02f, +6.098185524e-02f, +5.929436496e-02f, +5.641572132e-02f, +5.249509145e-02f, +4.773097773e-02f, +4.235668150e-02f, +3.662366861e-02f, +3.078431030e-02f, +2.507547970e-02f, +1.970434469e-02f, +1.483742976e-02f, +1.059365744e-02f, +7.041665348e-03f, +4.201274946e-03f, +2.048607246e-03f, +5.240379825e-04f, -4.580131745e-04f, -9.985433285e-04f, -1.203720885e-03f, -1.175832932e-03f, -1.006099812e-03f, -7.697588930e-04f, -5.235345920e-04f, -3.053476762e-04f,
        +6.436463064e-04f, +1.241949270e-03f, +1.999949993e-03f, +2.764791145e-03f, +3.274434301e-03f, +3.179347173e-03f, +2.098834001e-03f, -2.921378694e-04f, -4.159603364e-03f, -9.413027418e-03f, -1.563981567e-02f, -2.209609735e-02f, -2.776910148e-02f, -3.151204336e-02f, -3.223536296e-02f, -2.912237291e-02f, -2.182700797e-02f, -1.060963299e-02f, +3.624862950e-03f, +1.940517716e-02f, +3.488339953e-02f, +4.810821949e-02f, +5.733410396e-02f, +6.130915563e-02f, +5.948640879e-02f, +5.211720974e-02f, +4.020823094e-02f, +2.535062474e-02f, +9.454907409e-03f, -5.557099897e-03f, -1.804529590e-02f, -2.687688019e-02f, -3.154819541e-02f, -3.218919941e-02f, -2.946086403e-02f, -2.437571743e-02f, -1.808364432e-02f, -1.166703592e-02f, -5.981957730e-03f, -1.567792637e-03f, +1.369269778e-03f, +2.909344855e-03f, +3.330193582e-03f, +3.003104006e-03f, +2.297726873e-03f, +1.513292648e-03f, +8.440538267e-04f, +3.773469678e-04f,
        +1.392820018e-05f, +1.555196970e-05f, +1.470198130e-05f, +1.019427178e-05f, +8.744713867e-07f, -1.424017206e-05f, -3.581090067e-05f, -6.403646691e-05f, -9.853898309e-05f, -1.382935265e-04f, -1.816152396e-04f, -2.262124861e-04f, -2.693079297e-04f, -3.078219119e-04f, -3.386050587e-04f, -3.587005674e-04f, -3.656119364e-04f, -3.575496773e-04f, -3.336311662e-04f, -2.940113321e-04f, -2.399280361e-04f, -1.736541678e-04f, -9.835779378e-05f, -1.788110924e-05f, +6.354259999e-05f, +1.416082500e-04f, +2.122649289e-04f, +2.720182574e-04f, +3.181813609e-04f, +3.490520992e-04f, +3.640019265e-04f, +3.634708763e-04f, +3.488726530e-04f, +3.224226032e-04f, +2.869084686e-04f, +2.454285640e-04f, +2.011239334e-04f, +1.569300258e-04f, +1.153697583e-04f, +7.840403901e-05f, +4.734869143e-05f, +2.285914223e-05f, +4.977088548e-06f, -6.772549939e-06f, -1.325019189e-05f, -1.555342333e-05f, -1.486961808e-05f, -1.234467317e-05f,
        -3.044321659e-05f, -4.307558912e-05f, -4.971969849e-05f, -4.356446846e-05f, -1.807109303e-05f, +3.093743924e-05f, +1.031312945e-04f, +1.920774861e-04f, +2.847907589e-04f, +3.628510148e-04f, +4.051736998e-04f, +3.920998434e-04f, +3.100677915e-04f, +1.558512420e-04f, -6.070992062e-05f, -3.163542042e-04f, -5.768392143e-04f, -8.019966748e-04f, -9.525982357e-04f, -9.977400699e-04f, -9.212293605e-04f, -7.255672513e-04f, -4.325639655e-04f, -8.030404950e-05f, +2.830481549e-04f, +6.074286538e-04f, +8.494302580e-04f, +9.795432004e-04f, +9.866769511e-04f, +8.791526409e-04f, +6.821110234e-04f, +4.320236446e-04f, +1.695567592e-04f, -6.770091667e-05f, -2.512178480e-04f, -3.651644562e-04f, -4.072625452e-04f, -3.870083707e-04f, -3.219678548e-04f, -2.331603972e-04f, -1.406030499e-04f, -5.989628606e-05f, -3.702643188e-07f, +3.511644428e-05f, +4.901535501e-05f, +4.710521070e-05f, +3.631004035e-05f, +2.285808138e-05f,
        /*  1, 4 (48) */
        -4.230386322e-04f, -6.605928970e-04f, -9.071123531e-04f, -1.114184437e-03f, -1.214498009e-03f, -1.123361488e-03f, -7.425730963e-04f, +3.335392098e-05f, +1.308887951e-03f, +3.177656534e-03f, +5.711913535e-03f, +8.952288116e-03f, +1.289889603e-02f, +1.750486794e-02f, +2.267320305e-02f, +2.825759655e-02f, +3.406753894e-02f, +3.987757672e-02f, +4.544020177e-02f, +5.050144569e-02f, +5.481794176e-02f, +5.817401795e-02f, +6.039732565e-02f, +6.137160163e-02f, +6.104539784e-02f, +5.943597321e-02f, +5.662798625e-02f, +5.276710971e-02f, +4.804915909e-02f, +4.270573360e-02f, +3.698767054e-02f, +3.114778118e-02f, +2.542435236e-02f, +2.002676730e-02f, +1.512433823e-02f, +1.083908600e-02f, +7.242789281e-03f, +4.358204972e-03f, +2.163977005e-03f, +6.024420215e-04f, -4.106644831e-04f, -9.756841862e-04f, -1.198743797e-03f, -1.182605482e-03f, -1.019350004e-03f, -7.853123163e-04f, -5.384042101e-04f, -3.176923494e-04f,
        +6.132030899e-04f, +1.198873681e-03f, +1.950230294e-03f, +2.721226677e-03f, +3.256363208e-03f, +3.210284612e-03f, +2.201965296e-03f, -1.000603833e-04f, -3.874812605e-03f, -9.050176404e-03f, -1.523464198e-02f, -2.170399751e-02f, -2.745903369e-02f, -3.135619212e-02f, -3.229607288e-02f, -2.943872712e-02f, -2.240384718e-02f, -1.141162967e-02f, +2.672264714e-03f, +1.840743709e-02f, +3.396217017e-02f, +4.738265224e-02f, +5.690154000e-02f, +6.122885158e-02f, +5.976945695e-02f, +5.272463839e-02f, +4.105766120e-02f, +2.633016794e-02f, +1.044158436e-02f, -4.677947257e-03f, -1.736318488e-02f, -2.644485655e-02f, -3.137863865e-02f, -3.225690033e-02f, -2.971208187e-02f, -2.474088189e-02f, -1.849090686e-02f, -1.205404429e-02f, -6.303925585e-03f, -1.800953034e-03f, +1.228666729e-03f, +2.849448569e-03f, +3.329823318e-03f, +3.038220450e-03f, +2.346742228e-03f, +1.560397859e-03f, +8.803638670e-04f, +4.002050492e-04f,
        +1.377034793e-05f, +1.551093858e-05f, +1.484985257e-05f, +1.060555829e-05f, +1.617838952e-06f, -1.311117335e-05f, -3.426712759e-05f, -6.208139387e-05f, -9.621471868e-05f, -1.356836490e-04f, -1.788437260e-04f, -2.234383818e-04f, -2.667158598e-04f, -3.056090065e-04f, -3.369653145e-04f, -3.578080270e-04f, -3.656042935e-04f, -3.585139737e-04f, -3.355931220e-04f, -2.969295472e-04f, -2.436938494e-04f, -1.780974071e-04f, -1.032580523e-04f, -2.298361455e-05f, +5.850794175e-05f, +1.369063854e-04f, +2.081356675e-04f, +2.686586134e-04f, +3.157318305e-04f, +3.475880652e-04f, +3.635308455e-04f, +3.639353135e-04f, +3.501586466e-04f, +3.243723279e-04f, +2.893357895e-04f, +2.481358533e-04f, +2.039184901e-04f, +1.596385855e-04f, +1.178498758e-04f, +8.055153976e-05f, +4.910085537e-05f, +2.419375182e-05f, +5.907892698e-06f, -6.203084070e-06f, -1.297977154e-05f, -1.550934211e-05f, -1.497763796e-05f, -1.253651480e-05f,
        -2.959117339e-05f, -4.239527205e-05f, -4.960617699e-05f, -4.445510421e-05f, -2.032848599e-05f, +2.716344140e-05f, +9.802817553e-05f, +1.862418924e-04f, +2.792136228e-04f, +3.587981640e-04f, +4.039684070e-04f, +3.948407330e-04f, +3.173382086e-04f, +1.674878689e-04f, -4.572534974e-05f, -2.998367356e-04f, -5.611664122e-04f, -7.897284134e-04f, -9.460171984e-04f, -9.984035460e-04f, -9.296275127e-04f, -7.409659036e-04f, -4.530740344e-04f, -1.031726744e-04f, +2.609772578e-04f, +5.891750020e-04f, +8.373635309e-04f, +9.749982615e-04f, +9.897698548e-04f, +8.888269914e-04f, +6.963953288e-04f, +4.484376120e-04f, +1.855772631e-04f, -5.420976061e-05f, -2.416912049e-04f, -3.601893137e-04f, -4.066063268e-04f, -3.897958401e-04f, -3.269507481e-04f, -2.390118549e-04f, -1.461731693e-04f, -6.438304794e-05f, -3.385819329e-06f, +3.357772476e-05f, +4.867992751e-05f, +4.755646799e-05f, +3.711947890e-05f, +2.368270267e-05f,
        /*  1, 5 (48) */
        -4.092682842e-04f, -6.450819584e-04f, -8.922625006e-04f, -1.103578878e-03f, -1.212880170e-03f, -1.136472661e-03f, -7.768402239e-04f, -2.872747289e-05f, +1.212673232e-03f, +3.041972885e-03f, +5.533069809e-03f, +8.728849735e-03f, +1.263218017e-02f, +1.719925894e-02f, +2.233623773e-02f, +2.789978852e-02f, +3.370193465e-02f, +3.951906275e-02f, +4.510460865e-02f, +5.020451614e-02f, +5.457424791e-02f, +5.799592054e-02f, +6.029406760e-02f, +6.134861802e-02f, +6.110390578e-02f, +5.957287960e-02f, +5.683612192e-02f, +5.303576832e-02f, +4.836489092e-02f, +4.305332166e-02f, +3.735120138e-02f, +3.151171649e-02f, +2.577451100e-02f, +2.035113962e-02f, +1.541367402e-02f, +1.108722185e-02f, +7.446707771e-03f, +4.517843558e-03f, +2.281826881e-03f, +6.829935612e-04f, -3.615636277e-04f, -9.514904344e-04f, -1.192835904e-03f, -1.188808566e-03f, -1.032329775e-03f, -8.008216584e-04f, -5.533818481e-04f, -3.302288642e-04f,
        +5.836119165e-04f, +1.156478409e-03f, +1.900624117e-03f, +2.676771573e-03f, +3.236034722e-03f, +3.237448054e-03f, +2.299993471e-03f, +8.618150913e-05f, -3.595598982e-03f, -8.691378240e-03f, -1.483067357e-02f, -2.130915678e-02f, -2.714169548e-02f, -3.118870425e-02f, -3.234179823e-02f, -2.973856385e-02f, -2.296501360e-02f, -1.220135808e-02f, +1.726247516e-03f, +1.740903355e-02f, +3.303254266e-02f, +4.664168634e-02f, +5.644846596e-02f, +6.112567891e-02f, +6.003043421e-02f, +5.331381339e-02f, +4.189502473e-02f, +2.730516620e-02f, +1.143135421e-02f, -3.789120265e-03f, -1.666678955e-02f, -2.599641894e-02f, -3.119306139e-02f, -3.231111009e-02f, -2.995377308e-02f, -2.510107120e-02f, -1.889751319e-02f, -1.244384013e-02f, -6.630876333e-03f, -2.039964889e-03f, +1.082493559e-03f, +2.785065521e-03f, +3.326437498e-03f, +3.071798175e-03f, +2.395422155e-03f, +1.607954327e-03f, +9.174833459e-04f, +4.238877519e-04f,
        +1.360741082e-05f, +1.546055886e-05f, +1.498372103e-05f, +1.099826356e-05f, +2.338678028e-06f, -1.200742830e-05f, -3.274955044e-05f, -6.015121602e-05f, -9.391151370e-05f, -1.330883916e-04f, -1.760779795e-04f, -2.206592368e-04f, -2.641066927e-04f, -3.033666037e-04f, -3.352843568e-04f, -3.568642973e-04f, -3.655382063e-04f, -3.594160939e-04f, -3.374932277e-04f, -2.997904985e-04f, -2.474110810e-04f, -1.825043147e-04f, -1.081369454e-04f, -2.808133519e-05f, +5.346112415e-05f, +1.321763393e-04f, +2.039643239e-04f, +2.652461110e-04f, +3.132225075e-04f, +3.460615178e-04f, +3.629987460e-04f, +3.643440891e-04f, +3.513975353e-04f, +3.262858124e-04f, +2.917390162e-04f, +2.508314194e-04f, +2.067129352e-04f, +1.623570592e-04f, +1.203477449e-04f, +8.272210008e-05f, +5.087878289e-05f, +2.555439710e-05f, +6.862946083e-06f, -5.612701183e-06f, -1.269272958e-05f, -1.545331501e-05f, -1.507824593e-05f, -1.272492213e-05f,
        -2.873908892e-05f, -4.169358615e-05f, -4.944434125e-05f, -4.527090066e-05f, -2.249316533e-05f, +2.348274851e-05f, +9.299502465e-05f, +1.804267603e-04f, +2.735851890e-04f, +3.546105412e-04f, +4.025491149e-04f, +3.973111934e-04f, +3.243217116e-04f, +1.788724890e-04f, -3.090429259e-05f, -2.833495928e-04f, -5.453654837e-04f, -7.771752413e-04f, -9.390255295e-04f, -9.985875726e-04f, -9.375509149e-04f, -7.559714225e-04f, -4.733383682e-04f, -1.259848280e-04f, +2.387638760e-04f, +5.706043144e-04f, +8.248588837e-04f, +9.699669182e-04f, +9.924050797e-04f, +8.981400810e-04f, +7.104612148e-04f, +4.647942795e-04f, +2.016908352e-04f, -4.051009021e-05f, -2.318905738e-04f, -3.549286412e-04f, -4.057003792e-04f, -3.924022771e-04f, -3.318359064e-04f, -2.448456191e-04f, -1.517885333e-04f, -6.895320271e-05f, -6.497048873e-06f, +3.195247673e-05f, +4.828071952e-05f, +4.797156900e-05f, +3.791782005e-05f, +2.451397293e-05f,
        /*  1, 6 (48) */
        -3.956608734e-04f, -6.296213996e-04f, -8.772787795e-04f, -1.092580615e-03f, -1.210541492e-03f, -1.148480090e-03f, -8.095897743e-04f, -8.887868891e-05f, +1.118761719e-03f, +2.908884493e-03f, +5.356991830e-03f, +8.508190498e-03f, +1.236807348e-02f, +1.689589233e-02f, +2.200095338e-02f, +2.754292423e-02f, +3.333639644e-02f, +3.915964666e-02f, +4.476711542e-02f, +4.990472564e-02f, +5.432683683e-02f, +5.781341623e-02f, +6.018593065e-02f, +6.132053668e-02f, +6.115736690e-02f, +5.970505594e-02f, +5.704008624e-02f, +5.330101443e-02f, +4.867811343e-02f, +4.339938318e-02f, +3.771420013e-02f, +3.187606058e-02f, +2.612590854e-02f, +2.067742544e-02f, +1.570541304e-02f, +1.133805327e-02f, +7.653420706e-03f, +4.680200617e-03f, +2.402174625e-03f, +7.657156613e-04f, -3.106848448e-04f, -9.259360373e-04f, -1.185972958e-03f, -1.194421267e-03f, -1.045022505e-03f, -8.162749735e-04f, -5.684600940e-04f, -3.429537863e-04f,
        +5.548728275e-04f, +1.114784822e-03f, +1.851179776e-03f, +2.631500672e-03f, +3.213541556e-03f, +3.260930802e-03f, +2.392988496e-03f, +2.666082695e-04f, -3.322013793e-03f, -8.336767698e-03f, -1.442812445e-02f, -2.091184558e-02f, -2.681737377e-02f, -3.100983176e-02f, -3.237270252e-02f, -3.002191345e-02f, -2.351037908e-02f, -1.297853332e-02f, +7.872219866e-04f, +1.641044598e-02f, +3.209499175e-02f, +4.588571491e-02f, +5.597512760e-02f, +6.099969408e-02f, +6.026919808e-02f, +5.388441771e-02f, +4.271988361e-02f, +2.827513312e-02f, +1.242375929e-02f, -2.890980184e-03f, -1.595632833e-02f, -2.553162466e-02f, -3.099137055e-02f, -3.235162018e-02f, -3.018566365e-02f, -2.545599984e-02f, -1.930321357e-02f, -1.283624241e-02f, -6.962712239e-03f, -2.284810508e-03f, +9.307050260e-04f, +2.716112319e-03f, +3.319940450e-03f, +3.103750651e-03f, +2.443702875e-03f, +1.655925896e-03f, +9.554011660e-04f, +4.484017248e-04f,
        +1.343963384e-05f, +1.540111268e-05f, +1.510388072e-05f, +1.137266132e-05f, +3.037205637e-06f, -1.092881336e-05f, -3.125817198e-05f, -5.824608692e-05f, -9.162968470e-05f, -1.305082307e-04f, -1.733186168e-04f, -2.178757715e-04f, -2.614812022e-04f, -3.010954694e-04f, -3.335628777e-04f, -3.558699317e-04f, -3.654140322e-04f, -3.602561561e-04f, -3.393313383e-04f, -3.025937756e-04f, -2.510790765e-04f, -1.868740351e-04f, -1.129934779e-04f, -3.317321082e-05f, +4.840319232e-05f, +1.274190627e-04f, +1.997516844e-04f, +2.617813169e-04f, +3.106537038e-04f, +3.444725018e-04f, +3.624054162e-04f, +3.646967662e-04f, +3.525887067e-04f, +3.281623292e-04f, +2.941173722e-04f, +2.535145019e-04f, +2.095065816e-04f, +1.650848794e-04f, +1.228629477e-04f, +8.491546506e-05f, +5.268237913e-05f, +2.694112611e-05f, +7.842411460e-06f, -5.001158613e-06f, -1.238878055e-05f, -1.538504899e-05f, -1.517117127e-05f, -1.290966885e-05f,
        -2.788802465e-05f, -4.097207601e-05f, -4.923593954e-05f, -4.601335413e-05f, -2.456582673e-05f, +1.989597317e-05f, +8.803407223e-05f, +1.746359106e-04f, +2.679104263e-04f, +3.502934252e-04f, +4.009203018e-04f, +3.995137393e-04f, +3.310179034e-04f, +1.900013194e-04f, -1.625373835e-05f, -2.669020884e-04f, -5.294465871e-04f, -7.643463472e-04f, -9.316296518e-04f, -9.982944087e-04f, -9.449969818e-04f, -7.705765934e-04f, -4.933462266e-04f, -1.487280397e-04f, +2.164200722e-04f, +5.517261887e-04f, +8.119218791e-04f, +9.644499142e-04f, +9.945786815e-04f, +9.070842565e-04f, +7.242989091e-04f, +4.810836044e-04f, +2.178888888e-04f, -2.660775875e-05f, -2.218184512e-04f, -3.493816578e-04f, -4.045413228e-04f, -3.948227641e-04f, -3.366180478e-04f, -2.506570728e-04f, -1.574458887e-04f, -7.360514409e-05f, -9.703881282e-06f, +3.023963922e-05f, +4.781607847e-05f, +4.834879674e-05f, +3.870367843e-05f, +2.535104299e-05f,
        /*  1, 7 (48) */
        -3.822212396e-04f, -6.142202869e-04f, -8.621748988e-04f, -1.081207953e-03f, -1.207504287e-03f, -1.159408903e-03f, -8.408479463e-04f, -1.471247758e-04f, +1.027132034e-03f, +2.778376263e-03f, +5.183673213e-03f, +8.290314726e-03f, +1.210659227e-02f, +1.659479686e-02f, +2.166739050e-02f, +2.718705429e-02f, +3.297098241e-02f, +3.879939050e-02f, +4.442778408e-02f, +4.960213187e-02f, +5.407575776e-02f, +5.762654220e-02f, +6.007293718e-02f, +6.128736347e-02f, +6.120577010e-02f, +5.983247500e-02f, +5.723983792e-02f, +5.356279575e-02f, +4.898876714e-02f, +4.374385568e-02f, +3.807660555e-02f, +3.224075735e-02f, +2.647849724e-02f, +2.100558777e-02f, +1.599953041e-02f, +1.159156778e-02f, +7.862927288e-03f, +4.845285496e-03f, +2.525037573e-03f, +8.506311264e-04f, -2.580024657e-04f, -8.989949112e-04f, -1.178130546e-03f, -1.199422426e-03f, -1.057411285e-03f, -8.316600224e-04f, -5.836312653e-04f, -3.558634551e-04f,
        +5.269848029e-04f, +1.073812746e-03f, +1.801943836e-03f, +2.585487318e-03f, +3.188975729e-03f, +3.280826776e-03f, +2.481022568e-03f, +4.412441800e-04f, -3.054103367e-03f, -7.986474273e-03f, -1.402720415e-02f, -2.051233184e-02f, -2.648635586e-02f, -3.081983044e-02f, -3.238895626e-02f, -3.028881553e-02f, -2.403982567e-02f, -1.374287967e-02f, -1.444076651e-04f, +1.541215157e-02f, +3.114999476e-02f, +4.511513832e-02f, +5.548178137e-02f, +6.085096604e-02f, +6.048561815e-02f, +5.443614390e-02f, +4.353180549e-02f, +2.923958303e-02f, +1.341833798e-02f, -1.983895928e-03f, -1.523202942e-02f, -2.505054105e-02f, -3.077348167e-02f, -3.237822794e-02f, -3.040748210e-02f, -2.580538150e-02f, -1.970775489e-02f, -1.323106518e-02f, -7.299330287e-03f, -2.535467581e-03f, +7.732591374e-04f, +2.642507175e-03f, +3.310236568e-03f, +3.133990291e-03f, +2.491518953e-03f, +1.704274692e-03f, +9.941048444e-04f, +4.737527678e-04f,
        +1.326725904e-05f, +1.533288052e-05f, +1.521062582e-05f, +1.172902759e-05f, +3.713643442e-06f, -9.875198106e-06f, -2.979298624e-05f, -5.636615021e-05f, -8.936953796e-05f, -1.279436332e-04f, -1.705662467e-04f, -2.150887015e-04f, -2.588401603e-04f, -2.987963721e-04f, -3.318015757e-04f, -3.548254937e-04f, -3.652321423e-04f, -3.610342947e-04f, -3.411073257e-04f, -3.053389846e-04f, -2.546971958e-04f, -1.912057239e-04f, -1.178266614e-04f, -3.825818285e-05f, +4.333519473e-05f, +1.226355145e-04f, +1.954985477e-04f, +2.582648130e-04f, +3.080257478e-04f, +3.428210784e-04f, +3.617506595e-04f, +3.649929210e-04f, +3.537315574e-04f, +3.300011559e-04f, +2.964700822e-04f, +2.561843375e-04f, +2.122987367e-04f, +1.678214700e-04f, +1.253950564e-04f, +8.713136950e-05f, +5.451153963e-05f, +2.835397865e-05f, +8.846445392e-06f, -4.368217600e-06f, -1.206764059e-05f, -1.530425055e-05f, -1.525614110e-05f, -1.309052541e-05f,
        -2.703900717e-05f, -4.023226211e-05f, -4.898271918e-05f, -4.668399238e-05f, -2.654723195e-05f, +1.640363429e-05f, +8.314744426e-05f, +1.688730729e-04f, +2.621942529e-04f, +3.458521059e-04f, +3.990865308e-04f, +4.014510391e-04f, +3.374265890e-04f, +2.008707909e-04f, -1.780494609e-06f, -2.505034276e-04f, -5.134198790e-04f, -7.512510354e-04f, -9.238362079e-04f, -9.975266025e-04f, -9.519634345e-04f, -7.847744671e-04f, -5.130870425e-04f, -1.713898858e-04f, +1.939579981e-04f, +5.325504297e-04f, +7.985583642e-04f, +9.584483003e-04f, +9.962869878e-04f, +9.156520545e-04f, +7.378987183e-04f, +4.972955074e-04f, +2.341627031e-04f, -1.250881596e-05f, -2.114775483e-04f, -3.435477730e-04f, -4.031259119e-04f, -3.970524453e-04f, -3.412918803e-04f, -2.564415329e-04f, -1.631418845e-04f, -7.833716240e-05f, -1.300615846e-05f, +2.843820685e-05f, +4.728437245e-05f, +4.868642484e-05f, +3.947563984e-05f, +2.619302792e-05f,
        /*  1, 8 (48) */
        -3.689539805e-04f, -5.988874064e-04f, -8.469642730e-04f, -1.069478926e-03f, -1.203790643e-03f, -1.169284101e-03f, -8.706409326e-04f, -2.034909260e-04f, +9.377624959e-04f, +2.650432629e-03f, +5.013106966e-03f, +8.075226025e-03f, +1.184775211e-02f, +1.629600049e-02f, +2.133558892e-02f, +2.683222880e-02f, +3.260575027e-02f, +3.843835620e-02f, +4.408667676e-02f, +4.929679288e-02f, +5.382106056e-02f, +5.743533647e-02f, +5.995511052e-02f, +6.124910529e-02f, +6.124910529e-02f, +5.995511052e-02f, +5.743533647e-02f, +5.382106056e-02f, +4.929679288e-02f, +4.408667676e-02f, +3.843835620e-02f, +3.260575027e-02f, +2.683222880e-02f, +2.133558892e-02f, +1.629600049e-02f, +1.184775211e-02f, +8.075226025e-03f, +5.013106966e-03f, +2.650432629e-03f, +9.377624959e-04f, -2.034909260e-04f, -8.706409326e-04f, -1.169284101e-03f, -1.203790643e-03f, -1.069478926e-03f, -8.469642730e-04f, -5.988874064e-04f, -3.689539805e-04f,
        +4.999457957e-04f, +1.033580484e-03f, +1.752961117e-03f, +2.538803326e-03f, +3.162428497e-03f, +3.297230410e-03f, +2.564170012e-03f, +6.101172529e-04f, -2.791909114e-03f, -7.640622167e-03f, -1.362811762e-02f, -2.011088080e-02f, -2.614892927e-02f, -3.061895965e-02f, -3.239073675e-02f, -3.053931896e-02f, -2.455324555e-02f, -1.449413070e-02f, -1.068243873e-03f, +1.441462496e-02f, +3.019803133e-02f, +4.433036385e-02f, +5.496869433e-02f, +6.067957615e-02f, +6.067957615e-02f, +5.496869433e-02f, +4.433036385e-02f, +3.019803133e-02f, +1.441462496e-02f, -1.068243873e-03f, -1.449413070e-02f, -2.455324555e-02f, -3.053931896e-02f, -3.239073675e-02f, -3.061895965e-02f, -2.614892927e-02f, -2.011088080e-02f, -1.362811762e-02f, -7.640622167e-03f, -2.791909114e-03f, +6.101172529e-04f, +2.564170012e-03f, +3.297230410e-03f, +3.162428497e-03f, +2.538803326e-03f, +1.752961117e-03f, +1.033580484e-03f, +4.999457957e-04f,
        +1.309052541e-05f, +1.525614110e-05f, +1.530425055e-05f, +1.206764059e-05f, +4.368217600e-06f, -8.846445392e-06f, -2.835397865e-05f, -5.451153963e-05f, -8.713136950e-05f, -1.253950564e-04f, -1.678214700e-04f, -2.122987367e-04f, -2.561843375e-04f, -2.964700822e-04f, -3.300011559e-04f, -3.537315574e-04f, -3.649929210e-04f, -3.617506595e-04f, -3.428210784e-04f, -3.080257478e-04f, -2.582648130e-04f, -1.954985477e-04f, -1.226355145e-04f, -4.333519473e-05f, +3.825818285e-05f, +1.178266614e-04f, +1.912057239e-04f, +2.546971958e-04f, +3.053389846e-04f, +3.411073257e-04f, +3.610342947e-04f, +3.652321423e-04f, +3.548254937e-04f, +3.318015757e-04f, +2.987963721e-04f, +2.588401603e-04f, +2.150887015e-04f, +1.705662467e-04f, +1.279436332e-04f, +8.936953796e-05f, +5.636615021e-05f, +2.979298624e-05f, +9.875198106e-06f, -3.713643442e-06f, -1.172902759e-05f, -1.521062582e-05f, -1.533288052e-05f, -1.326725904e-05f,
        -2.619302792e-05f, -3.947563984e-05f, -4.868642484e-05f, -4.728437245e-05f, -2.843820685e-05f, +1.300615846e-05f, +7.833716240e-05f, +1.631418845e-04f, +2.564415329e-04f, +3.412918803e-04f, +3.970524453e-04f, +4.031259119e-04f, +3.435477730e-04f, +2.114775483e-04f, +1.250881596e-05f, -2.341627031e-04f, -4.972955074e-04f, -7.378987183e-04f, -9.156520545e-04f, -9.962869878e-04f, -9.584483003e-04f, -7.985583642e-04f, -5.325504297e-04f, -1.939579981e-04f, +1.713898858e-04f, +5.130870425e-04f, +7.847744671e-04f, +9.519634345e-04f, +9.975266025e-04f, +9.238362079e-04f, +7.512510354e-04f, +5.134198790e-04f, +2.505034276e-04f, +1.780494609e-06f, -2.008707909e-04f, -3.374265890e-04f, -4.014510391e-04f, -3.990865308e-04f, -3.458521059e-04f, -2.621942529e-04f, -1.688730729e-04f, -8.314744426e-05f, -1.640363429e-05f, +2.654723195e-05f, +4.668399238e-05f, +4.898271918e-05f, +4.023226211e-05f, +2.703900717e-05f,
        /*  1, 9 (48) */
        -3.558634551e-04f, -5.836312653e-04f, -8.316600224e-04f, -1.057411285e-03f, -1.199422426e-03f, -1.178130546e-03f, -8.989949112e-04f, -2.580024657e-04f, +8.506311264e-04f, +2.525037573e-03f, +4.845285496e-03f, +7.862927288e-03f, +1.159156778e-02f, +1.599953041e-02f, +2.100558777e-02f, +2.647849724e-02f, +3.224075735e-02f, +3.807660555e-02f, +4.374385568e-02f, +4.898876714e-02f, +5.356279575e-02f, +5.723983792e-02f, +5.983247500e-02f, +6.120577010e-02f, +6.128736347e-02f, +6.007293718e-02f, +5.762654220e-02f, +5.407575776e-02f, +4.960213187e-02f, +4.442778408e-02f, +3.879939050e-02f, +3.297098241e-02f, +2.718705429e-02f, +2.166739050e-02f, +1.659479686e-02f, +1.210659227e-02f, +8.290314726e-03f, +5.183673213e-03f, +2.778376263e-03f, +1.027132034e-03f, -1.471247758e-04f, -8.408479463e-04f, -1.159408903e-03f, -1.207504287e-03f, -1.081207953e-03f, -8.621748988e-04f, -6.142202869e-04f, -3.822212396e-04f,
        +4.737527678e-04f, +9.941048444e-04f, +1.704274692e-03f, +2.491518953e-03f, +3.133990291e-03f, +3.310236568e-03f, +2.642507175e-03f, +7.732591374e-04f, -2.535467581e-03f, -7.299330287e-03f, -1.323106518e-02f, -1.970775489e-02f, -2.580538150e-02f, -3.040748210e-02f, -3.237822794e-02f, -3.077348167e-02f, -2.505054105e-02f, -1.523202942e-02f, -1.983895928e-03f, +1.341833798e-02f, +2.923958303e-02f, +4.353180549e-02f, +5.443614390e-02f, +6.048561815e-02f, +6.085096604e-02f, +5.548178137e-02f, +4.511513832e-02f, +3.114999476e-02f, +1.541215157e-02f, -1.444076651e-04f, -1.374287967e-02f, -2.403982567e-02f, -3.028881553e-02f, -3.238895626e-02f, -3.081983044e-02f, -2.648635586e-02f, -2.051233184e-02f, -1.402720415e-02f, -7.986474273e-03f, -3.054103367e-03f, +4.412441800e-04f, +2.481022568e-03f, +3.280826776e-03f, +3.188975729e-03f, +2.585487318e-03f, +1.801943836e-03f, +1.073812746e-03f, +5.269848029e-04f,
        +1.290966885e-05f, +1.517117127e-05f, +1.538504899e-05f, +1.238878055e-05f, +5.001158613e-06f, -7.842411460e-06f, -2.694112611e-05f, -5.268237913e-05f, -8.491546506e-05f, -1.228629477e-04f, -1.650848794e-04f, -2.095065816e-04f, -2.535145019e-04f, -2.941173722e-04f, -3.281623292e-04f, -3.525887067e-04f, -3.646967662e-04f, -3.624054162e-04f, -3.444725018e-04f, -3.106537038e-04f, -2.617813169e-04f, -1.997516844e-04f, -1.274190627e-04f, -4.840319232e-05f, +3.317321082e-05f, +1.129934779e-04f, +1.868740351e-04f, +2.510790765e-04f, +3.025937756e-04f, +3.393313383e-04f, +3.602561561e-04f, +3.654140322e-04f, +3.558699317e-04f, +3.335628777e-04f, +3.010954694e-04f, +2.614812022e-04f, +2.178757715e-04f, +1.733186168e-04f, +1.305082307e-04f, +9.162968470e-05f, +5.824608692e-05f, +3.125817198e-05f, +1.092881336e-05f, -3.037205637e-06f, -1.137266132e-05f, -1.510388072e-05f, -1.540111268e-05f, -1.343963384e-05f,
        -2.535104299e-05f, -3.870367843e-05f, -4.834879674e-05f, -4.781607847e-05f, -3.023963922e-05f, +9.703881282e-06f, +7.360514409e-05f, +1.574458887e-04f, +2.506570728e-04f, +3.366180478e-04f, +3.948227641e-04f, +4.045413228e-04f, +3.493816578e-04f, +2.218184512e-04f, +2.660775875e-05f, -2.178888888e-04f, -4.810836044e-04f, -7.242989091e-04f, -9.070842565e-04f, -9.945786815e-04f, -9.644499142e-04f, -8.119218791e-04f, -5.517261887e-04f, -2.164200722e-04f, +1.487280397e-04f, +4.933462266e-04f, +7.705765934e-04f, +9.449969818e-04f, +9.982944087e-04f, +9.316296518e-04f, +7.643463472e-04f, +5.294465871e-04f, +2.669020884e-04f, +1.625373835e-05f, -1.900013194e-04f, -3.310179034e-04f, -3.995137393e-04f, -4.009203018e-04f, -3.502934252e-04f, -2.679104263e-04f, -1.746359106e-04f, -8.803407223e-05f, -1.989597317e-05f, +2.456582673e-05f, +4.601335413e-05f, +4.923593954e-05f, +4.097207601e-05f, +2.788802465e-05f,
        /*  1,10 (48) */
        -3.429537863e-04f, -5.684600940e-04f, -8.162749735e-04f, -1.045022505e-03f, -1.194421267e-03f, -1.185972958e-03f, -9.259360373e-04f, -3.106848448e-04f, +7.657156613e-04f, +2.402174625e-03f, +4.680200617e-03f, +7.653420706e-03f, +1.133805327e-02f, +1.570541304e-02f, +2.067742544e-02f, +2.612590854e-02f, +3.187606058e-02f, +3.771420013e-02f, +4.339938318e-02f, +4.867811343e-02f, +5.330101443e-02f, +5.704008624e-02f, +5.970505594e-02f, +6.115736690e-02f, +6.132053668e-02f, +6.018593065e-02f, +5.781341623e-02f, +5.432683683e-02f, +4.990472564e-02f, +4.476711542e-02f, +3.915964666e-02f, +3.333639644e-02f, +2.754292423e-02f, +2.200095338e-02f, +1.689589233e-02f, +1.236807348e-02f, +8.508190498e-03f, +5.356991830e-03f, +2.908884493e-03f, +1.118761719e-03f, -8.887868891e-05f, -8.095897743e-04f, -1.148480090e-03f, -1.210541492e-03f, -1.092580615e-03f, -8.772787795e-04f, -6.296213996e-04f, -3.956608734e-04f,
        +4.484017248e-04f, +9.554011660e-04f, +1.655925896e-03f, +2.443702875e-03f, +3.103750651e-03f, +3.319940450e-03f, +2.716112319e-03f, +9.307050260e-04f, -2.284810508e-03f, -6.962712239e-03f, -1.283624241e-02f, -1.930321357e-02f, -2.545599984e-02f, -3.018566365e-02f, -3.235162018e-02f, -3.099137055e-02f, -2.553162466e-02f, -1.595632833e-02f, -2.890980184e-03f, +1.242375929e-02f, +2.827513312e-02f, +4.271988361e-02f, +5.388441771e-02f, +6.026919808e-02f, +6.099969408e-02f, +5.597512760e-02f, +4.588571491e-02f, +3.209499175e-02f, +1.641044598e-02f, +7.872219866e-04f, -1.297853332e-02f, -2.351037908e-02f, -3.002191345e-02f, -3.237270252e-02f, -3.100983176e-02f, -2.681737377e-02f, -2.091184558e-02f, -1.442812445e-02f, -8.336767698e-03f, -3.322013793e-03f, +2.666082695e-04f, +2.392988496e-03f, +3.260930802e-03f, +3.213541556e-03f, +2.631500672e-03f, +1.851179776e-03f, +1.114784822e-03f, +5.548728275e-04f,
        +1.272492213e-05f, +1.507824593e-05f, +1.545331501e-05f, +1.269272958e-05f, +5.612701183e-06f, -6.862946083e-06f, -2.555439710e-05f, -5.087878289e-05f, -8.272210008e-05f, -1.203477449e-04f, -1.623570592e-04f, -2.067129352e-04f, -2.508314194e-04f, -2.917390162e-04f, -3.262858124e-04f, -3.513975353e-04f, -3.643440891e-04f, -3.629987460e-04f, -3.460615178e-04f, -3.132225075e-04f, -2.652461110e-04f, -2.039643239e-04f, -1.321763393e-04f, -5.346112415e-05f, +2.808133519e-05f, +1.081369454e-04f, +1.825043147e-04f, +2.474110810e-04f, +2.997904985e-04f, +3.374932277e-04f, +3.594160939e-04f, +3.655382063e-04f, +3.568642973e-04f, +3.352843568e-04f, +3.033666037e-04f, +2.641066927e-04f, +2.206592368e-04f, +1.760779795e-04f, +1.330883916e-04f, +9.391151370e-05f, +6.015121602e-05f, +3.274955044e-05f, +1.200742830e-05f, -2.338678028e-06f, -1.099826356e-05f, -1.498372103e-05f, -1.546055886e-05f, -1.360741082e-05f,
        -2.451397293e-05f, -3.791782005e-05f, -4.797156900e-05f, -4.828071952e-05f, -3.195247673e-05f, +6.497048873e-06f, +6.895320271e-05f, +1.517885333e-04f, +2.448456191e-04f, +3.318359064e-04f, +3.924022771e-04f, +4.057003792e-04f, +3.549286412e-04f, +2.318905738e-04f, +4.051009021e-05f, -2.016908352e-04f, -4.647942795e-04f, -7.104612148e-04f, -8.981400810e-04f, -9.924050797e-04f, -9.699669182e-04f, -8.248588837e-04f, -5.706043144e-04f, -2.387638760e-04f, +1.259848280e-04f, +4.733383682e-04f, +7.559714225e-04f, +9.375509149e-04f, +9.985875726e-04f, +9.390255295e-04f, +7.771752413e-04f, +5.453654837e-04f, +2.833495928e-04f, +3.090429259e-05f, -1.788724890e-04f, -3.243217116e-04f, -3.973111934e-04f, -4.025491149e-04f, -3.546105412e-04f, -2.735851890e-04f, -1.804267603e-04f, -9.299502465e-05f, -2.348274851e-05f, +2.249316533e-05f, +4.527090066e-05f, +4.944434125e-05f, +4.169358615e-05f, +2.873908892e-05f,
        /*  1,11 (48) */
        -3.302288642e-04f, -5.533818481e-04f, -8.008216584e-04f, -1.032329775e-03f, -1.188808566e-03f, -1.192835904e-03f, -9.514904344e-04f, -3.615636277e-04f, +6.829935612e-04f, +2.281826881e-03f, +4.517843558e-03f, +7.446707771e-03f, +1.108722185e-02f, +1.541367402e-02f, +2.035113962e-02f, +2.577451100e-02f, +3.151171649e-02f, +3.735120138e-02f, +4.305332166e-02f, +4.836489092e-02f, +5.303576832e-02f, +5.683612192e-02f, +5.957287960e-02f, +6.110390578e-02f, +6.134861802e-02f, +6.029406760e-02f, +5.799592054e-02f, +5.457424791e-02f, +5.020451614e-02f, +4.510460865e-02f, +3.951906275e-02f, +3.370193465e-02f, +2.789978852e-02f, +2.233623773e-02f, +1.719925894e-02f, +1.263218017e-02f, +8.728849735e-03f, +5.533069809e-03f, +3.041972885e-03f, +1.212673232e-03f, -2.872747289e-05f, -7.768402239e-04f, -1.136472661e-03f, -1.212880170e-03f, -1.103578878e-03f, -8.922625006e-04f, -6.450819584e-04f, -4.092682842e-04f,
        +4.238877519e-04f, +9.174833459e-04f, +1.607954327e-03f, +2.395422155e-03f, +3.071798175e-03f, +3.326437498e-03f, +2.785065521e-03f, +1.082493559e-03f, -2.039964889e-03f, -6.630876333e-03f, -1.244384013e-02f, -1.889751319e-02f, -2.510107120e-02f, -2.995377308e-02f, -3.231111009e-02f, -3.119306139e-02f, -2.599641894e-02f, -1.666678955e-02f, -3.789120265e-03f, +1.143135421e-02f, +2.730516620e-02f, +4.189502473e-02f, +5.331381339e-02f, +6.003043421e-02f, +6.112567891e-02f, +5.644846596e-02f, +4.664168634e-02f, +3.303254266e-02f, +1.740903355e-02f, +1.726247516e-03f, -1.220135808e-02f, -2.296501360e-02f, -2.973856385e-02f, -3.234179823e-02f, -3.118870425e-02f, -2.714169548e-02f, -2.130915678e-02f, -1.483067357e-02f, -8.691378240e-03f, -3.595598982e-03f, +8.618150913e-05f, +2.299993471e-03f, +3.237448054e-03f, +3.236034722e-03f, +2.676771573e-03f, +1.900624117e-03f, +1.156478409e-03f, +5.836119165e-04f,
        +1.253651480e-05f, +1.497763796e-05f, +1.550934211e-05f, +1.297977154e-05f, +6.203084070e-06f, -5.907892698e-06f, -2.419375182e-05f, -4.910085537e-05f, -8.055153976e-05f, -1.178498758e-04f, -1.596385855e-04f, -2.039184901e-04f, -2.481358533e-04f, -2.893357895e-04f, -3.243723279e-04f, -3.501586466e-04f, -3.639353135e-04f, -3.635308455e-04f, -3.475880652e-04f, -3.157318305e-04f, -2.686586134e-04f, -2.081356675e-04f, -1.369063854e-04f, -5.850794175e-05f, +2.298361455e-05f, +1.032580523e-04f, +1.780974071e-04f, +2.436938494e-04f, +2.969295472e-04f, +3.355931220e-04f, +3.585139737e-04f, +3.656042935e-04f, +3.578080270e-04f, +3.369653145e-04f, +3.056090065e-04f, +2.667158598e-04f, +2.234383818e-04f, +1.788437260e-04f, +1.356836490e-04f, +9.621471868e-05f, +6.208139387e-05f, +3.426712759e-05f, +1.311117335e-05f, -1.617838952e-06f, -1.060555829e-05f, -1.484985257e-05f, -1.551093858e-05f, -1.377034793e-05f,
        -2.368270267e-05f, -3.711947890e-05f, -4.755646799e-05f, -4.867992751e-05f, -3.357772476e-05f, +3.385819329e-06f, +6.438304794e-05f, +1.461731693e-04f, +2.390118549e-04f, +3.269507481e-04f, +3.897958401e-04f, +4.066063268e-04f, +3.601893137e-04f, +2.416912049e-04f, +5.420976061e-05f, -1.855772631e-04f, -4.484376120e-04f, -6.963953288e-04f, -8.888269914e-04f, -9.897698548e-04f, -9.749982615e-04f, -8.373635309e-04f, -5.891750020e-04f, -2.609772578e-04f, +1.031726744e-04f, +4.530740344e-04f, +7.409659036e-04f, +9.296275127e-04f, +9.984035460e-04f, +9.460171984e-04f, +7.897284134e-04f, +5.611664122e-04f, +2.998367356e-04f, +4.572534974e-05f, -1.674878689e-04f, -3.173382086e-04f, -3.948407330e-04f, -4.039684070e-04f, -3.587981640e-04f, -2.792136228e-04f, -1.862418924e-04f, -9.802817553e-05f, -2.716344140e-05f, +2.032848599e-05f, +4.445510421e-05f, +4.960617699e-05f, +4.239527205e-05f, +2.959117339e-05f,
        /*  1,12 (48) */
        -3.176923494e-04f, -5.384042101e-04f, -7.853123163e-04f, -1.019350004e-03f, -1.182605482e-03f, -1.198743797e-03f, -9.756841862e-04f, -4.106644831e-04f, +6.024420215e-04f, +2.163977005e-03f, +4.358204972e-03f, +7.242789281e-03f, +1.083908600e-02f, +1.512433823e-02f, +2.002676730e-02f, +2.542435236e-02f, +3.114778118e-02f, +3.698767054e-02f, +4.270573360e-02f, +4.804915909e-02f, +5.276710971e-02f, +5.662798625e-02f, +5.943597321e-02f, +6.104539784e-02f, +6.137160163e-02f, +6.039732565e-02f, +5.817401795e-02f, +5.481794176e-02f, +5.050144569e-02f, +4.544020177e-02f, +3.987757672e-02f, +3.406753894e-02f, +2.825759655e-02f, +2.267320305e-02f, +1.750486794e-02f, +1.289889603e-02f, +8.952288116e-03f, +5.711913535e-03f, +3.177656534e-03f, +1.308887951e-03f, +3.335392098e-05f, -7.425730963e-04f, -1.123361488e-03f, -1.214498009e-03f, -1.114184437e-03f, -9.071123531e-04f, -6.605928970e-04f, -4.230386322e-04f,
        +4.002050492e-04f, +8.803638670e-04f, +1.560397859e-03f, +2.346742228e-03f, +3.038220450e-03f, +3.329823318e-03f, +2.849448569e-03f, +1.228666729e-03f, -1.800953034e-03f, -6.303925585e-03f, -1.205404429e-02f, -1.849090686e-02f, -2.474088189e-02f, -2.971208187e-02f, -3.225690033e-02f, -3.137863865e-02f, -2.644485655e-02f, -1.736318488e-02f, -4.677947257e-03f, +1.044158436e-02f, +2.633016794e-02f, +4.105766120e-02f, +5.272463839e-02f, +5.976945695e-02f, +6.122885158e-02f, +5.690154000e-02f, +4.738265224e-02f, +3.396217017e-02f, +1.840743709e-02f, +2.672264714e-03f, -1.141162967e-02f, -2.240384718e-02f, -2.943872712e-02f, -3.229607288e-02f, -3.135619212e-02f, -2.745903369e-02f, -2.170399751e-02f, -1.523464198e-02f, -9.050176404e-03f, -3.874812605e-03f, -1.000603833e-04f, +2.201965296e-03f, +3.210284612e-03f, +3.256363208e-03f, +2.721226677e-03f, +1.950230294e-03f, +1.198873681e-03f, +6.132030899e-04f,
        +1.234467317e-05f, +1.486961808e-05f, +1.555342333e-05f, +1.325019189e-05f, +6.772549939e-06f, -4.977088548e-06f, -2.285914223e-05f, -4.734869143e-05f, -7.840403901e-05f, -1.153697583e-04f, -1.569300258e-04f, -2.011239334e-04f, -2.454285640e-04f, -2.869084686e-04f, -3.224226032e-04f, -3.488726530e-04f, -3.634708763e-04f, -3.640019265e-04f, -3.490520992e-04f, -3.181813609e-04f, -2.720182574e-04f, -2.122649289e-04f, -1.416082500e-04f, -6.354259999e-05f, +1.788110924e-05f, +9.835779378e-05f, +1.736541678e-04f, +2.399280361e-04f, +2.940113321e-04f, +3.336311662e-04f, +3.575496773e-04f, +3.656119364e-04f, +3.587005674e-04f, +3.386050587e-04f, +3.078219119e-04f, +2.693079297e-04f, +2.262124861e-04f, +1.816152396e-04f, +1.382935265e-04f, +9.853898309e-05f, +6.403646691e-05f, +3.581090067e-05f, +1.424017206e-05f, -8.744713867e-07f, -1.019427178e-05f, -1.470198130e-05f, -1.555196970e-05f, -1.392820018e-05f,
        -2.285808138e-05f, -3.631004035e-05f, -4.710521070e-05f, -4.901535501e-05f, -3.511644428e-05f, +3.702643188e-07f, +5.989628606e-05f, +1.406030499e-04f, +2.331603972e-04f, +3.219678548e-04f, +3.870083707e-04f, +4.072625452e-04f, +3.651644562e-04f, +2.512178480e-04f, +6.770091667e-05f, -1.695567592e-04f, -4.320236446e-04f, -6.821110234e-04f, -8.791526409e-04f, -9.866769511e-04f, -9.795432004e-04f, -8.494302580e-04f, -6.074286538e-04f, -2.830481549e-04f, +8.030404950e-05f, +4.325639655e-04f, +7.255672513e-04f, +9.212293605e-04f, +9.977400699e-04f, +9.525982357e-04f, +8.019966748e-04f, +5.768392143e-04f, +3.163542042e-04f, +6.070992062e-05f, -1.558512420e-04f, -3.100677915e-04f, -3.920998434e-04f, -4.051736998e-04f, -3.628510148e-04f, -2.847907589e-04f, -1.920774861e-04f, -1.031312945e-04f, -3.093743924e-05f, +1.807109303e-05f, +4.356446846e-05f, +4.971969849e-05f, +4.307558912e-05f, +3.044321659e-05f,
        /*  1,13 (48) */
        -3.053476762e-04f, -5.235345920e-04f, -7.697588930e-04f, -1.006099812e-03f, -1.175832932e-03f, -1.203720885e-03f, -9.985433285e-04f, -4.580131745e-04f, +5.240379825e-04f, +2.048607246e-03f, +4.201274946e-03f, +7.041665348e-03f, +1.059365744e-02f, +1.483742976e-02f, +1.970434469e-02f, +2.507547970e-02f, +3.078431030e-02f, +3.662366861e-02f, +4.235668150e-02f, +4.773097773e-02f, +5.249509145e-02f, +5.641572132e-02f, +5.929436496e-02f, +6.098185524e-02f, +6.138948274e-02f, +6.049568345e-02f, +5.834767212e-02f, +5.505786980e-02f, +5.079545702e-02f, +4.577383294e-02f, +4.023512640e-02f, +3.443315088e-02f, +2.861629712e-02f, +2.301180811e-02f, +1.781268985e-02f, +1.316820396e-02f, +9.178500602e-03f, +5.893528775e-03f, +3.315950061e-03f, +1.407426934e-03f, +9.739038789e-05f, -7.067621956e-04f, -1.109121316e-03f, -1.215372481e-03f, -1.124378708e-03f, -9.218143344e-04f, -6.761448667e-04f, -4.369668323e-04f,
        +3.773469678e-04f, +8.440538267e-04f, +1.513292648e-03f, +2.297726873e-03f, +3.003104006e-03f, +3.330193582e-03f, +2.909344855e-03f, +1.369269778e-03f, -1.567792637e-03f, -5.981957730e-03f, -1.166703592e-02f, -1.808364432e-02f, -2.437571743e-02f, -2.946086403e-02f, -3.218919941e-02f, -3.154819541e-02f, -2.687688019e-02f, -1.804529590e-02f, -5.557099897e-03f, +9.454907409e-03f, +2.535062474e-02f, +4.020823094e-02f, +5.211720974e-02f, +5.948640879e-02f, +6.130915563e-02f, +5.733410396e-02f, +4.810821949e-02f, +3.488339953e-02f, +1.940517716e-02f, +3.624862950e-03f, -1.060963299e-02f, -2.182700797e-02f, -2.912237291e-02f, -3.223536296e-02f, -3.151204336e-02f, -2.776910148e-02f, -2.209609735e-02f, -1.563981567e-02f, -9.413027418e-03f, -4.159603364e-03f, -2.921378694e-04f, +2.098834001e-03f, +3.179347173e-03f, +3.274434301e-03f, +2.764791145e-03f, +1.999949993e-03f, +1.241949270e-03f, +6.436463064e-04f,
        +1.214962021e-05f, +1.475445480e-05f, +1.558585112e-05f, +1.350427756e-05f, +7.321345221e-06f, -4.070364810e-06f, -2.155051224e-05f, -4.562237634e-05f, -7.627984250e-05f, -1.129078005e-04f, -1.542319388e-04f, -1.983299454e-04f, -2.427103092e-04f, -2.844578309e-04f, -3.204373710e-04f, -3.475401762e-04f, -3.629512268e-04f, -3.644122164e-04f, -3.504535917e-04f, -3.205708032e-04f, -2.753244915e-04f, -2.163513340e-04f, -1.462809907e-04f, -6.856405736e-05f, +1.277488105e-05f, +9.343717126e-05f, +1.691754631e-04f, +2.361143096e-04f, +2.910362794e-04f, +3.316075217e-04f, +3.565231022e-04f, +3.655607915e-04f, +3.595413759e-04f, +3.402029042e-04f, +3.100045565e-04f, +2.718821271e-04f, +2.289808241e-04f, +1.843918961e-04f, +1.409175379e-04f, +1.008839801e-04f, +6.601627161e-05f, +3.738085809e-05f, +1.539454099e-05f, -1.083630892e-07f, -9.764132757e-06f, -1.453981342e-05f, -1.558336850e-05f, -1.408071968e-05f,
        -2.204092248e-05f, -3.549086016e-05f, -4.661950316e-05f, -4.928867322e-05f, -3.656974964e-05f, -2.549629309e-06f, +5.549442053e-05f, +1.350813291e-04f, +2.272957940e-04f, +3.168924946e-04f, +3.840448432e-04f, +4.076725437e-04f, +3.698550369e-04f, +2.604682208e-04f, +8.097790407e-05f, -1.536377706e-04f, -4.155623762e-04f, -6.676181426e-04f, -8.691248663e-04f, -9.831305814e-04f, -9.836012974e-04f, -8.610537897e-04f, -6.253558851e-04f, -3.049646014e-04f, +5.739146255e-05f, +4.118190680e-04f, +7.097829418e-04f, +9.123593490e-04f, +9.965951766e-04f, +9.587624439e-04f, +8.139709591e-04f, +5.923737374e-04f, +3.328925852e-04f, +7.585083792e-05f, -1.439666045e-04f, -3.025110613e-04f, -3.890861680e-04f, -4.061606045e-04f, -3.667638307e-04f, -2.903115805e-04f, -1.979296317e-04f, -1.083020469e-04f, -3.480403449e-05f, +1.572035894e-05f, +4.259753072e-05f, +4.978315839e-05f, +4.373296981e-05f, +3.129412251e-05f,
        /*  1,14 (48) */
        -2.931980560e-04f, -5.087801372e-04f, -7.541730419e-04f, -9.925955341e-04f, -1.168511587e-03f, -1.207791250e-03f, -1.020093841e-03f, -5.036355508e-04f, +4.477581400e-04f, +1.935699446e-03f, +4.047043008e-03f, +6.843335402e-03f, +1.035094713e-02f, +1.455297193e-02f, +1.938390732e-02f, +2.472793953e-02f, +3.042135907e-02f, +3.625925639e-02f, +4.200622791e-02f, +4.741040693e-02f, +5.221976696e-02f, +5.619936998e-02f, +5.914808397e-02f, +6.091329118e-02f, +6.140225762e-02f, +6.058912062e-02f, +5.851684758e-02f, +5.529398411e-02f, +5.108649330e-02f, +4.610544046e-02f, +4.059164950e-02f, +3.479871167e-02f, +2.897583849e-02f, +2.335201101e-02f, +1.812269441e-02f, +1.344008609e-02f, +9.407481427e-03f, +6.077920671e-03f, +3.456867598e-03f, +1.508310914e-03f, +1.634066595e-04f, -6.693813375e-04f, -1.093726775e-03f, -1.215480844e-03f, -1.134142841e-03f, -9.363541479e-04f, -6.917282352e-04f, -4.510475520e-04f,
        +3.553060453e-04f, +8.085629665e-04f, +1.466673145e-03f, +2.248438199e-03f, +2.966534256e-03f, +3.327643953e-03f, +2.964839276e-03f, +1.504351108e-03f, -1.340496843e-03f, -5.665065235e-03f, -1.128299108e-02f, -1.767597177e-02f, -2.400586239e-02f, -2.920039581e-02f, -3.210822151e-02f, -3.170183318e-02f, -2.729244257e-02f, -1.871291404e-02f, -6.426224764e-03f, +8.471776828e-03f, +2.436702344e-02f, +3.934717715e-02f, +5.149185385e-02f, +5.918144419e-02f, +6.136654709e-02f, +5.774592303e-02f, +4.881800243e-02f, +3.579575888e-02f, +2.040177234e-02f, +4.583625394e-03f, -9.795662033e-03f, -2.123463423e-02f, -2.878948033e-02f, -3.215951212e-02f, -3.165600997e-02f, -2.807161254e-02f, -2.248518352e-02f, -1.604597628e-02f, -9.779791249e-03f, -4.449914944e-03f, -4.900675011e-04f, +1.990531954e-03f, +3.144543139e-03f, +3.290154659e-03f, +2.807388676e-03f, +2.049733151e-03f, +1.285682239e-03f, +6.749404290e-04f,
        +1.195157556e-05f, +1.463241434e-05f, +1.560691722e-05f, +1.374231680e-05f, +7.849719961e-06f, -3.187546744e-06f, -2.026779777e-05f, -4.392198589e-05f, -7.417918467e-05f, -1.104644002e-04f, -1.515448748e-04f, -1.955372004e-04f, -2.399818431e-04f, -2.819846545e-04f, -3.184173686e-04f, -3.461618466e-04f, -3.623768266e-04f, -3.647619571e-04f, -3.517925311e-04f, -3.228998788e-04f, -2.785767791e-04f, -2.203941213e-04f, -1.509236733e-04f, -7.357127629e-05f, +7.665992852e-06f, +8.849719227e-05f, +1.646621696e-04f, +2.322533521e-04f, +2.880048316e-04f, +3.295223672e-04f, +3.554341621e-04f, +3.654505292e-04f, +3.603299209e-04f, +3.417581727e-04f, +3.121561799e-04f, +2.744376758e-04f, +2.317426657e-04f, +1.871730634e-04f, +1.435551879e-04f, +1.032493727e-04f, +6.802063440e-05f, +3.897697936e-05f, +1.657438954e-05f, +6.806932534e-07f, -9.314872538e-06f, -1.436305556e-05f, -1.560484981e-05f, -1.422765568e-05f,
        -2.123200363e-05f, -3.466326372e-05f, -4.610103897e-05f, -4.950156984e-05f, -3.793880645e-05f, -5.373957843e-06f, +5.117885245e-05f, +1.296110609e-04f, +2.214225220e-04f, +3.117299173e-04f, +3.809102841e-04f, +4.078399572e-04f, +3.742622091e-04f, +2.694402545e-04f, +9.403526962e-05f, -1.378286001e-04f, -3.990637556e-04f, -6.529265948e-04f, -8.587516819e-04f, -9.791352228e-04f, -9.871724207e-04f, -8.722291410e-04f, -6.429475305e-04f, -3.267147364e-04f, +3.444745270e-05f, +3.908504078e-04f, +6.936207075e-04f, +9.030206730e-04f, +9.949671927e-04f, +9.645038563e-04f, +8.256423296e-04f, +6.077598419e-04f, +3.494423697e-04f, +9.114075986e-05f, -1.318381643e-04f, -2.946688243e-04f, -3.857975120e-04f, -4.069248265e-04f, -3.705313687e-04f, -2.957710268e-04f, -2.037943320e-04f, -1.135379940e-04f, -3.876242354e-05f, +1.327572638e-05f, +4.155286413e-05f, +4.979481204e-05f, +4.436582473e-05f, +3.214276087e-05f,
        /*  1,15 (48) */
        -2.812464804e-04f, -4.941477229e-04f, -7.385661247e-04f, -9.788532173e-04f, -1.160661867e-03f, -1.210978797e-03f, -1.040361638e-03f, -5.475575367e-04f, +3.735789553e-04f, +1.825235046e-03f, +3.895498133e-03f, +6.647798202e-03f, +1.011096528e-02f, +1.427098728e-02f, +1.906548995e-02f, +2.438177768e-02f, +3.005898225e-02f, +3.589449444e-02f, +4.165443537e-02f, +4.708750705e-02f, +5.194119018e-02f, +5.597897586e-02f, +5.899716030e-02f, +6.083971990e-02f, +6.140992362e-02f, +6.067761781e-02f, +5.868150975e-02f, +5.552623746e-02f, +5.137449813e-02f, +4.643496283e-02f, +4.094708366e-02f, +3.516416220e-02f, +2.933616842e-02f, +2.369376918e-02f, +1.843485059e-02f, +1.371452376e-02f, +9.639224092e-03f, +6.265093734e-03f, +3.600422786e-03f, +1.611560287e-03f, +2.314272939e-04f, -6.304043582e-04f, -1.077152385e-03f, -1.214800150e-03f, -1.143457714e-03f, -9.507172034e-04f, -7.073330850e-04f, -4.652752077e-04f,
        +3.340740417e-04f, +7.738997028e-04f, +1.420572106e-03f, +2.198936630e-03f, +2.928595450e-03f, +3.322269995e-03f, +3.016018128e-03f, +1.633962169e-03f, -1.119074321e-03f, -5.353335318e-03f, -1.090208080e-02f, -1.726813182e-02f, -2.363160019e-02f, -2.893095555e-02f, -3.201418624e-02f, -3.183966178e-02f, -2.769150633e-02f, -1.936584064e-02f, -7.284976446e-03f, +7.492641605e-03f, +2.337985102e-02f, +3.847494801e-02f, +5.084890632e-02f, +5.885472945e-02f, +6.140099454e-02f, +5.813677344e-02f, +4.951162314e-02f, +3.669877956e-02f, +2.139673953e-02f, +5.548129250e-03f, -8.970019704e-03f, -2.062687439e-02f, -2.844003796e-02f, -3.206837136e-02f, -3.178784813e-02f, -2.836628136e-02f, -2.287098103e-02f, -1.645290111e-02f, -1.015032262e-02f, -4.745685971e-03f, -6.938618331e-04f, +1.876993960e-03f, +3.105780715e-03f, +3.303430386e-03f, +2.848941540e-03f, +2.099527963e-03f, +1.330048064e-03f, +7.070831898e-04f,
        +1.175075544e-05f, +1.450376051e-05f, +1.561691254e-05f, +1.396459906e-05f, +8.357927672e-06f, -2.328453823e-06f, -1.901092689e-05f, -4.224758644e-05f, -7.210228972e-05f, -1.080399453e-04f, -1.488693749e-04f, -1.927463657e-04f, -2.372439164e-04f, -2.794897176e-04f, -3.163633379e-04f, -3.447383033e-04f, -3.617481497e-04f, -3.650514058e-04f, -3.530689224e-04f, -3.251683254e-04f, -2.817745994e-04f, -2.243925418e-04f, -1.555353731e-04f, -7.856322346e-05f, +2.555508337e-06f, +8.353887009e-05f, +1.601151740e-04f, +2.283458597e-04f, +2.849174469e-04f, +3.273758978e-04f, +3.542827868e-04f, +3.652808343e-04f, +3.610656819e-04f, +3.432701935e-04f, +3.142760250e-04f, +2.769737986e-04f, +2.344972762e-04f, +1.899581021e-04f, +1.462059716e-04f, +1.056348136e-04f, +7.004937168e-05f, +4.059923501e-05f, +1.777981991e-05f, +1.492899882e-06f, -8.846225192e-06f, -1.417141484e-05f, -1.561612709e-05f, -1.436875469e-05f,
        -2.043206678e-05f, -3.382854534e-05f, -4.555149778e-05f, -4.965574704e-05f, -3.922482936e-05f, -8.102898992e-06f, +4.695088128e-05f, +1.241951985e-04f, +2.155449835e-04f, +3.064853506e-04f, +3.776097676e-04f, +4.077685417e-04f, +3.783873075e-04f, +2.781320935e-04f, +1.068677635e-04f, -1.221374013e-04f, -3.825376741e-04f, -6.380463451e-04f, -8.480412722e-04f, -9.746956122e-04f, -9.902567432e-04f, -8.829516200e-04f, -6.601946496e-04f, -3.482868123e-04f, +1.148458052e-05f, +3.696692020e-04f, +6.770885329e-04f, +8.932168303e-04f, +9.928547411e-04f, +9.698167423e-04f, +8.370019861e-04f, +6.229874085e-04f, +3.659939596e-04f, +1.065721740e-04f, -1.194703409e-04f, -2.865420942e-04f, -3.822318455e-04f, -4.074621699e-04f, -3.741484107e-04f, -3.011639964e-04f, -2.096675045e-04f, -1.188365932e-04f, -4.281170552e-05f, +1.073671011e-05f, +4.042907987e-05f, +4.975291943e-05f, +4.497254386e-05f, +3.298796763e-05f,
        /*  2, 0 (48) */
        +2.604271951e-04f, +6.520713960e-04f, +1.184392264e-03f, +1.737066681e-03f, +2.100859845e-03f, +2.003596444e-03f, +1.168352244e-03f, -6.020526720e-04f, -3.329654867e-03f, -6.777842271e-03f, -1.040531144e-02f, -1.337949151e-02f, -1.466132590e-02f, -1.315819186e-02f, -7.924759808e-03f, +1.623190098e-03f, +1.552555605e-02f, +3.316834873e-02f, +5.328028472e-02f, +7.404900985e-02f, +9.334657971e-02f, +1.090303366e-01f, +1.192675993e-01f, +1.228249582e-01f, +1.192675993e-01f, +1.090303366e-01f, +9.334657971e-02f, +7.404900985e-02f, +5.328028472e-02f, +3.316834873e-02f, +1.552555605e-02f, +1.623190098e-03f, -7.924759808e-03f, -1.315819186e-02f, -1.466132590e-02f, -1.337949151e-02f, -1.040531144e-02f, -6.777842271e-03f, -3.329654867e-03f, -6.020526720e-04f, +1.168352244e-03f, +2.003596444e-03f, +2.100859845e-03f, +1.737066681e-03f, +1.184392264e-03f, +6.520713960e-04f, +2.604271951e-04f, +4.414624996e-05f,
        +7.781537535e-05f, -5.172646125e-04f, -1.673334699e-03f, -3.203343269e-03f, -4.525223175e-03f, -4.733635501e-03f, -2.892950492e-03f, +1.502882723e-03f, +8.068686861e-03f, +1.529267543e-02f, +2.072324747e-02f, +2.163579289e-02f, +1.603304991e-02f, +3.643522741e-03f, -1.349956937e-02f, -3.123170394e-02f, -4.427068528e-02f, -4.783283965e-02f, -3.933589198e-02f, -1.956599624e-02f, +7.183458326e-03f, +3.415533317e-02f, +5.408068209e-02f, +6.141247912e-02f, +5.408068209e-02f, +3.415533317e-02f, +7.183458326e-03f, -1.956599624e-02f, -3.933589198e-02f, -4.783283965e-02f, -4.427068528e-02f, -3.123170394e-02f, -1.349956937e-02f, +3.643522741e-03f, +1.603304991e-02f, +2.163579289e-02f, +2.072324747e-02f, +1.529267543e-02f, +8.068686861e-03f, +1.502882723e-03f, -2.892950492e-03f, -4.733635501e-03f, -4.525223175e-03f, -3.203343269e-03f, -1.673334699e-03f, -5.172646125e-04f, +7.781537535e-05f, +2.181178524e-04f,
        -1.861921294e-05f, -2.935641677e-05f, -3.558150459e-05f, -3.158285468e-05f, -1.222960999e-05f, +2.503188561e-05f, +7.823735817e-05f, +1.396181328e-04f, +1.955291828e-04f, +2.279424392e-04f, +2.175040677e-04f, +1.477345693e-04f, +9.568295641e-06f, -1.948056840e-04f, -4.498423675e-04f, -7.270596416e-04f, -9.882682428e-04f, -1.191284773e-03f, -1.297192640e-03f, -1.277772188e-03f, -1.121562690e-03f, -8.372037069e-04f, -4.532080721e-04f, -1.404008886e-05f, +4.268500357e-04f, +8.157300226e-04f, +1.107344162e-03f, +1.272031343e-03f, +1.299863938e-03f, +1.201110195e-03f, +1.003097751e-03f, +7.442858238e-04f, +4.668757046e-04f, +2.094955744e-04f, +1.357624045e-06f, -1.411433911e-04f, -2.150221760e-04f, -2.287403927e-04f, -1.984454053e-04f, -1.434426938e-04f, -8.194761206e-05f, -2.793995439e-05f, +1.043135282e-05f, +3.086690169e-05f, +3.569114798e-05f, +2.993458524e-05f, +1.932478483e-05f, +8.681311338e-06f,
        +1.998192572e-05f, +5.366299909e-05f, +8.706161150e-05f, +9.756320015e-05f, +6.036928359e-05f, -3.840748395e-05f, -1.882964467e-04f, -3.478457341e-04f, -4.509453262e-04f, -4.276011519e-04f, -2.339151312e-04f, +1.199645104e-04f, +5.572247964e-04f, +9.466604647e-04f, +1.140419444e-03f, +1.026779123e-03f, +5.791249940e-04f, -1.192580046e-04f, -8.880415694e-04f, -1.500328102e-03f, -1.755708558e-03f, -1.550547714e-03f, -9.192008225e-04f, -2.934142660e-05f, +8.688298676e-04f, +1.522442131e-03f, +1.756756523e-03f, +1.528432751e-03f, +9.332679948e-04f, +1.675029973e-04f, -5.413682538e-04f, -1.008289421e-03f, -1.143110919e-03f, -9.659588702e-04f, -5.845172747e-04f, -1.459931441e-04f, +2.160313154e-04f, +4.206999836e-04f, +4.538433513e-04f, +3.567067284e-04f, +1.985764530e-04f, +4.655048215e-05f, -5.603767555e-05f, -9.686533432e-05f, -8.865826890e-05f, -5.595251495e-05f, -2.179569405e-05f, +3.782715170e-07f,
        /*  2, 1 (48) */
        +2.418079821e-04f, +6.227149792e-04f, +1.148810760e-03f, +1.705483827e-03f, +2.088630235e-03f, +2.028628330e-03f, +1.246589602e-03f, -4.624345392e-04f, -3.134125684e-03f, -6.549899832e-03f, -1.018780737e-02f, -1.323175694e-02f, -1.465175760e-02f, -1.335299754e-02f, -8.374602175e-03f, +8.961304561e-04f, +1.453728781e-02f, +3.197706396e-02f, +5.198309208e-02f, +7.277123767e-02f, +9.222501702e-02f, +1.081931329e-01f, +1.188143913e-01f, +1.228109182e-01f, +1.196944494e-01f, +1.098460666e-01f, +9.445392387e-02f, +7.532104120e-02f, +5.458014866e-02f, +3.436945893e-02f, +1.652865380e-02f, +2.367475921e-03f, -7.457884103e-03f, -1.294869628e-02f, -1.465996827e-02f, -1.352063490e-02f, -1.062033362e-02f, -7.006582663e-03f, -3.528100272e-03f, -7.454953658e-04f, +1.086404632e-03f, +1.975656490e-03f, +2.111291198e-03f, +1.767933583e-03f, +1.220083412e-03f, +6.820059812e-04f, +2.797519799e-04f, +5.282756130e-05f,
        +9.779730107e-05f, -4.636016135e-04f, -1.586273087e-03f, -3.105780069e-03f, -4.464853891e-03f, -4.772042985e-03f, -3.081246939e-03f, +1.155036989e-03f, +7.617741535e-03f, +1.486507428e-02f, +2.048933234e-02f, +2.175575740e-02f, +1.659027470e-02f, +4.590183206e-03f, -1.235914992e-02f, -3.020492482e-02f, -4.369156029e-02f, -4.795209765e-02f, -4.022393355e-02f, -2.106632434e-02f, +5.427749768e-03f, +3.260478545e-02f, +5.316148127e-02f, +6.138313770e-02f, +5.494951196e-02f, +3.567777530e-02f, +8.940214849e-03f, -1.803756349e-02f, -3.840262399e-02f, -4.766533665e-02f, -4.481205354e-02f, -3.223999336e-02f, -1.464268029e-02f, +2.677563871e-03f, +1.544853263e-02f, +2.148979975e-02f, +2.093927879e-02f, +1.571337542e-02f, +8.522530212e-03f, +1.859589451e-03f, -2.694374039e-03f, -4.687085019e-03f, -4.581260851e-03f, -3.300208604e-03f, -1.761992968e-03f, -5.732171275e-04f, +5.601968130e-05f, +2.184961239e-04f,
        -1.791510520e-05f, -2.876097492e-05f, -3.543175649e-05f, -3.223799159e-05f, -1.395641963e-05f, +2.218803400e-05f, +7.456101461e-05f, +1.357736976e-04f, +1.925216541e-04f, +2.269761809e-04f, +2.197517632e-04f, +1.540548463e-04f, +2.023114846e-05f, -1.803180156e-04f, -4.328989326e-04f, -7.097722906e-04f, -9.732103711e-04f, -1.181076492e-03f, -1.294026224e-03f, -1.282972024e-03f, -1.135274025e-03f, -8.582828770e-04f, -4.793476000e-04f, -4.211344555e-05f, +4.002860127e-04f, +7.938712038e-04f, +1.092623262e-03f, +1.265749200e-03f, +1.302035102e-03f, +1.210544213e-03f, +1.017688552e-03f, +7.614405822e-04f, +4.839904468e-04f, +2.243820990e-04f, +1.254439996e-05f, -1.342803661e-04f, -2.123027569e-04f, -2.293654093e-04f, -2.012655171e-04f, -1.472433373e-04f, -8.568907504e-05f, -3.091105468e-05f, +8.561504587e-06f, +3.008908649e-05f, +3.575925304e-05f, +3.049412176e-05f, +2.003084938e-05f, +9.280428073e-06f,
        +1.822048807e-05f, +5.137590333e-05f, +8.537648151e-05f, +9.807124983e-05f, +6.445213413e-05f, -3.047478144e-05f, -1.780628463e-04f, -3.387659360e-04f, -4.475448477e-04f, -4.338187090e-04f, -2.511504331e-04f, +9.428040187e-05f, +5.297516141e-04f, +9.265858312e-04f, +1.136498499e-03f, +1.043926723e-03f, +6.158691211e-04f, -7.130416767e-05f, -8.421951268e-04f, -1.470796584e-03f, -1.752814755e-03f, -1.576943159e-03f, -9.685338654e-04f, -8.799090204e-05f, +8.174770020e-04f, +1.492653966e-03f, +1.755950062e-03f, +1.555070467e-03f, +9.778176877e-04f, +2.159849825e-04f, -5.026339086e-04f, -9.884649509e-04f, -1.144554210e-03f, -9.844462429e-04f, -6.115918602e-04f, -1.723388697e-04f, +1.975100473e-04f, +4.131101015e-04f, +4.562232692e-04f, +3.653305944e-04f, +2.088886799e-04f, +5.489725793e-05f, -5.145637092e-05f, -9.597211052e-05f, -9.015996227e-05f, -5.823979708e-05f, -2.366005660e-05f, -5.623598792e-07f,
        /*  2, 2 (48) */
        +2.238928769e-04f, +5.939540043e-04f, +1.113379003e-03f, +1.673245835e-03f, +2.074673816e-03f, +2.050816364e-03f, +1.321150617e-03f, -3.266608416e-04f, -2.941604030e-03f, -6.322923651e-03f, -9.968055609e-03f, -1.307770209e-02f, -1.463152645e-02f, -1.353331556e-02f, -8.807501108e-03f, +1.863581655e-04f, +1.356407744e-02f, +3.079598747e-02f, +5.068906585e-02f, +7.148826564e-02f, +9.108974299e-02f, +1.073348500e-01f, +1.183350437e-01f, +1.227688047e-01f, +1.200947354e-01f, +1.106399378e-01f, +9.554654713e-02f, +7.658679040e-02f, +5.588218376e-02f, +3.558000314e-02f, +1.754634235e-02f, +3.128916504e-03f, -6.973893657e-03f, -1.272431418e-02f, -1.464742387e-02f, -1.365491527e-02f, -1.083263637e-02f, -7.235948073e-03f, -3.729365789e-03f, -8.927387031e-04f, +1.000715557e-03f, +1.944745435e-03f, +2.119852703e-03f, +1.798022669e-03f, +1.255842665e-03f, +7.125001030e-04f, +2.997828293e-04f, +6.210798937e-05f,
        +1.160177891e-04f, -4.122257101e-04f, -1.500896606e-03f, -3.007708819e-03f, -4.400401757e-03f, -4.802517767e-03f, -3.259309785e-03f, +8.162710528e-04f, +7.170196687e-03f, +1.443125557e-02f, +2.023818191e-02f, +2.185003780e-02f, +1.712002632e-02f, +5.516769037e-03f, -1.122265142e-02f, -2.916099810e-02f, -4.307569117e-02f, -4.802340182e-02f, -4.106612868e-02f, -2.253712093e-02f, +3.674935013e-03f, +3.102784229e-02f, +5.219294740e-02f, +6.129514680e-02f, +5.576698896e-02f, +3.717042926e-02f, +1.069616491e-02f, -1.648249302e-02f, -3.742480630e-02f, -4.744935167e-02f, -4.531468744e-02f, -3.322845831e-02f, -1.578723449e-02f, +1.693117628e-03f, +1.483694077e-02f, +2.131746088e-02f, +2.113678884e-02f, +1.612648552e-02f, +8.978753482e-03f, +2.224920046e-03f, -2.485485359e-03f, -4.632187761e-03f, -4.632717222e-03f, -3.396180714e-03f, -1.852152930e-03f, -6.314569246e-04f, +3.235962470e-05f, +2.179337640e-04f,
        -1.721340283e-05f, -2.814960131e-05f, -3.524334497e-05f, -3.283339796e-05f, -1.561199585e-05f, +1.940949351e-05f, +7.092118880e-05f, +1.319133601e-04f, +1.894276004e-04f, +2.258462928e-04f, +2.217687085e-04f, +1.601053439e-04f, +3.062893417e-05f, -1.660379520e-04f, -4.160537421e-04f, -6.924339611e-04f, -9.579345288e-04f, -1.170494061e-03f, -1.290369966e-03f, -1.287631456e-03f, -1.148473659e-03f, -8.789584049e-04f, -5.052562393e-04f, -7.016634360e-05f, +3.735286588e-04f, +7.716368758e-04f, +1.077405124e-03f, +1.258925789e-03f, +1.303701385e-03f, +1.219578458e-03f, +1.032030359e-03f, +7.785136030e-04f, +5.011779468e-04f, +2.394594669e-04f, +2.398961014e-05f, -1.271447277e-04f, -2.093425983e-04f, -2.298129043e-04f, -2.039846941e-04f, -1.510159515e-04f, -8.945895274e-05f, -3.394390829e-05f, +6.619994119e-06f, +2.924840441e-05f, +3.578439566e-05f, +3.103365204e-05f, +2.073640537e-05f, +9.891302271e-06f,
        +1.651293895e-05f, +4.909571189e-05f, +8.360932158e-05f, +9.839518974e-05f, +6.828755564e-05f, -2.275838507e-05f, -1.678894210e-04f, -3.294855733e-04f, -4.436579724e-04f, -4.393586230e-04f, -2.677272441e-04f, +6.896735240e-05f, +5.021346199e-04f, +9.057703350e-04f, +1.131368162e-03f, +1.059726664e-03f, +6.515672104e-04f, -2.369487665e-05f, -7.957857930e-04f, -1.439879816e-03f, -1.748085931e-03f, -1.601603067e-03f, -1.016774333e-03f, -1.465402875e-04f, +7.651994937e-04f, +1.461212903e-03f, +1.753282834e-03f, +1.580202800e-03f, +1.021634421e-03f, +2.646490911e-04f, -4.629585158e-04f, -9.673148316e-04f, -1.144732003e-03f, -1.002088393e-03f, -6.384111173e-04f, -1.989733799e-04f, +1.783634743e-04f, +4.048272910e-04f, +4.580698598e-04f, +3.736989491e-04f, +2.192185398e-04f, +6.344078426e-05f, -4.662483179e-05f, -9.487816622e-05f, -9.156016257e-05f, -6.052002625e-05f, -2.557309600e-05f, -1.562413851e-06f,
        /*  2, 3 (48) */
        +2.066794741e-04f, +5.658044030e-04f, +1.078135658e-03f, +1.640412437e-03f, +2.059061820e-03f, +2.070225857e-03f, +1.392071805e-03f, -1.947474815e-04f, -2.752176430e-03f, -6.097077358e-03f, -9.746286900e-03f, -1.291759675e-02f, -1.460089752e-02f, -1.369935351e-02f, -9.223554850e-03f, -5.060757957e-04f, +1.260614291e-02f, +2.962549341e-02f, +4.939869589e-02f, +7.020063419e-02f, +8.994126933e-02f, +1.064558916e-01f, +1.178297874e-01f, +1.226986384e-01f, +1.204682640e-01f, +1.114115747e-01f, +9.662395226e-02f, +7.784571619e-02f, +5.718588514e-02f, +3.679958160e-02f, +1.857837271e-02f, +3.907430107e-03f, -6.472715710e-03f, -1.248485472e-02f, -1.462343426e-02f, -1.378205999e-02f, -1.104197897e-02f, -7.465760977e-03f, -3.933350484e-03f, -1.043754655e-03f, +9.112566040e-04f, +1.910801527e-03f, +2.126472697e-03f, +1.827271074e-03f, +1.291627061e-03f, +7.435337550e-04f, +3.205192346e-04f, +7.199929164e-05f,
        +1.325307281e-04f, -3.631299982e-04f, -1.417287284e-03f, -2.909313630e-03f, -4.332114202e-03f, -4.825276152e-03f, -3.427199206e-03f, +4.867854796e-04f, +6.726538715e-03f, +1.399189695e-02f, +1.997045467e-02f, +2.191900516e-02f, +1.762216094e-02f, +6.422539372e-03f, -1.009128326e-02f, -2.810127143e-02f, -4.242412396e-02f, -4.804709670e-02f, -4.186191447e-02f, -2.397700074e-02f, +1.926849082e-03f, +2.942623922e-02f, +5.117617307e-02f, +6.114860651e-02f, +5.653218845e-02f, +3.863164217e-02f, +1.244944774e-02f, -1.490229022e-02f, -3.640317188e-02f, -4.718470258e-02f, -4.577764596e-02f, -3.419577315e-02f, -1.693196650e-02f, +6.910292352e-04f, +1.419852965e-02f, +2.111848750e-02f, +2.131515231e-02f, +1.653131281e-02f, +9.436823341e-03f, +2.598618995e-03f, -2.266266820e-03f, -4.568746977e-03f, -4.679342053e-03f, -3.491058880e-03f, -1.943713093e-03f, -6.919769508e-04f, +6.786528698e-06f, +2.163713502e-04f,
        -1.651501641e-05f, -2.752361942e-05f, -3.501771719e-05f, -3.337019667e-05f, -1.719662164e-05f, +1.669726717e-05f, +6.732039382e-05f, +1.280410192e-04f, +1.862517758e-04f, +2.245574884e-04f, +2.235584601e-04f, +1.658873573e-04f, +4.075986188e-05f, -1.519706699e-04f, -3.993149794e-04f, -6.750547716e-04f, -9.424511507e-04f, -1.159546352e-03f, -1.286229402e-03f, -1.291751402e-03f, -1.161157397e-03f, -8.992214192e-04f, -5.309217592e-04f, -9.818515874e-05f, +3.465907549e-04f, +7.490369039e-04f, +1.061695187e-03f, +1.251561458e-03f, +1.304858312e-03f, +1.228204740e-03f, +1.046112950e-03f, +7.954945209e-04f, +5.184294122e-04f, +2.547216865e-04f, +3.569062057e-05f, -1.197358921e-04f, -2.061386118e-04f, -2.300783449e-04f, -2.065980965e-04f, -1.547563581e-04f, -9.325435845e-05f, -3.703714383e-05f, +4.606824229e-06f, +2.834389434e-05f, +3.576516312e-05f, +3.155178736e-05f, +2.144042228e-05f, +1.051340821e-05f,
        +1.486066013e-05f, +4.682673567e-05f, +8.176651482e-05f, +9.854087592e-05f, +7.187725374e-05f, -1.526379959e-05f, -1.577895109e-04f, -3.200227729e-04f, -4.393011265e-04f, -4.442277028e-04f, -2.836366688e-04f, +4.405097132e-05f, +4.744103624e-04f, +8.842498455e-04f, +1.125049832e-03f, +1.074175161e-03f, +6.861874516e-04f, +2.351731614e-05f, -7.488710269e-04f, -1.407620910e-03f, -1.741535112e-03f, -1.624504230e-03f, -1.063868971e-03f, -2.049230008e-04f, +7.120558050e-04f, +1.428150722e-03f, +1.748750765e-03f, +1.603792974e-03f, +1.064662533e-03f, +3.134398161e-04f, -4.223801457e-04f, -9.448499737e-04f, -1.143628431e-03f, -1.018851802e-03f, -6.649374122e-04f, -2.258675223e-04f, +1.586048292e-04f, +3.958482481e-04f, +4.593683694e-04f, +3.817933795e-04f, +2.295510580e-04f, +7.217352485e-05f, -4.154293279e-05f, -9.357833311e-05f, -9.285231470e-05f, -6.278822237e-05f, -2.753271206e-05f, -2.622325768e-06f,
        /*  2, 4 (48) */
        +1.901644577e-04f, +5.382807835e-04f, +1.043117941e-03f, +1.607042240e-03f, +2.041865198e-03f, +2.086923125e-03f, +1.459392199e-03f, -6.670646231e-05f, -2.565924654e-03f, -5.872519870e-03f, -9.522728440e-03f, -1.275170939e-02f, -1.456013766e-02f, -1.385132418e-02f, -9.622869830e-03f, -1.181130567e-03f, +1.166369176e-02f, +2.846594706e-02f, +4.811246649e-02f, +6.890888278e-02f, +8.878011194e-02f, +1.055566702e-01f, +1.172988657e-01f, +1.226004532e-01f, +1.208148548e-01f, +1.121606116e-01f, +9.768564744e-02f, +7.909727764e-02f, +5.849074345e-02f, +3.802778634e-02f, +1.962448566e-02f, +4.702924628e-03f, -5.954286298e-03f, -1.223013303e-02f, -1.458774364e-02f, -1.390179589e-02f, -1.124811758e-02f, -7.695839322e-03f, -4.139948580e-03f, -1.198511013e-03f, +8.180022455e-04f, +1.873764383e-03f, +2.131079521e-03f, +1.855614968e-03f, +1.327392224e-03f, +7.750855424e-04f, +3.419596569e-04f, +8.251269985e-05f,
        +1.473913882e-04f, -3.163032626e-04f, -1.335520770e-03f, -2.810772754e-03f, -4.260236948e-03f, -4.840539951e-03f, -3.584988717e-03f, +1.667627067e-04f, +6.287237588e-03f, +1.354766925e-02f, +1.968681800e-02f, +2.196305613e-02f, +1.809657130e-02f, +7.306789218e-03f, -8.966233429e-03f, -2.702709627e-02f, -4.173793651e-02f, -4.802357938e-02f, -4.261078550e-02f, -2.538462165e-02f, +1.853139707e-04f, +2.780173499e-02f, +5.011230410e-02f, +6.094368351e-02f, +5.724424426e-02f, +4.005979289e-02f, +1.419819851e-02f, -1.329849725e-02f, -3.533850934e-02f, -4.687126276e-02f, -4.620002611e-02f, -3.514062312e-02f, -1.807559493e-02f, -3.278225666e-04f, +1.353359224e-02f, +2.089261998e-02f, +2.147375714e-02f, +1.692716106e-02f, +9.896191711e-03f, +2.980412374e-03f, -2.036715762e-03f, -4.496573452e-03f, -4.720884986e-03f, -3.584637213e-03f, -2.036565407e-03f, -7.547651732e-04f, -2.074618336e-05f, +2.137490244e-04f,
        -1.582082546e-05f, -2.688433347e-05f, -3.475632442e-05f, -3.384954591e-05f, -1.871064704e-05f, +1.405226805e-05f, +6.376104794e-05f, +1.241604985e-04f, +1.829989042e-04f, +2.231145150e-04f, +2.251246810e-04f, +1.714023512e-04f, +5.062234878e-05f, -1.381211376e-04f, -3.826906643e-04f, -6.576447625e-04f, -9.267707057e-04f, -1.148242387e-03f, -1.281610320e-03f, -1.295333093e-03f, -1.173321362e-03f, -9.190633106e-04f, -5.563320867e-04f, -1.261562889e-04f, +3.194851996e-04f, +7.260813874e-04f, +1.045499198e-03f, +1.243656875e-03f, +1.305501685e-03f, +1.236415057e-03f, +1.059926174e-03f, +8.123729255e-04f, +5.357359097e-04f, +2.701625673e-04f, +4.764458457e-05f, -1.120534605e-04f, -2.026878366e-04f, -2.301572546e-04f, -2.091008723e-04f, -1.584603151e-04f, -9.707231393e-05f, -4.018929612e-05f, +2.522073369e-06f, +2.737464070e-05f, +3.570015596e-05f, +3.204712588e-05f, +2.214184094e-05f, +1.114618787e-05f,
        +1.326486022e-05f, +4.457310904e-05f, +7.985437440e-05f, +9.851429947e-05f, +7.522329867e-05f, -7.996027043e-06f, -1.477760152e-04f, -3.103955235e-04f, -4.344910750e-04f, -4.484335740e-04f, -2.988708887e-04f, +1.955592078e-05f, +4.466149993e-04f, +8.620606813e-04f, +1.117566187e-03f, +1.087270186e-03f, +7.196996783e-04f, +7.028076002e-05f, -7.015085432e-04f, -1.374064408e-03f, -1.733177506e-03f, -1.645625650e-03f, -1.109765997e-03f, -2.630726757e-04f, +6.581055171e-04f, +1.393501261e-03f, +1.742352059e-03f, +1.625805940e-03f, +1.106847003e-03f, +3.623010820e-04f, -3.809383425e-04f, -9.210830791e-04f, -1.141229105e-03f, -1.034703675e-03f, -6.911329643e-04f, -2.529913283e-04f, +1.382484285e-04f, +3.861705995e-04f, +4.601045415e-04f, +3.895954709e-04f, +2.398708882e-04f, +8.108743468e-05f, -3.621097189e-05f, -9.206765198e-05f, -9.402984937e-05f, -6.503924966e-05f, -2.953662015e-05f, -3.742405081e-06f,
        /*  2, 5 (48) */
        +1.743436322e-04f, +5.113964501e-04f, +1.008361617e-03f, +1.573192694e-03f, +2.023154551e-03f, +2.100975393e-03f, +1.523153247e-03f, +5.745403624e-05f, -2.382925750e-03f, -5.649405355e-03f, -9.297603759e-03f, -1.258030704e-02f, -1.450951531e-02f, -1.398944532e-02f, -1.000556049e-02f, -1.838775330e-03f, +1.073692105e-02f, +2.731770467e-02f, +4.683085617e-02f, +6.761354969e-02f, +8.760679058e-02f, +1.046376069e-01f, +1.167425336e-01f, +1.224742969e-01f, +1.211343400e-01f, +1.128866930e-01f, +9.873114664e-02f, +8.034093452e-02f, +5.979624514e-02f, +3.926420140e-02f, +2.068441184e-02f, +5.515297553e-03f, -5.418550388e-03f, -1.195997046e-02f, -1.454009906e-02f, -1.401384935e-02f, -1.145080542e-02f, -7.925996577e-03f, -4.349049452e-03f, -1.356971328e-03f, +7.209299316e-04f, +1.833575087e-03f, +2.133601595e-03f, +1.882989609e-03f, +1.363092380e-03f, +8.071326683e-04f, +3.641014979e-04f, +9.365888772e-05f,
        +1.606562484e-04f, -2.717301535e-04f, -1.255666395e-03f, -2.712258454e-03f, -4.185013649e-03f, -4.848535978e-03f, -3.732764732e-03f, -1.436328168e-04f, +5.852746513e-03f, +1.309923567e-02f, +1.938794711e-02f, +2.198261205e-02f, +1.854318630e-02f, +8.168849899e-03f, -7.848667242e-03f, -2.593982609e-02f, -4.101823683e-02f, -4.795329862e-02f, -4.331229404e-02f, -2.675868606e-02f, -1.547863536e-03f, +2.615610935e-02f, +4.900253810e-02f, +6.068061083e-02f, +5.790234977e-02f, +4.145329415e-02f, +1.594055057e-02f, -1.167269131e-02f, -3.423166234e-02f, -4.650896168e-02f, -4.658096445e-02f, -3.606170620e-02f, -1.921682403e-02f, -1.362526242e-03f, +1.284245928e-02f, +2.063962865e-02f, +2.161200557e-02f, +1.731333166e-02f, +1.035629625e-02f, +3.370007845e-03f, -1.796844873e-03f, -4.415486017e-03f, -4.757095958e-03f, -3.676704865e-03f, -2.130595257e-03f, -8.198044229e-04f, -5.028280352e-05f, +2.100066193e-04f,
        -1.513167810e-05f, -2.623302729e-05f, -3.446062022e-05f, -3.427263710e-05f, -2.015448731e-05f, +1.147532021e-05f, +6.024547421e-05f, +1.202755443e-04f, +1.796736753e-04f, +2.215221496e-04f, +2.264711354e-04f, +1.766519567e-04f, +6.021501885e-05f, -1.244941147e-04f, -3.661886494e-04f, -6.402138901e-04f, -9.109036901e-04f, -1.136591335e-03f, -1.276518757e-03f, -1.298378071e-03f, -1.184961996e-03f, -9.384757372e-04f, -5.814753136e-04f, -1.540661632e-04f, +2.922250001e-04f, +7.027806537e-04f, +1.028823208e-03f, +1.235213029e-03f, +1.305627587e-03f, +1.244201599e-03f, +1.073459961e-03f, +8.291383686e-04f, +5.530883705e-04f, +2.857757222e-04f, +5.984844242e-05f, -1.040972218e-04f, -1.989874440e-04f, -2.300452179e-04f, -2.114881615e-04f, -1.621235190e-04f, -1.009097504e-04f, -4.339880561e-05f, +3.658972101e-07f, +2.633977555e-05f, +3.558798994e-05f, +3.251825399e-05f, +2.283957411e-05f, +1.178905081e-05f,
        +1.172657779e-05f, +4.233878694e-05f, +7.787913356e-05f, +9.832157191e-05f, +7.832811222e-05f, -9.595703742e-07f, -1.378613810e-04f, -3.006216502e-04f, -4.292448886e-04f, -4.519846527e-04f, -3.134231564e-04f, -4.494105415e-06f, +4.187842527e-04f, +8.392395538e-04f, +1.108941136e-03f, +1.099011452e-03f, +7.520753944e-04f, +1.165447678e-04f, -6.537562347e-04f, -1.339256215e-03f, -1.723030478e-03f, -1.664948562e-03f, -1.154415171e-03f, -3.209232485e-04f, +6.034092543e-04f, +1.357300375e-03f, +1.734087204e-03f, +1.646208432e-03f, +1.148133531e-03f, +4.111763155e-04f, -3.386740834e-04f, -8.960286417e-04f, -1.137521149e-03f, -1.049611999e-03f, -7.169598973e-04f, -2.803140446e-04f, +1.173096685e-04f, +3.757929232e-04f, +4.602646486e-04f, +3.970868359e-04f, +2.501623294e-04f, +9.017396144e-05f, -3.062968081e-05f, -9.034138753e-05f, -9.508619534e-05f, -6.726782211e-05f, -3.158234997e-05f, -4.922830113e-06f,
        /*  2, 6 (48) */
        +1.592119541e-04f, +4.851634228e-04f, +9.739009964e-04f, +1.538920057e-03f, +2.003000064e-03f, +2.112450713e-03f, +1.583398721e-03f, +1.777295806e-04f, -2.203252074e-03f, -5.427883205e-03f, -9.071132624e-03f, -1.240365508e-02f, -1.444930029e-02f, -1.411393943e-02f, -1.037174914e-02f, -2.478989220e-03f, +9.826017361e-03f, +2.618111333e-02f, +4.555433741e-02f, +6.631517162e-02f, +8.642182858e-02f, +1.036991311e-01f, +1.161610583e-01f, +1.223202308e-01f, +1.214265650e-01f, +1.135894736e-01f, +9.975996985e-02f, +8.157614755e-02f, +6.110187273e-02f, +4.050840299e-02f, +2.175787180e-02f, +6.344435922e-03f, -4.865462017e-03f, -1.167419474e-02f, -1.448025062e-02f, -1.411794657e-02f, -1.164979286e-02f, -8.156041794e-03f, -4.560537614e-03f, -1.519094847e-03f, +6.200201812e-04f, +1.790176281e-03f, +2.133967492e-03f, +1.909329384e-03f, +1.398680370e-03f, +8.396509222e-04f, +3.869410720e-04f, +1.054479385e-04f,
        +1.723828262e-04f, -2.293913666e-04f, -1.177787262e-03f, -2.613936882e-03f, -4.106685537e-03f, -4.849495549e-03f, -3.870626113e-03f, -4.442544670e-04f, +5.423501625e-03f, +1.264725102e-02f, +1.907452395e-02f, +2.197811794e-02f, +1.896197055e-02f, +9.008089453e-03f, -6.739726106e-03f, -2.484081463e-02f, -4.026616143e-02f, -4.783675385e-02f, -4.396605027e-02f, -2.809794228e-02f, -3.270894013e-03f, +2.449116078e-02f, +4.784812293e-02f, +6.035968758e-02f, +5.850575903e-02f, +4.281059452e-02f, +1.767463777e-02f, -1.002648288e-02f, -3.308352881e-02f, -4.609778536e-02f, -4.691963853e-02f, -3.695773484e-02f, -2.035434518e-02f, -2.412138240e-03f, +1.212549938e-02f, +2.035931460e-02f, +2.172931524e-02f, +1.768912458e-02f, +1.081656090e-02f, +3.767094681e-03f, -1.546682544e-03f, -4.325312056e-03f, -4.787725639e-03f, -3.767046253e-03f, -2.225681452e-03f, -8.870722450e-04f, -8.186515349e-05f, +2.050837892e-04f,
        -1.444839081e-05f, -2.557096333e-05f, -3.413205882e-05f, -3.464069281e-05f, -2.152862109e-05f, +8.967159811e-06f, +5.677590025e-05f, +1.163898236e-04f, +1.762807416e-04f, +2.197851945e-04f, +2.276016850e-04f, +1.816379677e-04f, +6.953670123e-05f, -1.110941500e-04f, -3.498166160e-04f, -6.227720201e-04f, -8.948606193e-04f, -1.124602503e-03f, -1.270960990e-03f, -1.300888184e-03f, -1.196076058e-03f, -9.574506285e-04f, -6.063397045e-04f, -1.819012505e-04f, +2.648232645e-04f, +6.791452514e-04f, +1.011673564e-03f, +1.226231231e-03f, +1.305232385e-03f, +1.251556758e-03f, +1.086704325e-03f, +8.457803707e-04f, +5.704775955e-04f, +3.015545704e-04f, +7.229892102e-05f, -9.586715591e-05f, -1.950347411e-04f, -2.297378848e-04f, -2.137551001e-04f, -1.657416077e-04f, -1.047635095e-04f, -4.666401798e-05f, -1.861469822e-06f, +2.523848061e-05f, +3.542729791e-05f, +3.296374774e-05f, +2.353250716e-05f, +1.244137414e-05f,
        +1.024668483e-05f, +4.012754261e-05f, +7.584693604e-05f, +9.796891076e-05f, +8.119445455e-05f, +5.841562069e-06f, -1.280575934e-04f, -2.907187900e-04f, -4.235799126e-04f, -4.548901188e-04f, -3.272877877e-04f, -2.807640121e-05f, +3.909533641e-04f, +8.158235121e-04f, +1.099199776e-03f, +1.109400401e-03f, +7.832877974e-04f, +1.622596761e-04f, -6.056720947e-04f, -1.303243534e-03f, -1.711113513e-03f, -1.682456455e-03f, -1.197767855e-03f, -3.784090436e-04f, +5.480286059e-04f, +1.319585894e-03f, +1.723958986e-03f, +1.664969016e-03f, +1.188468608e-03f, +4.600085176e-04f, -2.956297347e-04f, -8.697029437e-04f, -1.132493239e-03f, -1.063545591e-03f, -7.423802916e-04f, -3.078041660e-04f, +9.580501968e-05f, +3.647147665e-04f, +4.598355234e-04f, +4.042491442e-04f, +2.604093438e-04f, +9.942404785e-05f, -2.480023478e-05f, -8.839504320e-05f, -9.601479198e-05f, -6.946850955e-05f, -3.366724465e-05f, -6.163642991e-06f,
        /*  2, 7 (48) */
        +1.447635633e-04f, +4.595924595e-04f, +9.397689376e-04f, +1.504279365e-03f, +1.981471443e-03f, +2.121417873e-03f, +1.640174622e-03f, +2.941194042e-04f, -2.026971333e-03f, -5.208098011e-03f, -8.843530939e-03f, -1.222201712e-02f, -1.437976359e-02f, -1.422503358e-02f, -1.072156576e-02f, -3.101761240e-03f, +8.931156742e-03f, +2.505651083e-02f, +4.428337642e-02f, +6.501428343e-02f, +8.522575252e-02f, +1.027416805e-01f, +1.155547185e-01f, +1.221383295e-01f, +1.216913882e-01f, +1.142686189e-01f, +1.007716434e-01f, +8.280237878e-02f, +6.240710511e-02f, +4.175995975e-02f, +2.284457612e-02f, +7.190216292e-03f, -4.294984422e-03f, -1.137264017e-02f, -1.440795170e-02f, -1.421381372e-02f, -1.184482760e-02f, -8.385779679e-03f, -4.774292714e-03f, -1.684836455e-03f, +5.152566717e-04f, +1.743512263e-03f, +2.132106022e-03f, +1.934567865e-03f, +1.434107668e-03f, +8.726146700e-04f, +4.104735791e-04f, +1.178893127e-04f,
        +1.826295111e-04f, -1.892638240e-04f, -1.101940326e-03f, -2.515967971e-03f, -4.025491083e-03f, -4.843653987e-03f, -3.998683707e-03f, -7.349732570e-04f, +4.999921712e-03f, +1.219236090e-02f, +1.874723616e-02f, +2.195004154e-02f, +1.935292392e-02f, +9.823912965e-03f, -5.640526330e-03f, -2.373141423e-02f, -3.948287364e-02f, -4.767449418e-02f, -4.457172237e-02f, -2.940118581e-02f, -4.982007526e-03f, +2.280870433e-02f, +4.665035507e-02f, +5.998127854e-02f, +5.905378763e-02f, +4.413018042e-02f, +1.939859676e-02f, -8.361513860e-03f, -3.189506020e-02f, -4.563777685e-02f, -4.721526827e-02f, -3.782743778e-02f, -2.148683842e-02f, -3.475683831e-03f, +1.138311909e-02f, +2.005151044e-02f, +2.182512026e-02f, +1.805383935e-02f, +1.127639642e-02f, +4.171343825e-03f, -1.286273200e-03f, -4.225888008e-03f, -4.812525874e-03f, -3.855441296e-03f, -2.321696244e-03f, -9.565407545e-04f, -1.155323981e-04f, +1.989201462e-04f,
        -1.377174813e-05f, -2.489938159e-05f, -3.377209336e-05f, -3.495496479e-05f, -2.283358851e-05f, +6.528436185e-06f, +5.335445802e-05f, +1.125069226e-04f, +1.728247150e-04f, +2.179084727e-04f, +2.285202841e-04f, +1.863623376e-04f, +7.858642862e-05f, -9.792558119e-05f, -3.335820703e-04f, -6.053289213e-04f, -8.786520212e-04f, -1.112285330e-03f, -1.264943534e-03f, -1.302865587e-03f, -1.206660630e-03f, -9.759801910e-04f, -6.309137040e-04f, -2.096480687e-04f, +2.372931928e-04f, +6.551859441e-04f, +9.940569119e-04f, +1.216713113e-03f, +1.304312736e-03f, +1.258473133e-03f, +1.099649378e-03f, +8.622884283e-04f, +5.878942605e-04f, +3.174923399e-04f, +8.499253389e-05f, -8.736343546e-05f, -1.908271752e-04f, -2.292309753e-04f, -2.158968239e-04f, -1.693101634e-04f, -1.086303448e-04f, -4.998318375e-05f, -4.159713064e-06f, +2.406998925e-05f, +3.521673185e-05f, +3.338217428e-05f, +2.421949874e-05f, +1.310250252e-05f,
        +8.825890435e-06f, +3.794296559e-05f, +7.376382695e-05f, +9.746262523e-05f, +8.382541052e-05f, +1.240385132e-05f, -1.183761664e-04f, -2.807043682e-04f, -4.175137344e-04f, -4.571598891e-04f, -3.404601524e-04f, -5.116926590e-05f, +3.631570519e-04f, +7.918498873e-04f, +1.088368341e-03f, +1.118440182e-03f, +8.133118003e-04f, +2.073769032e-04f, -5.573141404e-04f, -1.266074797e-03f, -1.697448191e-03f, -1.698135084e-03f, -1.239777076e-03f, -4.354648582e-04f, +4.920260470e-04f, +1.280397580e-03f, +1.711972486e-03f, +1.682058143e-03f, +1.227799595e-03f, +5.087403362e-04f, -2.518490062e-04f, -8.421240501e-04f, -1.126135628e-03f, -1.076474157e-03f, -7.673562372e-04f, -3.354294698e-04f, +7.375202007e-05f, +3.529366637e-04f, +4.588045889e-04f, +4.110641523e-04f, +2.705955750e-04f, +1.088281350e-04f, -1.872426182e-05f, -8.622437589e-05f, -9.680910213e-05f, -7.163574407e-05f, -3.578846024e-05f, -7.464744720e-06f,
        /*  2, 8 (48) */
        +1.309918152e-04f, +4.346930779e-04f, +9.059968443e-04f, +1.469324400e-03f, +1.958637854e-03f, +2.127946309e-03f, +1.693529080e-03f, +4.066263268e-04f, -1.854146618e-03f, -4.990189538e-03f, -8.615010654e-03f, -1.203565478e-02f, -1.430117716e-02f, -1.432295916e-02f, -1.105514783e-02f, -3.707090161e-03f, +8.052504721e-03f, +2.394422550e-02f, +4.301843289e-02f, +6.371141785e-02f, +8.401909189e-02f, +1.017657003e-01f, +1.149238048e-01f, +1.219286814e-01f, +1.219286814e-01f, +1.149238048e-01f, +1.017657003e-01f, +8.401909189e-02f, +6.371141785e-02f, +4.301843289e-02f, +2.394422550e-02f, +8.052504721e-03f, -3.707090161e-03f, -1.105514783e-02f, -1.432295916e-02f, -1.430117716e-02f, -1.203565478e-02f, -8.615010654e-03f, -4.990189538e-03f, -1.854146618e-03f, +4.066263268e-04f, +1.693529080e-03f, +2.127946309e-03f, +1.958637854e-03f, +1.469324400e-03f, +9.059968443e-04f, +4.346930779e-04f, +1.309918152e-04f,
        +1.914554015e-04f, -1.513208584e-04f, -1.028176499e-03f, -2.418505346e-03f, -3.941665672e-03f, -4.831250135e-03f, -4.117059873e-03f, -1.015677625e-03f, +4.582407978e-03f, +1.173520101e-02f, +1.840677601e-02f, +2.189887228e-02f, +1.971608097e-02f, +1.061576285e-02f, -4.552157989e-03f, -2.261297405e-02f, -3.866956183e-02f, -4.746711727e-02f, -4.512903651e-02f, -3.066726061e-02f, -6.679455717e-03f, +2.111056924e-02f, +4.541057800e-02f, +5.954581368e-02f, +5.954581368e-02f, +4.541057800e-02f, +2.111056924e-02f, -6.679455717e-03f, -3.066726061e-02f, -4.512903651e-02f, -4.746711727e-02f, -3.866956183e-02f, -2.261297405e-02f, -4.552157989e-03f, +1.061576285e-02f, +1.971608097e-02f, +2.189887228e-02f, +1.840677601e-02f, +1.173520101e-02f, +4.582407978e-03f, -1.015677625e-03f, -4.117059873e-03f, -4.831250135e-03f, -3.941665672e-03f, -2.418505346e-03f, -1.028176499e-03f, -1.513208584e-04f, +1.914554015e-04f,
        -1.310250252e-05f, -2.421949874e-05f, -3.338217428e-05f, -3.521673185e-05f, -2.406998925e-05f, +4.159713064e-06f, +4.998318375e-05f, +1.086303448e-04f, +1.693101634e-04f, +2.158968239e-04f, +2.292309753e-04f, +1.908271752e-04f, +8.736343546e-05f, -8.499253389e-05f, -3.174923399e-04f, -5.878942605e-04f, -8.622884283e-04f, -1.099649378e-03f, -1.258473133e-03f, -1.304312736e-03f, -1.216713113e-03f, -9.940569119e-04f, -6.551859441e-04f, -2.372931928e-04f, +2.096480687e-04f, +6.309137040e-04f, +9.759801910e-04f, +1.206660630e-03f, +1.302865587e-03f, +1.264943534e-03f, +1.112285330e-03f, +8.786520212e-04f, +6.053289213e-04f, +3.335820703e-04f, +9.792558119e-05f, -7.858642862e-05f, -1.863623376e-04f, -2.285202841e-04f, -2.179084727e-04f, -1.728247150e-04f, -1.125069226e-04f, -5.335445802e-05f, -6.528436185e-06f, +2.283358851e-05f, +3.495496479e-05f, +3.377209336e-05f, +2.489938159e-05f, +1.377174813e-05f,
        +7.464744720e-06f, +3.578846024e-05f, +7.163574407e-05f, +9.680910213e-05f, +8.622437589e-05f, +1.872426182e-05f, -1.088281350e-04f, -2.705955750e-04f, -4.110641523e-04f, -4.588045889e-04f, -3.529366637e-04f, -7.375202007e-05f, +3.354294698e-04f, +7.673562372e-04f, +1.076474157e-03f, +1.126135628e-03f, +8.421240501e-04f, +2.518490062e-04f, -5.087403362e-04f, -1.227799595e-03f, -1.682058143e-03f, -1.711972486e-03f, -1.280397580e-03f, -4.920260470e-04f, +4.354648582e-04f, +1.239777076e-03f, +1.698135084e-03f, +1.697448191e-03f, +1.266074797e-03f, +5.573141404e-04f, -2.073769032e-04f, -8.133118003e-04f, -1.118440182e-03f, -1.088368341e-03f, -7.918498873e-04f, -3.631570519e-04f, +5.116926590e-05f, +3.404601524e-04f, +4.571598891e-04f, +4.175137344e-04f, +2.807043682e-04f, +1.183761664e-04f, -1.240385132e-05f, -8.382541052e-05f, -9.746262523e-05f, -7.376382695e-05f, -3.794296559e-05f, -8.825890435e-06f,
        /*  2, 9 (48) */
        +1.178893127e-04f, +4.104735791e-04f, +8.726146700e-04f, +1.434107668e-03f, +1.934567865e-03f, +2.132106022e-03f, +1.743512263e-03f, +5.152566717e-04f, -1.684836455e-03f, -4.774292714e-03f, -8.385779679e-03f, -1.184482760e-02f, -1.421381372e-02f, -1.440795170e-02f, -1.137264017e-02f, -4.294984422e-03f, +7.190216292e-03f, +2.284457612e-02f, +4.175995975e-02f, +6.240710511e-02f, +8.280237878e-02f, +1.007716434e-01f, +1.142686189e-01f, +1.216913882e-01f, +1.221383295e-01f, +1.155547185e-01f, +1.027416805e-01f, +8.522575252e-02f, +6.501428343e-02f, +4.428337642e-02f, +2.505651083e-02f, +8.931156742e-03f, -3.101761240e-03f, -1.072156576e-02f, -1.422503358e-02f, -1.437976359e-02f, -1.222201712e-02f, -8.843530939e-03f, -5.208098011e-03f, -2.026971333e-03f, +2.941194042e-04f, +1.640174622e-03f, +2.121417873e-03f, +1.981471443e-03f, +1.504279365e-03f, +9.397689376e-04f, +4.595924595e-04f, +1.447635633e-04f,
        +1.989201462e-04f, -1.155323981e-04f, -9.565407545e-04f, -2.321696244e-03f, -3.855441296e-03f, -4.812525874e-03f, -4.225888008e-03f, -1.286273200e-03f, +4.171343825e-03f, +1.127639642e-02f, +1.805383935e-02f, +2.182512026e-02f, +2.005151044e-02f, +1.138311909e-02f, -3.475683831e-03f, -2.148683842e-02f, -3.782743778e-02f, -4.721526827e-02f, -4.563777685e-02f, -3.189506020e-02f, -8.361513860e-03f, +1.939859676e-02f, +4.413018042e-02f, +5.905378763e-02f, +5.998127854e-02f, +4.665035507e-02f, +2.280870433e-02f, -4.982007526e-03f, -2.940118581e-02f, -4.457172237e-02f, -4.767449418e-02f, -3.948287364e-02f, -2.373141423e-02f, -5.640526330e-03f, +9.823912965e-03f, +1.935292392e-02f, +2.195004154e-02f, +1.874723616e-02f, +1.219236090e-02f, +4.999921712e-03f, -7.349732570e-04f, -3.998683707e-03f, -4.843653987e-03f, -4.025491083e-03f, -2.515967971e-03f, -1.101940326e-03f, -1.892638240e-04f, +1.826295111e-04f,
        -1.244137414e-05f, -2.353250716e-05f, -3.296374774e-05f, -3.542729791e-05f, -2.523848061e-05f, +1.861469822e-06f, +4.666401798e-05f, +1.047635095e-04f, +1.657416077e-04f, +2.137551001e-04f, +2.297378848e-04f, +1.950347411e-04f, +9.586715591e-05f, -7.229892102e-05f, -3.015545704e-04f, -5.704775955e-04f, -8.457803707e-04f, -1.086704325e-03f, -1.251556758e-03f, -1.305232385e-03f, -1.226231231e-03f, -1.011673564e-03f, -6.791452514e-04f, -2.648232645e-04f, +1.819012505e-04f, +6.063397045e-04f, +9.574506285e-04f, +1.196076058e-03f, +1.300888184e-03f, +1.270960990e-03f, +1.124602503e-03f, +8.948606193e-04f, +6.227720201e-04f, +3.498166160e-04f, +1.110941500e-04f, -6.953670123e-05f, -1.816379677e-04f, -2.276016850e-04f, -2.197851945e-04f, -1.762807416e-04f, -1.163898236e-04f, -5.677590025e-05f, -8.967159811e-06f, +2.152862109e-05f, +3.464069281e-05f, +3.413205882e-05f, +2.557096333e-05f, +1.444839081e-05f,
        +6.163642991e-06f, +3.366724465e-05f, +6.946850955e-05f, +9.601479198e-05f, +8.839504320e-05f, +2.480023478e-05f, -9.942404785e-05f, -2.604093438e-04f, -4.042491442e-04f, -4.598355234e-04f, -3.647147665e-04f, -9.580501968e-05f, +3.078041660e-04f, +7.423802916e-04f, +1.063545591e-03f, +1.132493239e-03f, +8.697029437e-04f, +2.956297347e-04f, -4.600085176e-04f, -1.188468608e-03f, -1.664969016e-03f, -1.723958986e-03f, -1.319585894e-03f, -5.480286059e-04f, +3.784090436e-04f, +1.197767855e-03f, +1.682456455e-03f, +1.711113513e-03f, +1.303243534e-03f, +6.056720947e-04f, -1.622596761e-04f, -7.832877974e-04f, -1.109400401e-03f, -1.099199776e-03f, -8.158235121e-04f, -3.909533641e-04f, +2.807640121e-05f, +3.272877877e-04f, +4.548901188e-04f, +4.235799126e-04f, +2.907187900e-04f, +1.280575934e-04f, -5.841562069e-06f, -8.119445455e-05f, -9.796891076e-05f, -7.584693604e-05f, -4.012754261e-05f, -1.024668483e-05f,
        /*  2,10 (48) */
        +1.054479385e-04f, +3.869410720e-04f, +8.396509222e-04f, +1.398680370e-03f, +1.909329384e-03f, +2.133967492e-03f, +1.790176281e-03f, +6.200201812e-04f, -1.519094847e-03f, -4.560537614e-03f, -8.156041794e-03f, -1.164979286e-02f, -1.411794657e-02f, -1.448025062e-02f, -1.167419474e-02f, -4.865462017e-03f, +6.344435922e-03f, +2.175787180e-02f, +4.050840299e-02f, +6.110187273e-02f, +8.157614755e-02f, +9.975996985e-02f, +1.135894736e-01f, +1.214265650e-01f, +1.223202308e-01f, +1.161610583e-01f, +1.036991311e-01f, +8.642182858e-02f, +6.631517162e-02f, +4.555433741e-02f, +2.618111333e-02f, +9.826017361e-03f, -2.478989220e-03f, -1.037174914e-02f, -1.411393943e-02f, -1.444930029e-02f, -1.240365508e-02f, -9.071132624e-03f, -5.427883205e-03f, -2.203252074e-03f, +1.777295806e-04f, +1.583398721e-03f, +2.112450713e-03f, +2.003000064e-03f, +1.538920057e-03f, +9.739009964e-04f, +4.851634228e-04f, +1.592119541e-04f,
        +2.050837892e-04f, -8.186515349e-05f, -8.870722450e-04f, -2.225681452e-03f, -3.767046253e-03f, -4.787725639e-03f, -4.325312056e-03f, -1.546682544e-03f, +3.767094681e-03f, +1.081656090e-02f, +1.768912458e-02f, +2.172931524e-02f, +2.035931460e-02f, +1.212549938e-02f, -2.412138240e-03f, -2.035434518e-02f, -3.695773484e-02f, -4.691963853e-02f, -4.609778536e-02f, -3.308352881e-02f, -1.002648288e-02f, +1.767463777e-02f, +4.281059452e-02f, +5.850575903e-02f, +6.035968758e-02f, +4.784812293e-02f, +2.449116078e-02f, -3.270894013e-03f, -2.809794228e-02f, -4.396605027e-02f, -4.783675385e-02f, -4.026616143e-02f, -2.484081463e-02f, -6.739726106e-03f, +9.008089453e-03f, +1.896197055e-02f, +2.197811794e-02f, +1.907452395e-02f, +1.264725102e-02f, +5.423501625e-03f, -4.442544670e-04f, -3.870626113e-03f, -4.849495549e-03f, -4.106685537e-03f, -2.613936882e-03f, -1.177787262e-03f, -2.293913666e-04f, +1.723828262e-04f,
        -1.178905081e-05f, -2.283957411e-05f, -3.251825399e-05f, -3.558798994e-05f, -2.633977555e-05f, -3.658972101e-07f, +4.339880561e-05f, +1.009097504e-04f, +1.621235190e-04f, +2.114881615e-04f, +2.300452179e-04f, +1.989874440e-04f, +1.040972218e-04f, -5.984844242e-05f, -2.857757222e-04f, -5.530883705e-04f, -8.291383686e-04f, -1.073459961e-03f, -1.244201599e-03f, -1.305627587e-03f, -1.235213029e-03f, -1.028823208e-03f, -7.027806537e-04f, -2.922250001e-04f, +1.540661632e-04f, +5.814753136e-04f, +9.384757372e-04f, +1.184961996e-03f, +1.298378071e-03f, +1.276518757e-03f, +1.136591335e-03f, +9.109036901e-04f, +6.402138901e-04f, +3.661886494e-04f, +1.244941147e-04f, -6.021501885e-05f, -1.766519567e-04f, -2.264711354e-04f, -2.215221496e-04f, -1.796736753e-04f, -1.202755443e-04f, -6.024547421e-05f, -1.147532021e-05f, +2.015448731e-05f, +3.427263710e-05f, +3.446062022e-05f, +2.623302729e-05f, +1.513167810e-05f,
        +4.922830113e-06f, +3.158234997e-05f, +6.726782211e-05f, +9.508619534e-05f, +9.034138753e-05f, +3.062968081e-05f, -9.017396144e-05f, -2.501623294e-04f, -3.970868359e-04f, -4.602646486e-04f, -3.757929232e-04f, -1.173096685e-04f, +2.803140446e-04f, +7.169598973e-04f, +1.049611999e-03f, +1.137521149e-03f, +8.960286417e-04f, +3.386740834e-04f, -4.111763155e-04f, -1.148133531e-03f, -1.646208432e-03f, -1.734087204e-03f, -1.357300375e-03f, -6.034092543e-04f, +3.209232485e-04f, +1.154415171e-03f, +1.664948562e-03f, +1.723030478e-03f, +1.339256215e-03f, +6.537562347e-04f, -1.165447678e-04f, -7.520753944e-04f, -1.099011452e-03f, -1.108941136e-03f, -8.392395538e-04f, -4.187842527e-04f, +4.494105415e-06f, +3.134231564e-04f, +4.519846527e-04f, +4.292448886e-04f, +3.006216502e-04f, +1.378613810e-04f, +9.595703742e-07f, -7.832811222e-05f, -9.832157191e-05f, -7.787913356e-05f, -4.233878694e-05f, -1.172657779e-05f,
        /*  2,11 (48) */
        +9.365888772e-05f, +3.641014979e-04f, +8.071326683e-04f, +1.363092380e-03f, +1.882989609e-03f, +2.133601595e-03f, +1.833575087e-03f, +7.209299316e-04f, -1.356971328e-03f, -4.349049452e-03f, -7.925996577e-03f, -1.145080542e-02f, -1.401384935e-02f, -1.454009906e-02f, -1.195997046e-02f, -5.418550388e-03f, +5.515297553e-03f, +2.068441184e-02f, +3.926420140e-02f, +5.979624514e-02f, +8.034093452e-02f, +9.873114664e-02f, +1.128866930e-01f, +1.211343400e-01f, +1.224742969e-01f, +1.167425336e-01f, +1.046376069e-01f, +8.760679058e-02f, +6.761354969e-02f, +4.683085617e-02f, +2.731770467e-02f, +1.073692105e-02f, -1.838775330e-03f, -1.000556049e-02f, -1.398944532e-02f, -1.450951531e-02f, -1.258030704e-02f, -9.297603759e-03f, -5.649405355e-03f, -2.382925750e-03f, +5.745403624e-05f, +1.523153247e-03f, +2.100975393e-03f, +2.023154551e-03f, +1.573192694e-03f, +1.008361617e-03f, +5.113964501e-04f, +1.743436322e-04f,
        +2.100066193e-04f, -5.028280352e-05f, -8.198044229e-04f, -2.130595257e-03f, -3.676704865e-03f, -4.757095958e-03f, -4.415486017e-03f, -1.796844873e-03f, +3.370007845e-03f, +1.035629625e-02f, +1.731333166e-02f, +2.161200557e-02f, +2.063962865e-02f, +1.284245928e-02f, -1.362526242e-03f, -1.921682403e-02f, -3.606170620e-02f, -4.658096445e-02f, -4.650896168e-02f, -3.423166234e-02f, -1.167269131e-02f, +1.594055057e-02f, +4.145329415e-02f, +5.790234977e-02f, +6.068061083e-02f, +4.900253810e-02f, +2.615610935e-02f, -1.547863536e-03f, -2.675868606e-02f, -4.331229404e-02f, -4.795329862e-02f, -4.101823683e-02f, -2.593982609e-02f, -7.848667242e-03f, +8.168849899e-03f, +1.854318630e-02f, +2.198261205e-02f, +1.938794711e-02f, +1.309923567e-02f, +5.852746513e-03f, -1.436328168e-04f, -3.732764732e-03f, -4.848535978e-03f, -4.185013649e-03f, -2.712258454e-03f, -1.255666395e-03f, -2.717301535e-04f, +1.606562484e-04f,
        -1.114618787e-05f, -2.214184094e-05f, -3.204712588e-05f, -3.570015596e-05f, -2.737464070e-05f, -2.522073369e-06f, +4.018929612e-05f, +9.707231393e-05f, +1.584603151e-04f, +2.091008723e-04f, +2.301572546e-04f, +2.026878366e-04f, +1.120534605e-04f, -4.764458457e-05f, -2.701625673e-04f, -5.357359097e-04f, -8.123729255e-04f, -1.059926174e-03f, -1.236415057e-03f, -1.305501685e-03f, -1.243656875e-03f, -1.045499198e-03f, -7.260813874e-04f, -3.194851996e-04f, +1.261562889e-04f, +5.563320867e-04f, +9.190633106e-04f, +1.173321362e-03f, +1.295333093e-03f, +1.281610320e-03f, +1.148242387e-03f, +9.267707057e-04f, +6.576447625e-04f, +3.826906643e-04f, +1.381211376e-04f, -5.062234878e-05f, -1.714023512e-04f, -2.251246810e-04f, -2.231145150e-04f, -1.829989042e-04f, -1.241604985e-04f, -6.376104794e-05f, -1.405226805e-05f, +1.871064704e-05f, +3.384954591e-05f, +3.475632442e-05f, +2.688433347e-05f, +1.582082546e-05f,
        +3.742405081e-06f, +2.953662015e-05f, +6.503924966e-05f, +9.402984937e-05f, +9.206765198e-05f, +3.621097189e-05f, -8.108743468e-05f, -2.398708882e-04f, -3.895954709e-04f, -4.601045415e-04f, -3.861705995e-04f, -1.382484285e-04f, +2.529913283e-04f, +6.911329643e-04f, +1.034703675e-03f, +1.141229105e-03f, +9.210830791e-04f, +3.809383425e-04f, -3.623010820e-04f, -1.106847003e-03f, -1.625805940e-03f, -1.742352059e-03f, -1.393501261e-03f, -6.581055171e-04f, +2.630726757e-04f, +1.109765997e-03f, +1.645625650e-03f, +1.733177506e-03f, +1.374064408e-03f, +7.015085432e-04f, -7.028076002e-05f, -7.196996783e-04f, -1.087270186e-03f, -1.117566187e-03f, -8.620606813e-04f, -4.466149993e-04f, -1.955592078e-05f, +2.988708887e-04f, +4.484335740e-04f, +4.344910750e-04f, +3.103955235e-04f, +1.477760152e-04f, +7.996027043e-06f, -7.522329867e-05f, -9.851429947e-05f, -7.985437440e-05f, -4.457310904e-05f, -1.326486022e-05f,
        /*  2,12 (48) */
        +8.251269985e-05f, +3.419596569e-04f, +7.750855424e-04f, +1.327392224e-03f, +1.855614968e-03f, +2.131079521e-03f, +1.873764383e-03f, +8.180022455e-04f, -1.198511013e-03f, -4.139948580e-03f, -7.695839322e-03f, -1.124811758e-02f, -1.390179589e-02f, -1.458774364e-02f, -1.223013303e-02f, -5.954286298e-03f, +4.702924628e-03f, +1.962448566e-02f, +3.802778634e-02f, +5.849074345e-02f, +7.909727764e-02f, +9.768564744e-02f, +1.121606116e-01f, +1.208148548e-01f, +1.226004532e-01f, +1.172988657e-01f, +1.055566702e-01f, +8.878011194e-02f, +6.890888278e-02f, +4.811246649e-02f, +2.846594706e-02f, +1.166369176e-02f, -1.181130567e-03f, -9.622869830e-03f, -1.385132418e-02f, -1.456013766e-02f, -1.275170939e-02f, -9.522728440e-03f, -5.872519870e-03f, -2.565924654e-03f, -6.670646231e-05f, +1.459392199e-03f, +2.086923125e-03f, +2.041865198e-03f, +1.607042240e-03f, +1.043117941e-03f, +5.382807835e-04f, +1.901644577e-04f,
        +2.137490244e-04f, -2.074618336e-05f, -7.547651732e-04f, -2.036565407e-03f, -3.584637213e-03f, -4.720884986e-03f, -4.496573452e-03f, -2.036715762e-03f, +2.980412374e-03f, +9.896191711e-03f, +1.692716106e-02f, +2.147375714e-02f, +2.089261998e-02f, +1.353359224e-02f, -3.278225666e-04f, -1.807559493e-02f, -3.514062312e-02f, -4.620002611e-02f, -4.687126276e-02f, -3.533850934e-02f, -1.329849725e-02f, +1.419819851e-02f, +4.005979289e-02f, +5.724424426e-02f, +6.094368351e-02f, +5.011230410e-02f, +2.780173499e-02f, +1.853139707e-04f, -2.538462165e-02f, -4.261078550e-02f, -4.802357938e-02f, -4.173793651e-02f, -2.702709627e-02f, -8.966233429e-03f, +7.306789218e-03f, +1.809657130e-02f, +2.196305613e-02f, +1.968681800e-02f, +1.354766925e-02f, +6.287237588e-03f, +1.667627067e-04f, -3.584988717e-03f, -4.840539951e-03f, -4.260236948e-03f, -2.810772754e-03f, -1.335520770e-03f, -3.163032626e-04f, +1.473913882e-04f,
        -1.051340821e-05f, -2.144042228e-05f, -3.155178736e-05f, -3.576516312e-05f, -2.834389434e-05f, -4.606824229e-06f, +3.703714383e-05f, +9.325435845e-05f, +1.547563581e-04f, +2.065980965e-04f, +2.300783449e-04f, +2.061386118e-04f, +1.197358921e-04f, -3.569062057e-05f, -2.547216865e-04f, -5.184294122e-04f, -7.954945209e-04f, -1.046112950e-03f, -1.228204740e-03f, -1.304858312e-03f, -1.251561458e-03f, -1.061695187e-03f, -7.490369039e-04f, -3.465907549e-04f, +9.818515874e-05f, +5.309217592e-04f, +8.992214192e-04f, +1.161157397e-03f, +1.291751402e-03f, +1.286229402e-03f, +1.159546352e-03f, +9.424511507e-04f, +6.750547716e-04f, +3.993149794e-04f, +1.519706699e-04f, -4.075986188e-05f, -1.658873573e-04f, -2.235584601e-04f, -2.245574884e-04f, -1.862517758e-04f, -1.280410192e-04f, -6.732039382e-05f, -1.669726717e-05f, +1.719662164e-05f, +3.337019667e-05f, +3.501771719e-05f, +2.752361942e-05f, +1.651501641e-05f,
        +2.622325768e-06f, +2.753271206e-05f, +6.278822237e-05f, +9.285231470e-05f, +9.357833311e-05f, +4.154293279e-05f, -7.217352485e-05f, -2.295510580e-04f, -3.817933795e-04f, -4.593683694e-04f, -3.958482481e-04f, -1.586048292e-04f, +2.258675223e-04f, +6.649374122e-04f, +1.018851802e-03f, +1.143628431e-03f, +9.448499737e-04f, +4.223801457e-04f, -3.134398161e-04f, -1.064662533e-03f, -1.603792974e-03f, -1.748750765e-03f, -1.428150722e-03f, -7.120558050e-04f, +2.049230008e-04f, +1.063868971e-03f, +1.624504230e-03f, +1.741535112e-03f, +1.407620910e-03f, +7.488710269e-04f, -2.351731614e-05f, -6.861874516e-04f, -1.074175161e-03f, -1.125049832e-03f, -8.842498455e-04f, -4.744103624e-04f, -4.405097132e-05f, +2.836366688e-04f, +4.442277028e-04f, +4.393011265e-04f, +3.200227729e-04f, +1.577895109e-04f, +1.526379959e-05f, -7.187725374e-05f, -9.854087592e-05f, -8.176651482e-05f, -4.682673567e-05f, -1.486066013e-05f,
        /*  2,13 (48) */
        +7.199929164e-05f, +3.205192346e-04f, +7.435337550e-04f, +1.291627061e-03f, +1.827271074e-03f, +2.126472697e-03f, +1.910801527e-03f, +9.112566040e-04f, -1.043754655e-03f, -3.933350484e-03f, -7.465760977e-03f, -1.104197897e-02f, -1.378205999e-02f, -1.462343426e-02f, -1.248485472e-02f, -6.472715710e-03f, +3.907430107e-03f, +1.857837271e-02f, +3.679958160e-02f, +5.718588514e-02f, +7.784571619e-02f, +9.662395226e-02f, +1.114115747e-01f, +1.204682640e-01f, +1.226986384e-01f, +1.178297874e-01f, +1.064558916e-01f, +8.994126933e-02f, +7.020063419e-02f, +4.939869589e-02f, +2.962549341e-02f, +1.260614291e-02f, -5.060757957e-04f, -9.223554850e-03f, -1.369935351e-02f, -1.460089752e-02f, -1.291759675e-02f, -9.746286900e-03f, -6.097077358e-03f, -2.752176430e-03f, -1.947474815e-04f, +1.392071805e-03f, +2.070225857e-03f, +2.059061820e-03f, +1.640412437e-03f, +1.078135658e-03f, +5.658044030e-04f, +2.066794741e-04f,
        +2.163713502e-04f, +6.786528698e-06f, -6.919769508e-04f, -1.943713093e-03f, -3.491058880e-03f, -4.679342053e-03f, -4.568746977e-03f, -2.266266820e-03f, +2.598618995e-03f, +9.436823341e-03f, +1.653131281e-02f, +2.131515231e-02f, +2.111848750e-02f, +1.419852965e-02f, +6.910292352e-04f, -1.693196650e-02f, -3.419577315e-02f, -4.577764596e-02f, -4.718470258e-02f, -3.640317188e-02f, -1.490229022e-02f, +1.244944774e-02f, +3.863164217e-02f, +5.653218845e-02f, +6.114860651e-02f, +5.117617307e-02f, +2.942623922e-02f, +1.926849082e-03f, -2.397700074e-02f, -4.186191447e-02f, -4.804709670e-02f, -4.242412396e-02f, -2.810127143e-02f, -1.009128326e-02f, +6.422539372e-03f, +1.762216094e-02f, +2.191900516e-02f, +1.997045467e-02f, +1.399189695e-02f, +6.726538715e-03f, +4.867854796e-04f, -3.427199206e-03f, -4.825276152e-03f, -4.332114202e-03f, -2.909313630e-03f, -1.417287284e-03f, -3.631299982e-04f, +1.325307281e-04f,
        -9.891302271e-06f, -2.073640537e-05f, -3.103365204e-05f, -3.578439566e-05f, -2.924840441e-05f, -6.619994119e-06f, +3.394390829e-05f, +8.945895274e-05f, +1.510159515e-04f, +2.039846941e-04f, +2.298129043e-04f, +2.093425983e-04f, +1.271447277e-04f, -2.398961014e-05f, -2.394594669e-04f, -5.011779468e-04f, -7.785136030e-04f, -1.032030359e-03f, -1.219578458e-03f, -1.303701385e-03f, -1.258925789e-03f, -1.077405124e-03f, -7.716368758e-04f, -3.735286588e-04f, +7.016634360e-05f, +5.052562393e-04f, +8.789584049e-04f, +1.148473659e-03f, +1.287631456e-03f, +1.290369966e-03f, +1.170494061e-03f, +9.579345288e-04f, +6.924339611e-04f, +4.160537421e-04f, +1.660379520e-04f, -3.062893417e-05f, -1.601053439e-04f, -2.217687085e-04f, -2.258462928e-04f, -1.894276004e-04f, -1.319133601e-04f, -7.092118880e-05f, -1.940949351e-05f, +1.561199585e-05f, +3.283339796e-05f, +3.524334497e-05f, +2.814960131e-05f, +1.721340283e-05f,
        +1.562413851e-06f, +2.557309600e-05f, +6.052002625e-05f, +9.156016257e-05f, +9.487816622e-05f, +4.662483179e-05f, -6.344078426e-05f, -2.192185398e-04f, -3.736989491e-04f, -4.580698598e-04f, -4.048272910e-04f, -1.783634743e-04f, +1.989733799e-04f, +6.384111173e-04f, +1.002088393e-03f, +1.144732003e-03f, +9.673148316e-04f, +4.629585158e-04f, -2.646490911e-04f, -1.021634421e-03f, -1.580202800e-03f, -1.753282834e-03f, -1.461212903e-03f, -7.651994937e-04f, +1.465402875e-04f, +1.016774333e-03f, +1.601603067e-03f, +1.748085931e-03f, +1.439879816e-03f, +7.957857930e-04f, +2.369487665e-05f, -6.515672104e-04f, -1.059726664e-03f, -1.131368162e-03f, -9.057703350e-04f, -5.021346199e-04f, -6.896735240e-05f, +2.677272441e-04f, +4.393586230e-04f, +4.436579724e-04f, +3.294855733e-04f, +1.678894210e-04f, +2.275838507e-05f, -6.828755564e-05f, -9.839518974e-05f, -8.360932158e-05f, -4.909571189e-05f, -1.651293895e-05f,
        /*  2,14 (48) */
        +6.210798937e-05f, +2.997828293e-04f, +7.125001030e-04f, +1.255842665e-03f, +1.798022669e-03f, +2.119852703e-03f, +1.944745435e-03f, +1.000715557e-03f, -8.927387031e-04f, -3.729365789e-03f, -7.235948073e-03f, -1.083263637e-02f, -1.365491527e-02f, -1.464742387e-02f, -1.272431418e-02f, -6.973893657e-03f, +3.128916504e-03f, +1.754634235e-02f, +3.558000314e-02f, +5.588218376e-02f, +7.658679040e-02f, +9.554654713e-02f, +1.106399378e-01f, +1.200947354e-01f, +1.227688047e-01f, +1.183350437e-01f, +1.073348500e-01f, +9.108974299e-02f, +7.148826564e-02f, +5.068906585e-02f, +3.079598747e-02f, +1.356407744e-02f, +1.863581655e-04f, -8.807501108e-03f, -1.353331556e-02f, -1.463152645e-02f, -1.307770209e-02f, -9.968055609e-03f, -6.322923651e-03f, -2.941604030e-03f, -3.266608416e-04f, +1.321150617e-03f, +2.050816364e-03f, +2.074673816e-03f, +1.673245835e-03f, +1.113379003e-03f, +5.939540043e-04f, +2.238928769e-04f,
        +2.179337640e-04f, +3.235962470e-05f, -6.314569246e-04f, -1.852152930e-03f, -3.396180714e-03f, -4.632717222e-03f, -4.632187761e-03f, -2.485485359e-03f, +2.224920046e-03f, +8.978753482e-03f, +1.612648552e-02f, +2.113678884e-02f, +2.131746088e-02f, +1.483694077e-02f, +1.693117628e-03f, -1.578723449e-02f, -3.322845831e-02f, -4.531468744e-02f, -4.744935167e-02f, -3.742480630e-02f, -1.648249302e-02f, +1.069616491e-02f, +3.717042926e-02f, +5.576698896e-02f, +6.129514680e-02f, +5.219294740e-02f, +3.102784229e-02f, +3.674935013e-03f, -2.253712093e-02f, -4.106612868e-02f, -4.802340182e-02f, -4.307569117e-02f, -2.916099810e-02f, -1.122265142e-02f, +5.516769037e-03f, +1.712002632e-02f, +2.185003780e-02f, +2.023818191e-02f, +1.443125557e-02f, +7.170196687e-03f, +8.162710528e-04f, -3.259309785e-03f, -4.802517767e-03f, -4.400401757e-03f, -3.007708819e-03f, -1.500896606e-03f, -4.122257101e-04f, +1.160177891e-04f,
        -9.280428073e-06f, -2.003084938e-05f, -3.049412176e-05f, -3.575925304e-05f, -3.008908649e-05f, -8.561504587e-06f, +3.091105468e-05f, +8.568907504e-05f, +1.472433373e-04f, +2.012655171e-04f, +2.293654093e-04f, +2.123027569e-04f, +1.342803661e-04f, -1.254439996e-05f, -2.243820990e-04f, -4.839904468e-04f, -7.614405822e-04f, -1.017688552e-03f, -1.210544213e-03f, -1.302035102e-03f, -1.265749200e-03f, -1.092623262e-03f, -7.938712038e-04f, -4.002860127e-04f, +4.211344555e-05f, +4.793476000e-04f, +8.582828770e-04f, +1.135274025e-03f, +1.282972024e-03f, +1.294026224e-03f, +1.181076492e-03f, +9.732103711e-04f, +7.097722906e-04f, +4.328989326e-04f, +1.803180156e-04f, -2.023114846e-05f, -1.540548463e-04f, -2.197517632e-04f, -2.269761809e-04f, -1.925216541e-04f, -1.357736976e-04f, -7.456101461e-05f, -2.218803400e-05f, +1.395641963e-05f, +3.223799159e-05f, +3.543175649e-05f, +2.876097492e-05f, +1.791510520e-05f,
        +5.623598792e-07f, +2.366005660e-05f, +5.823979708e-05f, +9.015996227e-05f, +9.597211052e-05f, +5.145637092e-05f, -5.489725793e-05f, -2.088886799e-04f, -3.653305944e-04f, -4.562232692e-04f, -4.131101015e-04f, -1.975100473e-04f, +1.723388697e-04f, +6.115918602e-04f, +9.844462429e-04f, +1.144554210e-03f, +9.884649509e-04f, +5.026339086e-04f, -2.159849825e-04f, -9.778176877e-04f, -1.555070467e-03f, -1.755950062e-03f, -1.492653966e-03f, -8.174770020e-04f, +8.799090204e-05f, +9.685338654e-04f, +1.576943159e-03f, +1.752814755e-03f, +1.470796584e-03f, +8.421951268e-04f, +7.130416767e-05f, -6.158691211e-04f, -1.043926723e-03f, -1.136498499e-03f, -9.265858312e-04f, -5.297516141e-04f, -9.428040187e-05f, +2.511504331e-04f, +4.338187090e-04f, +4.475448477e-04f, +3.387659360e-04f, +1.780628463e-04f, +3.047478144e-05f, -6.445213413e-05f, -9.807124983e-05f, -8.537648151e-05f, -5.137590333e-05f, -1.822048807e-05f,
        /*  2,15 (48) */
        +5.282756130e-05f, +2.797519799e-04f, +6.820059812e-04f, +1.220083412e-03f, +1.767933583e-03f, +2.111291198e-03f, +1.975656490e-03f, +1.086404632e-03f, -7.454953658e-04f, -3.528100272e-03f, -7.006582663e-03f, -1.062033362e-02f, -1.352063490e-02f, -1.465996827e-02f, -1.294869628e-02f, -7.457884103e-03f, +2.367475921e-03f, +1.652865380e-02f, +3.436945893e-02f, +5.458014866e-02f, +7.532104120e-02f, +9.445392387e-02f, +1.098460666e-01f, +1.196944494e-01f, +1.228109182e-01f, +1.188143913e-01f, +1.081931329e-01f, +9.222501702e-02f, +7.277123767e-02f, +5.198309208e-02f, +3.197706396e-02f, +1.453728781e-02f, +8.961304561e-04f, -8.374602175e-03f, -1.335299754e-02f, -1.465175760e-02f, -1.323175694e-02f, -1.018780737e-02f, -6.549899832e-03f, -3.134125684e-03f, -4.624345392e-04f, +1.246589602e-03f, +2.028628330e-03f, +2.088630235e-03f, +1.705483827e-03f, +1.148810760e-03f, +6.227149792e-04f, +2.418079821e-04f,
        +2.184961239e-04f, +5.601968130e-05f, -5.732171275e-04f, -1.761992968e-03f, -3.300208604e-03f, -4.581260851e-03f, -4.687085019e-03f, -2.694374039e-03f, +1.859589451e-03f, +8.522530212e-03f, +1.571337542e-02f, +2.093927879e-02f, +2.148979975e-02f, +1.544853263e-02f, +2.677563871e-03f, -1.464268029e-02f, -3.223999336e-02f, -4.481205354e-02f, -4.766533665e-02f, -3.840262399e-02f, -1.803756349e-02f, +8.940214849e-03f, +3.567777530e-02f, +5.494951196e-02f, +6.138313770e-02f, +5.316148127e-02f, +3.260478545e-02f, +5.427749768e-03f, -2.106632434e-02f, -4.022393355e-02f, -4.795209765e-02f, -4.369156029e-02f, -3.020492482e-02f, -1.235914992e-02f, +4.590183206e-03f, +1.659027470e-02f, +2.175575740e-02f, +2.048933234e-02f, +1.486507428e-02f, +7.617741535e-03f, +1.155036989e-03f, -3.081246939e-03f, -4.772042985e-03f, -4.464853891e-03f, -3.105780069e-03f, -1.586273087e-03f, -4.636016135e-04f, +9.779730107e-05f,
        -8.681311338e-06f, -1.932478483e-05f, -2.993458524e-05f, -3.569114798e-05f, -3.086690169e-05f, -1.043135282e-05f, +2.793995439e-05f, +8.194761206e-05f, +1.434426938e-04f, +1.984454053e-04f, +2.287403927e-04f, +2.150221760e-04f, +1.411433911e-04f, -1.357624045e-06f, -2.094955744e-04f, -4.668757046e-04f, -7.442858238e-04f, -1.003097751e-03f, -1.201110195e-03f, -1.299863938e-03f, -1.272031343e-03f, -1.107344162e-03f, -8.157300226e-04f, -4.268500357e-04f, +1.404008886e-05f, +4.532080721e-04f, +8.372037069e-04f, +1.121562690e-03f, +1.277772188e-03f, +1.297192640e-03f, +1.191284773e-03f, +9.882682428e-04f, +7.270596416e-04f, +4.498423675e-04f, +1.948056840e-04f, -9.568295641e-06f, -1.477345693e-04f, -2.175040677e-04f, -2.279424392e-04f, -1.955291828e-04f, -1.396181328e-04f, -7.823735817e-05f, -2.503188561e-05f, +1.222960999e-05f, +3.158285468e-05f, +3.558150459e-05f, +2.935641677e-05f, +1.861921294e-05f,
        -3.782715170e-07f, +2.179569405e-05f, +5.595251495e-05f, +8.865826890e-05f, +9.686533432e-05f, +5.603767555e-05f, -4.655048215e-05f, -1.985764530e-04f, -3.567067284e-04f, -4.538433513e-04f, -4.206999836e-04f, -2.160313154e-04f, +1.459931441e-04f, +5.845172747e-04f, +9.659588702e-04f, +1.143110919e-03f, +1.008289421e-03f, +5.413682538e-04f, -1.675029973e-04f, -9.332679948e-04f, -1.528432751e-03f, -1.756756523e-03f, -1.522442131e-03f, -8.688298676e-04f, +2.934142660e-05f, +9.192008225e-04f, +1.550547714e-03f, +1.755708558e-03f, +1.500328102e-03f, +8.880415694e-04f, +1.192580046e-04f, -5.791249940e-04f, -1.026779123e-03f, -1.140419444e-03f, -9.466604647e-04f, -5.572247964e-04f, -1.199645104e-04f, +2.339151312e-04f, +4.276011519e-04f, +4.509453262e-04f, +3.478457341e-04f, +1.882964467e-04f, +3.840748395e-05f, -6.036928359e-05f, -9.756320015e-05f, -8.706161150e-05f, -5.366299909e-05f, -1.998192572e-05f,
        /*  3, 0 (48) */
        +3.382425704e-04f, +1.348067834e-04f, -4.889424346e-04f, -1.466276588e-03f, -2.424363330e-03f, -2.730039057e-03f, -1.724598248e-03f, +9.008300509e-04f, +4.739031994e-03f, +8.514833164e-03f, +1.031793603e-02f, +8.256301383e-03f, +1.371724009e-03f, -9.514669115e-03f, -2.142432917e-02f, -2.960851385e-02f, -2.874512923e-02f, -1.466449091e-02f, +1.394439274e-02f, +5.448301361e-02f, +1.005300380e-01f, +1.431856698e-01f, +1.733482814e-01f, +1.842374374e-01f, +1.733482814e-01f, +1.431856698e-01f, +1.005300380e-01f, +5.448301361e-02f, +1.394439274e-02f, -1.466449091e-02f, -2.874512923e-02f, -2.960851385e-02f, -2.142432917e-02f, -9.514669115e-03f, +1.371724009e-03f, +8.256301383e-03f, +1.031793603e-02f, +8.514833164e-03f, +4.739031994e-03f, +9.008300509e-04f, -1.724598248e-03f, -2.730039057e-03f, -2.424363330e-03f, -1.466276588e-03f, -4.889424346e-04f, +1.348067834e-04f, +3.382425704e-04f, +2.622641023e-04f,
        -7.823217465e-04f, -9.084685290e-04f, -9.527730581e-05f, +1.939581772e-03f, +4.521325238e-03f, +5.889778654e-03f, +3.972523948e-03f, -2.097746258e-03f, -1.059839761e-02f, -1.714075782e-02f, -1.654476645e-02f, -6.064599171e-03f, +1.185220802e-02f, +2.935028356e-02f, +3.641246564e-02f, +2.636698292e-02f, +6.586074871e-04f, -3.028063400e-02f, -5.133665227e-02f, -5.043564613e-02f, -2.556515975e-02f, +1.309926646e-02f, +4.764810534e-02f, +6.141247912e-02f, +4.764810534e-02f, +1.309926646e-02f, -2.556515975e-02f, -5.043564613e-02f, -5.133665227e-02f, -3.028063400e-02f, +6.586074871e-04f, +2.636698292e-02f, +3.641246564e-02f, +2.935028356e-02f, +1.185220802e-02f, -6.064599171e-03f, -1.654476645e-02f, -1.714075782e-02f, -1.059839761e-02f, -2.097746258e-03f, +3.972523948e-03f, +5.889778654e-03f, +4.521325238e-03f, +1.939581772e-03f, -9.527730581e-05f, -9.084685290e-04f, -7.823217465e-04f, -3.493719860e-04f,
        +1.362712782e-06f, +2.430658232e-05f, +5.148010691e-05f, +6.598034546e-05f, +4.813967360e-05f, -1.337559834e-05f, -1.100590885e-04f, -2.082276012e-04f, -2.554161433e-04f, -1.996587127e-04f, -1.641106349e-05f, +2.676990797e-04f, +5.667930921e-04f, +7.518547806e-04f, +6.905770765e-04f, +2.997194817e-04f, -4.091432488e-04f, -1.310542778e-03f, -2.185234209e-03f, -2.778100290e-03f, -2.877271248e-03f, -2.387751421e-03f, -1.372408895e-03f, -4.338151546e-05f, +1.295679903e-03f, +2.338172154e-03f, +2.864100685e-03f, +2.800464093e-03f, +2.233131932e-03f, +1.368613192e-03f, +4.617294971e-04f, -2.640035975e-04f, -6.762352148e-04f, -7.564632958e-04f, -5.831596506e-04f, -2.871365353e-04f, +1.009139408e-06f, +1.919595909e-04f, +2.553979460e-04f, +2.132640346e-04f, +1.166288410e-04f, +1.861052776e-05f, -4.560632273e-05f, -6.599843263e-05f, -5.296712092e-05f, -2.601792971e-05f, -2.470909225e-06f, +9.059582855e-06f,
        +2.441236253e-05f, -1.343848373e-05f, -8.745817246e-05f, -1.562071244e-04f, -1.482428810e-04f, -8.250122829e-06f, +2.434767633e-04f, +4.836305458e-04f, +5.292736097e-04f, +2.484931299e-04f, -3.204885507e-04f, -9.285345060e-04f, -1.209960521e-03f, -8.872633042e-04f, +2.426784483e-05f, +1.150386728e-03f, +1.905650109e-03f, +1.803120048e-03f, +7.585646875e-04f, -8.012388243e-04f, -2.118524642e-03f, -2.496316882e-03f, -1.688026227e-03f, -5.612345016e-05f, +1.603375858e-03f, +2.479825823e-03f, +2.175131749e-03f, +8.991349016e-04f, -6.693020372e-04f, -1.763498582e-03f, -1.927767583e-03f, -1.214731161e-03f, -9.390924656e-05f, +8.453833775e-04f, +1.209137816e-03f, +9.595032747e-04f, +3.609011358e-04f, -2.198020113e-04f, -5.219487723e-04f, -4.940825608e-04f, -2.605996306e-04f, -4.978456466e-06f, +1.436426421e-04f, +1.587387043e-04f, +9.256208576e-05f, +1.721600120e-05f, -2.329239317e-05f, -2.574298666e-05f,
        /*  3, 1 (48) */
        +3.396052832e-04f, +1.591133657e-04f, -4.374623277e-04f, -1.400296242e-03f, -2.376223656e-03f, -2.743414655e-03f, -1.834657337e-03f, +6.926024496e-04f, +4.483615851e-03f, +8.315174451e-03f, +1.030152497e-02f, +8.524000463e-03f, +1.938517101e-03f, -8.762814334e-03f, -2.073375210e-02f, -2.930879436e-02f, -2.915427248e-02f, -1.597503369e-02f, +1.175915853e-02f, +5.170491332e-02f, +9.765276679e-02f, +1.407979183e-01f, +1.719758725e-01f, +1.841940559e-01f, +1.746439613e-01f, +1.455238419e-01f, +1.033941387e-01f, +5.728347771e-02f, +1.617752467e-02f, -1.329587772e-02f, -2.828339973e-02f, -2.987251744e-02f, -2.210056439e-02f, -1.027113241e-02f, +7.885643586e-04f, +7.969164848e-03f, +1.031894517e-02f, +8.706792755e-03f, +4.994429940e-03f, +1.114094085e-03f, -1.607969408e-03f, -2.711428529e-03f, -2.469969652e-03f, -1.532275021e-03f, -5.419095556e-04f, +1.087888537e-04f, +3.357716612e-04f, +2.713236852e-04f,
        -7.579093840e-04f, -9.219070127e-04f, -1.827354783e-04f, +1.783374647e-03f, +4.373082357e-03f, +5.881528531e-03f, +4.216000711e-03f, -1.614115712e-03f, -1.006912400e-02f, -1.689226469e-02f, -1.686525500e-02f, -6.993133677e-03f, +1.064224750e-02f, +2.846302026e-02f, +3.643673348e-02f, +2.751736964e-02f, +2.564257596e-03f, -2.847751395e-02f, -5.057808759e-02f, -5.123688496e-02f, -2.768368439e-02f, +1.060294958e-02f, +4.596007912e-02f, +6.135635567e-02f, +4.925148120e-02f, +1.557909228e-02f, -2.339002800e-02f, -4.953651123e-02f, -5.200595431e-02f, -3.204413258e-02f, -1.269160096e-03f, +2.515225176e-02f, +3.631855639e-02f, +3.019566694e-02f, +1.306134584e-02f, -5.105095897e-03f, -1.618386532e-02f, -1.736055983e-02f, -1.112034638e-02f, -2.591828819e-03f, +3.711924318e-03f, +5.884800197e-03f, +4.664967880e-03f, +2.098320476e-03f, -2.715220056e-06f, -8.912525278e-04f, -8.056141397e-04f, -3.751149726e-04f,
        +3.053828783e-07f, +2.261492841e-05f, +4.994472502e-05f, +6.583325824e-05f, +5.049571450e-05f, -8.286747443e-06f, -1.035018317e-04f, -2.029922384e-04f, -2.550231936e-04f, -2.068425282e-04f, -3.139866995e-05f, +2.483352481e-04f, +5.499827626e-04f, +7.462678156e-04f, +7.035995661e-04f, +3.341544321e-04f, -3.573412500e-04f, -1.252380659e-03f, -2.136221350e-03f, -2.753768608e-03f, -2.888088780e-03f, -2.435226036e-03f, -1.447881465e-03f, -1.301043476e-04f, +1.217763015e-03f, +2.286525170e-03f, +2.848573324e-03f, +2.820819667e-03f, +2.279852789e-03f, +1.426529195e-03f, +5.150546432e-04f, -2.270243687e-04f, -6.605637628e-04f, -7.600641439e-04f, -5.990474603e-04f, -3.066192357e-04f, -1.479270955e-05f, +1.837446921e-04f, +2.549577521e-04f, +2.180872571e-04f, +1.231996048e-04f, +2.398620325e-05f, -4.289486633e-05f, -6.588302403e-05f, -5.440070923e-05f, -2.774567533e-05f, -3.629207216e-06f, +8.718068193e-06f,
        +2.537955790e-05f, -9.816694012e-06f, -8.234517685e-05f, -1.533714251e-04f, -1.523014450e-04f, -2.100545850e-05f, +2.263313703e-04f, +4.724027832e-04f, +5.352645915e-04f, +2.759836047e-04f, -2.802718001e-04f, -8.962615228e-04f, -1.208321983e-03f, -9.267164761e-04f, -4.445893301e-05f, +1.084561664e-03f, +1.880042092e-03f, +1.838882264e-03f, +8.456970987e-04f, -7.023757360e-04f, -2.058090656e-03f, -2.507961371e-03f, -1.769307145e-03f, -1.682574121e-04f, +1.515521846e-03f, +2.458507842e-03f, +2.227781133e-03f, +9.958594564e-04f, -5.780763036e-04f, -1.720065970e-03f, -1.946313220e-03f, -1.277443204e-03f, -1.643306246e-04f, +8.011294892e-04f, +1.205814231e-03f, +9.890754911e-04f, +4.014233099e-04f, -1.899484114e-04f, -5.132739533e-04f, -5.037125890e-04f, -2.776568924e-04f, -1.866172927e-05f, +1.384937071e-04f, +1.609470350e-04f, +9.764105202e-05f, +2.114422789e-05f, -2.201572656e-05f, -2.635586685e-05f,
        /*  3, 2 (48) */
        +3.399106661e-04f, +1.817282941e-04f, -3.875176027e-04f, -1.334462984e-03f, -2.325727942e-03f, -2.751701403e-03f, -1.938159169e-03f, +4.896102112e-04f, +4.228592657e-03f, +8.108331923e-03f, +1.027012630e-02f, +8.772335711e-03f, +2.488499864e-03f, -8.016546519e-03f, -2.003015253e-02f, -2.897463993e-02f, -2.951161373e-02f, -1.722741435e-02f, +9.622937179e-03f, +4.895114472e-02f, +9.476467801e-02f, +1.383626923e-01f, +1.705279911e-01f, +1.840639515e-01f, +1.758617243e-01f, +1.478103671e-01f, +1.062427120e-01f, +6.010429737e-02f, +1.845737746e-02f, -1.186934853e-02f, -2.776834509e-02f, -3.009954181e-02f, -2.276112815e-02f, -1.103119655e-02f, +1.895168983e-04f, +7.662545612e-03f, +1.030415246e-02f, +8.890537447e-03f, +5.249387692e-03f, +1.332181343e-03f, -1.484769803e-03f, -2.687442326e-03f, -2.512864519e-03f, -1.598158045e-03f, -5.963102648e-04f, +8.104317839e-05f, +3.321424540e-04f, +2.800417534e-04f,
        -7.325298261e-04f, -9.317237067e-04f, -2.650806551e-04f, +1.630003222e-03f, +4.220780912e-03f, +5.860523072e-03f, +4.442332082e-03f, -1.141712929e-03f, -9.533859405e-03f, -1.661628108e-02f, -1.714552680e-02f, -7.889395200e-03f, +9.433925520e-03f, +2.753630378e-02f, +3.639227455e-02f, +2.860193131e-02f, +4.444299688e-03f, -2.663863169e-02f, -4.973239049e-02f, -5.193926069e-02f, -2.974177505e-02f, +8.094988206e-03f, +4.419077197e-02f, +6.118809826e-02f, +5.076700305e-02f, +1.803760013e-02f, -2.116224687e-02f, -4.854065178e-02f, -5.258403061e-02f, -3.376419855e-02f, -3.215473316e-03f, +2.387480855e-02f, +3.615422576e-02f, +3.099679643e-02f, +1.426716007e-02f, -4.116020405e-03f, -1.578244201e-02f, -1.755050824e-02f, -1.163362033e-02f, -3.095541408e-03f, +3.434267425e-03f, +5.866138468e-03f, +4.803461587e-03f, +2.259267511e-03f, +9.492583196e-05f, -8.701082999e-04f, -8.276298662e-04f, -4.014708395e-04f,
        -7.004638822e-07f, +2.094611058e-05f, +4.836597661e-05f, +6.556179178e-05f, +5.267555978e-05f, -3.348891556e-06f, -9.696823219e-05f, -1.975722132e-04f, -2.542303720e-04f, -2.135123302e-04f, -4.595853568e-05f, +2.290726963e-04f, +5.327635541e-04f, +7.397323830e-04f, +7.153144195e-04f, +3.672927030e-04f, -3.063673185e-04f, -1.194188938e-03f, -2.086155759e-03f, -2.727511272e-03f, -2.896559589e-03f, -2.480561472e-03f, -1.522030573e-03f, -2.167066311e-04f, +1.138728152e-03f, +2.232849779e-03f, +2.830687958e-03f, +2.839128589e-03f, +2.325335806e-03f, +1.484227549e-03f, +5.690718432e-04f, -1.888012286e-04f, -6.435540565e-04f, -7.626289262e-04f, -6.144215072e-04f, -3.261181077e-04f, -3.097912402e-05f, +1.750143867e-04f, +2.540851657e-04f, +2.226829976e-04f, +1.297595871e-04f, +2.949687597e-05f, -4.000483767e-05f, -6.562976180e-05f, -5.577576691e-05f, -2.948637421e-05f, -4.836690636e-06f, +8.328888420e-06f,
        +2.619825575e-05f, -6.354954773e-06f, -7.723840020e-05f, -1.502509361e-04f, -1.558265929e-04f, -3.327077228e-05f, +2.092054228e-04f, +4.604462536e-04f, +5.399406518e-04f, +3.022388744e-04f, -2.403350278e-04f, -8.627779927e-04f, -1.204266684e-03f, -9.636961824e-04f, -1.121401310e-04f, +1.017409233e-03f, +1.851031519e-03f, +1.870745738e-03f, +9.305377716e-04f, -6.027510728e-04f, -1.993968156e-03f, -2.514749879e-03f, -1.847060106e-03f, -2.800528054e-04f, +1.424636953e-03f, +2.432392809e-03f, +2.276349786e-03f, +1.091209358e-03f, -4.850599651e-04f, -1.672878888e-03f, -1.961212656e-03f, -1.338372963e-03f, -2.353939035e-04f, +7.545604759e-04f, +1.199955147e-03f, +1.017160390e-03f, +4.419668961e-04f, -1.589740718e-04f, -5.032359372e-04f, -5.124752704e-04f, -2.946044465e-04f, -3.277937540e-05f, +1.327903489e-04f, +1.628132499e-04f, +1.026786732e-04f, +2.521744019e-05f, -2.057882056e-05f, -2.689529487e-05f,
        /*  3, 3 (48) */
        +3.392102022e-04f, +2.026744047e-04f, -3.391516261e-04f, -1.268901192e-03f, -2.273052382e-03f, -2.755050294e-03f, -2.035127401e-03f, +2.920379980e-04f, +3.974362285e-03f, +7.894819592e-03f, +1.022416777e-02f, +9.001408407e-03f, +3.021263418e-03f, -7.276814136e-03f, -1.931483811e-02f, -2.860734723e-02f, -2.981798105e-02f, -1.842160329e-02f, +7.536781420e-03f, +4.622363344e-02f, +9.186811842e-02f, +1.358821308e-01f, +1.690059605e-01f, +1.838472449e-01f, +1.770004525e-01f, +1.500432169e-01f, +1.090734000e-01f, +6.294342596e-02f, +2.078271327e-02f, -1.038512098e-02f, -2.719927325e-02f, -3.028834304e-02f, -2.340468221e-02f, -1.179382548e-02f, -4.249046089e-04f, +7.336427504e-03f, +1.027317334e-02f, +9.065551833e-03f, +5.503472858e-03f, +1.554864340e-03f, -1.355010216e-03f, -2.657945450e-03f, -2.552869356e-03f, -1.663787806e-03f, -6.520860317e-04f, +5.155680418e-05f, +3.273057633e-04f, +2.883706418e-04f,
        -7.063315703e-04f, -9.380786615e-04f, -3.423190553e-04f, +1.479752286e-03f, +4.064954319e-03f, +5.827252300e-03f, +4.651537505e-03f, -6.812666753e-04f, -8.993918753e-03f, -1.631404221e-02f, -1.738586183e-02f, -8.752173193e-03f, +8.229658837e-03f, +2.657260760e-02f, +3.628013442e-02f, +2.961934054e-02f, +6.295331207e-03f, -2.476788595e-02f, -4.880185272e-02f, -5.254201177e-02f, -3.173574321e-02f, +5.580238328e-03f, +4.234371187e-02f, +6.090804546e-02f, +5.219164000e-02f, +2.046999293e-02f, -1.888589709e-02f, -4.744944242e-02f, -5.306909058e-02f, -3.543707744e-02f, -5.176685972e-03f, +2.253643559e-02f, +3.591883186e-02f, +3.175135691e-02f, +1.546711522e-02f, -3.098860015e-03f, -1.534047511e-02f, -1.770948231e-02f, -1.213685627e-02f, -3.608016678e-03f, +3.139662979e-03f, +5.833359092e-03f, +4.936251936e-03f, +2.422080761e-03f, +1.976045052e-04f, -8.448908597e-04f, -8.482086868e-04f, -4.283661344e-04f,
        -1.654356283e-06f, +1.930311625e-05f, +4.674879763e-05f, +6.517067925e-05f, +5.468063210e-05f, +1.433467579e-06f, -9.046911708e-05f, -1.919817537e-04f, -2.530493507e-04f, -2.196702144e-04f, -6.007820864e-05f, +2.099383286e-04f, +5.151702243e-04f, +7.322791757e-04f, +7.257348527e-04f, +3.991203899e-04f, -2.562636991e-04f, -1.136029036e-03f, -2.035100429e-03f, -2.699372312e-03f, -2.902692508e-03f, -2.523725649e-03f, -1.594790730e-03f, -3.031081595e-04f, +1.058646560e-03f, +2.177187626e-03f, +2.810445952e-03f, +2.855354432e-03f, +2.369520845e-03f, +1.541644556e-03f, +6.237328043e-04f, -1.493554528e-04f, -6.251990193e-04f, -7.641301153e-04f, -6.292467916e-04f, -3.456034145e-04f, -4.753378261e-05f, +1.657699032e-04f, +2.527702729e-04f, +2.270370214e-04f, +1.362966996e-04f, +3.513638102e-05f, -3.693610856e-05f, -6.523443877e-05f, -5.708715158e-05f, -3.123643501e-05f, -6.092289786e-06f, +7.891082444e-06f,
        +2.687305772e-05f, -3.056904113e-06f, -7.215255303e-05f, -1.468651244e-04f, -1.588277613e-04f, -4.503105467e-05f, +1.921397021e-04f, +4.478085433e-04f, +5.433234257e-04f, +3.272279914e-04f, -2.007601133e-04f, -8.281786720e-04f, -1.197843781e-03f, -9.981618200e-04f, -1.786487368e-04f, +9.490838417e-04f, +1.818712806e-03f, +1.898679610e-03f, +1.012931182e-03f, -5.025707398e-04f, -1.926302692e-03f, -2.516683224e-03f, -1.921134244e-03f, -3.912847393e-04f, +1.330900520e-03f, +2.401520771e-03f, +2.320722836e-03f, +1.184983313e-03f, -3.904304742e-04f, -1.622002527e-03f, -1.972398693e-03f, -1.397372766e-03f, -3.069578549e-04f, +7.057411623e-04f, +1.191531114e-03f, +1.043669022e-03f, +4.824419647e-04f, -1.269242815e-04f, -4.918245151e-04f, -5.203262624e-04f, -3.113972596e-04f, -4.730931145e-05f, +1.265281901e-04f, +1.643188099e-04f, +1.076580508e-04f, +2.942920216e-05f, -1.897854157e-05f, -2.735491682e-05f,
        /*  3, 4 (48) */
        +3.375558459e-04f, +2.219775210e-04f, -2.924028285e-04f, -1.203730513e-03f, -2.218371750e-03f, -2.753616827e-03f, -2.125596518e-03f, +1.000562444e-04f, +3.721312934e-03f, +7.675149378e-03f, +1.016408956e-02f, +9.211346736e-03f, +3.536433642e-03f, -6.544534960e-03f, -1.858910326e-02f, -2.820822684e-02f, -3.007424475e-02f, -1.955763232e-02f, +5.501680991e-03f, +4.352426113e-02f, +8.896542591e-02f, +1.333584052e-01f, +1.674111697e-01f, +1.835441367e-01f, +1.780590990e-01f, +1.522204045e-01f, +1.118838460e-01f, +6.579878040e-02f, +2.315223411e-02f, -8.843476421e-03f, -2.657554044e-02f, -3.043769849e-02f, -2.402988123e-02f, -1.255795560e-02f, -1.054151401e-03f, +6.990824090e-03f, +1.022563956e-02f, +9.231321737e-03f, +5.756243131e-03f, +1.781901362e-03f, -1.218713516e-03f, -2.622809069e-03f, -2.589805465e-03f, -1.729022245e-03f, -7.091731833e-04f, +2.032036918e-05f, +3.212134736e-04f, +2.962617242e-04f,
        -6.794585126e-04f, -9.411355656e-04f, -4.144716084e-04f, +1.332887162e-03f, +3.906126557e-03f, +5.782221245e-03f, +4.843677207e-03f, -2.334581321e-04f, -8.450595327e-03f, -1.598681422e-02f, -1.758662195e-02f, -9.580351865e-03f, +7.031815056e-03f, +2.557444578e-02f, +3.610148568e-02f, +3.056842438e-02f, +8.114044013e-03f, -2.286920634e-02f, -4.778892153e-02f, -5.304458251e-02f, -3.366204590e-02f, +3.063555103e-03f, +4.042257762e-02f, +6.051676072e-02f, +5.352254052e-02f, +2.287151370e-02f, -1.656517425e-02f, -4.626445911e-02f, -5.345952105e-02f, -3.705907997e-02f, -7.149084665e-03f, +2.113906282e-02f, +3.561187401e-02f, +3.245709807e-02f, +1.665864633e-02f, -2.055190993e-03f, -1.485803315e-02f, -1.783640660e-02f, -1.262868078e-02f, -4.128342940e-03f, +2.828265719e-03f, +5.786049781e-03f, +5.062780126e-03f, +2.586399571e-03f, +3.052625560e-04f, -8.154616576e-04f, -8.671872283e-04f, -4.557210512e-04f,
        -2.555965243e-06f, +1.768877557e-05f, +4.509804999e-05f, +6.466475356e-05f, +5.651265163e-05f, +6.056241004e-06f, -8.401496727e-05f, -1.862350249e-04f, -2.514921708e-04f, -2.253190591e-04f, -7.374620772e-05f, +1.909582720e-04f, +4.972373481e-04f, +7.239395436e-04f, +7.348755228e-04f, +4.296254235e-04f, -2.070710274e-04f, -1.077961627e-03f, -1.983118864e-03f, -2.669397502e-03f, -2.906498868e-03f, -2.564688960e-03f, -1.666098084e-03f, -3.892289646e-04f, +9.775907166e-04f, +2.119582649e-03f, +2.787851257e-03f, +2.869462815e-03f, +2.412348689e-03f, +1.598716139e-03f, +6.789878318e-04f, -1.087101536e-04f, -6.054931951e-04f, -7.645411078e-04f, -6.434883797e-04f, -3.650447888e-04f, -6.443940815e-05f, +1.560133449e-04f, +2.510036692e-04f, +2.311351558e-04f, +1.427985743e-04f, +4.089813856e-05f, -3.368889852e-05f, -6.469301128e-05f, -5.832969341e-05f, -3.299212377e-05f, -7.394779215e-06f, +7.403782787e-06f,
        +2.740886232e-05f, +7.449142443e-08f, -6.710173023e-05f, -1.432335341e-04f, -1.613155044e-04f, -5.627305695e-05f, +1.751737233e-04f, +4.345377090e-04f, +5.454371371e-04f, +3.509236252e-04f, -1.616265181e-04f, -7.925591648e-04f, -1.189106918e-03f, -1.030078903e-03f, -2.438619218e-04f, +8.797406818e-04f, +1.783186529e-03f, +1.922661652e-03f, +1.092728083e-03f, -4.020406563e-04f, -1.855246655e-03f, -2.513772428e-03f, -1.991386654e-03f, -5.017295534e-04f, +1.234498089e-03f, +2.365941895e-03f, +2.360793830e-03f, +1.276982314e-03f, -2.943698963e-04f, -1.567510509e-03f, -1.979811515e-03f, -1.454297523e-03f, -3.788783831e-04f, +6.547422921e-04f, +1.180518003e-03f, +1.068514493e-03f, +5.227570188e-04f, -9.384783611e-05f, -4.790325759e-04f, -5.272223775e-04f, -3.279894630e-04f, -6.222770278e-05f, +1.197042549e-04f, +1.654455694e-04f, +1.125618207e-04f, +3.377236041e-05f, -1.721219165e-05f, -2.772838204e-05f,
        /*  3, 5 (48) */
        +3.349998807e-04f, +2.396662965e-04f, -2.473047785e-04f, -1.139065760e-03f, -2.161859098e-03f, -2.747560586e-03f, -2.209611485e-03f, -8.617878055e-05f, +3.469820763e-03f, +7.449830319e-03f, +1.009034335e-02f, +9.402305008e-03f, +4.033670990e-03f, -5.820595416e-03f, -1.785422774e-02f, -2.777860141e-02f, -3.028131578e-02f, -2.063559395e-02f, +3.518562128e-03f, +4.085486363e-02f, +8.605892704e-02f, +1.307937162e-01f, +1.657450717e-01f, +1.831549078e-01f, +1.790366898e-01f, +1.543399871e-01f, +1.146716972e-01f, +6.866824321e-02f, +2.556458280e-02f, -7.244760282e-03f, -2.589655261e-02f, -3.054640865e-02f, -2.463537442e-02f, -1.332249670e-02f, -1.697639780e-03f, +6.625779301e-03f, +1.016120015e-02f, +9.387335081e-03f, +6.007246800e-03f, +2.013036517e-03f, -1.075914942e-03f, -2.581910930e-03f, -2.623494363e-03f, -1.793715256e-03f, -7.675028767e-04f, -1.267175460e-05f, +3.138186943e-04f, +3.036655070e-04f,
        -6.520496503e-04f, -9.410610742e-04f, -4.815733386e-04f, +1.189653627e-03f, +3.744811053e-03f, +5.725948188e-03f, +5.018850930e-03f, +2.010795769e-04f, -7.905158190e-03f, -1.563589059e-02f, -1.774824846e-02f, -1.037291103e-02f, +5.842708137e-03f, +2.454436688e-02f, +3.585762376e-02f, +3.144816507e-02f, +9.897230542e-03f, -2.094654469e-02f, -4.669619345e-02f, -5.344662316e-02f, -3.551729255e-02f, +5.497826750e-04f, +3.843119097e-02f, +6.001503116e-02f, +5.475703861e-02f, +2.523745560e-02f, -1.420438042e-02f, -4.498747679e-02f, -5.375389095e-02f, -3.862659048e-02f, -9.128896180e-03f, +1.968476530e-02f, +3.523299562e-02f, +3.311184036e-02f, +1.783916434e-02f, -9.866765005e-04f, -1.433527613e-02f, -1.793025443e-02f, -1.310771336e-02f, -4.655565318e-03f, +2.500276256e-03f, +5.723822078e-03f, +5.182484381e-03f, +2.751845140e-03f, +4.178243766e-04f, -7.816892972e-04f, -8.843994200e-04f, -4.834494332e-04f,
        -3.405100316e-06f, +1.610575965e-05f, +4.341851334e-05f, +6.404893482e-05f, +5.817362492e-05f, +1.051574984e-05f, -7.761590678e-05f, -1.803461058e-04f, -2.495712134e-04f, -2.304625031e-04f, -8.695202101e-05f, +1.721578512e-04f, +4.789992715e-04f, +7.147454391e-04f, +7.427524870e-04f, +4.587975622e-04f, -1.588282957e-04f, -1.020046567e-03f, -1.930274992e-03f, -2.637634286e-03f, -2.907992474e-03f, -2.603424299e-03f, -1.735890485e-03f, -4.749894117e-04f, +8.956342544e-04f, +2.060081029e-03f, +2.762910412e-03f, +2.881421461e-03f, +2.453761118e-03f, +1.655377914e-03f, +7.347858775e-04f, -6.689027310e-05f, -5.844327786e-04f, -7.638362764e-04f, -6.571114549e-04f, -3.844112664e-04f, -8.167777557e-05f, +1.457477053e-04f, +2.487764871e-04f, +2.349633169e-04f, +1.492525790e-04f, +4.677515583e-05f, -3.026378360e-05f, -6.400161198e-05f, -5.949820540e-05f, -3.474956812e-05f, -8.742775860e-06f, +6.866220693e-06f,
        +2.781083669e-05f, +3.036922064e-06f, -6.209938901e-05f, -1.393757265e-04f, -1.633014308e-04f, -6.698527863e-05f, +1.583456646e-04f, +4.206821447e-04f, +5.463084825e-04f, +3.733020566e-04f, -1.230111396e-04f, -7.560156839e-04f, -1.178114037e-03f, -1.059419058e-03f, -3.076612684e-04f, +8.095353725e-04f, +1.744559142e-03f, +1.942678244e-03f, +1.169785795e-03f, -3.013663031e-04f, -1.780958912e-03f, -2.506038658e-03f, -2.057682689e-03f, -6.111653058e-04f, +1.135620996e-03f, +2.325716381e-03f, +2.396464998e-03f, +1.367010098e-03f, -1.970645351e-04f, -1.509484792e-03f, -1.983398884e-03f, -1.509005084e-03f, -4.510088204e-04f, +6.016404427e-04f, +1.166897134e-03f, +1.091612204e-03f, +5.628191870e-04f, -5.979698620e-05f, -4.648561908e-04f, -5.331217223e-04f, -3.443344526e-04f, -7.750898066e-05f, +1.123170193e-04f, +1.661758416e-04f, +1.173721915e-04f, +3.823904117e-05f, -1.527753494e-05f, -2.800936709e-05f,
        /*  3, 6 (48) */
        +3.315947804e-04f, +2.557720562e-04f, -2.038862651e-04f, -1.075016825e-03f, -2.103685473e-03f, -2.737044836e-03f, -2.287227392e-03f, -2.665248864e-04f, +3.220249550e-03f, +7.219367816e-03f, +1.000339133e-02f, +9.574462859e-03f, +4.512670262e-03f, -5.105849977e-03f, -1.711147525e-02f, -2.731980385e-02f, -3.044014407e-02f, -2.165564052e-02f, +1.588287136e-03f, +3.821722934e-02f, +8.315093457e-02f, +1.281902919e-01f, +1.640091812e-01f, +1.826799183e-01f, +1.799323240e-01f, +1.564000682e-01f, +1.174346076e-01f, +7.154966467e-02f, +2.801834392e-02f, -5.589382368e-03f, -2.516176673e-02f, -3.061329892e-02f, -2.521980720e-02f, -1.408633298e-02f, -2.354751235e-03f, +6.241368035e-03f, +1.007952237e-02f, +9.533082787e-03f, +6.256023287e-03f, +2.247999834e-03f, -9.266623627e-04f, -2.535135775e-03f, -2.653758147e-03f, -1.857716868e-03f, -8.270010821e-04f, -4.742132272e-05f, +3.050759185e-04f, +3.105317277e-04f,
        -6.242388136e-04f, -9.380241521e-04f, -5.436727276e-04f, +1.050277901e-03f, +3.581509622e-03f, +5.658962910e-03f, +5.177196595e-03f, +6.217617216e-04f, -7.358849707e-03f, -1.526258854e-02f, -1.787125960e-02f, -1.112892671e-02f, +4.664594100e-03f, +2.348494782e-02f, +3.554996249e-02f, +3.225770044e-02f, +1.164178968e-02f, -1.900386645e-02f, -4.552640766e-02f, -5.374798947e-02f, -3.729825146e-02f, -1.956255983e-03f, +3.637350828e-02f, +5.940386586e-02f, +5.589265961e-02f, +2.756317198e-02f, -1.180791542e-02f, -4.362046669e-02f, -5.395095548e-02f, -4.013607527e-02f, -1.111229506e-02f, +1.817576022e-02f, +3.478198680e-02f, +3.371348080e-02f, +1.900606147e-02f, +1.049357040e-04f, -1.377245694e-02f, -1.799005142e-02f, -1.357256955e-02f, -5.188687040e-03f, +2.155941804e-03f, +5.646313098e-03f, +5.294801400e-03f, +2.918020982e-03f, +5.351965681e-04f, -7.434502560e-04f, -8.996769549e-04f, -5.114588003e-04f,
        -4.201705979e-06f, +1.455657929e-05f, +4.171487722e-05f, +6.332821795e-05f, +5.966583346e-05f, +1.480872188e-05f, -7.128169313e-05f, -1.743289664e-04f, -2.472991710e-04f, -2.351049243e-04f, -9.968610268e-05f, +1.535615665e-04f, +4.604900653e-04f, +7.047293621e-04f, +7.493831600e-04f, +4.866283813e-04f, -1.115728219e-04f, -9.623428273e-04f, -1.876633085e-03f, -2.604131718e-03f, -2.907189572e-03f, -2.639907083e-03f, -1.804107560e-03f, -5.603102941e-04f, +8.128518704e-04f, +1.998731146e-03f, +2.735632550e-03f, +2.891200247e-03f, +2.493700993e-03f, +1.711565276e-03f, +7.910745906e-04f, -2.392257303e-05f, -5.620156431e-04f, -7.619910206e-04f, -6.700813706e-04f, -4.036713219e-04f, -9.922972144e-05f, +1.349768817e-04f, +2.460804233e-04f, +2.385075365e-04f, +1.556458342e-04f, +5.276002987e-05f, -2.666170461e-05f, -6.315656259e-05f, -6.058749407e-05f, -3.650476181e-05f, -1.013473749e-05f, +6.277731151e-06f,
        +2.808438836e-05f, +5.828718348e-06f, -5.715832945e-05f, -1.353112227e-04f, -1.647981405e-04f, -7.715795035e-05f, +1.416923013e-04f, +4.062904505e-04f, +5.459665106e-04f, +3.943431627e-04f, -8.498817533e-05f, -7.186448143e-04f, -1.164927174e-03f, -1.086160006e-03f, -3.699329842e-04f, +7.386236059e-04f, +1.702942683e-03f, +1.958724338e-03f, +1.243968472e-03f, -2.007522737e-04f, -1.703604432e-03f, -2.493513154e-03f, -2.119896241e-03f, -7.193722573e-04f, +1.034465965e-03f, +2.280914348e-03f, +2.427647501e-03f, +1.454873583e-03f, -9.870454600e-05f, -1.448015545e-03f, -1.983116330e-03f, -1.561356583e-03f, -5.232002321e-04f, +5.465179258e-04f, +1.150655407e-03f, +1.112880096e-03f, +6.025344230e-04f, -2.482737724e-05f, -4.492946910e-04f, -5.379838352e-04f, -3.603849945e-04f, -9.312586483e-05f, +1.043664581e-04f, +1.664924659e-04f, +1.220709847e-04f, +4.282064965e-05f, -1.317282348e-05f, -2.819160034e-05f,
        /*  3, 7 (48) */
        +3.273930744e-04f, +2.703286355e-04f, -1.621713879e-04f, -1.011688607e-03f, -2.044019640e-03f, -2.722236114e-03f, -2.358509085e-03f, -4.408538528e-04f, +2.972950379e-03f, +6.984262892e-03f, +9.903705225e-03f, +9.728024426e-03f, +4.973160327e-03f, -4.401120615e-03f, -1.636209209e-02f, -2.683317547e-02f, -3.055171689e-02f, -2.261798335e-02f, -2.883459489e-04f, +3.561309763e-02f, +8.024374500e-02f, +1.255503848e-01f, +1.622050736e-01f, +1.821196081e-01f, +1.807451759e-01f, +1.583987993e-01f, +1.201702402e-01f, +7.444086492e-02f, +3.051204491e-02f, -3.877817092e-03f, -2.437069214e-02f, -3.063722149e-02f, -2.578182284e-02f, -1.484832400e-02f, -3.024832606e-03f, +5.837696713e-03f, +9.980292652e-03f, +9.668059669e-03f, +6.502103710e-03f, +2.486507371e-03f, -7.710165285e-04f, -2.482375745e-03f, -2.680419852e-03f, -1.920873431e-03f, -8.875885761e-04f, -8.392608453e-05f, +2.949411810e-04f, +3.168094589e-04f,
        -5.961544252e-04f, -9.321954338e-04f, -6.008310570e-04f, +9.149666782e-04f, +3.416711482e-03f, +5.581804959e-03f, +5.318888896e-03f, +1.028052172e-03f, -6.812883197e-03f, -1.486824537e-02f, -1.795624778e-02f, -1.184757153e-02f, +3.499666927e-03f, +2.239878781e-02f, +3.518002950e-02f, +3.299632404e-02f, +1.334473237e-02f, -1.704514211e-02f, -4.428243918e-02f, -5.394874174e-02f, -3.900185590e-02f, -4.449769137e-03f, +3.425361204e-02f, +5.868449360e-02f, +5.692712557e-02f, +2.984408633e-02f, -9.380267921e-03f, -4.216559311e-02f, -5.404966003e-02f, -4.158409081e-02f, -1.309541139e-02f, +1.661440363e-02f, +3.425878657e-02f, +3.425999873e-02f, +2.015671688e-02f, +1.217815800e-03f, -1.316992252e-02f, -1.801487879e-02f, -1.402186424e-02f, -5.726670876e-03f, +1.795556809e-03f, +5.553187233e-03f, +5.399167858e-03f, +3.084513448e-03f, +6.572675528e-04f, -7.006296063e-04f, -9.128497784e-04f, -5.396504007e-04f,
        -4.945857699e-06f, +1.304358400e-05f, +3.999173360e-05f, +6.250766044e-05f, +6.099182201e-05f, +1.893228750e-05f, -6.502170838e-05f, -1.681974456e-04f, -2.446890194e-04f, -2.392514164e-04f, -1.119398682e-04f, +1.351930717e-04f, +4.417434806e-04f, +6.939243061e-04f, +7.547862708e-04f, +5.131112602e-04f, -6.534022092e-05f, -9.049084268e-04f, -1.822257674e-03f, -2.568940384e-03f, -2.904108821e-03f, -2.674115275e-03f, -1.870690780e-03f, -6.451129269e-04f, +7.293192398e-04f, +1.935583524e-03f, +2.706029398e-03f, +2.898771256e-03f, +2.532112331e-03f, +1.767213469e-03f, +8.478003715e-04f, +2.016437824e-05f, -5.382413675e-04f, -7.589818174e-04f, -6.823637033e-04f, -4.227929053e-04f, -1.170751551e-04f, +1.237056884e-04f, +2.429077650e-04f, +2.417539890e-04f, +1.619652302e-04f, +5.884495123e-05f, -2.288397489e-05f, -6.215438664e-05f, -6.159237027e-05f, -3.825356979e-05f, -1.156896150e-05f, +5.637757799e-06f,
        +2.823513717e-05f, +8.448833148e-06f, -5.229067766e-05f, -1.310594480e-04f, -1.658191595e-04f, -8.678301235e-05f, +1.252489455e-04f, +3.914113038e-04f, +5.444424981e-04f, +4.140303935e-04f, -4.762899468e-05f, -6.805432797e-04f, -1.149612253e-03f, -1.110285526e-03f, -4.305681031e-04f, +6.671607956e-04f, +1.658454472e-03f, +1.970803397e-03f, +1.315147357e-03f, -1.004018296e-04f, -1.623353899e-03f, -2.476237130e-03f, -2.177910002e-03f, -8.261333500e-04f, +9.312346806e-04f, +2.231615706e-03f, +2.454261653e-03f, +1.540383314e-03f, +5.164610520e-07f, -1.383201013e-03f, -1.978927318e-03f, -1.611216795e-03f, -5.953017304e-04f, +4.894626724e-04f, +1.131785412e-03f, +1.132238874e-03f, +6.418077115e-04f, +1.100202104e-05f, -4.323507393e-04f, -5.417698232e-04f, -3.760933330e-04f, -1.090493913e-04f, +9.585408879e-05f, +1.663788745e-04f, +1.266396775e-04f, +4.750787164e-05f, -1.089682223e-05f, -2.826888741e-05f,
        /*  3, 8 (48) */
        +3.224472167e-04f, +2.833722195e-04f, -1.221796543e-04f, -9.491809464e-04f, -1.983027818e-03f, -2.703303827e-03f, -2.423530794e-03f, -6.090512983e-04f, +2.728261360e-03f, +6.745011475e-03f, +9.791765357e-03f, +9.863217497e-03f, +5.414903808e-03f, -3.707196309e-03f, -1.560730582e-02f, -2.632006421e-02f, -3.061705711e-02f, -2.352289177e-02f, -2.110603623e-03f, +3.304415724e-02f, +7.733963617e-02f, +1.228762696e-01f, +1.603343828e-01f, +1.814744951e-01f, +1.814744951e-01f, +1.603343828e-01f, +1.228762696e-01f, +7.733963617e-02f, +3.304415724e-02f, -2.110603623e-03f, -2.352289177e-02f, -3.061705711e-02f, -2.632006421e-02f, -1.560730582e-02f, -3.707196309e-03f, +5.414903808e-03f, +9.863217497e-03f, +9.791765357e-03f, +6.745011475e-03f, +2.728261360e-03f, -6.090512983e-04f, -2.423530794e-03f, -2.703303827e-03f, -1.983027818e-03f, -9.491809464e-04f, -1.221796543e-04f, +2.833722195e-04f, +3.224472167e-04f,
        -5.679192881e-04f, -9.237466006e-04f, -6.531217347e-04f, +7.839072303e-04f, +3.250892322e-03f, +5.495021947e-03f, +5.444137841e-03f, +1.419463476e-03f, -6.268440699e-03f, -1.445421498e-02f, -1.800387677e-02f, -1.252811481e-02f, +2.350054674e-03f, +2.128850229e-02f, +3.474946140e-02f, +3.366348484e-02f, +1.500318684e-02f, -1.507433871e-02f, -4.296729183e-02f, -5.404914357e-02f, -4.062520980e-02f, -6.926006268e-03f, +3.207570204e-02f, +5.785836025e-02f, +5.785836025e-02f, +3.207570204e-02f, -6.926006268e-03f, -4.062520980e-02f, -5.404914357e-02f, -4.296729183e-02f, -1.507433871e-02f, +1.500318684e-02f, +3.366348484e-02f, +3.474946140e-02f, +2.128850229e-02f, +2.350054674e-03f, -1.252811481e-02f, -1.800387677e-02f, -1.445421498e-02f, -6.268440699e-03f, +1.419463476e-03f, +5.444137841e-03f, +5.495021947e-03f, +3.250892322e-03f, +7.839072303e-04f, -6.531217347e-04f, -9.237466006e-04f, -5.679192881e-04f,
        -5.637757799e-06f, +1.156896150e-05f, +3.825356979e-05f, +6.159237027e-05f, +6.215438664e-05f, +2.288397489e-05f, -5.884495123e-05f, -1.619652302e-04f, -2.417539890e-04f, -2.429077650e-04f, -1.237056884e-04f, +1.170751551e-04f, +4.227929053e-04f, +6.823637033e-04f, +7.589818174e-04f, +5.382413675e-04f, -2.016437824e-05f, -8.478003715e-04f, -1.767213469e-03f, -2.532112331e-03f, -2.898771256e-03f, -2.706029398e-03f, -1.935583524e-03f, -7.293192398e-04f, +6.451129269e-04f, +1.870690780e-03f, +2.674115275e-03f, +2.904108821e-03f, +2.568940384e-03f, +1.822257674e-03f, +9.049084268e-04f, +6.534022092e-05f, -5.131112602e-04f, -7.547862708e-04f, -6.939243061e-04f, -4.417434806e-04f, -1.351930717e-04f, +1.119398682e-04f, +2.392514164e-04f, +2.446890194e-04f, +1.681974456e-04f, +6.502170838e-05f, -1.893228750e-05f, -6.099182201e-05f, -6.250766044e-05f, -3.999173360e-05f, -1.304358400e-05f, +4.945857699e-06f,
        +2.826888741e-05f, +1.089682223e-05f, -4.750787164e-05f, -1.266396775e-04f, -1.663788745e-04f, -9.585408879e-05f, +1.090493913e-04f, +3.760933330e-04f, +5.417698232e-04f, +4.323507393e-04f, -1.100202104e-05f, -6.418077115e-04f, -1.132238874e-03f, -1.131785412e-03f, -4.894626724e-04f, +5.953017304e-04f, +1.611216795e-03f, +1.978927318e-03f, +1.383201013e-03f, -5.164610520e-07f, -1.540383314e-03f, -2.454261653e-03f, -2.231615706e-03f, -9.312346806e-04f, +8.261333500e-04f, +2.177910002e-03f, +2.476237130e-03f, +1.623353899e-03f, +1.004018296e-04f, -1.315147357e-03f, -1.970803397e-03f, -1.658454472e-03f, -6.671607956e-04f, +4.305681031e-04f, +1.110285526e-03f, +1.149612253e-03f, +6.805432797e-04f, +4.762899468e-05f, -4.140303935e-04f, -5.444424981e-04f, -3.914113038e-04f, -1.252489455e-04f, +8.678301235e-05f, +1.658191595e-04f, +1.310594480e-04f, +5.229067766e-05f, -8.448833148e-06f, -2.823513717e-05f,
        /*  3, 9 (48) */
        +3.168094589e-04f, +2.949411810e-04f, -8.392608453e-05f, -8.875885761e-04f, -1.920873431e-03f, -2.680419852e-03f, -2.482375745e-03f, -7.710165285e-04f, +2.486507371e-03f, +6.502103710e-03f, +9.668059669e-03f, +9.980292652e-03f, +5.837696713e-03f, -3.024832606e-03f, -1.484832400e-02f, -2.578182284e-02f, -3.063722149e-02f, -2.437069214e-02f, -3.877817092e-03f, +3.051204491e-02f, +7.444086492e-02f, +1.201702402e-01f, +1.583987993e-01f, +1.807451759e-01f, +1.821196081e-01f, +1.622050736e-01f, +1.255503848e-01f, +8.024374500e-02f, +3.561309763e-02f, -2.883459489e-04f, -2.261798335e-02f, -3.055171689e-02f, -2.683317547e-02f, -1.636209209e-02f, -4.401120615e-03f, +4.973160327e-03f, +9.728024426e-03f, +9.903705225e-03f, +6.984262892e-03f, +2.972950379e-03f, -4.408538528e-04f, -2.358509085e-03f, -2.722236114e-03f, -2.044019640e-03f, -1.011688607e-03f, -1.621713879e-04f, +2.703286355e-04f, +3.273930744e-04f,
        -5.396504007e-04f, -9.128497784e-04f, -7.006296063e-04f, +6.572675528e-04f, +3.084513448e-03f, +5.399167858e-03f, +5.553187233e-03f, +1.795556809e-03f, -5.726670876e-03f, -1.402186424e-02f, -1.801487879e-02f, -1.316992252e-02f, +1.217815800e-03f, +2.015671688e-02f, +3.425999873e-02f, +3.425878657e-02f, +1.661440363e-02f, -1.309541139e-02f, -4.158409081e-02f, -5.404966003e-02f, -4.216559311e-02f, -9.380267921e-03f, +2.984408633e-02f, +5.692712557e-02f, +5.868449360e-02f, +3.425361204e-02f, -4.449769137e-03f, -3.900185590e-02f, -5.394874174e-02f, -4.428243918e-02f, -1.704514211e-02f, +1.334473237e-02f, +3.299632404e-02f, +3.518002950e-02f, +2.239878781e-02f, +3.499666927e-03f, -1.184757153e-02f, -1.795624778e-02f, -1.486824537e-02f, -6.812883197e-03f, +1.028052172e-03f, +5.318888896e-03f, +5.581804959e-03f, +3.416711482e-03f, +9.149666782e-04f, -6.008310570e-04f, -9.321954338e-04f, -5.961544252e-04f,
        -6.277731151e-06f, +1.013473749e-05f, +3.650476181e-05f, +6.058749407e-05f, +6.315656259e-05f, +2.666170461e-05f, -5.276002987e-05f, -1.556458342e-04f, -2.385075365e-04f, -2.460804233e-04f, -1.349768817e-04f, +9.922972144e-05f, +4.036713219e-04f, +6.700813706e-04f, +7.619910206e-04f, +5.620156431e-04f, +2.392257303e-05f, -7.910745906e-04f, -1.711565276e-03f, -2.493700993e-03f, -2.891200247e-03f, -2.735632550e-03f, -1.998731146e-03f, -8.128518704e-04f, +5.603102941e-04f, +1.804107560e-03f, +2.639907083e-03f, +2.907189572e-03f, +2.604131718e-03f, +1.876633085e-03f, +9.623428273e-04f, +1.115728219e-04f, -4.866283813e-04f, -7.493831600e-04f, -7.047293621e-04f, -4.604900653e-04f, -1.535615665e-04f, +9.968610268e-05f, +2.351049243e-04f, +2.472991710e-04f, +1.743289664e-04f, +7.128169313e-05f, -1.480872188e-05f, -5.966583346e-05f, -6.332821795e-05f, -4.171487722e-05f, -1.455657929e-05f, +4.201705979e-06f,
        +2.819160034e-05f, +1.317282348e-05f, -4.282064965e-05f, -1.220709847e-04f, -1.664924659e-04f, -1.043664581e-04f, +9.312586483e-05f, +3.603849945e-04f, +5.379838352e-04f, +4.492946910e-04f, +2.482737724e-05f, -6.025344230e-04f, -1.112880096e-03f, -1.150655407e-03f, -5.465179258e-04f, +5.232002321e-04f, +1.561356583e-03f, +1.983116330e-03f, +1.448015545e-03f, +9.870454600e-05f, -1.454873583e-03f, -2.427647501e-03f, -2.280914348e-03f, -1.034465965e-03f, +7.193722573e-04f, +2.119896241e-03f, +2.493513154e-03f, +1.703604432e-03f, +2.007522737e-04f, -1.243968472e-03f, -1.958724338e-03f, -1.702942683e-03f, -7.386236059e-04f, +3.699329842e-04f, +1.086160006e-03f, +1.164927174e-03f, +7.186448143e-04f, +8.498817533e-05f, -3.943431627e-04f, -5.459665106e-04f, -4.062904505e-04f, -1.416923013e-04f, +7.715795035e-05f, +1.647981405e-04f, +1.353112227e-04f, +5.715832945e-05f, -5.828718348e-06f, -2.808438836e-05f,
        /*  3,10 (48) */
        +3.105317277e-04f, +3.050759185e-04f, -4.742132272e-05f, -8.270010821e-04f, -1.857716868e-03f, -2.653758147e-03f, -2.535135775e-03f, -9.266623627e-04f, +2.247999834e-03f, +6.256023287e-03f, +9.533082787e-03f, +1.007952237e-02f, +6.241368035e-03f, -2.354751235e-03f, -1.408633298e-02f, -2.521980720e-02f, -3.061329892e-02f, -2.516176673e-02f, -5.589382368e-03f, +2.801834392e-02f, +7.154966467e-02f, +1.174346076e-01f, +1.564000682e-01f, +1.799323240e-01f, +1.826799183e-01f, +1.640091812e-01f, +1.281902919e-01f, +8.315093457e-02f, +3.821722934e-02f, +1.588287136e-03f, -2.165564052e-02f, -3.044014407e-02f, -2.731980385e-02f, -1.711147525e-02f, -5.105849977e-03f, +4.512670262e-03f, +9.574462859e-03f, +1.000339133e-02f, +7.219367816e-03f, +3.220249550e-03f, -2.665248864e-04f, -2.287227392e-03f, -2.737044836e-03f, -2.103685473e-03f, -1.075016825e-03f, -2.038862651e-04f, +2.557720562e-04f, +3.315947804e-04f,
        -5.114588003e-04f, -8.996769549e-04f, -7.434502560e-04f, +5.351965681e-04f, +2.918020982e-03f, +5.294801400e-03f, +5.646313098e-03f, +2.155941804e-03f, -5.188687040e-03f, -1.357256955e-02f, -1.799005142e-02f, -1.377245694e-02f, +1.049357040e-04f, +1.900606147e-02f, +3.371348080e-02f, +3.478198680e-02f, +1.817576022e-02f, -1.111229506e-02f, -4.013607527e-02f, -5.395095548e-02f, -4.362046669e-02f, -1.180791542e-02f, +2.756317198e-02f, +5.589265961e-02f, +5.940386586e-02f, +3.637350828e-02f, -1.956255983e-03f, -3.729825146e-02f, -5.374798947e-02f, -4.552640766e-02f, -1.900386645e-02f, +1.164178968e-02f, +3.225770044e-02f, +3.554996249e-02f, +2.348494782e-02f, +4.664594100e-03f, -1.112892671e-02f, -1.787125960e-02f, -1.526258854e-02f, -7.358849707e-03f, +6.217617216e-04f, +5.177196595e-03f, +5.658962910e-03f, +3.581509622e-03f, +1.050277901e-03f, -5.436727276e-04f, -9.380241521e-04f, -6.242388136e-04f,
        -6.866220693e-06f, +8.742775860e-06f, +3.474956812e-05f, +5.949820540e-05f, +6.400161198e-05f, +3.026378360e-05f, -4.677515583e-05f, -1.492525790e-04f, -2.349633169e-04f, -2.487764871e-04f, -1.457477053e-04f, +8.167777557e-05f, +3.844112664e-04f, +6.571114549e-04f, +7.638362764e-04f, +5.844327786e-04f, +6.689027310e-05f, -7.347858775e-04f, -1.655377914e-03f, -2.453761118e-03f, -2.881421461e-03f, -2.762910412e-03f, -2.060081029e-03f, -8.956342544e-04f, +4.749894117e-04f, +1.735890485e-03f, +2.603424299e-03f, +2.907992474e-03f, +2.637634286e-03f, +1.930274992e-03f, +1.020046567e-03f, +1.588282957e-04f, -4.587975622e-04f, -7.427524870e-04f, -7.147454391e-04f, -4.789992715e-04f, -1.721578512e-04f, +8.695202101e-05f, +2.304625031e-04f, +2.495712134e-04f, +1.803461058e-04f, +7.761590678e-05f, -1.051574984e-05f, -5.817362492e-05f, -6.404893482e-05f, -4.341851334e-05f, -1.610575965e-05f, +3.405100316e-06f,
        +2.800936709e-05f, +1.527753494e-05f, -3.823904117e-05f, -1.173721915e-04f, -1.661758416e-04f, -1.123170193e-04f, +7.750898066e-05f, +3.443344526e-04f, +5.331217223e-04f, +4.648561908e-04f, +5.979698620e-05f, -5.628191870e-04f, -1.091612204e-03f, -1.166897134e-03f, -6.016404427e-04f, +4.510088204e-04f, +1.509005084e-03f, +1.983398884e-03f, +1.509484792e-03f, +1.970645351e-04f, -1.367010098e-03f, -2.396464998e-03f, -2.325716381e-03f, -1.135620996e-03f, +6.111653058e-04f, +2.057682689e-03f, +2.506038658e-03f, +1.780958912e-03f, +3.013663031e-04f, -1.169785795e-03f, -1.942678244e-03f, -1.744559142e-03f, -8.095353725e-04f, +3.076612684e-04f, +1.059419058e-03f, +1.178114037e-03f, +7.560156839e-04f, +1.230111396e-04f, -3.733020566e-04f, -5.463084825e-04f, -4.206821447e-04f, -1.583456646e-04f, +6.698527863e-05f, +1.633014308e-04f, +1.393757265e-04f, +6.209938901e-05f, -3.036922064e-06f, -2.781083669e-05f,
        /*  3,11 (48) */
        +3.036655070e-04f, +3.138186943e-04f, -1.267175460e-05f, -7.675028767e-04f, -1.793715256e-03f, -2.623494363e-03f, -2.581910930e-03f, -1.075914942e-03f, +2.013036517e-03f, +6.007246800e-03f, +9.387335081e-03f, +1.016120015e-02f, +6.625779301e-03f, -1.697639780e-03f, -1.332249670e-02f, -2.463537442e-02f, -3.054640865e-02f, -2.589655261e-02f, -7.244760282e-03f, +2.556458280e-02f, +6.866824321e-02f, +1.146716972e-01f, +1.543399871e-01f, +1.790366898e-01f, +1.831549078e-01f, +1.657450717e-01f, +1.307937162e-01f, +8.605892704e-02f, +4.085486363e-02f, +3.518562128e-03f, -2.063559395e-02f, -3.028131578e-02f, -2.777860141e-02f, -1.785422774e-02f, -5.820595416e-03f, +4.033670990e-03f, +9.402305008e-03f, +1.009034335e-02f, +7.449830319e-03f, +3.469820763e-03f, -8.617878055e-05f, -2.209611485e-03f, -2.747560586e-03f, -2.161859098e-03f, -1.139065760e-03f, -2.473047785e-04f, +2.396662965e-04f, +3.349998807e-04f,
        -4.834494332e-04f, -8.843994200e-04f, -7.816892972e-04f, +4.178243766e-04f, +2.751845140e-03f, +5.182484381e-03f, +5.723822078e-03f, +2.500276256e-03f, -4.655565318e-03f, -1.310771336e-02f, -1.793025443e-02f, -1.433527613e-02f, -9.866765005e-04f, +1.783916434e-02f, +3.311184036e-02f, +3.523299562e-02f, +1.968476530e-02f, -9.128896180e-03f, -3.862659048e-02f, -5.375389095e-02f, -4.498747679e-02f, -1.420438042e-02f, +2.523745560e-02f, +5.475703861e-02f, +6.001503116e-02f, +3.843119097e-02f, +5.497826750e-04f, -3.551729255e-02f, -5.344662316e-02f, -4.669619345e-02f, -2.094654469e-02f, +9.897230542e-03f, +3.144816507e-02f, +3.585762376e-02f, +2.454436688e-02f, +5.842708137e-03f, -1.037291103e-02f, -1.774824846e-02f, -1.563589059e-02f, -7.905158190e-03f, +2.010795769e-04f, +5.018850930e-03f, +5.725948188e-03f, +3.744811053e-03f, +1.189653627e-03f, -4.815733386e-04f, -9.410610742e-04f, -6.520496503e-04f,
        -7.403782787e-06f, +7.394779215e-06f, +3.299212377e-05f, +5.832969341e-05f, +6.469301128e-05f, +3.368889852e-05f, -4.089813856e-05f, -1.427985743e-04f, -2.311351558e-04f, -2.510036692e-04f, -1.560133449e-04f, +6.443940815e-05f, +3.650447888e-04f, +6.434883797e-04f, +7.645411078e-04f, +6.054931951e-04f, +1.087101536e-04f, -6.789878318e-04f, -1.598716139e-03f, -2.412348689e-03f, -2.869462815e-03f, -2.787851257e-03f, -2.119582649e-03f, -9.775907166e-04f, +3.892289646e-04f, +1.666098084e-03f, +2.564688960e-03f, +2.906498868e-03f, +2.669397502e-03f, +1.983118864e-03f, +1.077961627e-03f, +2.070710274e-04f, -4.296254235e-04f, -7.348755228e-04f, -7.239395436e-04f, -4.972373481e-04f, -1.909582720e-04f, +7.374620772e-05f, +2.253190591e-04f, +2.514921708e-04f, +1.862350249e-04f, +8.401496727e-05f, -6.056241004e-06f, -5.651265163e-05f, -6.466475356e-05f, -4.509804999e-05f, -1.768877557e-05f, +2.555965243e-06f,
        +2.772838204e-05f, +1.721219165e-05f, -3.377236041e-05f, -1.125618207e-04f, -1.654455694e-04f, -1.197042549e-04f, +6.222770278e-05f, +3.279894630e-04f, +5.272223775e-04f, +4.790325759e-04f, +9.384783611e-05f, -5.227570188e-04f, -1.068514493e-03f, -1.180518003e-03f, -6.547422921e-04f, +3.788783831e-04f, +1.454297523e-03f, +1.979811515e-03f, +1.567510509e-03f, +2.943698963e-04f, -1.276982314e-03f, -2.360793830e-03f, -2.365941895e-03f, -1.234498089e-03f, +5.017295534e-04f, +1.991386654e-03f, +2.513772428e-03f, +1.855246655e-03f, +4.020406563e-04f, -1.092728083e-03f, -1.922661652e-03f, -1.783186529e-03f, -8.797406818e-04f, +2.438619218e-04f, +1.030078903e-03f, +1.189106918e-03f, +7.925591648e-04f, +1.616265181e-04f, -3.509236252e-04f, -5.454371371e-04f, -4.345377090e-04f, -1.751737233e-04f, +5.627305695e-05f, +1.613155044e-04f, +1.432335341e-04f, +6.710173023e-05f, -7.449142443e-08f, -2.740886232e-05f,
        /*  3,12 (48) */
        +2.962617242e-04f, +3.212134736e-04f, +2.032036918e-05f, -7.091731833e-04f, -1.729022245e-03f, -2.589805465e-03f, -2.622809069e-03f, -1.218713516e-03f, +1.781901362e-03f, +5.756243131e-03f, +9.231321737e-03f, +1.022563956e-02f, +6.990824090e-03f, -1.054151401e-03f, -1.255795560e-02f, -2.402988123e-02f, -3.043769849e-02f, -2.657554044e-02f, -8.843476421e-03f, +2.315223411e-02f, +6.579878040e-02f, +1.118838460e-01f, +1.522204045e-01f, +1.780590990e-01f, +1.835441367e-01f, +1.674111697e-01f, +1.333584052e-01f, +8.896542591e-02f, +4.352426113e-02f, +5.501680991e-03f, -1.955763232e-02f, -3.007424475e-02f, -2.820822684e-02f, -1.858910326e-02f, -6.544534960e-03f, +3.536433642e-03f, +9.211346736e-03f, +1.016408956e-02f, +7.675149378e-03f, +3.721312934e-03f, +1.000562444e-04f, -2.125596518e-03f, -2.753616827e-03f, -2.218371750e-03f, -1.203730513e-03f, -2.924028285e-04f, +2.219775210e-04f, +3.375558459e-04f,
        -4.557210512e-04f, -8.671872283e-04f, -8.154616576e-04f, +3.052625560e-04f, +2.586399571e-03f, +5.062780126e-03f, +5.786049781e-03f, +2.828265719e-03f, -4.128342940e-03f, -1.262868078e-02f, -1.783640660e-02f, -1.485803315e-02f, -2.055190993e-03f, +1.665864633e-02f, +3.245709807e-02f, +3.561187401e-02f, +2.113906282e-02f, -7.149084665e-03f, -3.705907997e-02f, -5.345952105e-02f, -4.626445911e-02f, -1.656517425e-02f, +2.287151370e-02f, +5.352254052e-02f, +6.051676072e-02f, +4.042257762e-02f, +3.063555103e-03f, -3.366204590e-02f, -5.304458251e-02f, -4.778892153e-02f, -2.286920634e-02f, +8.114044013e-03f, +3.056842438e-02f, +3.610148568e-02f, +2.557444578e-02f, +7.031815056e-03f, -9.580351865e-03f, -1.758662195e-02f, -1.598681422e-02f, -8.450595327e-03f, -2.334581321e-04f, +4.843677207e-03f, +5.782221245e-03f, +3.906126557e-03f, +1.332887162e-03f, -4.144716084e-04f, -9.411355656e-04f, -6.794585126e-04f,
        -7.891082444e-06f, +6.092289786e-06f, +3.123643501e-05f, +5.708715158e-05f, +6.523443877e-05f, +3.693610856e-05f, -3.513638102e-05f, -1.362966996e-04f, -2.270370214e-04f, -2.527702729e-04f, -1.657699032e-04f, +4.753378261e-05f, +3.456034145e-04f, +6.292467916e-04f, +7.641301153e-04f, +6.251990193e-04f, +1.493554528e-04f, -6.237328043e-04f, -1.541644556e-03f, -2.369520845e-03f, -2.855354432e-03f, -2.810445952e-03f, -2.177187626e-03f, -1.058646560e-03f, +3.031081595e-04f, +1.594790730e-03f, +2.523725649e-03f, +2.902692508e-03f, +2.699372312e-03f, +2.035100429e-03f, +1.136029036e-03f, +2.562636991e-04f, -3.991203899e-04f, -7.257348527e-04f, -7.322791757e-04f, -5.151702243e-04f, -2.099383286e-04f, +6.007820864e-05f, +2.196702144e-04f, +2.530493507e-04f, +1.919817537e-04f, +9.046911708e-05f, -1.433467579e-06f, -5.468063210e-05f, -6.517067925e-05f, -4.674879763e-05f, -1.930311625e-05f, +1.654356283e-06f,
        +2.735491682e-05f, +1.897854157e-05f, -2.942920216e-05f, -1.076580508e-04f, -1.643188099e-04f, -1.265281901e-04f, +4.730931145e-05f, +3.113972596e-04f, +5.203262624e-04f, +4.918245151e-04f, +1.269242815e-04f, -4.824419647e-04f, -1.043669022e-03f, -1.191531114e-03f, -7.057411623e-04f, +3.069578549e-04f, +1.397372766e-03f, +1.972398693e-03f, +1.622002527e-03f, +3.904304742e-04f, -1.184983313e-03f, -2.320722836e-03f, -2.401520771e-03f, -1.330900520e-03f, +3.912847393e-04f, +1.921134244e-03f, +2.516683224e-03f, +1.926302692e-03f, +5.025707398e-04f, -1.012931182e-03f, -1.898679610e-03f, -1.818712806e-03f, -9.490838417e-04f, +1.786487368e-04f, +9.981618200e-04f, +1.197843781e-03f, +8.281786720e-04f, +2.007601133e-04f, -3.272279914e-04f, -5.433234257e-04f, -4.478085433e-04f, -1.921397021e-04f, +4.503105467e-05f, +1.588277613e-04f, +1.468651244e-04f, +7.215255303e-05f, +3.056904113e-06f, -2.687305772e-05f,
        /*  3,13 (48) */
        +2.883706418e-04f, +3.273057633e-04f, +5.155680418e-05f, -6.520860317e-04f, -1.663787806e-03f, -2.552869356e-03f, -2.657945450e-03f, -1.355010216e-03f, +1.554864340e-03f, +5.503472858e-03f, +9.065551833e-03f, +1.027317334e-02f, +7.336427504e-03f, -4.249046089e-04f, -1.179382548e-02f, -2.340468221e-02f, -3.028834304e-02f, -2.719927325e-02f, -1.038512098e-02f, +2.078271327e-02f, +6.294342596e-02f, +1.090734000e-01f, +1.500432169e-01f, +1.770004525e-01f, +1.838472449e-01f, +1.690059605e-01f, +1.358821308e-01f, +9.186811842e-02f, +4.622363344e-02f, +7.536781420e-03f, -1.842160329e-02f, -2.981798105e-02f, -2.860734723e-02f, -1.931483811e-02f, -7.276814136e-03f, +3.021263418e-03f, +9.001408407e-03f, +1.022416777e-02f, +7.894819592e-03f, +3.974362285e-03f, +2.920379980e-04f, -2.035127401e-03f, -2.755050294e-03f, -2.273052382e-03f, -1.268901192e-03f, -3.391516261e-04f, +2.026744047e-04f, +3.392102022e-04f,
        -4.283661344e-04f, -8.482086868e-04f, -8.448908597e-04f, +1.976045052e-04f, +2.422080761e-03f, +4.936251936e-03f, +5.833359092e-03f, +3.139662979e-03f, -3.608016678e-03f, -1.213685627e-02f, -1.770948231e-02f, -1.534047511e-02f, -3.098860015e-03f, +1.546711522e-02f, +3.175135691e-02f, +3.591883186e-02f, +2.253643559e-02f, -5.176685972e-03f, -3.543707744e-02f, -5.306909058e-02f, -4.744944242e-02f, -1.888589709e-02f, +2.046999293e-02f, +5.219164000e-02f, +6.090804546e-02f, +4.234371187e-02f, +5.580238328e-03f, -3.173574321e-02f, -5.254201177e-02f, -4.880185272e-02f, -2.476788595e-02f, +6.295331207e-03f, +2.961934054e-02f, +3.628013442e-02f, +2.657260760e-02f, +8.229658837e-03f, -8.752173193e-03f, -1.738586183e-02f, -1.631404221e-02f, -8.993918753e-03f, -6.812666753e-04f, +4.651537505e-03f, +5.827252300e-03f, +4.064954319e-03f, +1.479752286e-03f, -3.423190553e-04f, -9.380786615e-04f, -7.063315703e-04f,
        -8.328888420e-06f, +4.836690636e-06f, +2.948637421e-05f, +5.577576691e-05f, +6.562976180e-05f, +4.000483767e-05f, -2.949687597e-05f, -1.297595871e-04f, -2.226829976e-04f, -2.540851657e-04f, -1.750143867e-04f, +3.097912402e-05f, +3.261181077e-04f, +6.144215072e-04f, +7.626289262e-04f, +6.435540565e-04f, +1.888012286e-04f, -5.690718432e-04f, -1.484227549e-03f, -2.325335806e-03f, -2.839128589e-03f, -2.830687958e-03f, -2.232849779e-03f, -1.138728152e-03f, +2.167066311e-04f, +1.522030573e-03f, +2.480561472e-03f, +2.896559589e-03f, +2.727511272e-03f, +2.086155759e-03f, +1.194188938e-03f, +3.063673185e-04f, -3.672927030e-04f, -7.153144195e-04f, -7.397323830e-04f, -5.327635541e-04f, -2.290726963e-04f, +4.595853568e-05f, +2.135123302e-04f, +2.542303720e-04f, +1.975722132e-04f, +9.696823219e-05f, +3.348891556e-06f, -5.267555978e-05f, -6.556179178e-05f, -4.836597661e-05f, -2.094611058e-05f, +7.004638822e-07f,
        +2.689529487e-05f, +2.057882056e-05f, -2.521744019e-05f, -1.026786732e-04f, -1.628132499e-04f, -1.327903489e-04f, +3.277937540e-05f, +2.946044465e-04f, +5.124752704e-04f, +5.032359372e-04f, +1.589740718e-04f, -4.419668961e-04f, -1.017160390e-03f, -1.199955147e-03f, -7.545604759e-04f, +2.353939035e-04f, +1.338372963e-03f, +1.961212656e-03f, +1.672878888e-03f, +4.850599651e-04f, -1.091209358e-03f, -2.276349786e-03f, -2.432392809e-03f, -1.424636953e-03f, +2.800528054e-04f, +1.847060106e-03f, +2.514749879e-03f, +1.993968156e-03f, +6.027510728e-04f, -9.305377716e-04f, -1.870745738e-03f, -1.851031519e-03f, -1.017409233e-03f, +1.121401310e-04f, +9.636961824e-04f, +1.204266684e-03f, +8.627779927e-04f, +2.403350278e-04f, -3.022388744e-04f, -5.399406518e-04f, -4.604462536e-04f, -2.092054228e-04f, +3.327077228e-05f, +1.558265929e-04f, +1.502509361e-04f, +7.723840020e-05f, +6.354954773e-06f, -2.619825575e-05f,
        /*  3,14 (48) */
        +2.800417534e-04f, +3.321424540e-04f, +8.104317839e-05f, -5.963102648e-04f, -1.598158045e-03f, -2.512864519e-03f, -2.687442326e-03f, -1.484769803e-03f, +1.332181343e-03f, +5.249387692e-03f, +8.890537447e-03f, +1.030415246e-02f, +7.662545612e-03f, +1.895168983e-04f, -1.103119655e-02f, -2.276112815e-02f, -3.009954181e-02f, -2.776834509e-02f, -1.186934853e-02f, +1.845737746e-02f, +6.010429737e-02f, +1.062427120e-01f, +1.478103671e-01f, +1.758617243e-01f, +1.840639515e-01f, +1.705279911e-01f, +1.383626923e-01f, +9.476467801e-02f, +4.895114472e-02f, +9.622937179e-03f, -1.722741435e-02f, -2.951161373e-02f, -2.897463993e-02f, -2.003015253e-02f, -8.016546519e-03f, +2.488499864e-03f, +8.772335711e-03f, +1.027012630e-02f, +8.108331923e-03f, +4.228592657e-03f, +4.896102112e-04f, -1.938159169e-03f, -2.751701403e-03f, -2.325727942e-03f, -1.334462984e-03f, -3.875176027e-04f, +1.817282941e-04f, +3.399106661e-04f,
        -4.014708395e-04f, -8.276298662e-04f, -8.701082999e-04f, +9.492583196e-05f, +2.259267511e-03f, +4.803461587e-03f, +5.866138468e-03f, +3.434267425e-03f, -3.095541408e-03f, -1.163362033e-02f, -1.755050824e-02f, -1.578244201e-02f, -4.116020405e-03f, +1.426716007e-02f, +3.099679643e-02f, +3.615422576e-02f, +2.387480855e-02f, -3.215473316e-03f, -3.376419855e-02f, -5.258403061e-02f, -4.854065178e-02f, -2.116224687e-02f, +1.803760013e-02f, +5.076700305e-02f, +6.118809826e-02f, +4.419077197e-02f, +8.094988206e-03f, -2.974177505e-02f, -5.193926069e-02f, -4.973239049e-02f, -2.663863169e-02f, +4.444299688e-03f, +2.860193131e-02f, +3.639227455e-02f, +2.753630378e-02f, +9.433925520e-03f, -7.889395200e-03f, -1.714552680e-02f, -1.661628108e-02f, -9.533859405e-03f, -1.141712929e-03f, +4.442332082e-03f, +5.860523072e-03f, +4.220780912e-03f, +1.630003222e-03f, -2.650806551e-04f, -9.317237067e-04f, -7.325298261e-04f,
        -8.718068193e-06f, +3.629207216e-06f, +2.774567533e-05f, +5.440070923e-05f, +6.588302403e-05f, +4.289486633e-05f, -2.398620325e-05f, -1.231996048e-04f, -2.180872571e-04f, -2.549577521e-04f, -1.837446921e-04f, +1.479270955e-05f, +3.066192357e-04f, +5.990474603e-04f, +7.600641439e-04f, +6.605637628e-04f, +2.270243687e-04f, -5.150546432e-04f, -1.426529195e-03f, -2.279852789e-03f, -2.820819667e-03f, -2.848573324e-03f, -2.286525170e-03f, -1.217763015e-03f, +1.301043476e-04f, +1.447881465e-03f, +2.435226036e-03f, +2.888088780e-03f, +2.753768608e-03f, +2.136221350e-03f, +1.252380659e-03f, +3.573412500e-04f, -3.341544321e-04f, -7.035995661e-04f, -7.462678156e-04f, -5.499827626e-04f, -2.483352481e-04f, +3.139866995e-05f, +2.068425282e-04f, +2.550231936e-04f, +2.029922384e-04f, +1.035018317e-04f, +8.286747443e-06f, -5.049571450e-05f, -6.583325824e-05f, -4.994472502e-05f, -2.261492841e-05f, -3.053828783e-07f,
        +2.635586685e-05f, +2.201572656e-05f, -2.114422789e-05f, -9.764105202e-05f, -1.609470350e-04f, -1.384937071e-04f, +1.866172927e-05f, +2.776568924e-04f, +5.037125890e-04f, +5.132739533e-04f, +1.899484114e-04f, -4.014233099e-04f, -9.890754911e-04f, -1.205814231e-03f, -8.011294892e-04f, +1.643306246e-04f, +1.277443204e-03f, +1.946313220e-03f, +1.720065970e-03f, +5.780763036e-04f, -9.958594564e-04f, -2.227781133e-03f, -2.458507842e-03f, -1.515521846e-03f, +1.682574121e-04f, +1.769307145e-03f, +2.507961371e-03f, +2.058090656e-03f, +7.023757360e-04f, -8.456970987e-04f, -1.838882264e-03f, -1.880042092e-03f, -1.084561664e-03f, +4.445893301e-05f, +9.267164761e-04f, +1.208321983e-03f, +8.962615228e-04f, +2.802718001e-04f, -2.759836047e-04f, -5.352645915e-04f, -4.724027832e-04f, -2.263313703e-04f, +2.100545850e-05f, +1.523014450e-04f, +1.533714251e-04f, +8.234517685e-05f, +9.816694012e-06f, -2.537955790e-05f,
        /*  3,15 (48) */
        +2.713236852e-04f, +3.357716612e-04f, +1.087888537e-04f, -5.419095556e-04f, -1.532275021e-03f, -2.469969652e-03f, -2.711428529e-03f, -1.607969408e-03f, +1.114094085e-03f, +4.994429940e-03f, +8.706792755e-03f, +1.031894517e-02f, +7.969164848e-03f, +7.885643586e-04f, -1.027113241e-02f, -2.210056439e-02f, -2.987251744e-02f, -2.828339973e-02f, -1.329587772e-02f, +1.617752467e-02f, +5.728347771e-02f, +1.033941387e-01f, +1.455238419e-01f, +1.746439613e-01f, +1.841940559e-01f, +1.719758725e-01f, +1.407979183e-01f, +9.765276679e-02f, +5.170491332e-02f, +1.175915853e-02f, -1.597503369e-02f, -2.915427248e-02f, -2.930879436e-02f, -2.073375210e-02f, -8.762814334e-03f, +1.938517101e-03f, +8.524000463e-03f, +1.030152497e-02f, +8.315174451e-03f, +4.483615851e-03f, +6.926024496e-04f, -1.834657337e-03f, -2.743414655e-03f, -2.376223656e-03f, -1.400296242e-03f, -4.374623277e-04f, +1.591133657e-04f, +3.396052832e-04f,
        -3.751149726e-04f, -8.056141397e-04f, -8.912525278e-04f, -2.715220056e-06f, +2.098320476e-03f, +4.664967880e-03f, +5.884800197e-03f, +3.711924318e-03f, -2.591828819e-03f, -1.112034638e-02f, -1.736055983e-02f, -1.618386532e-02f, -5.105095897e-03f, +1.306134584e-02f, +3.019566694e-02f, +3.631855639e-02f, +2.515225176e-02f, -1.269160096e-03f, -3.204413258e-02f, -5.200595431e-02f, -4.953651123e-02f, -2.339002800e-02f, +1.557909228e-02f, +4.925148120e-02f, +6.135635567e-02f, +4.596007912e-02f, +1.060294958e-02f, -2.768368439e-02f, -5.123688496e-02f, -5.057808759e-02f, -2.847751395e-02f, +2.564257596e-03f, +2.751736964e-02f, +3.643673348e-02f, +2.846302026e-02f, +1.064224750e-02f, -6.993133677e-03f, -1.686525500e-02f, -1.689226469e-02f, -1.006912400e-02f, -1.614115712e-03f, +4.216000711e-03f, +5.881528531e-03f, +4.373082357e-03f, +1.783374647e-03f, -1.827354783e-04f, -9.219070127e-04f, -7.579093840e-04f,
        -9.059582855e-06f, +2.470909225e-06f, +2.601792971e-05f, +5.296712092e-05f, +6.599843263e-05f, +4.560632273e-05f, -1.861052776e-05f, -1.166288410e-04f, -2.132640346e-04f, -2.553979460e-04f, -1.919595909e-04f, -1.009139408e-06f, +2.871365353e-04f, +5.831596506e-04f, +7.564632958e-04f, +6.762352148e-04f, +2.640035975e-04f, -4.617294971e-04f, -1.368613192e-03f, -2.233131932e-03f, -2.800464093e-03f, -2.864100685e-03f, -2.338172154e-03f, -1.295679903e-03f, +4.338151546e-05f, +1.372408895e-03f, +2.387751421e-03f, +2.877271248e-03f, +2.778100290e-03f, +2.185234209e-03f, +1.310542778e-03f, +4.091432488e-04f, -2.997194817e-04f, -6.905770765e-04f, -7.518547806e-04f, -5.667930921e-04f, -2.676990797e-04f, +1.641106349e-05f, +1.996587127e-04f, +2.554161433e-04f, +2.082276012e-04f, +1.100590885e-04f, +1.337559834e-05f, -4.813967360e-05f, -6.598034546e-05f, -5.148010691e-05f, -2.430658232e-05f, -1.362712782e-06f,
        +2.574298666e-05f, +2.329239317e-05f, -1.721600120e-05f, -9.256208576e-05f, -1.587387043e-04f, -1.436426421e-04f, +4.978456466e-06f, +2.605996306e-04f, +4.940825608e-04f, +5.219487723e-04f, +2.198020113e-04f, -3.609011358e-04f, -9.595032747e-04f, -1.209137816e-03f, -8.453833775e-04f, +9.390924656e-05f, +1.214731161e-03f, +1.927767583e-03f, +1.763498582e-03f, +6.693020372e-04f, -8.991349016e-04f, -2.175131749e-03f, -2.479825823e-03f, -1.603375858e-03f, +5.612345016e-05f, +1.688026227e-03f, +2.496316882e-03f, +2.118524642e-03f, +8.012388243e-04f, -7.585646875e-04f, -1.803120048e-03f, -1.905650109e-03f, -1.150386728e-03f, -2.426784483e-05f, +8.872633042e-04f, +1.209960521e-03f, +9.285345060e-04f, +3.204885507e-04f, -2.484931299e-04f, -5.292736097e-04f, -4.836305458e-04f, -2.434767633e-04f, +8.250122829e-06f, +1.482428810e-04f, +1.562071244e-04f, +8.745817246e-05f, +1.343848373e-05f, -2.441236253e-05f,
        /*  4, 0 (48) */
        -4.440791761e-04f, -7.736617456e-04f, -5.842197404e-04f, +4.733051837e-04f, +2.096961908e-03f, +3.159739597e-03f, +2.247925700e-03f, -1.196916207e-03f, -5.859365612e-03f, -8.625924656e-03f, -6.226830420e-03f, +2.191702212e-03f, +1.322393203e-02f, +1.983561445e-02f, +1.498813646e-02f, -3.241530928e-03f, -2.808652174e-02f, -4.494512491e-02f, -3.739225953e-02f, +4.047367480e-03f, +7.496487828e-02f, +1.562849362e-01f, +2.209963868e-01f, +2.456499165e-01f, +2.209963868e-01f, +1.562849362e-01f, +7.496487828e-02f, +4.047367480e-03f, -3.739225953e-02f, -4.494512491e-02f, -2.808652174e-02f, -3.241530928e-03f, +1.498813646e-02f, +1.983561445e-02f, +1.322393203e-02f, +2.191702212e-03f, -6.226830420e-03f, -8.625924656e-03f, -5.859365612e-03f, -1.196916207e-03f, +2.247925700e-03f, +3.159739597e-03f, +2.096961908e-03f, +4.733051837e-04f, -5.842197404e-04f, -7.736617456e-04f, -4.440791761e-04f, -8.710788365e-05f,
        +3.469535659e-04f, +1.336667044e-03f, +1.790286751e-03f, +2.794767810e-04f, -3.303519821e-03f, -6.405731284e-03f, -4.976271198e-03f, +2.686342793e-03f, +1.248168983e-02f, +1.571582859e-02f, +5.946321108e-03f, -1.341789307e-02f, -2.845267002e-02f, -2.424163753e-02f, +1.494761300e-03f, +3.267286932e-02f, +4.455848173e-02f, +2.351503337e-02f, -1.915629477e-02f, -5.272885293e-02f, -4.998568337e-02f, -9.883103547e-03f, +3.944741130e-02f, +6.141247912e-02f, +3.944741130e-02f, -9.883103547e-03f, -4.998568337e-02f, -5.272885293e-02f, -1.915629477e-02f, +2.351503337e-02f, +4.455848173e-02f, +3.267286932e-02f, +1.494761300e-03f, -2.424163753e-02f, -2.845267002e-02f, -1.341789307e-02f, +5.946321108e-03f, +1.571582859e-02f, +1.248168983e-02f, +2.686342793e-03f, -4.976271198e-03f, -6.405731284e-03f, -3.303519821e-03f, +2.794767810e-04f, +1.790286751e-03f, +1.336667044e-03f, +3.469535659e-04f, -1.608870261e-04f,
        +2.577507531e-05f, +1.086809859e-05f, -3.597806555e-05f, -9.022677896e-05f, -1.001032074e-04f, -2.162572117e-05f, +1.334176747e-04f, +2.754029446e-04f, +2.738574663e-04f, +4.883441716e-05f, -3.368996142e-04f, -6.608354264e-04f, -6.431674293e-04f, -1.354085236e-04f, +7.148449213e-04f, +1.450106209e-03f, +1.496506860e-03f, +4.925772700e-04f, -1.426669522e-03f, -3.579339114e-03f, -4.995795890e-03f, -4.884068303e-03f, -3.060435122e-03f, -9.950496562e-05f, +2.899055761e-03f, +4.817997977e-03f, +5.039232434e-03f, +3.699598995e-03f, +1.563829895e-03f, -3.948853898e-04f, -1.466038086e-03f, -1.478734758e-03f, -7.701444613e-04f, +8.892008168e-05f, +6.259781652e-04f, +6.723667394e-04f, +3.619102752e-04f, -2.784242037e-05f, -2.665508263e-04f, -2.808185262e-04f, -1.439707896e-04f, +1.363207129e-05f, +9.803631935e-05f, +9.274027171e-05f, +3.959496484e-05f, -8.801928510e-06f, -2.576330239e-05f, -1.668340381e-05f,
        -5.085810041e-05f, -6.144595631e-05f, +1.679698635e-05f, +1.663740391e-04f, +2.496456082e-04f, +1.009428352e-04f, -2.793890885e-04f, -6.160780337e-04f, -5.172287092e-04f, +1.495552505e-04f, +9.893104132e-04f, +1.261605930e-03f, +4.928695846e-04f, -9.652920767e-04f, -2.014235506e-03f, -1.627372799e-03f, +1.931735069e-04f, +2.197939940e-03f, +2.758983809e-03f, +1.218866689e-03f, -1.422640286e-03f, -3.172656367e-03f, -2.613289263e-03f, -9.182675706e-05f, +2.499132998e-03f, +3.211843143e-03f, +1.579224448e-03f, -1.067547924e-03f, -2.722308581e-03f, -2.289606150e-03f, -3.308495136e-04f, +1.548140897e-03f, +2.038819890e-03f, +1.056102385e-03f, -4.132185360e-04f, -1.245245151e-03f, -1.030716273e-03f, -2.038784127e-04f, +4.909277589e-04f, +6.261909334e-04f, +3.058451921e-04f, -8.247435647e-05f, -2.483969291e-04f, -1.754542022e-04f, -2.490941987e-05f, +5.954958857e-05f, +5.310929686e-05f, +1.285012779e-05f,
        /*  4, 1 (48) */
        -4.183041008e-04f, -7.627936470e-04f, -6.201978060e-04f, +3.830784047e-04f, +1.996858701e-03f, +3.138113875e-03f, +2.381343374e-03f, -9.215132624e-04f, -5.585508145e-03f, -8.577090238e-03f, -6.563730034e-03f, +1.530866785e-03f, +1.258076460e-02f, +1.970020593e-02f, +1.570298138e-02f, -1.791424718e-03f, -2.659001489e-02f, -4.445254764e-02f, -3.881892906e-02f, +4.680283662e-04f, +6.996908239e-02f, +1.514008679e-01f, +2.179359516e-01f, +2.455504115e-01f, +2.238954425e-01f, +1.611029342e-01f, +8.000411071e-02f, +7.746966475e-03f, -3.582842964e-02f, -4.534001030e-02f, -2.955255983e-02f, -4.720265686e-03f, +1.421799200e-02f, +1.992453453e-02f, +1.384991020e-02f, +2.864068951e-03f, -5.864920145e-03f, -8.653767076e-03f, -6.125916438e-03f, -1.477734733e-03f, +2.103954910e-03f, +3.173371668e-03f, +2.194998227e-03f, +5.660454554e-04f, -5.446247756e-04f, -7.824636741e-04f, -4.698424785e-04f, -1.037912875e-04f,
        +2.960954655e-04f, +1.275221087e-03f, +1.807083737e-03f, +4.458508201e-04f, -3.053874213e-03f, -6.304788449e-03f, -5.255660287e-03f, +2.070264759e-03f, +1.196446112e-02f, +1.586538384e-02f, +6.935631522e-03f, -1.215628714e-02f, -2.795980043e-02f, -2.520692960e-02f, -5.194742057e-04f, +3.104549652e-02f, +4.475165524e-02f, +2.571297331e-02f, -1.639731096e-02f, -5.150998624e-02f, -5.140832366e-02f, -1.305575991e-02f, +3.683412204e-02f, +6.132065237e-02f, +4.194654430e-02f, -6.671260404e-03f, -4.840645892e-02f, -5.379640085e-02f, -2.187860335e-02f, +2.122542722e-02f, +4.422763222e-02f, +3.422101022e-02f, +3.533581191e-03f, -2.318553514e-02f, -2.886588855e-02f, -1.466313822e-02f, +4.915604835e-03f, +1.551195017e-02f, +1.297261759e-02f, +3.312533726e-03f, -4.670426006e-03f, -6.488205641e-03f, -3.551916750e-03f, +1.040225788e-04f, +1.765377331e-03f, +1.396216632e-03f, +4.000628628e-04f, -1.480368983e-04f,
        +2.568494077e-05f, +1.279823439e-05f, -3.240045182e-05f, -8.753816689e-05f, -1.018057305e-04f, -2.929220594e-05f, +1.228295386e-04f, +2.694105448e-04f, +2.802413978e-04f, +6.914107652e-05f, -3.116704700e-04f, -6.479262746e-04f, -6.583392203e-04f, -1.804486605e-04f, +6.591406331e-04f, +1.418716096e-03f, +1.522700842e-03f, +5.865016042e-04f, -1.290524252e-03f, -3.456144344e-03f, -4.946179436e-03f, -4.943187407e-03f, -3.217188611e-03f, -2.983617596e-04f, +2.733284861e-03f, +4.745033012e-03f, +5.076354457e-03f, +3.816679123e-03f, +1.701776486e-03f, -2.935367743e-04f, -1.431258577e-03f, -1.504467573e-03f, -8.248943874e-04f, +4.106534528e-05f, +6.067667708e-04f, +6.824562554e-04f, +3.866306003e-04f, -6.203719232e-06f, -2.583162013e-04f, -2.856253319e-04f, -1.544572875e-04f, +5.324473980e-06f, +9.559884073e-05f, +9.506401101e-05f, +4.324034279e-05f, -6.601447436e-06f, -2.564493378e-05f, -1.763779865e-05f,
        -4.849702512e-05f, -6.296872165e-05f, +9.009032545e-06f, +1.570497127e-04f, +2.499307227e-04f, +1.184039648e-04f, -2.528121168e-04f, -6.041753047e-04f, -5.411178559e-04f, +9.604230733e-05f, +9.456000801e-04f, +1.273601320e-03f, +5.695474258e-04f, -8.728683017e-04f, -1.983672901e-03f, -1.700545044e-03f, +5.636515345e-05f, +2.100287318e-03f, +2.786846348e-03f, +1.365515110e-03f, -1.262369016e-03f, -3.123805670e-03f, -2.719216202e-03f, -2.751886192e-04f, +2.377098497e-03f, +3.241213287e-03f, +1.731605663e-03f, -9.120159997e-04f, -2.676873833e-03f, -2.374936970e-03f, -4.689556004e-04f, +1.463034725e-03f, +2.057262883e-03f, +1.144973117e-03f, -3.308092521e-04f, -1.224490089e-03f, -1.069626454e-03f, -2.588417395e-04f, +4.622457530e-04f, +6.344264800e-04f, +3.320784716e-04f, -6.303458543e-05f, -2.461532424e-04f, -1.842423113e-04f, -3.332559610e-05f, +5.726948053e-05f, +5.523260112e-05f, +1.514649021e-05f,
        /*  4, 2 (48) */
        -3.926191600e-04f, -7.499954126e-04f, -6.525982578e-04f, +2.955402379e-04f, +1.895052970e-03f, +3.108821669e-03f, +2.504172913e-03f, -6.521027177e-04f, -5.305266748e-03f, -8.507949162e-03f, -6.875400504e-03f, +8.829405108e-04f, +1.192242538e-02f, +1.951975726e-02f, +1.636212202e-02f, -3.727086224e-04f, -2.506731404e-02f, -4.386604604e-02f, -4.010945331e-02f, -2.988115978e-03f, +6.502290296e-02f, +1.464576805e-01f, +2.147187630e-01f, +2.452520498e-01f, +2.266287274e-01f, +1.658479672e-01f, +8.508046517e-02f, +1.156364560e-02f, -3.412665315e-02f, -4.563354708e-02f, -3.098381841e-02f, -6.224733259e-03f, +1.339309761e-02f, +1.996559988e-02f, +1.445667697e-02f, +3.546525207e-03f, -5.478289544e-03f, -8.659970795e-03f, -6.384232639e-03f, -1.763360065e-03f, +1.949497623e-03f, +3.178696142e-03f, +2.290597068e-03f, +6.611094664e-04f, -5.013844328e-04f, -7.890651215e-04f, -4.954874122e-04f, -1.214290861e-04f,
        +2.475984404e-04f, +1.212252366e-03f, +1.816092770e-03f, +6.029005328e-04f, -2.803943490e-03f, -6.186384484e-03f, -5.508472404e-03f, +1.466089454e-03f, +1.142334327e-02f, +1.596142614e-02f, +7.881231602e-03f, -1.088268582e-02f, -2.739025301e-02f, -2.607979791e-02f, -2.503147107e-03f, +2.934495148e-02f, +4.480802039e-02f, +2.781326063e-02f, -1.361046461e-02f, -5.014447113e-02f, -5.267069267e-02f, -1.617956558e-02f, +3.411490584e-02f, +6.104546375e-02f, +4.432364280e-02f, -3.430047117e-03f, -4.667485326e-02f, -5.470841685e-02f, -2.455547718e-02f, +1.885049025e-02f, +4.375867662e-02f, +3.568404494e-02f, +5.590844074e-03f, -2.204056203e-02f, -2.919669781e-02f, -1.588762831e-02f, +3.845978381e-03f, +1.525310843e-02f, +1.343486335e-02f, +3.946960206e-03f, -4.338347535e-03f, -6.551240226e-03f, -3.798069993e-03f, -8.021973253e-05f, +1.732051735e-03f, +1.453486113e-03f, +4.552954639e-04f, -1.328904081e-04f,
        +2.549779187e-05f, +1.459115580e-05f, -2.887242359e-05f, -8.468914430e-05f, -1.031510331e-04f, -3.661966384e-05f, +1.122371906e-04f, +2.628740404e-04f, +2.857102798e-04f, +8.872654422e-05f, -2.862935634e-04f, -6.337052964e-04f, -6.715031297e-04f, -2.239637995e-04f, +6.031742885e-04f, +1.384701936e-03f, +1.544664201e-03f, +6.765567998e-04f, -1.155617987e-03f, -3.330262345e-03f, -4.890527745e-03f, -4.995311351e-03f, -3.369090678e-03f, -4.967594365e-04f, +2.563365105e-03f, +4.665242587e-03f, +5.107037743e-03f, +3.930337947e-03f, +1.840275841e-03f, -1.886513393e-04f, -1.392140813e-03f, -1.527174191e-03f, -8.789479600e-04f, -8.068450342e-06f, +5.855336396e-04f, +6.910422827e-04f, +4.109877721e-04f, +1.604031493e-05f, -2.491507715e-04f, -2.897922728e-04f, -1.648448594e-04f, -3.282499426e-06f, +9.278551127e-05f, +9.718348809e-05f, +4.690290633e-05f, -4.268934018e-06f, -2.541551119e-05f, -1.856640645e-05f,
        -4.604377184e-05f, -6.412929389e-05f, +1.564053316e-06f, +1.475283405e-04f, +2.492864582e-04f, +1.348266799e-04f, -2.262137482e-04f, -5.905744836e-04f, -5.625738223e-04f, +4.350302225e-05f, +8.997806223e-04f, +1.281274664e-03f, +6.430507441e-04f, -7.791577591e-04f, -1.947313080e-03f, -1.767494544e-03f, -7.914526029e-05f, +1.997013978e-03f, +2.805872340e-03f, +1.507053898e-03f, -1.098936335e-03f, -3.065474889e-03f, -2.816590098e-03f, -4.576765036e-04f, +2.247563083e-03f, +3.260645812e-03f, +1.879279726e-03f, -7.527445461e-04f, -2.622762061e-03f, -2.453601469e-03f, -6.070483377e-04f, +1.372261576e-03f, +2.069419948e-03f, +1.231579914e-03f, -2.458698177e-04f, -1.199326656e-03f, -1.105854670e-03f, -3.142690478e-04f, +4.312229160e-04f, +6.407018084e-04f, +3.579848182e-04f, -4.266457517e-05f, -2.428860696e-04f, -1.926898844e-04f, -4.202254467e-05f, +5.459686724e-05f, +5.720976625e-05f, +1.752542097e-05f,
        /*  4, 3 (48) */
        -3.671213681e-04f, -7.354042568e-04f, -6.814706814e-04f, +2.108510936e-04f, +1.791901937e-03f, +3.072202006e-03f, +2.616410104e-03f, -3.892286773e-04f, -5.019556468e-03f, -8.419222618e-03f, -7.161694067e-03f, +2.492352145e-04f, +1.125092225e-02f, +1.929579347e-02f, +1.696529630e-02f, +1.011993314e-03f, -2.352264984e-02f, -4.318948924e-02f, -4.126507130e-02f, -6.318378323e-03f, +6.013237521e-02f, +1.414623692e-01f, +2.113496723e-01f, +2.447552903e-01f, +2.291920925e-01f, +1.705132098e-01f, +9.018750292e-02f, +1.549398355e-02f, -3.228637731e-02f, -4.582219842e-02f, -3.237595922e-02f, -7.751907450e-03f, +1.251414965e-02f, +1.995753143e-02f, +1.504221061e-02f, +4.237567489e-03f, -5.067301772e-03f, -8.643930480e-03f, -6.633383411e-03f, -2.053152338e-03f, +1.784652763e-03f, +3.175413642e-03f, +2.383382579e-03f, +7.582929545e-04f, -4.544815265e-04f, -7.933340555e-04f, -5.209029234e-04f, -1.399954926e-04f,
        +2.015546685e-04f, +1.148123072e-03f, +1.817656823e-03f, +7.504288733e-04f, -2.554657032e-03f, -6.051557804e-03f, -5.734686152e-03f, +8.755149706e-04f, +1.086076945e-02f, +1.600492917e-02f, +8.781012224e-03f, -9.601411153e-03f, -2.674720226e-02f, -2.685895566e-02f, -4.450460187e-03f, +2.757745693e-02f, +4.472887513e-02f, +2.981027461e-02f, -1.080459227e-02f, -4.863741723e-02f, -5.376962901e-02f, -1.924504047e-02f, +3.129831574e-02f, +6.058778724e-02f, +4.657120588e-02f, -1.694013043e-04f, -4.479557353e-02f, -5.546116140e-02f, -2.717823924e-02f, +1.639688878e-02f, +4.315162828e-02f, +3.705630652e-02f, +7.660264021e-03f, -2.080898211e-02f, -2.944256762e-02f, -1.708695496e-02f, +2.740123711e-03f, +1.493883939e-02f, +1.386608626e-02f, +4.587662014e-03f, -3.980362717e-03f, -6.593904801e-03f, -4.040956062e-03f, -2.729096169e-04f, +1.690029190e-03f, +1.508082980e-03f, +5.125052301e-04f, -1.153649871e-04f,
        +2.521870143e-05f, +1.624621214e-05f, -2.540375540e-05f, -8.169444519e-05f, -1.041471292e-04f, -4.359758709e-05f, +1.016705850e-04f, +2.558267896e-04f, +2.902740750e-04f, +1.075577770e-04f, -2.608383219e-04f, -6.182403434e-04f, -6.826735565e-04f, -2.658826444e-04f, +5.470861159e-04f, +1.348204232e-03f, +1.562449107e-03f, +7.626505743e-04f, -1.022169247e-03f, -3.201943052e-03f, -4.828995200e-03f, -5.040408874e-03f, -3.515924974e-03f, -6.943928988e-04f, +2.389547080e-03f, +4.578708397e-03f, +5.131168788e-03f, +4.040337745e-03f, +1.979090371e-03f, -8.035797108e-05f, -1.348665889e-03f, -1.546728218e-03f, -9.321568742e-04f, -5.838895299e-05f, +5.622843227e-04f, +6.980656076e-04f, +4.349081821e-04f, +3.884562163e-05f, -2.390542422e-04f, -2.932892410e-04f, -1.751005601e-04f, -1.217293043e-05f, +8.959208158e-05f, +9.908437117e-05f, +5.057089919e-05f, -1.807232852e-06f, -2.507083135e-05f, -1.946383437e-05f,
        -4.351565455e-05f, -6.494024989e-05f, -5.521696940e-06f, +1.378560946e-04f, +2.477495159e-04f, +1.501848820e-04f, -1.996906535e-04f, -5.753710700e-04f, -5.815844655e-04f, -7.906233985e-06f, +8.520507510e-04f, +1.284683345e-03f, +7.131923655e-04f, -6.844865997e-04f, -1.905354028e-03f, -1.828080810e-03f, -2.129361260e-04f, +1.888500953e-03f, +2.816067114e-03f, +1.643063030e-03f, -9.328759901e-04f, -2.997878283e-03f, -2.905115653e-03f, -6.387110148e-04f, +2.110929078e-03f, +3.270051945e-03f, +2.021755815e-03f, -5.902221241e-04f, -2.560085015e-03f, -2.525288040e-03f, -7.446799040e-04f, +1.276050184e-03f, +2.075165918e-03f, +1.315601324e-03f, -1.586408310e-04f, -1.169755890e-03f, -1.139220329e-03f, -3.699785465e-04f, +3.979090191e-04f, +6.449391495e-04f, +3.834583218e-04f, -2.141035931e-05f, -2.385701128e-04f, -2.007480380e-04f, -5.097508111e-05f, +5.152445542e-05f, +5.902239499e-05f, +1.997819080e-05f,
        /*  4, 4 (48) */
        -3.419026667e-04f, -7.191580447e-04f, -7.068744368e-04f, +1.291566484e-04f, +1.687754808e-03f, +3.028604419e-03f, +2.718080689e-03f, -1.334018877e-04f, -4.729282393e-03f, -8.311664841e-03f, -7.422532389e-03f, -3.690051289e-04f, +1.056824870e-02f, +1.902991082e-02f, +1.751238242e-02f, +2.360197545e-03f, -2.196020074e-02f, -4.242683867e-02f, -4.228724054e-02f, -9.520321375e-03f, +5.530338001e-02f, +1.364219603e-01f, +2.078337474e-01f, +2.440608974e-01f, +2.315816396e-01f, +1.750919182e-01f, +9.531867170e-02f, +1.953432129e-02f, -3.030728694e-02f, -4.590255639e-02f, -3.372462511e-02f, -9.298635668e-03f, +1.158199278e-02f, +1.989914247e-02f, +1.560449493e-02f, +4.935633097e-03f, -4.632393590e-03f, -8.605084859e-03f, -6.872437653e-03f, -2.346441579e-03f, +1.609552203e-03f, +3.163240712e-03f, +2.472974661e-03f, +8.573773257e-04f, -4.039106273e-04f, -7.951412884e-04f, -5.459737548e-04f, -1.594593269e-04f,
        +1.580390140e-04f, +1.083182822e-03f, +1.812135126e-03f, +8.882849680e-04f, -2.306907516e-03f, -5.901372922e-03f, -5.934376806e-03f, +3.001439006e-04f, +1.027918498e-02f, +1.599702293e-02f, +9.633062975e-03f, -8.316727808e-03f, -2.603400990e-02f, -2.754344226e-02f, -6.355814215e-03f, +2.574937612e-02f, +4.451593900e-02f, +3.169877556e-02f, -7.988525159e-03f, -4.699435420e-02f, -5.470250500e-02f, -2.224291876e-02f, +2.839320009e-02f, +5.994907623e-02f, +4.868213496e-02f, +3.100650641e-03f, -4.277381772e-02f, -5.605138352e-02f, -2.973832426e-02f, +1.387160074e-02f, +4.240694837e-02f, +3.833235670e-02f, +9.735429939e-03f, -1.949338079e-02f, -2.960120845e-02f, -1.825671085e-02f, +1.600903381e-03f, +1.456886084e-02f, +1.426399528e-02f, +5.232601164e-03f, -3.596904395e-03f, -6.615315161e-03f, -4.279526175e-03f, -4.736576549e-04f, +1.639054109e-03f, +1.559607435e-03f, +5.715276251e-04f, -9.538679632e-05f,
        +2.485289707e-05f, +1.776326699e-05f, -2.200368024e-05f, -7.856878056e-05f, -1.048028527e-04f, -5.021681594e-05f, +9.115875605e-05f, +2.483026841e-04f, +2.939449663e-04f, +1.256045662e-04f, -2.353727258e-04f, -6.016008928e-04f, -6.918695702e-04f, -3.061393594e-04f, +4.910136010e-04f, +1.309366105e-03f, +1.576115501e-03f, +8.447000245e-04f, -8.903907804e-04f, -3.071438158e-03f, -4.761745523e-03f, -5.078461389e-03f, -3.657484738e-03f, -8.909585180e-04f, +2.212088805e-03f, +4.485524544e-03f, +5.148645087e-03f, +4.146445129e-03f, +2.117978792e-03f, +3.120562914e-05f, -1.300823683e-03f, -1.563007677e-03f, -9.843715783e-04f, -1.097988158e-04f, +5.370296229e-04f, +7.034697038e-04f, +4.583176107e-04f, +6.216550883e-05f, -2.280289067e-04f, -2.960872217e-04f, -1.851908887e-04f, -2.132956422e-05f, +8.601535640e-05f, +1.007525581e-04f, +5.423212726e-05f, +7.802366320e-07f, -2.460697086e-05f, -2.032459926e-05f,
        -4.092953074e-05f, -6.541522858e-05f, -1.223419269e-05f, +1.280780387e-04f, +2.453588821e-04f, +1.644573947e-04f, -1.733364085e-04f, -5.586638714e-04f, -5.981467065e-04f, -5.803657589e-05f, +8.026117632e-04f, +1.283898334e-03f, +7.797996862e-04f, -5.891793017e-04f, -1.858009816e-03f, -1.882186182e-03f, -3.445958614e-04f, +1.775143192e-03f, +2.817464960e-03f, +1.773143062e-03f, -7.647279520e-04f, -2.921259728e-03f, -2.984526936e-03f, -8.177176306e-04f, +1.967622483e-03f, +3.269375510e-03f, +2.158558199e-03f, -4.249506554e-04f, -2.488983513e-03f, -2.589705622e-03f, -8.813995793e-04f, +1.174650167e-03f, +2.074395682e-03f, +1.396719979e-03f, -6.937474964e-05f, -1.135794214e-03f, -1.169549304e-03f, -4.257833885e-04f, +3.623634157e-04f, +6.470662585e-04f, +4.083916371e-04f, +6.770848861e-07f, -2.331834640e-04f, -2.083676856e-04f, -6.015583712e-05f, +4.804651873e-05f, +6.065202711e-05f, +2.249519359e-05f,
        /*  4, 5 (48) */
        -3.170497696e-04f, -7.013947777e-04f, -7.288781171e-04f, +5.058786781e-05f, +1.582951955e-03f, +2.978387603e-03f, +2.809239445e-03f, +1.149007964e-04f, -4.435337427e-03f, -8.186060275e-03f, -7.657905115e-03f, -9.706060217e-04f, +9.876379128e-03f, +1.872377146e-02f, +1.800339602e-02f, +3.669563650e-03f, -2.038408523e-02f, -4.158213864e-02f, -4.317763132e-02f, -1.259175953e-02f, +5.054163449e-02f, +1.313434989e-01f, +2.041762626e-01f, +2.431699389e-01f, +2.337937284e-01f, +1.795774427e-01f, +1.004673168e-01f, +2.368076642e-02f, -2.818930815e-02f, -4.587135076e-02f, -3.502544879e-02f, -1.086164335e-02f, +1.059762120e-02f, +1.978934366e-02f, +1.614152455e-02f, +5.639102801e-03f, -4.174075979e-03f, -8.542919350e-03f, -7.100466560e-03f, -2.642528801e-03f, +1.424361314e-03f, +3.141911148e-03f, +2.558990017e-03f, +9.581298838e-04f, -3.496785000e-04f, -7.943610518e-04f, -5.705807257e-04f, -1.797839262e-04f,
        +1.171094832e-04f, +1.017767593e-03f, +1.799900934e-03f, +1.016363007e-03f, -2.061548634e-03f, -5.736915528e-03f, -6.107713214e-03f, -2.585199707e-04f, +9.681038274e-03f, +1.593898636e-02f, +1.043567474e-02f, -7.032829474e-03f, -2.525421021e-02f, -2.813262157e-02f, -8.213824032e-03f, +2.386718994e-02f, +4.417134314e-02f, +3.347391875e-02f, -5.171060199e-03f, -4.522121114e-02f, -5.546723295e-02f, -2.516417848e-02f, +2.540867315e-02f, +5.913135860e-02f, +5.064975744e-02f, +6.370026151e-03f, -4.061525952e-02f, -5.647633418e-02f, -3.222730777e-02f, +1.128189512e-02f, +4.152554879e-02f, +3.950700687e-02f, +1.180982562e-02f, -1.809666081e-02f, -2.967058320e-02f, -1.939250507e-02f, +4.313540776e-04f, +1.414307745e-02f, +1.462635870e-02f, +5.879667422e-03f, -3.188512758e-03f, -6.614638076e-03f, -4.512709639e-03f, -6.820253404e-04f, +1.578898272e-03f, +1.607653954e-03f, +6.321796522e-04f, -7.289160273e-05f,
        +2.440573637e-05f, +1.914268171e-05f, -1.868087567e-05f, -7.532679167e-05f, -1.051278059e-04f, -5.646952880e-05f, +8.072975785e-05f, +2.403360389e-04f, +2.967372692e-04f, +1.428395536e-04f, -2.099631606e-04f, -5.838578326e-04f, -6.991147656e-04f, -3.446736192e-04f, +4.350912186e-04f, +1.268332935e-03f, +1.585730846e-03f, +9.226316762e-04f, -7.604891965e-04f, -2.939000589e-03f, -4.688951385e-03f, -5.109462957e-03f, -3.793573174e-03f, -1.086154718e-03f, +2.031255250e-03f, +4.385797410e-03f, +5.159375410e-03f, +4.248431559e-03f, +2.256696583e-03f, +1.458931227e-04f, -1.248613006e-03f, -1.575895357e-03f, -1.035441599e-03f, -1.621958337e-04f, +5.097856788e-04f, +7.072009381e-04f, +4.811414114e-04f, +8.595071913e-05f, -2.160797036e-04f, -2.981584054e-04f, -1.950818736e-04f, -3.073382484e-05f, +8.205323572e-05f, +1.021742297e-04f, +5.787398607e-05f, +3.489473056e-06f, -2.402031080e-05f, -2.114314640e-05f,
        -3.830173685e-05f, -6.556882424e-05f, -1.856161600e-05f, +1.182379750e-04f, +2.421555950e-04f, +1.776279014e-04f, -1.472412174e-04f, -5.405545465e-04f, -6.122663293e-04f, -1.067469839e-04f, +7.516667697e-04f, +1.279003693e-03f, +8.427150406e-04f, -4.935575695e-04f, -1.805509649e-03f, -1.929715963e-03f, -4.737242104e-04f, +1.657348110e-03f, +2.810128809e-03f, +1.896916352e-03f, -5.950365752e-04f, -2.835891805e-03f, -3.054588224e-03f, -9.941286267e-04f, +1.818091573e-03f, +3.258593194e-03f, +2.289227892e-03f, -2.574437953e-04f, -2.409627157e-03f, -2.646584855e-03f, -1.016755263e-03f, +1.068331401e-03f, +2.067024802e-03f, +1.474623762e-03f, +2.166481680e-05f, -1.097473649e-03f, -1.196674685e-03f, -4.814922535e-04f, +3.246550398e-04f, +6.470168316e-04f, +4.326763660e-04f, +2.354189483e-05f, -2.267078061e-04f, -2.154997430e-04f, -6.953530181e-05f, +4.415898908e-05f, +6.208023054e-05f, +2.506595819e-05f,
        /*  4, 6 (48) */
        -2.926440332e-04f, -6.822520959e-04f, -7.475589927e-04f, -2.473892386e-05f, +1.477824149e-03f, +2.921918074e-03f, +2.889969203e-03f, +3.552368352e-04f, -4.138600157e-03f, -8.043220721e-03f, -7.867868276e-03f, -1.554463854e-03f, +9.177264362e-03f, +1.837909784e-02f, +1.843848724e-02f, +4.937896585e-03f, -1.879835439e-02f, -4.065950696e-02f, -4.393812052e-02f, -1.553076012e-02f, +4.585268310e-02f, +1.262340359e-01f, +2.003826895e-01f, +2.420837842e-01f, +2.358249836e-01f, +1.839632402e-01f, +1.056266922e-01f, +2.792919798e-02f, -2.593261157e-02f, -4.572545764e-02f, -3.627406180e-02f, -1.243753870e-02f, +9.562179601e-03f, +1.962714782e-02f, +1.665131023e-02f, +6.346303739e-03f, -3.692934568e-03f, -8.456968631e-03f, -7.316546263e-03f, -2.940687206e-03f, +1.229279441e-03f, +3.111177323e-03f, +2.641043253e-03f, +1.060304113e-03f, -2.918045140e-04f, -7.908715787e-04f, -5.946010365e-04f, -2.009270726e-04f,
        +7.880774639e-05f, +9.521987690e-04f, +1.781339318e-03f, +1.134600982e-03f, -1.819393039e-03f, -5.559287626e-03f, -6.254954431e-03f, -7.990745172e-04f, +9.068771944e-03f, +1.583223937e-02f, +1.118734151e-02f, -5.753825781e-03f, -2.441149517e-02f, -2.862617914e-02f, -1.001933368e-02f, +2.193747398e-02f, +4.369761893e-02f, +3.513126686e-02f, -2.360931390e-03f, -4.332429479e-02f, -5.606226953e-02f, -2.800007029e-02f, +2.235408493e-02f, +5.813722997e-02f, +5.246784902e-02f, +9.628619345e-03f, -3.832603163e-02f, -5.673377797e-02f, -3.463693493e-02f, +8.635310265e-03f, +4.050879353e-02f, +4.057533827e-02f, +1.387685042e-02f, -1.662203705e-02f, -2.964891839e-02f, -2.048997872e-02f, -7.653206070e-04f, +1.366158520e-02f, +1.495101374e-02f, +6.526684254e-03f, -2.755836392e-03f, -6.591096181e-03f, -4.739417445e-03f, -8.975250834e-04f, +1.509362970e-03f, +1.651812943e-03f, +6.942598828e-04f, -4.782564454e-05f,
        +2.388268238e-05f, +2.038529763e-05f, -1.544345222e-05f, -7.198300477e-05f, -1.051323070e-04f, -6.234922847e-05f, +7.041060820e-05f, +2.319614842e-04f, +2.986673396e-04f, +1.592382384e-04f, -1.846742780e-04f, -5.650832478e-04f, -7.044371083e-04f, -3.814306438e-04f, +3.794501758e-04f, +1.225251987e-03f, +1.591369861e-03f, +9.963815105e-04f, -6.326646124e-04f, -2.804883992e-03f, -4.610794003e-03f, -5.133420237e-03f, -3.924003801e-03f, -1.279682551e-03f, +1.847317835e-03f, +4.279645494e-03f, +5.163280051e-03f, +4.346073830e-03f, +2.394996447e-03f, +2.635497313e-04f, -1.192041739e-03f, -1.585279156e-03f, -1.085215875e-03f, -2.154730948e-04f, +4.805740365e-04f, +7.092087738e-04f, +5.033047016e-04f, +1.101495045e-04f, -2.032142678e-04f, -2.994762987e-04f, -2.047391603e-04f, -4.036583496e-05f, +7.770475349e-05f, +1.033359034e-04f, +6.148349062e-05f, +6.315887839e-06f, -2.330756098e-05f, -2.191386919e-05f,
        -3.564802872e-05f, -6.541647930e-05f, -2.449432609e-05f, +1.083783024e-04f, +2.381825098e-04f, +1.896848636e-04f, -1.214916587e-04f, -5.211471490e-04f, -6.239577516e-04f, -1.539046480e-04f, +6.994199307e-04f, +1.270096047e-03f, +9.017960107e-04f, -3.979392574e-04f, -1.748096881e-03f, -1.970598482e-03f, -5.999334907e-04f, +1.535534094e-03f, +2.794149814e-03f, +2.014028202e-03f, -4.243487494e-04f, -2.742074807e-03f, -3.115094746e-03f, -1.167384978e-03f, +1.662805419e-03f, +3.237714706e-03f, +2.413324272e-03f, -8.822525744e-05f, -2.322213947e-03f, -2.695679175e-03f, -1.150295009e-03f, +9.573833096e-04f, +2.052990060e-03f, +1.549006979e-03f, +1.142038653e-04f, -1.054841968e-03f, -1.220437529e-03f, -5.369099587e-04f, +2.848623687e-04f, +6.447309089e-04f, +4.562034539e-04f, +4.712340274e-05f, -2.191286046e-04f, -2.220953406e-04f, -7.908187432e-05f, +3.985954338e-05f, +6.328869589e-05f, +2.767916530e-05f,
        /*  4, 7 (48) */
        -2.687613508e-04f, -6.618667983e-04f, -7.630024450e-04f, -9.672192862e-05f, +1.372691842e-03f, +2.859568845e-03f, +2.960379811e-03f, +5.871983194e-04f, -3.839932818e-03f, -7.883982483e-03f, -8.052542554e-03f, -2.119547102e-03f, +8.472827254e-03f, +1.799766720e-02f, +1.881793742e-02f, +6.163148572e-03f, -1.720698453e-02f, -3.966312545e-02f, -4.457078513e-02f, -1.833564411e-02f, +4.124188910e-02f, +1.211006157e-01f, +1.964586857e-01f, +2.408041017e-01f, +2.376723015e-01f, +1.882428856e-01f, +1.107899723e-01f, +3.227527181e-02f, -2.353761512e-02f, -4.546190791e-02f, -3.746610354e-02f, -1.402281786e-02f, +8.476963726e-03f, +1.941167473e-02f, +1.713188427e-02f, +7.055512513e-03f, -3.189629866e-03f, -8.346819126e-03f, -7.519760531e-03f, -3.240163505e-03f, +1.024540281e-03f, +3.070811488e-03f, +2.718748007e-03f, +1.163640017e-03f, -2.303210233e-04f, -7.845556909e-04f, -6.179085974e-04f, -2.228409418e-04f,
        +4.315971767e-05f, +8.867822897e-04f, +1.756844992e-03f, +1.242979284e-03f, -1.581210529e-03f, -5.369602763e-03f, -6.376446090e-03f, -1.320221666e-03f, +8.444814193e-03f, +1.567833472e-02f, +1.188676144e-02f, -4.483729733e-03f, -2.350969916e-02f, -2.902411839e-02f, -1.176743056e-02f, +1.996687550e-02f, +4.309768544e-02f, +3.666680095e-02f, +4.332184234e-04f, -4.131026659e-02f, -5.648661828e-02f, -3.074214510e-02f, +1.923899018e-02f, +5.696984499e-02f, +5.413065444e-02f, +1.286633405e-02f, -3.591270736e-02f, -5.682200323e-02f, -3.695914888e-02f, +5.939631090e-03f, +3.935849852e-02f, +4.153272158e-02f, +1.592984048e-02f, -1.507303007e-02f, -2.953471452e-02f, -2.154482068e-02f, -1.985758136e-03f, +1.312467524e-02f, +1.523587610e-02f, +7.171415163e-03f, -2.299632938e-03f, -6.543972778e-03f, -4.958546050e-03f, -1.119620424e-03f, +1.430281096e-03f, +1.691672486e-03f, +7.575485786e-04f, -2.014647924e-05f,
        +2.328927947e-05f, +2.149241715e-05f, -1.229894406e-05f, -6.855178752e-05f, -1.048273375e-04f, -6.785072484e-05f, +6.022723717e-05f, +2.232138583e-04f, +2.997534787e-04f, +1.747789771e-04f, -1.595688629e-04f, -5.453502079e-04f, -7.078687720e-04f, -4.163612200e-04f, +3.242181677e-04f, +1.180272056e-03f, +1.593114251e-03f, +1.065894971e-03f, -5.071103173e-04f, -2.669342214e-03f, -4.527462721e-03f, -5.150352405e-03f, -4.048600782e-03f, -1.471246277e-03f, +1.660553920e-03f, +4.167199231e-03f, +5.160291051e-03f, +4.439154570e-03f, +2.532628792e-03f, +3.840124563e-04f, -1.131126946e-03f, -1.591052417e-03f, -1.133543098e-03f, -2.695191451e-04f, +4.494217083e-04f, +7.094459692e-04f, +5.247325564e-04f, +1.347077095e-04f, -1.894429744e-04f, -3.000158343e-04f, -2.141281029e-04f, -5.020444006e-05f, +7.297011391e-05f, +1.042244879e-04f, +6.504730720e-05f, +9.254301850e-06f, -2.246578373e-05f, -2.263112961e-05f,
        -3.298352728e-05f, -6.497437691e-05f, -3.002482001e-05f, +9.853988425e-05f, +2.334840638e-04f, +2.006214236e-04f, -9.617045035e-05f, -5.005476724e-04f, -6.332437672e-04f, -1.993852731e-04f, +6.460757027e-04f, +1.257284011e-03f, +9.569156754e-04f, -3.026373218e-04f, -1.686027989e-03f, -2.004785068e-03f, -7.228497856e-04f, +1.410128991e-03f, +2.769646834e-03f, +2.124147921e-03f, -2.532120519e-04f, -2.640135635e-03f, -3.165873309e-03f, -1.336938230e-03f, +1.502252330e-03f, +3.206782822e-03f, +2.530426625e-03f, +8.217290435e-05f, -2.226969791e-03f, -2.736765832e-03f, -1.281568578e-03f, +8.421140762e-04f, +2.032249947e-03f, +1.619571516e-03f, +2.079588070e-04f, -1.007962800e-03f, -1.240687586e-03f, -5.918380977e-04f, +2.430733469e-04f, +6.401552626e-04f, +4.788635990e-04f, +7.135623777e-05f, -2.104352892e-04f, -2.281060413e-04f, -8.876192768e-05f, +3.514768506e-05f, +6.425933412e-05f, +3.032266962e-05f,
        /*  4, 8 (48) */
        -2.454720714e-04f, -6.403743812e-04f, -7.753013890e-04f, -1.652737161e-04f, +1.267864505e-03f, +2.791718120e-03f, +3.020607048e-03f, +8.104121777e-04f, -3.540179339e-03f, -7.709203505e-03f, -8.212111417e-03f, -2.664897310e-03f, +7.764958482e-03f, +1.758130598e-02f, +1.914215558e-02f, +7.343420628e-03f, -1.561387028e-02f, -3.859723048e-02f, -4.507789545e-02f, -2.100498633e-02f, +3.671442638e-02f, +1.159502633e-01f, +1.924100849e-01f, +2.393328554e-01f, +2.393328554e-01f, +1.924100849e-01f, +1.159502633e-01f, +3.671442638e-02f, -2.100498633e-02f, -4.507789545e-02f, -3.859723048e-02f, -1.561387028e-02f, +7.343420628e-03f, +1.914215558e-02f, +1.758130598e-02f, +7.764958482e-03f, -2.664897310e-03f, -8.212111417e-03f, -7.709203505e-03f, -3.540179339e-03f, +8.104121777e-04f, +3.020607048e-03f, +2.791718120e-03f, +1.267864505e-03f, -1.652737161e-04f, -7.753013890e-04f, -6.403743812e-04f, -2.454720714e-04f,
        +1.017619038e-05f, +8.218079128e-04f, +1.726820172e-03f, +1.341519168e-03f, -1.347726465e-03f, -5.168981339e-03f, -6.472616540e-03f, -1.820769339e-03f, +7.811570426e-03f, +1.547894945e-02f, +1.253283714e-02f, -3.226445722e-03f, -2.255278348e-02f, -2.932675571e-02f, -1.345345855e-02f, +1.796209043e-02f, +4.237483565e-02f, +3.807692994e-02f, +3.202865258e-03f, -3.918611867e-02f, -5.673983033e-02f, -3.338228073e-02f, +1.607311687e-02f, +5.563290677e-02f, +5.563290677e-02f, +1.607311687e-02f, -3.338228073e-02f, -5.673983033e-02f, -3.918611867e-02f, +3.202865258e-03f, +3.807692994e-02f, +4.237483565e-02f, +1.796209043e-02f, -1.345345855e-02f, -2.932675571e-02f, -2.255278348e-02f, -3.226445722e-03f, +1.253283714e-02f, +1.547894945e-02f, +7.811570426e-03f, -1.820769339e-03f, -6.472616540e-03f, -5.168981339e-03f, -1.347726465e-03f, +1.341519168e-03f, +1.726820172e-03f, +8.218079128e-04f, +1.017619038e-05f,
        +2.263112961e-05f, +2.246578373e-05f, -9.254301850e-06f, -6.504730720e-05f, -1.042244879e-04f, -7.297011391e-05f, +5.020444006e-05f, +2.141281029e-04f, +3.000158343e-04f, +1.894429744e-04f, -1.347077095e-04f, -5.247325564e-04f, -7.094459692e-04f, -4.494217083e-04f, +2.695191451e-04f, +1.133543098e-03f, +1.591052417e-03f, +1.131126946e-03f, -3.840124563e-04f, -2.532628792e-03f, -4.439154570e-03f, -5.160291051e-03f, -4.167199231e-03f, -1.660553920e-03f, +1.471246277e-03f, +4.048600782e-03f, +5.150352405e-03f, +4.527462721e-03f, +2.669342214e-03f, +5.071103173e-04f, -1.065894971e-03f, -1.593114251e-03f, -1.180272056e-03f, -3.242181677e-04f, +4.163612200e-04f, +7.078687720e-04f, +5.453502079e-04f, +1.595688629e-04f, -1.747789771e-04f, -2.997534787e-04f, -2.232138583e-04f, -6.022723717e-05f, +6.785072484e-05f, +1.048273375e-04f, +6.855178752e-05f, +1.229894406e-05f, -2.149241715e-05f, -2.328927947e-05f,
        -3.032266962e-05f, -6.425933412e-05f, -3.514768506e-05f, +8.876192768e-05f, +2.281060413e-04f, +2.104352892e-04f, -7.135623777e-05f, -4.788635990e-04f, -6.401552626e-04f, -2.430733469e-04f, +5.918380977e-04f, +1.240687586e-03f, +1.007962800e-03f, -2.079588070e-04f, -1.619571516e-03f, -2.032249947e-03f, -8.421140762e-04f, +1.281568578e-03f, +2.736765832e-03f, +2.226969791e-03f, -8.217290435e-05f, -2.530426625e-03f, -3.206782822e-03f, -1.502252330e-03f, +1.336938230e-03f, +3.165873309e-03f, +2.640135635e-03f, +2.532120519e-04f, -2.124147921e-03f, -2.769646834e-03f, -1.410128991e-03f, +7.228497856e-04f, +2.004785068e-03f, +1.686027989e-03f, +3.026373218e-04f, -9.569156754e-04f, -1.257284011e-03f, -6.460757027e-04f, +1.993852731e-04f, +6.332437672e-04f, +5.005476724e-04f, +9.617045035e-05f, -2.006214236e-04f, -2.334840638e-04f, -9.853988425e-05f, +3.002482001e-05f, +6.497437691e-05f, +3.298352728e-05f,
        /*  4, 9 (48) */
        -2.228409418e-04f, -6.179085974e-04f, -7.845556909e-04f, -2.303210233e-04f, +1.163640017e-03f, +2.718748007e-03f, +3.070811488e-03f, +1.024540281e-03f, -3.240163505e-03f, -7.519760531e-03f, -8.346819126e-03f, -3.189629866e-03f, +7.055512513e-03f, +1.713188427e-02f, +1.941167473e-02f, +8.476963726e-03f, -1.402281786e-02f, -3.746610354e-02f, -4.546190791e-02f, -2.353761512e-02f, +3.227527181e-02f, +1.107899723e-01f, +1.882428856e-01f, +2.376723015e-01f, +2.408041017e-01f, +1.964586857e-01f, +1.211006157e-01f, +4.124188910e-02f, -1.833564411e-02f, -4.457078513e-02f, -3.966312545e-02f, -1.720698453e-02f, +6.163148572e-03f, +1.881793742e-02f, +1.799766720e-02f, +8.472827254e-03f, -2.119547102e-03f, -8.052542554e-03f, -7.883982483e-03f, -3.839932818e-03f, +5.871983194e-04f, +2.960379811e-03f, +2.859568845e-03f, +1.372691842e-03f, -9.672192862e-05f, -7.630024450e-04f, -6.618667983e-04f, -2.687613508e-04f,
        -2.014647924e-05f, +7.575485786e-04f, +1.691672486e-03f, +1.430281096e-03f, -1.119620424e-03f, -4.958546050e-03f, -6.543972778e-03f, -2.299632938e-03f, +7.171415163e-03f, +1.523587610e-02f, +1.312467524e-02f, -1.985758136e-03f, -2.154482068e-02f, -2.953471452e-02f, -1.507303007e-02f, +1.592984048e-02f, +4.153272158e-02f, +3.935849852e-02f, +5.939631090e-03f, -3.695914888e-02f, -5.682200323e-02f, -3.591270736e-02f, +1.286633405e-02f, +5.413065444e-02f, +5.696984499e-02f, +1.923899018e-02f, -3.074214510e-02f, -5.648661828e-02f, -4.131026659e-02f, +4.332184234e-04f, +3.666680095e-02f, +4.309768544e-02f, +1.996687550e-02f, -1.176743056e-02f, -2.902411839e-02f, -2.350969916e-02f, -4.483729733e-03f, +1.188676144e-02f, +1.567833472e-02f, +8.444814193e-03f, -1.320221666e-03f, -6.376446090e-03f, -5.369602763e-03f, -1.581210529e-03f, +1.242979284e-03f, +1.756844992e-03f, +8.867822897e-04f, +4.315971767e-05f,
        +2.191386919e-05f, +2.330756098e-05f, -6.315887839e-06f, -6.148349062e-05f, -1.033359034e-04f, -7.770475349e-05f, +4.036583496e-05f, +2.047391603e-04f, +2.994762987e-04f, +2.032142678e-04f, -1.101495045e-04f, -5.033047016e-04f, -7.092087738e-04f, -4.805740365e-04f, +2.154730948e-04f, +1.085215875e-03f, +1.585279156e-03f, +1.192041739e-03f, -2.635497313e-04f, -2.394996447e-03f, -4.346073830e-03f, -5.163280051e-03f, -4.279645494e-03f, -1.847317835e-03f, +1.279682551e-03f, +3.924003801e-03f, +5.133420237e-03f, +4.610794003e-03f, +2.804883992e-03f, +6.326646124e-04f, -9.963815105e-04f, -1.591369861e-03f, -1.225251987e-03f, -3.794501758e-04f, +3.814306438e-04f, +7.044371083e-04f, +5.650832478e-04f, +1.846742780e-04f, -1.592382384e-04f, -2.986673396e-04f, -2.319614842e-04f, -7.041060820e-05f, +6.234922847e-05f, +1.051323070e-04f, +7.198300477e-05f, +1.544345222e-05f, -2.038529763e-05f, -2.388268238e-05f,
        -2.767916530e-05f, -6.328869589e-05f, -3.985954338e-05f, +7.908187432e-05f, +2.220953406e-04f, +2.191286046e-04f, -4.712340274e-05f, -4.562034539e-04f, -6.447309089e-04f, -2.848623687e-04f, +5.369099587e-04f, +1.220437529e-03f, +1.054841968e-03f, -1.142038653e-04f, -1.549006979e-03f, -2.052990060e-03f, -9.573833096e-04f, +1.150295009e-03f, +2.695679175e-03f, +2.322213947e-03f, +8.822525744e-05f, -2.413324272e-03f, -3.237714706e-03f, -1.662805419e-03f, +1.167384978e-03f, +3.115094746e-03f, +2.742074807e-03f, +4.243487494e-04f, -2.014028202e-03f, -2.794149814e-03f, -1.535534094e-03f, +5.999334907e-04f, +1.970598482e-03f, +1.748096881e-03f, +3.979392574e-04f, -9.017960107e-04f, -1.270096047e-03f, -6.994199307e-04f, +1.539046480e-04f, +6.239577516e-04f, +5.211471490e-04f, +1.214916587e-04f, -1.896848636e-04f, -2.381825098e-04f, -1.083783024e-04f, +2.449432609e-05f, +6.541647930e-05f, +3.564802872e-05f,
        /*  4,10 (48) */
        -2.009270726e-04f, -5.946010365e-04f, -7.908715787e-04f, -2.918045140e-04f, +1.060304113e-03f, +2.641043253e-03f, +3.111177323e-03f, +1.229279441e-03f, -2.940687206e-03f, -7.316546263e-03f, -8.456968631e-03f, -3.692934568e-03f, +6.346303739e-03f, +1.665131023e-02f, +1.962714782e-02f, +9.562179601e-03f, -1.243753870e-02f, -3.627406180e-02f, -4.572545764e-02f, -2.593261157e-02f, +2.792919798e-02f, +1.056266922e-01f, +1.839632402e-01f, +2.358249836e-01f, +2.420837842e-01f, +2.003826895e-01f, +1.262340359e-01f, +4.585268310e-02f, -1.553076012e-02f, -4.393812052e-02f, -4.065950696e-02f, -1.879835439e-02f, +4.937896585e-03f, +1.843848724e-02f, +1.837909784e-02f, +9.177264362e-03f, -1.554463854e-03f, -7.867868276e-03f, -8.043220721e-03f, -4.138600157e-03f, +3.552368352e-04f, +2.889969203e-03f, +2.921918074e-03f, +1.477824149e-03f, -2.473892386e-05f, -7.475589927e-04f, -6.822520959e-04f, -2.926440332e-04f,
        -4.782564454e-05f, +6.942598828e-04f, +1.651812943e-03f, +1.509362970e-03f, -8.975250834e-04f, -4.739417445e-03f, -6.591096181e-03f, -2.755836392e-03f, +6.526684254e-03f, +1.495101374e-02f, +1.366158520e-02f, -7.653206070e-04f, -2.048997872e-02f, -2.964891839e-02f, -1.662203705e-02f, +1.387685042e-02f, +4.057533827e-02f, +4.050879353e-02f, +8.635310265e-03f, -3.463693493e-02f, -5.673377797e-02f, -3.832603163e-02f, +9.628619345e-03f, +5.246784902e-02f, +5.813722997e-02f, +2.235408493e-02f, -2.800007029e-02f, -5.606226953e-02f, -4.332429479e-02f, -2.360931390e-03f, +3.513126686e-02f, +4.369761893e-02f, +2.193747398e-02f, -1.001933368e-02f, -2.862617914e-02f, -2.441149517e-02f, -5.753825781e-03f, +1.118734151e-02f, +1.583223937e-02f, +9.068771944e-03f, -7.990745172e-04f, -6.254954431e-03f, -5.559287626e-03f, -1.819393039e-03f, +1.134600982e-03f, +1.781339318e-03f, +9.521987690e-04f, +7.880774639e-05f,
        +2.114314640e-05f, +2.402031080e-05f, -3.489473056e-06f, -5.787398607e-05f, -1.021742297e-04f, -8.205323572e-05f, +3.073382484e-05f, +1.950818736e-04f, +2.981584054e-04f, +2.160797036e-04f, -8.595071913e-05f, -4.811414114e-04f, -7.072009381e-04f, -5.097856788e-04f, +1.621958337e-04f, +1.035441599e-03f, +1.575895357e-03f, +1.248613006e-03f, -1.458931227e-04f, -2.256696583e-03f, -4.248431559e-03f, -5.159375410e-03f, -4.385797410e-03f, -2.031255250e-03f, +1.086154718e-03f, +3.793573174e-03f, +5.109462957e-03f, +4.688951385e-03f, +2.939000589e-03f, +7.604891965e-04f, -9.226316762e-04f, -1.585730846e-03f, -1.268332935e-03f, -4.350912186e-04f, +3.446736192e-04f, +6.991147656e-04f, +5.838578326e-04f, +2.099631606e-04f, -1.428395536e-04f, -2.967372692e-04f, -2.403360389e-04f, -8.072975785e-05f, +5.646952880e-05f, +1.051278059e-04f, +7.532679167e-05f, +1.868087567e-05f, -1.914268171e-05f, -2.440573637e-05f,
        -2.506595819e-05f, -6.208023054e-05f, -4.415898908e-05f, +6.953530181e-05f, +2.154997430e-04f, +2.267078061e-04f, -2.354189483e-05f, -4.326763660e-04f, -6.470168316e-04f, -3.246550398e-04f, +4.814922535e-04f, +1.196674685e-03f, +1.097473649e-03f, -2.166481680e-05f, -1.474623762e-03f, -2.067024802e-03f, -1.068331401e-03f, +1.016755263e-03f, +2.646584855e-03f, +2.409627157e-03f, +2.574437953e-04f, -2.289227892e-03f, -3.258593194e-03f, -1.818091573e-03f, +9.941286267e-04f, +3.054588224e-03f, +2.835891805e-03f, +5.950365752e-04f, -1.896916352e-03f, -2.810128809e-03f, -1.657348110e-03f, +4.737242104e-04f, +1.929715963e-03f, +1.805509649e-03f, +4.935575695e-04f, -8.427150406e-04f, -1.279003693e-03f, -7.516667697e-04f, +1.067469839e-04f, +6.122663293e-04f, +5.405545465e-04f, +1.472412174e-04f, -1.776279014e-04f, -2.421555950e-04f, -1.182379750e-04f, +1.856161600e-05f, +6.556882424e-05f, +3.830173685e-05f,
        /*  4,11 (48) */
        -1.797839262e-04f, -5.705807257e-04f, -7.943610518e-04f, -3.496785000e-04f, +9.581298838e-04f, +2.558990017e-03f, +3.141911148e-03f, +1.424361314e-03f, -2.642528801e-03f, -7.100466560e-03f, -8.542919350e-03f, -4.174075979e-03f, +5.639102801e-03f, +1.614152455e-02f, +1.978934366e-02f, +1.059762120e-02f, -1.086164335e-02f, -3.502544879e-02f, -4.587135076e-02f, -2.818930815e-02f, +2.368076642e-02f, +1.004673168e-01f, +1.795774427e-01f, +2.337937284e-01f, +2.431699389e-01f, +2.041762626e-01f, +1.313434989e-01f, +5.054163449e-02f, -1.259175953e-02f, -4.317763132e-02f, -4.158213864e-02f, -2.038408523e-02f, +3.669563650e-03f, +1.800339602e-02f, +1.872377146e-02f, +9.876379128e-03f, -9.706060217e-04f, -7.657905115e-03f, -8.186060275e-03f, -4.435337427e-03f, +1.149007964e-04f, +2.809239445e-03f, +2.978387603e-03f, +1.582951955e-03f, +5.058786781e-05f, -7.288781171e-04f, -7.013947777e-04f, -3.170497696e-04f,
        -7.289160273e-05f, +6.321796522e-04f, +1.607653954e-03f, +1.578898272e-03f, -6.820253404e-04f, -4.512709639e-03f, -6.614638076e-03f, -3.188512758e-03f, +5.879667422e-03f, +1.462635870e-02f, +1.414307745e-02f, +4.313540776e-04f, -1.939250507e-02f, -2.967058320e-02f, -1.809666081e-02f, +1.180982562e-02f, +3.950700687e-02f, +4.152554879e-02f, +1.128189512e-02f, -3.222730777e-02f, -5.647633418e-02f, -4.061525952e-02f, +6.370026151e-03f, +5.064975744e-02f, +5.913135860e-02f, +2.540867315e-02f, -2.516417848e-02f, -5.546723295e-02f, -4.522121114e-02f, -5.171060199e-03f, +3.347391875e-02f, +4.417134314e-02f, +2.386718994e-02f, -8.213824032e-03f, -2.813262157e-02f, -2.525421021e-02f, -7.032829474e-03f, +1.043567474e-02f, +1.593898636e-02f, +9.681038274e-03f, -2.585199707e-04f, -6.107713214e-03f, -5.736915528e-03f, -2.061548634e-03f, +1.016363007e-03f, +1.799900934e-03f, +1.017767593e-03f, +1.171094832e-04f,
        +2.032459926e-05f, +2.460697086e-05f, -7.802366320e-07f, -5.423212726e-05f, -1.007525581e-04f, -8.601535640e-05f, +2.132956422e-05f, +1.851908887e-04f, +2.960872217e-04f, +2.280289067e-04f, -6.216550883e-05f, -4.583176107e-04f, -7.034697038e-04f, -5.370296229e-04f, +1.097988158e-04f, +9.843715783e-04f, +1.563007677e-03f, +1.300823683e-03f, -3.120562914e-05f, -2.117978792e-03f, -4.146445129e-03f, -5.148645087e-03f, -4.485524544e-03f, -2.212088805e-03f, +8.909585180e-04f, +3.657484738e-03f, +5.078461389e-03f, +4.761745523e-03f, +3.071438158e-03f, +8.903907804e-04f, -8.447000245e-04f, -1.576115501e-03f, -1.309366105e-03f, -4.910136010e-04f, +3.061393594e-04f, +6.918695702e-04f, +6.016008928e-04f, +2.353727258e-04f, -1.256045662e-04f, -2.939449663e-04f, -2.483026841e-04f, -9.115875605e-05f, +5.021681594e-05f, +1.048028527e-04f, +7.856878056e-05f, +2.200368024e-05f, -1.776326699e-05f, -2.485289707e-05f,
        -2.249519359e-05f, -6.065202711e-05f, -4.804651873e-05f, +6.015583712e-05f, +2.083676856e-04f, +2.331834640e-04f, -6.770848861e-07f, -4.083916371e-04f, -6.470662585e-04f, -3.623634157e-04f, +4.257833885e-04f, +1.169549304e-03f, +1.135794214e-03f, +6.937474964e-05f, -1.396719979e-03f, -2.074395682e-03f, -1.174650167e-03f, +8.813995793e-04f, +2.589705622e-03f, +2.488983513e-03f, +4.249506554e-04f, -2.158558199e-03f, -3.269375510e-03f, -1.967622483e-03f, +8.177176306e-04f, +2.984526936e-03f, +2.921259728e-03f, +7.647279520e-04f, -1.773143062e-03f, -2.817464960e-03f, -1.775143192e-03f, +3.445958614e-04f, +1.882186182e-03f, +1.858009816e-03f, +5.891793017e-04f, -7.797996862e-04f, -1.283898334e-03f, -8.026117632e-04f, +5.803657589e-05f, +5.981467065e-04f, +5.586638714e-04f, +1.733364085e-04f, -1.644573947e-04f, -2.453588821e-04f, -1.280780387e-04f, +1.223419269e-05f, +6.541522858e-05f, +4.092953074e-05f,
        /*  4,12 (48) */
        -1.594593269e-04f, -5.459737548e-04f, -7.951412884e-04f, -4.039106273e-04f, +8.573773257e-04f, +2.472974661e-03f, +3.163240712e-03f, +1.609552203e-03f, -2.346441579e-03f, -6.872437653e-03f, -8.605084859e-03f, -4.632393590e-03f, +4.935633097e-03f, +1.560449493e-02f, +1.989914247e-02f, +1.158199278e-02f, -9.298635668e-03f, -3.372462511e-02f, -4.590255639e-02f, -3.030728694e-02f, +1.953432129e-02f, +9.531867170e-02f, +1.750919182e-01f, +2.315816396e-01f, +2.440608974e-01f, +2.078337474e-01f, +1.364219603e-01f, +5.530338001e-02f, -9.520321375e-03f, -4.228724054e-02f, -4.242683867e-02f, -2.196020074e-02f, +2.360197545e-03f, +1.751238242e-02f, +1.902991082e-02f, +1.056824870e-02f, -3.690051289e-04f, -7.422532389e-03f, -8.311664841e-03f, -4.729282393e-03f, -1.334018877e-04f, +2.718080689e-03f, +3.028604419e-03f, +1.687754808e-03f, +1.291566484e-04f, -7.068744368e-04f, -7.191580447e-04f, -3.419026667e-04f,
        -9.538679632e-05f, +5.715276251e-04f, +1.559607435e-03f, +1.639054109e-03f, -4.736576549e-04f, -4.279526175e-03f, -6.615315161e-03f, -3.596904395e-03f, +5.232601164e-03f, +1.426399528e-02f, +1.456886084e-02f, +1.600903381e-03f, -1.825671085e-02f, -2.960120845e-02f, -1.949338079e-02f, +9.735429939e-03f, +3.833235670e-02f, +4.240694837e-02f, +1.387160074e-02f, -2.973832426e-02f, -5.605138352e-02f, -4.277381772e-02f, +3.100650641e-03f, +4.868213496e-02f, +5.994907623e-02f, +2.839320009e-02f, -2.224291876e-02f, -5.470250500e-02f, -4.699435420e-02f, -7.988525159e-03f, +3.169877556e-02f, +4.451593900e-02f, +2.574937612e-02f, -6.355814215e-03f, -2.754344226e-02f, -2.603400990e-02f, -8.316727808e-03f, +9.633062975e-03f, +1.599702293e-02f, +1.027918498e-02f, +3.001439006e-04f, -5.934376806e-03f, -5.901372922e-03f, -2.306907516e-03f, +8.882849680e-04f, +1.812135126e-03f, +1.083182822e-03f, +1.580390140e-04f,
        +1.946383437e-05f, +2.507083135e-05f, +1.807232852e-06f, -5.057089919e-05f, -9.908437117e-05f, -8.959208158e-05f, +1.217293043e-05f, +1.751005601e-04f, +2.932892410e-04f, +2.390542422e-04f, -3.884562163e-05f, -4.349081821e-04f, -6.980656076e-04f, -5.622843227e-04f, +5.838895299e-05f, +9.321568742e-04f, +1.546728218e-03f, +1.348665889e-03f, +8.035797108e-05f, -1.979090371e-03f, -4.040337745e-03f, -5.131168788e-03f, -4.578708397e-03f, -2.389547080e-03f, +6.943928988e-04f, +3.515924974e-03f, +5.040408874e-03f, +4.828995200e-03f, +3.201943052e-03f, +1.022169247e-03f, -7.626505743e-04f, -1.562449107e-03f, -1.348204232e-03f, -5.470861159e-04f, +2.658826444e-04f, +6.826735565e-04f, +6.182403434e-04f, +2.608383219e-04f, -1.075577770e-04f, -2.902740750e-04f, -2.558267896e-04f, -1.016705850e-04f, +4.359758709e-05f, +1.041471292e-04f, +8.169444519e-05f, +2.540375540e-05f, -1.624621214e-05f, -2.521870143e-05f,
        -1.997819080e-05f, -5.902239499e-05f, -5.152445542e-05f, +5.097508111e-05f, +2.007480380e-04f, +2.385701128e-04f, +2.141035931e-05f, -3.834583218e-04f, -6.449391495e-04f, -3.979090191e-04f, +3.699785465e-04f, +1.139220329e-03f, +1.169755890e-03f, +1.586408310e-04f, -1.315601324e-03f, -2.075165918e-03f, -1.276050184e-03f, +7.446799040e-04f, +2.525288040e-03f, +2.560085015e-03f, +5.902221241e-04f, -2.021755815e-03f, -3.270051945e-03f, -2.110929078e-03f, +6.387110148e-04f, +2.905115653e-03f, +2.997878283e-03f, +9.328759901e-04f, -1.643063030e-03f, -2.816067114e-03f, -1.888500953e-03f, +2.129361260e-04f, +1.828080810e-03f, +1.905354028e-03f, +6.844865997e-04f, -7.131923655e-04f, -1.284683345e-03f, -8.520507510e-04f, +7.906233985e-06f, +5.815844655e-04f, +5.753710700e-04f, +1.996906535e-04f, -1.501848820e-04f, -2.477495159e-04f, -1.378560946e-04f, +5.521696940e-06f, +6.494024989e-05f, +4.351565455e-05f,
        /*  4,13 (48) */
        -1.399954926e-04f, -5.209029234e-04f, -7.933340555e-04f, -4.544815265e-04f, +7.582929545e-04f, +2.383382579e-03f, +3.175413642e-03f, +1.784652763e-03f, -2.053152338e-03f, -6.633383411e-03f, -8.643930480e-03f, -5.067301772e-03f, +4.237567489e-03f, +1.504221061e-02f, +1.995753143e-02f, +1.251414965e-02f, -7.751907450e-03f, -3.237595922e-02f, -4.582219842e-02f, -3.228637731e-02f, +1.549398355e-02f, +9.018750292e-02f, +1.705132098e-01f, +2.291920925e-01f, +2.447552903e-01f, +2.113496723e-01f, +1.414623692e-01f, +6.013237521e-02f, -6.318378323e-03f, -4.126507130e-02f, -4.318948924e-02f, -2.352264984e-02f, +1.011993314e-03f, +1.696529630e-02f, +1.929579347e-02f, +1.125092225e-02f, +2.492352145e-04f, -7.161694067e-03f, -8.419222618e-03f, -5.019556468e-03f, -3.892286773e-04f, +2.616410104e-03f, +3.072202006e-03f, +1.791901937e-03f, +2.108510936e-04f, -6.814706814e-04f, -7.354042568e-04f, -3.671213681e-04f,
        -1.153649871e-04f, +5.125052301e-04f, +1.508082980e-03f, +1.690029190e-03f, -2.729096169e-04f, -4.040956062e-03f, -6.593904801e-03f, -3.980362717e-03f, +4.587662014e-03f, +1.386608626e-02f, +1.493883939e-02f, +2.740123711e-03f, -1.708695496e-02f, -2.944256762e-02f, -2.080898211e-02f, +7.660264021e-03f, +3.705630652e-02f, +4.315162828e-02f, +1.639688878e-02f, -2.717823924e-02f, -5.546116140e-02f, -4.479557353e-02f, -1.694013043e-04f, +4.657120588e-02f, +6.058778724e-02f, +3.129831574e-02f, -1.924504047e-02f, -5.376962901e-02f, -4.863741723e-02f, -1.080459227e-02f, +2.981027461e-02f, +4.472887513e-02f, +2.757745693e-02f, -4.450460187e-03f, -2.685895566e-02f, -2.674720226e-02f, -9.601411153e-03f, +8.781012224e-03f, +1.600492917e-02f, +1.086076945e-02f, +8.755149706e-04f, -5.734686152e-03f, -6.051557804e-03f, -2.554657032e-03f, +7.504288733e-04f, +1.817656823e-03f, +1.148123072e-03f, +2.015546685e-04f,
        +1.856640645e-05f, +2.541551119e-05f, +4.268934018e-06f, -4.690290633e-05f, -9.718348809e-05f, -9.278551127e-05f, +3.282499426e-06f, +1.648448594e-04f, +2.897922728e-04f, +2.491507715e-04f, -1.604031493e-05f, -4.109877721e-04f, -6.910422827e-04f, -5.855336396e-04f, +8.068450342e-06f, +8.789479600e-04f, +1.527174191e-03f, +1.392140813e-03f, +1.886513393e-04f, -1.840275841e-03f, -3.930337947e-03f, -5.107037743e-03f, -4.665242587e-03f, -2.563365105e-03f, +4.967594365e-04f, +3.369090678e-03f, +4.995311351e-03f, +4.890527745e-03f, +3.330262345e-03f, +1.155617987e-03f, -6.765567998e-04f, -1.544664201e-03f, -1.384701936e-03f, -6.031742885e-04f, +2.239637995e-04f, +6.715031297e-04f, +6.337052964e-04f, +2.862935634e-04f, -8.872654422e-05f, -2.857102798e-04f, -2.628740404e-04f, -1.122371906e-04f, +3.661966384e-05f, +1.031510331e-04f, +8.468914430e-05f, +2.887242359e-05f, -1.459115580e-05f, -2.549779187e-05f,
        -1.752542097e-05f, -5.720976625e-05f, -5.459686724e-05f, +4.202254467e-05f, +1.926898844e-04f, +2.428860696e-04f, +4.266457517e-05f, -3.579848182e-04f, -6.407018084e-04f, -4.312229160e-04f, +3.142690478e-04f, +1.105854670e-03f, +1.199326656e-03f, +2.458698177e-04f, -1.231579914e-03f, -2.069419948e-03f, -1.372261576e-03f, +6.070483377e-04f, +2.453601469e-03f, +2.622762061e-03f, +7.527445461e-04f, -1.879279726e-03f, -3.260645812e-03f, -2.247563083e-03f, +4.576765036e-04f, +2.816590098e-03f, +3.065474889e-03f, +1.098936335e-03f, -1.507053898e-03f, -2.805872340e-03f, -1.997013978e-03f, +7.914526029e-05f, +1.767494544e-03f, +1.947313080e-03f, +7.791577591e-04f, -6.430507441e-04f, -1.281274664e-03f, -8.997806223e-04f, -4.350302225e-05f, +5.625738223e-04f, +5.905744836e-04f, +2.262137482e-04f, -1.348266799e-04f, -2.492864582e-04f, -1.475283405e-04f, -1.564053316e-06f, +6.412929389e-05f, +4.604377184e-05f,
        /*  4,14 (48) */
        -1.214290861e-04f, -4.954874122e-04f, -7.890651215e-04f, -5.013844328e-04f, +6.611094664e-04f, +2.290597068e-03f, +3.178696142e-03f, +1.949497623e-03f, -1.763360065e-03f, -6.384232639e-03f, -8.659970795e-03f, -5.478289544e-03f, +3.546525207e-03f, +1.445667697e-02f, +1.996559988e-02f, +1.339309761e-02f, -6.224733259e-03f, -3.098381841e-02f, -4.563354708e-02f, -3.412665315e-02f, +1.156364560e-02f, +8.508046517e-02f, +1.658479672e-01f, +2.266287274e-01f, +2.452520498e-01f, +2.147187630e-01f, +1.464576805e-01f, +6.502290296e-02f, -2.988115978e-03f, -4.010945331e-02f, -4.386604604e-02f, -2.506731404e-02f, -3.727086224e-04f, +1.636212202e-02f, +1.951975726e-02f, +1.192242538e-02f, +8.829405108e-04f, -6.875400504e-03f, -8.507949162e-03f, -5.305266748e-03f, -6.521027177e-04f, +2.504172913e-03f, +3.108821669e-03f, +1.895052970e-03f, +2.955402379e-04f, -6.525982578e-04f, -7.499954126e-04f, -3.926191600e-04f,
        -1.328904081e-04f, +4.552954639e-04f, +1.453486113e-03f, +1.732051735e-03f, -8.021973253e-05f, -3.798069993e-03f, -6.551240226e-03f, -4.338347535e-03f, +3.946960206e-03f, +1.343486335e-02f, +1.525310843e-02f, +3.845978381e-03f, -1.588762831e-02f, -2.919669781e-02f, -2.204056203e-02f, +5.590844074e-03f, +3.568404494e-02f, +4.375867662e-02f, +1.885049025e-02f, -2.455547718e-02f, -5.470841685e-02f, -4.667485326e-02f, -3.430047117e-03f, +4.432364280e-02f, +6.104546375e-02f, +3.411490584e-02f, -1.617956558e-02f, -5.267069267e-02f, -5.014447113e-02f, -1.361046461e-02f, +2.781326063e-02f, +4.480802039e-02f, +2.934495148e-02f, -2.503147107e-03f, -2.607979791e-02f, -2.739025301e-02f, -1.088268582e-02f, +7.881231602e-03f, +1.596142614e-02f, +1.142334327e-02f, +1.466089454e-03f, -5.508472404e-03f, -6.186384484e-03f, -2.803943490e-03f, +6.029005328e-04f, +1.816092770e-03f, +1.212252366e-03f, +2.475984404e-04f,
        +1.763779865e-05f, +2.564493378e-05f, +6.601447436e-06f, -4.324034279e-05f, -9.506401101e-05f, -9.559884073e-05f, -5.324473980e-06f, +1.544572875e-04f, +2.856253319e-04f, +2.583162013e-04f, +6.203719232e-06f, -3.866306003e-04f, -6.824562554e-04f, -6.067667708e-04f, -4.106534528e-05f, +8.248943874e-04f, +1.504467573e-03f, +1.431258577e-03f, +2.935367743e-04f, -1.701776486e-03f, -3.816679123e-03f, -5.076354457e-03f, -4.745033012e-03f, -2.733284861e-03f, +2.983617596e-04f, +3.217188611e-03f, +4.943187407e-03f, +4.946179436e-03f, +3.456144344e-03f, +1.290524252e-03f, -5.865016042e-04f, -1.522700842e-03f, -1.418716096e-03f, -6.591406331e-04f, +1.804486605e-04f, +6.583392203e-04f, +6.479262746e-04f, +3.116704700e-04f, -6.914107652e-05f, -2.802413978e-04f, -2.694105448e-04f, -1.228295386e-04f, +2.929220594e-05f, +1.018057305e-04f, +8.753816689e-05f, +3.240045182e-05f, -1.279823439e-05f, -2.568494077e-05f,
        -1.514649021e-05f, -5.523260112e-05f, -5.726948053e-05f, +3.332559610e-05f, +1.842423113e-04f, +2.461532424e-04f, +6.303458543e-05f, -3.320784716e-04f, -6.344264800e-04f, -4.622457530e-04f, +2.588417395e-04f, +1.069626454e-03f, +1.224490089e-03f, +3.308092521e-04f, -1.144973117e-03f, -2.057262883e-03f, -1.463034725e-03f, +4.689556004e-04f, +2.374936970e-03f, +2.676873833e-03f, +9.120159997e-04f, -1.731605663e-03f, -3.241213287e-03f, -2.377098497e-03f, +2.751886192e-04f, +2.719216202e-03f, +3.123805670e-03f, +1.262369016e-03f, -1.365515110e-03f, -2.786846348e-03f, -2.100287318e-03f, -5.636515345e-05f, +1.700545044e-03f, +1.983672901e-03f, +8.728683017e-04f, -5.695474258e-04f, -1.273601320e-03f, -9.456000801e-04f, -9.604230733e-05f, +5.411178559e-04f, +6.041753047e-04f, +2.528121168e-04f, -1.184039648e-04f, -2.499307227e-04f, -1.570497127e-04f, -9.009032545e-06f, +6.296872165e-05f, +4.849702512e-05f,
        /*  4,15 (48) */
        -1.037912875e-04f, -4.698424785e-04f, -7.824636741e-04f, -5.446247756e-04f, +5.660454554e-04f, +2.194998227e-03f, +3.173371668e-03f, +2.103954910e-03f, -1.477734733e-03f, -6.125916438e-03f, -8.653767076e-03f, -5.864920145e-03f, +2.864068951e-03f, +1.384991020e-02f, +1.992453453e-02f, +1.421799200e-02f, -4.720265686e-03f, -2.955255983e-02f, -4.534001030e-02f, -3.582842964e-02f, +7.746966475e-03f, +8.000411071e-02f, +1.611029342e-01f, +2.238954425e-01f, +2.455504115e-01f, +2.179359516e-01f, +1.514008679e-01f, +6.996908239e-02f, +4.680283662e-04f, -3.881892906e-02f, -4.445254764e-02f, -2.659001489e-02f, -1.791424718e-03f, +1.570298138e-02f, +1.970020593e-02f, +1.258076460e-02f, +1.530866785e-03f, -6.563730034e-03f, -8.577090238e-03f, -5.585508145e-03f, -9.215132624e-04f, +2.381343374e-03f, +3.138113875e-03f, +1.996858701e-03f, +3.830784047e-04f, -6.201978060e-04f, -7.627936470e-04f, -4.183041008e-04f,
        -1.480368983e-04f, +4.000628628e-04f, +1.396216632e-03f, +1.765377331e-03f, +1.040225788e-04f, -3.551916750e-03f, -6.488205641e-03f, -4.670426006e-03f, +3.312533726e-03f, +1.297261759e-02f, +1.551195017e-02f, +4.915604835e-03f, -1.466313822e-02f, -2.886588855e-02f, -2.318553514e-02f, +3.533581191e-03f, +3.422101022e-02f, +4.422763222e-02f, +2.122542722e-02f, -2.187860335e-02f, -5.379640085e-02f, -4.840645892e-02f, -6.671260404e-03f, +4.194654430e-02f, +6.132065237e-02f, +3.683412204e-02f, -1.305575991e-02f, -5.140832366e-02f, -5.150998624e-02f, -1.639731096e-02f, +2.571297331e-02f, +4.475165524e-02f, +3.104549652e-02f, -5.194742057e-04f, -2.520692960e-02f, -2.795980043e-02f, -1.215628714e-02f, +6.935631522e-03f, +1.586538384e-02f, +1.196446112e-02f, +2.070264759e-03f, -5.255660287e-03f, -6.304788449e-03f, -3.053874213e-03f, +4.458508201e-04f, +1.807083737e-03f, +1.275221087e-03f, +2.960954655e-04f,
        +1.668340381e-05f, +2.576330239e-05f, +8.801928510e-06f, -3.959496484e-05f, -9.274027171e-05f, -9.803631935e-05f, -1.363207129e-05f, +1.439707896e-04f, +2.808185262e-04f, +2.665508263e-04f, +2.784242037e-05f, -3.619102752e-04f, -6.723667394e-04f, -6.259781652e-04f, -8.892008168e-05f, +7.701444613e-04f, +1.478734758e-03f, +1.466038086e-03f, +3.948853898e-04f, -1.563829895e-03f, -3.699598995e-03f, -5.039232434e-03f, -4.817997977e-03f, -2.899055761e-03f, +9.950496562e-05f, +3.060435122e-03f, +4.884068303e-03f, +4.995795890e-03f, +3.579339114e-03f, +1.426669522e-03f, -4.925772700e-04f, -1.496506860e-03f, -1.450106209e-03f, -7.148449213e-04f, +1.354085236e-04f, +6.431674293e-04f, +6.608354264e-04f, +3.368996142e-04f, -4.883441716e-05f, -2.738574663e-04f, -2.754029446e-04f, -1.334176747e-04f, +2.162572117e-05f, +1.001032074e-04f, +9.022677896e-05f, +3.597806555e-05f, -1.086809859e-05f, -2.577507531e-05f,
        -1.285012779e-05f, -5.310929686e-05f, -5.954958857e-05f, +2.490941987e-05f, +1.754542022e-04f, +2.483969291e-04f, +8.247435647e-05f, -3.058451921e-04f, -6.261909334e-04f, -4.909277589e-04f, +2.038784127e-04f, +1.030716273e-03f, +1.245245151e-03f, +4.132185360e-04f, -1.056102385e-03f, -2.038819890e-03f, -1.548140897e-03f, +3.308495136e-04f, +2.289606150e-03f, +2.722308581e-03f, +1.067547924e-03f, -1.579224448e-03f, -3.211843143e-03f, -2.499132998e-03f, +9.182675706e-05f, +2.613289263e-03f, +3.172656367e-03f, +1.422640286e-03f, -1.218866689e-03f, -2.758983809e-03f, -2.197939940e-03f, -1.931735069e-04f, +1.627372799e-03f, +2.014235506e-03f, +9.652920767e-04f, -4.928695846e-04f, -1.261605930e-03f, -9.893104132e-04f, -1.495552505e-04f, +5.172287092e-04f, +6.160780337e-04f, +2.793890885e-04f, -1.009428352e-04f, -2.496456082e-04f, -1.663740391e-04f, -1.679698635e-05f, +6.144595631e-05f, +5.085810041e-05f,
        /*  5, 0 (48) */
        -9.712561017e-05f, +5.630052980e-04f, +1.206067011e-03f, +7.527819647e-04f, -1.206557913e-03f, -3.245991688e-03f, -2.728345499e-03f, +1.489426586e-03f, +6.622324221e-03f, +7.089903931e-03f, -2.805093114e-04f, -1.122619085e-02f, -1.522873798e-02f, -4.406023078e-03f, +1.648289776e-02f, +2.943133839e-02f, +1.647195998e-02f, -2.143009154e-02f, -5.654855430e-02f, -4.868148545e-02f, +2.497919491e-02f, +1.464018327e-01f, +2.604437981e-01f, +3.070623956e-01f, +2.604437981e-01f, +1.464018327e-01f, +2.497919491e-02f, -4.868148545e-02f, -5.654855430e-02f, -2.143009154e-02f, +1.647195998e-02f, +2.943133839e-02f, +1.648289776e-02f, -4.406023078e-03f, -1.522873798e-02f, -1.122619085e-02f, -2.805093114e-04f, +7.089903931e-03f, +6.622324221e-03f, +1.489426586e-03f, -2.728345499e-03f, -3.245991688e-03f, -1.206557913e-03f, +7.527819647e-04f, +1.206067011e-03f, +5.630052980e-04f, -9.712561017e-05f, -2.479949097e-04f,
        +5.939400487e-04f, -2.971519080e-04f, -2.102283883e-03f, -2.360885377e-03f, +1.198769271e-03f, +6.225411832e-03f, +5.885033052e-03f, -3.266913899e-03f, -1.360369760e-02f, -1.128997664e-02f, +6.959510654e-03f, +2.424665836e-02f, +1.796260386e-02f, -1.233743150e-02f, -3.690527276e-02f, -2.458115068e-02f, +1.881243249e-02f, +4.916511396e-02f, +2.951026661e-02f, -2.514630357e-02f, -5.812289420e-02f, -3.141212080e-02f, +2.978290985e-02f, +6.141247912e-02f, +2.978290985e-02f, -3.141212080e-02f, -5.812289420e-02f, -2.514630357e-02f, +2.951026661e-02f, +4.916511396e-02f, +1.881243249e-02f, -2.458115068e-02f, -3.690527276e-02f, -1.233743150e-02f, +1.796260386e-02f, +2.424665836e-02f, +6.959510654e-03f, -1.128997664e-02f, -1.360369760e-02f, -3.266913899e-03f, +5.885033052e-03f, +6.225411832e-03f, +1.198769271e-03f, -2.360885377e-03f, -2.102283883e-03f, -2.971519080e-04f, +5.939400487e-04f, +3.757269824e-04f,
        -2.508302509e-05f, -5.057785772e-05f, -1.918107920e-05f, +7.614726015e-05f, +1.495424008e-04f, +7.931711402e-05f, -1.459714138e-04f, -3.406750891e-04f, -2.433712429e-04f, +1.983896676e-04f, +6.524107990e-04f, +6.007705035e-04f, -1.502978448e-04f, -1.100700600e-03f, -1.299390585e-03f, -1.772665892e-04f, +1.689680367e-03f, +2.690517210e-03f, +1.332314287e-03f, -2.360472425e-03f, -6.418436176e-03f, -8.056724670e-03f, -5.673724385e-03f, -1.913317227e-04f, +5.398188759e-03f, +8.029841120e-03f, +6.618456882e-03f, +2.632051071e-03f, -1.158478686e-03f, -2.684491539e-03f, -1.796887600e-03f, +6.940613874e-05f, +1.268675429e-03f, +1.145022466e-03f, +2.127596292e-04f, -5.728784120e-04f, -6.688059981e-04f, -2.317208331e-04f, +2.243769326e-04f, +3.453724072e-04f, +1.618744025e-04f, -6.884228518e-05f, -1.503606098e-04f, -8.271393049e-05f, +1.468554497e-05f, +5.074766006e-05f, +2.734599447e-05f, -3.833276021e-06f,
        +1.008568569e-05f, +9.639225967e-05f, +1.014076270e-04f, -8.748225870e-05f, -3.212645130e-04f, -2.329728192e-04f, +2.917425243e-04f, +7.442576965e-04f, +4.046105230e-04f, -6.801120963e-04f, -1.372439335e-03f, -5.665968633e-04f, +1.265687754e-03f, +2.132658970e-03f, +6.521483036e-04f, -1.987873747e-03f, -2.875817282e-03f, -6.074058072e-04f, +2.711331088e-03f, +3.420033908e-03f, +4.211150561e-04f, -3.262185724e-03f, -3.617154996e-03f, -1.364461560e-04f, +3.490126337e-03f, +3.411893142e-03f, -1.638129533e-04f, -3.328507442e-03f, -2.864275019e-03f, +3.923144403e-04f, +2.822614710e-03f, +2.124180390e-03f, -4.941334060e-04f, -2.111330779e-03f, -1.371270310e-03f, +4.663515915e-04f, +1.371323979e-03f, +7.501865082e-04f, -3.514638438e-04f, -7.515829083e-04f, -3.304016101e-04f, +2.109512166e-04f, +3.288820696e-04f, +1.041165060e-04f, -9.544071803e-05f, -1.008885095e-04f, -1.481360237e-05f, +2.719430556e-05f,
        /*  5, 1 (48) */
        -1.222086353e-04f, +5.124274402e-04f, +1.186885931e-03f, +8.289292249e-04f, -1.057015512e-03f, -3.166674574e-03f, -2.874316912e-03f, +1.148751496e-03f, +6.378952979e-03f, +7.288293598e-03f, +3.719014876e-04f, -1.062542035e-02f, -1.537903583e-02f, -5.506723678e-03f, +1.518350718e-02f, +2.925407180e-02f, +1.816164035e-02f, -1.873957433e-02f, -5.521624002e-02f, -5.104195788e-02f, +1.856075873e-02f, +1.383451080e-01f, +2.547700737e-01f, +3.068710639e-01f, +2.658419868e-01f, +1.544316738e-01f, +3.159765179e-02f, -4.604943438e-02f, -5.770703299e-02f, -2.411458308e-02f, +1.467507238e-02f, +2.950074453e-02f, +1.775157319e-02f, -3.261000612e-03f, -1.501597835e-02f, -1.179906927e-02f, -9.493153096e-04f, +6.858183098e-03f, +6.846701154e-03f, +1.834798993e-03f, -2.566471096e-03f, -3.314833973e-03f, -1.356918523e-03f, +6.700680342e-04f, +1.220752556e-03f, +6.137529580e-04f, -6.977961571e-05f, -2.518281858e-04f,
        +6.040257344e-04f, -2.007596483e-04f, -2.000876256e-03f, -2.448367636e-03f, +8.775047576e-04f, +5.992439012e-03f, +6.176775576e-03f, -2.522656203e-03f, -1.319908707e-02f, -1.197008873e-02f, +5.587071319e-03f, +2.368006150e-02f, +1.922829162e-02f, -1.020477253e-02f, -3.625312446e-02f, -2.656902443e-02f, +1.593661521e-02f, +4.855770816e-02f, +3.222159770e-02f, -2.172626967e-02f, -5.770177914e-02f, -3.467430652e-02f, +2.616575485e-02f, +6.127603297e-02f, +3.327303618e-02f, -2.800022766e-02f, -5.828670715e-02f, -2.847481101e-02f, +2.664599159e-02f, +4.955742841e-02f, +2.163504720e-02f, -2.245697029e-02f, -3.739940617e-02f, -1.444876228e-02f, +1.659133356e-02f, +2.471300995e-02f, +8.330834633e-03f, -1.053979013e-02f, -1.395516144e-02f, -4.018496808e-03f, +5.554631442e-03f, +6.436363048e-03f, +1.527651340e-03f, -2.256768871e-03f, -2.197724601e-03f, -3.980404175e-04f, +5.791264463e-04f, +4.029212880e-04f,
        -2.281208434e-05f, -5.017048726e-05f, -2.339141928e-05f, +6.951154581e-05f, +1.481249922e-04f, +8.911175882e-05f, -1.299825782e-04f, -3.347647599e-04f, -2.608764580e-04f, +1.651833839e-04f, +6.339296100e-04f, +6.256750450e-04f, -8.879179446e-05f, -1.053316962e-03f, -1.324532268e-03f, -2.818289479e-04f, +1.579065996e-03f, +2.686788922e-03f, +1.496322096e-03f, -2.090629234e-03f, -6.208548452e-03f, -8.066993076e-03f, -5.936404813e-03f, -5.735503789e-04f, +5.110383358e-03f, +7.986246299e-03f, +6.807960120e-03f, +2.904663123e-03f, -9.750973470e-04f, -2.668473744e-03f, -1.900214177e-03f, -4.143284789e-05f, +1.232368496e-03f, +1.186038462e-03f, +2.759575187e-04f, -5.420338332e-04f, -6.829958540e-04f, -2.650454587e-04f, +2.039295517e-04f, +3.488011481e-04f, +1.776211840e-04f, -5.771011145e-05f, -1.505544017e-04f, -8.917830032e-05f, +9.914746689e-06f, +5.066803309e-05f, +2.958766734e-05f, -2.491308441e-06f,
        +5.600138690e-06f, +9.158013602e-05f, +1.065180250e-04f, -7.111861119e-05f, -3.123047380e-04f, -2.530462502e-04f, +2.529040111e-04f, +7.335582551e-04f, +4.544147255e-04f, -6.085229571e-04f, -1.367108885e-03f, -6.622257906e-04f, +1.156134388e-03f, +2.143836296e-03f, +8.049429437e-04f, -1.844174763e-03f, -2.915341338e-03f, -8.177702581e-04f, +2.547228180e-03f, +3.495490471e-03f, +6.753471971e-04f, -3.098138979e-03f, -3.727586997e-03f, -4.087067610e-04f, +3.347065450e-03f, +3.546524520e-03f, +9.537642794e-05f, -3.221242552e-03f, -3.005262188e-03f, +1.734621290e-04f, +2.755838884e-03f, +2.252359276e-03f, -3.315766088e-04f, -2.079793499e-03f, -1.472302924e-03f, +3.618865460e-04f, +1.363627926e-03f, +8.183617051e-04f, -2.951538003e-04f, -7.553980289e-04f, -3.686736639e-04f, +1.870303451e-04f, +3.350629867e-04f, +1.209377896e-04f, -8.861192429e-05f, -1.050228857e-04f, -1.976523353e-05f, +2.669965649e-05f,
        /*  5, 2 (48) */
        -1.450207196e-04f, +4.622569530e-04f, +1.163494512e-03f, +8.984407707e-04f, -9.088905201e-04f, -3.077562815e-03f, -3.004299491e-03f, +8.139867365e-04f, +6.118076521e-03f, +7.453476982e-03f, +1.005831098e-03f, -9.999745306e-03f, -1.546782762e-02f, -6.560040640e-03f, +1.385897491e-02f, +2.897224286e-02f, +1.974070635e-02f, -1.605278541e-02f, -5.371991792e-02f, -5.313258711e-02f, +1.235221028e-02f, +1.302781149e-01f, +2.488336689e-01f, +3.062975135e-01f, +2.709523702e-01f, +1.624179201e-01f, +3.840561191e-02f, -4.314477126e-02f, -5.868213034e-02f, -2.678305683e-02f, +1.277485821e-02f, +2.945931168e-02f, +1.898394169e-02f, -2.074962149e-03f, -1.474002084e-02f, -1.234110310e-02f, -1.632311164e-03f, +6.593137639e-03f, +7.050630706e-03f, +2.183600141e-03f, -2.388849912e-03f, -3.372544084e-03f, -1.507472925e-03f, +5.808897339e-04f, +1.230667302e-03f, +6.644209911e-04f, -4.019194836e-05f, -2.543194942e-04f,
        +6.096258730e-04f, -1.091795123e-04f, -1.894358231e-03f, -2.519486247e-03f, +5.652000196e-04f, +5.739392762e-03f, +6.429679587e-03f, -1.789097948e-03f, -1.274467235e-02f, -1.257861169e-02f, +4.219962434e-03f, +2.301783571e-02f, +2.038442601e-02f, -8.060936232e-03f, -3.544818151e-02f, -2.841319919e-02f, +1.302127387e-02f, +4.773993790e-02f, +3.476882588e-02f, -1.823077919e-02f, -5.702643195e-02f, -3.777244550e-02f, +2.243816785e-02f, +6.086732621e-02f, +3.662010163e-02f, -2.445370314e-02f, -5.819133072e-02f, -3.169605357e-02f, +2.364072940e-02f, +4.973089053e-02f, +2.439088608e-02f, -2.020461102e-02f, -3.773098278e-02f, -1.652855578e-02f, +1.511903063e-02f, +2.507489650e-02f, +9.694462559e-03f, -9.721428422e-03f, -1.425031524e-02f, -4.773894837e-03f, +5.185957778e-03f, +6.623393393e-03f, +1.862714327e-03f, -2.135831082e-03f, -2.286336525e-03f, -5.030633032e-04f, +5.593612128e-04f, +4.296209445e-04f,
        -2.054597997e-05f, -4.953813809e-05f, -2.730837028e-05f, +6.283919623e-05f, +1.461354251e-04f, +9.820701606e-05f, -1.139765576e-04f, -3.277004432e-04f, -2.768635425e-04f, +1.322295665e-04f, +6.134870589e-04f, +6.475693674e-04f, -2.845238567e-05f, -1.003121559e-03f, -1.344138791e-03f, -3.827926075e-04f, +1.465518940e-03f, +2.673570778e-03f, +1.650254353e-03f, -1.823208447e-03f, -5.989464080e-03f, -8.060786240e-03f, -6.185680776e-03f, -9.544359400e-04f, +4.810928188e-03f, +7.925888400e-03f, +6.986317469e-03f, +3.177593401e-03f, -7.824862200e-04f, -2.642252808e-03f, -1.999189150e-03f, -1.549126151e-04f, +1.190471988e-03f, +1.223511463e-03f, +3.396638220e-04f, -5.082843731e-04f, -6.948668979e-04f, -2.982287329e-04f, +1.820721445e-04f, +3.509095356e-04f, +1.931399588e-04f, -4.594707460e-05f, -1.501005583e-04f, -9.550639630e-05f, +4.880361657e-06f, +5.032793323e-05f, +3.179425506e-05f, -1.040985477e-06f,
        +1.373031687e-06f, +8.649795645e-05f, +1.107821223e-04f, -5.510432378e-05f, -3.021011351e-04f, -2.711345839e-04f, +2.140883933e-04f, +7.196339889e-04f, +5.007186730e-04f, -5.358023371e-04f, -1.355496472e-03f, -7.528718237e-04f, +1.043198748e-03f, +2.144969009e-03f, +9.518731857e-04f, -1.693845381e-03f, -2.941147774e-03f, -1.022472742e-03f, +2.372811083e-03f, +3.554623527e-03f, +9.253463350e-04f, -2.920555137e-03f, -3.820937052e-03f, -6.790752835e-04f, +3.188613303e-03f, +3.665412401e-03f, +3.552563934e-04f, -3.098647428e-03f, -3.133546031e-03f, -4.815868112e-05f, +2.675661381e-03f, +2.371705449e-03f, -1.651875793e-04f, -2.038037948e-03f, -1.568218952e-03f, +2.536268595e-04f, +1.349246533e-03f, +8.842539332e-04f, -2.358804181e-04f, -7.555818373e-04f, -4.063467844e-04f, +1.612711930e-04f, +3.397174985e-04f, +1.378580622e-04f, -8.092094178e-05f, -1.087495025e-04f, -2.491934601e-05f, +2.594761520e-05f,
        /*  5, 3 (48) */
        -1.655666996e-04f, +4.127188149e-04f, +1.136186142e-03f, +9.612799669e-04f, -7.627550950e-04f, -2.979355799e-03f, -3.118276048e-03f, +4.862862933e-04f, +5.841212978e-03f, +7.585706549e-03f, +1.619318156e-03f, -9.352175938e-03f, -1.549628001e-02f, -7.563162199e-03f, +1.251483612e-02f, +2.858945025e-02f, +2.120622529e-02f, -1.337921463e-02f, -5.206966357e-02f, -5.495579556e-02f, +6.362746202e-03f, +1.222173287e-01f, +2.426479881e-01f, +3.053430776e-01f, +2.757632984e-01f, +1.703438085e-01f, +4.539192938e-02f, -3.996717785e-02f, -5.946461656e-02f, -2.942530964e-02f, +1.077566906e-02f, +2.930439907e-02f, +2.017441367e-02f, -8.514506861e-04f, -1.440035701e-02f, -1.284938747e-02f, -2.327178061e-03f, +6.294908906e-03f, +7.232702850e-03f, +2.534509676e-03f, -2.195709953e-03f, -3.418491159e-03f, -1.657573483e-03f, +4.853833376e-04f, +1.235547664e-03f, +7.147489243e-04f, -8.397693308e-06f, -2.553604797e-04f,
        +6.109989047e-04f, -2.268155584e-05f, -1.783576109e-03f, -2.574590571e-03f, +2.630988845e-04f, +5.468258178e-03f, +6.643767981e-03f, -1.069463959e-03f, -1.224395368e-02f, -1.311441403e-02f, +2.864465963e-03f, +2.226496388e-02f, +2.142762475e-02f, -5.915967223e-03f, -3.449630833e-02f, -3.010704457e-02f, +1.008012610e-02f, +4.671746516e-02f, +3.714163696e-02f, -1.467615567e-02f, -5.610108561e-02f, -4.069300064e-02f, +1.861723080e-02f, +6.018825092e-02f, +3.980871493e-02f, -2.078829074e-02f, -5.783607433e-02f, -3.479470099e-02f, +2.050718337e-02f, +4.968273185e-02f, +2.706654746e-02f, -1.783290557e-02f, -3.789617035e-02f, -1.856659372e-02f, +1.355081168e-02f, +2.532852336e-02f, +1.104370909e-02f, -8.837174489e-03f, -1.448619566e-02f, -5.529476674e-03f, +4.779610994e-03f, +6.784664586e-03f, +2.202431825e-03f, -1.997973020e-03f, -2.367257467e-03f, -6.118128057e-04f, +5.344418668e-04f, +4.555685597e-04f,
        -1.829695311e-05f, -4.869403775e-05f, -3.092545234e-05f, +5.616164946e-05f, +1.436023867e-04f, +1.065872949e-04f, -9.802006855e-05f, -3.195442804e-04f, -2.913103906e-04f, +9.965154298e-05f, +5.912124291e-04f, +6.664430018e-04f, +3.051880904e-05f, -9.503692440e-04f, -1.358267912e-03f, -4.798765786e-04f, +1.349512981e-03f, +2.651151527e-03f, +1.793897867e-03f, -1.558880023e-03f, -5.761871190e-03f, -8.038287157e-03f, -6.421040627e-03f, -1.333103914e-03f, +4.500476158e-03f, +7.848760342e-03f, +7.152924603e-03f, +3.450115621e-03f, -5.809946439e-04f, -2.605646011e-03f, -2.093345793e-03f, -2.706780347e-04f, +1.143009043e-03f, +1.257212371e-03f, +4.036434917e-04f, -4.716902823e-04f, -7.043121473e-04f, -3.311329249e-04f, +1.588547770e-04f, +3.516499085e-04f, +2.083577617e-04f, -3.358328975e-05f, -1.489780312e-04f, -1.016636668e-04f, -4.041819234e-07f, +4.971722257e-05f, +3.395156363e-05f, +5.143564259e-07f,
        -2.582138931e-06f, +8.119107346e-05f, +1.142147107e-04f, -3.951307321e-05f, -2.907553767e-04f, -2.872126999e-04f, +1.754917821e-04f, +7.026467049e-04f, +5.433862206e-04f, -4.623303147e-04f, -1.337793488e-03f, -8.381997143e-04f, +9.274757092e-04f, +2.136210154e-03f, +1.092331806e-03f, -1.537670045e-03f, -2.953263164e-03f, -1.220613385e-03f, +2.188967178e-03f, +3.597258120e-03f, +1.169974583e-03f, -2.730297901e-03f, -3.896801234e-03f, -9.463004484e-04f, +3.015484417e-03f, +3.767961988e-03f, +6.146219611e-04f, -2.961205417e-03f, -3.248435191e-03f, -2.715336861e-04f, +2.582319918e-03f, +2.481548241e-03f, +4.295809510e-06f, -1.986104763e-03f, -1.658467293e-03f, +1.420245927e-04f, +1.328106554e-03f, +9.474821865e-04f, -1.738640922e-04f, -7.520287966e-04f, -4.432058116e-04f, +1.337468773e-04f, +3.427611766e-04f, +1.547851520e-04f, -7.237274682e-05f, -1.120228962e-04f, -3.025215391e-05f, +2.492684353e-05f,
        /*  5, 4 (48) */
        -1.838636527e-04f, +3.640247771e-04f, +1.105260690e-03f, +1.017441616e-03f, -6.191527084e-04f, -2.872768504e-03f, -3.216296117e-03f, +1.667420129e-04f, +5.549902587e-03f, +7.685358092e-03f, +2.210530586e-03f, -8.685732937e-03f, -1.546576120e-02f, -8.513531443e-03f, +1.115656820e-02f, +2.810957367e-02f, +2.255573827e-02f, -1.072806311e-02f, -5.027576570e-02f, -5.651467558e-02f, +6.008750117e-04f, +1.141790415e-01f, +2.362269475e-01f, +3.040099737e-01f, +2.802637745e-01f, +1.781925688e-01f, +5.254485398e-02f, -3.651706223e-02f, -6.004561120e-02f, -3.203095565e-02f, +8.682323264e-03f, +2.903372103e-02f, +2.131742272e-02f, +4.057616846e-04f, -1.399671352e-02f, -1.332107775e-02f, -3.031490209e-03f, +5.963775981e-03f, +7.391557627e-03f, +2.886159585e-03f, -1.987352192e-03f, -3.452074449e-03f, -1.806551514e-03f, +3.837196708e-04f, +1.235143482e-03f, +7.644661469e-04f, +2.555387032e-05f, -2.548461232e-04f,
        +6.084167658e-04f, +5.850951761e-05f, -1.669361398e-03f, -2.614103644e-03f, -2.765649223e-05f, +5.181045478e-03f, +6.819259763e-03f, -3.668172540e-04f, -1.170056746e-02f, -1.357674434e-02f, +1.526672475e-03f, +2.142676417e-02f, +2.235510046e-02f, -3.779757068e-03f, -3.340397652e-02f, -3.164471462e-02f, +7.126862931e-03f, +4.549685177e-02f, +3.933060414e-02f, -1.107889755e-02f, -5.493111103e-02f, -4.342329854e-02f, +1.472042957e-02f, +5.924195048e-02f, +4.282419935e-02f, -1.702032875e-02f, -5.722145237e-02f, -3.775590641e-02f, +1.725874818e-02f, +4.941119817e-02f, +2.964886738e-02f, -1.535135733e-02f, -3.789187454e-02f, -2.055269849e-02f, +1.189234439e-02f, +2.547054795e-02f, +1.237181565e-02f, -7.889692302e-03f, -1.466005975e-02f, -6.281505470e-03f, +4.336405182e-03f, +6.918411464e-03f, +2.545193002e-03f, -1.843187868e-03f, -2.439630214e-03f, -7.238357019e-04f, +5.041897128e-04f, +4.804954032e-04f,
        -1.607663367e-05f, -4.765196158e-05f, -3.423787293e-05f, +4.950925812e-05f, +1.405560294e-04f, +1.142405788e-04f, -8.217765240e-05f, -3.103611873e-04f, -3.042017402e-04f, +6.756799030e-05f, +5.672390375e-04f, +6.822974410e-04f, +8.793011604e-05f, -8.953186611e-04f, -1.366996215e-03f, -5.728200767e-04f, +1.231519640e-03f, +2.619843217e-03f, +1.927074180e-03f, -1.298295096e-03f, -5.526473475e-03f, -7.999721116e-03f, -6.642011674e-03f, -1.708676149e-03f, +4.179711288e-03f, +7.754900054e-03f, +7.307203285e-03f, +3.721494474e-03f, -3.710047202e-04f, -2.558499992e-03f, -2.182223262e-03f, -3.883575103e-04f, +1.090024104e-03f, +1.286921163e-03f, +4.676548732e-04f, -4.323245107e-04f, -7.112316931e-04f, -3.636178797e-04f, +1.343345090e-04f, +3.509790369e-04f, +2.232007484e-04f, -2.065247933e-05f, -1.471681076e-04f, -1.076151274e-04f, -5.923709862e-06f, +4.882675536e-05f, +3.604505625e-05f, +2.170594329e-06f,
        -6.254422861e-06f, +7.570410508e-05f, +1.168348903e-04f, -2.441321203e-05f, -2.783717331e-04f, -3.012670491e-04f, +1.373032065e-04f, +6.827694336e-04f, +5.823030335e-04f, -3.884819314e-04f, -1.314217345e-03f, -9.179066134e-04f, +8.095634262e-04f, +2.117758113e-03f, +1.225750979e-03f, -1.376451619e-03f, -2.951778960e-03f, -1.411331538e-03f, +1.996621844e-03f, +3.623298329e-03f, +1.408124574e-03f, -2.528288105e-03f, -3.954858788e-03f, -1.209146098e-03f, +2.828463513e-03f, +3.853654204e-03f, +8.722656489e-04f, -2.809473102e-03f, -3.349297257e-03f, -4.956314854e-04f, +2.476117843e-03f, +2.581254969e-03f, +1.761107648e-04f, -1.924084932e-03f, -1.742515420e-03f, +2.755693267e-05f, +1.300167151e-03f, +1.007670250e-03f, -1.093449204e-04f, -7.446500392e-04f, -4.790334108e-04f, +1.045426173e-04f, +3.441156022e-04f, +1.716231578e-04f, -6.297778107e-05f, -1.147983424e-04f, -3.573736284e-05f, +2.362740894e-05f,
        /*  5, 5 (48) */
        -1.999402864e-04f, +3.163728156e-04f, +1.071022817e-03f, +1.066950874e-03f, -4.785966790e-04f, -2.758527925e-03f, -3.298473769e-03f, -1.436191744e-04f, +5.245700847e-03f, +7.752926082e-03f, +2.777769623e-03f, -8.003435496e-03f, -1.537783108e-02f, -9.408850104e-03f, +9.789571990e-03f, +2.753675359e-02f, +2.378725791e-02f, -8.108219891e-03f, -4.834869152e-02f, -5.781297067e-02f, -4.925598463e-03f, +1.061793204e-01f, +2.295849358e-01f, +3.023012975e-01f, +2.844434858e-01f, +1.859474689e-01f, +5.985205727e-02f, -3.279556776e-02f, -6.041661592e-02f, -3.458945564e-02f, +6.500100002e-03f, +2.864536352e-02f, +2.240744682e-02f, +1.692682847e-03f, -1.352905865e-02f, -1.375340227e-02f, -3.742721902e-03f, +5.600158101e-03f, +7.525892136e-03f, +3.237138622e-03f, -1.764151443e-03f, -3.472726928e-03f, -1.953719622e-03f, +2.761045433e-04f, +1.229219772e-03f, +8.132929023e-04f, +6.159892657e-05f, -2.526755289e-04f,
        +6.021623429e-04f, +1.342136227e-04f, -1.552526508e-03f, -2.638516856e-03f, -3.060282253e-04f, +4.879778429e-03f, +6.956562969e-03f, +3.159521796e-04f, -1.111826442e-02f, -1.396522627e-02f, +2.124551303e-04f, +2.050885756e-02f, +2.316466389e-02f, -1.661998956e-03f, -3.217822554e-02f, -3.302116624e-02f, +4.175083971e-03f, +4.408552023e-02f, +4.132722598e-02f, -7.455599217e-03f, -5.352298645e-02f, -4.595158665e-02f, +1.076557078e-02f, +5.803280438e-02f, +4.565266287e-02f, -1.316667454e-02f, -5.634918672e-02f, -4.056537951e-02f, +1.390945093e-02f, +4.891556668e-02f, +3.212498523e-02f, -1.277010236e-02f, -3.771576378e-02f, -2.247678342e-02f, +1.014982897e-02f, +2.549810488e-02f, +1.367198280e-02f, -6.882022052e-03f, -1.476940467e-02f, -7.026155510e-03f, +3.857371771e-03f, +7.022954081e-03f, +2.889308604e-03f, -1.671564710e-03f, -2.502607995e-03f, -8.386340443e-04f, +4.684523500e-04f, +5.041228121e-04f,
        -1.389600048e-05f, -4.642614253e-05f, -3.724249168e-05f, +4.291118337e-05f, +1.370277891e-04f, +1.211583726e-04f, -6.651145955e-05f, -3.002185076e-04f, -3.155290602e-04f, +3.609256965e-05f, +5.417036090e-04f, +6.951458607e-04f, +1.436002750e-04f, -8.382311887e-04f, -1.370418431e-03f, -6.613830285e-04f, +1.112006636e-03f, +2.579979786e-03f, +2.049639612e-03f, -1.042084238e-03f, -5.283987960e-03f, -7.945354762e-03f, -6.848161398e-03f, -2.080283344e-03f, +3.849346823e-03f, +7.644390604e-03f, +7.448603302e-03f, +3.990987763e-03f, -1.529305739e-04f, -2.500691732e-03f, -2.265368269e-03f, -5.075639558e-04f, +1.031583203e-03f, +1.312427929e-03f, +5.314504956e-04f, -3.902727112e-04f, -7.155332732e-04f, -3.955415343e-04f, +1.085753362e-04f, +3.488584262e-04f, +2.375944924e-04f, -7.191930005e-06f, -1.446545704e-04f, -1.133255133e-04f, -1.166131574e-05f, +4.764846214e-05f, +3.805991974e-05f, +3.922811791e-06f,
        -9.635371862e-06f, +7.008068125e-05f, +1.186657797e-04f, -9.867568066e-06f, -2.650563955e-04f, -3.132953637e-04f, +9.970380601e-05f, +6.601852187e-04f, +6.173766457e-04f, -3.146253892e-04f, -1.285009845e-03f, -9.917229840e-04f, +6.900603119e-04f, +2.089854939e-03f, +1.351604527e-03f, -1.211007247e-03f, -2.936850373e-03f, -1.593809598e-03f, +1.796733710e-03f, +3.632727262e-03f, +1.638724650e-03f, -2.315499119e-03f, -3.994873537e-03f, -1.466397133e-03f, +2.628401821e-03f, +3.922048391e-03f, +1.126983296e-03f, -2.644077995e-03f, -3.435562247e-03f, -7.194084680e-04f, +2.357423304e-03f, +2.670234486e-03f, +3.494730274e-04f, -1.852120081e-03f, -1.819852361e-03f, -8.927577200e-05f, +1.265420760e-03f, +1.064448760e-03f, -4.258191508e-05f, -7.333742859e-04f, -5.136111991e-04f, +7.375563930e-05f, +3.437090248e-04f, +1.882728830e-04f, -5.275210890e-05f, -1.170321815e-04f, -4.134623355e-05f, +2.204093044e-05f,
        /*  5, 6 (48) */
        -2.138362868e-04f, +2.699466730e-04f, +1.033780325e-03f, +1.109862058e-03f, -3.415688898e-04f, -2.637369552e-03f, -3.364985229e-03f, -4.438376820e-04f, +4.930171787e-03f, +7.789018652e-03f, +3.319473232e-03f, -7.308289635e-03f, -1.523423081e-02f, -1.024708129e-02f, +8.419153559e-03f, +2.687537056e-02f, +2.489926454e-02f, -5.528240104e-03f, -4.629905191e-02f, -5.885505491e-02f, -1.020958642e-02f, +9.823396566e-02f, +2.227367744e-01f, +3.002210142e-01f, +2.882928326e-01f, +1.935918595e-01f, +6.730066057e-02f, -2.880458000e-02f, -6.056954650e-02f, -3.709014737e-02f, +4.234731733e-03f, +2.813779957e-02f, +2.343903002e-02f, +3.005110776e-03f, -1.299760815e-02f, -1.414367498e-02f, -4.458255175e-03f, +5.204616567e-03f, +7.634467472e-03f, +3.585997048e-03f, -1.526556951e-03f, -3.479918858e-03f, -2.098374192e-03f, +1.627790300e-04f, +1.217558456e-03f, +8.609413644e-04f, +9.965884631e-05f, -2.487527171e-04f,
        +5.925269711e-04f, +2.042943039e-04f, -1.433860728e-03f, -2.648384424e-03f, -5.710846208e-04f, +4.566483066e-03f, +7.056266775e-03f, +9.761373983e-04f, -1.050088778e-02f, -1.427985166e-02f, -1.072554714e-03f, +1.951713457e-02f, +2.385472420e-02f, +4.278559834e-04f, -3.082662102e-02f, -3.423217348e-02f, +1.238233598e-03f, +4.249171064e-02f, +4.312395969e-02f, -3.822871955e-03f, -5.188426180e-02f, -4.826708576e-02f, +6.770697241e-03f, +5.656640725e-02f, +4.828106469e-02f, -9.244626154e-03f, -5.522220343e-02f, -4.320945751e-02f, +1.047388868e-02f, +4.819615821e-02f, +3.448240853e-02f, -1.009986787e-02f, -3.736629075e-02f, -2.432890350e-02f, +8.329976605e-03f, +2.540882911e-02f, +1.493740356e-02f, -5.817573292e-03f, -1.481198659e-02f, -7.759529796e-03f, +3.343760572e-03f, +7.096709720e-03f, +3.233017629e-03f, -1.483291827e-03f, -2.555360104e-03f, -9.556662258e-04f, +4.271061165e-04f, +5.261637426e-04f,
        -1.176534634e-05f, -4.503118166e-05f, -3.993777832e-05f, +3.639529768e-05f, +1.330502028e-04f, +1.273356352e-04f, -5.108105047e-05f, -2.891856649e-04f, -3.252904120e-04f, +5.333590443e-06f, +5.147456527e-04f, +7.050127996e-04f, +1.973589024e-04f, -7.793699012e-04f, -1.368646705e-03f, -7.453464948e-04f, +9.914363706e-04f, +2.531915604e-03f, +2.161485201e-03f, -7.908557901e-04f, -5.035142753e-03f, -7.875495044e-03f, -7.039098547e-03f, -2.447067529e-03f, +3.510123255e-03f, +7.517360200e-03f, +7.576604323e-03f, +4.257848572e-03f, +7.278250009e-05f, -2.432129444e-03f, -2.342336748e-03f, -6.278958467e-04f, +9.677741847e-04f, +1.333533885e-03f, +5.947779018e-04f, -3.456331944e-04f, -7.171328272e-04f, -4.267604542e-04f, +8.164810093e-05f, +3.452546102e-04f, +2.514642936e-04f, +6.757567778e-06f, -1.414238512e-04f, -1.187594373e-04f, -1.759838370e-05f, +4.617543122e-05f, +3.998113491e-05f, +5.765296115e-06f,
        -1.271898053e-05f, +6.436320670e-05f, +1.197342126e-04f, +4.066716365e-06f, -2.509168103e-04f, -3.233063110e-04f, +6.286608877e-05f, +6.350858861e-04f, +6.485364007e-04f, -2.411203233e-04f, -1.250435457e-03f, -1.059413327e-03f, +5.695620628e-04f, +2.052784506e-03f, +1.469409935e-03f, -1.042164199e-03f, -2.908694961e-03f, -1.767276576e-03f, +1.590289783e-03f, +3.625606667e-03f, +1.860743862e-03f, -2.092951993e-03f, -4.016694866e-03f, -1.716865348e-03f, +2.416213044e-03f, +3.972784618e-03f, +1.377579891e-03f, -2.465715883e-03f, -3.506725792e-03f, -9.418137984e-04f, +2.226668070e-03f, +2.747940555e-03f, +5.235804775e-04f, -1.770402507e-03f, -1.889991623e-03f, -2.079521297e-04f, +1.223893792e-03f, +1.117457274e-03f, +2.614790518e-05f, -7.181486913e-04f, -5.467209090e-04f, +4.149500913e-05f, +3.414770032e-04f, +2.046323028e-04f, -4.171754544e-05f, -1.186821501e-04f, -4.704766528e-05f, +2.016071959e-05f,
        /*  5, 7 (48) */
        -2.256016332e-04f, +2.249154914e-04f, +9.938425466e-04f, +1.146257356e-03f, -2.085186870e-04f, -2.510033917e-03f, -3.416066279e-03f, -7.330233469e-04f, +4.604881375e-03f, +7.794352242e-03f, +3.834218885e-03f, -6.603276835e-03f, -1.503687191e-02f, -1.102645119e-02f, +7.050506854e-03f, +2.613002407e-02f, +2.589070091e-02f, -2.996324500e-03f, -4.413756671e-02f, -5.964591070e-02f, -1.524472918e-02f, +9.035847061e-02f, +2.156976758e-01f, +2.977739466e-01f, +2.918029559e-01f, +2.011092197e-01f, +7.487726489e-02f, -2.454673142e-02f, -6.049676400e-02f, -3.952227682e-02f, +1.892394985e-03f, +2.750990372e-02f, +2.440680421e-02f, +4.338644661e-03f, -1.240283025e-02f, -1.448930817e-02f, -5.175388002e-03f, +4.777856113e-03f, +7.716115573e-03f, +3.931251658e-03f, -1.275092657e-03f, -3.473161290e-03f, -2.239798043e-03f, +4.401959277e-05f, +1.199960073e-03f, +9.071167956e-04f, +1.396399812e-04f, -2.429874210e-04f,
        +5.798079906e-04f, +2.686575106e-04f, -1.314126515e-03f, -2.644317708e-03f, -8.220014310e-04f, +4.243176755e-03f, +7.119132864e-03f, +1.611223284e-03f, -9.852351375e-03f, -1.452097198e-02f, -2.322990171e-03f, +1.845772125e-02f, +2.442428626e-02f, +2.480640490e-03f, -2.935721108e-02f, -3.527433768e-02f, -1.670461363e-03f, +4.072443406e-02f, +4.471424948e-02f, -1.972652877e-04f, -5.002351794e-02f, -5.036003776e-02f, +2.754002374e-03f, +5.484954190e-02f, +5.069727773e-02f, -5.271841536e-03f, -5.384462353e-02f, -4.567517339e-02f, +6.967162887e-03f, +4.725434442e-02f, +3.670907660e-02f, -7.351927317e-03f, -3.684271028e-02f, -2.609930601e-02f, +6.439984982e-03f, +2.520087698e-02f, +1.616129735e-02f, -4.700116019e-03f, -1.478583868e-02f, -8.477678487e-03f, +2.797039663e-03f, +7.138204729e-03f, +3.574494632e-03f, -1.278659524e-03f, -2.597077649e-03f, -1.074348376e-03f, +3.800584512e-04f, +5.463244622e-04f,
        -9.694247817e-06f, -4.348195976e-05f, -4.232376407e-05f, +2.998809673e-05f, +1.286567263e-04f, +1.327706987e-04f, -3.594321318e-05f, -2.773338142e-04f, -3.334902885e-04f, -2.460629603e-05f, +4.865068398e-04f, +7.119338031e-04f, +2.490469033e-04f, -7.189985418e-04f, -1.361809822e-03f, -8.245130117e-04f, +8.702644658e-04f, +2.476023961e-03f, +2.262536517e-03f, -5.451942925e-04f, -4.780674772e-03f, -7.790488041e-03f, -7.214474091e-03f, -2.808184507e-03f, +3.162806250e-03f, +7.373982052e-03f, +7.690717676e-03f, +4.521327475e-03f, +3.056590003e-04f, -2.352753376e-03f, -2.412695524e-03f, -7.489383407e-04f, +8.987068488e-04f, +1.350052371e-03f, +6.573805153e-04f, -2.985168311e-04f, -7.159550299e-04f, -4.571303882e-04f, +5.363037253e-05f, +3.401394283e-04f, +2.647354962e-04f, +2.115179771e-05f, -1.374651753e-04f, -1.238815535e-04f, -2.371462048e-05f, +4.440198691e-05f, +4.179355039e-05f, +7.691540014e-06f,
        -1.550161284e-05f, +5.859264138e-05f, +1.200704223e-04f, +1.733830566e-05f, -2.360610272e-04f, -3.313190975e-04f, +2.695325785e-05f, +6.076707952e-04f, +6.757332781e-04f, -1.683161561e-04f, -1.210779515e-03f, -1.120776721e-03f, +4.486587473e-04f, +2.006870463e-03f, +1.578730122e-03f, -8.707557173e-04f, -2.867590910e-03f, -1.931011420e-03f, +1.378300460e-03f, +3.602076150e-03f, +2.073196738e-03f, -1.861710401e-03f, -4.020258295e-03f, -1.959395137e-03f, +2.192869030e-03f, +4.005585615e-03f, +1.622875376e-03f, -2.275147812e-03f, -3.562352025e-03f, -1.161794479e-03f, +2.084346041e-03f, +2.813875044e-03f, +6.976168748e-04f, -1.679174953e-03f, -1.952474029e-03f, -3.279319705e-04f, +1.175647175e-03f, +1.166346332e-03f, +9.655054157e-05f, -6.989396102e-04f, -5.781455835e-04f, +7.881392525e-06f, +3.373630248e-04f, +2.205970658e-04f, -2.990175319e-05f, -1.197077173e-04f, -5.280829914e-05f, +1.798191556e-05f,
        /*  5, 8 (48) */
        -2.352958810e-04f, +1.814335316e-04f, +9.515187825e-04f, +1.176245452e-03f, -7.986196071e-05f, -2.377263219e-03f, -3.452009492e-03f, -1.010357161e-03f, +4.271391087e-03f, +7.769745946e-03f, +4.320725725e-03f, -5.891343032e-03f, -1.478782500e-02f, -1.174544974e-02f, +5.688697032e-03f, +2.530551106e-02f, +2.676096538e-02f, -5.203005390e-04f, -4.187503019e-02f, -6.019110499e-02f, -2.002540395e-02f, +8.256798257e-02f, +2.084832017e-01f, +2.949657621e-01f, +2.949657621e-01f, +2.084832017e-01f, +8.256798257e-02f, -2.002540395e-02f, -6.019110499e-02f, -4.187503019e-02f, -5.203005390e-04f, +2.676096538e-02f, +2.530551106e-02f, +5.688697032e-03f, -1.174544974e-02f, -1.478782500e-02f, -5.891343032e-03f, +4.320725725e-03f, +7.769745946e-03f, +4.271391087e-03f, -1.010357161e-03f, -3.452009492e-03f, -2.377263219e-03f, -7.986196071e-05f, +1.176245452e-03f, +9.515187825e-04f, +1.814335316e-04f, -2.352958810e-04f,
        +5.643063777e-04f, +3.272501520e-04f, -1.194056093e-03f, -2.626979402e-03f, -1.058062458e-03f, +3.911857657e-03f, +7.146086122e-03f, +2.218894080e-03f, -9.176618097e-03f, -1.468928814e-02f, -3.533769686e-03f, +1.733694452e-02f, +2.487294501e-02f, +4.487510953e-03f, -2.777848096e-02f, -3.614509340e-02f, -4.538052273e-03f, +3.879342264e-02f, +4.609254994e-02f, +3.404810862e-03f, -4.795032120e-02f, -5.222174816e-02f, -1.266255920e-03f, +5.289014676e-02f, +5.289014676e-02f, -1.266255920e-03f, -5.222174816e-02f, -4.795032120e-02f, +3.404810862e-03f, +4.609254994e-02f, +3.879342264e-02f, -4.538052273e-03f, -3.614509340e-02f, -2.777848096e-02f, +4.487510953e-03f, +2.487294501e-02f, +1.733694452e-02f, -3.533769686e-03f, -1.468928814e-02f, -9.176618097e-03f, +2.218894080e-03f, +7.146086122e-03f, +3.911857657e-03f, -1.058062458e-03f, -2.626979402e-03f, -1.194056093e-03f, +3.272501520e-04f, +5.643063777e-04f,
        -7.691540014e-06f, -4.179355039e-05f, -4.440198691e-05f, +2.371462048e-05f, +1.238815535e-04f, +1.374651753e-04f, -2.115179771e-05f, -2.647354962e-04f, -3.401394283e-04f, -5.363037253e-05f, +4.571303882e-04f, +7.159550299e-04f, +2.985168311e-04f, -6.573805153e-04f, -1.350052371e-03f, -8.987068488e-04f, +7.489383407e-04f, +2.412695524e-03f, +2.352753376e-03f, -3.056590003e-04f, -4.521327475e-03f, -7.690717676e-03f, -7.373982052e-03f, -3.162806250e-03f, +2.808184507e-03f, +7.214474091e-03f, +7.790488041e-03f, +4.780674772e-03f, +5.451942925e-04f, -2.262536517e-03f, -2.476023961e-03f, -8.702644658e-04f, +8.245130117e-04f, +1.361809822e-03f, +7.189985418e-04f, -2.490469033e-04f, -7.119338031e-04f, -4.865068398e-04f, +2.460629603e-05f, +3.334902885e-04f, +2.773338142e-04f, +3.594321318e-05f, -1.327706987e-04f, -1.286567263e-04f, -2.998809673e-05f, +4.232376407e-05f, +4.348195976e-05f, +9.694247817e-06f,
        -1.798191556e-05f, +5.280829914e-05f, +1.197077173e-04f, +2.990175319e-05f, -2.205970658e-04f, -3.373630248e-04f, -7.881392525e-06f, +5.781455835e-04f, +6.989396102e-04f, -9.655054157e-05f, -1.166346332e-03f, -1.175647175e-03f, +3.279319705e-04f, +1.952474029e-03f, +1.679174953e-03f, -6.976168748e-04f, -2.813875044e-03f, -2.084346041e-03f, +1.161794479e-03f, +3.562352025e-03f, +2.275147812e-03f, -1.622875376e-03f, -4.005585615e-03f, -2.192869030e-03f, +1.959395137e-03f, +4.020258295e-03f, +1.861710401e-03f, -2.073196738e-03f, -3.602076150e-03f, -1.378300460e-03f, +1.931011420e-03f, +2.867590910e-03f, +8.707557173e-04f, -1.578730122e-03f, -2.006870463e-03f, -4.486587473e-04f, +1.120776721e-03f, +1.210779515e-03f, +1.683161561e-04f, -6.757332781e-04f, -6.076707952e-04f, -2.695325785e-05f, +3.313190975e-04f, +2.360610272e-04f, -1.733830566e-05f, -1.200704223e-04f, -5.859264138e-05f, +1.550161284e-05f,
        /*  5, 9 (48) */
        -2.429874210e-04f, +1.396399812e-04f, +9.071167956e-04f, +1.199960073e-03f, +4.401959277e-05f, -2.239798043e-03f, -3.473161290e-03f, -1.275092657e-03f, +3.931251658e-03f, +7.716115573e-03f, +4.777856113e-03f, -5.175388002e-03f, -1.448930817e-02f, -1.240283025e-02f, +4.338644661e-03f, +2.440680421e-02f, +2.750990372e-02f, +1.892394985e-03f, -3.952227682e-02f, -6.049676400e-02f, -2.454673142e-02f, +7.487726489e-02f, +2.011092197e-01f, +2.918029559e-01f, +2.977739466e-01f, +2.156976758e-01f, +9.035847061e-02f, -1.524472918e-02f, -5.964591070e-02f, -4.413756671e-02f, -2.996324500e-03f, +2.589070091e-02f, +2.613002407e-02f, +7.050506854e-03f, -1.102645119e-02f, -1.503687191e-02f, -6.603276835e-03f, +3.834218885e-03f, +7.794352242e-03f, +4.604881375e-03f, -7.330233469e-04f, -3.416066279e-03f, -2.510033917e-03f, -2.085186870e-04f, +1.146257356e-03f, +9.938425466e-04f, +2.249154914e-04f, -2.256016332e-04f,
        +5.463244622e-04f, +3.800584512e-04f, -1.074348376e-03f, -2.597077649e-03f, -1.278659524e-03f, +3.574494632e-03f, +7.138204729e-03f, +2.797039663e-03f, -8.477678487e-03f, -1.478583868e-02f, -4.700116019e-03f, +1.616129735e-02f, +2.520087698e-02f, +6.439984982e-03f, -2.609930601e-02f, -3.684271028e-02f, -7.351927317e-03f, +3.670907660e-02f, +4.725434442e-02f, +6.967162887e-03f, -4.567517339e-02f, -5.384462353e-02f, -5.271841536e-03f, +5.069727773e-02f, +5.484954190e-02f, +2.754002374e-03f, -5.036003776e-02f, -5.002351794e-02f, -1.972652877e-04f, +4.471424948e-02f, +4.072443406e-02f, -1.670461363e-03f, -3.527433768e-02f, -2.935721108e-02f, +2.480640490e-03f, +2.442428626e-02f, +1.845772125e-02f, -2.322990171e-03f, -1.452097198e-02f, -9.852351375e-03f, +1.611223284e-03f, +7.119132864e-03f, +4.243176755e-03f, -8.220014310e-04f, -2.644317708e-03f, -1.314126515e-03f, +2.686575106e-04f, +5.798079906e-04f,
        -5.765296115e-06f, -3.998113491e-05f, -4.617543122e-05f, +1.759838370e-05f, +1.187594373e-04f, +1.414238512e-04f, -6.757567778e-06f, -2.514642936e-04f, -3.452546102e-04f, -8.164810093e-05f, +4.267604542e-04f, +7.171328272e-04f, +3.456331944e-04f, -5.947779018e-04f, -1.333533885e-03f, -9.677741847e-04f, +6.278958467e-04f, +2.342336748e-03f, +2.432129444e-03f, -7.278250009e-05f, -4.257848572e-03f, -7.576604323e-03f, -7.517360200e-03f, -3.510123255e-03f, +2.447067529e-03f, +7.039098547e-03f, +7.875495044e-03f, +5.035142753e-03f, +7.908557901e-04f, -2.161485201e-03f, -2.531915604e-03f, -9.914363706e-04f, +7.453464948e-04f, +1.368646705e-03f, +7.793699012e-04f, -1.973589024e-04f, -7.050127996e-04f, -5.147456527e-04f, -5.333590443e-06f, +3.252904120e-04f, +2.891856649e-04f, +5.108105047e-05f, -1.273356352e-04f, -1.330502028e-04f, -3.639529768e-05f, +3.993777832e-05f, +4.503118166e-05f, +1.176534634e-05f,
        -2.016071959e-05f, +4.704766528e-05f, +1.186821501e-04f, +4.171754544e-05f, -2.046323028e-04f, -3.414770032e-04f, -4.149500913e-05f, +5.467209090e-04f, +7.181486913e-04f, -2.614790518e-05f, -1.117457274e-03f, -1.223893792e-03f, +2.079521297e-04f, +1.889991623e-03f, +1.770402507e-03f, -5.235804775e-04f, -2.747940555e-03f, -2.226668070e-03f, +9.418137984e-04f, +3.506725792e-03f, +2.465715883e-03f, -1.377579891e-03f, -3.972784618e-03f, -2.416213044e-03f, +1.716865348e-03f, +4.016694866e-03f, +2.092951993e-03f, -1.860743862e-03f, -3.625606667e-03f, -1.590289783e-03f, +1.767276576e-03f, +2.908694961e-03f, +1.042164199e-03f, -1.469409935e-03f, -2.052784506e-03f, -5.695620628e-04f, +1.059413327e-03f, +1.250435457e-03f, +2.411203233e-04f, -6.485364007e-04f, -6.350858861e-04f, -6.286608877e-05f, +3.233063110e-04f, +2.509168103e-04f, -4.066716365e-06f, -1.197342126e-04f, -6.436320670e-05f, +1.271898053e-05f,
        /*  5,10 (48) */
        -2.487527171e-04f, +9.965884631e-05f, +8.609413644e-04f, +1.217558456e-03f, +1.627790300e-04f, -2.098374192e-03f, -3.479918858e-03f, -1.526556951e-03f, +3.585997048e-03f, +7.634467472e-03f, +5.204616567e-03f, -4.458255175e-03f, -1.414367498e-02f, -1.299760815e-02f, +3.005110776e-03f, +2.343903002e-02f, +2.813779957e-02f, +4.234731733e-03f, -3.709014737e-02f, -6.056954650e-02f, -2.880458000e-02f, +6.730066057e-02f, +1.935918595e-01f, +2.882928326e-01f, +3.002210142e-01f, +2.227367744e-01f, +9.823396566e-02f, -1.020958642e-02f, -5.885505491e-02f, -4.629905191e-02f, -5.528240104e-03f, +2.489926454e-02f, +2.687537056e-02f, +8.419153559e-03f, -1.024708129e-02f, -1.523423081e-02f, -7.308289635e-03f, +3.319473232e-03f, +7.789018652e-03f, +4.930171787e-03f, -4.438376820e-04f, -3.364985229e-03f, -2.637369552e-03f, -3.415688898e-04f, +1.109862058e-03f, +1.033780325e-03f, +2.699466730e-04f, -2.138362868e-04f,
        +5.261637426e-04f, +4.271061165e-04f, -9.556662258e-04f, -2.555360104e-03f, -1.483291827e-03f, +3.233017629e-03f, +7.096709720e-03f, +3.343760572e-03f, -7.759529796e-03f, -1.481198659e-02f, -5.817573292e-03f, +1.493740356e-02f, +2.540882911e-02f, +8.329976605e-03f, -2.432890350e-02f, -3.736629075e-02f, -1.009986787e-02f, +3.448240853e-02f, +4.819615821e-02f, +1.047388868e-02f, -4.320945751e-02f, -5.522220343e-02f, -9.244626154e-03f, +4.828106469e-02f, +5.656640725e-02f, +6.770697241e-03f, -4.826708576e-02f, -5.188426180e-02f, -3.822871955e-03f, +4.312395969e-02f, +4.249171064e-02f, +1.238233598e-03f, -3.423217348e-02f, -3.082662102e-02f, +4.278559834e-04f, +2.385472420e-02f, +1.951713457e-02f, -1.072554714e-03f, -1.427985166e-02f, -1.050088778e-02f, +9.761373983e-04f, +7.056266775e-03f, +4.566483066e-03f, -5.710846208e-04f, -2.648384424e-03f, -1.433860728e-03f, +2.042943039e-04f, +5.925269711e-04f,
        -3.922811791e-06f, -3.805991974e-05f, -4.764846214e-05f, +1.166131574e-05f, +1.133255133e-04f, +1.446545704e-04f, +7.191930005e-06f, -2.375944924e-04f, -3.488584262e-04f, -1.085753362e-04f, +3.955415343e-04f, +7.155332732e-04f, +3.902727112e-04f, -5.314504956e-04f, -1.312427929e-03f, -1.031583203e-03f, +5.075639558e-04f, +2.265368269e-03f, +2.500691732e-03f, +1.529305739e-04f, -3.990987763e-03f, -7.448603302e-03f, -7.644390604e-03f, -3.849346823e-03f, +2.080283344e-03f, +6.848161398e-03f, +7.945354762e-03f, +5.283987960e-03f, +1.042084238e-03f, -2.049639612e-03f, -2.579979786e-03f, -1.112006636e-03f, +6.613830285e-04f, +1.370418431e-03f, +8.382311887e-04f, -1.436002750e-04f, -6.951458607e-04f, -5.417036090e-04f, -3.609256965e-05f, +3.155290602e-04f, +3.002185076e-04f, +6.651145955e-05f, -1.211583726e-04f, -1.370277891e-04f, -4.291118337e-05f, +3.724249168e-05f, +4.642614253e-05f, +1.389600048e-05f,
        -2.204093044e-05f, +4.134623355e-05f, +1.170321815e-04f, +5.275210890e-05f, -1.882728830e-04f, -3.437090248e-04f, -7.375563930e-05f, +5.136111991e-04f, +7.333742859e-04f, +4.258191508e-05f, -1.064448760e-03f, -1.265420760e-03f, +8.927577200e-05f, +1.819852361e-03f, +1.852120081e-03f, -3.494730274e-04f, -2.670234486e-03f, -2.357423304e-03f, +7.194084680e-04f, +3.435562247e-03f, +2.644077995e-03f, -1.126983296e-03f, -3.922048391e-03f, -2.628401821e-03f, +1.466397133e-03f, +3.994873537e-03f, +2.315499119e-03f, -1.638724650e-03f, -3.632727262e-03f, -1.796733710e-03f, +1.593809598e-03f, +2.936850373e-03f, +1.211007247e-03f, -1.351604527e-03f, -2.089854939e-03f, -6.900603119e-04f, +9.917229840e-04f, +1.285009845e-03f, +3.146253892e-04f, -6.173766457e-04f, -6.601852187e-04f, -9.970380601e-05f, +3.132953637e-04f, +2.650563955e-04f, +9.867568066e-06f, -1.186657797e-04f, -7.008068125e-05f, +9.635371862e-06f,
        /*  5,11 (48) */
        -2.526755289e-04f, +6.159892657e-05f, +8.132929023e-04f, +1.229219772e-03f, +2.761045433e-04f, -1.953719622e-03f, -3.472726928e-03f, -1.764151443e-03f, +3.237138622e-03f, +7.525892136e-03f, +5.600158101e-03f, -3.742721902e-03f, -1.375340227e-02f, -1.352905865e-02f, +1.692682847e-03f, +2.240744682e-02f, +2.864536352e-02f, +6.500100002e-03f, -3.458945564e-02f, -6.041661592e-02f, -3.279556776e-02f, +5.985205727e-02f, +1.859474689e-01f, +2.844434858e-01f, +3.023012975e-01f, +2.295849358e-01f, +1.061793204e-01f, -4.925598463e-03f, -5.781297067e-02f, -4.834869152e-02f, -8.108219891e-03f, +2.378725791e-02f, +2.753675359e-02f, +9.789571990e-03f, -9.408850104e-03f, -1.537783108e-02f, -8.003435496e-03f, +2.777769623e-03f, +7.752926082e-03f, +5.245700847e-03f, -1.436191744e-04f, -3.298473769e-03f, -2.758527925e-03f, -4.785966790e-04f, +1.066950874e-03f, +1.071022817e-03f, +3.163728156e-04f, -1.999402864e-04f,
        +5.041228121e-04f, +4.684523500e-04f, -8.386340443e-04f, -2.502607995e-03f, -1.671564710e-03f, +2.889308604e-03f, +7.022954081e-03f, +3.857371771e-03f, -7.026155510e-03f, -1.476940467e-02f, -6.882022052e-03f, +1.367198280e-02f, +2.549810488e-02f, +1.014982897e-02f, -2.247678342e-02f, -3.771576378e-02f, -1.277010236e-02f, +3.212498523e-02f, +4.891556668e-02f, +1.390945093e-02f, -4.056537951e-02f, -5.634918672e-02f, -1.316667454e-02f, +4.565266287e-02f, +5.803280438e-02f, +1.076557078e-02f, -4.595158665e-02f, -5.352298645e-02f, -7.455599217e-03f, +4.132722598e-02f, +4.408552023e-02f, +4.175083971e-03f, -3.302116624e-02f, -3.217822554e-02f, -1.661998956e-03f, +2.316466389e-02f, +2.050885756e-02f, +2.124551303e-04f, -1.396522627e-02f, -1.111826442e-02f, +3.159521796e-04f, +6.956562969e-03f, +4.879778429e-03f, -3.060282253e-04f, -2.638516856e-03f, -1.552526508e-03f, +1.342136227e-04f, +6.021623429e-04f,
        -2.170594329e-06f, -3.604505625e-05f, -4.882675536e-05f, +5.923709862e-06f, +1.076151274e-04f, +1.471681076e-04f, +2.065247933e-05f, -2.232007484e-04f, -3.509790369e-04f, -1.343345090e-04f, +3.636178797e-04f, +7.112316931e-04f, +4.323245107e-04f, -4.676548732e-04f, -1.286921163e-03f, -1.090024104e-03f, +3.883575103e-04f, +2.182223262e-03f, +2.558499992e-03f, +3.710047202e-04f, -3.721494474e-03f, -7.307203285e-03f, -7.754900054e-03f, -4.179711288e-03f, +1.708676149e-03f, +6.642011674e-03f, +7.999721116e-03f, +5.526473475e-03f, +1.298295096e-03f, -1.927074180e-03f, -2.619843217e-03f, -1.231519640e-03f, +5.728200767e-04f, +1.366996215e-03f, +8.953186611e-04f, -8.793011604e-05f, -6.822974410e-04f, -5.672390375e-04f, -6.756799030e-05f, +3.042017402e-04f, +3.103611873e-04f, +8.217765240e-05f, -1.142405788e-04f, -1.405560294e-04f, -4.950925812e-05f, +3.423787293e-05f, +4.765196158e-05f, +1.607663367e-05f,
        -2.362740894e-05f, +3.573736284e-05f, +1.147983424e-04f, +6.297778107e-05f, -1.716231578e-04f, -3.441156022e-04f, -1.045426173e-04f, +4.790334108e-04f, +7.446500392e-04f, +1.093449204e-04f, -1.007670250e-03f, -1.300167151e-03f, -2.755693267e-05f, +1.742515420e-03f, +1.924084932e-03f, -1.761107648e-04f, -2.581254969e-03f, -2.476117843e-03f, +4.956314854e-04f, +3.349297257e-03f, +2.809473102e-03f, -8.722656489e-04f, -3.853654204e-03f, -2.828463513e-03f, +1.209146098e-03f, +3.954858788e-03f, +2.528288105e-03f, -1.408124574e-03f, -3.623298329e-03f, -1.996621844e-03f, +1.411331538e-03f, +2.951778960e-03f, +1.376451619e-03f, -1.225750979e-03f, -2.117758113e-03f, -8.095634262e-04f, +9.179066134e-04f, +1.314217345e-03f, +3.884819314e-04f, -5.823030335e-04f, -6.827694336e-04f, -1.373032065e-04f, +3.012670491e-04f, +2.783717331e-04f, +2.441321203e-05f, -1.168348903e-04f, -7.570410508e-05f, +6.254422861e-06f,
        /*  5,12 (48) */
        -2.548461232e-04f, +2.555387032e-05f, +7.644661469e-04f, +1.235143482e-03f, +3.837196708e-04f, -1.806551514e-03f, -3.452074449e-03f, -1.987352192e-03f, +2.886159585e-03f, +7.391557627e-03f, +5.963775981e-03f, -3.031490209e-03f, -1.332107775e-02f, -1.399671352e-02f, +4.057616846e-04f, +2.131742272e-02f, +2.903372103e-02f, +8.682323264e-03f, -3.203095565e-02f, -6.004561120e-02f, -3.651706223e-02f, +5.254485398e-02f, +1.781925688e-01f, +2.802637745e-01f, +3.040099737e-01f, +2.362269475e-01f, +1.141790415e-01f, +6.008750117e-04f, -5.651467558e-02f, -5.027576570e-02f, -1.072806311e-02f, +2.255573827e-02f, +2.810957367e-02f, +1.115656820e-02f, -8.513531443e-03f, -1.546576120e-02f, -8.685732937e-03f, +2.210530586e-03f, +7.685358092e-03f, +5.549902587e-03f, +1.667420129e-04f, -3.216296117e-03f, -2.872768504e-03f, -6.191527084e-04f, +1.017441616e-03f, +1.105260690e-03f, +3.640247771e-04f, -1.838636527e-04f,
        +4.804954032e-04f, +5.041897128e-04f, -7.238357019e-04f, -2.439630214e-03f, -1.843187868e-03f, +2.545193002e-03f, +6.918411464e-03f, +4.336405182e-03f, -6.281505470e-03f, -1.466005975e-02f, -7.889692302e-03f, +1.237181565e-02f, +2.547054795e-02f, +1.189234439e-02f, -2.055269849e-02f, -3.789187454e-02f, -1.535135733e-02f, +2.964886738e-02f, +4.941119817e-02f, +1.725874818e-02f, -3.775590641e-02f, -5.722145237e-02f, -1.702032875e-02f, +4.282419935e-02f, +5.924195048e-02f, +1.472042957e-02f, -4.342329854e-02f, -5.493111103e-02f, -1.107889755e-02f, +3.933060414e-02f, +4.549685177e-02f, +7.126862931e-03f, -3.164471462e-02f, -3.340397652e-02f, -3.779757068e-03f, +2.235510046e-02f, +2.142676417e-02f, +1.526672475e-03f, -1.357674434e-02f, -1.170056746e-02f, -3.668172540e-04f, +6.819259763e-03f, +5.181045478e-03f, -2.765649223e-05f, -2.614103644e-03f, -1.669361398e-03f, +5.850951761e-05f, +6.084167658e-04f,
        -5.143564259e-07f, -3.395156363e-05f, -4.971722257e-05f, +4.041819234e-07f, +1.016636668e-04f, +1.489780312e-04f, +3.358328975e-05f, -2.083577617e-04f, -3.516499085e-04f, -1.588547770e-04f, +3.311329249e-04f, +7.043121473e-04f, +4.716902823e-04f, -4.036434917e-04f, -1.257212371e-03f, -1.143009043e-03f, +2.706780347e-04f, +2.093345793e-03f, +2.605646011e-03f, +5.809946439e-04f, -3.450115621e-03f, -7.152924603e-03f, -7.848760342e-03f, -4.500476158e-03f, +1.333103914e-03f, +6.421040627e-03f, +8.038287157e-03f, +5.761871190e-03f, +1.558880023e-03f, -1.793897867e-03f, -2.651151527e-03f, -1.349512981e-03f, +4.798765786e-04f, +1.358267912e-03f, +9.503692440e-04f, -3.051880904e-05f, -6.664430018e-04f, -5.912124291e-04f, -9.965154298e-05f, +2.913103906e-04f, +3.195442804e-04f, +9.802006855e-05f, -1.065872949e-04f, -1.436023867e-04f, -5.616164946e-05f, +3.092545234e-05f, +4.869403775e-05f, +1.829695311e-05f,
        -2.492684353e-05f, +3.025215391e-05f, +1.120228962e-04f, +7.237274682e-05f, -1.547851520e-04f, -3.427611766e-04f, -1.337468773e-04f, +4.432058116e-04f, +7.520287966e-04f, +1.738640922e-04f, -9.474821865e-04f, -1.328106554e-03f, -1.420245927e-04f, +1.658467293e-03f, +1.986104763e-03f, -4.295809510e-06f, -2.481548241e-03f, -2.582319918e-03f, +2.715336861e-04f, +3.248435191e-03f, +2.961205417e-03f, -6.146219611e-04f, -3.767961988e-03f, -3.015484417e-03f, +9.463004484e-04f, +3.896801234e-03f, +2.730297901e-03f, -1.169974583e-03f, -3.597258120e-03f, -2.188967178e-03f, +1.220613385e-03f, +2.953263164e-03f, +1.537670045e-03f, -1.092331806e-03f, -2.136210154e-03f, -9.274757092e-04f, +8.381997143e-04f, +1.337793488e-03f, +4.623303147e-04f, -5.433862206e-04f, -7.026467049e-04f, -1.754917821e-04f, +2.872126999e-04f, +2.907553767e-04f, +3.951307321e-05f, -1.142147107e-04f, -8.119107346e-05f, +2.582138931e-06f,
        /*  5,13 (48) */
        -2.553604797e-04f, -8.397693308e-06f, +7.147489243e-04f, +1.235547664e-03f, +4.853833376e-04f, -1.657573483e-03f, -3.418491159e-03f, -2.195709953e-03f, +2.534509676e-03f, +7.232702850e-03f, +6.294908906e-03f, -2.327178061e-03f, -1.284938747e-02f, -1.440035701e-02f, -8.514506861e-04f, +2.017441367e-02f, +2.930439907e-02f, +1.077566906e-02f, -2.942530964e-02f, -5.946461656e-02f, -3.996717785e-02f, +4.539192938e-02f, +1.703438085e-01f, +2.757632984e-01f, +3.053430776e-01f, +2.426479881e-01f, +1.222173287e-01f, +6.362746202e-03f, -5.495579556e-02f, -5.206966357e-02f, -1.337921463e-02f, +2.120622529e-02f, +2.858945025e-02f, +1.251483612e-02f, -7.563162199e-03f, -1.549628001e-02f, -9.352175938e-03f, +1.619318156e-03f, +7.585706549e-03f, +5.841212978e-03f, +4.862862933e-04f, -3.118276048e-03f, -2.979355799e-03f, -7.627550950e-04f, +9.612799669e-04f, +1.136186142e-03f, +4.127188149e-04f, -1.655666996e-04f,
        +4.555685597e-04f, +5.344418668e-04f, -6.118128057e-04f, -2.367257467e-03f, -1.997973020e-03f, +2.202431825e-03f, +6.784664586e-03f, +4.779610994e-03f, -5.529476674e-03f, -1.448619566e-02f, -8.837174489e-03f, +1.104370909e-02f, +2.532852336e-02f, +1.355081168e-02f, -1.856659372e-02f, -3.789617035e-02f, -1.783290557e-02f, +2.706654746e-02f, +4.968273185e-02f, +2.050718337e-02f, -3.479470099e-02f, -5.783607433e-02f, -2.078829074e-02f, +3.980871493e-02f, +6.018825092e-02f, +1.861723080e-02f, -4.069300064e-02f, -5.610108561e-02f, -1.467615567e-02f, +3.714163696e-02f, +4.671746516e-02f, +1.008012610e-02f, -3.010704457e-02f, -3.449630833e-02f, -5.915967223e-03f, +2.142762475e-02f, +2.226496388e-02f, +2.864465963e-03f, -1.311441403e-02f, -1.224395368e-02f, -1.069463959e-03f, +6.643767981e-03f, +5.468258178e-03f, +2.630988845e-04f, -2.574590571e-03f, -1.783576109e-03f, -2.268155584e-05f, +6.109989047e-04f,
        +1.040985477e-06f, -3.179425506e-05f, -5.032793323e-05f, -4.880361657e-06f, +9.550639630e-05f, +1.501005583e-04f, +4.594707460e-05f, -1.931399588e-04f, -3.509095356e-04f, -1.820721445e-04f, +2.982287329e-04f, +6.948668979e-04f, +5.082843731e-04f, -3.396638220e-04f, -1.223511463e-03f, -1.190471988e-03f, +1.549126151e-04f, +1.999189150e-03f, +2.642252808e-03f, +7.824862200e-04f, -3.177593401e-03f, -6.986317469e-03f, -7.925888400e-03f, -4.810928188e-03f, +9.544359400e-04f, +6.185680776e-03f, +8.060786240e-03f, +5.989464080e-03f, +1.823208447e-03f, -1.650254353e-03f, -2.673570778e-03f, -1.465518940e-03f, +3.827926075e-04f, +1.344138791e-03f, +1.003121559e-03f, +2.845238567e-05f, -6.475693674e-04f, -6.134870589e-04f, -1.322295665e-04f, +2.768635425e-04f, +3.277004432e-04f, +1.139765576e-04f, -9.820701606e-05f, -1.461354251e-04f, -6.283919623e-05f, +2.730837028e-05f, +4.953813809e-05f, +2.054597997e-05f,
        -2.594761520e-05f, +2.491934601e-05f, +1.087495025e-04f, +8.092094178e-05f, -1.378580622e-04f, -3.397174985e-04f, -1.612711930e-04f, +4.063467844e-04f, +7.555818373e-04f, +2.358804181e-04f, -8.842539332e-04f, -1.349246533e-03f, -2.536268595e-04f, +1.568218952e-03f, +2.038037948e-03f, +1.651875793e-04f, -2.371705449e-03f, -2.675661381e-03f, +4.815868112e-05f, +3.133546031e-03f, +3.098647428e-03f, -3.552563934e-04f, -3.665412401e-03f, -3.188613303e-03f, +6.790752835e-04f, +3.820937052e-03f, +2.920555137e-03f, -9.253463350e-04f, -3.554623527e-03f, -2.372811083e-03f, +1.022472742e-03f, +2.941147774e-03f, +1.693845381e-03f, -9.518731857e-04f, -2.144969009e-03f, -1.043198748e-03f, +7.528718237e-04f, +1.355496472e-03f, +5.358023371e-04f, -5.007186730e-04f, -7.196339889e-04f, -2.140883933e-04f, +2.711345839e-04f, +3.021011351e-04f, +5.510432378e-05f, -1.107821223e-04f, -8.649795645e-05f, -1.373031687e-06f,
        /*  5,14 (48) */
        -2.543194942e-04f, -4.019194836e-05f, +6.644209911e-04f, +1.230667302e-03f, +5.808897339e-04f, -1.507472925e-03f, -3.372544084e-03f, -2.388849912e-03f, +2.183600141e-03f, +7.050630706e-03f, +6.593137639e-03f, -1.632311164e-03f, -1.234110310e-02f, -1.474002084e-02f, -2.074962149e-03f, +1.898394169e-02f, +2.945931168e-02f, +1.277485821e-02f, -2.678305683e-02f, -5.868213034e-02f, -4.314477126e-02f, +3.840561191e-02f, +1.624179201e-01f, +2.709523702e-01f, +3.062975135e-01f, +2.488336689e-01f, +1.302781149e-01f, +1.235221028e-02f, -5.313258711e-02f, -5.371991792e-02f, -1.605278541e-02f, +1.974070635e-02f, +2.897224286e-02f, +1.385897491e-02f, -6.560040640e-03f, -1.546782762e-02f, -9.999745306e-03f, +1.005831098e-03f, +7.453476982e-03f, +6.118076521e-03f, +8.139867365e-04f, -3.004299491e-03f, -3.077562815e-03f, -9.088905201e-04f, +8.984407707e-04f, +1.163494512e-03f, +4.622569530e-04f, -1.450207196e-04f,
        +4.296209445e-04f, +5.593612128e-04f, -5.030633032e-04f, -2.286336525e-03f, -2.135831082e-03f, +1.862714327e-03f, +6.623393393e-03f, +5.185957778e-03f, -4.773894837e-03f, -1.425031524e-02f, -9.721428422e-03f, +9.694462559e-03f, +2.507489650e-02f, +1.511903063e-02f, -1.652855578e-02f, -3.773098278e-02f, -2.020461102e-02f, +2.439088608e-02f, +4.973089053e-02f, +2.364072940e-02f, -3.169605357e-02f, -5.819133072e-02f, -2.445370314e-02f, +3.662010163e-02f, +6.086732621e-02f, +2.243816785e-02f, -3.777244550e-02f, -5.702643195e-02f, -1.823077919e-02f, +3.476882588e-02f, +4.773993790e-02f, +1.302127387e-02f, -2.841319919e-02f, -3.544818151e-02f, -8.060936232e-03f, +2.038442601e-02f, +2.301783571e-02f, +4.219962434e-03f, -1.257861169e-02f, -1.274467235e-02f, -1.789097948e-03f, +6.429679587e-03f, +5.739392762e-03f, +5.652000196e-04f, -2.519486247e-03f, -1.894358231e-03f, -1.091795123e-04f, +6.096258730e-04f,
        +2.491308441e-06f, -2.958766734e-05f, -5.066803309e-05f, -9.914746689e-06f, +8.917830032e-05f, +1.505544017e-04f, +5.771011145e-05f, -1.776211840e-04f, -3.488011481e-04f, -2.039295517e-04f, +2.650454587e-04f, +6.829958540e-04f, +5.420338332e-04f, -2.759575187e-04f, -1.186038462e-03f, -1.232368496e-03f, +4.143284789e-05f, +1.900214177e-03f, +2.668473744e-03f, +9.750973470e-04f, -2.904663123e-03f, -6.807960120e-03f, -7.986246299e-03f, -5.110383358e-03f, +5.735503789e-04f, +5.936404813e-03f, +8.066993076e-03f, +6.208548452e-03f, +2.090629234e-03f, -1.496322096e-03f, -2.686788922e-03f, -1.579065996e-03f, +2.818289479e-04f, +1.324532268e-03f, +1.053316962e-03f, +8.879179446e-05f, -6.256750450e-04f, -6.339296100e-04f, -1.651833839e-04f, +2.608764580e-04f, +3.347647599e-04f, +1.299825782e-04f, -8.911175882e-05f, -1.481249922e-04f, -6.951154581e-05f, +2.339141928e-05f, +5.017048726e-05f, +2.281208434e-05f,
        -2.669965649e-05f, +1.976523353e-05f, +1.050228857e-04f, +8.861192429e-05f, -1.209377896e-04f, -3.350629867e-04f, -1.870303451e-04f, +3.686736639e-04f, +7.553980289e-04f, +2.951538003e-04f, -8.183617051e-04f, -1.363627926e-03f, -3.618865460e-04f, +1.472302924e-03f, +2.079793499e-03f, +3.315766088e-04f, -2.252359276e-03f, -2.755838884e-03f, -1.734621290e-04f, +3.005262188e-03f, +3.221242552e-03f, -9.537642794e-05f, -3.546524520e-03f, -3.347065450e-03f, +4.087067610e-04f, +3.727586997e-03f, +3.098138979e-03f, -6.753471971e-04f, -3.495490471e-03f, -2.547228180e-03f, +8.177702581e-04f, +2.915341338e-03f, +1.844174763e-03f, -8.049429437e-04f, -2.143836296e-03f, -1.156134388e-03f, +6.622257906e-04f, +1.367108885e-03f, +6.085229571e-04f, -4.544147255e-04f, -7.335582551e-04f, -2.529040111e-04f, +2.530462502e-04f, +3.123047380e-04f, +7.111861119e-05f, -1.065180250e-04f, -9.158013602e-05f, -5.600138690e-06f,
        /*  5,15 (48) */
        -2.518281858e-04f, -6.977961571e-05f, +6.137529580e-04f, +1.220752556e-03f, +6.700680342e-04f, -1.356918523e-03f, -3.314833973e-03f, -2.566471096e-03f, +1.834798993e-03f, +6.846701154e-03f, +6.858183098e-03f, -9.493153096e-04f, -1.179906927e-02f, -1.501597835e-02f, -3.261000612e-03f, +1.775157319e-02f, +2.950074453e-02f, +1.467507238e-02f, -2.411458308e-02f, -5.770703299e-02f, -4.604943438e-02f, +3.159765179e-02f, +1.544316738e-01f, +2.658419868e-01f, +3.068710639e-01f, +2.547700737e-01f, +1.383451080e-01f, +1.856075873e-02f, -5.104195788e-02f, -5.521624002e-02f, -1.873957433e-02f, +1.816164035e-02f, +2.925407180e-02f, +1.518350718e-02f, -5.506723678e-03f, -1.537903583e-02f, -1.062542035e-02f, +3.719014876e-04f, +7.288293598e-03f, +6.378952979e-03f, +1.148751496e-03f, -2.874316912e-03f, -3.166674574e-03f, -1.057015512e-03f, +8.289292249e-04f, +1.186885931e-03f, +5.124274402e-04f, -1.222086353e-04f,
        +4.029212880e-04f, +5.791264463e-04f, -3.980404175e-04f, -2.197724601e-03f, -2.256768871e-03f, +1.527651340e-03f, +6.436363048e-03f, +5.554631442e-03f, -4.018496808e-03f, -1.395516144e-02f, -1.053979013e-02f, +8.330834633e-03f, +2.471300995e-02f, +1.659133356e-02f, -1.444876228e-02f, -3.739940617e-02f, -2.245697029e-02f, +2.163504720e-02f, +4.955742841e-02f, +2.664599159e-02f, -2.847481101e-02f, -5.828670715e-02f, -2.800022766e-02f, +3.327303618e-02f, +6.127603297e-02f, +2.616575485e-02f, -3.467430652e-02f, -5.770177914e-02f, -2.172626967e-02f, +3.222159770e-02f, +4.855770816e-02f, +1.593661521e-02f, -2.656902443e-02f, -3.625312446e-02f, -1.020477253e-02f, +1.922829162e-02f, +2.368006150e-02f, +5.587071319e-03f, -1.197008873e-02f, -1.319908707e-02f, -2.522656203e-03f, +6.176775576e-03f, +5.992439012e-03f, +8.775047576e-04f, -2.448367636e-03f, -2.000876256e-03f, -2.007596483e-04f, +6.040257344e-04f,
        +3.833276021e-06f, -2.734599447e-05f, -5.074766006e-05f, -1.468554497e-05f, +8.271393049e-05f, +1.503606098e-04f, +6.884228518e-05f, -1.618744025e-04f, -3.453724072e-04f, -2.243769326e-04f, +2.317208331e-04f, +6.688059981e-04f, +5.728784120e-04f, -2.127596292e-04f, -1.145022466e-03f, -1.268675429e-03f, -6.940613874e-05f, +1.796887600e-03f, +2.684491539e-03f, +1.158478686e-03f, -2.632051071e-03f, -6.618456882e-03f, -8.029841120e-03f, -5.398188759e-03f, +1.913317227e-04f, +5.673724385e-03f, +8.056724670e-03f, +6.418436176e-03f, +2.360472425e-03f, -1.332314287e-03f, -2.690517210e-03f, -1.689680367e-03f, +1.772665892e-04f, +1.299390585e-03f, +1.100700600e-03f, +1.502978448e-04f, -6.007705035e-04f, -6.524107990e-04f, -1.983896676e-04f, +2.433712429e-04f, +3.406750891e-04f, +1.459714138e-04f, -7.931711402e-05f, -1.495424008e-04f, -7.614726015e-05f, +1.918107920e-05f, +5.057785772e-05f, +2.508302509e-05f,
        -2.719430556e-05f, +1.481360237e-05f, +1.008885095e-04f, +9.544071803e-05f, -1.041165060e-04f, -3.288820696e-04f, -2.109512166e-04f, +3.304016101e-04f, +7.515829083e-04f, +3.514638438e-04f, -7.501865082e-04f, -1.371323979e-03f, -4.663515915e-04f, +1.371270310e-03f, +2.111330779e-03f, +4.941334060e-04f, -2.124180390e-03f, -2.822614710e-03f, -3.923144403e-04f, +2.864275019e-03f, +3.328507442e-03f, +1.638129533e-04f, -3.411893142e-03f, -3.490126337e-03f, +1.364461560e-04f, +3.617154996e-03f, +3.262185724e-03f, -4.211150561e-04f, -3.420033908e-03f, -2.711331088e-03f, +6.074058072e-04f, +2.875817282e-03f, +1.987873747e-03f, -6.521483036e-04f, -2.132658970e-03f, -1.265687754e-03f, +5.665968633e-04f, +1.372439335e-03f, +6.801120963e-04f, -4.046105230e-04f, -7.442576965e-04f, -2.917425243e-04f, +2.329728192e-04f, +3.212645130e-04f, +8.748225870e-05f, -1.014076270e-04f, -9.639225967e-05f, -1.008568569e-05f,
        /*  6, 0 (48) */
        +4.968144385e-04f, +2.658533900e-04f, -8.962168723e-04f, -1.608103413e-03f, -7.788642489e-06f, +2.979420144e-03f, +3.156687553e-03f, -1.777487314e-03f, -6.981373376e-03f, -4.200072704e-03f, +6.679001343e-03f, +1.302046751e-02f, +2.733865881e-03f, -1.674345458e-02f, -2.042237500e-02f, +4.850187710e-03f, +3.528439247e-02f, +2.773502242e-02f, -2.703828769e-02f, -7.382778902e-02f, -3.314369929e-02f, +1.149897119e-01f, +2.902267079e-01f, +3.684748747e-01f, +2.902267079e-01f, +1.149897119e-01f, -3.314369929e-02f, -7.382778902e-02f, -2.703828769e-02f, +2.773502242e-02f, +3.528439247e-02f, +4.850187710e-03f, -2.042237500e-02f, -1.674345458e-02f, +2.733865881e-03f, +1.302046751e-02f, +6.679001343e-03f, -4.200072704e-03f, -6.981373376e-03f, -1.777487314e-03f, +3.156687553e-03f, +2.979420144e-03f, -7.788642489e-06f, -1.608103413e-03f, -8.962168723e-04f, +2.658533900e-04f, +4.968144385e-04f, +1.277320727e-04f,
        -4.968144385e-04f, -7.842817921e-04f, +8.994291019e-04f, +2.915640051e-03f, +8.438649895e-04f, -5.098406932e-03f, -6.009425829e-03f, +3.886651395e-03f, +1.308708603e-02f, +4.180565853e-03f, -1.651382305e-02f, -1.845487053e-02f, +9.460496445e-03f, +3.171517895e-02f, +1.017220246e-02f, -3.304107863e-02f, -3.524088677e-02f, +1.560130303e-02f, +5.143354543e-02f, +1.625027633e-02f, -4.622585189e-02f, -4.721341238e-02f, +1.858986948e-02f, +6.004110985e-02f, +1.858986948e-02f, -4.721341238e-02f, -4.622585189e-02f, +1.625027633e-02f, +5.143354543e-02f, +1.560130303e-02f, -3.524088677e-02f, -3.304107863e-02f, +1.017220246e-02f, +3.171517895e-02f, +9.460496445e-03f, -1.845487053e-02f, -1.651382305e-02f, +4.180565853e-03f, +1.308708603e-02f, +3.886651395e-03f, -6.009425829e-03f, -5.098406932e-03f, +8.438649895e-04f, +2.915640051e-03f, +8.994291019e-04f, -7.842817921e-04f, -6.202569526e-04f, -1.277320727e-04f,
        -1.499733940e-05f, +4.581440195e-05f, +8.222654775e-05f, -1.133499855e-05f, -1.717221122e-04f, -1.536557052e-04f, +1.457711105e-04f, +4.035826075e-04f, +1.612392801e-04f, -4.817224287e-04f, -7.200285364e-04f, +3.417364024e-05f, +1.115389910e-03f, +1.031958370e-03f, -6.472422812e-04f, -2.165140336e-03f, -1.186136915e-03f, +2.083111403e-03f, +4.043645375e-03f, +1.059561482e-03f, -5.997321120e-03f, -1.131891039e-02f, -9.290879382e-03f, -3.277778787e-04f, +8.888315096e-03f, +1.144173426e-02f, +6.454643929e-03f, -6.964563701e-04f, -4.022753705e-03f, -2.292177099e-03f, +1.025727110e-03f, +2.193586529e-03f, +7.745420228e-04f, -9.663083127e-04f, -1.158510680e-03f, -1.065268205e-04f, +7.025179806e-04f, +5.184656751e-04f, -1.270869112e-04f, -4.062105010e-04f, -1.685272076e-04f, +1.421089314e-04f, +1.785214599e-04f, +2.140257552e-05f, -8.075517306e-05f, -5.014084945e-05f, +1.253239210e-05f, +2.336102954e-05f,
        +1.499733940e-05f, -3.604833932e-05f, -1.540456612e-04f, -4.913805713e-05f, +2.946836819e-04f, +3.408706404e-04f, -2.734518864e-04f, -8.054712459e-04f, -1.611983499e-04f, +1.144424426e-03f, +1.076495704e-03f, -8.825186526e-04f, -2.120794780e-03f, -2.820117937e-04f, +2.572434168e-03f, +2.088618093e-03f, -1.773533212e-03f, -3.658041246e-03f, -3.037498356e-04f, +3.951088380e-03f, +2.828652722e-03f, -2.493092796e-03f, -4.507857853e-03f, -1.857454068e-04f, +4.399660011e-03f, +2.793451027e-03f, -2.554869886e-03f, -4.076700728e-03f, -1.409849475e-05f, +3.595489982e-03f, +2.013737730e-03f, -1.908679696e-03f, -2.674543436e-03f, +8.678704201e-05f, +2.100891351e-03f, +1.018351270e-03f, -9.962403305e-04f, -1.200978750e-03f, +8.125534378e-05f, +8.058829803e-04f, +3.226831859e-04f, -3.204820592e-04f, -3.135467573e-04f, +3.155727048e-05f, +1.567596241e-04f, +4.438067365e-05f, -4.015609728e-05f, -2.336102954e-05f,
        /*  6, 1 (48) */
        +4.818170991e-04f, +3.116677919e-04f, -8.139903245e-04f, -1.619438411e-03f, -1.795107547e-04f, +2.825764439e-03f, +3.302458664e-03f, -1.373904706e-03f, -6.820134096e-03f, -4.681795133e-03f, +5.958972806e-03f, +1.305464115e-02f, +3.849255791e-03f, -1.571149621e-02f, -2.106961728e-02f, +2.685047373e-03f, +3.409825556e-02f, +2.981813382e-02f, -2.299464232e-02f, -7.276822754e-02f, -3.914102041e-02f, +1.036708015e-01f, +2.809358285e-01f, +3.681470969e-01f, +2.991150230e-01f, +1.264314461e-01f, -2.668905536e-02f, -7.452424539e-02f, -3.106104140e-02f, +2.544284532e-02f, +3.631011958e-02f, +7.043774239e-03f, -1.964783298e-02f, -1.770976289e-02f, +1.575355201e-03f, +1.291394069e-02f, +7.381519323e-03f, -3.681607029e-03f, -7.108460287e-03f, -2.183697815e-03f, +2.988160346e-03f, +3.121529075e-03f, +1.707328174e-04f, -1.586700837e-03f, -9.769720453e-04f, +2.157125405e-04f, +5.093468306e-04f, +1.510931022e-04f,
        -4.818170991e-04f, -8.203301315e-04f, +7.453834406e-04f, +2.866501994e-03f, +1.138548671e-03f, -4.757536292e-03f, -6.282877715e-03f, +3.081180149e-03f, +1.292588768e-02f, +5.324990279e-03f, -1.543732735e-02f, -1.933738918e-02f, +7.339701665e-03f, +3.143316715e-02f, +1.274463663e-02f, -3.095246054e-02f, -3.701441998e-02f, +1.194326179e-02f, +5.112979559e-02f, +2.020136471e-02f, -4.339719917e-02f, -4.970650518e-02f, +1.408201163e-02f, +5.985536445e-02f, +2.298952949e-02f, -4.441996135e-02f, -4.878072178e-02f, +1.217357560e-02f, +5.141944693e-02f, +1.919679302e-02f, -3.322714904e-02f, -3.494975833e-02f, +7.497659026e-03f, +3.180196599e-02f, +1.156138780e-02f, -1.743651926e-02f, -1.751006338e-02f, +2.979587103e-03f, +1.316834138e-02f, +4.692534375e-03f, -5.686742643e-03f, -5.418888992e-03f, +5.303182322e-04f, +2.947197322e-03f, +1.056188726e-03f, -7.399011185e-04f, -6.604130498e-04f, -1.510931022e-04f,
        -1.721194565e-05f, +4.140964876e-05f, +8.312660570e-05f, -1.607065380e-06f, -1.641797458e-04f, -1.639344914e-04f, +1.229214328e-04f, +3.987934951e-04f, +1.935382675e-04f, -4.433395733e-04f, -7.331792745e-04f, -3.655074561e-05f, +1.067342593e-03f, +1.090519334e-03f, -5.195893246e-04f, -2.126003711e-03f, -1.336275342e-03f, +1.869018664e-03f, +4.043550276e-03f, +1.404861238e-03f, -5.533201255e-03f, -1.116513206e-02f, -9.663991810e-03f, -9.822571399e-04f, +8.457448808e-03f, +1.153277082e-02f, +6.903336548e-03f, -3.165794289e-04f, -3.980359535e-03f, -2.495011615e-03f, +8.556247074e-04f, +2.210926428e-03f, +9.007918871e-04f, -8.937550365e-04f, -1.196345405e-03f, -1.801472872e-04f, +6.806320721e-04f, +5.533162464e-04f, -9.122424856e-05f, -4.065968808e-04f, -1.910524798e-04f, +1.293202336e-04f, +1.845085850e-04f, +3.175948924e-05f, -7.869717760e-05f, -5.435485258e-05f, +9.822433814e-06f, +2.420834805e-05f,
        +1.721194565e-05f, -2.797302899e-05f, -1.503786526e-04f, -6.554580609e-05f, +2.746236972e-04f, +3.582266926e-04f, -2.240947659e-04f, -7.998354702e-04f, -2.378849854e-04f, +1.081948821e-03f, +1.148058766e-03f, -7.438547548e-04f, -2.126892192e-03f, -4.722485472e-04f, +2.455585875e-03f, +2.253106908e-03f, -1.524831037e-03f, -3.697023187e-03f, -6.172201198e-04f, +3.801456149e-03f, +3.083415824e-03f, -2.178016822e-03f, -4.587581862e-03f, -5.560515546e-04f, +4.263636073e-03f, +3.077127272e-03f, -2.263733107e-03f, -4.177340741e-03f, -3.343157089e-04f, +3.509552640e-03f, +2.243798546e-03f, -1.714262142e-03f, -2.761034460e-03f, -1.122302159e-04f, +2.067058655e-03f, +1.150395214e-03f, -9.076298295e-04f, -1.251081896e-03f, -1.491478018e-06f, +8.009066393e-04f, +3.714402944e-04f, -2.970911118e-04f, -3.310245125e-04f, +1.288020430e-05f, +1.584475354e-04f, +5.291577035e-05f, -3.845865258e-05f, -2.420834805e-05f,
        /*  6, 2 (48) */
        +4.646051534e-04f, +3.530774407e-04f, -7.308637188e-04f, -1.621045477e-03f, -3.436905005e-04f, +2.661829947e-03f, +3.425380097e-03f, -9.751112112e-04f, -6.626595828e-03f, -5.125134706e-03f, +5.225793532e-03f, +1.301809040e-02f, +4.916598384e-03f, -1.462097687e-02f, -2.158920660e-02f, +5.590436624e-04f, +3.276198022e-02f, +3.168715249e-02f, -1.895109204e-02f, -7.136336630e-02f, -4.467422166e-02f, +9.250566943e-02f, +2.712718367e-01f, +3.671648397e-01f, +3.075724718e-01f, +1.379642170e-01f, -1.978571881e-02f, -7.484082482e-02f, -3.504140093e-02f, +2.294783371e-02f, +3.716574429e-02f, +9.254700667e-03f, -1.874704109e-02f, -1.860351792e-02f, +3.790097958e-04f, +1.273379340e-02f, +8.062151396e-03f, -3.128290783e-03f, -7.199684535e-03f, -2.590294696e-03f, +2.797107866e-03f, +3.250849309e-03f, +3.552414023e-04f, -1.554941348e-03f, -1.055669223e-03f, +1.613576880e-04f, +5.191692644e-04f, +1.753014503e-04f,
        -4.646051534e-04f, -8.483031605e-04f, +5.950047880e-04f, +2.800956188e-03f, +1.413172369e-03f, -4.399309599e-03f, -6.506972481e-03f, +2.281344679e-03f, +1.268800270e-02f, +6.406939100e-03f, -1.428926858e-02f, -2.008124393e-02f, +5.212809473e-03f, +3.096091860e-02f, +1.520022250e-02f, -2.869935363e-02f, -3.853925102e-02f, +8.246238601e-03f, +5.051257547e-02f, +2.400282086e-02f, -4.031378334e-02f, -5.188452200e-02f, +9.494429766e-03f, +5.929931289e-02f, +2.725316557e-02f, -4.134283408e-02f, -5.104445488e-02f, +7.996234859e-03f, +5.108513123e-02f, +2.270634566e-02f, -3.098335049e-02f, -3.666402047e-02f, +4.736624566e-03f, +3.168973577e-02f, +1.362844645e-02f, -1.628612404e-02f, -1.841769321e-02f, +1.728505206e-03f, +1.316684990e-02f, +5.493441015e-03f, -5.315302348e-03f, -5.715980103e-03f, +1.992937197e-04f, +2.960077526e-03f, +1.214636261e-03f, -6.869853482e-04f, -6.988717024e-04f, -1.753014503e-04f,
        -1.917294829e-05f, +3.695981836e-05f, +8.347375200e-05f, +7.734872448e-06f, -1.559657101e-04f, -1.729275679e-04f, +1.001118357e-04f, +3.919335456e-04f, +2.238551306e-04f, -4.035727706e-04f, -7.420094127e-04f, -1.053024563e-04f, +1.014746362e-03f, +1.141847450e-03f, -3.922656056e-04f, -2.076637988e-03f, -1.475628833e-03f, +1.651098036e-03f, +4.023065436e-03f, +1.731415080e-03f, -5.064117745e-03f, -1.098134138e-02f, -1.000661783e-02f, -1.633511224e-03f, +7.999541491e-03f, +1.159130080e-02f, +7.341573863e-03f, +7.894597345e-05f, -3.916032251e-03f, -2.690411489e-03f, +6.764722311e-04f, +2.216792834e-03f, +1.025284408e-03f, -8.145264851e-04f, -1.228555130e-03f, -2.546575136e-04f, +6.543796353e-04f, +5.860252003e-04f, -5.380827359e-05f, -4.046723017e-04f, -2.132068256e-04f, +1.153241184e-04f, +1.896169401e-04f, +4.235166595e-05f, -7.604058012e-05f, -5.842156927e-05f, +6.874909048e-06f, +2.490662972e-05f,
        +1.917294829e-05f, -2.020393344e-05f, -1.458354689e-04f, -8.071584242e-05f, +2.535564812e-04f, +3.725425543e-04f, -1.749498460e-04f, -7.891706437e-04f, -3.108967826e-04f, +1.014108723e-03f, +1.210657585e-03f, -6.033167163e-04f, -2.119395490e-03f, -6.563535789e-04f, +2.324961565e-03f, +2.401288390e-03f, -1.269314706e-03f, -3.712407093e-03f, -9.243468054e-04f, +3.628906158e-03f, +3.317623958e-03f, -1.850276583e-03f, -4.638369466e-03f, -9.228114822e-04f, +4.100614958e-03f, +3.342259702e-03f, -1.957028337e-03f, -4.252212819e-03f, -6.548620144e-04f, +3.400567182e-03f, +2.462118457e-03f, -1.506443431e-03f, -2.831118909e-03f, -3.137999908e-04f, +2.019264512e-03f, +1.277699413e-03f, -8.110657220e-04f, -1.294235224e-03f, -8.655777873e-05f, +7.904112298e-04f, +4.193667154e-04f, -2.707510300e-04f, -3.469313050e-04f, -6.804394093e-06f, +1.590410464e-04f, +6.159451063e-05f, -3.628430681e-05f, -2.490662972e-05f,
        /*  6, 3 (48) */
        +4.454322052e-04f, +3.900372591e-04f, -6.473899668e-04f, -1.613310604e-03f, -4.996562106e-04f, +2.488902380e-03f, +3.525491932e-03f, -5.831776656e-04f, -6.402740698e-03f, -5.528707477e-03f, +4.483784119e-03f, +1.291278795e-02f, +5.931344747e-03f, -1.347912942e-02f, -2.198147221e-02f, -1.517594326e-03f, +3.128635138e-02f, +3.333825052e-02f, -1.492802661e-02f, -6.963195122e-02f, -4.973833941e-02f, +8.152432805e-02f, +2.612652189e-01f, +3.655313285e-01f, +3.155720133e-01f, +1.495555178e-01f, -1.244414495e-02f, -7.476187885e-02f, -3.895743318e-02f, +2.025742222e-02f, +3.784221652e-02f, +1.147149350e-02f, -1.772175668e-02f, -1.941804441e-02f, -8.495453346e-04f, +1.247913589e-02f, +8.716531031e-03f, -2.542265583e-03f, -7.253492809e-03f, -2.994966997e-03f, +2.583901040e-03f, +3.366173427e-03f, +5.448583425e-04f, -1.512589682e-03f, -1.131709803e-03f, +1.029361187e-04f, +5.260441735e-04f, +2.002080800e-04f,
        -4.454322052e-04f, -8.685070939e-04f, +4.491693191e-04f, +2.720240346e-03f, +1.666728850e-03f, -4.026767045e-03f, -6.681922327e-03f, +1.492174035e-03f, +1.237710592e-02f, +7.421047823e-03f, -1.307861100e-02f, -2.068456065e-02f, +3.093413984e-03f, +3.030456503e-02f, +1.752518407e-02f, -2.629806524e-02f, -3.980856572e-02f, +4.533831508e-03f, +4.958822867e-02f, +2.763172701e-02f, -3.699615939e-02f, -5.373479858e-02f, +4.856060301e-03f, +5.837650141e-02f, +3.135378052e-02f, -3.800057438e-02f, -5.300148322e-02f, +3.744022040e-03f, +5.043026921e-02f, +2.610691284e-02f, -2.852123204e-02f, -3.817046390e-02f, +1.905505657e-03f, +3.137593578e-02f, +1.564771096e-02f, -1.500842463e-02f, -1.922875894e-02f, +4.342699829e-04f, +1.308029212e-02f, +6.283852244e-03f, -4.895935633e-03f, -5.986731133e-03f, -1.476375854e-04f, +2.953273132e-03f, +1.373677308e-03f, -6.253908375e-04f, -7.351560092e-04f, -2.002080800e-04f,
        -2.087909205e-05f, +3.249703570e-05f, +8.328925833e-05f, +1.664857625e-05f, -1.471529901e-04f, -1.806254050e-04f, +7.747171356e-05f, +3.831024246e-04f, +2.520758300e-04f, -3.626787717e-04f, -7.465810587e-04f, -1.717567126e-04f, +9.579945182e-04f, +1.185840910e-03f, -2.659361064e-04f, -2.017546624e-03f, -1.603750184e-03f, +1.430538142e-03f, +3.982865045e-03f, +2.038378098e-03f, -4.591896607e-03f, -1.076858506e-02f, -1.031784186e-02f, -2.279404362e-03f, +7.515960575e-03f, +1.161672233e-02f, +7.767546564e-03f, +4.889102033e-04f, -3.829429834e-03f, -2.877179697e-03f, +4.889741247e-04f, +2.210870206e-03f, +1.147304853e-03f, -7.288923924e-04f, -1.254823802e-03f, -3.296656896e-04f, +6.237944064e-04f, +6.163492617e-04f, -1.500931522e-05f, -4.003788880e-04f, -2.348480499e-04f, +1.001635876e-04f, +1.937831454e-04f, +5.312148518e-05f, -7.277692874e-05f, -6.230567366e-05f, +3.699409719e-06f, +2.544119995e-05f,
        +2.087909205e-05f, -1.278501217e-05f, -1.404960552e-04f, -9.459557017e-05f, +2.316715232e-04f, +3.838323497e-04f, -1.263427196e-04f, -7.737004654e-04f, -3.798513683e-04f, +9.414833671e-04f, +1.264085916e-03f, -4.618549811e-04f, -2.098602257e-03f, -8.332417435e-04f, +2.181600471e-03f, +2.532421760e-03f, -1.008693674e-03f, -3.704317578e-03f, -1.223220544e-03f, +3.434682070e-03f, +3.529881935e-03f, -1.512001046e-03f, -4.659946008e-03f, -1.283686914e-03f, +3.911601571e-03f, +3.587101452e-03f, -1.636650437e-03f, -4.300684389e-03f, -9.736802695e-04f, +3.269025430e-03f, +2.667160254e-03f, -1.286403228e-03f, -2.884105909e-03f, -5.166454864e-04f, +1.957569632e-03f, +1.399325762e-03f, -7.070124832e-04f, -1.329975583e-03f, -1.734300341e-04f, +7.743006998e-04f, +4.661001774e-04f, -2.415385252e-04f, -3.610857945e-04f, -2.739598337e-05f, +1.584772530e-04f, +7.035318574e-05f, -3.361875474e-05f, -2.544119995e-05f,
        /*  6, 4 (48) */
        +4.245531131e-04f, +4.225342948e-04f, -5.641007085e-04f, -1.596662028e-03f, -6.468092006e-04f, +2.308276975e-03f, +3.602963646e-03f, -2.000752410e-04f, -6.150664868e-03f, -5.891386249e-03f, +3.737203061e-03f, +1.274103123e-02f, +6.889339265e-03f, -1.229328851e-02f, -2.224740832e-02f, -3.535140950e-03f, +2.968260120e-02f, +3.476878867e-02f, -1.094516156e-02f, -6.759357313e-02f, -5.433023602e-02f, +7.075574299e-02f, +2.509473770e-01f, +3.632519241e-01f, +3.230879739e-01f, +1.611722401e-01f, -4.676598387e-03f, -7.427296864e-02f, -4.278686302e-02f, +1.738024252e-02f, +3.833119065e-02f, +1.368236371e-02f, -1.657445183e-02f, -2.014693680e-02f, -2.104369136e-03f, +1.214947020e-02f, +9.340325437e-03f, -1.925916321e-03f, -7.268502124e-03f, -3.395345886e-03f, +2.349052990e-03f, +3.466337015e-03f, +7.386414879e-04f, -1.459468197e-03f, -1.204486732e-03f, +4.063044502e-05f, +5.297435832e-04f, +2.256492799e-04f,
        -4.245531131e-04f, -8.812921061e-04f, +3.086732639e-04f, +2.625644776e-03f, +1.898400373e-03f, -3.642934695e-03f, -6.808265047e-03f, +7.184735700e-04f, +1.199725455e-02f, +8.362531190e-03f, -1.181452508e-02f, -2.114641563e-02f, +9.948117267e-04f, +2.947132328e-02f, +1.970678454e-02f, -2.376564348e-02f, -4.081725940e-02f, +8.295139303e-04f, +4.836500812e-02f, +3.106640908e-02f, -3.346627745e-02f, -5.524679963e-02f, +1.961142931e-04f, +5.709281450e-02f, +3.526538209e-02f, -3.441347293e-02f, -5.463813366e-02f, -5.566623497e-04f, +4.945658894e-02f, +2.937593827e-02f, -2.585407178e-02f, -3.945686713e-02f, -9.786002519e-04f, +3.085929029e-02f, +1.760528059e-02f, -1.360909887e-02f, -1.993577142e-02f, -8.957056000e-04f, +1.290686209e-02f, +7.058152944e-03f, -4.429835456e-03f, -6.228269659e-03f, -5.087233799e-04f, +2.925877149e-03f, +1.532154561e-03f, -5.550376518e-04f, -7.687747640e-04f, -2.256492799e-04f,
        -2.233105653e-05f, +2.805214350e-05f, +8.259701733e-05f, +2.509604609e-05f, -1.378157037e-04f, -1.870264704e-04f, +5.512555411e-05f, +3.724082463e-04f, +2.781012933e-04f, -3.209139411e-04f, -7.469783072e-04f, -2.356091725e-04f, +8.974935422e-04f, +1.222439452e-03f, -1.412452366e-04f, -1.949271696e-03f, -1.720259320e-03f, +1.208511679e-03f, +3.923696023e-03f, +2.325003233e-03f, -4.118348902e-03f, -1.052800922e-02f, -1.059687046e-02f, -2.917822246e-03f, +7.008174801e-03f, +1.160855426e-02f, +8.179468934e-03f, +9.120213723e-04f, -3.720301977e-03f, -3.054131478e-03f, +2.938945811e-04f, +2.192897459e-03f, +1.266134869e-03f, -6.371637688e-04f, -1.274860546e-03f, -4.047675780e-04f, +5.889354579e-04f, +6.440523703e-04f, +2.498958862e-05f, -3.936710023e-04f, -2.558326624e-04f, +8.389013798e-05f, +1.969474946e-04f, +6.400803040e-05f, -6.890149093e-05f, -6.597158708e-05f, +3.076934037e-07f, +2.579800327e-05f,
        +2.233105653e-05f, -5.754885180e-06f, -1.344426504e-04f, -1.071443738e-04f, +2.091567200e-04f, +3.921311355e-04f, -7.858462338e-05f, -7.536749521e-04f, -4.444041660e-04f, +8.646699359e-04f, +1.308203188e-03f, -3.204070220e-04f, -2.064892248e-03f, -1.001892781e-03f, +2.026610082e-03f, +2.645886660e-03f, -7.446917873e-04f, -3.673030348e-03f, -1.512000316e-03f, +3.220160048e-03f, +3.718943121e-03f, -1.165380464e-03f, -4.652226236e-03f, -1.636378197e-03f, +3.697770427e-03f, +3.810032420e-03f, -1.304591153e-03f, -4.322291018e-03f, -1.288709475e-03f, +3.115571159e-03f, +2.857457604e-03f, -1.055416203e-03f, -2.919408038e-03f, -7.194611602e-04f, +1.882128834e-03f, +1.514355818e-03f, -5.959956855e-04f, -1.357879403e-03f, -2.615684034e-04f, +7.525156364e-04f, +5.112751002e-04f, -2.095540331e-04f, -3.733125000e-04f, -4.878252667e-05f, +1.566994726e-04f, +7.912381790e-05f, -3.045138455e-05f, -2.579800327e-05f,
        /*  6, 5 (48) */
        +4.022220566e-04f, +4.505864383e-04f, -4.815036912e-04f, -1.571565982e-03f, -7.846249043e-04f, +2.121250504e-03f, +3.658089200e-03f, +1.723330052e-04f, -5.872563574e-03f, -6.212300190e-03f, +2.990224753e-03f, +1.250542206e-02f, +7.786832807e-03f, -1.107084906e-02f, -2.238865355e-02f, -5.484412646e-03f, +2.796234188e-02f, +3.597730034e-02f, -7.021465538e-03f, -6.526856989e-02f, -5.844858492e-02f, +6.022773377e-02f, +2.403505066e-01f, +3.603341019e-01f, +3.300961487e-01f, +1.727807943e-01f, +3.502870548e-03f, -7.336094727e-02f, -4.650716500e-02f, +1.432611104e-02f, +3.862508523e-02f, +1.587526117e-02f, -1.530831696e-02f, -2.078410057e-02f, -3.379229683e-03f, +1.174470262e-02f, +9.929260895e-03f, -1.281863951e-03f, -7.243512536e-03f, -3.789016888e-03f, +2.093220328e-03f, +3.550227153e-03f, +9.355889825e-04f, -1.395460166e-03f, -1.273388223e-03f, -2.534114206e-05f, +5.300512766e-04f, +2.514472832e-04f,
        -4.022220566e-04f, -8.870469913e-04f, +1.742306135e-04f, +2.518500402e-03f, +2.107557093e-03f, -3.250803560e-03f, -6.886849670e-03f, -3.520138210e-05f, +1.155285038e-02f, +9.227201126e-03f, -1.050632189e-02f, -2.146682265e-02f, -1.070080522e-03f, +2.846943050e-02f, +2.173339462e-02f, -2.111975682e-02f, -4.156195119e-02f, -2.843516418e-03f, +4.685300781e-02f, +3.428656913e-02f, -2.974733433e-02f, -5.641218009e-02f, -4.456111943e-03f, +5.545643630e-02f, +3.896315252e-02f, -3.060344051e-02f, -5.594272481e-02f, -4.878953368e-03f, +4.816787947e-02f, +3.249150943e-02f, -2.299661418e-02f, -4.051228333e-02f, -3.898008290e-03f, +3.013982913e-02f, +1.948740943e-02f, -1.209474305e-02f, -2.053176710e-02f, -2.253585003e-03f, +1.264529368e-02f, +7.810668581e-03f, -3.918560355e-03f, -6.437823692e-03f, -8.820358799e-04f, +2.877094622e-03f, +1.688854033e-03f, -4.759138339e-04f, -7.992261485e-04f, -2.514472832e-04f,
        -2.353137234e-05f, +2.365453872e-05f, +8.142328803e-05f, +3.304361531e-05f, -1.280286063e-04f, -1.921369911e-04f, +3.319234646e-05f, +3.599667111e-04f, +3.018475856e-04f, -2.785328196e-04f, -7.433062355e-04f, -2.965771233e-04f, +8.336605869e-04f, +1.251623750e-03f, -1.881390406e-05f, -1.872390275e-03f, -1.824843738e-03f, +9.861701888e-04f, +3.846373323e-03f, +2.590643025e-03f, -3.645263310e-03f, -1.026085388e-02f, -1.084303494e-02f, -3.546680477e-03f, +6.477748644e-03f, +1.156643899e-02f, +8.575586598e-03f, +1.346909768e-03f, -3.588492821e-03f, -3.220100200e-03f, +9.205503488e-05f, +2.162670530e-03f, +1.381056230e-03f, -5.396921521e-04f, -1.288401865e-03f, -4.795484832e-04f, +5.498874868e-04f, +6.689072257e-04f, +6.599342113e-05f, -3.845158597e-04f, -2.760167067e-04f, +6.656370929e-05f, +1.990544543e-04f, +7.494736970e-05f, -6.441342463e-05f, -6.938371933e-05f, -3.286313808e-06f, +2.596374223e-05f,
        +2.353137234e-05f, +8.532242424e-07f, -1.277590202e-04f, -1.183334294e-04f, +1.861970369e-04f, +3.974939200e-04f, -3.197067399e-05f, -7.293679253e-04f, -5.042497876e-04f, +7.842790341e-04f, +1.342934023e-03f, -1.798912746e-04f, -2.018723382e-03f, -1.161357086e-03f, +1.861157813e-03f, +2.741185758e-03f, -4.790357470e-04f, -3.618968992e-03f, -1.788925009e-03f, +2.986838906e-03f, +3.883716922e-03f, -8.126518140e-04f, -4.615314533e-03f, -1.978639386e-03f, +3.460458135e-03f, +4.009570271e-03f, -9.629263980e-04f, -4.316740431e-03f, -1.597898392e-03f, +2.940997155e-03f, +3.031625551e-03f, -8.148446463e-04f, -2.936546701e-03f, -9.209211050e-04f, +1.793191621e-03f, +1.621897476e-03f, -4.785996723e-04f, -1.377566587e-03f, -3.504098630e-04f, +7.250347421e-04f, +5.545251612e-04f, -1.749217869e-04f, -3.834433674e-04f, -7.084089497e-05f, +1.536580014e-04f, +8.783453419e-05f, -2.677558788e-05f, -2.596374223e-05f,
        /*  6, 6 (48) */
        +3.786906842e-04f, +4.742409770e-04f, -4.000804031e-04f, -1.538522367e-03f, -9.126535106e-04f, +1.929113513e-03f, +3.691281546e-03f, +5.322997163e-04f, -5.570715989e-03f, -6.490833009e-03f, +2.246918518e-03f, +1.220884494e-02f, +8.620493394e-03f, -9.819225309e-03f, -2.240746746e-02f, -7.356802921e-03f, +2.613749814e-02f, +3.696347053e-02f, -3.175092215e-03f, -6.267792687e-02f, -6.209384823e-02f, +4.996687989e-02f, +2.295074716e-01f, +3.567874214e-01f, +3.365738973e-01f, +1.843472333e-01f, +1.207845715e-02f, -7.201403750e-02f, -5.009565782e-02f, +1.110601084e-02f, +3.871714026e-02f, +1.803793170e-02f, -1.392726073e-02f, -2.132379272e-02f, -4.667631548e-03f, +1.126515414e-02f, +1.047914838e-02f, -6.129567250e-04f, -7.177519115e-03f, -4.173532748e-03f, +1.817203621e-03f, +3.616790862e-03f, +1.134643437e-03f, -1.320512797e-03f, -1.337801647e-03f, -9.472486139e-05f, +5.267649628e-04f, +2.774110254e-04f,
        -3.786906842e-04f, -8.861937670e-04f, +4.647159335e-05f, +2.400166972e-03f, +2.293754130e-03f, -2.853309640e-03f, -6.918820344e-03f, -7.645693074e-04f, +1.104860059e-02f, +1.001148016e-02f, -9.163387871e-03f, -2.164671393e-02f, -3.088803903e-03f, +2.730807342e-02f, +2.359455243e-02f, -1.837857106e-02f, -4.204098693e-02f, -6.462485410e-03f, +4.506408280e-02f, +3.727340804e-02f, -2.586361741e-02f, -5.722483191e-02f, -9.071426476e-03f, +5.347779691e-02f, +4.242361066e-02f, -2.659387024e-02f, -5.690565121e-02f, -9.195693798e-03f, +4.656998107e-02f, +3.543250658e-02f, -1.996498863e-02f, -4.132712798e-02f, -6.834554991e-03f, +2.921890803e-02f, +2.128060105e-02f, -1.047284557e-02f, -2.101036678e-02f, -3.631151590e-03f, +1.229488382e-02f, +8.535703323e-03f, -3.364035194e-03f, -6.612745479e-03f, -1.265479247e-03f, +2.806253727e-03f, +1.842512035e-03f, -3.880792997e-04f, -8.260017364e-04f, -2.774110254e-04f,
        -2.448432686e-05f, +1.933202504e-05f, +7.979643430e-05f, +4.046201405e-05f, -1.178666074e-04f, -1.959706758e-04f, +1.178503831e-05f, +3.459002212e-04f, +3.232459887e-04f, -2.357867328e-04f, -7.356898046e-04f, -3.544005275e-04f, +7.669209652e-04f, +1.273414605e-03f, +1.007632299e-04f, -1.787510694e-03f, -1.917258590e-03f, +7.646390276e-04f, +3.751774984e-03f, +2.834750877e-03f, -3.174398890e-03f, -9.968447037e-03f, -1.105579341e-02f, -4.163932878e-03f, +5.926336299e-03f, +1.149014482e-02f, +8.954184214e-03f, +1.792132689e-03f, -3.433943292e-03f, -3.373943242e-03f, -1.156686781e-04f, +2.120044708e-03f, +1.491354662e-03f, -4.368686223e-04f, -1.295213721e-03f, -5.535853241e-04f, +5.067609651e-04f, +6.906968193e-04f, +1.077960061e-04f, -3.728940811e-04f, -2.952566154e-04f, +4.825257690e-05f, +2.000531521e-04f, +8.587286552e-05f, -5.931592914e-05f, -7.250671886e-05f, -7.066530373e-06f, +2.592601571e-05f,
        +2.448432686e-05f, +7.011497458e-06f, -1.205297111e-04f, -1.281454301e-04f, +1.629732380e-04f, +3.999945670e-04f, +1.322172512e-05f, -7.010743988e-04f, -5.591231130e-04f, +7.009301813e-04f, +1.368267321e-03f, -4.120131989e-05f, -1.960627270e-03f, -1.310760908e-03f, +1.686462397e-03f, +2.817946487e-03f, -2.134436808e-04f, -3.542700803e-03f, -2.052324376e-03f, +2.736329489e-03f, +4.023275194e-03f, -4.560839640e-04f, -4.549503884e-03f, -2.308292966e-03f, +3.201154799e-03f, +4.184380535e-03f, -6.138029170e-04f, -4.283915400e-03f, -1.899219181e-03f, +2.746241242e-03f, +3.188370580e-03f, -5.661303949e-04f, -2.935156821e-03f, -1.119687697e-03f, +1.691102124e-03f, +1.721091589e-03f, -3.554647702e-04f, -1.388704191e-03f, -4.393715858e-04f, +6.918760735e-04f, +5.954859446e-04f, -1.377897108e-04f, -3.913193363e-04f, -9.343737580e-05f, +1.493108471e-04f, +9.640999259e-05f, -2.258904820e-05f, -2.592601571e-05f,
        /*  6, 7 (48) */
        +3.542063574e-04f, +4.935730020e-04f, -3.202839688e-04f, -1.498060353e-03f, -1.030520118e-03f, +1.733142837e-03f, +3.703066585e-03f, +8.781999375e-04f, -5.247470000e-03f, -6.726619742e-03f, +1.511228713e-03f, +1.185444441e-02f, +9.387414359e-03f, -8.545810704e-03f, -2.230670423e-02f, -9.144313614e-03f, +2.422023955e-02f, +3.772810956e-02f, +5.766827686e-04f, -5.984317599e-02f, -6.526824712e-02f, +3.999843285e-02f, +2.184516782e-01f, +3.526234885e-01f, +3.425002336e-01f, +1.958373782e-01f, +2.103264136e-02f, -7.022190482e-02f, -5.352960111e-02f, +7.732067600e-03f, +3.860147158e-02f, +2.015797640e-02f, -1.243590607e-02f, -2.176066135e-02f, -5.962845269e-03f, +1.071156881e-02f, +1.098590935e-02f, +7.774009424e-05f, -7.069723108e-03f, -4.546426829e-03f, +1.521947006e-03f, +3.665043439e-03f, +1.334696589e-03f, -1.234639931e-03f, -1.397117576e-03f, -1.672315802e-04f, +5.196984324e-04f, +3.033370412e-04f,
        -3.542063574e-04f, -8.791822696e-04f, -7.405811770e-05f, +2.272021542e-03f, +2.456727368e-03f, -2.453315073e-03f, -6.905598619e-03f, -1.465643706e-03f, +1.048947748e-02f, +1.071241034e-02f, -7.795120550e-03f, -2.168791525e-02f, -5.049431174e-03f, +2.599731251e-02f, +2.528101483e-02f, -1.556062457e-02f, -4.225443061e-02f, -1.000518621e-02f, +4.301175842e-02f, +4.000973753e-02f, -2.184034221e-02f, -5.768091587e-02f, -1.362093036e-02f, +5.116950395e-02f, +4.562476546e-02f, -2.240948970e-02f, -5.751945412e-02f, -1.347960920e-02f, +4.467076189e-02f, +3.817874782e-02f, -1.677661805e-02f, -4.189325837e-02f, -9.769711812e-03f, +2.809922033e-02f, +2.297170317e-02f, -8.751753984e-03f, -2.136583155e-02f, -5.019855781e-03f, +1.185551223e-02f, +9.227579396e-03f, -2.768549250e-03f, -6.750535189e-03f, -1.656798584e-03f, +2.712816351e-03f, +1.991822882e-03f, -2.916693071e-04f, -8.485907846e-04f, -3.033370412e-04f,
        -2.519586065e-05f, +1.511068163e-05f, +7.774665823e-05f, +4.732640238e-05f, -1.074043009e-04f, -1.985483987e-04f, -8.989955332e-06f, +3.303369810e-04f, +3.422429896e-04f, -1.929224521e-04f, -7.242726748e-04f, -4.088429183e-04f, +6.977056506e-04f, +1.287871922e-03f, +2.169203000e-04f, -1.695268729e-03f, -1.997326444e-03f, +5.450125416e-04f, +3.640836977e-03f, +3.056881857e-03f, -2.707478034e-03f, -9.652198442e-03f, -1.123473239e-02f, -4.767579644e-03f, +5.355675280e-03f, +1.137956767e-02f, +9.313593052e-03f, +2.246179663e-03f, -3.256693025e-03f, -3.514547854e-03f, -3.283494830e-04f, +2.064936703e-03f, +1.596323724e-03f, -3.291225817e-04f, -1.295093514e-03f, -6.264488016e-04f, +4.596921448e-04f, +7.092159442e-04f, +1.501809141e-04f, -3.588001819e-04f, -3.134100873e-04f, +2.903319024e-05f, +1.998978496e-04f, +9.671551233e-05f, -5.361637368e-05f, -7.530573035e-05f, -1.101474876e-05f, +2.567345557e-05f,
        +2.519586065e-05f, +1.269748124e-05f, -1.128393307e-04f, -1.365742325e-04f, +1.396606961e-04f, +3.997245964e-04f, +5.673429862e-05f, -6.691078869e-04f, -6.088000572e-04f, +6.152473448e-04f, +1.384254920e-03f, +9.479965023e-05f, -1.891204326e-03f, -1.449310955e-03f, +1.503785046e-03f, +2.875921927e-03f, +5.038610774e-05f, -3.444931680e-03f, -2.300629299e-03f, +2.470343376e-03f, +4.136857541e-03f, -9.796268044e-05f, -4.455273590e-03f, -2.623244109e-03f, +2.921494382e-03f, +4.333285752e-03f, -2.594244262e-04f, -4.223875475e-03f, -2.190680989e-03f, +2.532381300e-03f, +3.326500154e-03f, -3.107861333e-04f, -2.914990835e-03f, -1.314420454e-03f, +1.576298379e-03f, +1.811118485e-03f, -2.272840501e-04f, -1.391009849e-03f, -5.278545486e-04f, +6.530980272e-04f, +6.337976565e-04f, -9.832913091e-05f, -3.967918929e-04f, -1.164282873e-04f, +1.436244281e-04f, +1.047718587e-04f, -1.789400372e-05f, -2.567345557e-05f,
        /*  6, 8 (48) */
        +3.290104967e-04f, +5.086836836e-04f, -2.425373106e-04f, -1.450733950e-03f, -1.137924419e-03f, +1.534594438e-03f, +3.694076629e-03f, +1.208536918e-03f, -4.905227010e-03f, -6.919542194e-03f, +7.869560385e-04f, +1.144560149e-02f, +1.008512001e-02f, -7.257938783e-03f, -2.208978393e-02f, -1.083958234e-02f, +2.222291311e-02f, +3.827312210e-02f, +4.217519746e-03f, -5.678629413e-02f, -6.797572515e-02f, +3.034623441e-02f, +2.072169458e-01f, +3.478559089e-01f, +3.478559089e-01f, +2.072169458e-01f, +3.034623441e-02f, -6.797572515e-02f, -5.678629413e-02f, +4.217519746e-03f, +3.827312210e-02f, +2.222291311e-02f, -1.083958234e-02f, -2.208978393e-02f, -7.257938783e-03f, +1.008512001e-02f, +1.144560149e-02f, +7.869560385e-04f, -6.919542194e-03f, -4.905227010e-03f, +1.208536918e-03f, +3.694076629e-03f, +1.534594438e-03f, -1.137924419e-03f, -1.450733950e-03f, -2.425373106e-04f, +5.086836836e-04f, +3.290104967e-04f,
        -3.290104967e-04f, -8.664847883e-04f, -1.868974484e-04f, +2.135447310e-03f, +2.596388064e-03f, -2.053590476e-03f, -6.848864320e-03f, -2.134751593e-03f, +9.880677424e-03f, +1.132765769e-02f, -6.410865630e-03f, -2.159311560e-02f, -6.940635500e-03f, +2.454800155e-02f, +2.678479988e-02f, -1.268470265e-02f, -4.220404451e-02f, -1.345011789e-02f, +4.071112912e-02f, +4.248008090e-02f, -1.770348467e-02f, -5.777887855e-02f, -1.807620395e-02f, +4.854625984e-02f, +4.854625984e-02f, -1.807620395e-02f, -5.777887855e-02f, -1.770348467e-02f, +4.248008090e-02f, +4.071112912e-02f, -1.345011789e-02f, -4.220404451e-02f, -1.268470265e-02f, +2.678479988e-02f, +2.454800155e-02f, -6.940635500e-03f, -2.159311560e-02f, -6.410865630e-03f, +1.132765769e-02f, +9.880677424e-03f, -2.134751593e-03f, -6.848864320e-03f, -2.053590476e-03f, +2.596388064e-03f, +2.135447310e-03f, -1.868974484e-04f, -8.664847883e-04f, -3.290104967e-04f,
        -2.567345557e-05f, +1.101474876e-05f, +7.530573035e-05f, +5.361637368e-05f, -9.671551233e-05f, -1.998978496e-04f, -2.903319024e-05f, +3.134100873e-04f, +3.588001819e-04f, -1.501809141e-04f, -7.092159442e-04f, -4.596921448e-04f, +6.264488016e-04f, +1.295093514e-03f, +3.291225817e-04f, -1.596323724e-03f, -2.064936703e-03f, +3.283494830e-04f, +3.514547854e-03f, +3.256693025e-03f, -2.246179663e-03f, -9.313593052e-03f, -1.137956767e-02f, -5.355675280e-03f, +4.767579644e-03f, +1.123473239e-02f, +9.652198442e-03f, +2.707478034e-03f, -3.056881857e-03f, -3.640836977e-03f, -5.450125416e-04f, +1.997326444e-03f, +1.695268729e-03f, -2.169203000e-04f, -1.287871922e-03f, -6.977056506e-04f, +4.088429183e-04f, +7.242726748e-04f, +1.929224521e-04f, -3.422429896e-04f, -3.303369810e-04f, +8.989955332e-06f, +1.985483987e-04f, +1.074043009e-04f, -4.732640238e-05f, -7.774665823e-05f, -1.511068163e-05f, +2.519586065e-05f,
        +2.567345557e-05f, +1.789400372e-05f, -1.047718587e-04f, -1.436244281e-04f, +1.164282873e-04f, +3.967918929e-04f, +9.832913091e-05f, -6.337976565e-04f, -6.530980272e-04f, +5.278545486e-04f, +1.391009849e-03f, +2.272840501e-04f, -1.811118485e-03f, -1.576298379e-03f, +1.314420454e-03f, +2.914990835e-03f, +3.107861333e-04f, -3.326500154e-03f, -2.532381300e-03f, +2.190680989e-03f, +4.223875475e-03f, +2.594244262e-04f, -4.333285752e-03f, -2.921494382e-03f, +2.623244109e-03f, +4.455273590e-03f, +9.796268044e-05f, -4.136857541e-03f, -2.470343376e-03f, +2.300629299e-03f, +3.444931680e-03f, -5.038610774e-05f, -2.875921927e-03f, -1.503785046e-03f, +1.449310955e-03f, +1.891204326e-03f, -9.479965023e-05f, -1.384254920e-03f, -6.152473448e-04f, +6.088000572e-04f, +6.691078869e-04f, -5.673429862e-05f, -3.997245964e-04f, -1.396606961e-04f, +1.365742325e-04f, +1.128393307e-04f, -1.269748124e-05f, -2.519586065e-05f,
        /*  6, 9 (48) */
        +3.033370412e-04f, +5.196984324e-04f, -1.672315802e-04f, -1.397117576e-03f, -1.234639931e-03f, +1.334696589e-03f, +3.665043439e-03f, +1.521947006e-03f, -4.546426829e-03f, -7.069723108e-03f, +7.774009424e-05f, +1.098590935e-02f, +1.071156881e-02f, -5.962845269e-03f, -2.176066135e-02f, -1.243590607e-02f, +2.015797640e-02f, +3.860147158e-02f, +7.732067600e-03f, -5.352960111e-02f, -7.022190482e-02f, +2.103264136e-02f, +1.958373782e-01f, +3.425002336e-01f, +3.526234885e-01f, +2.184516782e-01f, +3.999843285e-02f, -6.526824712e-02f, -5.984317599e-02f, +5.766827686e-04f, +3.772810956e-02f, +2.422023955e-02f, -9.144313614e-03f, -2.230670423e-02f, -8.545810704e-03f, +9.387414359e-03f, +1.185444441e-02f, +1.511228713e-03f, -6.726619742e-03f, -5.247470000e-03f, +8.781999375e-04f, +3.703066585e-03f, +1.733142837e-03f, -1.030520118e-03f, -1.498060353e-03f, -3.202839688e-04f, +4.935730020e-04f, +3.542063574e-04f,
        -3.033370412e-04f, -8.485907846e-04f, -2.916693071e-04f, +1.991822882e-03f, +2.712816351e-03f, -1.656798584e-03f, -6.750535189e-03f, -2.768549250e-03f, +9.227579396e-03f, +1.185551223e-02f, -5.019855781e-03f, -2.136583155e-02f, -8.751753984e-03f, +2.297170317e-02f, +2.809922033e-02f, -9.769711812e-03f, -4.189325837e-02f, -1.677661805e-02f, +3.817874782e-02f, +4.467076189e-02f, -1.347960920e-02f, -5.751945412e-02f, -2.240948970e-02f, +4.562476546e-02f, +5.116950395e-02f, -1.362093036e-02f, -5.768091587e-02f, -2.184034221e-02f, +4.000973753e-02f, +4.301175842e-02f, -1.000518621e-02f, -4.225443061e-02f, -1.556062457e-02f, +2.528101483e-02f, +2.599731251e-02f, -5.049431174e-03f, -2.168791525e-02f, -7.795120550e-03f, +1.071241034e-02f, +1.048947748e-02f, -1.465643706e-03f, -6.905598619e-03f, -2.453315073e-03f, +2.456727368e-03f, +2.272021542e-03f, -7.405811770e-05f, -8.791822696e-04f, -3.542063574e-04f,
        -2.592601571e-05f, +7.066530373e-06f, +7.250671886e-05f, +5.931592914e-05f, -8.587286552e-05f, -2.000531521e-04f, -4.825257690e-05f, +2.952566154e-04f, +3.728940811e-04f, -1.077960061e-04f, -6.906968193e-04f, -5.067609651e-04f, +5.535853241e-04f, +1.295213721e-03f, +4.368686223e-04f, -1.491354662e-03f, -2.120044708e-03f, +1.156686781e-04f, +3.373943242e-03f, +3.433943292e-03f, -1.792132689e-03f, -8.954184214e-03f, -1.149014482e-02f, -5.926336299e-03f, +4.163932878e-03f, +1.105579341e-02f, +9.968447037e-03f, +3.174398890e-03f, -2.834750877e-03f, -3.751774984e-03f, -7.646390276e-04f, +1.917258590e-03f, +1.787510694e-03f, -1.007632299e-04f, -1.273414605e-03f, -7.669209652e-04f, +3.544005275e-04f, +7.356898046e-04f, +2.357867328e-04f, -3.232459887e-04f, -3.459002212e-04f, -1.178503831e-05f, +1.959706758e-04f, +1.178666074e-04f, -4.046201405e-05f, -7.979643430e-05f, -1.933202504e-05f, +2.448432686e-05f,
        +2.592601571e-05f, +2.258904820e-05f, -9.640999259e-05f, -1.493108471e-04f, +9.343737580e-05f, +3.913193363e-04f, +1.377897108e-04f, -5.954859446e-04f, -6.918760735e-04f, +4.393715858e-04f, +1.388704191e-03f, +3.554647702e-04f, -1.721091589e-03f, -1.691102124e-03f, +1.119687697e-03f, +2.935156821e-03f, +5.661303949e-04f, -3.188370580e-03f, -2.746241242e-03f, +1.899219181e-03f, +4.283915400e-03f, +6.138029170e-04f, -4.184380535e-03f, -3.201154799e-03f, +2.308292966e-03f, +4.549503884e-03f, +4.560839640e-04f, -4.023275194e-03f, -2.736329489e-03f, +2.052324376e-03f, +3.542700803e-03f, +2.134436808e-04f, -2.817946487e-03f, -1.686462397e-03f, +1.310760908e-03f, +1.960627270e-03f, +4.120131989e-05f, -1.368267321e-03f, -7.009301813e-04f, +5.591231130e-04f, +7.010743988e-04f, -1.322172512e-05f, -3.999945670e-04f, -1.629732380e-04f, +1.281454301e-04f, +1.205297111e-04f, -7.011497458e-06f, -2.448432686e-05f,
        /*  6,10 (48) */
        +2.774110254e-04f, +5.267649628e-04f, -9.472486139e-05f, -1.337801647e-03f, -1.320512797e-03f, +1.134643437e-03f, +3.616790862e-03f, +1.817203621e-03f, -4.173532748e-03f, -7.177519115e-03f, -6.129567250e-04f, +1.047914838e-02f, +1.126515414e-02f, -4.667631548e-03f, -2.132379272e-02f, -1.392726073e-02f, +1.803793170e-02f, +3.871714026e-02f, +1.110601084e-02f, -5.009565782e-02f, -7.201403750e-02f, +1.207845715e-02f, +1.843472333e-01f, +3.365738973e-01f, +3.567874214e-01f, +2.295074716e-01f, +4.996687989e-02f, -6.209384823e-02f, -6.267792687e-02f, -3.175092215e-03f, +3.696347053e-02f, +2.613749814e-02f, -7.356802921e-03f, -2.240746746e-02f, -9.819225309e-03f, +8.620493394e-03f, +1.220884494e-02f, +2.246918518e-03f, -6.490833009e-03f, -5.570715989e-03f, +5.322997163e-04f, +3.691281546e-03f, +1.929113513e-03f, -9.126535106e-04f, -1.538522367e-03f, -4.000804031e-04f, +4.742409770e-04f, +3.786906842e-04f,
        -2.774110254e-04f, -8.260017364e-04f, -3.880792997e-04f, +1.842512035e-03f, +2.806253727e-03f, -1.265479247e-03f, -6.612745479e-03f, -3.364035194e-03f, +8.535703323e-03f, +1.229488382e-02f, -3.631151590e-03f, -2.101036678e-02f, -1.047284557e-02f, +2.128060105e-02f, +2.921890803e-02f, -6.834554991e-03f, -4.132712798e-02f, -1.996498863e-02f, +3.543250658e-02f, +4.656998107e-02f, -9.195693798e-03f, -5.690565121e-02f, -2.659387024e-02f, +4.242361066e-02f, +5.347779691e-02f, -9.071426476e-03f, -5.722483191e-02f, -2.586361741e-02f, +3.727340804e-02f, +4.506408280e-02f, -6.462485410e-03f, -4.204098693e-02f, -1.837857106e-02f, +2.359455243e-02f, +2.730807342e-02f, -3.088803903e-03f, -2.164671393e-02f, -9.163387871e-03f, +1.001148016e-02f, +1.104860059e-02f, -7.645693074e-04f, -6.918820344e-03f, -2.853309640e-03f, +2.293754130e-03f, +2.400166972e-03f, +4.647159335e-05f, -8.861937670e-04f, -3.786906842e-04f,
        -2.596374223e-05f, +3.286313808e-06f, +6.938371933e-05f, +6.441342463e-05f, -7.494736970e-05f, -1.990544543e-04f, -6.656370929e-05f, +2.760167067e-04f, +3.845158597e-04f, -6.599342113e-05f, -6.689072257e-04f, -5.498874868e-04f, +4.795484832e-04f, +1.288401865e-03f, +5.396921521e-04f, -1.381056230e-03f, -2.162670530e-03f, -9.205503488e-05f, +3.220100200e-03f, +3.588492821e-03f, -1.346909768e-03f, -8.575586598e-03f, -1.156643899e-02f, -6.477748644e-03f, +3.546680477e-03f, +1.084303494e-02f, +1.026085388e-02f, +3.645263310e-03f, -2.590643025e-03f, -3.846373323e-03f, -9.861701888e-04f, +1.824843738e-03f, +1.872390275e-03f, +1.881390406e-05f, -1.251623750e-03f, -8.336605869e-04f, +2.965771233e-04f, +7.433062355e-04f, +2.785328196e-04f, -3.018475856e-04f, -3.599667111e-04f, -3.319234646e-05f, +1.921369911e-04f, +1.280286063e-04f, -3.304361531e-05f, -8.142328803e-05f, -2.365453872e-05f, +2.353137234e-05f,
        +2.596374223e-05f, +2.677558788e-05f, -8.783453419e-05f, -1.536580014e-04f, +7.084089497e-05f, +3.834433674e-04f, +1.749217869e-04f, -5.545251612e-04f, -7.250347421e-04f, +3.504098630e-04f, +1.377566587e-03f, +4.785996723e-04f, -1.621897476e-03f, -1.793191621e-03f, +9.209211050e-04f, +2.936546701e-03f, +8.148446463e-04f, -3.031625551e-03f, -2.940997155e-03f, +1.597898392e-03f, +4.316740431e-03f, +9.629263980e-04f, -4.009570271e-03f, -3.460458135e-03f, +1.978639386e-03f, +4.615314533e-03f, +8.126518140e-04f, -3.883716922e-03f, -2.986838906e-03f, +1.788925009e-03f, +3.618968992e-03f, +4.790357470e-04f, -2.741185758e-03f, -1.861157813e-03f, +1.161357086e-03f, +2.018723382e-03f, +1.798912746e-04f, -1.342934023e-03f, -7.842790341e-04f, +5.042497876e-04f, +7.293679253e-04f, +3.197067399e-05f, -3.974939200e-04f, -1.861970369e-04f, +1.183334294e-04f, +1.277590202e-04f, -8.532242424e-07f, -2.353137234e-05f,
        /*  6,11 (48) */
        +2.514472832e-04f, +5.300512766e-04f, -2.534114206e-05f, -1.273388223e-03f, -1.395460166e-03f, +9.355889825e-04f, +3.550227153e-03f, +2.093220328e-03f, -3.789016888e-03f, -7.243512536e-03f, -1.281863951e-03f, +9.929260895e-03f, +1.174470262e-02f, -3.379229683e-03f, -2.078410057e-02f, -1.530831696e-02f, +1.587526117e-02f, +3.862508523e-02f, +1.432611104e-02f, -4.650716500e-02f, -7.336094727e-02f, +3.502870548e-03f, +1.727807943e-01f, +3.300961487e-01f, +3.603341019e-01f, +2.403505066e-01f, +6.022773377e-02f, -5.844858492e-02f, -6.526856989e-02f, -7.021465538e-03f, +3.597730034e-02f, +2.796234188e-02f, -5.484412646e-03f, -2.238865355e-02f, -1.107084906e-02f, +7.786832807e-03f, +1.250542206e-02f, +2.990224753e-03f, -6.212300190e-03f, -5.872563574e-03f, +1.723330052e-04f, +3.658089200e-03f, +2.121250504e-03f, -7.846249043e-04f, -1.571565982e-03f, -4.815036912e-04f, +4.505864383e-04f, +4.022220566e-04f,
        -2.514472832e-04f, -7.992261485e-04f, -4.759138339e-04f, +1.688854033e-03f, +2.877094622e-03f, -8.820358799e-04f, -6.437823692e-03f, -3.918560355e-03f, +7.810668581e-03f, +1.264529368e-02f, -2.253585003e-03f, -2.053176710e-02f, -1.209474305e-02f, +1.948740943e-02f, +3.013982913e-02f, -3.898008290e-03f, -4.051228333e-02f, -2.299661418e-02f, +3.249150943e-02f, +4.816787947e-02f, -4.878953368e-03f, -5.594272481e-02f, -3.060344051e-02f, +3.896315252e-02f, +5.545643630e-02f, -4.456111943e-03f, -5.641218009e-02f, -2.974733433e-02f, +3.428656913e-02f, +4.685300781e-02f, -2.843516418e-03f, -4.156195119e-02f, -2.111975682e-02f, +2.173339462e-02f, +2.846943050e-02f, -1.070080522e-03f, -2.146682265e-02f, -1.050632189e-02f, +9.227201126e-03f, +1.155285038e-02f, -3.520138210e-05f, -6.886849670e-03f, -3.250803560e-03f, +2.107557093e-03f, +2.518500402e-03f, +1.742306135e-04f, -8.870469913e-04f, -4.022220566e-04f,
        -2.579800327e-05f, -3.076934037e-07f, +6.597158708e-05f, +6.890149093e-05f, -6.400803040e-05f, -1.969474946e-04f, -8.389013798e-05f, +2.558326624e-04f, +3.936710023e-04f, -2.498958862e-05f, -6.440523703e-04f, -5.889354579e-04f, +4.047675780e-04f, +1.274860546e-03f, +6.371637688e-04f, -1.266134869e-03f, -2.192897459e-03f, -2.938945811e-04f, +3.054131478e-03f, +3.720301977e-03f, -9.120213723e-04f, -8.179468934e-03f, -1.160855426e-02f, -7.008174801e-03f, +2.917822246e-03f, +1.059687046e-02f, +1.052800922e-02f, +4.118348902e-03f, -2.325003233e-03f, -3.923696023e-03f, -1.208511679e-03f, +1.720259320e-03f, +1.949271696e-03f, +1.412452366e-04f, -1.222439452e-03f, -8.974935422e-04f, +2.356091725e-04f, +7.469783072e-04f, +3.209139411e-04f, -2.781012933e-04f, -3.724082463e-04f, -5.512555411e-05f, +1.870264704e-04f, +1.378157037e-04f, -2.509604609e-05f, -8.259701733e-05f, -2.805214350e-05f, +2.233105653e-05f,
        +2.579800327e-05f, +3.045138455e-05f, -7.912381790e-05f, -1.566994726e-04f, +4.878252667e-05f, +3.733125000e-04f, +2.095540331e-04f, -5.112751002e-04f, -7.525156364e-04f, +2.615684034e-04f, +1.357879403e-03f, +5.959956855e-04f, -1.514355818e-03f, -1.882128834e-03f, +7.194611602e-04f, +2.919408038e-03f, +1.055416203e-03f, -2.857457604e-03f, -3.115571159e-03f, +1.288709475e-03f, +4.322291018e-03f, +1.304591153e-03f, -3.810032420e-03f, -3.697770427e-03f, +1.636378197e-03f, +4.652226236e-03f, +1.165380464e-03f, -3.718943121e-03f, -3.220160048e-03f, +1.512000316e-03f, +3.673030348e-03f, +7.446917873e-04f, -2.645886660e-03f, -2.026610082e-03f, +1.001892781e-03f, +2.064892248e-03f, +3.204070220e-04f, -1.308203188e-03f, -8.646699359e-04f, +4.444041660e-04f, +7.536749521e-04f, +7.858462338e-05f, -3.921311355e-04f, -2.091567200e-04f, +1.071443738e-04f, +1.344426504e-04f, +5.754885180e-06f, -2.233105653e-05f,
        /*  6,12 (48) */
        +2.256492799e-04f, +5.297435832e-04f, +4.063044502e-05f, -1.204486732e-03f, -1.459468197e-03f, +7.386414879e-04f, +3.466337015e-03f, +2.349052990e-03f, -3.395345886e-03f, -7.268502124e-03f, -1.925916321e-03f, +9.340325437e-03f, +1.214947020e-02f, -2.104369136e-03f, -2.014693680e-02f, -1.657445183e-02f, +1.368236371e-02f, +3.833119065e-02f, +1.738024252e-02f, -4.278686302e-02f, -7.427296864e-02f, -4.676598387e-03f, +1.611722401e-01f, +3.230879739e-01f, +3.632519241e-01f, +2.509473770e-01f, +7.075574299e-02f, -5.433023602e-02f, -6.759357313e-02f, -1.094516156e-02f, +3.476878867e-02f, +2.968260120e-02f, -3.535140950e-03f, -2.224740832e-02f, -1.229328851e-02f, +6.889339265e-03f, +1.274103123e-02f, +3.737203061e-03f, -5.891386249e-03f, -6.150664868e-03f, -2.000752410e-04f, +3.602963646e-03f, +2.308276975e-03f, -6.468092006e-04f, -1.596662028e-03f, -5.641007085e-04f, +4.225342948e-04f, +4.245531131e-04f,
        -2.256492799e-04f, -7.687747640e-04f, -5.550376518e-04f, +1.532154561e-03f, +2.925877149e-03f, -5.087233799e-04f, -6.228269659e-03f, -4.429835456e-03f, +7.058152944e-03f, +1.290686209e-02f, -8.957056000e-04f, -1.993577142e-02f, -1.360909887e-02f, +1.760528059e-02f, +3.085929029e-02f, -9.786002519e-04f, -3.945686713e-02f, -2.585407178e-02f, +2.937593827e-02f, +4.945658894e-02f, -5.566623497e-04f, -5.463813366e-02f, -3.441347293e-02f, +3.526538209e-02f, +5.709281450e-02f, +1.961142931e-04f, -5.524679963e-02f, -3.346627745e-02f, +3.106640908e-02f, +4.836500812e-02f, +8.295139303e-04f, -4.081725940e-02f, -2.376564348e-02f, +1.970678454e-02f, +2.947132328e-02f, +9.948117267e-04f, -2.114641563e-02f, -1.181452508e-02f, +8.362531190e-03f, +1.199725455e-02f, +7.184735700e-04f, -6.808265047e-03f, -3.642934695e-03f, +1.898400373e-03f, +2.625644776e-03f, +3.086732639e-04f, -8.812921061e-04f, -4.245531131e-04f,
        -2.544119995e-05f, -3.699409719e-06f, +6.230567366e-05f, +7.277692874e-05f, -5.312148518e-05f, -1.937831454e-04f, -1.001635876e-04f, +2.348480499e-04f, +4.003788880e-04f, +1.500931522e-05f, -6.163492617e-04f, -6.237944064e-04f, +3.296656896e-04f, +1.254823802e-03f, +7.288923924e-04f, -1.147304853e-03f, -2.210870206e-03f, -4.889741247e-04f, +2.877179697e-03f, +3.829429834e-03f, -4.889102033e-04f, -7.767546564e-03f, -1.161672233e-02f, -7.515960575e-03f, +2.279404362e-03f, +1.031784186e-02f, +1.076858506e-02f, +4.591896607e-03f, -2.038378098e-03f, -3.982865045e-03f, -1.430538142e-03f, +1.603750184e-03f, +2.017546624e-03f, +2.659361064e-04f, -1.185840910e-03f, -9.579945182e-04f, +1.717567126e-04f, +7.465810587e-04f, +3.626787717e-04f, -2.520758300e-04f, -3.831024246e-04f, -7.747171356e-05f, +1.806254050e-04f, +1.471529901e-04f, -1.664857625e-05f, -8.328925833e-05f, -3.249703570e-05f, +2.087909205e-05f,
        +2.544119995e-05f, +3.361875474e-05f, -7.035318574e-05f, -1.584772530e-04f, +2.739598337e-05f, +3.610857945e-04f, +2.415385252e-04f, -4.661001774e-04f, -7.743006998e-04f, +1.734300341e-04f, +1.329975583e-03f, +7.070124832e-04f, -1.399325762e-03f, -1.957569632e-03f, +5.166454864e-04f, +2.884105909e-03f, +1.286403228e-03f, -2.667160254e-03f, -3.269025430e-03f, +9.736802695e-04f, +4.300684389e-03f, +1.636650437e-03f, -3.587101452e-03f, -3.911601571e-03f, +1.283686914e-03f, +4.659946008e-03f, +1.512001046e-03f, -3.529881935e-03f, -3.434682070e-03f, +1.223220544e-03f, +3.704317578e-03f, +1.008693674e-03f, -2.532421760e-03f, -2.181600471e-03f, +8.332417435e-04f, +2.098602257e-03f, +4.618549811e-04f, -1.264085916e-03f, -9.414833671e-04f, +3.798513683e-04f, +7.737004654e-04f, +1.263427196e-04f, -3.838323497e-04f, -2.316715232e-04f, +9.459557017e-05f, +1.404960552e-04f, +1.278501217e-05f, -2.087909205e-05f,
        /*  6,13 (48) */
        +2.002080800e-04f, +5.260441735e-04f, +1.029361187e-04f, -1.131709803e-03f, -1.512589682e-03f, +5.448583425e-04f, +3.366173427e-03f, +2.583901040e-03f, -2.994966997e-03f, -7.253492809e-03f, -2.542265583e-03f, +8.716531031e-03f, +1.247913589e-02f, -8.495453346e-04f, -1.941804441e-02f, -1.772175668e-02f, +1.147149350e-02f, +3.784221652e-02f, +2.025742222e-02f, -3.895743318e-02f, -7.476187885e-02f, -1.244414495e-02f, +1.495555178e-01f, +3.155720133e-01f, +3.655313285e-01f, +2.612652189e-01f, +8.152432805e-02f, -4.973833941e-02f, -6.963195122e-02f, -1.492802661e-02f, +3.333825052e-02f, +3.128635138e-02f, -1.517594326e-03f, -2.198147221e-02f, -1.347912942e-02f, +5.931344747e-03f, +1.291278795e-02f, +4.483784119e-03f, -5.528707477e-03f, -6.402740698e-03f, -5.831776656e-04f, +3.525491932e-03f, +2.488902380e-03f, -4.996562106e-04f, -1.613310604e-03f, -6.473899668e-04f, +3.900372591e-04f, +4.454322052e-04f,
        -2.002080800e-04f, -7.351560092e-04f, -6.253908375e-04f, +1.373677308e-03f, +2.953273132e-03f, -1.476375854e-04f, -5.986731133e-03f, -4.895935633e-03f, +6.283852244e-03f, +1.308029212e-02f, +4.342699829e-04f, -1.922875894e-02f, -1.500842463e-02f, +1.564771096e-02f, +3.137593578e-02f, +1.905505657e-03f, -3.817046390e-02f, -2.852123204e-02f, +2.610691284e-02f, +5.043026921e-02f, +3.744022040e-03f, -5.300148322e-02f, -3.800057438e-02f, +3.135378052e-02f, +5.837650141e-02f, +4.856060301e-03f, -5.373479858e-02f, -3.699615939e-02f, +2.763172701e-02f, +4.958822867e-02f, +4.533831508e-03f, -3.980856572e-02f, -2.629806524e-02f, +1.752518407e-02f, +3.030456503e-02f, +3.093413984e-03f, -2.068456065e-02f, -1.307861100e-02f, +7.421047823e-03f, +1.237710592e-02f, +1.492174035e-03f, -6.681922327e-03f, -4.026767045e-03f, +1.666728850e-03f, +2.720240346e-03f, +4.491693191e-04f, -8.685070939e-04f, -4.454322052e-04f,
        -2.490662972e-05f, -6.874909048e-06f, +5.842156927e-05f, +7.604058012e-05f, -4.235166595e-05f, -1.896169401e-04f, -1.153241184e-04f, +2.132068256e-04f, +4.046723017e-04f, +5.380827359e-05f, -5.860252003e-04f, -6.543796353e-04f, +2.546575136e-04f, +1.228555130e-03f, +8.145264851e-04f, -1.025284408e-03f, -2.216792834e-03f, -6.764722311e-04f, +2.690411489e-03f, +3.916032251e-03f, -7.894597345e-05f, -7.341573863e-03f, -1.159130080e-02f, -7.999541491e-03f, +1.633511224e-03f, +1.000661783e-02f, +1.098134138e-02f, +5.064117745e-03f, -1.731415080e-03f, -4.023065436e-03f, -1.651098036e-03f, +1.475628833e-03f, +2.076637988e-03f, +3.922656056e-04f, -1.141847450e-03f, -1.014746362e-03f, +1.053024563e-04f, +7.420094127e-04f, +4.035727706e-04f, -2.238551306e-04f, -3.919335456e-04f, -1.001118357e-04f, +1.729275679e-04f, +1.559657101e-04f, -7.734872448e-06f, -8.347375200e-05f, -3.695981836e-05f, +1.917294829e-05f,
        +2.490662972e-05f, +3.628430681e-05f, -6.159451063e-05f, -1.590410464e-04f, +6.804394093e-06f, +3.469313050e-04f, +2.707510300e-04f, -4.193667154e-04f, -7.904112298e-04f, +8.655777873e-05f, +1.294235224e-03f, +8.110657220e-04f, -1.277699413e-03f, -2.019264512e-03f, +3.137999908e-04f, +2.831118909e-03f, +1.506443431e-03f, -2.462118457e-03f, -3.400567182e-03f, +6.548620144e-04f, +4.252212819e-03f, +1.957028337e-03f, -3.342259702e-03f, -4.100614958e-03f, +9.228114822e-04f, +4.638369466e-03f, +1.850276583e-03f, -3.317623958e-03f, -3.628906158e-03f, +9.243468054e-04f, +3.712407093e-03f, +1.269314706e-03f, -2.401288390e-03f, -2.324961565e-03f, +6.563535789e-04f, +2.119395490e-03f, +6.033167163e-04f, -1.210657585e-03f, -1.014108723e-03f, +3.108967826e-04f, +7.891706437e-04f, +1.749498460e-04f, -3.725425543e-04f, -2.535564812e-04f, +8.071584242e-05f, +1.458354689e-04f, +2.020393344e-05f, -1.917294829e-05f,
        /*  6,14 (48) */
        +1.753014503e-04f, +5.191692644e-04f, +1.613576880e-04f, -1.055669223e-03f, -1.554941348e-03f, +3.552414023e-04f, +3.250849309e-03f, +2.797107866e-03f, -2.590294696e-03f, -7.199684535e-03f, -3.128290783e-03f, +8.062151396e-03f, +1.273379340e-02f, +3.790097958e-04f, -1.860351792e-02f, -1.874704109e-02f, +9.254700667e-03f, +3.716574429e-02f, +2.294783371e-02f, -3.504140093e-02f, -7.484082482e-02f, -1.978571881e-02f, +1.379642170e-01f, +3.075724718e-01f, +3.671648397e-01f, +2.712718367e-01f, +9.250566943e-02f, -4.467422166e-02f, -7.136336630e-02f, -1.895109204e-02f, +3.168715249e-02f, +3.276198022e-02f, +5.590436624e-04f, -2.158920660e-02f, -1.462097687e-02f, +4.916598384e-03f, +1.301809040e-02f, +5.225793532e-03f, -5.125134706e-03f, -6.626595828e-03f, -9.751112112e-04f, +3.425380097e-03f, +2.661829947e-03f, -3.436905005e-04f, -1.621045477e-03f, -7.308637188e-04f, +3.530774407e-04f, +4.646051534e-04f,
        -1.753014503e-04f, -6.988717024e-04f, -6.869853482e-04f, +1.214636261e-03f, +2.960077526e-03f, +1.992937197e-04f, -5.715980103e-03f, -5.315302348e-03f, +5.493441015e-03f, +1.316684990e-02f, +1.728505206e-03f, -1.841769321e-02f, -1.628612404e-02f, +1.362844645e-02f, +3.168973577e-02f, +4.736624566e-03f, -3.666402047e-02f, -3.098335049e-02f, +2.270634566e-02f, +5.108513123e-02f, +7.996234859e-03f, -5.104445488e-02f, -4.134283408e-02f, +2.725316557e-02f, +5.929931289e-02f, +9.494429766e-03f, -5.188452200e-02f, -4.031378334e-02f, +2.400282086e-02f, +5.051257547e-02f, +8.246238601e-03f, -3.853925102e-02f, -2.869935363e-02f, +1.520022250e-02f, +3.096091860e-02f, +5.212809473e-03f, -2.008124393e-02f, -1.428926858e-02f, +6.406939100e-03f, +1.268800270e-02f, +2.281344679e-03f, -6.506972481e-03f, -4.399309599e-03f, +1.413172369e-03f, +2.800956188e-03f, +5.950047880e-04f, -8.483031605e-04f, -4.646051534e-04f,
        -2.420834805e-05f, -9.822433814e-06f, +5.435485258e-05f, +7.869717760e-05f, -3.175948924e-05f, -1.845085850e-04f, -1.293202336e-04f, +1.910524798e-04f, +4.065968808e-04f, +9.122424856e-05f, -5.533162464e-04f, -6.806320721e-04f, +1.801472872e-04f, +1.196345405e-03f, +8.937550365e-04f, -9.007918871e-04f, -2.210926428e-03f, -8.556247074e-04f, +2.495011615e-03f, +3.980359535e-03f, +3.165794289e-04f, -6.903336548e-03f, -1.153277082e-02f, -8.457448808e-03f, +9.822571399e-04f, +9.663991810e-03f, +1.116513206e-02f, +5.533201255e-03f, -1.404861238e-03f, -4.043550276e-03f, -1.869018664e-03f, +1.336275342e-03f, +2.126003711e-03f, +5.195893246e-04f, -1.090519334e-03f, -1.067342593e-03f, +3.655074561e-05f, +7.331792745e-04f, +4.433395733e-04f, -1.935382675e-04f, -3.987934951e-04f, -1.229214328e-04f, +1.639344914e-04f, +1.641797458e-04f, +1.607065380e-06f, -8.312660570e-05f, -4.140964876e-05f, +1.721194565e-05f,
        +2.420834805e-05f, +3.845865258e-05f, -5.291577035e-05f, -1.584475354e-04f, -1.288020430e-05f, +3.310245125e-04f, +2.970911118e-04f, -3.714402944e-04f, -8.009066393e-04f, +1.491478018e-06f, +1.251081896e-03f, +9.076298295e-04f, -1.150395214e-03f, -2.067058655e-03f, +1.122302159e-04f, +2.761034460e-03f, +1.714262142e-03f, -2.243798546e-03f, -3.509552640e-03f, +3.343157089e-04f, +4.177340741e-03f, +2.263733107e-03f, -3.077127272e-03f, -4.263636073e-03f, +5.560515546e-04f, +4.587581862e-03f, +2.178016822e-03f, -3.083415824e-03f, -3.801456149e-03f, +6.172201198e-04f, +3.697023187e-03f, +1.524831037e-03f, -2.253106908e-03f, -2.455585875e-03f, +4.722485472e-04f, +2.126892192e-03f, +7.438547548e-04f, -1.148058766e-03f, -1.081948821e-03f, +2.378849854e-04f, +7.998354702e-04f, +2.240947659e-04f, -3.582266926e-04f, -2.746236972e-04f, +6.554580609e-05f, +1.503786526e-04f, +2.797302899e-05f, -1.721194565e-05f,
        /*  6,15 (48) */
        +1.510931022e-04f, +5.093468306e-04f, +2.157125405e-04f, -9.769720453e-04f, -1.586700837e-03f, +1.707328174e-04f, +3.121529075e-03f, +2.988160346e-03f, -2.183697815e-03f, -7.108460287e-03f, -3.681607029e-03f, +7.381519323e-03f, +1.291394069e-02f, +1.575355201e-03f, -1.770976289e-02f, -1.964783298e-02f, +7.043774239e-03f, +3.631011958e-02f, +2.544284532e-02f, -3.106104140e-02f, -7.452424539e-02f, -2.668905536e-02f, +1.264314461e-01f, +2.991150230e-01f, +3.681470969e-01f, +2.809358285e-01f, +1.036708015e-01f, -3.914102041e-02f, -7.276822754e-02f, -2.299464232e-02f, +2.981813382e-02f, +3.409825556e-02f, +2.685047373e-03f, -2.106961728e-02f, -1.571149621e-02f, +3.849255791e-03f, +1.305464115e-02f, +5.958972806e-03f, -4.681795133e-03f, -6.820134096e-03f, -1.373904706e-03f, +3.302458664e-03f, +2.825764439e-03f, -1.795107547e-04f, -1.619438411e-03f, -8.139903245e-04f, +3.116677919e-04f, +4.818170991e-04f,
        -1.510931022e-04f, -6.604130498e-04f, -7.399011185e-04f, +1.056188726e-03f, +2.947197322e-03f, +5.303182322e-04f, -5.418888992e-03f, -5.686742643e-03f, +4.692534375e-03f, +1.316834138e-02f, +2.979587103e-03f, -1.751006338e-02f, -1.743651926e-02f, +1.156138780e-02f, +3.180196599e-02f, +7.497659026e-03f, -3.494975833e-02f, -3.322714904e-02f, +1.919679302e-02f, +5.141944693e-02f, +1.217357560e-02f, -4.878072178e-02f, -4.441996135e-02f, +2.298952949e-02f, +5.985536445e-02f, +1.408201163e-02f, -4.970650518e-02f, -4.339719917e-02f, +2.020136471e-02f, +5.112979559e-02f, +1.194326179e-02f, -3.701441998e-02f, -3.095246054e-02f, +1.274463663e-02f, +3.143316715e-02f, +7.339701665e-03f, -1.933738918e-02f, -1.543732735e-02f, +5.324990279e-03f, +1.292588768e-02f, +3.081180149e-03f, -6.282877715e-03f, -4.757536292e-03f, +1.138548671e-03f, +2.866501994e-03f, +7.453834406e-04f, -8.203301315e-04f, -4.818170991e-04f,
        -2.336102954e-05f, -1.253239210e-05f, +5.014084945e-05f, +8.075517306e-05f, -2.140257552e-05f, -1.785214599e-04f, -1.421089314e-04f, +1.685272076e-04f, +4.062105010e-04f, +1.270869112e-04f, -5.184656751e-04f, -7.025179806e-04f, +1.065268205e-04f, +1.158510680e-03f, +9.663083127e-04f, -7.745420228e-04f, -2.193586529e-03f, -1.025727110e-03f, +2.292177099e-03f, +4.022753705e-03f, +6.964563701e-04f, -6.454643929e-03f, -1.144173426e-02f, -8.888315096e-03f, +3.277778787e-04f, +9.290879382e-03f, +1.131891039e-02f, +5.997321120e-03f, -1.059561482e-03f, -4.043645375e-03f, -2.083111403e-03f, +1.186136915e-03f, +2.165140336e-03f, +6.472422812e-04f, -1.031958370e-03f, -1.115389910e-03f, -3.417364024e-05f, +7.200285364e-04f, +4.817224287e-04f, -1.612392801e-04f, -4.035826075e-04f, -1.457711105e-04f, +1.536557052e-04f, +1.717221122e-04f, +1.133499855e-05f, -8.222654775e-05f, -4.581440195e-05f, +1.499733940e-05f,
        +2.336102954e-05f, +4.015609728e-05f, -4.438067365e-05f, -1.567596241e-04f, -3.155727048e-05f, +3.135467573e-04f, +3.204820592e-04f, -3.226831859e-04f, -8.058829803e-04f, -8.125534378e-05f, +1.200978750e-03f, +9.962403305e-04f, -1.018351270e-03f, -2.100891351e-03f, -8.678704201e-05f, +2.674543436e-03f, +1.908679696e-03f, -2.013737730e-03f, -3.595489982e-03f, +1.409849475e-05f, +4.076700728e-03f, +2.554869886e-03f, -2.793451027e-03f, -4.399660011e-03f, +1.857454068e-04f, +4.507857853e-03f, +2.493092796e-03f, -2.828652722e-03f, -3.951088380e-03f, +3.037498356e-04f, +3.658041246e-03f, +1.773533212e-03f, -2.088618093e-03f, -2.572434168e-03f, +2.820117937e-04f, +2.120794780e-03f, +8.825186526e-04f, -1.076495704e-03f, -1.144424426e-03f, +1.611983499e-04f, +8.054712459e-04f, +2.734518864e-04f, -3.408706404e-04f, -2.946836819e-04f, +4.913805713e-05f, +1.540456612e-04f, +3.604833932e-05f, -1.499733940e-05f,
        /*  7, 0 (48) */
        +0.000000000e+00f, -5.184284022e-04f, +3.212229602e-06f, +1.307536639e-03f, +8.360763470e-04f, -2.118986788e-03f, -2.852738276e-03f, +2.109164081e-03f, +6.105712658e-03f, -1.950685165e-05f, -9.834821711e-03f, -5.434403018e-03f, +1.219436233e-02f, +1.497172437e-02f, -1.025017254e-02f, -2.819089092e-02f, +4.350570367e-05f, +4.333632545e-02f, +2.439525774e-02f, -5.757751269e-02f, -7.936955118e-02f, +6.777629950e-02f, +3.088165774e-01f, +4.285159846e-01f, +3.088165774e-01f, +6.777629950e-02f, -7.936955118e-02f, -5.757751269e-02f, +2.439525774e-02f, +4.333632545e-02f, +4.350570367e-05f, -2.819089092e-02f, -1.025017254e-02f, +1.497172437e-02f, +1.219436233e-02f, -5.434403018e-03f, -9.834821711e-03f, -1.950685165e-05f, +6.105712658e-03f, +2.109164081e-03f, -2.852738276e-03f, -2.118986788e-03f, +8.360763470e-04f, +1.307536639e-03f, +3.212229602e-06f, -5.184284022e-04f, -1.234425141e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.184284022e-04f, -3.212229602e-06f, -1.888597505e-03f, -1.236145466e-03f, +3.592023527e-03f, +4.047052782e-03f, -4.982450802e-03f, -8.918259580e-03f, +4.834186303e-03f, +1.556156622e-02f, -1.810767405e-03f, -2.277524083e-02f, -4.954253986e-03f, +2.859390823e-02f, +1.529315124e-02f, -3.084300852e-02f, -2.774230592e-02f, +2.793154400e-02f, +3.977726494e-02f, -1.956380632e-02f, -4.852880250e-02f, +7.038976371e-03f, +5.173229864e-02f, +7.038976371e-03f, -4.852880250e-02f, -1.956380632e-02f, +3.977726494e-02f, +2.793154400e-02f, -2.774230592e-02f, -3.084300852e-02f, +1.529315124e-02f, +2.859390823e-02f, -4.954253986e-03f, -2.277524083e-02f, -1.810767405e-03f, +1.556156622e-02f, +4.834186303e-03f, -8.918259580e-03f, -4.982450802e-03f, +4.047052782e-03f, +3.592023527e-03f, -1.236145466e-03f, -1.888597505e-03f, +7.853369693e-05f, +5.184284022e-04f, +1.234425141e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +9.766062624e-06f, -7.181911347e-05f, -6.047305568e-05f, +1.229615697e-04f, +1.872149352e-04f, -1.276807758e-04f, -4.018886385e-04f, +4.093019403e-08f, +6.627019978e-04f, +3.564671675e-04f, -8.483450124e-04f, -1.005404870e-03f, +7.499465761e-04f, +1.925191887e-03f, -7.652224290e-05f, -2.959670128e-03f, -1.574929844e-03f, +3.739895539e-03f, +5.010649862e-03f, -3.168668398e-03f, -1.381200319e-02f, -1.379873723e-02f, -5.135232855e-04f, +1.328797511e-02f, +1.423518529e-02f, +3.899774043e-03f, -4.773157098e-03f, -4.036852200e-03f, +1.303312883e-03f, +3.039464840e-03f, +2.849068333e-04f, -1.900001413e-03f, -8.795212707e-04f, +9.423806704e-04f, +9.118244494e-04f, -2.937223500e-04f, -6.825130750e-04f, -4.583156740e-05f, +3.996724792e-04f, +1.541559783e-04f, -1.783731277e-04f, -1.350252974e-04f, +5.295984601e-05f, +7.600445101e-05f, -5.760175807e-06f, -2.762370518e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -9.766062624e-06f, +7.181911347e-05f, +1.023278982e-04f, -1.976870227e-04f, -2.974200642e-04f, +2.890575428e-04f, +6.463004974e-04f, -2.837752888e-04f, -1.144536630e-03f, +7.830175331e-05f, +1.720893812e-03f, +4.102685728e-04f, -2.237880283e-03f, -1.198305879e-03f, +2.523595232e-03f, +2.204745980e-03f, -2.428286484e-03f, -3.253878147e-03f, +1.885076851e-03f, +4.117691368e-03f, -9.485163500e-04f, -4.585739218e-03f, -2.087601736e-04f, +4.536250409e-03f, +1.343972107e-03f, -3.979342386e-03f, -2.219794955e-03f, +3.053928932e-03f, +2.678080675e-03f, -1.979513937e-03f, -2.682938861e-03f, +9.831294547e-04f, +2.318231147e-03f, -2.310718362e-04f, -1.744439505e-03f, -2.092633706e-04f, +1.136155430e-03f, +3.673118035e-04f, -6.267404753e-04f, -3.348125527e-04f, +2.796685582e-04f, +2.185893392e-04f, -9.151332350e-05f, -1.016996062e-04f, +5.760175807e-06f, +2.762370518e-05f, +0.000000000e+00f,
        /*  7, 1 (48) */
        +0.000000000e+00f, -5.086623395e-04f, -6.860688387e-05f, +1.247063583e-03f, +9.590379168e-04f, -1.931771853e-03f, -2.980419051e-03f, +1.707275443e-03f, +6.105753588e-03f, +6.431951462e-04f, -9.478354543e-03f, -6.282748031e-03f, +1.118895746e-02f, +1.572167095e-02f, -8.324980651e-03f, -2.826741316e-02f, -2.916164424e-03f, +4.176139561e-02f, +2.813515328e-02f, -5.256686283e-02f, -8.253821958e-02f, +5.396429631e-02f, +2.950178402e-01f, +4.280024613e-01f, +3.221045525e-01f, +8.201148479e-02f, -7.546977714e-02f, -6.235066979e-02f, +2.035840554e-02f, +4.463963834e-02f, +3.082970544e-03f, -2.790598409e-02f, -1.215017395e-02f, +1.409220310e-02f, +1.313674300e-02f, -4.522578569e-03f, -1.012854406e-02f, -7.020199266e-04f, +6.059881091e-03f, +2.508836561e-03f, -2.698582297e-03f, -2.297359916e-03f, +7.010510496e-04f, +1.360496485e-03f, +7.921668061e-05f, -5.241885780e-04f, -1.510662193e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.086623395e-04f, +6.860688387e-05f, -1.786269607e-03f, -1.433832489e-03f, +3.294603463e-03f, +4.336110325e-03f, -4.336150304e-03f, -9.202034869e-03f, +3.689649672e-03f, +1.563986797e-02f, -8.987359339e-05f, -2.236497226e-02f, -7.192134268e-03f, +2.739560235e-02f, +1.781674647e-02f, -2.863826254e-02f, -3.017059240e-02f, +2.467766585e-02f, +4.166234180e-02f, -1.544611496e-02f, -4.947731885e-02f, +2.453237153e-03f, +5.152353847e-02f, +1.157522678e-02f, -4.718483039e-02f, -2.354314871e-02f, +3.755746999e-02f, +3.098547293e-02f, -2.506422524e-02f, -3.282252246e-02f, +1.261021237e-02f, +2.957703769e-02f, -2.636022839e-03f, -2.300631267e-02f, -3.555206910e-03f, +1.535230285e-02f, +5.970341733e-03f, -8.550947777e-03f, -5.609191277e-03f, +3.712240230e-03f, +3.871692085e-03f, -1.017556127e-03f, -1.980110829e-03f, -2.316590932e-05f, +5.241885780e-04f, +1.510662193e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.343661977e-05f, -6.725204694e-05f, -6.715287147e-05f, +1.104439513e-04f, +1.942922012e-04f, -1.011733331e-04f, -4.010419751e-04f, -4.434671800e-05f, +6.386092476e-04f, +4.148794920e-04f, -7.804055004e-04f, -1.059549598e-03f, +6.182707865e-04f, +1.935996551e-03f, +1.271031969e-04f, -2.861106379e-03f, -1.828004523e-03f, +3.426330156e-03f, +5.206317386e-03f, -2.449785430e-03f, -1.334314888e-02f, -1.425157367e-02f, -1.538308694e-03f, +1.272108488e-02f, +1.460989809e-02f, +4.639603441e-03f, -4.493920170e-03f, -4.314675244e-03f, +1.014541025e-03f, +3.099423254e-03f, +4.966642856e-04f, -1.860242573e-03f, -1.005985252e-03f, +8.707132496e-04f, +9.702479273e-04f, -2.269977574e-04f, -6.977656499e-04f, -9.271572658e-05f, +3.943097584e-04f, +1.803878146e-04f, -1.677708782e-04f, -1.465159276e-04f, +4.463969354e-05f, +7.975035777e-05f, -1.439082229e-06f, -2.863621876e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -1.343661977e-05f, +6.725204694e-05f, +1.116228722e-04f, -1.760565584e-04f, -3.118785642e-04f, +2.425642658e-04f, +6.597919536e-04f, -2.003800356e-04f, -1.143213222e-03f, -5.012793022e-05f, +1.683708230e-03f, +5.826009958e-04f, -2.140599143e-03f, -1.400372094e-03f, +2.345782207e-03f, +2.409356830e-03f, -2.161148111e-03f, -3.425650924e-03f, +1.537159529e-03f, +4.221775386e-03f, -5.466049358e-04f, -4.597704255e-03f, -6.245539774e-04f, +4.449587916e-03f, +1.729674275e-03f, -3.807712082e-03f, -2.538446195e-03f, +2.827239875e-03f, +2.908274395e-03f, -1.735306302e-03f, -2.822226078e-03f, +7.564539392e-04f, +2.380676125e-03f, -4.639975854e-05f, -1.753844383e-03f, -3.416912839e-04f, +1.117877985e-03f, +4.502613259e-04f, -6.010806214e-04f, -3.793884526e-04f, +2.586479351e-04f, +2.385297552e-04f, -7.920246515e-05f, -1.088454893e-04f, +1.439082229e-06f, +2.863621876e-05f, +0.000000000e+00f,
        /*  7, 2 (48) */
        +0.000000000e+00f, -4.952257198e-04f, -1.358589308e-04f, +1.179910712e-03f, +1.069481868e-03f, -1.737479652e-03f, -3.081592384e-03f, +1.306233468e-03f, +6.061406870e-03f, +1.281804394e-03f, -9.063475051e-03f, -7.063153531e-03f, +1.012940786e-02f, +1.633994173e-02f, -6.388984100e-03f, -2.814030997e-02f, -5.777270803e-03f, +3.993339109e-02f, +3.156148343e-02f, -4.736054545e-02f, -8.498800501e-02f, +4.062114743e-02f, +2.807662665e-01f, +4.264641526e-01f, +3.348256374e-01f, +9.662138288e-02f, -7.083017370e-02f, -6.684458996e-02f, +1.604373029e-02f, +4.565417936e-02f, +6.182393798e-03f, -2.740931980e-02f, -1.401041652e-02f, +1.308621785e-02f, +1.400745625e-02f, -3.552330642e-03f, -1.035554182e-02f, -1.399785577e-03f, +5.967165364e-03f, +2.903146319e-03f, -2.518194483e-03f, -2.465130794e-03f, +5.545351220e-04f, +1.405136178e-03f, +1.589670384e-04f, -5.256276602e-04f, -1.797024380e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.952257198e-04f, +1.358589308e-04f, -1.674646735e-03f, -1.609889047e-03f, +2.982724899e-03f, +4.578674591e-03f, -3.676358351e-03f, -9.402414905e-03f, +2.546436450e-03f, +1.558974004e-02f, +1.593834637e-03f, -2.178237126e-02f, -9.332733411e-03f, +2.599523026e-02f, +2.016252867e-02f, -2.622890571e-02f, -3.233174051e-02f, +2.125201493e-02f, +4.319950132e-02f, -1.122433957e-02f, -5.002392379e-02f, -2.144467102e-03f, +5.089898449e-02f, +1.602481470e-02f, -4.545515612e-02f, -2.735086079e-02f, +3.501902379e-02f, +3.381271281e-02f, -2.215595085e-02f, -3.455782876e-02f, +9.787986297e-03f, +3.033349163e-02f, -2.553467138e-04f, -2.305271243e-02f, -5.309051293e-03f, +1.501061156e-02f, +7.088219717e-03f, -8.100686451e-03f, -6.210271898e-03f, +3.332851777e-03f, +4.130340021e-03f, -7.790263715e-04f, -2.059313294e-03f, -1.320113986e-04f, +5.256276602e-04f, +1.797024380e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.675588491e-05f, -6.236171686e-05f, -7.298096997e-05f, +9.759077119e-05f, +1.996149864e-04f, -7.483801030e-05f, -3.972370981e-04f, -8.704165206e-05f, +6.105359519e-04f, +4.686481720e-04f, -7.086191726e-04f, -1.104649127e-03f, +4.854938715e-04f, +1.932695959e-03f, +3.246504017e-04f, -2.744943539e-03f, -2.061309057e-03f, +3.098718631e-03f, +5.360321239e-03f, -1.746493787e-03f, -1.283161796e-02f, -1.464498729e-02f, -2.556322706e-03f, +1.210015645e-02f, +1.493356050e-02f, +5.384545525e-03f, -4.173266846e-03f, -4.570894266e-03f, +7.101556934e-04f, +3.138590688e-03f, +7.103494024e-04f, -1.805834501e-03f, -1.128326476e-03f, +7.907093813e-04f, +1.023041899e-03f, -1.566860867e-04f, -7.082100232e-04f, -1.403660523e-04f, +3.857389280e-04f, +2.061598898e-04f, -1.554269116e-04f, -1.573143649e-04f, +3.554727186e-05f, +8.300046623e-05f, +3.172941354e-06f, -2.940939777e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -1.675588491e-05f, +6.236171686e-05f, +1.193909001e-04f, -1.539281953e-04f, -3.230510926e-04f, +1.957644976e-04f, +6.672984590e-04f, -1.178320026e-04f, -1.132455450e-03f, -1.750068552e-04f, +1.633489118e-03f, +7.467647766e-04f, -2.027489676e-03f, -1.587851634e-03f, +2.151220976e-03f, +2.591892616e-03f, -1.879045199e-03f, -3.568057956e-03f, +1.179002679e-03f, +4.290901969e-03f, -1.415792325e-04f, -4.572109842e-03f, -1.035182771e-03f, +4.326413757e-03f, +2.102396482e-03f, -3.604068283e-03f, -2.838279978e-03f, +2.575484564e-03f, +3.116755210e-03f, -1.473948446e-03f, -2.940019494e-03f, +5.200131665e-04f, +2.424376583e-03f, +1.422846034e-04f, -1.748719610e-03f, -4.744814268e-04f, +1.089595050e-03f, +5.318792988e-04f, -5.693439858e-04f, -4.223391725e-04f, +2.344139914e-04f, +2.572731998e-04f, -6.543514523e-05f, -1.153866087e-04f, -3.172941354e-06f, +2.940939777e-05f, +0.000000000e+00f,
        /*  7, 3 (48) */
        +0.000000000e+00f, -4.784698349e-04f, -1.982206477e-04f, +1.106929742e-03f, +1.167072639e-03f, -1.537864666e-03f, -3.156430395e-03f, +9.089963697e-04f, +5.974365218e-03f, +1.892340346e-03f, -8.594826879e-03f, -7.771772704e-03f, +9.024758730e-03f, +1.682543560e-02f, -4.456288141e-03f, -2.781565957e-02f, -8.522214343e-03f, +3.787208203e-02f, +3.466020206e-02f, -4.200022421e-02f, -8.673449879e-02f, +2.778952947e-02f, +2.661212792e-01f, +4.239078299e-01f, +3.469257938e-01f, +1.115549434e-01f, -6.544562817e-02f, -7.101785681e-02f, +1.147283603e-02f, +4.636433506e-02f, +9.320984485e-03f, -2.669897040e-02f, -1.581625102e-02f, +1.195789137e-02f, +1.479816563e-02f, -2.529288742e-03f, -1.051222790e-02f, -2.107995600e-03f, +5.826799312e-03f, +3.288885247e-03f, -2.312034593e-03f, -2.620557706e-03f, +3.972207571e-04f, +1.440683450e-03f, +2.419675046e-04f, -5.224547188e-04f, -2.091118358e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.784698349e-04f, +1.982206477e-04f, -1.555255835e-03f, -1.763817242e-03f, +2.659673806e-03f, +4.774439089e-03f, -3.009059891e-03f, -9.520246907e-03f, +1.413981001e-03f, +1.541473318e-02f, +3.227323755e-03f, -2.103560649e-02f, -1.136022309e-02f, +2.440737863e-02f, +2.231374965e-02f, -2.363701309e-02f, -3.421078571e-02f, +1.768395697e-02f, +4.437850400e-02f, -6.933437601e-03f, -5.016550302e-02f, -6.716576944e-03f, +4.986380172e-02f, +2.035122845e-02f, -4.335275964e-02f, -3.095492907e-02f, +3.218074382e-02f, +3.638819737e-02f, -1.903919564e-02f, -3.603177721e-02f, +6.847966803e-03f, +3.085350479e-02f, +2.169029869e-03f, -2.291042782e-02f, -7.057770904e-03f, +1.453613013e-02f, +8.177814767e-03f, -7.568807152e-03f, -6.779615884e-03f, +2.910512605e-03f, +4.364754012e-03f, -5.217531717e-04f, -2.124748439e-03f, -2.473980074e-04f, +5.224547188e-04f, +2.091118358e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.971202353e-05f, -5.720679688e-05f, -7.794699392e-05f, +8.451853313e-05f, +2.032069447e-04f, -4.887100603e-05f, -3.905980408e-04f, -1.277755383e-04f, +5.788045953e-04f, +5.175048575e-04f, -6.336116937e-04f, -1.140607739e-03f, +3.525991669e-04f, +1.915664365e-03f, +5.148751356e-04f, -2.612443858e-03f, -2.273779436e-03f, +2.759644501e-03f, +5.473060168e-03f, -1.062014672e-03f, -1.228058610e-02f, -1.497778787e-02f, -3.563091276e-03f, +1.142756215e-02f, +1.520382378e-02f, +6.130896128e-03f, -3.811774186e-03f, -4.803110104e-03f, +3.918457334e-04f, +3.156134378e-03f, +9.244669781e-04f, -1.736801056e-03f, -1.245537879e-03f, +7.027458309e-04f, +1.069660072e-03f, -8.321807681e-05f, -7.136263213e-04f, -1.884393493e-04f, +3.739218118e-04f, +2.312521275e-04f, -1.413749376e-04f, -1.673026491e-04f, +2.572550181e-05f, +8.570032428e-05f, +8.047512082e-06f, -2.991934502e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -1.971202353e-05f, +5.720679688e-05f, +1.256399360e-04f, -1.315266148e-04f, -3.309743637e-04f, +1.490773181e-04f, +6.689535921e-04f, -3.680922803e-05f, -1.112607779e-03f, -2.953707904e-04f, +1.570940809e-03f, +9.015498578e-04f, -1.899768601e-03f, -1.759413283e-03f, +1.941750497e-03f, +2.751101370e-03f, -1.584459375e-03f, -3.680165329e-03f, +8.136323987e-04f, +4.324674288e-03f, +2.632043609e-04f, -4.509234495e-03f, -1.437251817e-03f, +4.167696725e-03f, +2.459011507e-03f, -3.369953529e-03f, -3.116686908e-03f, +2.300561152e-03f, +3.301574000e-03f, -1.197431855e-03f, -3.035045686e-03f, +2.756505008e-04f, +2.448640478e-03f, +3.334555235e-04f, -1.728794241e-03f, -6.065002292e-04f, +1.051282896e-03f, +6.114111721e-04f, -5.316094506e-04f, -4.632174361e-04f, +2.070551399e-04f, +2.745855725e-04f, -5.026807306e-05f, -1.212155758e-04f, -8.047512082e-06f, +2.991934502e-05f, +0.000000000e+00f,
        /*  7, 4 (48) */
        +0.000000000e+00f, -4.587578113e-04f, -2.554274445e-04f, +1.028982748e-03f, +1.251591172e-03f, -1.334657721e-03f, -3.205301401e-03f, +5.183983289e-04f, +5.846589680e-03f, +2.471144941e-03f, -8.077322022e-03f, -8.405384397e-03f, +7.884150992e-03f, +1.717803477e-02f, -2.540623776e-03f, -2.730078443e-02f, -1.113465820e-02f, +3.559830260e-02f, +3.741984656e-02f, -3.652716404e-02f, -8.779651347e-02f, +1.550894337e-02f, +2.511434913e-01f, +4.203447386e-01f, +3.583533560e-01f, +1.267587672e-01f, -5.931473204e-02f, -7.482963099e-02f, +6.669725923e-03f, +4.675618079e-02f, +1.247711886e-02f, -2.577450342e-02f, -1.755305208e-02f, +1.071235349e-02f, +1.550091146e-02f, -1.459628670e-03f, -1.059544598e-02f, -2.821621921e-03f, +5.638359962e-03f, +3.662807059e-03f, -2.080782465e-03f, -2.761932644e-03f, +2.299181080e-04f, +1.466408952e-03f, +3.276678289e-04f, -5.144072068e-04f, -2.390311808e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.587578113e-04f, +2.554274445e-04f, -1.429615899e-03f, -1.895343857e-03f, +2.328699442e-03f, +4.923516407e-03f, -2.340106299e-03f, -9.557056136e-03f, +3.013732217e-04f, +1.511936239e-02f, +4.798264564e-03f, -2.013405663e-02f, -1.325999169e-02f, +2.264796534e-02f, +2.425550015e-02f, -2.088591172e-02f, -3.579524509e-02f, +1.400379164e-02f, +4.519213640e-02f, -2.608763314e-03f, -4.990229866e-02f, -1.122581144e-02f, +4.842654990e-02f, +2.451892518e-02f, -4.089374813e-02f, -3.432488260e-02f, +2.906405691e-02f, +3.868875852e-02f, -1.573762164e-02f, -3.722920906e-02f, +3.812921116e-03f, +3.112915529e-02f, +4.617670347e-03f, -2.257697230e-02f, -8.786565145e-03f, +1.392962991e-02f, +9.229097663e-03f, -6.957395980e-03f, -7.311225335e-03f, +2.447295169e-03f, +4.571809152e-03f, -2.471675992e-04f, -2.175016512e-03f, -3.686135832e-04f, +5.144072068e-04f, +2.390311808e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.229725832e-05f, -5.184563309e-05f, -8.204832773e-05f, +7.134101637e-05f, +2.051046652e-04f, -2.345906927e-05f, -3.812667058e-04f, -1.663028728e-04f, +5.437559948e-04f, +5.612248810e-04f, -5.560161944e-04f, -1.167398706e-03f, +2.205466708e-04f, +1.885364845e-03f, +6.966149643e-04f, -2.464951107e-03f, -2.464518670e-03f, +2.411695707e-03f, +5.545163282e-03f, -3.994057809e-04f, -1.169338969e-02f, -1.524909670e-02f, -4.554200443e-03f, +1.070594523e-02f, +1.541858668e-02f, +6.874877781e-03f, -3.410269646e-03f, -5.009011453e-03f, +6.143968142e-05f, +3.151352185e-03f, +1.137481256e-03f, -1.653273170e-03f, -1.356624929e-03f, +6.072682878e-04f, +1.109588240e-03f, -7.060227675e-06f, -7.138270327e-04f, -2.365788148e-04f, +3.588446341e-04f, +2.554424378e-04f, -1.256638951e-04f, -1.763650054e-04f, +1.522550372e-05f, +8.779798166e-05f, +1.315223083e-05f, -3.014369114e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.229725832e-05f, +5.184563309e-05f, +1.303924354e-04f, -1.090690042e-04f, -3.357132912e-04f, +1.029057219e-04f, +6.649381238e-04f, +4.204338890e-05f, -1.084083954e-03f, -4.103172188e-04f, +1.496857454e-03f, +1.045849078e-03f, -1.758755042e-03f, -1.913880253e-03f, +1.719310276e-03f, +2.885941360e-03f, -1.279952204e-03f, -3.761300367e-03f, +4.441151534e-04f, +4.322993071e-03f, +6.644028583e-04f, -4.409668015e-03f, -1.827438844e-03f, +3.974704598e-03f, +2.796518107e-03f, -3.107173204e-03f, -3.371221869e-03f, +2.004577893e-03f, +3.460963170e-03f, -9.078988784e-04f, -3.106208297e-03f, +2.530449539e-05f, +2.452930830e-03f, +5.255367885e-04f, -1.693920083e-03f, -7.365940119e-04f, +1.003005735e-03f, +6.880989818e-04f, -4.880127681e-04f, -5.015789302e-04f, +1.766928219e-04f, +2.902361166e-04f, -3.377506652e-05f, -1.262264773e-04f, -1.315223083e-05f, +3.014369114e-05f, +0.000000000e+00f,
        /*  7, 5 (48) */
        +0.000000000e+00f, -4.364605530e-04f, -3.072730776e-04f, +9.469344199e-04f, +1.322932189e-03f, -1.129553056e-03f, -3.228760470e-03f, +1.371316231e-04f, +5.680286807e-03f, +3.014900936e-03f, -7.516097141e-03f, -8.961400592e-03f, +6.716752286e-03f, +1.739858144e-02f, -6.552589311e-04f, -2.660416947e-02f, -1.359960931e-02f, +3.313378393e-02f, +3.983154227e-02f, -3.098200076e-02f, -8.819591925e-02f, +3.815553680e-03f, +2.358943946e-01f, +4.157905382e-01f, +3.690593012e-01f, +1.421773538e-01f, -5.243985426e-02f, -7.823990064e-02f, +1.660714471e-03f, +4.681762047e-02f, +1.562847105e-02f, -2.463702217e-02f, -1.920632525e-02f, +9.355728563e-03f, +1.610817975e-02f, -3.500404306e-04f, -1.060250621e-02f, -3.535448954e-03f, +5.401781148e-03f, +4.021651693e-03f, -1.825340028e-03f, -2.887596539e-03f, +5.355310260e-05f, +1.481634456e-03f, +4.154658105e-04f, -5.012549759e-04f, -2.691748720e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.364605530e-04f, +3.072730776e-04f, -1.299223464e-03f, -2.004412861e-03f, +1.992986151e-03f, +5.026422129e-03f, -1.675168176e-03f, -9.515012747e-03f, -7.827107325e-04f, +1.470904517e-02f, +6.295122018e-03f, -1.908820755e-02f, -1.501874673e-02f, +2.073408509e-02f, +2.597481042e-02f, -1.799997036e-02f, -3.707519729e-02f, +1.024249128e-02f, +4.563625156e-02f, +1.714229757e-03f, -4.923789580e-02f, -1.563547945e-02f, +4.659911106e-02f, +2.849362978e-02f, -3.809723002e-02f, -3.743205581e-02f, +2.569283504e-02f, +4.069333641e-02f, -1.227665847e-02f, -3.813710794e-02f, +7.067128194e-04f, +3.115445979e-02f, +7.070601177e-03f, -2.205143551e-02f, -1.048048523e-02f, +1.319303589e-02f, +1.023210340e-02f, -6.269296998e-03f, -7.799238103e-03f, +1.945716238e-03f, +4.748501974e-03f, +4.306851739e-05f, -2.208791579e-03f, -4.948400605e-04f, +5.012549759e-04f, +2.691748720e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.450776296e-05f, -4.633573213e-05f, -8.528981405e-05f, +5.816843057e-05f, +2.053569289e-04f, +1.221672470e-06f, -3.694012142e-04f, -2.024022021e-04f, +5.057462146e-04f, +5.996277874e-04f, -4.764683979e-04f, -1.185062795e-03f, +9.026666474e-05f, +1.842343909e-03f, +8.687954834e-04f, -2.303879485e-03f, -2.632798804e-03f, +2.057448314e-03f, +5.577481931e-03f, +2.384536114e-04f, -1.107350569e-02f, -1.545834947e-02f, -5.525319863e-03f, +9.938206779e-03f, +1.557600927e-02f, +7.612660200e-03f, -2.969830662e-03f, -5.186391212e-03f, -2.791030453e-04f, +3.123680586e-03f, +1.347825884e-03f, -1.555490471e-03f, -1.460613257e-03f, +5.047897562e-04f, +1.142348993e-03f, +7.128781453e-05f, -7.086593613e-04f, -2.844164418e-04f, +3.405188824e-04f, +2.785084545e-04f, -1.083580776e-04f, -1.843889131e-04f, +4.106474726e-06f, +8.924457674e-05f, +1.845081486e-05f, -3.006190168e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.450776296e-05f, +4.633573213e-05f, +1.336844431e-04f, -8.676328082e-05f, -3.373592935e-04f, +5.763349266e-05f, +6.554768997e-04f, +1.181188622e-04f, -1.047361566e-03f, -5.190117488e-04f, +1.412114242e-03f, +1.178665739e-03f, -1.605857472e-03f, -2.050237899e-03f, +1.485922522e-03f, +2.995587507e-03f, -9.681426814e-04f, -3.811055189e-03f, +7.353155228e-05f, +4.286055964e-03f, +1.058714921e-03f, -4.274305924e-03f, -2.202522148e-03f, +3.748993771e-03f, +3.112066827e-03f, -2.817781351e-03f, -3.599625827e-03f, +1.689836756e-03f, +3.593353469e-03f, -6.076260051e-04f, -3.152599747e-03f, -2.290064906e-04f, +2.436872970e-03f, +7.169145526e-04f, -1.644075557e-03f, -8.635987773e-04f, +9.449173978e-04f, +7.611881432e-04f, -4.387470956e-04f, -5.369865850e-04f, +1.434816127e-04f, +3.039998545e-04f, -1.604710306e-05f, -1.303161153e-04f, -1.845081486e-05f, +3.006190168e-05f, +0.000000000e+00f,
        /*  7, 6 (48) */
        +0.000000000e+00f, -4.119527900e-04f, -3.536088098e-04f, +8.616446058e-04f, +1.381100619e-03f, -9.241961269e-04f, -3.227538798e-03f, -2.322695911e-04f, +5.477884605e-03f, +3.520647150e-03f, -6.916469353e-03f, -9.437868990e-03f, +5.531689491e-03f, +1.748884811e-02f, +1.187084978e-03f, -2.573537398e-02f, -1.590348879e-02f, +3.050098512e-02f, +4.188899058e-02f, -2.540451883e-02f, -8.795746564e-02f, -7.257952015e-03f, +2.204360452e-01f, +4.102652183e-01f, +3.789975080e-01f, +1.577533631e-01f, -4.482719406e-02f, -8.120973130e-02f, -3.525676742e-03f, +4.653851743e-02f, +1.875215164e-02f, -2.328919628e-02f, -2.076181572e-02f, +7.895115306e-03f, +1.661296950e-02f, +7.923085621e-04f, -1.053121839e-02f, -4.244108315e-03f, +5.117364706e-03f, +4.362170575e-03f, -1.546831573e-03f, -2.995954616e-03f, -1.308358105e-04f, +1.485740930e-03f, +5.047103873e-04f, -4.828041611e-04f, -2.992367736e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.119527900e-04f, +3.536088098e-04f, -1.165539020e-03f, -2.091176142e-03f, +1.655626858e-03f, +5.084055621e-03f, -1.019691276e-03f, -9.396893884e-03f, -1.830072298e-03f, +1.419003343e-02f, +7.707236260e-03f, -1.790954181e-02f, -1.662460420e-02f, +1.868384719e-02f, +2.746073294e-02f, -1.500438286e-02f, -3.804333997e-02f, +6.431436087e-03f, +4.570978311e-02f, +6.000285721e-03f, -4.817918088e-02f, -1.990978538e-02f, +4.439658891e-02f, +3.224262355e-02f, -3.498516320e-02f, -4.024983716e-02f, +2.209320921e-02f, +4.238317317e-02f, -8.683305000e-03f, -3.874473394e-02f, -2.445886927e-03f, +3.092545330e-02f, +9.507474147e-03f, -2.133452096e-02f, -1.212456078e-02f, +1.232943712e-02f, +1.117702080e-02f, -5.508108855e-03f, -8.237985198e-03f, +1.408729653e-03f, +4.891983586e-03f, +3.470683719e-04f, -2.224838682e-03f, -6.251561758e-04f, +4.828041611e-04f, +2.992367736e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.634352250e-05f, -4.073327675e-05f, -8.768341605e-05f, +4.510663056e-05f, +2.040238912e-04f, +2.500676342e-05f, -3.551741776e-04f, -2.358771244e-04f, +4.651434485e-04f, +6.325775162e-04f, -3.956018474e-04f, -1.193706305e-03f, -3.734630268e-05f, +1.787225627e-03f, +1.030435793e-03f, -2.130702271e-03f, -2.778061776e-03f, +1.699450608e-03f, +5.571080366e-03f, +8.488763033e-04f, -1.042453100e-02f, -1.560529730e-02f, -6.472225843e-03f, +9.127491098e-03f, +1.567452535e-02f, +8.340381297e-03f, -2.491782711e-03f, -5.333162472e-03f, -6.277020005e-04f, +3.072701901e-03f, +1.553914313e-03f, -1.443802159e-03f, -1.556556319e-03f, +3.958884027e-04f, +1.167506265e-03f, +1.512961948e-04f, -6.980073717e-04f, -3.315755797e-04f, +3.189819924e-04f, +3.002293292e-04f, -8.953713388e-05f, -1.912661842e-04f, -7.564510283e-06f, +8.999491795e-05f, +2.390327373e-05f, -2.965557857e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.634352250e-05f, +4.073327675e-05f, +1.355645836e-04f, -6.480648075e-05f, -3.360284079e-04f, +1.362236142e-05f, +6.408354129e-04f, +1.908524170e-04f, -1.002976181e-03f, -6.206937747e-04f, +1.317658095e-03f, +1.299120064e-03f, -1.442560106e-03f, -2.167639909e-03f, +1.243673803e-03f, +3.079435871e-03f, -6.516844366e-04f, -3.829287972e-03f, -2.950498220e-04f, +4.214354349e-03f, +1.442908639e-03f, -4.104341299e-03f, -2.559407831e-03f, +3.492396405e-03f, +3.402984597e-03f, -2.504064289e-03f, -3.799846157e-03f, +1.358815244e-03f, +3.697389241e-03f, -2.990057852e-04f, -3.173511451e-03f, -4.852005956e-04f, +2.400260476e-03f, +9.059507605e-04f, -1.579368513e-03f, -9.863503137e-04f, +8.772622431e-04f, +8.299343997e-04f, -3.840630086e-04f, -5.690149289e-04f, +1.076090043e-04f, +3.156600646e-04f, +2.807807247e-06f, -1.333852764e-04f, -2.390327373e-05f, +2.965557857e-05f, +0.000000000e+00f,
        /*  7, 7 (48) */
        +0.000000000e+00f, -3.856092675e-04f, -3.943420865e-04f, +7.739611898e-04f, +1.426207250e-03f, -7.201722357e-04f, -3.202532034e-03f, -5.874437687e-04f, +5.242007481e-03f, +3.985790599e-03f, -6.283891837e-03f, -9.833470837e-03f, +4.337983186e-03f, +1.745150180e-02f, +2.974310605e-03f, -2.470493819e-02f, -1.803419106e-02f, +2.772292335e-02f, +4.358844119e-02f, -1.983343846e-02f, -8.710858933e-02f, -1.768248302e-02f, +2.048307479e-01f, +4.037929925e-01f, +3.881249991e-01f, +1.734278885e-01f, -3.648681276e-02f, -8.370151401e-02f, -8.858839214e-03f, +4.591081542e-02f, +2.182485354e-02f, -2.173528197e-02f, -2.220561788e-02f, +6.338558987e-03f, +1.700885791e-02f, +1.959814827e-03f, -1.037992220e-02f, -4.942115687e-03f, +4.785789126e-03f, +4.681152568e-03f, -1.246602244e-03f, -3.085491750e-03f, -3.221019947e-04f, +1.478176420e-03f, +5.947053052e-04f, -4.589008873e-04f, -3.288923522e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.856092675e-04f, +3.943420865e-04f, -1.029974437e-03f, -2.155982623e-03f, +1.319598450e-03f, +5.097677983e-03f, -3.788558631e-04f, -9.206041467e-03f, -2.833048479e-03f, +1.356933965e-02f, +9.024894355e-03f, -1.661042175e-02f, -1.806716431e-02f, +1.651620728e-02f, +2.870440675e-02f, -1.192494699e-02f, -3.869502441e-02f, +2.602148116e-03f, +4.541473329e-02f, +1.021464007e-02f, -4.673627224e-02f, -2.401412668e-02f, +4.183718108e-02f, +3.573501995e-02f, -3.158217860e-02f, -4.275390145e-02f, +1.829336305e-02f, +4.374198841e-02f, -4.985915759e-03f, -3.904373973e-02f, -5.619398378e-03f, +3.044025270e-02f, +1.190773462e-02f, -2.042857020e-02f, -1.370392930e-02f, +1.134308680e-02f, +1.205428304e-02f, -4.678174456e-03f, -8.622048207e-03f, +8.397147245e-04f, +4.999592591e-03f, +6.627284365e-04f, -2.222030875e-03f, -7.585414522e-04f, +4.589008873e-04f, +3.288923522e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.780816287e-05f, -3.509267250e-05f, -8.924783014e-05f, +3.225639524e-05f, +2.011761977e-04f, +4.774434328e-05f, -3.387709059e-04f, -2.665570676e-04f, +4.223248927e-04f, +6.599822455e-04f, -3.140432681e-04f, -1.193498675e-03f, -1.614390333e-04f, +1.720705346e-03f, +1.180653198e-03f, -1.946940336e-03f, -2.899919139e-03f, +1.340207678e-03f, +5.527225233e-03f, +1.429379508e-03f, -9.750161122e-03f, -1.569000598e-02f, -7.390823752e-03f, +8.277169662e-03f, +1.571285342e-02f, +9.054168626e-03f, -1.977695812e-03f, -5.447374015e-03f, -9.821665543e-04f, +2.998150671e-03f, +1.754150570e-03f, -1.318667112e-03f, -1.643543036e-03f, +2.812048656e-04f, +1.184669683e-03f, +2.324080947e-04f, -6.817939050e-04f, -3.776736345e-04f, +2.942978454e-04f, +3.203875692e-04f, -6.929594067e-05f, -1.968940433e-04f, -1.971277493e-05f, +9.000805441e-05f, +2.946612832e-05f, -2.890875247e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.780816287e-05f, +3.509267250e-05f, +1.360929656e-04f, -4.338331920e-05f, -3.318592401e-04f, -2.879053179e-05f, +6.213161109e-04f, +2.597252849e-04f, -9.515151096e-04f, -7.146813517e-04f, +1.214497919e-03f, +1.406454515e-03f, -1.270408862e-03f, -2.265412945e-03f, +9.946964071e-04f, +3.137106184e-03f, -3.332428752e-04f, -3.816121917e-03f, -6.585983085e-04f, +4.108667669e-03f, +1.813848623e-03f, -3.901254063e-03f, -2.895155927e-03f, +3.207005202e-03f, +3.666797860e-03f, -2.168522171e-03f, -3.970055315e-03f, +1.014146564e-03f, +3.771941957e-03f, +1.547244324e-05f, -3.168442424e-03f, -7.411495481e-04f, +2.343059715e-03f, +1.090997027e-03f, -1.500037935e-03f, -1.103694528e-03f, +8.003752606e-04f, +8.936108672e-04f, -3.242679756e-04f, -5.972544766e-04f, +6.929486011e-05f, +3.250107733e-04f, +2.266493267e-05f, -1.353400191e-04f, -2.946612832e-05f, +2.890875247e-05f, +0.000000000e+00f,
        /*  7, 8 (48) */
        +0.000000000e+00f, -3.578011047e-04f, -4.294347590e-04f, +6.847133596e-04f, +1.458463645e-03f, -5.189960380e-04f, -3.154787691e-03f, -9.262146746e-04f, +4.975450413e-03f, +4.408115492e-03f, -5.623909592e-03f, -1.014751411e-02f, +3.144484510e-03f, +1.729006277e-02f, +4.695015951e-03f, -2.352428499e-02f, -1.998113140e-02f, +2.482300421e-02f, +4.492864887e-02f, -1.430621323e-02f, -8.567920983e-02f, -2.743264414e-02f, +1.891407419e-01f, +3.964021687e-01f, +3.964021687e-01f, +1.891407419e-01f, -2.743264414e-02f, -8.567920983e-02f, -1.430621323e-02f, +4.492864887e-02f, +2.482300421e-02f, -1.998113140e-02f, -2.352428499e-02f, +4.695015951e-03f, +1.729006277e-02f, +3.144484510e-03f, -1.014751411e-02f, -5.623909592e-03f, +4.408115492e-03f, +4.975450413e-03f, -9.262146746e-04f, -3.154787691e-03f, -5.189960380e-04f, +1.458463645e-03f, +6.847133596e-04f, -4.294347590e-04f, -3.578011047e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.578011047e-04f, +4.294347590e-04f, -8.938814713e-04f, -2.199365942e-03f, +9.877392098e-04f, +5.068887451e-03f, +2.424602479e-04f, -8.946316183e-03f, -3.784563588e-03f, +1.285465830e-02f, +1.023939227e-02f, -1.520396723e-02f, -1.933757317e-02f, +1.425079434e-02f, +2.969910316e-02f, -8.787840802e-03f, -3.902826729e-02f, -1.213973801e-03f, +4.475613498e-02f, +1.432330774e-02f, -4.492242362e-02f, -2.791538074e-02f, +3.894202515e-02f, +3.894202515e-02f, -2.791538074e-02f, -4.492242362e-02f, +1.432330774e-02f, +4.475613498e-02f, -1.213973801e-03f, -3.902826729e-02f, -8.787840802e-03f, +2.969910316e-02f, +1.425079434e-02f, -1.933757317e-02f, -1.520396723e-02f, +1.023939227e-02f, +1.285465830e-02f, -3.784563588e-03f, -8.946316183e-03f, +2.424602479e-04f, +5.068887451e-03f, +9.877392098e-04f, -2.199365942e-03f, -8.938814713e-04f, +4.294347590e-04f, +3.578011047e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.890875247e-05f, -2.946612832e-05f, -9.000805441e-05f, +1.971277493e-05f, +1.968940433e-04f, +6.929594067e-05f, -3.203875692e-04f, -2.942978454e-04f, +3.776736345e-04f, +6.817939050e-04f, -2.324080947e-04f, -1.184669683e-03f, -2.812048656e-04f, +1.643543036e-03f, +1.318667112e-03f, -1.754150570e-03f, -2.998150671e-03f, +9.821665543e-04f, +5.447374015e-03f, +1.977695812e-03f, -9.054168626e-03f, -1.571285342e-02f, -8.277169662e-03f, +7.390823752e-03f, +1.569000598e-02f, +9.750161122e-03f, -1.429379508e-03f, -5.527225233e-03f, -1.340207678e-03f, +2.899919139e-03f, +1.946940336e-03f, -1.180653198e-03f, -1.720705346e-03f, +1.614390333e-04f, +1.193498675e-03f, +3.140432681e-04f, -6.599822455e-04f, -4.223248927e-04f, +2.665570676e-04f, +3.387709059e-04f, -4.774434328e-05f, -2.011761977e-04f, -3.225639524e-05f, +8.924783014e-05f, +3.509267250e-05f, -2.780816287e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.890875247e-05f, +2.946612832e-05f, +1.353400191e-04f, -2.266493267e-05f, -3.250107733e-04f, -6.929486011e-05f, +5.972544766e-04f, +3.242679756e-04f, -8.936108672e-04f, -8.003752606e-04f, +1.103694528e-03f, +1.500037935e-03f, -1.090997027e-03f, -2.343059715e-03f, +7.411495481e-04f, +3.168442424e-03f, -1.547244324e-05f, -3.771941957e-03f, -1.014146564e-03f, +3.970055315e-03f, +2.168522171e-03f, -3.666797860e-03f, -3.207005202e-03f, +2.895155927e-03f, +3.901254063e-03f, -1.813848623e-03f, -4.108667669e-03f, +6.585983085e-04f, +3.816121917e-03f, +3.332428752e-04f, -3.137106184e-03f, -9.946964071e-04f, +2.265412945e-03f, +1.270408862e-03f, -1.406454515e-03f, -1.214497919e-03f, +7.146813517e-04f, +9.515151096e-04f, -2.597252849e-04f, -6.213161109e-04f, +2.879053179e-05f, +3.318592401e-04f, +4.338331920e-05f, -1.360929656e-04f, -3.509267250e-05f, +2.780816287e-05f, +0.000000000e+00f,
        /*  7, 9 (48) */
        +0.000000000e+00f, -3.288923522e-04f, -4.589008873e-04f, +5.947053052e-04f, +1.478176420e-03f, -3.221019947e-04f, -3.085491750e-03f, -1.246602244e-03f, +4.681152568e-03f, +4.785789126e-03f, -4.942115687e-03f, -1.037992220e-02f, +1.959814827e-03f, +1.700885791e-02f, +6.338558987e-03f, -2.220561788e-02f, -2.173528197e-02f, +2.182485354e-02f, +4.591081542e-02f, -8.858839214e-03f, -8.370151401e-02f, -3.648681276e-02f, +1.734278885e-01f, +3.881249991e-01f, +4.037929925e-01f, +2.048307479e-01f, -1.768248302e-02f, -8.710858933e-02f, -1.983343846e-02f, +4.358844119e-02f, +2.772292335e-02f, -1.803419106e-02f, -2.470493819e-02f, +2.974310605e-03f, +1.745150180e-02f, +4.337983186e-03f, -9.833470837e-03f, -6.283891837e-03f, +3.985790599e-03f, +5.242007481e-03f, -5.874437687e-04f, -3.202532034e-03f, -7.201722357e-04f, +1.426207250e-03f, +7.739611898e-04f, -3.943420865e-04f, -3.856092675e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.288923522e-04f, +4.589008873e-04f, -7.585414522e-04f, -2.222030875e-03f, +6.627284365e-04f, +4.999592591e-03f, +8.397147245e-04f, -8.622048207e-03f, -4.678174456e-03f, +1.205428304e-02f, +1.134308680e-02f, -1.370392930e-02f, -2.042857020e-02f, +1.190773462e-02f, +3.044025270e-02f, -5.619398378e-03f, -3.904373973e-02f, -4.985915759e-03f, +4.374198841e-02f, +1.829336305e-02f, -4.275390145e-02f, -3.158217860e-02f, +3.573501995e-02f, +4.183718108e-02f, -2.401412668e-02f, -4.673627224e-02f, +1.021464007e-02f, +4.541473329e-02f, +2.602148116e-03f, -3.869502441e-02f, -1.192494699e-02f, +2.870440675e-02f, +1.651620728e-02f, -1.806716431e-02f, -1.661042175e-02f, +9.024894355e-03f, +1.356933965e-02f, -2.833048479e-03f, -9.206041467e-03f, -3.788558631e-04f, +5.097677983e-03f, +1.319598450e-03f, -2.155982623e-03f, -1.029974437e-03f, +3.943420865e-04f, +3.856092675e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.965557857e-05f, -2.390327373e-05f, -8.999491795e-05f, +7.564510283e-06f, +1.912661842e-04f, +8.953713388e-05f, -3.002293292e-04f, -3.189819924e-04f, +3.315755797e-04f, +6.980073717e-04f, -1.512961948e-04f, -1.167506265e-03f, -3.958884027e-04f, +1.556556319e-03f, +1.443802159e-03f, -1.553914313e-03f, -3.072701901e-03f, +6.277020005e-04f, +5.333162472e-03f, +2.491782711e-03f, -8.340381297e-03f, -1.567452535e-02f, -9.127491098e-03f, +6.472225843e-03f, +1.560529730e-02f, +1.042453100e-02f, -8.488763033e-04f, -5.571080366e-03f, -1.699450608e-03f, +2.778061776e-03f, +2.130702271e-03f, -1.030435793e-03f, -1.787225627e-03f, +3.734630268e-05f, +1.193706305e-03f, +3.956018474e-04f, -6.325775162e-04f, -4.651434485e-04f, +2.358771244e-04f, +3.551741776e-04f, -2.500676342e-05f, -2.040238912e-04f, -4.510663056e-05f, +8.768341605e-05f, +4.073327675e-05f, -2.634352250e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.965557857e-05f, +2.390327373e-05f, +1.333852764e-04f, -2.807807247e-06f, -3.156600646e-04f, -1.076090043e-04f, +5.690149289e-04f, +3.840630086e-04f, -8.299343997e-04f, -8.772622431e-04f, +9.863503137e-04f, +1.579368513e-03f, -9.059507605e-04f, -2.400260476e-03f, +4.852005956e-04f, +3.173511451e-03f, +2.990057852e-04f, -3.697389241e-03f, -1.358815244e-03f, +3.799846157e-03f, +2.504064289e-03f, -3.402984597e-03f, -3.492396405e-03f, +2.559407831e-03f, +4.104341299e-03f, -1.442908639e-03f, -4.214354349e-03f, +2.950498220e-04f, +3.829287972e-03f, +6.516844366e-04f, -3.079435871e-03f, -1.243673803e-03f, +2.167639909e-03f, +1.442560106e-03f, -1.299120064e-03f, -1.317658095e-03f, +6.206937747e-04f, +1.002976181e-03f, -1.908524170e-04f, -6.408354129e-04f, -1.362236142e-05f, +3.360284079e-04f, +6.480648075e-05f, -1.355645836e-04f, -4.073327675e-05f, +2.634352250e-05f, +0.000000000e+00f,
        /*  7,10 (48) */
        +0.000000000e+00f, -2.992367736e-04f, -4.828041611e-04f, +5.047103873e-04f, +1.485740930e-03f, -1.308358105e-04f, -2.995954616e-03f, -1.546831573e-03f, +4.362170575e-03f, +5.117364706e-03f, -4.244108315e-03f, -1.053121839e-02f, +7.923085621e-04f, +1.661296950e-02f, +7.895115306e-03f, -2.076181572e-02f, -2.328919628e-02f, +1.875215164e-02f, +4.653851743e-02f, -3.525676742e-03f, -8.120973130e-02f, -4.482719406e-02f, +1.577533631e-01f, +3.789975080e-01f, +4.102652183e-01f, +2.204360452e-01f, -7.257952015e-03f, -8.795746564e-02f, -2.540451883e-02f, +4.188899058e-02f, +3.050098512e-02f, -1.590348879e-02f, -2.573537398e-02f, +1.187084978e-03f, +1.748884811e-02f, +5.531689491e-03f, -9.437868990e-03f, -6.916469353e-03f, +3.520647150e-03f, +5.477884605e-03f, -2.322695911e-04f, -3.227538798e-03f, -9.241961269e-04f, +1.381100619e-03f, +8.616446058e-04f, -3.536088098e-04f, -4.119527900e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.992367736e-04f, +4.828041611e-04f, -6.251561758e-04f, -2.224838682e-03f, +3.470683719e-04f, +4.891983586e-03f, +1.408729653e-03f, -8.237985198e-03f, -5.508108855e-03f, +1.117702080e-02f, +1.232943712e-02f, -1.212456078e-02f, -2.133452096e-02f, +9.507474147e-03f, +3.092545330e-02f, -2.445886927e-03f, -3.874473394e-02f, -8.683305000e-03f, +4.238317317e-02f, +2.209320921e-02f, -4.024983716e-02f, -3.498516320e-02f, +3.224262355e-02f, +4.439658891e-02f, -1.990978538e-02f, -4.817918088e-02f, +6.000285721e-03f, +4.570978311e-02f, +6.431436087e-03f, -3.804333997e-02f, -1.500438286e-02f, +2.746073294e-02f, +1.868384719e-02f, -1.662460420e-02f, -1.790954181e-02f, +7.707236260e-03f, +1.419003343e-02f, -1.830072298e-03f, -9.396893884e-03f, -1.019691276e-03f, +5.084055621e-03f, +1.655626858e-03f, -2.091176142e-03f, -1.165539020e-03f, +3.536088098e-04f, +4.119527900e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.006190168e-05f, -1.845081486e-05f, -8.924457674e-05f, -4.106474726e-06f, +1.843889131e-04f, +1.083580776e-04f, -2.785084545e-04f, -3.405188824e-04f, +2.844164418e-04f, +7.086593613e-04f, -7.128781453e-05f, -1.142348993e-03f, -5.047897562e-04f, +1.460613257e-03f, +1.555490471e-03f, -1.347825884e-03f, -3.123680586e-03f, +2.791030453e-04f, +5.186391212e-03f, +2.969830662e-03f, -7.612660200e-03f, -1.557600927e-02f, -9.938206779e-03f, +5.525319863e-03f, +1.545834947e-02f, +1.107350569e-02f, -2.384536114e-04f, -5.577481931e-03f, -2.057448314e-03f, +2.632798804e-03f, +2.303879485e-03f, -8.687954834e-04f, -1.842343909e-03f, -9.026666474e-05f, +1.185062795e-03f, +4.764683979e-04f, -5.996277874e-04f, -5.057462146e-04f, +2.024022021e-04f, +3.694012142e-04f, -1.221672470e-06f, -2.053569289e-04f, -5.816843057e-05f, +8.528981405e-05f, +4.633573213e-05f, -2.450776296e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -3.006190168e-05f, +1.845081486e-05f, +1.303161153e-04f, +1.604710306e-05f, -3.039998545e-04f, -1.434816127e-04f, +5.369865850e-04f, +4.387470956e-04f, -7.611881432e-04f, -9.449173978e-04f, +8.635987773e-04f, +1.644075557e-03f, -7.169145526e-04f, -2.436872970e-03f, +2.290064906e-04f, +3.152599747e-03f, +6.076260051e-04f, -3.593353469e-03f, -1.689836756e-03f, +3.599625827e-03f, +2.817781351e-03f, -3.112066827e-03f, -3.748993771e-03f, +2.202522148e-03f, +4.274305924e-03f, -1.058714921e-03f, -4.286055964e-03f, -7.353155228e-05f, +3.811055189e-03f, +9.681426814e-04f, -2.995587507e-03f, -1.485922522e-03f, +2.050237899e-03f, +1.605857472e-03f, -1.178665739e-03f, -1.412114242e-03f, +5.190117488e-04f, +1.047361566e-03f, -1.181188622e-04f, -6.554768997e-04f, -5.763349266e-05f, +3.373592935e-04f, +8.676328082e-05f, -1.336844431e-04f, -4.633573213e-05f, +2.450776296e-05f, +0.000000000e+00f,
        /*  7,11 (48) */
        +0.000000000e+00f, -2.691748720e-04f, -5.012549759e-04f, +4.154658105e-04f, +1.481634456e-03f, +5.355310260e-05f, -2.887596539e-03f, -1.825340028e-03f, +4.021651693e-03f, +5.401781148e-03f, -3.535448954e-03f, -1.060250621e-02f, -3.500404306e-04f, +1.610817975e-02f, +9.355728563e-03f, -1.920632525e-02f, -2.463702217e-02f, +1.562847105e-02f, +4.681762047e-02f, +1.660714471e-03f, -7.823990064e-02f, -5.243985426e-02f, +1.421773538e-01f, +3.690593012e-01f, +4.157905382e-01f, +2.358943946e-01f, +3.815553680e-03f, -8.819591925e-02f, -3.098200076e-02f, +3.983154227e-02f, +3.313378393e-02f, -1.359960931e-02f, -2.660416947e-02f, -6.552589311e-04f, +1.739858144e-02f, +6.716752286e-03f, -8.961400592e-03f, -7.516097141e-03f, +3.014900936e-03f, +5.680286807e-03f, +1.371316231e-04f, -3.228760470e-03f, -1.129553056e-03f, +1.322932189e-03f, +9.469344199e-04f, -3.072730776e-04f, -4.364605530e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.691748720e-04f, +5.012549759e-04f, -4.948400605e-04f, -2.208791579e-03f, +4.306851739e-05f, +4.748501974e-03f, +1.945716238e-03f, -7.799238103e-03f, -6.269296998e-03f, +1.023210340e-02f, +1.319303589e-02f, -1.048048523e-02f, -2.205143551e-02f, +7.070601177e-03f, +3.115445979e-02f, +7.067128194e-04f, -3.813710794e-02f, -1.227665847e-02f, +4.069333641e-02f, +2.569283504e-02f, -3.743205581e-02f, -3.809723002e-02f, +2.849362978e-02f, +4.659911106e-02f, -1.563547945e-02f, -4.923789580e-02f, +1.714229757e-03f, +4.563625156e-02f, +1.024249128e-02f, -3.707519729e-02f, -1.799997036e-02f, +2.597481042e-02f, +2.073408509e-02f, -1.501874673e-02f, -1.908820755e-02f, +6.295122018e-03f, +1.470904517e-02f, -7.827107325e-04f, -9.515012747e-03f, -1.675168176e-03f, +5.026422129e-03f, +1.992986151e-03f, -2.004412861e-03f, -1.299223464e-03f, +3.072730776e-04f, +4.364605530e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.014369114e-05f, -1.315223083e-05f, -8.779798166e-05f, -1.522550372e-05f, +1.763650054e-04f, +1.256638951e-04f, -2.554424378e-04f, -3.588446341e-04f, +2.365788148e-04f, +7.138270327e-04f, +7.060227675e-06f, -1.109588240e-03f, -6.072682878e-04f, +1.356624929e-03f, +1.653273170e-03f, -1.137481256e-03f, -3.151352185e-03f, -6.143968142e-05f, +5.009011453e-03f, +3.410269646e-03f, -6.874877781e-03f, -1.541858668e-02f, -1.070594523e-02f, +4.554200443e-03f, +1.524909670e-02f, +1.169338969e-02f, +3.994057809e-04f, -5.545163282e-03f, -2.411695707e-03f, +2.464518670e-03f, +2.464951107e-03f, -6.966149643e-04f, -1.885364845e-03f, -2.205466708e-04f, +1.167398706e-03f, +5.560161944e-04f, -5.612248810e-04f, -5.437559948e-04f, +1.663028728e-04f, +3.812667058e-04f, +2.345906927e-05f, -2.051046652e-04f, -7.134101637e-05f, +8.204832773e-05f, +5.184563309e-05f, -2.229725832e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -3.014369114e-05f, +1.315223083e-05f, +1.262264773e-04f, +3.377506652e-05f, -2.902361166e-04f, -1.766928219e-04f, +5.015789302e-04f, +4.880127681e-04f, -6.880989818e-04f, -1.003005735e-03f, +7.365940119e-04f, +1.693920083e-03f, -5.255367885e-04f, -2.452930830e-03f, -2.530449539e-05f, +3.106208297e-03f, +9.078988784e-04f, -3.460963170e-03f, -2.004577893e-03f, +3.371221869e-03f, +3.107173204e-03f, -2.796518107e-03f, -3.974704598e-03f, +1.827438844e-03f, +4.409668015e-03f, -6.644028583e-04f, -4.322993071e-03f, -4.441151534e-04f, +3.761300367e-03f, +1.279952204e-03f, -2.885941360e-03f, -1.719310276e-03f, +1.913880253e-03f, +1.758755042e-03f, -1.045849078e-03f, -1.496857454e-03f, +4.103172188e-04f, +1.084083954e-03f, -4.204338890e-05f, -6.649381238e-04f, -1.029057219e-04f, +3.357132912e-04f, +1.090690042e-04f, -1.303924354e-04f, -5.184563309e-05f, +2.229725832e-05f, +0.000000000e+00f,
        /*  7,12 (48) */
        +0.000000000e+00f, -2.390311808e-04f, -5.144072068e-04f, +3.276678289e-04f, +1.466408952e-03f, +2.299181080e-04f, -2.761932644e-03f, -2.080782465e-03f, +3.662807059e-03f, +5.638359962e-03f, -2.821621921e-03f, -1.059544598e-02f, -1.459628670e-03f, +1.550091146e-02f, +1.071235349e-02f, -1.755305208e-02f, -2.577450342e-02f, +1.247711886e-02f, +4.675618079e-02f, +6.669725923e-03f, -7.482963099e-02f, -5.931473204e-02f, +1.267587672e-01f, +3.583533560e-01f, +4.203447386e-01f, +2.511434913e-01f, +1.550894337e-02f, -8.779651347e-02f, -3.652716404e-02f, +3.741984656e-02f, +3.559830260e-02f, -1.113465820e-02f, -2.730078443e-02f, -2.540623776e-03f, +1.717803477e-02f, +7.884150992e-03f, -8.405384397e-03f, -8.077322022e-03f, +2.471144941e-03f, +5.846589680e-03f, +5.183983289e-04f, -3.205301401e-03f, -1.334657721e-03f, +1.251591172e-03f, +1.028982748e-03f, -2.554274445e-04f, -4.587578113e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.390311808e-04f, +5.144072068e-04f, -3.686135832e-04f, -2.175016512e-03f, -2.471675992e-04f, +4.571809152e-03f, +2.447295169e-03f, -7.311225335e-03f, -6.957395980e-03f, +9.229097663e-03f, +1.392962991e-02f, -8.786565145e-03f, -2.257697230e-02f, +4.617670347e-03f, +3.112915529e-02f, +3.812921116e-03f, -3.722920906e-02f, -1.573762164e-02f, +3.868875852e-02f, +2.906405691e-02f, -3.432488260e-02f, -4.089374813e-02f, +2.451892518e-02f, +4.842654990e-02f, -1.122581144e-02f, -4.990229866e-02f, -2.608763314e-03f, +4.519213640e-02f, +1.400379164e-02f, -3.579524509e-02f, -2.088591172e-02f, +2.425550015e-02f, +2.264796534e-02f, -1.325999169e-02f, -2.013405663e-02f, +4.798264564e-03f, +1.511936239e-02f, +3.013732217e-04f, -9.557056136e-03f, -2.340106299e-03f, +4.923516407e-03f, +2.328699442e-03f, -1.895343857e-03f, -1.429615899e-03f, +2.554274445e-04f, +4.587578113e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.991934502e-05f, -8.047512082e-06f, -8.570032428e-05f, -2.572550181e-05f, +1.673026491e-04f, +1.413749376e-04f, -2.312521275e-04f, -3.739218118e-04f, +1.884393493e-04f, +7.136263213e-04f, +8.321807681e-05f, -1.069660072e-03f, -7.027458309e-04f, +1.245537879e-03f, +1.736801056e-03f, -9.244669781e-04f, -3.156134378e-03f, -3.918457334e-04f, +4.803110104e-03f, +3.811774186e-03f, -6.130896128e-03f, -1.520382378e-02f, -1.142756215e-02f, +3.563091276e-03f, +1.497778787e-02f, +1.228058610e-02f, +1.062014672e-03f, -5.473060168e-03f, -2.759644501e-03f, +2.273779436e-03f, +2.612443858e-03f, -5.148751356e-04f, -1.915664365e-03f, -3.525991669e-04f, +1.140607739e-03f, +6.336116937e-04f, -5.175048575e-04f, -5.788045953e-04f, +1.277755383e-04f, +3.905980408e-04f, +4.887100603e-05f, -2.032069447e-04f, -8.451853313e-05f, +7.794699392e-05f, +5.720679688e-05f, -1.971202353e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.991934502e-05f, +8.047512082e-06f, +1.212155758e-04f, +5.026807306e-05f, -2.745855725e-04f, -2.070551399e-04f, +4.632174361e-04f, +5.316094506e-04f, -6.114111721e-04f, -1.051282896e-03f, +6.065002292e-04f, +1.728794241e-03f, -3.334555235e-04f, -2.448640478e-03f, -2.756505008e-04f, +3.035045686e-03f, +1.197431855e-03f, -3.301574000e-03f, -2.300561152e-03f, +3.116686908e-03f, +3.369953529e-03f, -2.459011507e-03f, -4.167696725e-03f, +1.437251817e-03f, +4.509234495e-03f, -2.632043609e-04f, -4.324674288e-03f, -8.136323987e-04f, +3.680165329e-03f, +1.584459375e-03f, -2.751101370e-03f, -1.941750497e-03f, +1.759413283e-03f, +1.899768601e-03f, -9.015498578e-04f, -1.570940809e-03f, +2.953707904e-04f, +1.112607779e-03f, +3.680922803e-05f, -6.689535921e-04f, -1.490773181e-04f, +3.309743637e-04f, +1.315266148e-04f, -1.256399360e-04f, -5.720679688e-05f, +1.971202353e-05f, +0.000000000e+00f,
        /*  7,13 (48) */
        +0.000000000e+00f, -2.091118358e-04f, -5.224547188e-04f, +2.419675046e-04f, +1.440683450e-03f, +3.972207571e-04f, -2.620557706e-03f, -2.312034593e-03f, +3.288885247e-03f, +5.826799312e-03f, -2.107995600e-03f, -1.051222790e-02f, -2.529288742e-03f, +1.479816563e-02f, +1.195789137e-02f, -1.581625102e-02f, -2.669897040e-02f, +9.320984485e-03f, +4.636433506e-02f, +1.147283603e-02f, -7.101785681e-02f, -6.544562817e-02f, +1.115549434e-01f, +3.469257938e-01f, +4.239078299e-01f, +2.661212792e-01f, +2.778952947e-02f, -8.673449879e-02f, -4.200022421e-02f, +3.466020206e-02f, +3.787208203e-02f, -8.522214343e-03f, -2.781565957e-02f, -4.456288141e-03f, +1.682543560e-02f, +9.024758730e-03f, -7.771772704e-03f, -8.594826879e-03f, +1.892340346e-03f, +5.974365218e-03f, +9.089963697e-04f, -3.156430395e-03f, -1.537864666e-03f, +1.167072639e-03f, +1.106929742e-03f, -1.982206477e-04f, -4.784698349e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.091118358e-04f, +5.224547188e-04f, -2.473980074e-04f, -2.124748439e-03f, -5.217531717e-04f, +4.364754012e-03f, +2.910512605e-03f, -6.779615884e-03f, -7.568807152e-03f, +8.177814767e-03f, +1.453613013e-02f, -7.057770904e-03f, -2.291042782e-02f, +2.169029869e-03f, +3.085350479e-02f, +6.847966803e-03f, -3.603177721e-02f, -1.903919564e-02f, +3.638819737e-02f, +3.218074382e-02f, -3.095492907e-02f, -4.335275964e-02f, +2.035122845e-02f, +4.986380172e-02f, -6.716576944e-03f, -5.016550302e-02f, -6.933437601e-03f, +4.437850400e-02f, +1.768395697e-02f, -3.421078571e-02f, -2.363701309e-02f, +2.231374965e-02f, +2.440737863e-02f, -1.136022309e-02f, -2.103560649e-02f, +3.227323755e-03f, +1.541473318e-02f, +1.413981001e-03f, -9.520246907e-03f, -3.009059891e-03f, +4.774439089e-03f, +2.659673806e-03f, -1.763817242e-03f, -1.555255835e-03f, +1.982206477e-04f, +4.784698349e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.940939777e-05f, -3.172941354e-06f, -8.300046623e-05f, -3.554727186e-05f, +1.573143649e-04f, +1.554269116e-04f, -2.061598898e-04f, -3.857389280e-04f, +1.403660523e-04f, +7.082100232e-04f, +1.566860867e-04f, -1.023041899e-03f, -7.907093813e-04f, +1.128326476e-03f, +1.805834501e-03f, -7.103494024e-04f, -3.138590688e-03f, -7.101556934e-04f, +4.570894266e-03f, +4.173266846e-03f, -5.384545525e-03f, -1.493356050e-02f, -1.210015645e-02f, +2.556322706e-03f, +1.464498729e-02f, +1.283161796e-02f, +1.746493787e-03f, -5.360321239e-03f, -3.098718631e-03f, +2.061309057e-03f, +2.744943539e-03f, -3.246504017e-04f, -1.932695959e-03f, -4.854938715e-04f, +1.104649127e-03f, +7.086191726e-04f, -4.686481720e-04f, -6.105359519e-04f, +8.704165206e-05f, +3.972370981e-04f, +7.483801030e-05f, -1.996149864e-04f, -9.759077119e-05f, +7.298096997e-05f, +6.236171686e-05f, -1.675588491e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.940939777e-05f, +3.172941354e-06f, +1.153866087e-04f, +6.543514523e-05f, -2.572731998e-04f, -2.344139914e-04f, +4.223391725e-04f, +5.693439858e-04f, -5.318792988e-04f, -1.089595050e-03f, +4.744814268e-04f, +1.748719610e-03f, -1.422846034e-04f, -2.424376583e-03f, -5.200131665e-04f, +2.940019494e-03f, +1.473948446e-03f, -3.116755210e-03f, -2.575484564e-03f, +2.838279978e-03f, +3.604068283e-03f, -2.102396482e-03f, -4.326413757e-03f, +1.035182771e-03f, +4.572109842e-03f, +1.415792325e-04f, -4.290901969e-03f, -1.179002679e-03f, +3.568057956e-03f, +1.879045199e-03f, -2.591892616e-03f, -2.151220976e-03f, +1.587851634e-03f, +2.027489676e-03f, -7.467647766e-04f, -1.633489118e-03f, +1.750068552e-04f, +1.132455450e-03f, +1.178320026e-04f, -6.672984590e-04f, -1.957644976e-04f, +3.230510926e-04f, +1.539281953e-04f, -1.193909001e-04f, -6.236171686e-05f, +1.675588491e-05f, +0.000000000e+00f,
        /*  7,14 (48) */
        +0.000000000e+00f, -1.797024380e-04f, -5.256276602e-04f, +1.589670384e-04f, +1.405136178e-03f, +5.545351220e-04f, -2.465130794e-03f, -2.518194483e-03f, +2.903146319e-03f, +5.967165364e-03f, -1.399785577e-03f, -1.035554182e-02f, -3.552330642e-03f, +1.400745625e-02f, +1.308621785e-02f, -1.401041652e-02f, -2.740931980e-02f, +6.182393798e-03f, +4.565417936e-02f, +1.604373029e-02f, -6.684458996e-02f, -7.083017370e-02f, +9.662138288e-02f, +3.348256374e-01f, +4.264641526e-01f, +2.807662665e-01f, +4.062114743e-02f, -8.498800501e-02f, -4.736054545e-02f, +3.156148343e-02f, +3.993339109e-02f, -5.777270803e-03f, -2.814030997e-02f, -6.388984100e-03f, +1.633994173e-02f, +1.012940786e-02f, -7.063153531e-03f, -9.063475051e-03f, +1.281804394e-03f, +6.061406870e-03f, +1.306233468e-03f, -3.081592384e-03f, -1.737479652e-03f, +1.069481868e-03f, +1.179910712e-03f, -1.358589308e-04f, -4.952257198e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.797024380e-04f, +5.256276602e-04f, -1.320113986e-04f, -2.059313294e-03f, -7.790263715e-04f, +4.130340021e-03f, +3.332851777e-03f, -6.210271898e-03f, -8.100686451e-03f, +7.088219717e-03f, +1.501061156e-02f, -5.309051293e-03f, -2.305271243e-02f, -2.553467138e-04f, +3.033349163e-02f, +9.787986297e-03f, -3.455782876e-02f, -2.215595085e-02f, +3.381271281e-02f, +3.501902379e-02f, -2.735086079e-02f, -4.545515612e-02f, +1.602481470e-02f, +5.089898449e-02f, -2.144467102e-03f, -5.002392379e-02f, -1.122433957e-02f, +4.319950132e-02f, +2.125201493e-02f, -3.233174051e-02f, -2.622890571e-02f, +2.016252867e-02f, +2.599523026e-02f, -9.332733411e-03f, -2.178237126e-02f, +1.593834637e-03f, +1.558974004e-02f, +2.546436450e-03f, -9.402414905e-03f, -3.676358351e-03f, +4.578674591e-03f, +2.982724899e-03f, -1.609889047e-03f, -1.674646735e-03f, +1.358589308e-04f, +4.952257198e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.863621876e-05f, +1.439082229e-06f, -7.975035777e-05f, -4.463969354e-05f, +1.465159276e-04f, +1.677708782e-04f, -1.803878146e-04f, -3.943097584e-04f, +9.271572658e-05f, +6.977656499e-04f, +2.269977574e-04f, -9.702479273e-04f, -8.707132496e-04f, +1.005985252e-03f, +1.860242573e-03f, -4.966642856e-04f, -3.099423254e-03f, -1.014541025e-03f, +4.314675244e-03f, +4.493920170e-03f, -4.639603441e-03f, -1.460989809e-02f, -1.272108488e-02f, +1.538308694e-03f, +1.425157367e-02f, +1.334314888e-02f, +2.449785430e-03f, -5.206317386e-03f, -3.426330156e-03f, +1.828004523e-03f, +2.861106379e-03f, -1.271031969e-04f, -1.935996551e-03f, -6.182707865e-04f, +1.059549598e-03f, +7.804055004e-04f, -4.148794920e-04f, -6.386092476e-04f, +4.434671800e-05f, +4.010419751e-04f, +1.011733331e-04f, -1.942922012e-04f, -1.104439513e-04f, +6.715287147e-05f, +6.725204694e-05f, -1.343661977e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.863621876e-05f, -1.439082229e-06f, +1.088454893e-04f, +7.920246515e-05f, -2.385297552e-04f, -2.586479351e-04f, +3.793884526e-04f, +6.010806214e-04f, -4.502613259e-04f, -1.117877985e-03f, +3.416912839e-04f, +1.753844383e-03f, +4.639975854e-05f, -2.380676125e-03f, -7.564539392e-04f, +2.822226078e-03f, +1.735306302e-03f, -2.908274395e-03f, -2.827239875e-03f, +2.538446195e-03f, +3.807712082e-03f, -1.729674275e-03f, -4.449587916e-03f, +6.245539774e-04f, +4.597704255e-03f, +5.466049358e-04f, -4.221775386e-03f, -1.537159529e-03f, +3.425650924e-03f, +2.161148111e-03f, -2.409356830e-03f, -2.345782207e-03f, +1.400372094e-03f, +2.140599143e-03f, -5.826009958e-04f, -1.683708230e-03f, +5.012793022e-05f, +1.143213222e-03f, +2.003800356e-04f, -6.597919536e-04f, -2.425642658e-04f, +3.118785642e-04f, +1.760565584e-04f, -1.116228722e-04f, -6.725204694e-05f, +1.343661977e-05f, +0.000000000e+00f,
        /*  7,15 (48) */
        +0.000000000e+00f, -1.510662193e-04f, -5.241885780e-04f, +7.921668061e-05f, +1.360496485e-03f, +7.010510496e-04f, -2.297359916e-03f, -2.698582297e-03f, +2.508836561e-03f, +6.059881091e-03f, -7.020199266e-04f, -1.012854406e-02f, -4.522578569e-03f, +1.313674300e-02f, +1.409220310e-02f, -1.215017395e-02f, -2.790598409e-02f, +3.082970544e-03f, +4.463963834e-02f, +2.035840554e-02f, -6.235066979e-02f, -7.546977714e-02f, +8.201148479e-02f, +3.221045525e-01f, +4.280024613e-01f, +2.950178402e-01f, +5.396429631e-02f, -8.253821958e-02f, -5.256686283e-02f, +2.813515328e-02f, +4.176139561e-02f, -2.916164424e-03f, -2.826741316e-02f, -8.324980651e-03f, +1.572167095e-02f, +1.118895746e-02f, -6.282748031e-03f, -9.478354543e-03f, +6.431951462e-04f, +6.105753588e-03f, +1.707275443e-03f, -2.980419051e-03f, -1.931771853e-03f, +9.590379168e-04f, +1.247063583e-03f, -6.860688387e-05f, -5.086623395e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.510662193e-04f, +5.241885780e-04f, -2.316590932e-05f, -1.980110829e-03f, -1.017556127e-03f, +3.871692085e-03f, +3.712240230e-03f, -5.609191277e-03f, -8.550947777e-03f, +5.970341733e-03f, +1.535230285e-02f, -3.555206910e-03f, -2.300631267e-02f, -2.636022839e-03f, +2.957703769e-02f, +1.261021237e-02f, -3.282252246e-02f, -2.506422524e-02f, +3.098547293e-02f, +3.755746999e-02f, -2.354314871e-02f, -4.718483039e-02f, +1.157522678e-02f, +5.152353847e-02f, +2.453237153e-03f, -4.947731885e-02f, -1.544611496e-02f, +4.166234180e-02f, +2.467766585e-02f, -3.017059240e-02f, -2.863826254e-02f, +1.781674647e-02f, +2.739560235e-02f, -7.192134268e-03f, -2.236497226e-02f, -8.987359339e-05f, +1.563986797e-02f, +3.689649672e-03f, -9.202034869e-03f, -4.336150304e-03f, +4.336110325e-03f, +3.294603463e-03f, -1.433832489e-03f, -1.786269607e-03f, +6.860688387e-05f, +5.086623395e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.762370518e-05f, +5.760175807e-06f, -7.600445101e-05f, -5.295984601e-05f, +1.350252974e-04f, +1.783731277e-04f, -1.541559783e-04f, -3.996724792e-04f, +4.583156740e-05f, +6.825130750e-04f, +2.937223500e-04f, -9.118244494e-04f, -9.423806704e-04f, +8.795212707e-04f, +1.900001413e-03f, -2.849068333e-04f, -3.039464840e-03f, -1.303312883e-03f, +4.036852200e-03f, +4.773157098e-03f, -3.899774043e-03f, -1.423518529e-02f, -1.328797511e-02f, +5.135232855e-04f, +1.379873723e-02f, +1.381200319e-02f, +3.168668398e-03f, -5.010649862e-03f, -3.739895539e-03f, +1.574929844e-03f, +2.959670128e-03f, +7.652224290e-05f, -1.925191887e-03f, -7.499465761e-04f, +1.005404870e-03f, +8.483450124e-04f, -3.564671675e-04f, -6.627019978e-04f, -4.093019403e-08f, +4.018886385e-04f, +1.276807758e-04f, -1.872149352e-04f, -1.229615697e-04f, +6.047305568e-05f, +7.181911347e-05f, -9.766062624e-06f, +0.000000000e+00f,
        +0.000000000e+00f, -2.762370518e-05f, -5.760175807e-06f, +1.016996062e-04f, +9.151332350e-05f, -2.185893392e-04f, -2.796685582e-04f, +3.348125527e-04f, +6.267404753e-04f, -3.673118035e-04f, -1.136155430e-03f, +2.092633706e-04f, +1.744439505e-03f, +2.310718362e-04f, -2.318231147e-03f, -9.831294547e-04f, +2.682938861e-03f, +1.979513937e-03f, -2.678080675e-03f, -3.053928932e-03f, +2.219794955e-03f, +3.979342386e-03f, -1.343972107e-03f, -4.536250409e-03f, +2.087601736e-04f, +4.585739218e-03f, +9.485163500e-04f, -4.117691368e-03f, -1.885076851e-03f, +3.253878147e-03f, +2.428286484e-03f, -2.204745980e-03f, -2.523595232e-03f, +1.198305879e-03f, +2.237880283e-03f, -4.102685728e-04f, -1.720893812e-03f, -7.830175331e-05f, +1.144536630e-03f, +2.837752888e-04f, -6.463004974e-04f, -2.890575428e-04f, +2.974200642e-04f, +1.976870227e-04f, -1.023278982e-04f, -7.181911347e-05f, +9.766062624e-06f, +0.000000000e+00f,
        /*  8, 0 (44) */
        +0.000000000e+00f, -5.810608668e-04f, -4.000691189e-04f, +1.473036739e-03f, +1.194314507e-03f, -2.873286720e-03f, -2.812546922e-03f, +4.814679451e-03f, +5.726744505e-03f, -7.245170423e-03f, -1.058087851e-02f, +1.001747038e-02f, +1.834373570e-02f, -1.289773969e-02f, -3.079950282e-02f, +1.559401954e-02f, +5.232680174e-02f, -1.780024775e-02f, -9.893335750e-02f, +1.924749700e-02f, +3.158555538e-01f, +4.802482832e-01f, +3.158555538e-01f, +1.924749700e-02f, -9.893335750e-02f, -1.780024775e-02f, +5.232680174e-02f, +1.559401954e-02f, -3.079950282e-02f, -1.289773969e-02f, +1.834373570e-02f, +1.001747038e-02f, -1.058087851e-02f, -7.245170423e-03f, +5.726744505e-03f, +4.814679451e-03f, -2.812546922e-03f, -2.873286720e-03f, +1.194314507e-03f, +1.473036739e-03f, -4.000691189e-04f, -5.810608668e-04f, +8.174592653e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +5.810608668e-04f, +4.000691189e-04f, -2.174762082e-03f, -1.369356920e-03f, +4.931706478e-03f, +2.614276448e-03f, -9.249493921e-03f, -4.085126069e-03f, +1.521344320e-02f, +5.480993556e-03f, -2.257913432e-02f, -6.427039238e-03f, +3.073327098e-02f, +6.578871207e-03f, -3.875145264e-02f, -5.735049828e-03f, +4.555317997e-02f, +3.918145659e-03f, -5.012182275e-02f, -1.392488435e-03f, +5.173229864e-02f, -1.392488435e-03f, -5.012182275e-02f, +3.918145659e-03f, +4.555317997e-02f, -5.735049828e-03f, -3.875145264e-02f, +6.578871207e-03f, +3.073327098e-02f, -6.427039238e-03f, -2.257913432e-02f, +5.480993556e-03f, +1.521344320e-02f, -4.085126069e-03f, -9.249493921e-03f, +2.614276448e-03f, +4.931706478e-03f, -1.369356920e-03f, -2.174762082e-03f, +5.133746463e-04f, +5.810608668e-04f, -8.174592653e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.185484257e-05f, -7.472545295e-05f, -1.102051290e-04f, +1.613767670e-04f, +2.444118589e-04f, -2.837343586e-04f, -4.818346326e-04f, +4.347689209e-04f, +8.725487992e-04f, -5.951362975e-04f, -1.487933707e-03f, +7.268860082e-04f, +2.447072989e-03f, -7.549241477e-04f, -4.003216328e-03f, +4.860173922e-04f, +6.895726713e-03f, +9.490229708e-04f, -1.476051954e-02f, -1.838447645e-02f, -7.222834590e-04f, +1.782422552e-02f, +1.557915740e-02f, -7.956834231e-05f, -6.992952053e-03f, -9.829232678e-04f, +3.981393558e-03f, +1.059950903e-03f, -2.398032028e-03f, -9.168719580e-04f, +1.438709876e-03f, +7.113088342e-04f, -8.326150558e-04f, -5.029857206e-04f, +4.536423550e-04f, +3.214802361e-04f, -2.270679961e-04f, -1.806565744e-04f, +1.012954305e-04f, +8.356404177e-05f, -3.855347749e-05f, -2.569515524e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.185484257e-05f, +7.472545295e-05f, +1.586424720e-04f, -2.828334246e-04f, -3.191320079e-04f, +6.056212654e-04f, +5.265264426e-04f, -1.095032644e-03f, -7.496963344e-04f, +1.750316290e-03f, +9.422006148e-04f, -2.533177027e-03f, -1.053194813e-03f, +3.366842708e-03f, +1.041971095e-03f, -4.146189187e-03f, -8.914588966e-04f, +4.757638244e-03f, +6.158590596e-04f, -5.104045782e-03f, -2.592907924e-04f, +5.127648687e-03f, -1.146548538e-04f, -4.824253892e-03f, +4.393630174e-04f, +4.244320116e-03f, -6.624116387e-04f, -3.480588537e-03f, +7.580816744e-04f, +2.646049143e-03f, -7.314302511e-04f, -1.848821109e-03f, +6.132254185e-04f, +1.171037534e-03f, -4.481649702e-04f, -6.569929318e-04f, +2.808403007e-04f, +3.124376673e-04f, -1.441699117e-04f, -1.132976271e-04f, +3.855347749e-05f, +2.569515524e-05f, +0.000000000e+00f,
        /*  8, 1 (44) */
        +0.000000000e+00f, -5.392060243e-04f, -4.747945719e-04f, +1.362831610e-03f, +1.355691274e-03f, -2.628874861e-03f, -3.096281281e-03f, +4.332844818e-03f, +6.161513426e-03f, -6.372621624e-03f, -1.117601480e-02f, +8.529536678e-03f, +1.907062170e-02f, -1.045066670e-02f, -3.155442696e-02f, +1.159080321e-02f, +5.281281913e-02f, -1.090452104e-02f, -9.798433453e-02f, +4.486977456e-03f, +2.974710773e-01f, +4.795259998e-01f, +3.336797793e-01f, +3.482665439e-02f, -9.901292585e-02f, -2.479319980e-02f, +5.134387847e-02f, +1.957541309e-02f, -2.973955191e-02f, -1.529577171e-02f, +1.742686374e-02f, +1.145618026e-02f, -9.869569671e-03f, -8.077785479e-03f, +5.223758785e-03f, +5.268321806e-03f, -2.491066686e-03f, -3.100354716e-03f, +1.013657932e-03f, +1.574332169e-03f, -3.165050772e-04f, -6.196143443e-04f, +5.605077129e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +5.392060243e-04f, +4.747945719e-04f, -2.016119610e-03f, -1.652190345e-03f, +4.612574470e-03f, +3.219897714e-03f, -8.722967479e-03f, -5.180158713e-03f, +1.446374686e-02f, +7.231309846e-03f, -2.163693371e-02f, -8.960216265e-03f, +2.968007616e-02f, +9.945713914e-03f, -3.770948155e-02f, -9.881239015e-03f, +4.466172107e-02f, +8.675783903e-03f, -4.950596369e-02f, -6.496534218e-03f, +5.147300785e-02f, +3.735160252e-03f, -5.023647761e-02f, -9.061082325e-04f, +4.599254299e-02f, -1.490729711e-03f, -3.941386428e-02f, +3.098282669e-03f, +3.149135265e-02f, -3.780990095e-03f, -2.331056457e-02f, +3.632172447e-03f, +1.582666861e-02f, -2.914088535e-03f, -9.697658891e-03f, +1.957283516e-03f, +5.212546779e-03f, -1.056919253e-03f, -2.318931993e-03f, +4.000770192e-04f, +6.196143443e-04f, -5.605077129e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.447000076e-05f, -6.561260708e-05f, -1.175863630e-04f, +1.413909328e-04f, +2.587499785e-04f, -2.447267536e-04f, -5.046039744e-04f, +3.647515618e-04f, +9.033027300e-04f, -4.769486025e-04f, -1.522328357e-03f, +5.356244570e-04f, +2.472885404e-03f, -4.517495490e-04f, -3.989152634e-03f, +6.792324100e-07f, +6.743476916e-03f, +1.771989956e-03f, -1.388975381e-02f, -1.884927793e-02f, -2.162862672e-03f, +1.717067280e-02f, +1.633957237e-02f, +8.318913589e-04f, -7.032366365e-03f, -1.487435369e-03f, +3.922815420e-03f, +1.364116952e-03f, -2.325561793e-03f, -1.103788633e-03f, +1.374690872e-03f, +8.243134910e-04f, -7.835964559e-04f, -5.686890412e-04f, +4.201123347e-04f, +3.575455993e-04f, -2.067708630e-04f, -1.990006381e-04f, +9.087705687e-05f, +9.201382764e-05f, -3.456277161e-05f, -2.909513156e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.447000076e-05f, +6.561260708e-05f, +1.705338903e-04f, -2.516281064e-04f, -3.524274318e-04f, +5.498599193e-04f, +5.968357629e-04f, -1.010025620e-03f, -8.748938469e-04f, +1.636274853e-03f, +1.139001349e-03f, -2.396651528e-03f, -1.332909937e-03f, +3.220556109e-03f, +1.406553845e-03f, -4.007037969e-03f, -1.331074280e-03f, +4.643243197e-03f, +1.108914643e-03f, -5.028768897e-03f, -7.752124316e-04f, +5.099238890e-03f, +3.895744136e-04f, -4.842134161e-03f, -2.064217926e-05f, +4.300022554e-03f, -2.716382553e-04f, -3.560161383e-03f, +4.504061946e-04f, +2.733648279e-03f, -5.086205797e-04f, -1.930375961e-03f, +4.666398829e-04f, +1.236949904e-03f, -3.623359676e-04f, -7.032381695e-04f, +2.377710009e-04f, +3.400167222e-04f, -1.271457542e-04f, -1.265129176e-04f, +3.456277161e-05f, +2.909513156e-05f, +0.000000000e+00f,
        /*  8, 2 (44) */
        +0.000000000e+00f, -4.947360235e-04f, -5.404071790e-04f, +1.245245247e-03f, +1.497082207e-03f, -2.370124883e-03f, -3.341008035e-03f, +3.828240844e-03f, +6.526264988e-03f, -5.469318894e-03f, -1.165296341e-02f, +7.007208321e-03f, +1.960624616e-02f, -7.977781293e-03f, -3.200617651e-02f, +7.601650574e-03f, +5.281349836e-02f, -4.161044122e-03f, -9.621234458e-02f, -9.402776357e-03f, +2.786217994e-01f, +4.773631371e-01f, +3.508504521e-01f, +5.116622676e-02f, -9.818103449e-02f, -3.182556617e-02f, +4.985644310e-02f, +2.349822851e-02f, -2.837543496e-02f, -1.762133351e-02f, +1.632307510e-02f, +1.283087113e-02f, -9.045256180e-03f, -8.861381935e-03f, +4.655069744e-03f, +5.688434141e-03f, -2.133521087e-03f, -3.307125579e-03f, +8.146572943e-04f, +1.665209226e-03f, -2.244912495e-04f, -6.541771159e-04f, +2.695563973e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.947360235e-04f, +5.404071790e-04f, -1.845585719e-03f, -1.903818451e-03f, +4.260147039e-03f, +3.769757633e-03f, -8.126131716e-03f, -6.190184334e-03f, +1.358885301e-02f, +8.867584699e-03f, -2.049793236e-02f, -1.135686779e-02f, +2.834716623e-02f, +1.316627002e-02f, -3.630292770e-02f, -1.388827698e-02f, +4.333064679e-02f, +1.331902710e-02f, -4.839704905e-02f, -1.152530311e-02f, +5.069779542e-02f, +8.834399142e-03f, -4.984690319e-02f, -5.748242393e-03f, +4.597190081e-02f, +2.809292843e-03f, -3.968550254e-02f, -4.618787135e-04f, +3.194175885e-02f, -1.047341816e-03f, -2.381918515e-02f, +1.701796486e-03f, +1.629330850e-02f, -1.677138632e-03f, -1.005999486e-02f, +1.254045347e-03f, +5.450317780e-03f, -7.169025308e-04f, -2.446077748e-03f, +2.735641016e-04f, +6.541771159e-04f, -2.695563973e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.640993010e-05f, -5.633742412e-05f, -1.234361062e-04f, +1.209264873e-04f, +2.700613610e-04f, -2.048736546e-04f, -5.219194978e-04f, +2.936413168e-04f, +9.248699457e-04f, -3.578843506e-04f, -1.541995804e-03f, +3.448443249e-04f, +2.475871378e-03f, -1.530509239e-04f, -3.940354256e-03f, -4.693393252e-04f, +6.539323918e-03f, +2.544408182e-03f, -1.297319719e-02f, -1.921709714e-02f, -3.591505477e-03f, +1.642657021e-02f, +1.703595698e-02f, +1.780477243e-03f, -7.011546824e-03f, -1.995409702e-03f, +3.826910903e-03f, +1.664642242e-03f, -2.229670092e-03f, -1.285821334e-03f, +1.296050107e-03f, +9.329939847e-04f, -7.256777112e-04f, -6.311675135e-04f, +3.813850264e-04f, +3.915132464e-04f, -1.836050578e-04f, -2.161792827e-04f, +7.898707982e-05f, +9.995883490e-05f, -2.988787338e-05f, -3.238614251e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.640993010e-05f, +5.633742412e-05f, +1.798468566e-04f, -2.192450057e-04f, -3.805723284e-04f, +4.904672768e-04f, +6.586139036e-04f, -9.171717255e-04f, -9.878083628e-04f, +1.508241484e-03f, +1.320087845e-03f, -2.238310358e-03f, -1.594596247e-03f, +3.043677248e-03f, +1.752595690e-03f, -3.828686751e-03f, -1.753801711e-03f, +4.482514405e-03f, +1.588801705e-03f, -4.902691787e-03f, -1.283182136e-03f, +5.019017235e-03f, +8.916550208e-04f, -4.810825532e-03f, -4.838688553e-04f, +4.312319161e-03f, +1.264254265e-04f, -3.604266988e-03f, +1.331817181e-04f, +2.794594309e-03f, -2.758704644e-04f, -1.993717300e-03f, +3.112387393e-04f, +1.291758293e-03f, -2.697264117e-04f, -7.436511503e-04f, +1.902072397e-04f, +3.651508023e-04f, -1.076330211e-04f, -1.390933055e-04f, +2.988787338e-05f, +3.238614251e-05f, +0.000000000e+00f,
        /*  8, 3 (44) */
        +0.000000000e+00f, -4.483260934e-04f, -5.967446031e-04f, +1.121809141e-03f, +1.618008694e-03f, -2.100063522e-03f, -3.545881689e-03f, +3.306321346e-03f, +6.819906305e-03f, -4.544448948e-03f, -1.201084776e-02f, +5.465212517e-03f, +1.995109049e-02f, -5.501909915e-03f, -3.215922744e-02f, +3.661296318e-03f, +5.234415903e-02f, +2.378279796e-03f, -9.366793640e-02f, -2.237597355e-02f, +2.594047022e-01f, +4.737716316e-01f, +3.672770223e-01f, +6.820218374e-02f, -9.640055725e-02f, -3.883711299e-02f, +4.786103340e-02f, +2.732513942e-02f, -2.671079272e-02f, -1.985100360e-02f, +1.503725377e-02f, +1.412692124e-02f, -8.112262196e-03f, -9.587059646e-03f, +4.023902230e-03f, +6.069819167e-03f, -1.742007841e-03f, -3.490730637e-03f, +5.984780117e-04f, +1.744196306e-03f, -1.245324146e-04f, -6.840649893e-04f, -5.430502781e-06f, +0.000000000e+00f,
        +0.000000000e+00f, +4.483260934e-04f, +5.967446031e-04f, -1.665738863e-03f, -2.123063457e-03f, +3.879574710e-03f, +4.260224910e-03f, -7.467517812e-03f, -7.107356059e-03f, +1.260104465e-02f, +1.037582618e-02f, -1.917784451e-02f, -1.359517815e-02f, +2.675256998e-02f, +1.620994727e-02f, -3.455033201e-02f, -1.771696373e-02f, +4.157684508e-02f, +1.780154150e-02f, -4.680824735e-02f, -1.642799490e-02f, +4.941461328e-02f, +1.385341638e-02f, -4.895524817e-02f, -1.055906793e-02f, +4.548803195e-02f, +7.121612003e-03f, -3.955907711e-02f, -4.066145701e-03f, +3.207494056e-02f, +1.747252493e-03f, -2.409505562e-02f, -2.919208143e-04f, +1.660454724e-02f, -3.853803383e-04f, -1.032972127e-02f, +5.103941965e-04f, +5.640525020e-03f, -3.517517285e-04f, -2.553710769e-03f, +1.344707961e-04f, +6.840649893e-04f, +5.430502781e-06f, +0.000000000e+00f,
        +0.000000000e+00f, +4.769294207e-05f, -4.700808171e-05f, -1.277674190e-04f, +1.002063120e-04f, +2.783555512e-04f, -1.645847664e-04f, -5.338031835e-04f, +2.221340670e-04f, +9.373291153e-04f, -2.390578810e-04f, -1.547169434e-03f, +1.562510821e-04f, +2.456625632e-03f, +1.386575125e-04f, -3.858238810e-03f, -9.205208281e-04f, +6.286692566e-03f, +3.262659615e-03f, -1.201738174e-02f, -1.948702236e-02f, -5.000343093e-03f, +1.559525887e-02f, +1.766283529e-02f, +2.760942598e-03f, -6.928461094e-03f, -2.502548952e-03f, +3.693419733e-03f, +1.958702524e-03f, -2.110578708e-03f, -1.461150555e-03f, +1.203102599e-03f, +1.036201354e-03f, -6.591341691e-04f, -6.897183060e-04f, +3.376565750e-04f, +4.229718227e-04f, -1.576876388e-04f, -2.319653085e-04f, +6.568020226e-05f, +1.072829234e-04f, -2.454257125e-05f, -3.551525150e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.769294207e-05f, +4.700808171e-05f, +1.866147110e-04f, -1.861016712e-04f, -4.034761595e-04f, +4.282141356e-04f, +7.114893926e-04f, -8.176767188e-04f, -1.087586590e-03f, +1.367872721e-03f, +1.483916041e-03f, -2.060186002e-03f, -1.835852403e-03f, +2.838446164e-03f, +2.076766203e-03f, -3.613344933e-03f, -2.155442434e-03f, +4.277369306e-03f, +2.050656220e-03f, -4.727213046e-03f, -1.777991320e-03f, +4.887722949e-03f, +1.386417312e-03f, -4.730384443e-03f, -9.455611626e-04f, +4.280677796e-03f, +5.277348038e-04f, -3.611967365e-03f, -1.904302771e-04f, +2.827765709e-03f, -3.542794466e-05f, -2.037748604e-03f, +1.484504698e-04f, +1.334543715e-03f, -1.711211164e-04f, -7.775662099e-04f, +1.384958074e-04f, +3.874297558e-04f, -8.572907829e-05f, -1.508342662e-04f, +2.454257125e-05f, +3.551525150e-05f, +0.000000000e+00f,
        /*  8, 4 (44) */
        +0.000000000e+00f, -4.006331513e-04f, -6.437526848e-04f, +9.940417215e-04f, +1.718215006e-03f, -1.821707971e-03f, -3.710466456e-03f, +2.772518163e-03f, +7.042040372e-03f, -3.607119833e-03f, -1.224990564e-02f, +3.918043083e-03f, +2.010734157e-02f, -3.045284283e-03f, -3.202056993e-02f, -1.969424922e-04f, +5.142363821e-02f, +8.664972362e-03f, -9.040527678e-02f, -3.439335529e-02f, +2.399176799e-01f, +4.687712885e-01f, +3.828722811e-01f, +8.586501903e-02f, -9.363961465e-02f, -4.576557409e-02f, +4.535848444e-02f, +3.101855915e-02f, -2.475209020e-02f, -2.196158231e-02f, +1.357610321e-02f, +1.533002384e-02f, -7.076060841e-03f, -1.024619382e-02f, +3.334183924e-03f, +6.407475742e-03f, -1.319036018e-03f, -3.648418276e-03f, +3.665127031e-04f, +1.809876508e-03f, -1.724949120e-05f, -7.086075605e-04f, -4.094575428e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.006331513e-04f, +6.437526848e-04f, -1.479124152e-03f, -2.309165128e-03f, +3.476098551e-03f, +4.688439045e-03f, -6.756028420e-03f, -7.925032778e-03f, +1.151345806e-02f, +1.174369890e-02f, -1.769392847e-02f, -1.565536415e-02f, +2.491671758e-02f, +1.904839344e-02f, -3.247356581e-02f, -2.133030867e-02f, +3.942140265e-02f, +2.207891081e-02f, -4.475759113e-02f, -2.115520795e-02f, +4.763662196e-02f, +1.874113933e-02f, -4.756883086e-02f, -1.528945237e-02f, +4.454247079e-02f, +1.140228980e-02f, -3.903134231e-02f, -7.678113066e-03f, +3.188451029e-02f, +4.575018202e-03f, -2.413048356e-02f, -2.329669418e-03f, +1.675299771e-02f, +9.491633768e-04f, -1.050084239e-02f, -2.671720134e-04f, +5.779020827e-03f, +3.567802731e-05f, -2.639439847e-03f, -1.636347006e-05f, +7.086075605e-04f, +4.094575428e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.834410762e-05f, -3.772798779e-05f, -1.306086261e-04f, +7.944665265e-05f, +2.836714180e-04f, -1.242594839e-04f, -5.403279595e-04f, +1.509076622e-04f, +9.408412593e-04f, -1.215496279e-04f, -1.538208371e-03f, -2.851540742e-05f, +2.415925241e-03f, +4.209902531e-04f, -3.744470874e-03f, -1.349604660e-03f, +5.989278435e-03f, +3.923587290e-03f, -1.102898683e-02f, -1.965876471e-02f, -6.381639287e-03f, +1.468064983e-02f, +1.821510479e-02f, +3.767704577e-03f, -6.781491515e-03f, -3.004433560e-03f, +3.522402851e-03f, +2.243453307e-03f, -1.968727041e-03f, -1.627968675e-03f, +1.096305901e-03f, +1.132805076e-03f, -5.843318427e-04f, -7.436542395e-04f, +2.891787024e-04f, +4.515201670e-04f, -1.291681340e-04f, -2.461364923e-04f, +5.102892682e-05f, +1.138711112e-04f, -1.854956279e-05f, -3.842849568e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.834410762e-05f, +3.772798779e-05f, +1.908995503e-04f, -1.526052546e-04f, -4.211106389e-04f, +3.638746578e-04f, +7.551990102e-04f, -7.127823102e-04f, -1.173536764e-03f, +1.216916679e-03f, +1.629154798e-03f, -1.864480710e-03f, -2.054528295e-03f, +2.607366901e-03f, +2.376001048e-03f, -3.363584131e-03f, -2.532048830e-03f, +4.030174318e-03f, +2.489820397e-03f, -4.504240370e-03f, -2.254569416e-03f, +4.706626740e-03f, +1.868750069e-03f, -4.601379392e-03f, -1.400944966e-03f, +4.205021212e-03f, +9.281659166e-04f, -3.582695493e-03f, -5.171517757e-04f, +2.832316186e-03f, +2.103311512e-04f, -2.061556128e-03f, -2.017944628e-05f, +1.364492529e-03f, -6.739694859e-05f, -8.043669378e-04f, +8.304557818e-05f, +4.064584806e-04f, -6.156610171e-05f, -1.615301094e-04f, +1.854956279e-05f, +3.842849568e-05f, +0.000000000e+00f,
        /*  8, 5 (44) */
        +0.000000000e+00f, -3.522890437e-04f, -6.814806726e-04f, +8.634330955e-04f, +1.797661659e-03f, -1.538036552e-03f, -3.834725940e-03f, +2.232190203e-03f, +7.192948034e-03f, -2.666278574e-03f, -1.237145527e-02f, +2.379834711e-03f, +2.007882616e-02f, -6.293590427e-04f, -3.159957967e-02f, -3.941413366e-03f, +5.007403355e-02f, +1.465425080e-02f, -8.648168949e-02f, -4.542234212e-02f, +2.202589152e-01f, +4.623896493e-01f, +3.975529310e-01f, +1.040801238e-01f, -8.987191007e-02f, -5.254706560e-02f, +4.235405088e-02f, +3.454096200e-02f, -2.250863689e-02f, -2.393030935e-02f, +1.194813454e-02f, +1.642632974e-02f, -5.943255765e-03f, -1.083052566e-02f, +2.590529685e-03f, +6.696654445e-03f, -8.675158509e-04f, -3.777586410e-03f, +1.203762108e-04f, +1.860905435e-03f, +9.662161999e-05f, -7.271571233e-04f, -7.937424996e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +3.522890437e-04f, +6.814806726e-04f, -1.288224602e-03f, -2.461770383e-03f, +3.054987912e-03f, +5.052313703e-03f, -6.000829409e-03f, -8.637815088e-03f, +1.033992130e-02f, +1.296061558e-02f, -1.606477367e-02f, -1.751984486e-02f, +2.286218928e-02f, +2.165576034e-02f, -3.009756476e-02f, -2.469389280e-02f, +3.688935382e-02f, +2.610908513e-02f, -4.226777073e-02f, -2.565944832e-02f, +4.538205255e-02f, +2.344776607e-02f, -4.570008079e-02f, -1.989083176e-02f, +4.314152582e-02f, +1.560731101e-02f, -3.810317639e-02f, -1.126080856e-02f, +3.136735851e-02f, +7.407334389e-03f, -2.392015241e-02f, -4.391225546e-03f, +1.673281826e-02f, +2.313655906e-03f, -1.056823934e-02f, -1.071538951e-03f, +5.862066405e-03f, +4.421365079e-04f, -2.701005949e-03f, -1.778935794e-04f, +7.271571233e-04f, +7.937424996e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.839462908e-05f, -2.859485025e-05f, -1.320023646e-04f, +5.885516513e-05f, +2.860756854e-04f, -8.428333986e-05f, -5.416153511e-04f, +8.061603855e-05f, +9.356458443e-04f, -6.397055724e-06f, -1.515590808e-03f, -2.078939901e-04f, +2.354718005e-03f, +6.917080224e-04f, -3.600941485e-03f, -1.753606875e-03f, +5.651013484e-03f, +4.524509575e-03f, -1.001479077e-02f, -1.973265539e-02f, -7.727842011e-03f, +1.368720055e-02f, +1.868807609e-02f, +4.794878850e-03f, -6.569456489e-03f, -3.496554457e-03f, +3.314250424e-03f, +2.516054581e-03f, -1.804773863e-03f, -1.784496961e-03f, +9.762597131e-04f, +1.221704309e-03f, -5.017265645e-04f, -7.923109627e-04f, +2.362580365e-04f, +4.767717013e-04f, -9.822821321e-05f, -2.584781305e-04f, +3.512353509e-05f, +1.196109415e-04f, -1.194062833e-05f, -4.107153860e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.839462908e-05f, +2.859485025e-05f, +1.927900639e-04f, -1.191481753e-04f, -4.335076091e-04f, +2.982175889e-04f, +7.895872538e-04f, -6.037516229e-04f, -1.245131973e-03f, +1.057192249e-03f, +1.754695733e-03f, -1.653540093e-03f, -2.248743779e-03f, +2.353177519e-03f, +2.647531089e-03f, -3.082307693e-03f, -2.879963865e-03f, +3.743717416e-03f, +2.901890653e-03f, -4.236169460e-03f, -2.708037002e-03f, +4.477518245e-03f, +2.333654438e-03f, -4.424887605e-03f, -1.845278111e-03f, +4.085731968e-03f, +1.323558370e-03f, -3.516266209e-03f, -8.436215584e-04f, +2.807688605e-03f, +4.589264150e-04f, -2.064422979e-03f, -1.930026237e-04f, +1.380908477e-03f, +4.048418938e-05f, -8.234949991e-04f, +2.432513126e-05f, +4.218623792e-04f, -3.531111780e-05f, -1.709766679e-04f, +1.194062833e-05f, +4.107153860e-05f, +0.000000000e+00f,
        /*  8, 6 (44) */
        +0.000000000e+00f, -3.038944146e-04f, -7.100755228e-04f, +7.314307309e-04f, +1.856516824e-03f, -1.251960867e-03f, -3.919009279e-03f, +1.690574852e-03f, +7.273564073e-03f, -1.730632730e-03f, -1.237785232e-02f, +8.642439036e-04f, +1.987093217e-02f, +1.725358962e-03f, -3.090787165e-02f, -7.542354851e-03f, +4.832042667e-02f, +2.030526428e-02f, -8.195717992e-02f, -5.543713289e-02f, +2.005262598e-01f, +4.546618072e-01f, +4.112401315e-01f, +1.227681999e-01f, -8.507703122e-02f, -5.911652209e-02f, +3.885749643e-02f, +3.785521243e-02f, -1.999258231e-02f, -2.573508321e-02f, +1.016363758e-02f, +1.740258945e-02f, -4.721551456e-03f, -1.133225222e-02f, +1.798218722e-03f, +6.932912481e-03f, -3.907441495e-04f, -3.875814623e-03f, -1.381019197e-04f, +1.896028970e-03f, +2.162325615e-04f, -7.390977517e-04f, -1.204457886e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.038944146e-04f, +7.100755228e-04f, -1.095434538e-03f, -2.580918558e-03f, +2.621480303e-03f, +5.350531292e-03f, -5.211242156e-03f, -9.241566711e-03f, +9.094789324e-03f, +1.401780783e-02f, -1.431007794e-02f, -1.917338496e-02f, +2.061344550e-02f, +2.400893786e-02f, -2.745003367e-02f, -2.777620049e-02f, +3.400938995e-02f, +2.985280254e-02f, -3.936588008e-02f, -2.989561778e-02f, +4.267401554e-02f, +2.792528431e-02f, -4.336642635e-02f, -2.431571937e-02f, +4.129624771e-02f, +1.969304298e-02f, -3.677961802e-02f, -1.477707477e-02f, +3.052373695e-02f, +1.021502299e-02f, -2.346122599e-02f, -6.455648525e-03f, +1.653981564e-02f, +3.694564383e-03f, -1.052775515e-02f, -1.895033950e-03f, +5.886391536e-03f, +8.639988871e-04f, -2.736317066e-03f, -3.488702474e-04f, +7.390977517e-04f, +1.204457886e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.788116752e-05f, -1.969985019e-05f, -1.320045167e-04f, +3.862912484e-05f, +2.856612353e-04f, -4.502470736e-05f, -5.378327322e-04f, +1.188374152e-05f, +9.220562475e-04f, +1.054137594e-04f, -1.479906409e-03f, -3.804142822e-04f, +2.274109596e-03f, +9.487336002e-04f, -3.429746212e-03f, -2.129837364e-03f, +5.276030544e-03f, +5.063230652e-03f, -8.981622363e-03f, -1.970963860e-02f, -9.031633674e-03f, +1.261988750e-02f, +1.907750995e-02f, +5.836317008e-03f, -6.291628868e-03f, -3.974347229e-03f, +3.069687240e-03f, +2.773696116e-03f, -1.619597138e-03f, -1.929002754e-03f, +8.437041567e-04f, +1.301839163e-03f, -4.118622482e-04f, -8.350541189e-04f, +1.792548715e-04f, +4.983588199e-04f, -6.508101615e-05f, -2.687855997e-04f, +1.807187045e-05f, +1.243938803e-04f, -4.756703036e-06f, -4.339035843e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.788116752e-05f, +1.969985019e-05f, +1.923991367e-04f, -8.610414198e-05f, -4.407562983e-04f, +2.319978392e-04f, +8.146046105e-04f, -4.918548230e-04f, -1.302011596e-03f, +8.905679790e-04f, +1.859660446e-03f, -1.429825661e-03f, -2.416904238e-03f, +2.078818033e-03f, +2.888908036e-03f, -2.772716986e-03f, -3.195857155e-03f, +3.421176404e-03f, +3.282762717e-03f, -3.925857803e-03f, -3.133756888e-03f, +4.202687952e-03f, +2.776296846e-03f, -4.202486263e-03f, -2.273900699e-03f, +3.923652468e-03f, +1.709759111e-03f, -3.412883114e-03f, -1.166429934e-03f, +2.753625988e-03f, +7.077976662e-04f, -2.045841319e-03f, -3.682833568e-04f, +1.383223723e-03f, +1.514835683e-04f, -8.344585772e-04f, -3.714043133e-05f, +4.332927888e-04f, -7.165599053e-06f, -1.789741028e-04f, +4.756703036e-06f, +4.339035843e-05f, +0.000000000e+00f,
        /*  8, 7 (44) */
        +0.000000000e+00f, -2.560132471e-04f, -7.297753730e-04f, +5.994262142e-04f, +1.895145949e-03f, -9.662996318e-04f, -3.964033987e-03f, +1.152742120e-03f, +7.285447814e-03f, -8.085764820e-04f, -1.227243856e-02f, -6.156625050e-04f, +1.949051789e-02f, +3.999468559e-03f, -2.995913805e-02f, -1.097210106e-02f, +4.619058931e-02f, +2.558129482e-02f, -7.689394926e-02f, -6.441875526e-02f, +1.808166212e-01f, +4.456301736e-01f, +4.238600190e-01f, +1.418457099e-01f, -7.924071421e-02f, -6.540815096e-02f, +3.488314920e-02f, +4.092489967e-02f, -1.721888619e-02f, -2.735468035e-02f, +8.234634824e-03f, +1.824629361e-02f, -3.419712293e-03f, -1.174411447e-02f, +9.631646030e-04f, +7.112167352e-03f, +1.076146704e-04f, -3.940895639e-03f, -4.068875194e-04f, +1.914100841e-03f, +3.406264418e-04f, -7.438544547e-04f, -1.638361470e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.560132471e-04f, +7.297753730e-04f, -9.030354009e-04f, -2.667022700e-03f, +2.180724004e-03f, +5.582529131e-03f, -4.396637545e-03f, -9.733421534e-03f, +7.792777728e-03f, +1.490837581e-02f, -1.245041749e-02f, -2.060321062e-02f, +1.819654127e-02f, +2.608775589e-02f, -2.456112564e-02f, -3.054891748e-02f, +3.081353280e-02f, +3.327397895e-02f, -3.608311736e-02f, -3.382147558e-02f, +3.954025866e-02f, +3.212797226e-02f, -4.059012951e-02f, -2.851820563e-02f, +3.902234701e-02f, +2.361669545e-02f, -3.506985891e-02f, -1.818995788e-02f, +2.935730702e-02f, +1.296864898e-02f, -2.275342833e-02f, -8.501489845e-03f, +1.617153228e-02f, +5.077788106e-03f, -1.037627158e-02f, -2.729492528e-03f, +5.849251105e-03f, +1.297291676e-03f, -2.743482666e-03f, -5.278443502e-04f, +7.438544547e-04f, +1.638361470e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.684513548e-05f, -1.112692396e-05f, -1.306830424e-04f, +1.895381149e-05f, +2.825452050e-04f, -6.831782675e-06f, -5.291902169e-04f, -5.469910617e-05f, +9.004546514e-04f, +2.129558393e-04f, -1.431847895e-03f, -5.447075985e-04f, +2.175349606e-03f, +1.190165848e-03f, -3.233162014e-03f, -2.475914239e-03f, +4.868626925e-03f, +5.538047177e-03f, -7.936312500e-03f, -1.959126004e-02f, -1.028597968e-02f, +1.148417486e-02f, +1.937965128e-02f, +6.885646455e-03f, -5.947751127e-03f, -4.433227450e-03f, +2.789775403e-03f, +3.013623114e-03f, -1.414291854e-03f, -2.059816660e-03f, +6.995166794e-04f, +1.372201893e-03f, -3.153682513e-04f, -8.712864337e-04f, +1.185813556e-04f, +5.159372326e-04f, -2.997013018e-05f, -2.768669074e-04f, -1.080557890e-09f, +1.281167300e-04f, +2.952157736e-06f, -4.533196465e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.684513548e-05f, +1.112692396e-05f, +1.898612599e-04f, -5.382456666e-05f, -4.430000117e-04f, +1.659485128e-04f, +8.303046957e-04f, -3.783550747e-04f, -1.343980885e-03f, +7.189409073e-04f, +1.943405127e-03f, -1.195886599e-03f, -2.557712845e-03f, +1.787396621e-03f, +3.098026373e-03f, -2.438274842e-03f, -3.476757284e-03f, +3.066083240e-03f, +3.628673365e-03f, -3.576593616e-03f, -3.527382605e-03f, +3.884903787e-03f, +3.192060310e-03f, -3.936238367e-03f, -2.682284826e-03f, +3.720080067e-03f, +2.082666591e-03f, -3.273141382e-03f, -1.482154510e-03f, +2.670179440e-03f, +9.543311124e-04f, -2.005522523e-03f, -5.442155608e-04f, +1.371008737e-03f, +2.644949693e-04f, -8.368403219e-04f, -1.007734610e-04f, +4.404323169e-04f, +2.263539879e-05f, -1.853297907e-04f, -2.952157736e-06f, +4.533196465e-05f, +0.000000000e+00f,
        /*  8, 8 (44) */
        +0.000000000e+00f, -2.091681116e-04f, -7.409022970e-04f, +4.687431718e-04f, +1.914099760e-03f, -6.837544268e-04f, -3.970865769e-03f, +6.235519031e-04f, +7.230748708e-03f, +9.187816936e-05f, -1.205948272e-02f, -2.047510400e-03f, +1.894581029e-02f, +6.174818164e-03f, -2.876897220e-02f, -1.420526308e-02f, +4.371467507e-02f, +3.044992175e-02f, -7.135590209e-02f, -7.235506776e-02f, +1.612253611e-01f, +4.353441939e-01f, +4.353441939e-01f, +1.612253611e-01f, -7.235506776e-02f, -7.135590209e-02f, +3.044992175e-02f, +4.371467507e-02f, -1.420526308e-02f, -2.876897220e-02f, +6.174818164e-03f, +1.894581029e-02f, -2.047510400e-03f, -1.205948272e-02f, +9.187816936e-05f, +7.230748708e-03f, +6.235519031e-04f, -3.970865769e-03f, -6.837544268e-04f, +1.914099760e-03f, +4.687431718e-04f, -7.409022970e-04f, -2.091681116e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.091681116e-04f, +7.409022970e-04f, -7.131741410e-04f, -2.720847267e-03f, +1.737723993e-03f, +5.748477644e-03f, -3.566332849e-03f, -1.011177661e-02f, +6.448796843e-03f, +1.562731672e-02f, -1.050701237e-02f, -2.179909722e-02f, +1.563882842e-02f, +2.787515251e-02f, -2.146309926e-02f, -3.298719232e-02f, +2.733677551e-02f, +3.634006219e-02f, -3.245444399e-02f, -3.739806920e-02f, +3.601287605e-02f, +3.601287605e-02f, -3.739806920e-02f, -3.245444399e-02f, +3.634006219e-02f, +2.733677551e-02f, -3.298719232e-02f, -2.146309926e-02f, +2.787515251e-02f, +1.563882842e-02f, -2.179909722e-02f, -1.050701237e-02f, +1.562731672e-02f, +6.448796843e-03f, -1.011177661e-02f, -3.566332849e-03f, +5.748477644e-03f, +1.737723993e-03f, -2.720847267e-03f, -7.131741410e-04f, +7.409022970e-04f, +2.091681116e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.533196465e-05f, -2.952157736e-06f, -1.281167300e-04f, +1.080557890e-09f, +2.768669074e-04f, +2.997013018e-05f, -5.159372326e-04f, -1.185813556e-04f, +8.712864337e-04f, +3.153682513e-04f, -1.372201893e-03f, -6.995166794e-04f, +2.059816660e-03f, +1.414291854e-03f, -3.013623114e-03f, -2.789775403e-03f, +4.433227450e-03f, +5.947751127e-03f, -6.885646455e-03f, -1.937965128e-02f, -1.148417486e-02f, +1.028597968e-02f, +1.959126004e-02f, +7.936312500e-03f, -5.538047177e-03f, -4.868626925e-03f, +2.475914239e-03f, +3.233162014e-03f, -1.190165848e-03f, -2.175349606e-03f, +5.447075985e-04f, +1.431847895e-03f, -2.129558393e-04f, -9.004546514e-04f, +5.469910617e-05f, +5.291902169e-04f, +6.831782675e-06f, -2.825452050e-04f, -1.895381149e-05f, +1.306830424e-04f, +1.112692396e-05f, -4.684513548e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.533196465e-05f, +2.952157736e-06f, +1.853297907e-04f, -2.263539879e-05f, -4.404323169e-04f, +1.007734610e-04f, +8.368403219e-04f, -2.644949693e-04f, -1.371008737e-03f, +5.442155608e-04f, +2.005522523e-03f, -9.543311124e-04f, -2.670179440e-03f, +1.482154510e-03f, +3.273141382e-03f, -2.082666591e-03f, -3.720080067e-03f, +2.682284826e-03f, +3.936238367e-03f, -3.192060310e-03f, -3.884903787e-03f, +3.527382605e-03f, +3.576593616e-03f, -3.628673365e-03f, -3.066083240e-03f, +3.476757284e-03f, +2.438274842e-03f, -3.098026373e-03f, -1.787396621e-03f, +2.557712845e-03f, +1.195886599e-03f, -1.943405127e-03f, -7.189409073e-04f, +1.343980885e-03f, +3.783550747e-04f, -8.303046957e-04f, -1.659485128e-04f, +4.430000117e-04f, +5.382456666e-05f, -1.898612599e-04f, -1.112692396e-05f, +4.684513548e-05f, +0.000000000e+00f,
        /*  8, 9 (44) */
        +0.000000000e+00f, -1.638361470e-04f, -7.438544547e-04f, +3.406264418e-04f, +1.914100841e-03f, -4.068875194e-04f, -3.940895639e-03f, +1.076146704e-04f, +7.112167352e-03f, +9.631646030e-04f, -1.174411447e-02f, -3.419712293e-03f, +1.824629361e-02f, +8.234634824e-03f, -2.735468035e-02f, -1.721888619e-02f, +4.092489967e-02f, +3.488314920e-02f, -6.540815096e-02f, -7.924071421e-02f, +1.418457099e-01f, +4.238600190e-01f, +4.456301736e-01f, +1.808166212e-01f, -6.441875526e-02f, -7.689394926e-02f, +2.558129482e-02f, +4.619058931e-02f, -1.097210106e-02f, -2.995913805e-02f, +3.999468559e-03f, +1.949051789e-02f, -6.156625050e-04f, -1.227243856e-02f, -8.085764820e-04f, +7.285447814e-03f, +1.152742120e-03f, -3.964033987e-03f, -9.662996318e-04f, +1.895145949e-03f, +5.994262142e-04f, -7.297753730e-04f, -2.560132471e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.638361470e-04f, +7.438544547e-04f, -5.278443502e-04f, -2.743482666e-03f, +1.297291676e-03f, +5.849251105e-03f, -2.729492528e-03f, -1.037627158e-02f, +5.077788106e-03f, +1.617153228e-02f, -8.501489845e-03f, -2.275342833e-02f, +1.296864898e-02f, +2.935730702e-02f, -1.818995788e-02f, -3.506985891e-02f, +2.361669545e-02f, +3.902234701e-02f, -2.851820563e-02f, -4.059012951e-02f, +3.212797226e-02f, +3.954025866e-02f, -3.382147558e-02f, -3.608311736e-02f, +3.327397895e-02f, +3.081353280e-02f, -3.054891748e-02f, -2.456112564e-02f, +2.608775589e-02f, +1.819654127e-02f, -2.060321062e-02f, -1.245041749e-02f, +1.490837581e-02f, +7.792777728e-03f, -9.733421534e-03f, -4.396637545e-03f, +5.582529131e-03f, +2.180724004e-03f, -2.667022700e-03f, -9.030354009e-04f, +7.297753730e-04f, +2.560132471e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.339035843e-05f, +4.756703036e-06f, -1.243938803e-04f, -1.807187045e-05f, +2.687855997e-04f, +6.508101615e-05f, -4.983588199e-04f, -1.792548715e-04f, +8.350541189e-04f, +4.118622482e-04f, -1.301839163e-03f, -8.437041567e-04f, +1.929002754e-03f, +1.619597138e-03f, -2.773696116e-03f, -3.069687240e-03f, +3.974347229e-03f, +6.291628868e-03f, -5.836317008e-03f, -1.907750995e-02f, -1.261988750e-02f, +9.031633674e-03f, +1.970963860e-02f, +8.981622363e-03f, -5.063230652e-03f, -5.276030544e-03f, +2.129837364e-03f, +3.429746212e-03f, -9.487336002e-04f, -2.274109596e-03f, +3.804142822e-04f, +1.479906409e-03f, -1.054137594e-04f, -9.220562475e-04f, -1.188374152e-05f, +5.378327322e-04f, +4.502470736e-05f, -2.856612353e-04f, -3.862912484e-05f, +1.320045167e-04f, +1.969985019e-05f, -4.788116752e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.339035843e-05f, -4.756703036e-06f, +1.789741028e-04f, +7.165599053e-06f, -4.332927888e-04f, +3.714043133e-05f, +8.344585772e-04f, -1.514835683e-04f, -1.383223723e-03f, +3.682833568e-04f, +2.045841319e-03f, -7.077976662e-04f, -2.753625988e-03f, +1.166429934e-03f, +3.412883114e-03f, -1.709759111e-03f, -3.923652468e-03f, +2.273900699e-03f, +4.202486263e-03f, -2.776296846e-03f, -4.202687952e-03f, +3.133756888e-03f, +3.925857803e-03f, -3.282762717e-03f, -3.421176404e-03f, +3.195857155e-03f, +2.772716986e-03f, -2.888908036e-03f, -2.078818033e-03f, +2.416904238e-03f, +1.429825661e-03f, -1.859660446e-03f, -8.905679790e-04f, +1.302011596e-03f, +4.918548230e-04f, -8.146046105e-04f, -2.319978392e-04f, +4.407562983e-04f, +8.610414198e-05f, -1.923991367e-04f, -1.969985019e-05f, +4.788116752e-05f, +0.000000000e+00f,
        /*  8,10 (44) */
        +0.000000000e+00f, -1.204457886e-04f, -7.390977517e-04f, +2.162325615e-04f, +1.896028970e-03f, -1.381019197e-04f, -3.875814623e-03f, -3.907441495e-04f, +6.932912481e-03f, +1.798218722e-03f, -1.133225222e-02f, -4.721551456e-03f, +1.740258945e-02f, +1.016363758e-02f, -2.573508321e-02f, -1.999258231e-02f, +3.785521243e-02f, +3.885749643e-02f, -5.911652209e-02f, -8.507703122e-02f, +1.227681999e-01f, +4.112401315e-01f, +4.546618072e-01f, +2.005262598e-01f, -5.543713289e-02f, -8.195717992e-02f, +2.030526428e-02f, +4.832042667e-02f, -7.542354851e-03f, -3.090787165e-02f, +1.725358962e-03f, +1.987093217e-02f, +8.642439036e-04f, -1.237785232e-02f, -1.730632730e-03f, +7.273564073e-03f, +1.690574852e-03f, -3.919009279e-03f, -1.251960867e-03f, +1.856516824e-03f, +7.314307309e-04f, -7.100755228e-04f, -3.038944146e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.204457886e-04f, +7.390977517e-04f, -3.488702474e-04f, -2.736317066e-03f, +8.639988871e-04f, +5.886391536e-03f, -1.895033950e-03f, -1.052775515e-02f, +3.694564383e-03f, +1.653981564e-02f, -6.455648525e-03f, -2.346122599e-02f, +1.021502299e-02f, +3.052373695e-02f, -1.477707477e-02f, -3.677961802e-02f, +1.969304298e-02f, +4.129624771e-02f, -2.431571937e-02f, -4.336642635e-02f, +2.792528431e-02f, +4.267401554e-02f, -2.989561778e-02f, -3.936588008e-02f, +2.985280254e-02f, +3.400938995e-02f, -2.777620049e-02f, -2.745003367e-02f, +2.400893786e-02f, +2.061344550e-02f, -1.917338496e-02f, -1.431007794e-02f, +1.401780783e-02f, +9.094789324e-03f, -9.241566711e-03f, -5.211242156e-03f, +5.350531292e-03f, +2.621480303e-03f, -2.580918558e-03f, -1.095434538e-03f, +7.100755228e-04f, +3.038944146e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.107153860e-05f, +1.194062833e-05f, -1.196109415e-04f, -3.512353509e-05f, +2.584781305e-04f, +9.822821321e-05f, -4.767717013e-04f, -2.362580365e-04f, +7.923109627e-04f, +5.017265645e-04f, -1.221704309e-03f, -9.762597131e-04f, +1.784496961e-03f, +1.804773863e-03f, -2.516054581e-03f, -3.314250424e-03f, +3.496554457e-03f, +6.569456489e-03f, -4.794878850e-03f, -1.868807609e-02f, -1.368720055e-02f, +7.727842011e-03f, +1.973265539e-02f, +1.001479077e-02f, -4.524509575e-03f, -5.651013484e-03f, +1.753606875e-03f, +3.600941485e-03f, -6.917080224e-04f, -2.354718005e-03f, +2.078939901e-04f, +1.515590808e-03f, +6.397055724e-06f, -9.356458443e-04f, -8.061603855e-05f, +5.416153511e-04f, +8.428333986e-05f, -2.860756854e-04f, -5.885516513e-05f, +1.320023646e-04f, +2.859485025e-05f, -4.839462908e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.107153860e-05f, -1.194062833e-05f, +1.709766679e-04f, +3.531111780e-05f, -4.218623792e-04f, -2.432513126e-05f, +8.234949991e-04f, -4.048418938e-05f, -1.380908477e-03f, +1.930026237e-04f, +2.064422979e-03f, -4.589264150e-04f, -2.807688605e-03f, +8.436215584e-04f, +3.516266209e-03f, -1.323558370e-03f, -4.085731968e-03f, +1.845278111e-03f, +4.424887605e-03f, -2.333654438e-03f, -4.477518245e-03f, +2.708037002e-03f, +4.236169460e-03f, -2.901890653e-03f, -3.743717416e-03f, +2.879963865e-03f, +3.082307693e-03f, -2.647531089e-03f, -2.353177519e-03f, +2.248743779e-03f, +1.653540093e-03f, -1.754695733e-03f, -1.057192249e-03f, +1.245131973e-03f, +6.037516229e-04f, -7.895872538e-04f, -2.982175889e-04f, +4.335076091e-04f, +1.191481753e-04f, -1.927900639e-04f, -2.859485025e-05f, +4.839462908e-05f, +0.000000000e+00f,
        /*  8,11 (44) */
        +0.000000000e+00f, -7.937424996e-05f, -7.271571233e-04f, +9.662161999e-05f, +1.860905435e-03f, +1.203762108e-04f, -3.777586410e-03f, -8.675158509e-04f, +6.696654445e-03f, +2.590529685e-03f, -1.083052566e-02f, -5.943255765e-03f, +1.642632974e-02f, +1.194813454e-02f, -2.393030935e-02f, -2.250863689e-02f, +3.454096200e-02f, +4.235405088e-02f, -5.254706560e-02f, -8.987191007e-02f, +1.040801238e-01f, +3.975529310e-01f, +4.623896493e-01f, +2.202589152e-01f, -4.542234212e-02f, -8.648168949e-02f, +1.465425080e-02f, +5.007403355e-02f, -3.941413366e-03f, -3.159957967e-02f, -6.293590427e-04f, +2.007882616e-02f, +2.379834711e-03f, -1.237145527e-02f, -2.666278574e-03f, +7.192948034e-03f, +2.232190203e-03f, -3.834725940e-03f, -1.538036552e-03f, +1.797661659e-03f, +8.634330955e-04f, -6.814806726e-04f, -3.522890437e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +7.937424996e-05f, +7.271571233e-04f, -1.778935794e-04f, -2.701005949e-03f, +4.421365079e-04f, +5.862066405e-03f, -1.071538951e-03f, -1.056823934e-02f, +2.313655906e-03f, +1.673281826e-02f, -4.391225546e-03f, -2.392015241e-02f, +7.407334389e-03f, +3.136735851e-02f, -1.126080856e-02f, -3.810317639e-02f, +1.560731101e-02f, +4.314152582e-02f, -1.989083176e-02f, -4.570008079e-02f, +2.344776607e-02f, +4.538205255e-02f, -2.565944832e-02f, -4.226777073e-02f, +2.610908513e-02f, +3.688935382e-02f, -2.469389280e-02f, -3.009756476e-02f, +2.165576034e-02f, +2.286218928e-02f, -1.751984486e-02f, -1.606477367e-02f, +1.296061558e-02f, +1.033992130e-02f, -8.637815088e-03f, -6.000829409e-03f, +5.052313703e-03f, +3.054987912e-03f, -2.461770383e-03f, -1.288224602e-03f, +6.814806726e-04f, +3.522890437e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.842849568e-05f, +1.854956279e-05f, -1.138711112e-04f, -5.102892682e-05f, +2.461364923e-04f, +1.291681340e-04f, -4.515201670e-04f, -2.891787024e-04f, +7.436542395e-04f, +5.843318427e-04f, -1.132805076e-03f, -1.096305901e-03f, +1.627968675e-03f, +1.968727041e-03f, -2.243453307e-03f, -3.522402851e-03f, +3.004433560e-03f, +6.781491515e-03f, -3.767704577e-03f, -1.821510479e-02f, -1.468064983e-02f, +6.381639287e-03f, +1.965876471e-02f, +1.102898683e-02f, -3.923587290e-03f, -5.989278435e-03f, +1.349604660e-03f, +3.744470874e-03f, -4.209902531e-04f, -2.415925241e-03f, +2.851540742e-05f, +1.538208371e-03f, +1.215496279e-04f, -9.408412593e-04f, -1.509076622e-04f, +5.403279595e-04f, +1.242594839e-04f, -2.836714180e-04f, -7.944665265e-05f, +1.306086261e-04f, +3.772798779e-05f, -4.834410762e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -3.842849568e-05f, -1.854956279e-05f, +1.615301094e-04f, +6.156610171e-05f, -4.064584806e-04f, -8.304557818e-05f, +8.043669378e-04f, +6.739694859e-05f, -1.364492529e-03f, +2.017944628e-05f, +2.061556128e-03f, -2.103311512e-04f, -2.832316186e-03f, +5.171517757e-04f, +3.582695493e-03f, -9.281659166e-04f, -4.205021212e-03f, +1.400944966e-03f, +4.601379392e-03f, -1.868750069e-03f, -4.706626740e-03f, +2.254569416e-03f, +4.504240370e-03f, -2.489820397e-03f, -4.030174318e-03f, +2.532048830e-03f, +3.363584131e-03f, -2.376001048e-03f, -2.607366901e-03f, +2.054528295e-03f, +1.864480710e-03f, -1.629154798e-03f, -1.216916679e-03f, +1.173536764e-03f, +7.127823102e-04f, -7.551990102e-04f, -3.638746578e-04f, +4.211106389e-04f, +1.526052546e-04f, -1.908995503e-04f, -3.772798779e-05f, +4.834410762e-05f, +0.000000000e+00f,
        /*  8,12 (44) */
        +0.000000000e+00f, -4.094575428e-05f, -7.086075605e-04f, -1.724949120e-05f, +1.809876508e-03f, +3.665127031e-04f, -3.648418276e-03f, -1.319036018e-03f, +6.407475742e-03f, +3.334183924e-03f, -1.024619382e-02f, -7.076060841e-03f, +1.533002384e-02f, +1.357610321e-02f, -2.196158231e-02f, -2.475209020e-02f, +3.101855915e-02f, +4.535848444e-02f, -4.576557409e-02f, -9.363961465e-02f, +8.586501903e-02f, +3.828722811e-01f, +4.687712885e-01f, +2.399176799e-01f, -3.439335529e-02f, -9.040527678e-02f, +8.664972362e-03f, +5.142363821e-02f, -1.969424922e-04f, -3.202056993e-02f, -3.045284283e-03f, +2.010734157e-02f, +3.918043083e-03f, -1.224990564e-02f, -3.607119833e-03f, +7.042040372e-03f, +2.772518163e-03f, -3.710466456e-03f, -1.821707971e-03f, +1.718215006e-03f, +9.940417215e-04f, -6.437526848e-04f, -4.006331513e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.094575428e-05f, +7.086075605e-04f, -1.636347006e-05f, -2.639439847e-03f, +3.567802731e-05f, +5.779020827e-03f, -2.671720134e-04f, -1.050084239e-02f, +9.491633768e-04f, +1.675299771e-02f, -2.329669418e-03f, -2.413048356e-02f, +4.575018202e-03f, +3.188451029e-02f, -7.678113066e-03f, -3.903134231e-02f, +1.140228980e-02f, +4.454247079e-02f, -1.528945237e-02f, -4.756883086e-02f, +1.874113933e-02f, +4.763662196e-02f, -2.115520795e-02f, -4.475759113e-02f, +2.207891081e-02f, +3.942140265e-02f, -2.133030867e-02f, -3.247356581e-02f, +1.904839344e-02f, +2.491671758e-02f, -1.565536415e-02f, -1.769392847e-02f, +1.174369890e-02f, +1.151345806e-02f, -7.925032778e-03f, -6.756028420e-03f, +4.688439045e-03f, +3.476098551e-03f, -2.309165128e-03f, -1.479124152e-03f, +6.437526848e-04f, +4.006331513e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.551525150e-05f, +2.454257125e-05f, -1.072829234e-04f, -6.568020226e-05f, +2.319653085e-04f, +1.576876388e-04f, -4.229718227e-04f, -3.376565750e-04f, +6.897183060e-04f, +6.591341691e-04f, -1.036201354e-03f, -1.203102599e-03f, +1.461150555e-03f, +2.110578708e-03f, -1.958702524e-03f, -3.693419733e-03f, +2.502548952e-03f, +6.928461094e-03f, -2.760942598e-03f, -1.766283529e-02f, -1.559525887e-02f, +5.000343093e-03f, +1.948702236e-02f, +1.201738174e-02f, -3.262659615e-03f, -6.286692566e-03f, +9.205208281e-04f, +3.858238810e-03f, -1.386575125e-04f, -2.456625632e-03f, -1.562510821e-04f, +1.547169434e-03f, +2.390578810e-04f, -9.373291153e-04f, -2.221340670e-04f, +5.338031835e-04f, +1.645847664e-04f, -2.783555512e-04f, -1.002063120e-04f, +1.277674190e-04f, +4.700808171e-05f, -4.769294207e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -3.551525150e-05f, -2.454257125e-05f, +1.508342662e-04f, +8.572907829e-05f, -3.874297558e-04f, -1.384958074e-04f, +7.775662099e-04f, +1.711211164e-04f, -1.334543715e-03f, -1.484504698e-04f, +2.037748604e-03f, +3.542794466e-05f, -2.827765709e-03f, +1.904302771e-04f, +3.611967365e-03f, -5.277348038e-04f, -4.280677796e-03f, +9.455611626e-04f, +4.730384443e-03f, -1.386417312e-03f, -4.887722949e-03f, +1.777991320e-03f, +4.727213046e-03f, -2.050656220e-03f, -4.277369306e-03f, +2.155442434e-03f, +3.613344933e-03f, -2.076766203e-03f, -2.838446164e-03f, +1.835852403e-03f, +2.060186002e-03f, -1.483916041e-03f, -1.367872721e-03f, +1.087586590e-03f, +8.176767188e-04f, -7.114893926e-04f, -4.282141356e-04f, +4.034761595e-04f, +1.861016712e-04f, -1.866147110e-04f, -4.700808171e-05f, +4.769294207e-05f, +0.000000000e+00f,
        /*  8,13 (44) */
        +0.000000000e+00f, -5.430502781e-06f, -6.840649893e-04f, -1.245324146e-04f, +1.744196306e-03f, +5.984780117e-04f, -3.490730637e-03f, -1.742007841e-03f, +6.069819167e-03f, +4.023902230e-03f, -9.587059646e-03f, -8.112262196e-03f, +1.412692124e-02f, +1.503725377e-02f, -1.985100360e-02f, -2.671079272e-02f, +2.732513942e-02f, +4.786103340e-02f, -3.883711299e-02f, -9.640055725e-02f, +6.820218374e-02f, +3.672770223e-01f, +4.737716316e-01f, +2.594047022e-01f, -2.237597355e-02f, -9.366793640e-02f, +2.378279796e-03f, +5.234415903e-02f, +3.661296318e-03f, -3.215922744e-02f, -5.501909915e-03f, +1.995109049e-02f, +5.465212517e-03f, -1.201084776e-02f, -4.544448948e-03f, +6.819906305e-03f, +3.306321346e-03f, -3.545881689e-03f, -2.100063522e-03f, +1.618008694e-03f, +1.121809141e-03f, -5.967446031e-04f, -4.483260934e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.430502781e-06f, +6.840649893e-04f, +1.344707961e-04f, -2.553710769e-03f, -3.517517285e-04f, +5.640525020e-03f, +5.103941965e-04f, -1.032972127e-02f, -3.853803383e-04f, +1.660454724e-02f, -2.919208143e-04f, -2.409505562e-02f, +1.747252493e-03f, +3.207494056e-02f, -4.066145701e-03f, -3.955907711e-02f, +7.121612003e-03f, +4.548803195e-02f, -1.055906793e-02f, -4.895524817e-02f, +1.385341638e-02f, +4.941461328e-02f, -1.642799490e-02f, -4.680824735e-02f, +1.780154150e-02f, +4.157684508e-02f, -1.771696373e-02f, -3.455033201e-02f, +1.620994727e-02f, +2.675256998e-02f, -1.359517815e-02f, -1.917784451e-02f, +1.037582618e-02f, +1.260104465e-02f, -7.107356059e-03f, -7.467517812e-03f, +4.260224910e-03f, +3.879574710e-03f, -2.123063457e-03f, -1.665738863e-03f, +5.967446031e-04f, +4.483260934e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.238614251e-05f, +2.988787338e-05f, -9.995883490e-05f, -7.898707982e-05f, +2.161792827e-04f, +1.836050578e-04f, -3.915132464e-04f, -3.813850264e-04f, +6.311675135e-04f, +7.256777112e-04f, -9.329939847e-04f, -1.296050107e-03f, +1.285821334e-03f, +2.229670092e-03f, -1.664642242e-03f, -3.826910903e-03f, +1.995409702e-03f, +7.011546824e-03f, -1.780477243e-03f, -1.703595698e-02f, -1.642657021e-02f, +3.591505477e-03f, +1.921709714e-02f, +1.297319719e-02f, -2.544408182e-03f, -6.539323918e-03f, +4.693393252e-04f, +3.940354256e-03f, +1.530509239e-04f, -2.475871378e-03f, -3.448443249e-04f, +1.541995804e-03f, +3.578843506e-04f, -9.248699457e-04f, -2.936413168e-04f, +5.219194978e-04f, +2.048736546e-04f, -2.700613610e-04f, -1.209264873e-04f, +1.234361062e-04f, +5.633742412e-05f, -4.640993010e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -3.238614251e-05f, -2.988787338e-05f, +1.390933055e-04f, +1.076330211e-04f, -3.651508023e-04f, -1.902072397e-04f, +7.436511503e-04f, +2.697264117e-04f, -1.291758293e-03f, -3.112387393e-04f, +1.993717300e-03f, +2.758704644e-04f, -2.794594309e-03f, -1.331817181e-04f, +3.604266988e-03f, -1.264254265e-04f, -4.312319161e-03f, +4.838688553e-04f, +4.810825532e-03f, -8.916550208e-04f, -5.019017235e-03f, +1.283182136e-03f, +4.902691787e-03f, -1.588801705e-03f, -4.482514405e-03f, +1.753801711e-03f, +3.828686751e-03f, -1.752595690e-03f, -3.043677248e-03f, +1.594596247e-03f, +2.238310358e-03f, -1.320087845e-03f, -1.508241484e-03f, +9.878083628e-04f, +9.171717255e-04f, -6.586139036e-04f, -4.904672768e-04f, +3.805723284e-04f, +2.192450057e-04f, -1.798468566e-04f, -5.633742412e-05f, +4.640993010e-05f, +0.000000000e+00f,
        /*  8,14 (44) */
        +0.000000000e+00f, +2.695563973e-05f, -6.541771159e-04f, -2.244912495e-04f, +1.665209226e-03f, +8.146572943e-04f, -3.307125579e-03f, -2.133521087e-03f, +5.688434141e-03f, +4.655069744e-03f, -8.861381935e-03f, -9.045256180e-03f, +1.283087113e-02f, +1.632307510e-02f, -1.762133351e-02f, -2.837543496e-02f, +2.349822851e-02f, +4.985644310e-02f, -3.182556617e-02f, -9.818103449e-02f, +5.116622676e-02f, +3.508504521e-01f, +4.773631371e-01f, +2.786217994e-01f, -9.402776357e-03f, -9.621234458e-02f, -4.161044122e-03f, +5.281349836e-02f, +7.601650574e-03f, -3.200617651e-02f, -7.977781293e-03f, +1.960624616e-02f, +7.007208321e-03f, -1.165296341e-02f, -5.469318894e-03f, +6.526264988e-03f, +3.828240844e-03f, -3.341008035e-03f, -2.370124883e-03f, +1.497082207e-03f, +1.245245247e-03f, -5.404071790e-04f, -4.947360235e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -2.695563973e-05f, +6.541771159e-04f, +2.735641016e-04f, -2.446077748e-03f, -7.169025308e-04f, +5.450317780e-03f, +1.254045347e-03f, -1.005999486e-02f, -1.677138632e-03f, +1.629330850e-02f, +1.701796486e-03f, -2.381918515e-02f, -1.047341816e-03f, +3.194175885e-02f, -4.618787135e-04f, -3.968550254e-02f, +2.809292843e-03f, +4.597190081e-02f, -5.748242393e-03f, -4.984690319e-02f, +8.834399142e-03f, +5.069779542e-02f, -1.152530311e-02f, -4.839704905e-02f, +1.331902710e-02f, +4.333064679e-02f, -1.388827698e-02f, -3.630292770e-02f, +1.316627002e-02f, +2.834716623e-02f, -1.135686779e-02f, -2.049793236e-02f, +8.867584699e-03f, +1.358885301e-02f, -6.190184334e-03f, -8.126131716e-03f, +3.769757633e-03f, +4.260147039e-03f, -1.903818451e-03f, -1.845585719e-03f, +5.404071790e-04f, +4.947360235e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.909513156e-05f, +3.456277161e-05f, -9.201382764e-05f, -9.087705687e-05f, +1.990006381e-04f, +2.067708630e-04f, -3.575455993e-04f, -4.201123347e-04f, +5.686890412e-04f, +7.835964559e-04f, -8.243134910e-04f, -1.374690872e-03f, +1.103788633e-03f, +2.325561793e-03f, -1.364116952e-03f, -3.922815420e-03f, +1.487435369e-03f, +7.032366365e-03f, -8.318913589e-04f, -1.633957237e-02f, -1.717067280e-02f, +2.162862672e-03f, +1.884927793e-02f, +1.388975381e-02f, -1.771989956e-03f, -6.743476916e-03f, -6.792324100e-07f, +3.989152634e-03f, +4.517495490e-04f, -2.472885404e-03f, -5.356244570e-04f, +1.522328357e-03f, +4.769486025e-04f, -9.033027300e-04f, -3.647515618e-04f, +5.046039744e-04f, +2.447267536e-04f, -2.587499785e-04f, -1.413909328e-04f, +1.175863630e-04f, +6.561260708e-05f, -4.447000076e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.909513156e-05f, -3.456277161e-05f, +1.265129176e-04f, +1.271457542e-04f, -3.400167222e-04f, -2.377710009e-04f, +7.032381695e-04f, +3.623359676e-04f, -1.236949904e-03f, -4.666398829e-04f, +1.930375961e-03f, +5.086205797e-04f, -2.733648279e-03f, -4.504061946e-04f, +3.560161383e-03f, +2.716382553e-04f, -4.300022554e-03f, +2.064217926e-05f, +4.842134161e-03f, -3.895744136e-04f, -5.099238890e-03f, +7.752124316e-04f, +5.028768897e-03f, -1.108914643e-03f, -4.643243197e-03f, +1.331074280e-03f, +4.007037969e-03f, -1.406553845e-03f, -3.220556109e-03f, +1.332909937e-03f, +2.396651528e-03f, -1.139001349e-03f, -1.636274853e-03f, +8.748938469e-04f, +1.010025620e-03f, -5.968357629e-04f, -5.498599193e-04f, +3.524274318e-04f, +2.516281064e-04f, -1.705338903e-04f, -6.561260708e-05f, +4.447000076e-05f, +0.000000000e+00f,
        /*  8,15 (44) */
        +0.000000000e+00f, +5.605077129e-05f, -6.196143443e-04f, -3.165050772e-04f, +1.574332169e-03f, +1.013657932e-03f, -3.100354716e-03f, -2.491066686e-03f, +5.268321806e-03f, +5.223758785e-03f, -8.077785479e-03f, -9.869569671e-03f, +1.145618026e-02f, +1.742686374e-02f, -1.529577171e-02f, -2.973955191e-02f, +1.957541309e-02f, +5.134387847e-02f, -2.479319980e-02f, -9.901292585e-02f, +3.482665439e-02f, +3.336797793e-01f, +4.795259998e-01f, +2.974710773e-01f, +4.486977456e-03f, -9.798433453e-02f, -1.090452104e-02f, +5.281281913e-02f, +1.159080321e-02f, -3.155442696e-02f, -1.045066670e-02f, +1.907062170e-02f, +8.529536678e-03f, -1.117601480e-02f, -6.372621624e-03f, +6.161513426e-03f, +4.332844818e-03f, -3.096281281e-03f, -2.628874861e-03f, +1.355691274e-03f, +1.362831610e-03f, -4.747945719e-04f, -5.392060243e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -5.605077129e-05f, +6.196143443e-04f, +4.000770192e-04f, -2.318931993e-03f, -1.056919253e-03f, +5.212546779e-03f, +1.957283516e-03f, -9.697658891e-03f, -2.914088535e-03f, +1.582666861e-02f, +3.632172447e-03f, -2.331056457e-02f, -3.780990095e-03f, +3.149135265e-02f, +3.098282669e-03f, -3.941386428e-02f, -1.490729711e-03f, +4.599254299e-02f, -9.061082325e-04f, -5.023647761e-02f, +3.735160252e-03f, +5.147300785e-02f, -6.496534218e-03f, -4.950596369e-02f, +8.675783903e-03f, +4.466172107e-02f, -9.881239015e-03f, -3.770948155e-02f, +9.945713914e-03f, +2.968007616e-02f, -8.960216265e-03f, -2.163693371e-02f, +7.231309846e-03f, +1.446374686e-02f, -5.180158713e-03f, -8.722967479e-03f, +3.219897714e-03f, +4.612574470e-03f, -1.652190345e-03f, -2.016119610e-03f, +4.747945719e-04f, +5.392060243e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.569515524e-05f, +3.855347749e-05f, -8.356404177e-05f, -1.012954305e-04f, +1.806565744e-04f, +2.270679961e-04f, -3.214802361e-04f, -4.536423550e-04f, +5.029857206e-04f, +8.326150558e-04f, -7.113088342e-04f, -1.438709876e-03f, +9.168719580e-04f, +2.398032028e-03f, -1.059950903e-03f, -3.981393558e-03f, +9.829232678e-04f, +6.992952053e-03f, +7.956834231e-05f, -1.557915740e-02f, -1.782422552e-02f, +7.222834590e-04f, +1.838447645e-02f, +1.476051954e-02f, -9.490229708e-04f, -6.895726713e-03f, -4.860173922e-04f, +4.003216328e-03f, +7.549241477e-04f, -2.447072989e-03f, -7.268860082e-04f, +1.487933707e-03f, +5.951362975e-04f, -8.725487992e-04f, -4.347689209e-04f, +4.818346326e-04f, +2.837343586e-04f, -2.444118589e-04f, -1.613767670e-04f, +1.102051290e-04f, +7.472545295e-05f, -4.185484257e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.569515524e-05f, -3.855347749e-05f, +1.132976271e-04f, +1.441699117e-04f, -3.124376673e-04f, -2.808403007e-04f, +6.569929318e-04f, +4.481649702e-04f, -1.171037534e-03f, -6.132254185e-04f, +1.848821109e-03f, +7.314302511e-04f, -2.646049143e-03f, -7.580816744e-04f, +3.480588537e-03f, +6.624116387e-04f, -4.244320116e-03f, -4.393630174e-04f, +4.824253892e-03f, +1.146548538e-04f, -5.127648687e-03f, +2.592907924e-04f, +5.104045782e-03f, -6.158590596e-04f, -4.757638244e-03f, +8.914588966e-04f, +4.146189187e-03f, -1.041971095e-03f, -3.366842708e-03f, +1.053194813e-03f, +2.533177027e-03f, -9.422006148e-04f, -1.750316290e-03f, +7.496963344e-04f, +1.095032644e-03f, -5.265264426e-04f, -6.056212654e-04f, +3.191320079e-04f, +2.828334246e-04f, -1.586424720e-04f, -7.472545295e-05f, +4.185484257e-05f, +0.000000000e+00f,
        /*  9, 0 (40) */
        +0.000000000e+00f, -7.017253429e-04f, -1.750424134e-04f, +2.058419758e-03f, -1.982704743e-04f, -4.434814470e-03f, +1.641618436e-03f, +7.968272772e-03f, -5.099884949e-03f, -1.256166394e-02f, +1.191669646e-02f, +1.783553129e-02f, -2.422063161e-02f, -2.315743311e-02f, +4.659175191e-02f, +2.775293222e-02f, -9.501521185e-02f, -3.087432576e-02f, +3.144630653e-01f, +5.319805819e-01f, +3.144630653e-01f, -3.087432576e-02f, -9.501521185e-02f, +2.775293222e-02f, +4.659175191e-02f, -2.315743311e-02f, -2.422063161e-02f, +1.783553129e-02f, +1.191669646e-02f, -1.256166394e-02f, -5.099884949e-03f, +7.968272772e-03f, +1.641618436e-03f, -4.434814470e-03f, -1.982704743e-04f, +2.058419758e-03f, -1.750424134e-04f, -7.017253429e-04f, +1.133055274e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +7.017253429e-04f, +1.750424134e-04f, -2.819252016e-03f, +1.317047024e-03f, +5.813065763e-03f, -5.638484823e-03f, -8.056056973e-03f, +1.356304760e-02f, +6.644294405e-03f, -2.362138728e-02f, +9.950267494e-04f, +3.194086253e-02f, -1.503480532e-02f, -3.374209658e-02f, +3.210410297e-02f, +2.603063562e-02f, -4.623861285e-02f, -9.813316511e-03f, +5.173229864e-02f, -9.813316511e-03f, -4.623861285e-02f, +2.603063562e-02f, +3.210410297e-02f, -3.374209658e-02f, -1.503480532e-02f, +3.194086253e-02f, +9.950267494e-04f, -2.362138728e-02f, +6.644294405e-03f, +1.356304760e-02f, -8.056056973e-03f, -5.638484823e-03f, +5.813065763e-03f, +1.317047024e-03f, -2.819252016e-03f, +8.373329469e-05f, +7.017253429e-04f, -1.133055274e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.843734294e-05f, -1.214566576e-04f, -7.472014895e-05f, +3.218869068e-04f, +4.469181001e-05f, -6.602637232e-04f, +1.228524648e-04f, +1.155179992e-03f, -5.457330918e-04f, -1.806291018e-03f, +1.393878176e-03f, +2.611918560e-03f, -2.961245233e-03f, -3.660171795e-03f, +6.004267817e-03f, +5.706661215e-03f, -1.414466048e-02f, -2.348852223e-02f, -9.815742514e-04f, +2.295187420e-02f, +1.546450254e-02f, -4.903822234e-03f, -6.553589036e-03f, +3.261396848e-03f, +3.318981920e-03f, -2.420637634e-03f, -1.639950353e-03f, +1.729177185e-03f, +7.072796253e-04f, -1.137512275e-03f, -2.193896372e-04f, +6.680518135e-04f, +5.477384785e-06f, -3.355126957e-04f, +5.377230458e-05f, +1.317810928e-04f, -4.287448115e-05f, -2.973358537e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.843734294e-05f, +1.214566576e-04f, +6.611005247e-05f, -4.953319912e-04f, +1.616505191e-04f, +9.145006501e-04f, -8.057764558e-04f, -1.146118613e-03f, +1.880473749e-03f, +8.100621742e-04f, -3.094701674e-03f, +3.389294331e-04f, +3.899152682e-03f, -2.171261040e-03f, -3.748628172e-03f, +4.130118087e-03f, +2.443118584e-03f, -5.457193385e-03f, -3.156886903e-04f, +5.589460748e-03f, -1.888406059e-03f, -4.477572991e-03f, +3.389085798e-03f, +2.611983874e-03f, -3.769404223e-03f, -7.399153723e-04f, +3.143917298e-03f, -5.342574714e-04f, -2.013366884e-03f, +1.009860492e-03f, +9.358410193e-04f, -8.784127114e-04f, -2.445082970e-04f, +5.043349974e-04f, -3.186974957e-05f, -1.820124374e-04f, +4.287448115e-05f, +2.973358537e-05f, +0.000000000e+00f,
        /*  9, 1 (40) */
        +0.000000000e+00f, -6.532880000e-04f, -2.964990710e-04f, +1.983699609e-03f, +1.236164325e-04f, -4.390122660e-03f, +9.813547128e-04f, +8.091125237e-03f, -3.944704957e-03f, -1.310739703e-02f, +1.011040544e-02f, +1.922940947e-02f, -2.160871305e-02f, -2.611867834e-02f, +4.293158011e-02f, +3.375720004e-02f, -8.930855063e-02f, -4.501898624e-02f, +2.909745431e-01f, +5.309990076e-01f, +3.374149395e-01f, -1.540982321e-02f, -9.991903408e-02f, +2.119934318e-02f, +4.985314876e-02f, -1.983845119e-02f, -2.664126924e-02f, +1.619558094e-02f, +1.364587364e-02f, -1.185438431e-02f, -6.237397224e-03f, +7.748883135e-03f, +2.309670250e-03f, -4.429337085e-03f, -5.337831700e-04f, +2.112192063e-03f, -4.326132053e-05f, -7.445998240e-04f, +8.357194200e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +6.532880000e-04f, +2.964990710e-04f, -2.753141964e-03f, +8.217150332e-04f, +5.974716282e-03f, -4.723984173e-03f, -8.861833429e-03f, +1.241692899e-02f, +8.524768155e-03f, -2.281132511e-02f, -2.099674924e-03f, +3.227979197e-02f, -1.113565264e-02f, -3.591335762e-02f, +2.835547480e-02f, +3.016075371e-02f, -4.379549427e-02f, -1.527050990e-02f, +5.141660995e-02f, -4.223855762e-03f, -4.812701891e-02f, +2.155306263e-02f, +3.549318877e-02f, -3.113011271e-02f, -1.880420955e-02f, +3.120094716e-02f, +4.138944048e-03f, -2.415564475e-02f, +4.630927521e-03f, +1.457290810e-02f, -7.120215954e-03f, -6.516897535e-03f, +5.568557466e-03f, +1.821382022e-03f, -2.851121766e-03f, -9.827914271e-05f, +7.445998240e-04f, -8.357194200e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +5.294752732e-05f, -1.102371737e-04f, -9.367745324e-05f, +3.051331657e-04f, +9.223178851e-05f, -6.452740583e-04f, +2.840888309e-05f, +1.159326250e-03f, -3.833270077e-04f, -1.861027071e-03f, +1.139975466e-03f, +2.768806560e-03f, -2.582598789e-03f, -4.006358736e-03f, +5.412402635e-03f, +6.415233152e-03f, -1.278083917e-02f, -2.387804682e-02f, -2.938075104e-03f, +2.226991169e-02f, +1.672914678e-02f, -4.010242802e-03f, -7.053008544e-03f, +2.812587184e-03f, +3.651177164e-03f, -2.196044431e-03f, -1.875155598e-03f, +1.629859646e-03f, +8.660702928e-04f, -1.106062470e-03f, -3.169565730e-04f, +6.682608626e-04f, +5.777636716e-05f, -3.456925702e-04f, +3.100013789e-05f, +1.410160841e-04f, -3.626869734e-05f, -3.449908995e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.294752732e-05f, +1.102371737e-04f, +9.746178296e-05f, -4.803221480e-04f, +8.029617568e-05f, +9.376714072e-04f, -6.699201149e-04f, -1.264117719e-03f, +1.727641254e-03f, +1.069656674e-03f, -3.008215065e-03f, -5.954087941e-05f, +3.979018819e-03f, -1.708904058e-03f, -4.058694388e-03f, +3.734171146e-03f, +2.965184200e-03f, -5.257929761e-03f, -9.431245850e-04f, +5.652928597e-03f, -1.307846094e-03f, -4.771847280e-03f, +2.984137637e-03f, +3.025262961e-03f, -3.590713239e-03f, -1.138362217e-03f, +3.154504429e-03f, -2.454207327e-04f, -2.124084753e-03f, +8.565848337e-04f, +1.058200773e-03f, -8.293981165e-04f, -3.278005785e-04f, +5.069019624e-04f, +4.923932350e-06f, -1.949270588e-04f, +3.626869734e-05f, +3.449908995e-05f, +0.000000000e+00f,
        /*  9, 2 (40) */
        +0.000000000e+00f, -6.003404726e-04f, -4.067362447e-04f, +1.890022156e-03f, +4.287495982e-04f, -4.297890872e-03f, +3.360806545e-04f, +8.119534120e-03f, -2.785378707e-03f, -1.349072404e-02f, +8.249378367e-03f, +2.036938493e-02f, -1.883990649e-02f, -2.870127713e-02f, +3.892522138e-02f, +3.916960267e-02f, -8.289331748e-02f, -5.779982541e-02f, +2.670964963e-01f, +5.280609325e-01f, +3.596848512e-01f, +1.319323565e-03f, -1.039292769e-01f, +1.414633464e-02f, +5.266573594e-02f, -1.618727402e-02f, -2.883731368e-02f, +1.432042534e-02f, +1.527573329e-02f, -1.098831402e-02f, -7.343459695e-03f, +7.431926562e-03f, +2.977931112e-03f, -4.371560718e-03f, -8.794757402e-04f, +2.143192201e-03f, +9.775476354e-05f, -7.808685214e-04f, +4.907285204e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +6.003404726e-04f, +4.067362447e-04f, -2.655680181e-03f, +3.413928852e-04f, +6.055012458e-03f, -3.786312766e-03f, -9.531753544e-03f, +1.115281127e-02f, +1.025240941e-02f, -2.174166843e-02f, -5.107889989e-03f, +3.222025109e-02f, -7.156633823e-03f, -3.762226168e-02f, +2.429678041e-02f, +3.389492485e-02f, -4.083031007e-02f, -2.052843966e-02f, +5.047348537e-02f, +1.429072834e-03f, -4.943486501e-02f, +1.678121535e-02f, +3.847732640e-02f, -2.810484974e-02f, -2.239492279e-02f, +3.006258494e-02f, +7.293448477e-03f, -2.440106548e-02f, +2.506842768e-03f, +1.542949293e-02f, -6.062015180e-03f, -7.346295651e-03f, +5.240756887e-03f, +2.328283984e-03f, -2.846197833e-03f, -2.932062015e-04f, +7.808685214e-04f, -4.907285204e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +5.641075041e-05f, -9.831851840e-05f, -1.105109674e-04f, +2.855936222e-04f, +1.366944058e-04f, -6.235304087e-04f, -6.293841711e-05f, +1.150357134e-03f, -2.219079595e-04f, -1.893466033e-03f, +8.812751314e-04f, +2.890626324e-03f, -2.187758567e-03f, -4.298026076e-03f, +4.785522207e-03f, +7.026922587e-03f, -1.138439549e-02f, -2.411978892e-02f, -4.874687612e-03f, +2.144558744e-02f, +1.792761201e-02f, -3.030348290e-03f, -7.495415680e-03f, +2.316909459e-03f, +3.953336330e-03f, -1.939624746e-03f, -2.096488373e-03f, +1.508772975e-03f, +1.020179643e-03f, -1.060723315e-03f, -4.144389719e-04f, +6.605907798e-04f, +1.116586147e-04f, -3.521379039e-04f, +6.602181892e-06f, +1.489715196e-04f, -2.864594131e-05f, -3.913447055e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.641075041e-05f, +9.831851840e-05f, +1.256487669e-04f, -4.597976294e-04f, +1.450451870e-06f, +9.481045615e-04f, -5.301994246e-04f, -1.362887090e-03f, +1.557305195e-03f, +1.310139011e-03f, -2.886262616e-03f, -4.505553522e-04f, +4.008706317e-03f, -1.230929462e-03f, -4.315874755e-03f, +3.295000408e-03f, +3.448245579e-03f, -4.994314020e-03f, -1.558786322e-03f, +5.646659450e-03f, -7.085952003e-04f, -5.008896046e-03f, +2.538468262e-03f, +3.405572999e-03f, -3.364659660e-03f, -1.529164760e-03f, +3.125579499e-03f, +5.302961668e-05f, -2.210626144e-03f, +6.877948014e-04f, +1.170983701e-03f, -7.676237739e-04f, -4.104073217e-04f, +5.026758498e-04f, +4.387886421e-05f, -2.058395148e-04f, +2.864594131e-05f, +3.913447055e-05f, +0.000000000e+00f,
        /*  9, 3 (40) */
        +0.000000000e+00f, -5.439297222e-04f, -5.050547631e-04f, +1.779511189e-03f, +7.143432204e-04f, -4.161196466e-03f, -2.874497542e-04f, +8.056595703e-03f, -1.635021573e-03f, -1.371263200e-02f, +6.355912334e-03f, +2.125066007e-02f, -1.594928017e-02f, -3.088903570e-02f, +3.462719530e-02f, +4.395512488e-02f, -7.586639489e-02f, -6.918422090e-02f, +2.429767073e-01f, +5.231862449e-01f, +3.811304387e-01f, +1.924693557e-02f, -1.069596252e-01f, +6.650918960e-03f, +5.498264540e-02f, -1.223393769e-02f, -3.077693842e-02f, +1.222393697e-02f, +1.678450626e-02f, -9.968134376e-03f, -8.404183010e-03f, +7.017487590e-03f, +3.638521892e-03f, -4.259902104e-03f, -1.231613644e-03f, +2.149794383e-03f, +2.467262831e-04f, -8.095144627e-04f, +9.938381493e-06f, +0.000000000e+00f,
        +0.000000000e+00f, +5.439297222e-04f, +5.050547631e-04f, -2.530031414e-03f, -1.184047442e-04f, +6.056462910e-03f, -2.838208205e-03f, -1.006195297e-02f, +9.789924182e-03f, +1.180971460e-02f, -2.043152942e-02f, -7.994152605e-03f, +3.176969573e-02f, -3.147927506e-03f, -3.885319114e-02f, +1.998090565e-02f, +3.718992526e-02f, -3.738206449e-02f, -2.552275368e-02f, +4.891469905e-02f, +7.075732284e-03f, -5.014346021e-02f, +1.177231930e-02f, +4.101579467e-02f, -2.469927675e-02f, -2.575958245e-02f, +2.853342018e-02f, +1.041902798e-02f, -2.434803587e-02f, +2.962166243e-04f, +1.611728773e-02f, -4.891031479e-03f, -8.113919425e-03f, +4.830349566e-03f, +2.830959834e-03f, -2.802318969e-03f, -4.990457162e-04f, +8.095144627e-04f, -9.938381493e-06f, +0.000000000e+00f,
        +0.000000000e+00f, +5.884729198e-05f, -8.589535914e-05f, -1.251206083e-04f, +2.636293693e-04f, +1.776862090e-04f, -5.955426518e-04f, -1.502574751e-04f, +1.128814840e-03f, -6.325339340e-05f, -1.903934920e-03f, +6.207732291e-04f, +2.977103677e-03f, -1.781472607e-03f, -4.533865761e-03f, +4.131250132e-03f, +7.540028922e-03f, -9.966725522e-03f, -2.421423541e-02f, -6.778334413e-03f, +2.048298182e-02f, +1.904925260e-02f, -1.969441845e-03f, -7.874022257e-03f, +1.778128844e-03f, +4.221154537e-03f, -1.653264841e-03f, -2.301008985e-03f, +1.366615154e-03f, +1.167674654e-03f, -1.001547249e-03f, -5.106836993e-04f, +6.448254091e-04f, +1.665354586e-04f, -3.545943872e-04f, -1.919183145e-05f, +1.554644473e-04f, -2.004887603e-05f, -4.355134276e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.884729198e-05f, +8.589535914e-05f, +1.504549592e-04f, -4.343038303e-04f, -7.395648112e-05f, +9.461414043e-04f, -3.885302033e-04f, -1.441731981e-03f, +1.372064648e-03f, +1.528915007e-03f, -2.731065440e-03f, -8.293498011e-04f, +3.988557310e-03f, -7.434815445e-04f, -4.517457818e-03f, +2.818382716e-03f, +3.886466567e-03f, -4.669795535e-03f, -2.154991477e-03f, +5.570595356e-03f, -9.807683830e-05f, -5.185374127e-03f, +2.057321567e-03f, +3.747747485e-03f, -3.093451758e-03f, -1.907233017e-03f, +3.056753389e-03f, +3.574748264e-04f, -2.271257013e-03f, +5.052423525e-04f, +1.272385676e-03f, -6.934369816e-04f, -4.911712416e-04f, +4.913803271e-04f, +8.454905082e-05f, -2.144429117e-04f, +2.004887603e-05f, +4.355134276e-05f, +0.000000000e+00f,
        /*  9, 4 (40) */
        +0.000000000e+00f, -4.850824302e-04f, -5.909501222e-04f, +1.654390580e-03f, +9.779725896e-04f, -3.983510257e-03f, -8.829924060e-04f, +7.906338228e-03f, -5.062067334e-04f, -1.377588539e-02f, +4.451977414e-03f, +2.187143329e-02f, -1.297217649e-02f, -3.267050830e-02f, +3.009332954e-02f, +4.808637501e-02f, -6.832636597e-02f, -7.915094642e-02f, +2.187624719e-01f, +5.164079105e-01f, +4.016134205e-01f, +3.829618817e-02f, -1.089290670e-01f, -1.223103297e-03f, +5.676077424e-02f, -8.012783156e-03f, -3.243020326e-02f, +9.922927981e-03f, +1.815112142e-02f, -8.800459722e-03f, -9.405730259e-03f, +6.506803891e-03f, +4.283347301e-03f, -4.093366645e-03f, -1.586208031e-03f, +2.130602551e-03f, +4.021907304e-04f, -8.295633387e-04f, -3.361296126e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.850824302e-04f, +5.909501222e-04f, -2.379576454e-03f, -5.527085745e-04f, +5.982506429e-03f, -1.892066800e-03f, -1.045048317e-02f, +8.348192201e-03f, +1.318177925e-02f, -1.890261442e-02f, -1.072521805e-02f, +3.094034593e-02f, +8.406298037e-04f, -3.959667268e-02f, +1.546344784e-02f, +4.000830798e-02f, -3.349559792e-02f, -3.019254921e-02f, +4.675970757e-02f, +1.264632764e-02f, -5.024153705e-02f, +6.586945176e-03f, +4.307311623e-02f, -2.095152926e-02f, -2.885303420e-02f, +2.662618717e-02f, +1.347578136e-02f, -2.399056104e-02f, -1.975040388e-03f, +1.662253008e-02f, -3.618645803e-03f, -8.807356407e-03f, +4.339178324e-03f, +3.322340161e-03f, -2.717769918e-03f, -7.134886279e-04f, +8.295633387e-04f, +3.361296126e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +6.029092420e-05f, -7.315860199e-05f, -1.374392209e-04f, +2.396151739e-04f, +2.148710507e-04f, -5.618746480e-04f, -2.326955049e-04f, +1.095367052e-03f, +9.094642695e-05f, -1.892996117e-03f, +3.613969454e-04f, +3.028357154e-03f, -1.368469826e-03f, -4.713188790e-03f, +3.457229605e-03f, +7.953761608e-03f, -8.539166431e-03f, -2.416300508e-02f, -8.636208704e-03f, +1.938727657e-02f, +2.008385485e-02f, -8.336748150e-04f, -8.182436481e-03f, +1.200587652e-03f, +4.450568768e-03f, -1.339242186e-03f, -2.485878817e-03f, +1.204347512e-03f, +1.306637052e-03f, -9.287510517e-04f, -6.045112890e-04f, +6.208382892e-04f, +2.217817538e-04f, -3.528467708e-04f, -4.612255583e-05f, +1.603219883e-04f, -1.053717489e-05f, -4.765899818e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -6.029092420e-05f, +7.315860199e-05f, +1.717246052e-04f, -4.044293024e-04f, -1.450792578e-04f, +9.322746214e-04f, -2.467916037e-04f, -1.500235027e-03f, +1.174644097e-03f, +1.723725133e-03f, -2.545224130e-03f, -1.191394320e-03f, +3.919539164e-03f, -2.527524175e-04f, -4.661458564e-03f, +2.310526380e-03f, +4.274604149e-03f, -4.288582946e-03f, -2.724305859e-03f, +5.425560317e-03f, +5.161124881e-04f, -5.298683465e-03f, +1.546438148e-03f, +4.047049349e-03f, -2.779905960e-03f, -2.267558771e-03f, +2.948145751e-03f, +6.641392795e-04f, -2.304540143e-03f, +3.109115906e-04f, +1.360697223e-03f, -6.073670260e-04f, -5.689127526e-04f, +4.728274703e-04f, +1.264386833e-04f, -2.204480988e-04f, +1.053717489e-05f, +4.765899818e-05f, +0.000000000e+00f,
        /*  9, 5 (40) */
        +0.000000000e+00f, -4.247915060e-04f, -6.641087242e-04f, +1.516951359e-03f, +1.217587764e-03f, -3.768639206e-03f, -1.444867054e-03f, +7.673642723e-03f, +5.891603182e-04f, -1.368493896e-02f, +2.558981297e-03f, +2.223283024e-02f, -9.943819336e-03f, -3.403897813e-02f, +2.538014075e-02f, +5.154360462e-02f, -6.037260436e-02f, -8.769011285e-02f, +1.945994668e-01f, +5.077717018e-01f, +4.210006970e-01f, +5.838004303e-02f, -1.097627418e-01f, -9.405539777e-03f, +5.796136190e-02f, -3.562214389e-03f, -3.376944545e-02f, +7.437049164e-03f, +1.935546893e-02f, -7.493822670e-03f, -1.033448131e-02f, +5.902292602e-03f, +4.904185590e-03f, -3.871584891e-03f, -1.939054802e-03f, +2.084479995e-03f, +5.625127187e-04f, -8.401005136e-04f, -8.127195944e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.247915060e-04f, +6.641087242e-04f, -2.207851849e-03f, -9.571378768e-04f, +5.837427171e-03f, -9.597921789e-04f, -1.069727478e-02f, +6.847957174e-03f, +1.435642335e-02f, -1.717888928e-02f, -1.327044218e-02f, +2.974895161e-02f, +4.760168967e-03f, -3.984942510e-02f, +1.080198927e-02f, +4.231883436e-02f, -2.922099377e-02f, -3.448113216e-02f, +4.403540171e-02f, +1.807188796e-02f, -4.972542456e-02f, +1.288261711e-03f, +4.461955438e-02f, -1.690447991e-02f, -3.163294016e-02f, +2.435862839e-02f, +1.642392712e-02f, -2.332642176e-02f, -4.279580531e-03f, +1.693344167e-02f, -2.257948580e-03f, -9.414723433e-03f, +3.770265571e-03f, +3.795167631e-03f, -2.591331235e-03f, -9.339367267e-04f, +8.401005136e-04f, +8.127195944e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +6.078769928e-05f, -6.029301021e-05f, -1.474319237e-04f, +2.139342490e-04f, +2.479719027e-04f, -5.231355844e-04f, -3.094861283e-04f, +1.050795193e-03f, +2.391049255e-04f, -1.861434083e-03f, +1.059742262e-04f, +3.044885542e-03f, -9.534103962e-04f, -4.835914568e-03f, +2.771049618e-03f, +8.268226991e-03f, -7.112900121e-03f, -2.396882485e-02f, -1.043587901e-02f, +1.816471880e-02f, +2.102173053e-02f, +3.699912449e-04f, -8.414734600e-03f, +5.891775115e-04f, +4.637808794e-03f, -1.000211628e-03f, -2.648395422e-03f, +1.023191644e-03f, +1.435186128e-03f, -8.427186704e-04f, -6.947291882e-04f, +5.885975143e-04f, +2.767422258e-04f, -3.467232978e-04f, -7.390308195e-05f, +1.633842487e-04f, -1.875827134e-07f, -5.136572648e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -6.078769928e-05f, +6.029301021e-05f, +1.893614946e-04f, -3.707954872e-04f, -2.111655490e-04f, +9.071362565e-04f, -1.068023210e-04f, -1.538253905e-03f, +9.678548124e-04f, +1.892666405e-03f, -2.331677985e-03f, -1.532447546e-03f, +3.803223330e-03f, +2.350976400e-04f, -4.746637006e-03f, +1.777989004e-03f, +4.608072432e-03f, -3.855588534e-03f, -3.259638268e-03f, +5.213251324e-03f, +1.126299759e-03f, -5.347011066e-03f, +1.011985686e-03f, +4.299236737e-03f, -2.427418426e-03f, -2.605282082e-03f, +2.800392844e-03f, +9.691369591e-04f, -2.309361504e-03f, +1.069985000e-04f, +1.434329790e-03f, -5.101242715e-04f, -6.424458079e-04f, +4.469244867e-04f, +1.690071554e-04f, -2.235893425e-04f, +1.875827134e-07f, +5.136572648e-05f, +0.000000000e+00f,
        /*  9, 6 (40) */
        +0.000000000e+00f, -3.640038068e-04f, -7.244017344e-04f, +1.369519436e-03f, +1.431522013e-03f, -3.520667303e-03f, -1.968002638e-03f, +7.364156595e-03f, +1.639955511e-03f, -1.344583404e-02f, +6.975472133e-04f, +2.233880447e-02f, -6.898933795e-03f, -3.499238852e-02f, +2.054422618e-02f, +5.431465423e-02f, -5.210437737e-02f, -9.480301297e-02f, +1.706306420e-01f, +4.973358228e-01f, +4.391654158e-01f, +7.940177356e-02f, -1.093927506e-01f, -1.782027438e-02f, +5.855053941e-02f, +1.075594405e-03f, -3.476965708e-02f, +4.788653743e-03f, +2.037866057e-02f, -6.058636542e-03f, -1.117719998e-02f, +5.207563414e-03f, +5.492783105e-03f, -3.594842665e-03f, -2.285778100e-03f, +2.010576913e-03f, +7.258969674e-04f, -8.402880963e-04f, -1.326376859e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.640038068e-04f, +7.244017344e-04f, -2.018490355e-03f, -1.327933364e-03f, +5.626261622e-03f, -5.265592234e-05f, -1.080407710e-02f, +5.309703269e-03f, +1.532427816e-02f, -1.528622288e-02f, -1.560212016e-02f, +2.821650407e-02f, +8.563392298e-03f, -3.961432746e-02f, +6.055352266e-03f, +4.409682336e-02f, -2.461292134e-02f, -3.833672069e-02f, +4.077576344e-02f, +2.328513928e-02f, -4.859912480e-02f, -4.058749355e-03f, +4.563154007e-02f, -1.260524317e-02f, -3.406035859e-02f, +2.175334631e-02f, +1.922431996e-02f, -2.235728480e-02f, -6.588942035e-03f, +1.704044017e-02f, -8.236187902e-04f, -9.924847704e-03f, +3.127819764e-03f, +4.242092118e-03f, -2.422324079e-03f, -1.157526069e-03f, +8.402880963e-04f, +1.326376859e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +6.039462004e-05f, -4.747501713e-05f, -1.550950630e-04f, +1.869731319e-04f, +2.767718783e-04f, -4.799710815e-04f, -3.799553483e-04f, +9.959817384e-04f, +3.797540378e-04f, -1.810239943e-03f, -1.427946417e-04f, +3.027551634e-03f, -5.408381760e-04f, -4.902554350e-03f, +2.080173389e-03f, +8.484407056e-03f, -5.698859645e-03f, -2.363549640e-02f, -1.216539056e-02f, +1.682257546e-02f, +2.185380679e-02f, +1.633830746e-03f, -8.565529567e-03f, -5.069476091e-05f, +4.779446351e-03f, -6.391869980e-04f, -2.786027072e-03f, +8.246232333e-04f, +1.551501823e-03f, -7.440021563e-04f, -7.801456050e-04f, +5.481696044e-04f, +3.307384398e-04f, -3.360997572e-04f, -1.022214475e-04f, +1.645071892e-04f, +1.090627139e-05f, -5.458022250e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -6.039462004e-05f, +4.747501713e-05f, +2.033273582e-04f, -3.340464162e-04f, -2.715626713e-04f, +8.714841796e-04f, +2.970164573e-05f, -1.555915397e-03f, +7.545560368e-04f, +2.034209142e-03f, -2.093660601e-03f, -1.848606288e-03f, +3.641756681e-03f, +7.140185025e-04f, -4.772506982e-03f, +1.227591396e-03f, +4.882997857e-03f, -3.376363675e-03f, -3.754330776e-03f, +4.936218116e-03f, +1.724833323e-03f, -5.329357022e-03f, +4.604832095e-04f, +4.500623034e-03f, -2.039928659e-03f, -2.915756870e-03f, +2.614648660e-03f, +1.268520358e-03f, -2.284952881e-03f, -1.041127549e-04f, +1.491841141e-03f, -4.025966696e-04f, -7.105944377e-04f, +4.136793152e-04f, +2.116750094e-04f, -2.236299197e-04f, -1.090627139e-05f, +5.458022250e-05f, +0.000000000e+00f,
        /*  9, 7 (40) */
        +0.000000000e+00f, -3.036091867e-04f, -7.718767515e-04f, +1.214424373e-03f, +1.618495145e-03f, -3.243895425e-03f, -2.447973720e-03f, +6.984201246e-03f, +2.635937250e-03f, -1.306608000e-02f, -1.112692730e-03f, +2.219600982e-02f, -3.871382161e-03f, -3.553322670e-02f, +1.564167183e-02f, +5.639482762e-02f, -4.361997031e-02f, -1.005018726e-01f, +1.469951456e-01f, +4.851704322e-01f, +4.559879913e-01f, +1.012555804e-01f, -1.077589198e-01f, -2.638580394e-02f, +5.849984465e-02f, +5.855040756e-03f, -3.540884407e-02f, +2.002626671e-03f, +2.120328381e-02f, -4.507134719e-03f, -1.192120214e-02f, +4.427417809e-03f, +6.040952709e-03f, -3.264104226e-03f, -2.621877857e-03f, +1.908355466e-03f, +8.904041566e-04f, -8.293818249e-04f, -1.872179084e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.036091867e-04f, +7.718767515e-04f, -1.815162996e-03f, -1.661979780e-03f, +5.354698950e-03f, +8.188282573e-04f, -1.077437545e-02f, +3.753787872e-03f, +1.607883420e-02f, -1.325201374e-02f, -1.769578076e-02f, +2.636789778e-02f, +1.220514898e-02f, -3.890030896e-02f, +1.282845284e-03f, +4.532441476e-02f, -1.972992349e-02f, -4.171308437e-02f, +3.702143267e-02f, +2.822135740e-02f, -4.687429148e-02f, -9.388106377e-03f, +4.609202328e-02f, -8.104620140e-03f, -3.610028725e-02f, +1.883758944e-02f, +2.183896862e-02f, -2.108876444e-02f, -8.873894916e-03f, +1.693632742e-02f, +6.682223505e-04f, -1.032744437e-02f, +2.417225326e-03f, +4.655771433e-03f, -2.210649070e-03f, -1.381155989e-03f, +8.293818249e-04f, +1.872179084e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.917821755e-05f, -3.487075517e-05f, -1.604548066e-04f, +1.591167301e-04f, +3.011144788e-04f, -4.330541809e-04f, -4.435262341e-04f, +9.318967466e-04f, +5.115572318e-04f, -1.740594197e-03f, -3.823632391e-04f, +2.977562468e-03f, -1.351356408e-04f, -4.914189081e-03f, +1.391869640e-03f, +8.604130417e-03f, -4.307639135e-03f, -2.316785366e-02f, -1.381336228e-02f, +1.536907865e-02f, +2.257171159e-02f, +2.949408088e-03f, -8.630035953e-03f, -7.131473829e-04f, +4.872441994e-03f, -2.595182674e-04f, -2.896446364e-03f, +6.103627797e-04f, +1.653847792e-03f, -6.333206296e-04f, -8.595838121e-04f, +4.997223034e-04f, +3.830763249e-04f, -3.209030892e-04f, -1.307435912e-04f, +1.635654095e-04f, +2.263431824e-05f, -5.721306075e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.917821755e-05f, +3.487075517e-05f, +2.136394716e-04f, -2.948385299e-04f, -3.257225426e-04f, +8.261872995e-04f, +1.610874226e-04f, -1.553606028e-03f, +5.376164940e-04f, +2.147208443e-03f, -1.834652463e-03f, -2.136349946e-03f, +3.437825781e-03f, +1.178146185e-03f, -4.739335150e-03f, +6.663286819e-04f, +5.096264962e-03f, -2.857026236e-03f, -4.202243378e-03f, +4.597831892e-03f, +2.304180875e-03f, -5.245552147e-03f, -1.012798371e-04f, +4.648130273e-03f, -1.621875525e-03f, -3.194614682e-03f, +2.392579214e-03f, +1.558331221e-03f, -2.230910377e-03f, -3.198767271e-04f, +1.531959494e-03f, -2.858436540e-04f, -7.722097691e-04f, +3.732049744e-04f, +2.538307599e-04f, -2.203675361e-04f, -2.263431824e-05f, +5.721306075e-05f, +0.000000000e+00f,
        /*  9, 8 (40) */
        +0.000000000e+00f, -2.444309692e-04f, -8.067475067e-04f, +1.053969566e-03f, +1.777611875e-03f, -2.942780946e-03f, -2.881027901e-03f, +6.540675012e-03f, +3.567833996e-03f, -1.255452277e-02f, -2.853286927e-03f, +2.181364659e-02f, -8.938196926e-04f, -3.566836234e-02f, +1.072748275e-02f, +5.778669726e-02f, -3.501583990e-02f, -1.048095118e-01f, +1.238272919e-01f, +4.713570699e-01f, +4.713570699e-01f, +1.238272919e-01f, -1.048095118e-01f, -3.501583990e-02f, +5.778669726e-02f, +1.072748275e-02f, -3.566836234e-02f, -8.938196926e-04f, +2.181364659e-02f, -2.853286927e-03f, -1.255452277e-02f, +3.567833996e-03f, +6.540675012e-03f, -2.881027901e-03f, -2.942780946e-03f, +1.777611875e-03f, +1.053969566e-03f, -8.067475067e-04f, -2.444309692e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.444309692e-04f, +8.067475067e-04f, -1.601523525e-03f, -1.956818310e-03f, +5.028976408e-03f, +1.645015557e-03f, -1.061328803e-02f, +2.200181844e-03f, +1.661645069e-02f, -1.110480529e-02f, -1.953043322e-02f, +2.423154783e-02f, +1.564297476e-02f, -3.772216277e-02f, -3.456489867e-03f, +4.599074344e-02f, -1.463365852e-02f, -4.457011060e-02f, +3.281918929e-02f, +3.281918929e-02f, -4.457011060e-02f, -1.463365852e-02f, +4.599074344e-02f, -3.456489867e-03f, -3.772216277e-02f, +1.564297476e-02f, +2.423154783e-02f, -1.953043322e-02f, -1.110480529e-02f, +1.661645069e-02f, +2.200181844e-03f, -1.061328803e-02f, +1.645015557e-03f, +5.028976408e-03f, -1.956818310e-03f, -1.601523525e-03f, +8.067475067e-04f, +2.444309692e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.721306075e-05f, -2.263431824e-05f, -1.635654095e-04f, +1.307435912e-04f, +3.209030892e-04f, -3.830763249e-04f, -4.997223034e-04f, +8.595838121e-04f, +6.333206296e-04f, -1.653847792e-03f, -6.103627797e-04f, +2.896446364e-03f, +2.595182674e-04f, -4.872441994e-03f, +7.131473829e-04f, +8.630035953e-03f, -2.949408088e-03f, -2.257171159e-02f, -1.536907865e-02f, +1.381336228e-02f, +2.316785366e-02f, +4.307639135e-03f, -8.604130417e-03f, -1.391869640e-03f, +4.914189081e-03f, +1.351356408e-04f, -2.977562468e-03f, +3.823632391e-04f, +1.740594197e-03f, -5.115572318e-04f, -9.318967466e-04f, +4.435262341e-04f, +4.330541809e-04f, -3.011144788e-04f, -1.591167301e-04f, +1.604548066e-04f, +3.487075517e-05f, -5.917821755e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.721306075e-05f, +2.263431824e-05f, +2.203675361e-04f, -2.538307599e-04f, -3.732049744e-04f, +7.722097691e-04f, +2.858436540e-04f, -1.531959494e-03f, +3.198767271e-04f, +2.230910377e-03f, -1.558331221e-03f, -2.392579214e-03f, +3.194614682e-03f, +1.621875525e-03f, -4.648130273e-03f, +1.012798371e-04f, +5.245552147e-03f, -2.304180875e-03f, -4.597831892e-03f, +4.202243378e-03f, +2.857026236e-03f, -5.096264962e-03f, -6.663286819e-04f, +4.739335150e-03f, -1.178146185e-03f, -3.437825781e-03f, +2.136349946e-03f, +1.834652463e-03f, -2.147208443e-03f, -5.376164940e-04f, +1.553606028e-03f, -1.610874226e-04f, -8.261872995e-04f, +3.257225426e-04f, +2.948385299e-04f, -2.136394716e-04f, -3.487075517e-05f, +5.917821755e-05f, +0.000000000e+00f,
        /*  9, 9 (40) */
        +0.000000000e+00f, -1.872179084e-04f, -8.293818249e-04f, +8.904041566e-04f, +1.908355466e-03f, -2.621877857e-03f, -3.264104226e-03f, +6.040952709e-03f, +4.427417809e-03f, -1.192120214e-02f, -4.507134719e-03f, +2.120328381e-02f, +2.002626671e-03f, -3.540884407e-02f, +5.855040756e-03f, +5.849984465e-02f, -2.638580394e-02f, -1.077589198e-01f, +1.012555804e-01f, +4.559879913e-01f, +4.851704322e-01f, +1.469951456e-01f, -1.005018726e-01f, -4.361997031e-02f, +5.639482762e-02f, +1.564167183e-02f, -3.553322670e-02f, -3.871382161e-03f, +2.219600982e-02f, -1.112692730e-03f, -1.306608000e-02f, +2.635937250e-03f, +6.984201246e-03f, -2.447973720e-03f, -3.243895425e-03f, +1.618495145e-03f, +1.214424373e-03f, -7.718767515e-04f, -3.036091867e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.872179084e-04f, +8.293818249e-04f, -1.381155989e-03f, -2.210649070e-03f, +4.655771433e-03f, +2.417225326e-03f, -1.032744437e-02f, +6.682223505e-04f, +1.693632742e-02f, -8.873894916e-03f, -2.108876444e-02f, +2.183896862e-02f, +1.883758944e-02f, -3.610028725e-02f, -8.104620140e-03f, +4.609202328e-02f, -9.388106377e-03f, -4.687429148e-02f, +2.822135740e-02f, +3.702143267e-02f, -4.171308437e-02f, -1.972992349e-02f, +4.532441476e-02f, +1.282845284e-03f, -3.890030896e-02f, +1.220514898e-02f, +2.636789778e-02f, -1.769578076e-02f, -1.325201374e-02f, +1.607883420e-02f, +3.753787872e-03f, -1.077437545e-02f, +8.188282573e-04f, +5.354698950e-03f, -1.661979780e-03f, -1.815162996e-03f, +7.718767515e-04f, +3.036091867e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.458022250e-05f, -1.090627139e-05f, -1.645071892e-04f, +1.022214475e-04f, +3.360997572e-04f, -3.307384398e-04f, -5.481696044e-04f, +7.801456050e-04f, +7.440021563e-04f, -1.551501823e-03f, -8.246232333e-04f, +2.786027072e-03f, +6.391869980e-04f, -4.779446351e-03f, +5.069476091e-05f, +8.565529567e-03f, -1.633830746e-03f, -2.185380679e-02f, -1.682257546e-02f, +1.216539056e-02f, +2.363549640e-02f, +5.698859645e-03f, -8.484407056e-03f, -2.080173389e-03f, +4.902554350e-03f, +5.408381760e-04f, -3.027551634e-03f, +1.427946417e-04f, +1.810239943e-03f, -3.797540378e-04f, -9.959817384e-04f, +3.799553483e-04f, +4.799710815e-04f, -2.767718783e-04f, -1.869731319e-04f, +1.550950630e-04f, +4.747501713e-05f, -6.039462004e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.458022250e-05f, +1.090627139e-05f, +2.236299197e-04f, -2.116750094e-04f, -4.136793152e-04f, +7.105944377e-04f, +4.025966696e-04f, -1.491841141e-03f, +1.041127549e-04f, +2.284952881e-03f, -1.268520358e-03f, -2.614648660e-03f, +2.915756870e-03f, +2.039928659e-03f, -4.500623034e-03f, -4.604832095e-04f, +5.329357022e-03f, -1.724833323e-03f, -4.936218116e-03f, +3.754330776e-03f, +3.376363675e-03f, -4.882997857e-03f, -1.227591396e-03f, +4.772506982e-03f, -7.140185025e-04f, -3.641756681e-03f, +1.848606288e-03f, +2.093660601e-03f, -2.034209142e-03f, -7.545560368e-04f, +1.555915397e-03f, -2.970164573e-05f, -8.714841796e-04f, +2.715626713e-04f, +3.340464162e-04f, -2.033273582e-04f, -4.747501713e-05f, +6.039462004e-05f, +0.000000000e+00f,
        /*  9,10 (40) */
        +0.000000000e+00f, -1.326376859e-04f, -8.402880963e-04f, +7.258969674e-04f, +2.010576913e-03f, -2.285778100e-03f, -3.594842665e-03f, +5.492783105e-03f, +5.207563414e-03f, -1.117719998e-02f, -6.058636542e-03f, +2.037866057e-02f, +4.788653743e-03f, -3.476965708e-02f, +1.075594405e-03f, +5.855053941e-02f, -1.782027438e-02f, -1.093927506e-01f, +7.940177356e-02f, +4.391654158e-01f, +4.973358228e-01f, +1.706306420e-01f, -9.480301297e-02f, -5.210437737e-02f, +5.431465423e-02f, +2.054422618e-02f, -3.499238852e-02f, -6.898933795e-03f, +2.233880447e-02f, +6.975472133e-04f, -1.344583404e-02f, +1.639955511e-03f, +7.364156595e-03f, -1.968002638e-03f, -3.520667303e-03f, +1.431522013e-03f, +1.369519436e-03f, -7.244017344e-04f, -3.640038068e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.326376859e-04f, +8.402880963e-04f, -1.157526069e-03f, -2.422324079e-03f, +4.242092118e-03f, +3.127819764e-03f, -9.924847704e-03f, -8.236187902e-04f, +1.704044017e-02f, -6.588942035e-03f, -2.235728480e-02f, +1.922431996e-02f, +2.175334631e-02f, -3.406035859e-02f, -1.260524317e-02f, +4.563154007e-02f, -4.058749355e-03f, -4.859912480e-02f, +2.328513928e-02f, +4.077576344e-02f, -3.833672069e-02f, -2.461292134e-02f, +4.409682336e-02f, +6.055352266e-03f, -3.961432746e-02f, +8.563392298e-03f, +2.821650407e-02f, -1.560212016e-02f, -1.528622288e-02f, +1.532427816e-02f, +5.309703269e-03f, -1.080407710e-02f, -5.265592234e-05f, +5.626261622e-03f, -1.327933364e-03f, -2.018490355e-03f, +7.244017344e-04f, +3.640038068e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.136572648e-05f, +1.875827134e-07f, -1.633842487e-04f, +7.390308195e-05f, +3.467232978e-04f, -2.767422258e-04f, -5.885975143e-04f, +6.947291882e-04f, +8.427186704e-04f, -1.435186128e-03f, -1.023191644e-03f, +2.648395422e-03f, +1.000211628e-03f, -4.637808794e-03f, -5.891775115e-04f, +8.414734600e-03f, -3.699912449e-04f, -2.102173053e-02f, -1.816471880e-02f, +1.043587901e-02f, +2.396882485e-02f, +7.112900121e-03f, -8.268226991e-03f, -2.771049618e-03f, +4.835914568e-03f, +9.534103962e-04f, -3.044885542e-03f, -1.059742262e-04f, +1.861434083e-03f, -2.391049255e-04f, -1.050795193e-03f, +3.094861283e-04f, +5.231355844e-04f, -2.479719027e-04f, -2.139342490e-04f, +1.474319237e-04f, +6.029301021e-05f, -6.078769928e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.136572648e-05f, -1.875827134e-07f, +2.235893425e-04f, -1.690071554e-04f, -4.469244867e-04f, +6.424458079e-04f, +5.101242715e-04f, -1.434329790e-03f, -1.069985000e-04f, +2.309361504e-03f, -9.691369591e-04f, -2.800392844e-03f, +2.605282082e-03f, +2.427418426e-03f, -4.299236737e-03f, -1.011985686e-03f, +5.347011066e-03f, -1.126299759e-03f, -5.213251324e-03f, +3.259638268e-03f, +3.855588534e-03f, -4.608072432e-03f, -1.777989004e-03f, +4.746637006e-03f, -2.350976400e-04f, -3.803223330e-03f, +1.532447546e-03f, +2.331677985e-03f, -1.892666405e-03f, -9.678548124e-04f, +1.538253905e-03f, +1.068023210e-04f, -9.071362565e-04f, +2.111655490e-04f, +3.707954872e-04f, -1.893614946e-04f, -6.029301021e-05f, +6.078769928e-05f, +0.000000000e+00f,
        /*  9,11 (40) */
        +0.000000000e+00f, -8.127195944e-05f, -8.401005136e-04f, +5.625127187e-04f, +2.084479995e-03f, -1.939054802e-03f, -3.871584891e-03f, +4.904185590e-03f, +5.902292602e-03f, -1.033448131e-02f, -7.493822670e-03f, +1.935546893e-02f, +7.437049164e-03f, -3.376944545e-02f, -3.562214389e-03f, +5.796136190e-02f, -9.405539777e-03f, -1.097627418e-01f, +5.838004303e-02f, +4.210006970e-01f, +5.077717018e-01f, +1.945994668e-01f, -8.769011285e-02f, -6.037260436e-02f, +5.154360462e-02f, +2.538014075e-02f, -3.403897813e-02f, -9.943819336e-03f, +2.223283024e-02f, +2.558981297e-03f, -1.368493896e-02f, +5.891603182e-04f, +7.673642723e-03f, -1.444867054e-03f, -3.768639206e-03f, +1.217587764e-03f, +1.516951359e-03f, -6.641087242e-04f, -4.247915060e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +8.127195944e-05f, +8.401005136e-04f, -9.339367267e-04f, -2.591331235e-03f, +3.795167631e-03f, +3.770265571e-03f, -9.414723433e-03f, -2.257948580e-03f, +1.693344167e-02f, -4.279580531e-03f, -2.332642176e-02f, +1.642392712e-02f, +2.435862839e-02f, -3.163294016e-02f, -1.690447991e-02f, +4.461955438e-02f, +1.288261711e-03f, -4.972542456e-02f, +1.807188796e-02f, +4.403540171e-02f, -3.448113216e-02f, -2.922099377e-02f, +4.231883436e-02f, +1.080198927e-02f, -3.984942510e-02f, +4.760168967e-03f, +2.974895161e-02f, -1.327044218e-02f, -1.717888928e-02f, +1.435642335e-02f, +6.847957174e-03f, -1.069727478e-02f, -9.597921789e-04f, +5.837427171e-03f, -9.571378768e-04f, -2.207851849e-03f, +6.641087242e-04f, +4.247915060e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.765899818e-05f, +1.053717489e-05f, -1.603219883e-04f, +4.612255583e-05f, +3.528467708e-04f, -2.217817538e-04f, -6.208382892e-04f, +6.045112890e-04f, +9.287510517e-04f, -1.306637052e-03f, -1.204347512e-03f, +2.485878817e-03f, +1.339242186e-03f, -4.450568768e-03f, -1.200587652e-03f, +8.182436481e-03f, +8.336748150e-04f, -2.008385485e-02f, -1.938727657e-02f, +8.636208704e-03f, +2.416300508e-02f, +8.539166431e-03f, -7.953761608e-03f, -3.457229605e-03f, +4.713188790e-03f, +1.368469826e-03f, -3.028357154e-03f, -3.613969454e-04f, +1.892996117e-03f, -9.094642695e-05f, -1.095367052e-03f, +2.326955049e-04f, +5.618746480e-04f, -2.148710507e-04f, -2.396151739e-04f, +1.374392209e-04f, +7.315860199e-05f, -6.029092420e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.765899818e-05f, -1.053717489e-05f, +2.204480988e-04f, -1.264386833e-04f, -4.728274703e-04f, +5.689127526e-04f, +6.073670260e-04f, -1.360697223e-03f, -3.109115906e-04f, +2.304540143e-03f, -6.641392795e-04f, -2.948145751e-03f, +2.267558771e-03f, +2.779905960e-03f, -4.047049349e-03f, -1.546438148e-03f, +5.298683465e-03f, -5.161124881e-04f, -5.425560317e-03f, +2.724305859e-03f, +4.288582946e-03f, -4.274604149e-03f, -2.310526380e-03f, +4.661458564e-03f, +2.527524175e-04f, -3.919539164e-03f, +1.191394320e-03f, +2.545224130e-03f, -1.723725133e-03f, -1.174644097e-03f, +1.500235027e-03f, +2.467916037e-04f, -9.322746214e-04f, +1.450792578e-04f, +4.044293024e-04f, -1.717246052e-04f, -7.315860199e-05f, +6.029092420e-05f, +0.000000000e+00f,
        /*  9,12 (40) */
        +0.000000000e+00f, -3.361296126e-05f, -8.295633387e-04f, +4.021907304e-04f, +2.130602551e-03f, -1.586208031e-03f, -4.093366645e-03f, +4.283347301e-03f, +6.506803891e-03f, -9.405730259e-03f, -8.800459722e-03f, +1.815112142e-02f, +9.922927981e-03f, -3.243020326e-02f, -8.012783156e-03f, +5.676077424e-02f, -1.223103297e-03f, -1.089290670e-01f, +3.829618817e-02f, +4.016134205e-01f, +5.164079105e-01f, +2.187624719e-01f, -7.915094642e-02f, -6.832636597e-02f, +4.808637501e-02f, +3.009332954e-02f, -3.267050830e-02f, -1.297217649e-02f, +2.187143329e-02f, +4.451977414e-03f, -1.377588539e-02f, -5.062067334e-04f, +7.906338228e-03f, -8.829924060e-04f, -3.983510257e-03f, +9.779725896e-04f, +1.654390580e-03f, -5.909501222e-04f, -4.850824302e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.361296126e-05f, +8.295633387e-04f, -7.134886279e-04f, -2.717769918e-03f, +3.322340161e-03f, +4.339178324e-03f, -8.807356407e-03f, -3.618645803e-03f, +1.662253008e-02f, -1.975040388e-03f, -2.399056104e-02f, +1.347578136e-02f, +2.662618717e-02f, -2.885303420e-02f, -2.095152926e-02f, +4.307311623e-02f, +6.586945176e-03f, -5.024153705e-02f, +1.264632764e-02f, +4.675970757e-02f, -3.019254921e-02f, -3.349559792e-02f, +4.000830798e-02f, +1.546344784e-02f, -3.959667268e-02f, +8.406298037e-04f, +3.094034593e-02f, -1.072521805e-02f, -1.890261442e-02f, +1.318177925e-02f, +8.348192201e-03f, -1.045048317e-02f, -1.892066800e-03f, +5.982506429e-03f, -5.527085745e-04f, -2.379576454e-03f, +5.909501222e-04f, +4.850824302e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.355134276e-05f, +2.004887603e-05f, -1.554644473e-04f, +1.919183145e-05f, +3.545943872e-04f, -1.665354586e-04f, -6.448254091e-04f, +5.106836993e-04f, +1.001547249e-03f, -1.167674654e-03f, -1.366615154e-03f, +2.301008985e-03f, +1.653264841e-03f, -4.221154537e-03f, -1.778128844e-03f, +7.874022257e-03f, +1.969441845e-03f, -1.904925260e-02f, -2.048298182e-02f, +6.778334413e-03f, +2.421423541e-02f, +9.966725522e-03f, -7.540028922e-03f, -4.131250132e-03f, +4.533865761e-03f, +1.781472607e-03f, -2.977103677e-03f, -6.207732291e-04f, +1.903934920e-03f, +6.325339340e-05f, -1.128814840e-03f, +1.502574751e-04f, +5.955426518e-04f, -1.776862090e-04f, -2.636293693e-04f, +1.251206083e-04f, +8.589535914e-05f, -5.884729198e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.355134276e-05f, -2.004887603e-05f, +2.144429117e-04f, -8.454905082e-05f, -4.913803271e-04f, +4.911712416e-04f, +6.934369816e-04f, -1.272385676e-03f, -5.052423525e-04f, +2.271257013e-03f, -3.574748264e-04f, -3.056753389e-03f, +1.907233017e-03f, +3.093451758e-03f, -3.747747485e-03f, -2.057321567e-03f, +5.185374127e-03f, +9.807683830e-05f, -5.570595356e-03f, +2.154991477e-03f, +4.669795535e-03f, -3.886466567e-03f, -2.818382716e-03f, +4.517457818e-03f, +7.434815445e-04f, -3.988557310e-03f, +8.293498011e-04f, +2.731065440e-03f, -1.528915007e-03f, -1.372064648e-03f, +1.441731981e-03f, +3.885302033e-04f, -9.461414043e-04f, +7.395648112e-05f, +4.343038303e-04f, -1.504549592e-04f, -8.589535914e-05f, +5.884729198e-05f, +0.000000000e+00f,
        /*  9,13 (40) */
        +0.000000000e+00f, +9.938381493e-06f, -8.095144627e-04f, +2.467262831e-04f, +2.149794383e-03f, -1.231613644e-03f, -4.259902104e-03f, +3.638521892e-03f, +7.017487590e-03f, -8.404183010e-03f, -9.968134376e-03f, +1.678450626e-02f, +1.222393697e-02f, -3.077693842e-02f, -1.223393769e-02f, +5.498264540e-02f, +6.650918960e-03f, -1.069596252e-01f, +1.924693557e-02f, +3.811304387e-01f, +5.231862449e-01f, +2.429767073e-01f, -6.918422090e-02f, -7.586639489e-02f, +4.395512488e-02f, +3.462719530e-02f, -3.088903570e-02f, -1.594928017e-02f, +2.125066007e-02f, +6.355912334e-03f, -1.371263200e-02f, -1.635021573e-03f, +8.056595703e-03f, -2.874497542e-04f, -4.161196466e-03f, +7.143432204e-04f, +1.779511189e-03f, -5.050547631e-04f, -5.439297222e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -9.938381493e-06f, +8.095144627e-04f, -4.990457162e-04f, -2.802318969e-03f, +2.830959834e-03f, +4.830349566e-03f, -8.113919425e-03f, -4.891031479e-03f, +1.611728773e-02f, +2.962166243e-04f, -2.434803587e-02f, +1.041902798e-02f, +2.853342018e-02f, -2.575958245e-02f, -2.469927675e-02f, +4.101579467e-02f, +1.177231930e-02f, -5.014346021e-02f, +7.075732284e-03f, +4.891469905e-02f, -2.552275368e-02f, -3.738206449e-02f, +3.718992526e-02f, +1.998090565e-02f, -3.885319114e-02f, -3.147927506e-03f, +3.176969573e-02f, -7.994152605e-03f, -2.043152942e-02f, +1.180971460e-02f, +9.789924182e-03f, -1.006195297e-02f, -2.838208205e-03f, +6.056462910e-03f, -1.184047442e-04f, -2.530031414e-03f, +5.050547631e-04f, +5.439297222e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.913447055e-05f, +2.864594131e-05f, -1.489715196e-04f, -6.602181892e-06f, +3.521379039e-04f, -1.116586147e-04f, -6.605907798e-04f, +4.144389719e-04f, +1.060723315e-03f, -1.020179643e-03f, -1.508772975e-03f, +2.096488373e-03f, +1.939624746e-03f, -3.953336330e-03f, -2.316909459e-03f, +7.495415680e-03f, +3.030348290e-03f, -1.792761201e-02f, -2.144558744e-02f, +4.874687612e-03f, +2.411978892e-02f, +1.138439549e-02f, -7.026922587e-03f, -4.785522207e-03f, +4.298026076e-03f, +2.187758567e-03f, -2.890626324e-03f, -8.812751314e-04f, +1.893466033e-03f, +2.219079595e-04f, -1.150357134e-03f, +6.293841711e-05f, +6.235304087e-04f, -1.366944058e-04f, -2.855936222e-04f, +1.105109674e-04f, +9.831851840e-05f, -5.641075041e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -3.913447055e-05f, -2.864594131e-05f, +2.058395148e-04f, -4.387886421e-05f, -5.026758498e-04f, +4.104073217e-04f, +7.676237739e-04f, -1.170983701e-03f, -6.877948014e-04f, +2.210626144e-03f, -5.302961668e-05f, -3.125579499e-03f, +1.529164760e-03f, +3.364659660e-03f, -3.405572999e-03f, -2.538468262e-03f, +5.008896046e-03f, +7.085952003e-04f, -5.646659450e-03f, +1.558786322e-03f, +4.994314020e-03f, -3.448245579e-03f, -3.295000408e-03f, +4.315874755e-03f, +1.230929462e-03f, -4.008706317e-03f, +4.505553522e-04f, +2.886262616e-03f, -1.310139011e-03f, -1.557305195e-03f, +1.362887090e-03f, +5.301994246e-04f, -9.481045615e-04f, -1.450451870e-06f, +4.597976294e-04f, -1.256487669e-04f, -9.831851840e-05f, +5.641075041e-05f, +0.000000000e+00f,
        /*  9,14 (40) */
        +0.000000000e+00f, +4.907285204e-05f, -7.808685214e-04f, +9.775476354e-05f, +2.143192201e-03f, -8.794757402e-04f, -4.371560718e-03f, +2.977931112e-03f, +7.431926562e-03f, -7.343459695e-03f, -1.098831402e-02f, +1.527573329e-02f, +1.432042534e-02f, -2.883731368e-02f, -1.618727402e-02f, +5.266573594e-02f, +1.414633464e-02f, -1.039292769e-01f, +1.319323565e-03f, +3.596848512e-01f, +5.280609325e-01f, +2.670964963e-01f, -5.779982541e-02f, -8.289331748e-02f, +3.916960267e-02f, +3.892522138e-02f, -2.870127713e-02f, -1.883990649e-02f, +2.036938493e-02f, +8.249378367e-03f, -1.349072404e-02f, -2.785378707e-03f, +8.119534120e-03f, +3.360806545e-04f, -4.297890872e-03f, +4.287495982e-04f, +1.890022156e-03f, -4.067362447e-04f, -6.003404726e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -4.907285204e-05f, +7.808685214e-04f, -2.932062015e-04f, -2.846197833e-03f, +2.328283984e-03f, +5.240756887e-03f, -7.346295651e-03f, -6.062015180e-03f, +1.542949293e-02f, +2.506842768e-03f, -2.440106548e-02f, +7.293448477e-03f, +3.006258494e-02f, -2.239492279e-02f, -2.810484974e-02f, +3.847732640e-02f, +1.678121535e-02f, -4.943486501e-02f, +1.429072834e-03f, +5.047348537e-02f, -2.052843966e-02f, -4.083031007e-02f, +3.389492485e-02f, +2.429678041e-02f, -3.762226168e-02f, -7.156633823e-03f, +3.222025109e-02f, -5.107889989e-03f, -2.174166843e-02f, +1.025240941e-02f, +1.115281127e-02f, -9.531753544e-03f, -3.786312766e-03f, +6.055012458e-03f, +3.413928852e-04f, -2.655680181e-03f, +4.067362447e-04f, +6.003404726e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.449908995e-05f, +3.626869734e-05f, -1.410160841e-04f, -3.100013789e-05f, +3.456925702e-04f, -5.777636716e-05f, -6.682608626e-04f, +3.169565730e-04f, +1.106062470e-03f, -8.660702928e-04f, -1.629859646e-03f, +1.875155598e-03f, +2.196044431e-03f, -3.651177164e-03f, -2.812587184e-03f, +7.053008544e-03f, +4.010242802e-03f, -1.672914678e-02f, -2.226991169e-02f, +2.938075104e-03f, +2.387804682e-02f, +1.278083917e-02f, -6.415233152e-03f, -5.412402635e-03f, +4.006358736e-03f, +2.582598789e-03f, -2.768806560e-03f, -1.139975466e-03f, +1.861027071e-03f, +3.833270077e-04f, -1.159326250e-03f, -2.840888309e-05f, +6.452740583e-04f, -9.223178851e-05f, -3.051331657e-04f, +9.367745324e-05f, +1.102371737e-04f, -5.294752732e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -3.449908995e-05f, -3.626869734e-05f, +1.949270588e-04f, -4.923932350e-06f, -5.069019624e-04f, +3.278005785e-04f, +8.293981165e-04f, -1.058200773e-03f, -8.565848337e-04f, +2.124084753e-03f, +2.454207327e-04f, -3.154504429e-03f, +1.138362217e-03f, +3.590713239e-03f, -3.025262961e-03f, -2.984137637e-03f, +4.771847280e-03f, +1.307846094e-03f, -5.652928597e-03f, +9.431245850e-04f, +5.257929761e-03f, -2.965184200e-03f, -3.734171146e-03f, +4.058694388e-03f, +1.708904058e-03f, -3.979018819e-03f, +5.954087941e-05f, +3.008215065e-03f, -1.069656674e-03f, -1.727641254e-03f, +1.264117719e-03f, +6.699201149e-04f, -9.376714072e-04f, -8.029617568e-05f, +4.803221480e-04f, -9.746178296e-05f, -1.102371737e-04f, +5.294752732e-05f, +0.000000000e+00f,
        /*  9,15 (40) */
        +0.000000000e+00f, +8.357194200e-05f, -7.445998240e-04f, -4.326132053e-05f, +2.112192063e-03f, -5.337831700e-04f, -4.429337085e-03f, +2.309670250e-03f, +7.748883135e-03f, -6.237397224e-03f, -1.185438431e-02f, +1.364587364e-02f, +1.619558094e-02f, -2.664126924e-02f, -1.983845119e-02f, +4.985314876e-02f, +2.119934318e-02f, -9.991903408e-02f, -1.540982321e-02f, +3.374149395e-01f, +5.309990076e-01f, +2.909745431e-01f, -4.501898624e-02f, -8.930855063e-02f, +3.375720004e-02f, +4.293158011e-02f, -2.611867834e-02f, -2.160871305e-02f, +1.922940947e-02f, +1.011040544e-02f, -1.310739703e-02f, -3.944704957e-03f, +8.091125237e-03f, +9.813547128e-04f, -4.390122660e-03f, +1.236164325e-04f, +1.983699609e-03f, -2.964990710e-04f, -6.532880000e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -8.357194200e-05f, +7.445998240e-04f, -9.827914271e-05f, -2.851121766e-03f, +1.821382022e-03f, +5.568557466e-03f, -6.516897535e-03f, -7.120215954e-03f, +1.457290810e-02f, +4.630927521e-03f, -2.415564475e-02f, +4.138944048e-03f, +3.120094716e-02f, -1.880420955e-02f, -3.113011271e-02f, +3.549318877e-02f, +2.155306263e-02f, -4.812701891e-02f, -4.223855762e-03f, +5.141660995e-02f, -1.527050990e-02f, -4.379549427e-02f, +3.016075371e-02f, +2.835547480e-02f, -3.591335762e-02f, -1.113565264e-02f, +3.227979197e-02f, -2.099674924e-03f, -2.281132511e-02f, +8.524768155e-03f, +1.241692899e-02f, -8.861833429e-03f, -4.723984173e-03f, +5.974716282e-03f, +8.217150332e-04f, -2.753141964e-03f, +2.964990710e-04f, +6.532880000e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.973358537e-05f, +4.287448115e-05f, -1.317810928e-04f, -5.377230458e-05f, +3.355126957e-04f, -5.477384785e-06f, -6.680518135e-04f, +2.193896372e-04f, +1.137512275e-03f, -7.072796253e-04f, -1.729177185e-03f, +1.639950353e-03f, +2.420637634e-03f, -3.318981920e-03f, -3.261396848e-03f, +6.553589036e-03f, +4.903822234e-03f, -1.546450254e-02f, -2.295187420e-02f, +9.815742514e-04f, +2.348852223e-02f, +1.414466048e-02f, -5.706661215e-03f, -6.004267817e-03f, +3.660171795e-03f, +2.961245233e-03f, -2.611918560e-03f, -1.393878176e-03f, +1.806291018e-03f, +5.457330918e-04f, -1.155179992e-03f, -1.228524648e-04f, +6.602637232e-04f, -4.469181001e-05f, -3.218869068e-04f, +7.472014895e-05f, +1.214566576e-04f, -4.843734294e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.973358537e-05f, -4.287448115e-05f, +1.820124374e-04f, +3.186974957e-05f, -5.043349974e-04f, +2.445082970e-04f, +8.784127114e-04f, -9.358410193e-04f, -1.009860492e-03f, +2.013366884e-03f, +5.342574714e-04f, -3.143917298e-03f, +7.399153723e-04f, +3.769404223e-03f, -2.611983874e-03f, -3.389085798e-03f, +4.477572991e-03f, +1.888406059e-03f, -5.589460748e-03f, +3.156886903e-04f, +5.457193385e-03f, -2.443118584e-03f, -4.130118087e-03f, +3.748628172e-03f, +2.171261040e-03f, -3.899152682e-03f, -3.389294331e-04f, +3.094701674e-03f, -8.100621742e-04f, -1.880473749e-03f, +1.146118613e-03f, +8.057764558e-04f, -9.145006501e-04f, -1.616505191e-04f, +4.953319912e-04f, -6.611005247e-05f, -1.214566576e-04f, +4.843734294e-05f, +0.000000000e+00f,
        /* 10, 0 (36) */
        +0.000000000e+00f, -7.608322579e-04f, +1.118776550e-03f, +1.378251293e-03f, -3.996866387e-03f, -8.778420085e-05f, +8.463162654e-03f, -5.917369532e-03f, -1.170469082e-02f, +1.883055804e-02f, +7.720230922e-03f, -3.819223843e-02f, +1.284965533e-02f, +5.985703519e-02f, -6.898457622e-02f, -7.711293861e-02f, +3.046497488e-01f, +5.837128805e-01f, +3.046497488e-01f, -7.711293861e-02f, -6.898457622e-02f, +5.985703519e-02f, +1.284965533e-02f, -3.819223843e-02f, +7.720230922e-03f, +1.883055804e-02f, -1.170469082e-02f, -5.917369532e-03f, +8.463162654e-03f, -8.778420085e-05f, -3.996866387e-03f, +1.378251293e-03f, +1.118776550e-03f, -7.608322579e-04f, -9.130911868e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +7.608322579e-04f, -1.118776550e-03f, -1.032757977e-03f, +5.537963620e-03f, -3.277985306e-03f, -8.278225430e-03f, +1.383882521e-02f, +1.771302895e-03f, -2.355345110e-02f, +1.719759611e-02f, +1.895372978e-02f, -3.796855404e-02f, +5.697284657e-03f, +4.123561278e-02f, -3.721413273e-02f, -1.801118074e-02f, +5.173229864e-02f, -1.801118074e-02f, -3.721413273e-02f, +4.123561278e-02f, +5.697284657e-03f, -3.796855404e-02f, +1.895372978e-02f, +1.719759611e-02f, -2.355345110e-02f, +1.771302895e-03f, +1.383882521e-02f, -8.278225430e-03f, -3.277985306e-03f, +5.537963620e-03f, -1.032757977e-03f, -1.549282673e-03f, +7.608322579e-04f, +9.130911868e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -8.610096471e-06f, -1.734450844e-04f, +2.063423291e-04f, +2.542369269e-04f, -6.829239910e-04f, +9.061379130e-06f, +1.334740657e-03f, -9.962288442e-04f, -1.700823497e-03f, +2.950847993e-03f, +9.379074490e-04f, -5.831432835e-03f, +2.255639644e-03f, +9.836779302e-03f, -1.170154190e-02f, -2.894571562e-02f, -1.297262942e-03f, +2.854133495e-02f, +1.357609648e-02f, -9.381395225e-03f, -3.164503237e-03f, +5.873380723e-03f, -4.504223033e-04f, -3.160553007e-03f, +1.503966945e-03f, +1.194919714e-03f, -1.306087259e-03f, -1.276517827e-04f, +7.164513821e-04f, -2.103608979e-04f, -2.390309122e-04f, +1.688223017e-04f, +2.190255501e-05f, -5.023134456e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +8.610096471e-06f, +1.734450844e-04f, -3.463027545e-04f, -1.500603778e-04f, +9.815523707e-04f, -7.206449357e-04f, -1.114731918e-03f, +2.286851473e-03f, -3.065756726e-04f, -3.135594535e-03f, +3.100476839e-03f, +1.596989202e-03f, -5.198937536e-03f, +2.172477802e-03f, +4.288541765e-03f, -5.598913174e-03f, -3.783561031e-04f, +5.878377207e-03f, -3.766421654e-03f, -2.797408819e-03f, +5.174551379e-03f, -1.058782302e-03f, -3.437091543e-03f, +2.946312073e-03f, +6.670301471e-04f, -2.380746322e-03f, +9.426127885e-04f, +8.762743588e-04f, -9.760043827e-04f, +7.025519776e-05f, +3.861753858e-04f, -2.019751614e-04f, -2.190255501e-05f, +5.023134456e-05f, +0.000000000e+00f,
        /* 10, 1 (36) */
        +0.000000000e+00f, -7.694423543e-04f, +9.453314657e-04f, +1.584593622e-03f, -3.742629460e-03f, -7.707081919e-04f, +8.472224034e-03f, -4.582628874e-03f, -1.270091967e-02f, +1.712973454e-02f, +1.067107892e-02f, -3.725433098e-02f, +7.018222492e-03f, +6.211267483e-02f, -5.914779692e-02f, -8.881448051e-02f, +2.757040332e-01f, +5.824156176e-01f, +3.331910838e-01f, -6.353684213e-02f, -7.836597145e-02f, +5.669253195e-02f, +1.872303605e-02f, -3.864266074e-02f, +4.559677915e-03f, +2.033452499e-02f, -1.050977111e-02f, -7.223456790e-03f, +8.335510872e-03f, +6.286671812e-04f, -4.207227285e-03f, +1.139220381e-03f, +1.287598852e-03f, -7.389297029e-04f, -1.415404632e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +7.694423543e-04f, -9.453314657e-04f, -1.379060731e-03f, +5.387903242e-03f, -2.296432935e-03f, -8.998870366e-03f, +1.272409329e-02f, +4.058154368e-03f, -2.386002677e-02f, +1.406200157e-02f, +2.205420662e-02f, -3.637156484e-02f, +4.983471210e-04f, +4.340809058e-02f, -3.292559096e-02f, -2.361009391e-02f, +5.135394254e-02f, -1.213280353e-02f, -4.098055438e-02f, +3.843820396e-02f, +1.087183604e-02f, -3.902733634e-02f, +1.551663824e-02f, +2.014390818e-02f, -2.288642095e-02f, -6.094434262e-04f, +1.478143799e-02f, -7.401951071e-03f, -4.253989689e-03f, +5.608218818e-03f, -6.465825911e-04f, -1.751257834e-03f, +7.389297029e-04f, +1.415404632e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.784329719e-06f, -1.751889823e-04f, +1.725279642e-04f, +2.923973489e-04f, -6.415112318e-04f, -1.047914687e-04f, +1.344314247e-03f, -7.913703976e-04f, -1.868239599e-03f, +2.709265681e-03f, +1.396420030e-03f, -5.715262794e-03f, +1.353708248e-03f, +1.014940430e-02f, -9.815654971e-03f, -2.913597658e-02f, -3.881199688e-03f, +2.792284028e-02f, +1.542130069e-02f, -8.782090082e-03f, -4.068870907e-03f, +5.837850146e-03f, +6.046392525e-05f, -3.334406648e-03f, +1.279348831e-03f, +1.384438913e-03f, -1.258014460e-03f, -2.494776366e-04f, +7.412442005e-04f, -1.611372539e-04f, -2.700242113e-04f, +1.612093921e-04f, +3.592407024e-05f, -5.391097472e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -3.784329719e-06f, +1.751889823e-04f, -3.032592295e-04f, -2.234675677e-04f, +9.718574754e-04f, -5.600141608e-04f, -1.264509408e-03f, +2.161546552e-03f, +4.961619248e-05f, -3.274497897e-03f, +2.723920263e-03f, +2.103880952e-03f, -5.146294832e-03f, +1.520757418e-03f, +4.744380058e-03f, -5.237480478e-03f, -1.129403384e-03f, +6.071456451e-03f, -3.185499788e-03f, -3.385910532e-03f, +5.072635585e-03f, -4.969786261e-04f, -3.727931714e-03f, +2.708498128e-03f, +1.026284678e-03f, -2.440867502e-03f, +7.501245237e-04f, +1.024220164e-03f, -9.546290909e-04f, -1.493482220e-05f, +4.219838745e-04f, -1.880624540e-04f, -3.592407024e-05f, +5.391097472e-05f, +0.000000000e+00f,
        /* 10, 2 (36) */
        +0.000000000e+00f, -7.656580246e-04f, +7.701424835e-04f, +1.757121586e-03f, -3.450232112e-03f, -1.412219424e-03f, +8.367432565e-03f, -3.238314627e-03f, -1.349229007e-02f, +1.526149494e-02f, +1.338034460e-02f, -3.585791095e-02f, +1.302959698e-03f, +6.346638308e-02f, -4.899839262e-02f, -9.863013548e-02f, +2.465680566e-01f, +5.785344179e-01f, +3.611139240e-01f, -4.811554144e-02f, -8.714806153e-02f, +5.262366104e-02f, +2.456088620e-02f, -3.858219681e-02f, +1.225271268e-03f, +2.161387382e-02f, -9.125332197e-03f, -8.481471251e-03f, +8.086033235e-03f, +1.369911382e-03f, -4.368364539e-03f, +8.691961692e-04f, +1.448808244e-03f, -7.030056326e-04f, -1.954514380e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +7.656580246e-04f, -7.701424835e-04f, -1.682319961e-03f, +5.164435675e-03f, -1.324575460e-03f, -9.558884527e-03f, +1.145958388e-02f, +6.219700920e-03f, -2.381041058e-02f, +1.078750368e-02f, +2.477812689e-02f, -3.426768389e-02f, -4.647947712e-03f, +4.492884800e-02f, -2.818121091e-02f, -2.884757439e-02f, +5.022453916e-02f, -6.061347078e-03f, -4.416605417e-02f, +3.505229343e-02f, +1.594447162e-02f, -3.952431497e-02f, +1.178870653e-02f, +2.285240631e-02f, -2.186013627e-02f, -3.050310928e-03f, +1.553156252e-02f, -6.377730908e-03f, -5.208618780e-03f, +5.593283996e-03f, -2.245987165e-04f, -1.939320288e-03f, +7.030056326e-04f, +1.954514380e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.513779949e-05f, -1.742040072e-04f, +1.381448576e-04f, +3.245741528e-04f, -5.931378417e-04f, -2.125299559e-04f, +1.335397235e-03f, -5.833270222e-04f, -2.004987484e-03f, +2.440070971e-03f, +1.820947750e-03f, -5.528955538e-03f, +4.696474517e-04f, +1.032192300e-02f, -7.936149909e-03f, -2.911410294e-02f, -6.433473934e-03f, +2.709224689e-02f, +1.721901681e-02f, -8.039244336e-03f, -4.956947418e-03f, +5.722482458e-03f, +5.886766699e-04f, -3.468789506e-03f, +1.029091125e-03f, +1.561802592e-03f, -1.190446501e-03f, -3.729285139e-04f, +7.565447293e-04f, -1.070329941e-04f, -2.987487070e-04f, +1.505379459e-04f, +5.048104610e-05f, -5.686799517e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -1.513779949e-05f, +1.742040072e-04f, -2.579436044e-04f, -2.896164368e-04f, +9.477237061e-04f, -3.970459732e-04f, -1.390382041e-03f, +2.007613800e-03f, +3.962779854e-04f, -3.361979505e-03f, +2.313761148e-03f, +2.572322046e-03f, -5.018283861e-03f, +8.522127213e-04f, +5.127499849e-03f, -4.799722777e-03f, -1.863542627e-03f, +6.175033338e-03f, -2.554190250e-03f, -3.928819409e-03f, +4.893869695e-03f, +8.023245599e-05f, -3.967771208e-03f, +2.424792516e-03f, +1.378763756e-03f, -2.465319555e-03f, +5.396297686e-04f, +1.161825532e-03f, -9.170806654e-04f, -1.043542233e-04f, +4.528571409e-04f, -1.696619686e-04f, -5.048104610e-05f, +5.686799517e-05f, +0.000000000e+00f,
        /* 10, 3 (36) */
        +0.000000000e+00f, -7.505202251e-04f, +5.959384762e-04f, +1.895266444e-03f, -3.125657959e-03f, -2.005357265e-03f, +8.154902609e-03f, -1.902917392e-03f, -1.407561709e-02f, +1.325650746e-02f, +1.582041557e-02f, -3.403696320e-02f, -4.225995840e-03f, +6.393603053e-02f, -3.867646963e-02f, -1.065662854e-01f, +2.174539537e-01f, +5.721009440e-01f, +3.882061709e-01f, -3.089652464e-02f, -9.518730587e-02f, +4.766671363e-02f, +3.028336865e-02f, -3.799352014e-02f, -2.243518239e-03f, +2.264296494e-02f, -7.563529605e-03f, -9.671917752e-03f, +7.713104721e-03f, +2.126456111e-03f, -4.475397533e-03f, +5.704474622e-04f, +1.599346190e-03f, -6.525245865e-04f, -2.523194331e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +7.505202251e-04f, -5.959384762e-04f, -1.940263565e-03f, +4.874819238e-03f, -3.768517537e-04f, -9.955930500e-03f, +1.006920184e-02f, +8.227314721e-03f, -2.341413259e-02f, +7.425524173e-03f, +2.709188803e-02f, -3.169536184e-02f, -9.666231573e-03f, +4.578106072e-02f, -2.305371106e-02f, -3.364729716e-02f, +4.836099653e-02f, +1.136862607e-04f, -4.672024442e-02f, +3.112347402e-02f, +2.083834132e-02f, -3.944408252e-02f, +7.820935319e-03f, +2.527719883e-02f, -2.048137252e-02f, -5.515630483e-03f, +1.607119229e-02f, -5.215905376e-03f, -6.125699445e-03f, +5.488929773e-03f, +2.282584243e-04f, -2.108982257e-03f, +6.525245865e-04f, +2.523194331e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.533435089e-05f, -1.706744610e-04f, +1.037297279e-04f, +3.505987525e-04f, -5.387876784e-04f, -3.129171415e-04f, +1.308811255e-03f, -3.750199130e-04f, -2.110292211e-03f, +2.147753875e-03f, +2.207084703e-03f, -5.277347306e-03f, -3.862076857e-04f, +1.035841164e-02f, -6.080258955e-03f, -2.888403095e-02f, -8.933325890e-03f, +2.605357718e-02f, +1.895117576e-02f, -7.154815972e-03f, -5.816700690e-03f, +5.525876329e-03f, +1.127702779e-03f, -3.560497858e-03f, +7.557444035e-04f, +1.724089980e-03f, -1.103582358e-03f, -4.963048970e-04f, +7.617019767e-04f, -4.861157251e-05f, -3.246357830e-04f, +1.367859399e-04f, +6.535721937e-05f, -5.897846436e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -2.533435089e-05f, +1.706744610e-04f, -2.112442972e-04f, -3.478069317e-04f, +9.101527510e-04f, -2.343439974e-04f, -1.491207895e-03f, +1.828199279e-03f, +7.284145239e-04f, -3.397801589e-03f, +1.876739421e-03f, +2.995861166e-03f, -4.817686777e-03f, +1.769787936e-04f, +5.432600469e-03f, -4.292421448e-03f, -2.569789586e-03f, +6.187339930e-03f, -1.881716702e-03f, -4.417593386e-03f, +4.640115837e-03f, +6.643113960e-04f, -4.152082301e-03f, +2.098601618e-03f, +1.718864774e-03f, -2.452718358e-03f, +3.138551405e-04f, +1.286503976e-03f, -8.632675193e-04f, -1.967187451e-04f, +4.779633281e-04f, -1.468021015e-04f, -6.535721937e-05f, +5.897846436e-05f, +0.000000000e+00f,
        /* 10, 4 (36) */
        +0.000000000e+00f, -7.251858742e-04f, +4.252640152e-04f, +1.998996172e-03f, -2.775059206e-03f, -2.544144944e-03f, +7.841985467e-03f, -5.941061375e-04f, -1.445063700e-02f, +1.114621525e-02f, +1.796816944e-02f, -3.182987850e-02f, -9.503343145e-03f, +6.354982285e-02f, -2.831805799e-02f, -1.126465443e-01f, +1.885699227e-01f, +5.631676181e-01f, +4.142597481e-01f, -1.194534887e-02f, -1.023421218e-01f, +4.185001294e-02f, +3.580924498e-02f, -3.686581736e-02f, -5.804016097e-03f, +2.339870935e-02f, -5.839439625e-03f, -1.077550011e-02f, +7.216799824e-03f, +2.888158088e-03f, -4.524009106e-03f, +2.458116791e-04f, +1.736132130e-03f, -5.871673671e-04f, -3.112978975e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +7.251858742e-04f, -4.252640152e-04f, -2.151507862e-03f, +4.527012306e-03f, +5.333009973e-04f, -1.019027450e-02f, +8.577993945e-03f, +1.005551400e-02f, -2.268571807e-02f, +4.027722584e-03f, +2.896862746e-02f, -2.869950068e-02f, -1.448391835e-02f, +4.595803951e-02f, -1.762111059e-02f, -3.793971861e-02f, +4.579120694e-02f, +6.301026190e-03f, -4.860196112e-02f, +2.670588063e-02f, +2.547845715e-02f, -3.877977112e-02f, +3.668853018e-03f, +2.737580044e-02f, -1.876250774e-02f, -7.968348841e-03f, +1.638504743e-02f, -3.929401400e-03f, -6.988966964e-03f, +5.292211027e-03f, +7.062217525e-04f, -2.255784358e-03f, +5.871673671e-04f, +3.112978975e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.428538431e-05f, -1.648141284e-04f, +6.979179289e-05f, +3.703999734e-04f, -4.794871086e-04f, -4.048679758e-04f, +1.265590524e-03f, -1.692709848e-04f, -2.183827185e-03f, +1.836962834e-03f, +2.551069338e-03f, -4.965941208e-03f, -1.204228959e-03f, +1.026428799e-02f, -4.264562282e-03f, -2.845158803e-02f, -1.136051456e-02f, +2.481283688e-02f, +2.059996734e-02f, -6.132358280e-03f, -6.635998333e-03f, +5.247637001e-03f, +1.670662808e-03f, -3.606800958e-03f, +4.622669339e-04f, +1.868486791e-03f, -9.979030911e-04f, -6.178394611e-04f, +7.561859339e-04f, +1.347126320e-05f, -3.471309988e-04f, +1.199806996e-04f, +8.031612747e-05f, -6.012611049e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -3.428538431e-05f, +1.648141284e-04f, -1.640243894e-04f, -3.975036781e-04f, +8.603196375e-04f, -7.441197769e-05f, -1.566271235e-03f, +1.626753728e-03f, +1.041374031e-03f, -3.382518597e-03f, +1.419885067e-03f, +3.368820468e-03f, -4.548352097e-03f, -4.947957059e-04f, +5.655591827e-03f, -3.723388442e-03f, -3.237586949e-03f, +6.107988193e-03f, -1.177974736e-03f, -4.844448366e-03f, +4.314402501e-03f, +1.246496406e-03f, -4.277118059e-03f, +1.734060021e-03f, +2.041046287e-03f, -2.402227156e-03f, +7.585826118e-05f, +1.395784589e-03f, -7.933642114e-04f, -2.906317128e-04f, +4.965269876e-04f, -1.195978440e-04f, -8.031612747e-05f, +6.012611049e-05f, +0.000000000e+00f,
        /* 10, 5 (36) */
        +0.000000000e+00f, -6.909004899e-04f, +2.604498868e-04f, +2.068787965e-03f, -2.404659233e-03f, -3.023632052e-03f, +7.437117492e-03f, +6.714843867e-04f, -1.461990799e-02f, +8.962388064e-03f, +1.980513228e-02f, -2.927880916e-02f, -1.446928435e-02f, +6.234559389e-02f, -1.805377000e-02f, -1.169111066e-01f, +1.601183347e-01f, +5.518071035e-01f, +4.390725850e-01f, +8.654618468e-03f, -1.084744801e-01f, +3.521401460e-02f, +4.105688198e-02f, -3.519515455e-02f, -9.410817054e-03f, +2.386097628e-02f, -3.970952834e-03f, -1.177340320e-02f, +6.598960363e-03f, +3.644344022e-03f, -4.510537843e-03f, -1.013193196e-04f, +1.856112829e-03f, -5.068512397e-04f, -3.714240080e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +6.909004899e-04f, -2.604498868e-04f, -2.315532252e-03f, +4.129508628e-03f, +1.393620635e-03f, -1.026468647e-02f, +7.011722709e-03f, +1.168226773e-02f, -2.164434404e-02f, +6.452039870e-04f, +3.038851252e-02f, -2.533068021e-02f, -1.903227045e-02f, +4.546324381e-02f, -1.196551876e-02f, -4.166310706e-02f, +4.255361999e-02f, +1.240901438e-02f, -4.977993586e-02f, +2.186143227e-02f, +2.979285965e-02f, -3.753327471e-02f, -6.082650413e-04f, +2.910986046e-02f, -1.672146145e-02f, -1.037057600e-02f, +1.646090569e-02f, -2.533616811e-03f, -7.782331176e-03f, +5.001579315e-03f, +1.202748740e-03f, -2.375382202e-03f, +5.068512397e-04f, +3.714240080e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.192957089e-05f, -1.568612381e-04f, +3.680635368e-05f, +3.840006722e-04f, -4.162884493e-04f, -4.874587115e-04f, +1.206959738e-03f, +3.123232161e-05f, -2.225703758e-03f, +1.512437996e-03f, +2.849812934e-03f, -4.600816928e-03f, -1.975587388e-03f, +1.004621600e-02f, -2.504827690e-03f, -2.782441339e-02f, -1.369551728e-02f, +2.337797012e-02f, +2.214803029e-02f, -4.977019822e-03f, -7.402748914e-03f, +4.888414249e-03f, +2.210390368e-03f, -3.605493710e-03f, +1.519974222e-04f, +1.992328603e-03f, -8.741753758e-04f, -7.357201704e-04f, +7.396006017e-04f, +7.847324282e-05f, -3.657035821e-04f, +1.002011889e-04f, +9.510407349e-05f, -6.020509376e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.192957089e-05f, +1.568612381e-04f, -1.171078463e-04f, -4.383373773e-04f, +7.995464616e-04f, +8.038279173e-05f, -1.615280415e-03f, +1.406970164e-03f, +1.330912198e-03f, -3.317452385e-03f, +9.504049408e-04f, +3.686371627e-03f, -4.215123603e-03f, -1.153103885e-03f, +5.793649839e-03f, -3.101343533e-03f, -3.856965741e-03f, +5.937978961e-03f, -4.533831067e-04f, -5.202483955e-03f, +3.920889906e-03f, +1.817936591e-03f, -4.339983708e-03f, +1.335979822e-03f, +2.339917301e-03f, -2.313584651e-03f, -1.710116581e-04f, +1.487356930e-03f, -7.078192505e-04f, -3.846031339e-04f, +5.078460812e-04f, -8.825372617e-05f, -9.510407349e-05f, +6.020509376e-05f, +0.000000000e+00f,
        /* 10, 6 (36) */
        +0.000000000e+00f, -6.489709190e-04f, +1.035886486e-04f, +2.105594318e-03f, -2.020658561e-03f, -3.439920502e-03f, +6.949658780e-03f, +1.878444125e-03f, -1.458867566e-02f, +6.736684306e-03f, +2.131757027e-02f, -2.642899623e-02f, -1.907010128e-02f, +6.037000650e-02f, -8.007554010e-03f, -1.194159343e-01f, +1.322939213e-01f, +5.381115862e-01f, +4.624505551e-01f, +3.080264876e-02f, -1.134514999e-01f, +2.781126569e-02f, +4.594529623e-02f, -3.298476419e-02f, -1.301631076e-02f, +2.401297370e-02f, -1.978624231e-03f, -1.264757858e-02f, +5.863240193e-03f, +4.383944623e-03f, -4.432064600e-03f, -4.670229017e-04f, +1.956314018e-03f, -4.117471662e-04f, -4.316291017e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +6.489709190e-04f, -1.035886486e-04f, -2.432640098e-03f, +3.691171251e-03f, +2.193167096e-03f, -1.018430368e-02f, +5.396442294e-03f, +1.308923789e-02f, -2.031343184e-02f, -2.672248398e-03f, +3.133891746e-02f, -2.164430858e-02f, -2.324739405e-02f, +4.431013992e-02f, -6.171868922e-03f, -4.476445059e-02f, +3.869665425e-02f, +1.834699334e-02f, -5.023331897e-02f, +1.665894831e-02f, +3.371374956e-02f, -3.571533812e-02f, -4.948248749e-03f, +3.044584029e-02f, -1.438154415e-02f, -1.268416065e-02f, +1.628989403e-02f, -1.046259880e-03f, -8.490150426e-03f, +4.616976181e-03f, +1.710594821e-03f, -2.463635928e-03f, +4.117471662e-04f, +4.316291017e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.823229520e-05f, -1.470732843e-04f, +5.209207025e-06f, +3.915130981e-04f, -3.502537026e-04f, -5.599336583e-04f, +1.134310075e-03f, +2.239691981e-04f, -2.236455243e-03f, +1.178945346e-03f, +3.100918505e-03f, -4.188535847e-03f, -2.692333594e-03f, +9.711998452e-03f, -8.158617887e-04f, -2.701186007e-02f, -1.591972134e-02f, +2.175879357e-02f, +2.357864012e-02f, -3.695526276e-03f, -8.105046358e-03f, +4.449928273e-03f, +2.739517692e-03f, -3.554943868e-03f, -1.713784116e-04f, +2.093143592e-03f, -7.334510579e-04f, -8.481149112e-04f, +7.116955357e-04f, +1.455729348e-04f, -3.798559979e-04f, +7.757955797e-05f, +1.094535619e-04f, -5.912273056e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -4.823229520e-05f, +1.470732843e-04f, -7.126711184e-05f, -4.701033003e-04f, +7.292747038e-04f, +2.278425380e-04f, -1.638359030e-03f, +1.172719323e-03f, +1.593248327e-03f, -3.204655905e-03f, +4.755687618e-04f, +3.944597606e-03f, -3.823754627e-03f, -1.788232438e-03f, +5.845251949e-03f, -2.435777920e-03f, -4.418697522e-03f, +5.679689375e-03f, +2.812738550e-04f, -5.485796362e-03f, +3.464817326e-03f, +2.369828215e-03f, -4.338695672e-03f, +9.097881746e-04f, +2.610326149e-03f, -2.187124480e-03f, -4.231592095e-04f, +1.559114740e-03f, -6.073585134e-04f, -4.770712771e-04f, +5.113084792e-04f, -5.306519586e-05f, -1.094535619e-04f, +5.912273056e-05f, +0.000000000e+00f,
        /* 10, 7 (36) */
        +0.000000000e+00f, -6.007386238e-04f, -4.348463569e-05f, +2.110803525e-03f, -1.629145463e-03f, -3.790174204e-03f, +6.389725122e-03f, +3.012754199e-03f, -1.436470647e-02f, +4.500229063e-03f, +2.249651562e-02f, -2.332807772e-02f, -2.325863713e-02f, +5.767767291e-02f, +1.704444442e-03f, -1.202317961e-01f, +1.052820612e-01f, +5.221918649e-01f, +4.842093487e-01f, +5.438128888e-02f, -1.171470262e-01f, +1.970621933e-02f, +5.039522451e-02f, -3.024524649e-02f, -1.657125463e-02f, +2.384159529e-02f, +1.145193607e-04f, -1.338102963e-02f, +5.015125282e-03f, +5.095640159e-03f, -4.286491665e-03f, -8.468788996e-04f, +2.033893576e-03f, -3.022936042e-04f, -4.907518323e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +6.007386238e-04f, +4.348463569e-05f, -2.503907210e-03f, +3.221067951e-03f, +2.922441800e-03f, -9.956461145e-03f, +3.758083264e-03f, +1.426195722e-02f, -1.872018351e-02f, -5.876904303e-03f, +3.181448622e-02f, -1.769971098e-02f, -2.707114868e-02f, +4.252190749e-02f, -3.266169733e-04f, -4.720022851e-02f, +3.427795673e-02f, +2.402668272e-02f, -4.995204511e-02f, +1.117315195e-02f, +3.717856689e-02f, -3.334550991e-02f, -9.286944420e-03f, +3.135562846e-02f, -1.177121800e-02f, -1.487128513e-02f, +1.586673482e-02f, +5.128548594e-04f, -9.097508940e-03f, +4.139904904e-03f, +2.221903300e-03f, -2.516701124e-03f, +3.022936042e-04f, +4.907518323e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.318466494e-05f, -1.357217998e-04f, -2.460806380e-05f, +3.931331187e-04f, -2.824388115e-04f, -6.217092813e-04f, +1.049173726e-03f, +4.066142464e-04f, -2.217015702e-03f, +8.412125227e-04f, +3.302690140e-03f, -3.736042896e-03f, -3.347465510e-03f, +9.270459099e-03f, +7.886258271e-04f, -2.602487989e-02f, -1.801560566e-02f, +1.996691054e-02f, +2.487589246e-02f, -2.296144059e-03f, -8.731315790e-03f, +3.934982890e-03f, +3.250566468e-03f, -3.454132949e-03f, -5.038671492e-04f, +2.168694001e-03f, -5.770625852e-04f, -9.531973567e-04f, +6.723756816e-04f, +2.138786494e-04f, -3.891334442e-04f, +5.230188514e-05f, +1.230871687e-04f, -5.680212660e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.318466494e-05f, +1.357217998e-04f, -2.721223859e-05f, -4.927570272e-04f, +6.510366524e-04f, +3.659681520e-04f, -1.636030674e-03f, +9.279840278e-04f, +1.825112831e-03f, -3.046866177e-03f, +2.596102324e-06f, +4.140539390e-03f, -3.380809234e-03f, -2.390907600e-03f, +5.810192325e-03f, -1.736806368e-03f, -4.914435019e-03f, +5.336838992e-03f, +1.015010234e-03f, -5.689576599e-03f, +2.952433000e-03f, +2.893551996e-03f, -4.272227167e-03f, +4.614538658e-04f, +2.847447523e-03f, -2.023785552e-03f, -6.767935767e-04f, +1.609197730e-03f, -4.929840536e-04f, -5.664264510e-04f, +5.064076230e-04f, -1.441832443e-05f, -1.230871687e-04f, +5.680212660e-05f, +0.000000000e+00f,
        /* 10, 8 (36) */
        +0.000000000e+00f, -5.475539589e-04f, -1.792064355e-04f, +2.086195461e-03f, -1.236012344e-03f, -4.072613016e-03f, +5.768015841e-03f, +4.061927925e-03f, -1.395809222e-02f, +2.283213361e-03f, +2.333772814e-02f, -2.002538758e-02f, -2.699468003e-02f, +5.433020740e-02f, +1.097490354e-02f, -1.194431703e-01f, +7.925718134e-02f, +5.041762592e-01f, +5.041762592e-01f, +7.925718134e-02f, -1.194431703e-01f, +1.097490354e-02f, +5.433020740e-02f, -2.699468003e-02f, -2.002538758e-02f, +2.333772814e-02f, +2.283213361e-03f, -1.395809222e-02f, +4.061927925e-03f, +5.768015841e-03f, -4.072613016e-03f, -1.236012344e-03f, +2.086195461e-03f, -1.792064355e-04f, -5.475539589e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.475539589e-04f, +1.792064355e-04f, -2.531119449e-03f, +2.728310923e-03f, +3.573478453e-03f, -9.590492993e-03f, +2.122052590e-03f, +1.518994124e-02f, -1.689507068e-02f, -8.923770481e-03f, +3.181708233e-02f, -1.355917159e-02f, -3.045195791e-02f, +4.013099989e-02f, +5.483575352e-03f, -4.893703488e-02f, +2.936352171e-02f, +2.936352171e-02f, -4.893703488e-02f, +5.483575352e-03f, +4.013099989e-02f, -3.045195791e-02f, -1.355917159e-02f, +3.181708233e-02f, -8.923770481e-03f, -1.689507068e-02f, +1.518994124e-02f, +2.122052590e-03f, -9.590492993e-03f, +3.573478453e-03f, +2.728310923e-03f, -2.531119449e-03f, +1.792064355e-04f, +5.475539589e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.680212660e-05f, -1.230871687e-04f, -5.230188514e-05f, +3.891334442e-04f, -2.138786494e-04f, -6.723756816e-04f, +9.531973567e-04f, +5.770625852e-04f, -2.168694001e-03f, +5.038671492e-04f, +3.454132949e-03f, -3.250566468e-03f, -3.934982890e-03f, +8.731315790e-03f, +2.296144059e-03f, -2.487589246e-02f, -1.996691054e-02f, +1.801560566e-02f, +2.602487989e-02f, -7.886258271e-04f, -9.270459099e-03f, +3.347465510e-03f, +3.736042896e-03f, -3.302690140e-03f, -8.412125227e-04f, +2.217015702e-03f, -4.066142464e-04f, -1.049173726e-03f, +6.217092813e-04f, +2.824388115e-04f, -3.931331187e-04f, +2.460806380e-05f, +1.357217998e-04f, -5.318466494e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.680212660e-05f, +1.230871687e-04f, +1.441832443e-05f, -5.064076230e-04f, +5.664264510e-04f, +4.929840536e-04f, -1.609197730e-03f, +6.767935767e-04f, +2.023785552e-03f, -2.847447523e-03f, -4.614538658e-04f, +4.272227167e-03f, -2.893551996e-03f, -2.952433000e-03f, +5.689576599e-03f, -1.015010234e-03f, -5.336838992e-03f, +4.914435019e-03f, +1.736806368e-03f, -5.810192325e-03f, +2.390907600e-03f, +3.380809234e-03f, -4.140539390e-03f, -2.596102324e-06f, +3.046866177e-03f, -1.825112831e-03f, -9.279840278e-04f, +1.636030674e-03f, -3.659681520e-04f, -6.510366524e-04f, +4.927570272e-04f, +2.721223859e-05f, -1.357217998e-04f, +5.318466494e-05f, +0.000000000e+00f,
        /* 10, 9 (36) */
        +0.000000000e+00f, -4.907518323e-04f, -3.022936042e-04f, +2.033893576e-03f, -8.468788996e-04f, -4.286491665e-03f, +5.095640159e-03f, +5.015125282e-03f, -1.338102963e-02f, +1.145193607e-04f, +2.384159529e-02f, -1.657125463e-02f, -3.024524649e-02f, +5.039522451e-02f, +1.970621933e-02f, -1.171470262e-01f, +5.438128888e-02f, +4.842093487e-01f, +5.221918649e-01f, +1.052820612e-01f, -1.202317961e-01f, +1.704444442e-03f, +5.767767291e-02f, -2.325863713e-02f, -2.332807772e-02f, +2.249651562e-02f, +4.500229063e-03f, -1.436470647e-02f, +3.012754199e-03f, +6.389725122e-03f, -3.790174204e-03f, -1.629145463e-03f, +2.110803525e-03f, -4.348463569e-05f, -6.007386238e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.907518323e-04f, +3.022936042e-04f, -2.516701124e-03f, +2.221903300e-03f, +4.139904904e-03f, -9.097508940e-03f, +5.128548594e-04f, +1.586673482e-02f, -1.487128513e-02f, -1.177121800e-02f, +3.135562846e-02f, -9.286944420e-03f, -3.334550991e-02f, +3.717856689e-02f, +1.117315195e-02f, -4.995204511e-02f, +2.402668272e-02f, +3.427795673e-02f, -4.720022851e-02f, -3.266169733e-04f, +4.252190749e-02f, -2.707114868e-02f, -1.769971098e-02f, +3.181448622e-02f, -5.876904303e-03f, -1.872018351e-02f, +1.426195722e-02f, +3.758083264e-03f, -9.956461145e-03f, +2.922441800e-03f, +3.221067951e-03f, -2.503907210e-03f, +4.348463569e-05f, +6.007386238e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.912273056e-05f, -1.094535619e-04f, -7.757955797e-05f, +3.798559979e-04f, -1.455729348e-04f, -7.116955357e-04f, +8.481149112e-04f, +7.334510579e-04f, -2.093143592e-03f, +1.713784116e-04f, +3.554943868e-03f, -2.739517692e-03f, -4.449928273e-03f, +8.105046358e-03f, +3.695526276e-03f, -2.357864012e-02f, -2.175879357e-02f, +1.591972134e-02f, +2.701186007e-02f, +8.158617887e-04f, -9.711998452e-03f, +2.692333594e-03f, +4.188535847e-03f, -3.100918505e-03f, -1.178945346e-03f, +2.236455243e-03f, -2.239691981e-04f, -1.134310075e-03f, +5.599336583e-04f, +3.502537026e-04f, -3.915130981e-04f, -5.209207025e-06f, +1.470732843e-04f, -4.823229520e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.912273056e-05f, +1.094535619e-04f, +5.306519586e-05f, -5.113084792e-04f, +4.770712771e-04f, +6.073585134e-04f, -1.559114740e-03f, +4.231592095e-04f, +2.187124480e-03f, -2.610326149e-03f, -9.097881746e-04f, +4.338695672e-03f, -2.369828215e-03f, -3.464817326e-03f, +5.485796362e-03f, -2.812738550e-04f, -5.679689375e-03f, +4.418697522e-03f, +2.435777920e-03f, -5.845251949e-03f, +1.788232438e-03f, +3.823754627e-03f, -3.944597606e-03f, -4.755687618e-04f, +3.204655905e-03f, -1.593248327e-03f, -1.172719323e-03f, +1.638359030e-03f, -2.278425380e-04f, -7.292747038e-04f, +4.701033003e-04f, +7.126711184e-05f, -1.470732843e-04f, +4.823229520e-05f, +0.000000000e+00f,
        /* 10,10 (36) */
        +0.000000000e+00f, -4.316291017e-04f, -4.117471662e-04f, +1.956314018e-03f, -4.670229017e-04f, -4.432064600e-03f, +4.383944623e-03f, +5.863240193e-03f, -1.264757858e-02f, -1.978624231e-03f, +2.401297370e-02f, -1.301631076e-02f, -3.298476419e-02f, +4.594529623e-02f, +2.781126569e-02f, -1.134514999e-01f, +3.080264876e-02f, +4.624505551e-01f, +5.381115862e-01f, +1.322939213e-01f, -1.194159343e-01f, -8.007554010e-03f, +6.037000650e-02f, -1.907010128e-02f, -2.642899623e-02f, +2.131757027e-02f, +6.736684306e-03f, -1.458867566e-02f, +1.878444125e-03f, +6.949658780e-03f, -3.439920502e-03f, -2.020658561e-03f, +2.105594318e-03f, +1.035886486e-04f, -6.489709190e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.316291017e-04f, +4.117471662e-04f, -2.463635928e-03f, +1.710594821e-03f, +4.616976181e-03f, -8.490150426e-03f, -1.046259880e-03f, +1.628989403e-02f, -1.268416065e-02f, -1.438154415e-02f, +3.044584029e-02f, -4.948248749e-03f, -3.571533812e-02f, +3.371374956e-02f, +1.665894831e-02f, -5.023331897e-02f, +1.834699334e-02f, +3.869665425e-02f, -4.476445059e-02f, -6.171868922e-03f, +4.431013992e-02f, -2.324739405e-02f, -2.164430858e-02f, +3.133891746e-02f, -2.672248398e-03f, -2.031343184e-02f, +1.308923789e-02f, +5.396442294e-03f, -1.018430368e-02f, +2.193167096e-03f, +3.691171251e-03f, -2.432640098e-03f, -1.035886486e-04f, +6.489709190e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +6.020509376e-05f, -9.510407349e-05f, -1.002011889e-04f, +3.657035821e-04f, -7.847324282e-05f, -7.396006017e-04f, +7.357201704e-04f, +8.741753758e-04f, -1.992328603e-03f, -1.519974222e-04f, +3.605493710e-03f, -2.210390368e-03f, -4.888414249e-03f, +7.402748914e-03f, +4.977019822e-03f, -2.214803029e-02f, -2.337797012e-02f, +1.369551728e-02f, +2.782441339e-02f, +2.504827690e-03f, -1.004621600e-02f, +1.975587388e-03f, +4.600816928e-03f, -2.849812934e-03f, -1.512437996e-03f, +2.225703758e-03f, -3.123232161e-05f, -1.206959738e-03f, +4.874587115e-04f, +4.162884493e-04f, -3.840006722e-04f, -3.680635368e-05f, +1.568612381e-04f, -4.192957089e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -6.020509376e-05f, +9.510407349e-05f, +8.825372617e-05f, -5.078460812e-04f, +3.846031339e-04f, +7.078192505e-04f, -1.487356930e-03f, +1.710116581e-04f, +2.313584651e-03f, -2.339917301e-03f, -1.335979822e-03f, +4.339983708e-03f, -1.817936591e-03f, -3.920889906e-03f, +5.202483955e-03f, +4.533831067e-04f, -5.937978961e-03f, +3.856965741e-03f, +3.101343533e-03f, -5.793649839e-03f, +1.153103885e-03f, +4.215123603e-03f, -3.686371627e-03f, -9.504049408e-04f, +3.317452385e-03f, -1.330912198e-03f, -1.406970164e-03f, +1.615280415e-03f, -8.038279173e-05f, -7.995464616e-04f, +4.383373773e-04f, +1.171078463e-04f, -1.568612381e-04f, +4.192957089e-05f, +0.000000000e+00f,
        /* 10,11 (36) */
        +0.000000000e+00f, -3.714240080e-04f, -5.068512397e-04f, +1.856112829e-03f, -1.013193196e-04f, -4.510537843e-03f, +3.644344022e-03f, +6.598960363e-03f, -1.177340320e-02f, -3.970952834e-03f, +2.386097628e-02f, -9.410817054e-03f, -3.519515455e-02f, +4.105688198e-02f, +3.521401460e-02f, -1.084744801e-01f, +8.654618468e-03f, +4.390725850e-01f, +5.518071035e-01f, +1.601183347e-01f, -1.169111066e-01f, -1.805377000e-02f, +6.234559389e-02f, -1.446928435e-02f, -2.927880916e-02f, +1.980513228e-02f, +8.962388064e-03f, -1.461990799e-02f, +6.714843867e-04f, +7.437117492e-03f, -3.023632052e-03f, -2.404659233e-03f, +2.068787965e-03f, +2.604498868e-04f, -6.909004899e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.714240080e-04f, +5.068512397e-04f, -2.375382202e-03f, +1.202748740e-03f, +5.001579315e-03f, -7.782331176e-03f, -2.533616811e-03f, +1.646090569e-02f, -1.037057600e-02f, -1.672146145e-02f, +2.910986046e-02f, -6.082650413e-04f, -3.753327471e-02f, +2.979285965e-02f, +2.186143227e-02f, -4.977993586e-02f, +1.240901438e-02f, +4.255361999e-02f, -4.166310706e-02f, -1.196551876e-02f, +4.546324381e-02f, -1.903227045e-02f, -2.533068021e-02f, +3.038851252e-02f, +6.452039870e-04f, -2.164434404e-02f, +1.168226773e-02f, +7.011722709e-03f, -1.026468647e-02f, +1.393620635e-03f, +4.129508628e-03f, -2.315532252e-03f, -2.604498868e-04f, +6.909004899e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +6.012611049e-05f, -8.031612747e-05f, -1.199806996e-04f, +3.471309988e-04f, -1.347126320e-05f, -7.561859339e-04f, +6.178394611e-04f, +9.979030911e-04f, -1.868486791e-03f, -4.622669339e-04f, +3.606800958e-03f, -1.670662808e-03f, -5.247637001e-03f, +6.635998333e-03f, +6.132358280e-03f, -2.059996734e-02f, -2.481283688e-02f, +1.136051456e-02f, +2.845158803e-02f, +4.264562282e-03f, -1.026428799e-02f, +1.204228959e-03f, +4.965941208e-03f, -2.551069338e-03f, -1.836962834e-03f, +2.183827185e-03f, +1.692709848e-04f, -1.265590524e-03f, +4.048679758e-04f, +4.794871086e-04f, -3.703999734e-04f, -6.979179289e-05f, +1.648141284e-04f, -3.428538431e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -6.012611049e-05f, +8.031612747e-05f, +1.195978440e-04f, -4.965269876e-04f, +2.906317128e-04f, +7.933642114e-04f, -1.395784589e-03f, -7.585826118e-05f, +2.402227156e-03f, -2.041046287e-03f, -1.734060021e-03f, +4.277118059e-03f, -1.246496406e-03f, -4.314402501e-03f, +4.844448366e-03f, +1.177974736e-03f, -6.107988193e-03f, +3.237586949e-03f, +3.723388442e-03f, -5.655591827e-03f, +4.947957059e-04f, +4.548352097e-03f, -3.368820468e-03f, -1.419885067e-03f, +3.382518597e-03f, -1.041374031e-03f, -1.626753728e-03f, +1.566271235e-03f, +7.441197769e-05f, -8.603196375e-04f, +3.975036781e-04f, +1.640243894e-04f, -1.648141284e-04f, +3.428538431e-05f, +0.000000000e+00f,
        /* 10,12 (36) */
        +0.000000000e+00f, -3.112978975e-04f, -5.871673671e-04f, +1.736132130e-03f, +2.458116791e-04f, -4.524009106e-03f, +2.888158088e-03f, +7.216799824e-03f, -1.077550011e-02f, -5.839439625e-03f, +2.339870935e-02f, -5.804016097e-03f, -3.686581736e-02f, +3.580924498e-02f, +4.185001294e-02f, -1.023421218e-01f, -1.194534887e-02f, +4.142597481e-01f, +5.631676181e-01f, +1.885699227e-01f, -1.126465443e-01f, -2.831805799e-02f, +6.354982285e-02f, -9.503343145e-03f, -3.182987850e-02f, +1.796816944e-02f, +1.114621525e-02f, -1.445063700e-02f, -5.941061375e-04f, +7.841985467e-03f, -2.544144944e-03f, -2.775059206e-03f, +1.998996172e-03f, +4.252640152e-04f, -7.251858742e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.112978975e-04f, +5.871673671e-04f, -2.255784358e-03f, +7.062217525e-04f, +5.292211027e-03f, -6.988966964e-03f, -3.929401400e-03f, +1.638504743e-02f, -7.968348841e-03f, -1.876250774e-02f, +2.737580044e-02f, +3.668853018e-03f, -3.877977112e-02f, +2.547845715e-02f, +2.670588063e-02f, -4.860196112e-02f, +6.301026190e-03f, +4.579120694e-02f, -3.793971861e-02f, -1.762111059e-02f, +4.595803951e-02f, -1.448391835e-02f, -2.869950068e-02f, +2.896862746e-02f, +4.027722584e-03f, -2.268571807e-02f, +1.005551400e-02f, +8.577993945e-03f, -1.019027450e-02f, +5.333009973e-04f, +4.527012306e-03f, -2.151507862e-03f, -4.252640152e-04f, +7.251858742e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.897846436e-05f, -6.535721937e-05f, -1.367859399e-04f, +3.246357830e-04f, +4.861157251e-05f, -7.617019767e-04f, +4.963048970e-04f, +1.103582358e-03f, -1.724089980e-03f, -7.557444035e-04f, +3.560497858e-03f, -1.127702779e-03f, -5.525876329e-03f, +5.816700690e-03f, +7.154815972e-03f, -1.895117576e-02f, -2.605357718e-02f, +8.933325890e-03f, +2.888403095e-02f, +6.080258955e-03f, -1.035841164e-02f, +3.862076857e-04f, +5.277347306e-03f, -2.207084703e-03f, -2.147753875e-03f, +2.110292211e-03f, +3.750199130e-04f, -1.308811255e-03f, +3.129171415e-04f, +5.387876784e-04f, -3.505987525e-04f, -1.037297279e-04f, +1.706744610e-04f, -2.533435089e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.897846436e-05f, +6.535721937e-05f, +1.468021015e-04f, -4.779633281e-04f, +1.967187451e-04f, +8.632675193e-04f, -1.286503976e-03f, -3.138551405e-04f, +2.452718358e-03f, -1.718864774e-03f, -2.098601618e-03f, +4.152082301e-03f, -6.643113960e-04f, -4.640115837e-03f, +4.417593386e-03f, +1.881716702e-03f, -6.187339930e-03f, +2.569789586e-03f, +4.292421448e-03f, -5.432600469e-03f, -1.769787936e-04f, +4.817686777e-03f, -2.995861166e-03f, -1.876739421e-03f, +3.397801589e-03f, -7.284145239e-04f, -1.828199279e-03f, +1.491207895e-03f, +2.343439974e-04f, -9.101527510e-04f, +3.478069317e-04f, +2.112442972e-04f, -1.706744610e-04f, +2.533435089e-05f, +0.000000000e+00f,
        /* 10,13 (36) */
        +0.000000000e+00f, -2.523194331e-04f, -6.525245865e-04f, +1.599346190e-03f, +5.704474622e-04f, -4.475397533e-03f, +2.126456111e-03f, +7.713104721e-03f, -9.671917752e-03f, -7.563529605e-03f, +2.264296494e-02f, -2.243518239e-03f, -3.799352014e-02f, +3.028336865e-02f, +4.766671363e-02f, -9.518730587e-02f, -3.089652464e-02f, +3.882061709e-01f, +5.721009440e-01f, +2.174539537e-01f, -1.065662854e-01f, -3.867646963e-02f, +6.393603053e-02f, -4.225995840e-03f, -3.403696320e-02f, +1.582041557e-02f, +1.325650746e-02f, -1.407561709e-02f, -1.902917392e-03f, +8.154902609e-03f, -2.005357265e-03f, -3.125657959e-03f, +1.895266444e-03f, +5.959384762e-04f, -7.505202251e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.523194331e-04f, +6.525245865e-04f, -2.108982257e-03f, +2.282584243e-04f, +5.488929773e-03f, -6.125699445e-03f, -5.215905376e-03f, +1.607119229e-02f, -5.515630483e-03f, -2.048137252e-02f, +2.527719883e-02f, +7.820935319e-03f, -3.944408252e-02f, +2.083834132e-02f, +3.112347402e-02f, -4.672024442e-02f, +1.136862607e-04f, +4.836099653e-02f, -3.364729716e-02f, -2.305371106e-02f, +4.578106072e-02f, -9.666231573e-03f, -3.169536184e-02f, +2.709188803e-02f, +7.425524173e-03f, -2.341413259e-02f, +8.227314721e-03f, +1.006920184e-02f, -9.955930500e-03f, -3.768517537e-04f, +4.874819238e-03f, -1.940263565e-03f, -5.959384762e-04f, +7.505202251e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.686799517e-05f, -5.048104610e-05f, -1.505379459e-04f, +2.987487070e-04f, +1.070329941e-04f, -7.565447293e-04f, +3.729285139e-04f, +1.190446501e-03f, -1.561802592e-03f, -1.029091125e-03f, +3.468789506e-03f, -5.886766699e-04f, -5.722482458e-03f, +4.956947418e-03f, +8.039244336e-03f, -1.721901681e-02f, -2.709224689e-02f, +6.433473934e-03f, +2.911410294e-02f, +7.936149909e-03f, -1.032192300e-02f, -4.696474517e-04f, +5.528955538e-03f, -1.820947750e-03f, -2.440070971e-03f, +2.004987484e-03f, +5.833270222e-04f, -1.335397235e-03f, +2.125299559e-04f, +5.931378417e-04f, -3.245741528e-04f, -1.381448576e-04f, +1.742040072e-04f, -1.513779949e-05f, +0.000000000e+00f,
        +0.000000000e+00f, -5.686799517e-05f, +5.048104610e-05f, +1.696619686e-04f, -4.528571409e-04f, +1.043542233e-04f, +9.170806654e-04f, -1.161825532e-03f, -5.396297686e-04f, +2.465319555e-03f, -1.378763756e-03f, -2.424792516e-03f, +3.967771208e-03f, -8.023245599e-05f, -4.893869695e-03f, +3.928819409e-03f, +2.554190250e-03f, -6.175033338e-03f, +1.863542627e-03f, +4.799722777e-03f, -5.127499849e-03f, -8.522127213e-04f, +5.018283861e-03f, -2.572322046e-03f, -2.313761148e-03f, +3.361979505e-03f, -3.962779854e-04f, -2.007613800e-03f, +1.390382041e-03f, +3.970459732e-04f, -9.477237061e-04f, +2.896164368e-04f, +2.579436044e-04f, -1.742040072e-04f, +1.513779949e-05f, +0.000000000e+00f,
        /* 10,14 (36) */
        +0.000000000e+00f, -1.954514380e-04f, -7.030056326e-04f, +1.448808244e-03f, +8.691961692e-04f, -4.368364539e-03f, +1.369911382e-03f, +8.086033235e-03f, -8.481471251e-03f, -9.125332197e-03f, +2.161387382e-02f, +1.225271268e-03f, -3.858219681e-02f, +2.456088620e-02f, +5.262366104e-02f, -8.714806153e-02f, -4.811554144e-02f, +3.611139240e-01f, +5.785344179e-01f, +2.465680566e-01f, -9.863013548e-02f, -4.899839262e-02f, +6.346638308e-02f, +1.302959698e-03f, -3.585791095e-02f, +1.338034460e-02f, +1.526149494e-02f, -1.349229007e-02f, -3.238314627e-03f, +8.367432565e-03f, -1.412219424e-03f, -3.450232112e-03f, +1.757121586e-03f, +7.701424835e-04f, -7.656580246e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.954514380e-04f, +7.030056326e-04f, -1.939320288e-03f, -2.245987165e-04f, +5.593283996e-03f, -5.208618780e-03f, -6.377730908e-03f, +1.553156252e-02f, -3.050310928e-03f, -2.186013627e-02f, +2.285240631e-02f, +1.178870653e-02f, -3.952431497e-02f, +1.594447162e-02f, +3.505229343e-02f, -4.416605417e-02f, -6.061347078e-03f, +5.022453916e-02f, -2.884757439e-02f, -2.818121091e-02f, +4.492884800e-02f, -4.647947712e-03f, -3.426768389e-02f, +2.477812689e-02f, +1.078750368e-02f, -2.381041058e-02f, +6.219700920e-03f, +1.145958388e-02f, -9.558884527e-03f, -1.324575460e-03f, +5.164435675e-03f, -1.682319961e-03f, -7.701424835e-04f, +7.656580246e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.391097472e-05f, -3.592407024e-05f, -1.612093921e-04f, +2.700242113e-04f, +1.611372539e-04f, -7.412442005e-04f, +2.494776366e-04f, +1.258014460e-03f, -1.384438913e-03f, -1.279348831e-03f, +3.334406648e-03f, -6.046392525e-05f, -5.837850146e-03f, +4.068870907e-03f, +8.782090082e-03f, -1.542130069e-02f, -2.792284028e-02f, +3.881199688e-03f, +2.913597658e-02f, +9.815654971e-03f, -1.014940430e-02f, -1.353708248e-03f, +5.715262794e-03f, -1.396420030e-03f, -2.709265681e-03f, +1.868239599e-03f, +7.913703976e-04f, -1.344314247e-03f, +1.047914687e-04f, +6.415112318e-04f, -2.923973489e-04f, -1.725279642e-04f, +1.751889823e-04f, -3.784329719e-06f, +0.000000000e+00f,
        +0.000000000e+00f, -5.391097472e-05f, +3.592407024e-05f, +1.880624540e-04f, -4.219838745e-04f, +1.493482220e-05f, +9.546290909e-04f, -1.024220164e-03f, -7.501245237e-04f, +2.440867502e-03f, -1.026284678e-03f, -2.708498128e-03f, +3.727931714e-03f, +4.969786261e-04f, -5.072635585e-03f, +3.385910532e-03f, +3.185499788e-03f, -6.071456451e-03f, +1.129403384e-03f, +5.237480478e-03f, -4.744380058e-03f, -1.520757418e-03f, +5.146294832e-03f, -2.103880952e-03f, -2.723920263e-03f, +3.274497897e-03f, -4.961619248e-05f, -2.161546552e-03f, +1.264509408e-03f, +5.600141608e-04f, -9.718574754e-04f, +2.234675677e-04f, +3.032592295e-04f, -1.751889823e-04f, +3.784329719e-06f, +0.000000000e+00f,
        /* 10,15 (36) */
        +0.000000000e+00f, -1.415404632e-04f, -7.389297029e-04f, +1.287598852e-03f, +1.139220381e-03f, -4.207227285e-03f, +6.286671812e-04f, +8.335510872e-03f, -7.223456790e-03f, -1.050977111e-02f, +2.033452499e-02f, +4.559677915e-03f, -3.864266074e-02f, +1.872303605e-02f, +5.669253195e-02f, -7.836597145e-02f, -6.353684213e-02f, +3.331910838e-01f, +5.824156176e-01f, +2.757040332e-01f, -8.881448051e-02f, -5.914779692e-02f, +6.211267483e-02f, +7.018222492e-03f, -3.725433098e-02f, +1.067107892e-02f, +1.712973454e-02f, -1.270091967e-02f, -4.582628874e-03f, +8.472224034e-03f, -7.707081919e-04f, -3.742629460e-03f, +1.584593622e-03f, +9.453314657e-04f, -7.694423543e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.415404632e-04f, +7.389297029e-04f, -1.751257834e-03f, -6.465825911e-04f, +5.608218818e-03f, -4.253989689e-03f, -7.401951071e-03f, +1.478143799e-02f, -6.094434262e-04f, -2.288642095e-02f, +2.014390818e-02f, +1.551663824e-02f, -3.902733634e-02f, +1.087183604e-02f, +3.843820396e-02f, -4.098055438e-02f, -1.213280353e-02f, +5.135394254e-02f, -2.361009391e-02f, -3.292559096e-02f, +4.340809058e-02f, +4.983471210e-04f, -3.637156484e-02f, +2.205420662e-02f, +1.406200157e-02f, -2.386002677e-02f, +4.058154368e-03f, +1.272409329e-02f, -8.998870366e-03f, -2.296432935e-03f, +5.387903242e-03f, -1.379060731e-03f, -9.453314657e-04f, +7.694423543e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.023134456e-05f, -2.190255501e-05f, -1.688223017e-04f, +2.390309122e-04f, +2.103608979e-04f, -7.164513821e-04f, +1.276517827e-04f, +1.306087259e-03f, -1.194919714e-03f, -1.503966945e-03f, +3.160553007e-03f, +4.504223033e-04f, -5.873380723e-03f, +3.164503237e-03f, +9.381395225e-03f, -1.357609648e-02f, -2.854133495e-02f, +1.297262942e-03f, +2.894571562e-02f, +1.170154190e-02f, -9.836779302e-03f, -2.255639644e-03f, +5.831432835e-03f, -9.379074490e-04f, -2.950847993e-03f, +1.700823497e-03f, +9.962288442e-04f, -1.334740657e-03f, -9.061379130e-06f, +6.829239910e-04f, -2.542369269e-04f, -2.063423291e-04f, +1.734450844e-04f, +8.610096471e-06f, +0.000000000e+00f,
        +0.000000000e+00f, -5.023134456e-05f, +2.190255501e-05f, +2.019751614e-04f, -3.861753858e-04f, -7.025519776e-05f, +9.760043827e-04f, -8.762743588e-04f, -9.426127885e-04f, +2.380746322e-03f, -6.670301471e-04f, -2.946312073e-03f, +3.437091543e-03f, +1.058782302e-03f, -5.174551379e-03f, +2.797408819e-03f, +3.766421654e-03f, -5.878377207e-03f, +3.783561031e-04f, +5.598913174e-03f, -4.288541765e-03f, -2.172477802e-03f, +5.198937536e-03f, -1.596989202e-03f, -3.100476839e-03f, +3.135594535e-03f, +3.065756726e-04f, -2.286851473e-03f, +1.114731918e-03f, +7.206449357e-04f, -9.815523707e-04f, +1.500603778e-04f, +3.463027545e-04f, -1.734450844e-04f, -8.610096471e-06f, +0.000000000e+00f,
        /* 11, 0 (32) */
        +0.000000000e+00f, +3.454933159e-04f, +1.541097233e-03f, -3.365769507e-03f, +1.849372243e-04f, +7.921455674e-03f, -9.933387929e-03f, -4.722893055e-03f, +2.491782703e-02f, -1.923850865e-02f, -2.511889872e-02f, +6.555431985e-02f, -2.774896345e-02f, -1.143270713e-01f, +2.866385681e-01f, +6.354451792e-01f, +2.866385681e-01f, -1.143270713e-01f, -2.774896345e-02f, +6.555431985e-02f, -2.511889872e-02f, -1.923850865e-02f, +2.491782703e-02f, -4.722893055e-03f, -9.933387929e-03f, +7.921455674e-03f, +1.849372243e-04f, -3.365769507e-03f, +1.541097233e-03f, +3.454933159e-04f, -4.305061225e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -3.454933159e-04f, -1.287417451e-03f, +5.082890229e-03f, -4.452826306e-03f, -5.152110347e-03f, +1.588482173e-02f, -1.131295515e-02f, -1.199676363e-02f, +3.147222030e-02f, -1.942348993e-02f, -1.990214054e-02f, +4.584722208e-02f, -2.506967236e-02f, -2.523864421e-02f, +5.173229864e-02f, -2.523864421e-02f, -2.506967236e-02f, +4.584722208e-02f, -1.990214054e-02f, -1.942348993e-02f, +3.147222030e-02f, -1.199676363e-02f, -1.131295515e-02f, +1.588482173e-02f, -5.152110347e-03f, -4.452826306e-03f, +5.082890229e-03f, -1.287417451e-03f, -7.762310022e-04f, +4.305061225e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.399604254e-04f, +1.041765491e-04f, +2.986283797e-04f, -7.115835566e-04f, +2.200087399e-04f, +1.290622629e-03f, -2.007399170e-03f, -1.847465416e-04f, +4.038384288e-03f, -4.234443633e-03f, -2.943297891e-03f, +1.200925710e-02f, -7.413000132e-03f, -3.454462879e-02f, -1.675619045e-03f, +3.441971216e-02f, +9.809674830e-03f, -1.217880404e-02f, +2.010048142e-03f, +4.814598421e-03f, -3.887513846e-03f, -2.142409335e-04f, +2.170997092e-03f, -1.185826608e-03f, -3.634744702e-04f, +7.486225761e-04f, -2.595530007e-04f, -1.401057002e-04f, +1.471444736e-04f, -3.315285962e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +1.399604254e-04f, -2.714216420e-04f, -1.520612352e-04f, +9.909186848e-04f, -1.172027193e-03f, -3.022516193e-04f, +2.503704416e-03f, -2.716755794e-03f, -4.456389479e-04f, +4.365791338e-03f, -4.428304910e-03f, -5.070221017e-04f, +5.764277198e-03f, -5.506807710e-03f, -4.425173936e-04f, +5.957741012e-03f, -5.372316216e-03f, -2.775764127e-04f, +4.833429021e-03f, -4.105732234e-03f, -9.342864861e-05f, +2.998386549e-03f, -2.381896629e-03f, +2.989319289e-05f, +1.316518315e-03f, -9.605757532e-04f, +6.507439985e-05f, +3.191257033e-04f, -2.010311674e-04f, +3.315285962e-05f, +0.000000000e+00f,
        /* 11, 1 (32) */
        +0.000000000e+00f, +2.055328905e-04f, +1.645273782e-03f, -3.067141127e-03f, -5.266463322e-04f, +8.141464414e-03f, -8.642765300e-03f, -6.730292225e-03f, +2.473308049e-02f, -1.520012436e-02f, -2.935334235e-02f, +6.261102195e-02f, -1.573970634e-02f, -1.217400715e-01f, +2.520939393e-01f, +6.337695601e-01f, +3.210582802e-01f, -1.045173965e-01f, -3.992776749e-02f, +6.756436799e-02f, -2.030430029e-02f, -2.312602249e-02f, +2.470358610e-02f, -2.551895963e-03f, -1.111921454e-02f, +7.557981204e-03f, +9.335598005e-04f, -3.625322507e-03f, +1.400991533e-03f, +4.926377895e-04f, -4.636589821e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -2.055328905e-04f, -1.558839093e-03f, +4.930828994e-03f, -3.461907621e-03f, -6.324137540e-03f, +1.558257011e-02f, -8.809250736e-03f, -1.471351943e-02f, +3.102658135e-02f, -1.505769859e-02f, -2.433044545e-02f, +4.534019998e-02f, -1.930539516e-02f, -3.074545192e-02f, +5.128978125e-02f, -1.928090320e-02f, -3.044198857e-02f, +4.556964567e-02f, -1.506871152e-02f, -2.352922217e-02f, +3.137879165e-02f, -8.998377082e-03f, -1.369485178e-02f, +1.591471492e-02f, -3.835592032e-03f, -5.413402059e-03f, +5.147964629e-03f, -9.682917474e-04f, -9.772621697e-04f, +4.636589821e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.307312654e-04f, +6.892978118e-05f, +3.303462436e-04f, -6.648056295e-04f, +7.980483913e-05f, +1.370176154e-03f, -1.818623406e-03f, -5.652322161e-04f, +4.120340294e-03f, -3.611381843e-03f, -3.792586585e-03f, +1.167016172e-02f, -5.071274913e-03f, -3.437345706e-02f, -5.010603072e-03f, +3.399429673e-02f, +1.223580090e-02f, -1.216800061e-02f, +1.003764677e-03f, +5.340871520e-03f, -3.667467789e-03f, -6.259085202e-04f, +2.305633509e-03f, -1.056428589e-03f, -5.078899367e-04f, +7.747425269e-04f, -2.133848905e-04f, -1.760720761e-04f, +1.519596632e-04f, -2.685306184e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +1.307312654e-04f, -2.217972983e-04f, -2.311650394e-04f, +1.001898222e-03f, -1.012712208e-03f, -5.596855127e-04f, +2.578160955e-03f, -2.395085426e-03f, -9.655624416e-04f, +4.545869262e-03f, -3.952208277e-03f, -1.274926019e-03f, +6.054025378e-03f, -4.962195739e-03f, -1.319799421e-03f, +6.306773198e-03f, -4.884366485e-03f, -1.065181453e-03f, +5.159434945e-03f, -3.768946506e-03f, -6.423743823e-04f, +3.233859346e-03f, -2.213529401e-03f, -2.528729306e-04f, +1.442834315e-03f, -9.105023451e-04f, -2.849917238e-05f, +3.637431385e-04f, -2.007290083e-04f, +2.685306184e-05f, +0.000000000e+00f,
        /* 11, 2 (32) */
        +0.000000000e+00f, +7.480162519e-05f, +1.714203563e-03f, -2.736794883e-03f, -1.191451962e-03f, +8.221269253e-03f, -7.272589145e-03f, -8.548915631e-03f, +2.416784827e-02f, -1.107978407e-02f, -3.296472419e-02f, +5.881843537e-02f, -4.069544625e-03f, -1.268113464e-01f, +2.177204822e-01f, +6.287589571e-01f, +3.550525770e-01f, -9.228159561e-02f, -5.209576810e-02f, +6.856813267e-02f, -1.496342877e-02f, -2.679349028e-02f, +2.407767758e-02f, -2.462624541e-04f, -1.217564313e-02f, +7.050091267e-03f, +1.708302327e-03f, -3.838707398e-03f, +1.224919457e-03f, +6.445974527e-04f, -4.905120440e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -7.480162519e-05f, -1.780636391e-03f, +4.699663955e-03f, -2.460009399e-03f, -7.336849749e-03f, +1.502288459e-02f, -6.231089781e-03f, -1.710860485e-02f, +3.006101891e-02f, -1.051182933e-02f, -2.828265373e-02f, +4.406527396e-02f, -1.325136978e-02f, -3.570764766e-02f, +4.996998183e-02f, -1.297413000e-02f, -3.532635506e-02f, +4.450446421e-02f, -9.909276578e-03f, -2.729816867e-02f, +3.073641726e-02f, -5.764517736e-03f, -1.590838118e-02f, +1.566184199e-02f, -2.392757717e-03f, -6.323904404e-03f, +5.119465457e-03f, -6.045486089e-04f, -1.177991178e-03f, +4.905120440e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.197987467e-04f, +3.495771602e-05f, +3.545858643e-04f, -6.095759291e-04f, -5.498480556e-05f, +1.424286778e-03f, -1.608709499e-03f, -9.219085338e-04f, +4.134708898e-03f, -2.956633492e-03f, -4.548636410e-03f, +1.117413572e-02f, -2.808650060e-03f, -3.391382572e-02f, -8.297016562e-03f, +3.326728023e-02f, +1.466482656e-02f, -1.196806374e-02f, -6.307772297e-05f, +5.802714914e-03f, -3.379094539e-03f, -1.043996991e-03f, +2.407854881e-03f, -9.035169628e-04f, -6.508167323e-04f, +7.888970184e-04f, -1.605359360e-04f, -2.113872174e-04f, +1.541084338e-04f, -1.912402271e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +1.197987467e-04f, -1.713870949e-04f, -3.013125153e-04f, +9.942311033e-04f, -8.420672912e-04f, -7.981028032e-04f, +2.605351521e-03f, -2.040060195e-03f, -1.457607839e-03f, +4.644186430e-03f, -3.414433922e-03f, -2.012878036e-03f, +6.237185937e-03f, -4.333758325e-03f, -2.173962125e-03f, +6.547465475e-03f, -4.308401061e-03f, -1.841917467e-03f, +5.399489258e-03f, -3.360128864e-03f, -1.191560114e-03f, +3.417750004e-03f, -2.000282133e-03f, -5.411772459e-04f, +1.547837769e-03f, -8.407043378e-04f, -1.271556887e-04f, +4.040997418e-04f, -1.956734673e-04f, +1.912402271e-05f, +0.000000000e+00f,
        /* 11, 3 (32) */
        +0.000000000e+00f, -4.499712153e-05f, +1.749161279e-03f, -2.382209019e-03f, -1.801027891e-03f, +8.166284447e-03f, -5.848302367e-03f, -1.015762513e-02f, +2.324593974e-02f, -6.945075168e-03f, -3.592135768e-02f, +5.426979896e-02f, +7.104591091e-03f, -1.296199964e-01f, +1.838066565e-01f, +6.204619405e-01f, +3.883198572e-01f, -7.761676906e-02f, -6.406383185e-02f, +6.850505494e-02f, -9.160713861e-03f, -3.017258482e-02f, +2.303368059e-02f, +2.161592427e-03f, -1.307916009e-02f, +6.399274535e-03f, +2.497199346e-03f, -3.999243334e-03f, +1.013532239e-03f, +7.987058865e-04f, -5.096360667e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.499712153e-05f, -1.952023486e-03f, +4.398351440e-03f, -1.465778295e-03f, -8.178917040e-03f, +1.422478179e-02f, -3.625738261e-03f, -1.914866505e-02f, +2.860341107e-02f, -5.867642902e-03f, -3.169708765e-02f, +4.205239592e-02f, -7.014183843e-03f, -4.004140599e-02f, +4.779601970e-02f, -6.426664530e-03f, -3.963475612e-02f, +4.266254675e-02f, -4.509787320e-03f, -3.065829754e-02f, +2.954485715e-02f, -2.346767732e-03f, -1.790866331e-02f, +1.512066474e-02f, -8.449199480e-04f, -7.164608742e-03f, +4.992309768e-03f, -2.004488672e-04f, -1.373664645e-03f, +5.096360667e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.075145692e-04f, +2.791820816e-06f, +3.713650726e-04f, -5.472611389e-04f, -1.823966401e-04f, +1.453179366e-03f, -1.381877687e-03f, -1.250047714e-03f, +4.083824124e-03f, -2.281486140e-03f, -5.203894462e-03f, +1.053539043e-02f, -6.476584866e-04f, -3.317645239e-02f, -1.150311548e-02f, +3.224091711e-02f, +1.706945906e-02f, -1.157240936e-02f, -1.176584853e-03f, +6.190187725e-03f, -3.024379522e-03f, -1.461896240e-03f, +2.474609177e-03f, -7.286283776e-04f, -7.897272177e-04f, +7.901990787e-04f, -1.015655426e-04f, -2.453303176e-04f, +1.533275451e-04f, -1.001616161e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +1.075145692e-04f, -1.212714302e-04f, -3.616636038e-04f, +9.689545383e-04f, -6.636577527e-04f, -1.013897991e-03f, +2.586211951e-03f, -1.658796092e-03f, -1.913720021e-03f, +4.660445649e-03f, -2.825243912e-03f, -2.708284773e-03f, +6.311299411e-03f, -3.632797577e-03f, -2.990053264e-03f, +6.675283650e-03f, -3.654009310e-03f, -2.593970440e-03f, +5.548211855e-03f, -2.885352155e-03f, -1.731145461e-03f, +3.545446236e-03f, -1.744715690e-03f, -8.298788745e-04f, +1.628674706e-03f, -7.515772681e-04f, -2.292045253e-04f, +4.390390155e-04f, -1.855878775e-04f, +1.001616161e-05f, +0.000000000e+00f,
        /* 11, 4 (32) */
        +0.000000000e+00f, -1.525116908e-04f, +1.751953100e-03f, -2.010843946e-03f, -2.348289030e-03f, +7.983887807e-03f, -4.395123001e-03f, -1.153950282e-02f, +2.199589203e-02f, -2.861251044e-03f, -3.820284382e-02f, +4.906590450e-02f, +1.763998152e-02f, -1.302676549e-01f, +1.506302041e-01f, +6.089588250e-01f, +4.205607743e-01f, -6.054731000e-02f, -7.563624121e-02f, +6.732847009e-02f, -2.970526136e-03f, -3.319696434e-02f, +2.157178435e-02f, +4.636201605e-03f, -1.380778847e-02f, +5.609547317e-03f, +3.287398424e-03f, -4.100808877e-03f, +7.682019216e-04f, +9.520334316e-04f, -5.196522283e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.525116908e-04f, -2.073294916e-03f, +4.036687836e-03f, -4.968237572e-04f, -8.842574792e-03f, +1.321088380e-02f, -1.039526309e-03f, -2.080746114e-02f, +2.668969105e-02f, -1.207197253e-03f, -3.452233157e-02f, +3.934411115e-02f, -7.028844317e-04f, -4.367420357e-02f, +4.480596644e-02f, +2.486191205e-04f, -4.328876543e-02f, +4.006857631e-02f, +1.038424535e-03f, -3.354364969e-02f, +2.781371169e-02f, +1.198678504e-03f, -1.965337901e-02f, +1.429078587e-02f, +7.837547575e-04f, -7.916186010e-03f, +4.763105243e-03f, +2.385901483e-04f, -1.559252523e-03f, +5.196522283e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -9.423259651e-05f, -2.710370466e-05f, +3.808325289e-04f, -4.792799535e-04f, -3.006807112e-04f, +1.457482743e-03f, -1.142453153e-03f, -1.545555763e-03f, +3.970954405e-03f, -1.597120740e-03f, -5.752581056e-03f, +9.769492281e-03f, +1.391029546e-03f, -3.217497647e-02f, -1.459810151e-02f, +3.092082508e-02f, +1.942199261e-02f, -1.097680665e-02f, -2.321595832e-03f, +6.494133407e-03f, -2.606455251e-03f, -1.872740937e-03f, +2.503313221e-03f, -5.337403646e-04f, -9.220448299e-04f, +7.779451282e-04f, -3.717827743e-05f, -2.771604496e-04f, +1.493959888e-04f, +3.828556293e-07f, +0.000000000e+00f,
        +0.000000000e+00f, +9.423259651e-05f, -7.245690575e-05f, -4.116164933e-04f, +9.273919632e-04f, -4.810502642e-04f, -1.204002802e-03f, +2.522487056e-03f, -1.258700448e-03f, -2.326654291e-03f, +4.595812404e-03f, -2.195670544e-03f, -3.349435626e-03f, +6.275852711e-03f, -2.871856988e-03f, -3.753802700e-03f, +6.687684854e-03f, -2.932233975e-03f, -3.307838086e-03f, +5.601792117e-03f, -2.351978856e-03f, -2.251264847e-03f, +3.613252870e-03f, -1.450249299e-03f, -1.113654754e-03f, +1.682841202e-03f, -6.439158093e-04f, -3.327938628e-04f, +4.674487560e-04f, -1.702953811e-04f, -3.828556293e-07f, +0.000000000e+00f,
        /* 11, 5 (32) */
        +0.000000000e+00f, -2.467442873e-04f, +1.724849395e-03f, -1.630011418e-03f, -2.827568983e-03f, +7.683207096e-03f, -2.937640258e-03f, -1.268195597e-02f, +2.045033626e-02f, +1.109703361e-03f, -3.979996456e-02f, +4.331332344e-02f, +2.740947380e-02f, -1.288766254e-01f, +1.184552276e-01f, +5.943607235e-01f, +4.514815994e-01f, -4.112531739e-02f, -8.661304785e-02f, +6.500687426e-02f, +3.523607271e-03f, -3.580341959e-02f, +1.969904341e-02f, +7.139514826e-03f, -1.434152883e-02f, +4.687502487e-03f, +4.065343553e-03f, -4.137987154e-03f, +4.910414720e-04f, +1.101429420e-03f, -5.192693727e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.467442873e-04f, -2.145751822e-03f, +3.625071342e-03f, +4.305682060e-04f, -9.323625057e-03f, +1.200688100e-02f, +1.482960747e-03f, -2.206616159e-02f, +2.436303675e-02f, +3.388615151e-03f, -3.671800211e-02f, +3.599467552e-02f, +5.572968280e-03f, -4.654606055e-02f, +4.105216374e-02f, +6.936303974e-03f, -4.622099940e-02f, +3.676073822e-02f, +6.640216652e-03f, -3.589562855e-02f, +2.556244684e-02f, +4.811931374e-03f, -2.110362830e-02f, +1.317713111e-02f, +2.466595959e-03f, -8.560101819e-03f, +4.430311380e-03f, +7.060389043e-04f, -1.729547904e-03f, +5.192693727e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -8.030149258e-05f, -5.433670509e-05f, +3.832580123e-04f, -4.070759198e-04f, -4.083206773e-04f, +1.438202486e-03f, -8.947915600e-04f, -1.805014389e-03f, +3.800217875e-03f, -9.144453014e-04f, -6.190710991e-03f, +8.893112110e-03f, +3.288822149e-03f, -3.092575692e-02f, -1.755248302e-02f, +2.931594908e-02f, +2.169464718e-02f, -1.017950378e-02f, -3.481859008e-03f, +6.706350839e-03f, -2.129593340e-03f, -2.269513888e-03f, +2.491914723e-03f, -3.212560480e-04f, -1.045187034e-03f, +7.516367599e-04f, +3.178135117e-05f, -3.061298911e-04f, +1.421424992e-04f, +1.194746278e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +8.030149258e-05f, -2.585919819e-05f, -4.508075312e-04f, +8.711146184e-04f, -2.977454210e-04f, -1.365925069e-03f, +2.416675152e-03f, -8.473300397e-04f, -2.690090414e-03f, +4.452868841e-03f, -1.537307931e-03f, -3.925703444e-03f, +6.132274715e-03f, -2.064492216e-03f, -4.451877688e-03f, +6.584168342e-03f, -2.155380859e-03f, -3.970576614e-03f, +5.558077690e-03f, -1.768547346e-03f, -2.742208475e-03f, +3.618482286e-03f, -1.121120444e-03f, -1.387095215e-03f, +1.708245537e-03f, -5.189155386e-04f, -4.359409679e-04f, +4.882881120e-04f, -1.497297397e-04f, -1.194746278e-05f, +0.000000000e+00f,
        /* 11, 6 (32) */
        +0.000000000e+00f, -3.270457799e-04f, +1.670512690e-03f, -1.246753405e-03f, -3.234644903e-03f, +7.274886419e-03f, -1.499437772e-03f, -1.357674753e-02f, +1.864532187e-02f, +4.909921236e-03f, -4.071440986e-02f, +3.712261245e-02f, +3.630258591e-02f, -1.255878032e-01f, +8.752947072e-02f, +5.768082405e-01f, +4.807975485e-01f, -1.943067021e-02f, -9.679255163e-02f, +6.152501525e-02f, +1.022995811e-02f, -3.793301293e-02f, +1.742952952e-02f, +9.631429549e-03f, -1.466278488e-02f, +3.642315453e-03f, +4.816980313e-03f, -4.106205803e-03f, +1.849115809e-04f, +1.243571920e-03f, -5.073219099e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.270457799e-04f, -2.171611020e-03f, +3.174263811e-03f, +1.301682824e-03f, -9.621370478e-03f, +1.064095593e-02f, +3.899635899e-03f, -2.291349163e-02f, +2.167294634e-02f, +7.841483992e-03f, -3.825531004e-02f, +3.206897208e-02f, +1.170524299e-02f, -4.861055277e-02f, +3.660028605e-02f, +1.352047232e-02f, -4.837638026e-02f, +3.279016161e-02f, +1.219829434e-02f, -3.766417590e-02f, +2.282023837e-02f, +8.430413660e-03f, -2.222474875e-02f, +1.179003590e-02f, +4.174841496e-03f, -9.079017358e-03f, +3.994370412e-03f, +1.194327016e-03f, -1.879277644e-03f, +5.073219099e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -6.605790481e-05f, -7.859020218e-05f, +3.790210013e-04f, -3.320911204e-04f, -5.040489558e-04f, +1.396688521e-03f, -6.432069161e-04f, -2.025710559e-03f, +3.576487267e-03f, -2.439382415e-04f, -6.516088221e-03f, +7.923766014e-03f, +5.029390160e-03f, -2.944763799e-02f, -2.033841886e-02f, +2.743848295e-02f, +2.385991397e-02f, -9.181322639e-03f, -4.640229032e-03f, +6.819756489e-03f, -1.599177980e-03f, -2.645155693e-03f, +2.438947738e-03f, -9.398088869e-05f, -1.156610267e-03f, +7.109998284e-04f, +1.043370223e-04f, -3.314983423e-04f, +1.314524813e-04f, +2.451436211e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +6.605790481e-05f, +1.771118770e-05f, -4.791062706e-04f, +8.018998884e-04f, -1.171141105e-04f, -1.497775478e-03f, +2.271960141e-03f, -4.322498801e-04f, -2.998727403e-03f, +4.235542723e-03f, -8.620962011e-04f, -4.427723534e-03f, +5.883896733e-03f, -1.225024426e-03f, -5.072121008e-03f, +6.366289365e-03f, -1.336804441e-03f, -4.570039469e-03f, +5.416633899e-03f, -1.144634675e-03f, -3.194603884e-03f, +3.559527997e-03f, -7.623281066e-04f, -1.644804275e-03f, +1.703264485e-03f, -3.781666435e-04f, -5.365666914e-04f, +5.006145340e-04f, -1.239441717e-04f, -2.451436211e-05f, +0.000000000e+00f,
        /* 11, 7 (32) */
        +0.000000000e+00f, -3.931036847e-04f, +1.591922488e-03f, -8.677324040e-04f, -3.566736023e-03f, +6.770837463e-03f, -1.027492505e-04f, -1.421995445e-02f, +1.661961131e-02f, +8.486408502e-03f, -4.095834811e-02f, +3.060652423e-02f, +4.422635193e-02f, -1.205584131e-01f, +5.808183272e-02f, +5.564698216e-01f, +5.082360314e-01f, +4.429243765e-03f, -1.059738743e-01f, +5.688478622e-02f, +1.704971460e-02f, -3.953219091e-02f, +1.478437383e-02f, +1.207037729e-02f, -1.475676577e-02f, +2.485705186e-03f, +5.527980141e-03f, -4.001868780e-03f, -1.465867614e-04f, +1.375024401e-03f, -4.828075478e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.931036847e-04f, -2.153899832e-03f, +2.695157541e-03f, +2.103582713e-03f, -9.738484588e-03f, +9.143180449e-03f, +6.171596040e-03f, -2.334574151e-02f, +1.867421894e-02f, +1.207702671e-02f, -3.911740624e-02f, +2.764124854e-02f, +1.758913973e-02f, -4.983557720e-02f, +3.152816504e-02f, +1.988676168e-02f, -4.971318470e-02f, +2.822012214e-02f, +1.761492824e-02f, -3.880881057e-02f, +1.962563448e-02f, +1.198994166e-02f, -2.298707685e-02f, +1.014523162e-02f, +5.878105981e-03f, -9.457184001e-03f, +3.457803721e-03f, +1.694941550e-03f, -2.003221815e-03f, +4.828075478e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -5.182030238e-05f, -9.962390851e-05f, +3.685978409e-04f, -2.557411293e-04f, -5.868569481e-04f, +1.334598274e-03f, -3.919028713e-04f, -2.205653655e-03f, +3.305286243e-03f, +4.044964937e-04f, -6.728274744e-03f, +6.879551499e-03f, +6.598818152e-03f, -2.776168626e-02f, -2.293004068e-02f, +2.530374954e-02f, +2.589090270e-02f, -7.985720658e-03f, -5.778882790e-03f, +6.828534886e-03f, -1.021660698e-03f, -2.992679084e-03f, +2.343580374e-03f, +1.449084482e-04f, -1.253856162e-03f, +6.560003737e-04f, +1.793916280e-04f, -3.525478016e-04f, +1.172741787e-04f, +3.788356071e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +5.182030238e-05f, +5.756011899e-05f, -4.966059787e-04f, +7.216873692e-04f, +5.766121231e-05f, -1.598282041e-03f, +2.092132763e-03f, -2.089533043e-05f, -3.248357673e-03f, +3.949013080e-03f, -1.821023717e-04f, -4.847547932e-03f, +5.535878828e-03f, -3.682807604e-04f, -5.603767603e-03f, +6.037635758e-03f, -4.906732555e-04f, -5.095103581e-03f, +5.178772370e-03f, -4.906980429e-04f, -3.599594689e-03f, +3.435919606e-03f, -3.795599826e-04f, -1.881502821e-03f, +1.666792427e-03f, -2.236393745e-04f, -6.325336388e-04f, +5.036100117e-04f, -9.311789802e-05f, -3.788356071e-05f, +0.000000000e+00f,
        /* 11, 8 (32) */
        +0.000000000e+00f, -4.449239871e-04f, +1.492298580e-03f, -4.991345630e-04f, -3.822477153e-03f, +6.183980515e-03f, +1.231849024e-03f, -1.461185732e-02f, +1.441395766e-02f, +1.179169475e-02f, -4.055385161e-02f, +2.387824949e-02f, +5.110590343e-02f, -1.139595949e-01f, +3.032014646e-02f, +5.335397809e-01f, +5.335397809e-01f, +3.032014646e-02f, -1.139595949e-01f, +5.110590343e-02f, +2.387824949e-02f, -4.055385161e-02f, +1.179169475e-02f, +1.441395766e-02f, -1.461185732e-02f, +1.231849024e-03f, +6.183980515e-03f, -3.822477153e-03f, -4.991345630e-04f, +1.492298580e-03f, -4.449239871e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.449239871e-04f, -2.096339713e-03f, +2.198551562e-03f, +2.825270082e-03f, -9.680823376e-03f, +7.544898408e-03f, +8.263728803e-03f, -2.336663684e-02f, +1.542586126e-02f, +1.602603979e-02f, -3.929950861e-02f, +2.279370061e-02f, +2.312501856e-02f, -5.020385796e-02f, +2.592439744e-02f, +2.592439744e-02f, -5.020385796e-02f, +2.312501856e-02f, +2.279370061e-02f, -3.929950861e-02f, +1.602603979e-02f, +1.542586126e-02f, -2.336663684e-02f, +8.263728803e-03f, +7.544898408e-03f, -9.680823376e-03f, +2.825270082e-03f, +2.198551562e-03f, -2.096339713e-03f, +4.449239871e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -3.788356071e-05f, -1.172741787e-04f, +3.525478016e-04f, -1.793916280e-04f, -6.560003737e-04f, +1.253856162e-03f, -1.449084482e-04f, -2.343580374e-03f, +2.992679084e-03f, +1.021660698e-03f, -6.828534886e-03f, +5.778882790e-03f, +7.985720658e-03f, -2.589090270e-02f, -2.530374954e-02f, +2.293004068e-02f, +2.776168626e-02f, -6.598818152e-03f, -6.879551499e-03f, +6.728274744e-03f, -4.044964937e-04f, -3.305286243e-03f, +2.205653655e-03f, +3.919028713e-04f, -1.334598274e-03f, +5.868569481e-04f, +2.557411293e-04f, -3.685978409e-04f, +9.962390851e-05f, +5.182030238e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +3.788356071e-05f, +9.311789802e-05f, -5.036100117e-04f, +6.325336388e-04f, +2.236393745e-04f, -1.666792427e-03f, +1.881502821e-03f, +3.795599826e-04f, -3.435919606e-03f, +3.599594689e-03f, +4.906980429e-04f, -5.178772370e-03f, +5.095103581e-03f, +4.906732555e-04f, -6.037635758e-03f, +5.603767603e-03f, +3.682807604e-04f, -5.535878828e-03f, +4.847547932e-03f, +1.821023717e-04f, -3.949013080e-03f, +3.248357673e-03f, +2.089533043e-05f, -2.092132763e-03f, +1.598282041e-03f, -5.766121231e-05f, -7.216873692e-04f, +4.966059787e-04f, -5.756011899e-05f, -5.182030238e-05f, +0.000000000e+00f,
        /* 11, 9 (32) */
        +0.000000000e+00f, -4.828075478e-04f, +1.375024401e-03f, -1.465867614e-04f, -4.001868780e-03f, +5.527980141e-03f, +2.485705186e-03f, -1.475676577e-02f, +1.207037729e-02f, +1.478437383e-02f, -3.953219091e-02f, +1.704971460e-02f, +5.688478622e-02f, -1.059738743e-01f, +4.429243765e-03f, +5.082360314e-01f, +5.564698216e-01f, +5.808183272e-02f, -1.205584131e-01f, +4.422635193e-02f, +3.060652423e-02f, -4.095834811e-02f, +8.486408502e-03f, +1.661961131e-02f, -1.421995445e-02f, -1.027492505e-04f, +6.770837463e-03f, -3.566736023e-03f, -8.677324040e-04f, +1.591922488e-03f, -3.931036847e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.828075478e-04f, -2.003221815e-03f, +1.694941550e-03f, +3.457803721e-03f, -9.457184001e-03f, +5.878105981e-03f, +1.014523162e-02f, -2.298707685e-02f, +1.198994166e-02f, +1.962563448e-02f, -3.880881057e-02f, +1.761492824e-02f, +2.822012214e-02f, -4.971318470e-02f, +1.988676168e-02f, +3.152816504e-02f, -4.983557720e-02f, +1.758913973e-02f, +2.764124854e-02f, -3.911740624e-02f, +1.207702671e-02f, +1.867421894e-02f, -2.334574151e-02f, +6.171596040e-03f, +9.143180449e-03f, -9.738484588e-03f, +2.103582713e-03f, +2.695157541e-03f, -2.153899832e-03f, +3.931036847e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -2.451436211e-05f, -1.314524813e-04f, +3.314983423e-04f, -1.043370223e-04f, -7.109998284e-04f, +1.156610267e-03f, +9.398088869e-05f, -2.438947738e-03f, +2.645155693e-03f, +1.599177980e-03f, -6.819756489e-03f, +4.640229032e-03f, +9.181322639e-03f, -2.385991397e-02f, -2.743848295e-02f, +2.033841886e-02f, +2.944763799e-02f, -5.029390160e-03f, -7.923766014e-03f, +6.516088221e-03f, +2.439382415e-04f, -3.576487267e-03f, +2.025710559e-03f, +6.432069161e-04f, -1.396688521e-03f, +5.040489558e-04f, +3.320911204e-04f, -3.790210013e-04f, +7.859020218e-05f, +6.605790481e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +2.451436211e-05f, +1.239441717e-04f, -5.006145340e-04f, +5.365666914e-04f, +3.781666435e-04f, -1.703264485e-03f, +1.644804275e-03f, +7.623281066e-04f, -3.559527997e-03f, +3.194603884e-03f, +1.144634675e-03f, -5.416633899e-03f, +4.570039469e-03f, +1.336804441e-03f, -6.366289365e-03f, +5.072121008e-03f, +1.225024426e-03f, -5.883896733e-03f, +4.427723534e-03f, +8.620962011e-04f, -4.235542723e-03f, +2.998727403e-03f, +4.322498801e-04f, -2.271960141e-03f, +1.497775478e-03f, +1.171141105e-04f, -8.018998884e-04f, +4.791062706e-04f, -1.771118770e-05f, -6.605790481e-05f, +0.000000000e+00f,
        /* 11,10 (32) */
        +0.000000000e+00f, -5.073219099e-04f, +1.243571920e-03f, +1.849115809e-04f, -4.106205803e-03f, +4.816980313e-03f, +3.642315453e-03f, -1.466278488e-02f, +9.631429549e-03f, +1.742952952e-02f, -3.793301293e-02f, +1.022995811e-02f, +6.152501525e-02f, -9.679255163e-02f, -1.943067021e-02f, +4.807975485e-01f, +5.768082405e-01f, +8.752947072e-02f, -1.255878032e-01f, +3.630258591e-02f, +3.712261245e-02f, -4.071440986e-02f, +4.909921236e-03f, +1.864532187e-02f, -1.357674753e-02f, -1.499437772e-03f, +7.274886419e-03f, -3.234644903e-03f, -1.246753405e-03f, +1.670512690e-03f, -3.270457799e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.073219099e-04f, -1.879277644e-03f, +1.194327016e-03f, +3.994370412e-03f, -9.079017358e-03f, +4.174841496e-03f, +1.179003590e-02f, -2.222474875e-02f, +8.430413660e-03f, +2.282023837e-02f, -3.766417590e-02f, +1.219829434e-02f, +3.279016161e-02f, -4.837638026e-02f, +1.352047232e-02f, +3.660028605e-02f, -4.861055277e-02f, +1.170524299e-02f, +3.206897208e-02f, -3.825531004e-02f, +7.841483992e-03f, +2.167294634e-02f, -2.291349163e-02f, +3.899635899e-03f, +1.064095593e-02f, -9.621370478e-03f, +1.301682824e-03f, +3.174263811e-03f, -2.171611020e-03f, +3.270457799e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.194746278e-05f, -1.421424992e-04f, +3.061298911e-04f, -3.178135117e-05f, -7.516367599e-04f, +1.045187034e-03f, +3.212560480e-04f, -2.491914723e-03f, +2.269513888e-03f, +2.129593340e-03f, -6.706350839e-03f, +3.481859008e-03f, +1.017950378e-02f, -2.169464718e-02f, -2.931594908e-02f, +1.755248302e-02f, +3.092575692e-02f, -3.288822149e-03f, -8.893112110e-03f, +6.190710991e-03f, +9.144453014e-04f, -3.800217875e-03f, +1.805014389e-03f, +8.947915600e-04f, -1.438202486e-03f, +4.083206773e-04f, +4.070759198e-04f, -3.832580123e-04f, +5.433670509e-05f, +8.030149258e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +1.194746278e-05f, +1.497297397e-04f, -4.882881120e-04f, +4.359409679e-04f, +5.189155386e-04f, -1.708245537e-03f, +1.387095215e-03f, +1.121120444e-03f, -3.618482286e-03f, +2.742208475e-03f, +1.768547346e-03f, -5.558077690e-03f, +3.970576614e-03f, +2.155380859e-03f, -6.584168342e-03f, +4.451877688e-03f, +2.064492216e-03f, -6.132274715e-03f, +3.925703444e-03f, +1.537307931e-03f, -4.452868841e-03f, +2.690090414e-03f, +8.473300397e-04f, -2.416675152e-03f, +1.365925069e-03f, +2.977454210e-04f, -8.711146184e-04f, +4.508075312e-04f, +2.585919819e-05f, -8.030149258e-05f, +0.000000000e+00f,
        /* 11,11 (32) */
        +0.000000000e+00f, -5.192693727e-04f, +1.101429420e-03f, +4.910414720e-04f, -4.137987154e-03f, +4.065343553e-03f, +4.687502487e-03f, -1.434152883e-02f, +7.139514826e-03f, +1.969904341e-02f, -3.580341959e-02f, +3.523607271e-03f, +6.500687426e-02f, -8.661304785e-02f, -4.112531739e-02f, +4.514815994e-01f, +5.943607235e-01f, +1.184552276e-01f, -1.288766254e-01f, +2.740947380e-02f, +4.331332344e-02f, -3.979996456e-02f, +1.109703361e-03f, +2.045033626e-02f, -1.268195597e-02f, -2.937640258e-03f, +7.683207096e-03f, -2.827568983e-03f, -1.630011418e-03f, +1.724849395e-03f, -2.467442873e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.192693727e-04f, -1.729547904e-03f, +7.060389043e-04f, +4.430311380e-03f, -8.560101819e-03f, +2.466595959e-03f, +1.317713111e-02f, -2.110362830e-02f, +4.811931374e-03f, +2.556244684e-02f, -3.589562855e-02f, +6.640216652e-03f, +3.676073822e-02f, -4.622099940e-02f, +6.936303974e-03f, +4.105216374e-02f, -4.654606055e-02f, +5.572968280e-03f, +3.599467552e-02f, -3.671800211e-02f, +3.388615151e-03f, +2.436303675e-02f, -2.206616159e-02f, +1.482960747e-03f, +1.200688100e-02f, -9.323625057e-03f, +4.305682060e-04f, +3.625071342e-03f, -2.145751822e-03f, +2.467442873e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -3.828556293e-07f, -1.493959888e-04f, +2.771604496e-04f, +3.717827743e-05f, -7.779451282e-04f, +9.220448299e-04f, +5.337403646e-04f, -2.503313221e-03f, +1.872740937e-03f, +2.606455251e-03f, -6.494133407e-03f, +2.321595832e-03f, +1.097680665e-02f, -1.942199261e-02f, -3.092082508e-02f, +1.459810151e-02f, +3.217497647e-02f, -1.391029546e-03f, -9.769492281e-03f, +5.752581056e-03f, +1.597120740e-03f, -3.970954405e-03f, +1.545555763e-03f, +1.142453153e-03f, -1.457482743e-03f, +3.006807112e-04f, +4.792799535e-04f, -3.808325289e-04f, +2.710370466e-05f, +9.423259651e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +3.828556293e-07f, +1.702953811e-04f, -4.674487560e-04f, +3.327938628e-04f, +6.439158093e-04f, -1.682841202e-03f, +1.113654754e-03f, +1.450249299e-03f, -3.613252870e-03f, +2.251264847e-03f, +2.351978856e-03f, -5.601792117e-03f, +3.307838086e-03f, +2.932233975e-03f, -6.687684854e-03f, +3.753802700e-03f, +2.871856988e-03f, -6.275852711e-03f, +3.349435626e-03f, +2.195670544e-03f, -4.595812404e-03f, +2.326654291e-03f, +1.258700448e-03f, -2.522487056e-03f, +1.204002802e-03f, +4.810502642e-04f, -9.273919632e-04f, +4.116164933e-04f, +7.245690575e-05f, -9.423259651e-05f, +0.000000000e+00f,
        /* 11,12 (32) */
        +0.000000000e+00f, -5.196522283e-04f, +9.520334316e-04f, +7.682019216e-04f, -4.100808877e-03f, +3.287398424e-03f, +5.609547317e-03f, -1.380778847e-02f, +4.636201605e-03f, +2.157178435e-02f, -3.319696434e-02f, -2.970526136e-03f, +6.732847009e-02f, -7.563624121e-02f, -6.054731000e-02f, +4.205607743e-01f, +6.089588250e-01f, +1.506302041e-01f, -1.302676549e-01f, +1.763998152e-02f, +4.906590450e-02f, -3.820284382e-02f, -2.861251044e-03f, +2.199589203e-02f, -1.153950282e-02f, -4.395123001e-03f, +7.983887807e-03f, -2.348289030e-03f, -2.010843946e-03f, +1.751953100e-03f, -1.525116908e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.196522283e-04f, -1.559252523e-03f, +2.385901483e-04f, +4.763105243e-03f, -7.916186010e-03f, +7.837547575e-04f, +1.429078587e-02f, -1.965337901e-02f, +1.198678504e-03f, +2.781371169e-02f, -3.354364969e-02f, +1.038424535e-03f, +4.006857631e-02f, -4.328876543e-02f, +2.486191205e-04f, +4.480596644e-02f, -4.367420357e-02f, -7.028844317e-04f, +3.934411115e-02f, -3.452233157e-02f, -1.207197253e-03f, +2.668969105e-02f, -2.080746114e-02f, -1.039526309e-03f, +1.321088380e-02f, -8.842574792e-03f, -4.968237572e-04f, +4.036687836e-03f, -2.073294916e-03f, +1.525116908e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.001616161e-05f, -1.533275451e-04f, +2.453303176e-04f, +1.015655426e-04f, -7.901990787e-04f, +7.897272177e-04f, +7.286283776e-04f, -2.474609177e-03f, +1.461896240e-03f, +3.024379522e-03f, -6.190187725e-03f, +1.176584853e-03f, +1.157240936e-02f, -1.706945906e-02f, -3.224091711e-02f, +1.150311548e-02f, +3.317645239e-02f, +6.476584866e-04f, -1.053539043e-02f, +5.203894462e-03f, +2.281486140e-03f, -4.083824124e-03f, +1.250047714e-03f, +1.381877687e-03f, -1.453179366e-03f, +1.823966401e-04f, +5.472611389e-04f, -3.713650726e-04f, -2.791820816e-06f, +1.075145692e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.001616161e-05f, +1.855878775e-04f, -4.390390155e-04f, +2.292045253e-04f, +7.515772681e-04f, -1.628674706e-03f, +8.298788745e-04f, +1.744715690e-03f, -3.545446236e-03f, +1.731145461e-03f, +2.885352155e-03f, -5.548211855e-03f, +2.593970440e-03f, +3.654009310e-03f, -6.675283650e-03f, +2.990053264e-03f, +3.632797577e-03f, -6.311299411e-03f, +2.708284773e-03f, +2.825243912e-03f, -4.660445649e-03f, +1.913720021e-03f, +1.658796092e-03f, -2.586211951e-03f, +1.013897991e-03f, +6.636577527e-04f, -9.689545383e-04f, +3.616636038e-04f, +1.212714302e-04f, -1.075145692e-04f, +0.000000000e+00f,
        /* 11,13 (32) */
        +0.000000000e+00f, -5.096360667e-04f, +7.987058865e-04f, +1.013532239e-03f, -3.999243334e-03f, +2.497199346e-03f, +6.399274535e-03f, -1.307916009e-02f, +2.161592427e-03f, +2.303368059e-02f, -3.017258482e-02f, -9.160713861e-03f, +6.850505494e-02f, -6.406383185e-02f, -7.761676906e-02f, +3.883198572e-01f, +6.204619405e-01f, +1.838066565e-01f, -1.296199964e-01f, +7.104591091e-03f, +5.426979896e-02f, -3.592135768e-02f, -6.945075168e-03f, +2.324593974e-02f, -1.015762513e-02f, -5.848302367e-03f, +8.166284447e-03f, -1.801027891e-03f, -2.382209019e-03f, +1.749161279e-03f, -4.499712153e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +5.096360667e-04f, -1.373664645e-03f, -2.004488672e-04f, +4.992309768e-03f, -7.164608742e-03f, -8.449199480e-04f, +1.512066474e-02f, -1.790866331e-02f, -2.346767732e-03f, +2.954485715e-02f, -3.065829754e-02f, -4.509787320e-03f, +4.266254675e-02f, -3.963475612e-02f, -6.426664530e-03f, +4.779601970e-02f, -4.004140599e-02f, -7.014183843e-03f, +4.205239592e-02f, -3.169708765e-02f, -5.867642902e-03f, +2.860341107e-02f, -1.914866505e-02f, -3.625738261e-03f, +1.422478179e-02f, -8.178917040e-03f, -1.465778295e-03f, +4.398351440e-03f, -1.952023486e-03f, +4.499712153e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +1.912402271e-05f, -1.541084338e-04f, +2.113872174e-04f, +1.605359360e-04f, -7.888970184e-04f, +6.508167323e-04f, +9.035169628e-04f, -2.407854881e-03f, +1.043996991e-03f, +3.379094539e-03f, -5.802714914e-03f, +6.307772297e-05f, +1.196806374e-02f, -1.466482656e-02f, -3.326728023e-02f, +8.297016562e-03f, +3.391382572e-02f, +2.808650060e-03f, -1.117413572e-02f, +4.548636410e-03f, +2.956633492e-03f, -4.134708898e-03f, +9.219085338e-04f, +1.608709499e-03f, -1.424286778e-03f, +5.498480556e-05f, +6.095759291e-04f, -3.545858643e-04f, -3.495771602e-05f, +1.197987467e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.912402271e-05f, +1.956734673e-04f, -4.040997418e-04f, +1.271556887e-04f, +8.407043378e-04f, -1.547837769e-03f, +5.411772459e-04f, +2.000282133e-03f, -3.417750004e-03f, +1.191560114e-03f, +3.360128864e-03f, -5.399489258e-03f, +1.841917467e-03f, +4.308401061e-03f, -6.547465475e-03f, +2.173962125e-03f, +4.333758325e-03f, -6.237185937e-03f, +2.012878036e-03f, +3.414433922e-03f, -4.644186430e-03f, +1.457607839e-03f, +2.040060195e-03f, -2.605351521e-03f, +7.981028032e-04f, +8.420672912e-04f, -9.942311033e-04f, +3.013125153e-04f, +1.713870949e-04f, -1.197987467e-04f, +0.000000000e+00f,
        /* 11,14 (32) */
        +0.000000000e+00f, -4.905120440e-04f, +6.445974527e-04f, +1.224919457e-03f, -3.838707398e-03f, +1.708302327e-03f, +7.050091267e-03f, -1.217564313e-02f, -2.462624541e-04f, +2.407767758e-02f, -2.679349028e-02f, -1.496342877e-02f, +6.856813267e-02f, -5.209576810e-02f, -9.228159561e-02f, +3.550525770e-01f, +6.287589571e-01f, +2.177204822e-01f, -1.268113464e-01f, -4.069544625e-03f, +5.881843537e-02f, -3.296472419e-02f, -1.107978407e-02f, +2.416784827e-02f, -8.548915631e-03f, -7.272589145e-03f, +8.221269253e-03f, -1.191451962e-03f, -2.736794883e-03f, +1.714203563e-03f, +7.480162519e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.905120440e-04f, -1.177991178e-03f, -6.045486089e-04f, +5.119465457e-03f, -6.323904404e-03f, -2.392757717e-03f, +1.566184199e-02f, -1.590838118e-02f, -5.764517736e-03f, +3.073641726e-02f, -2.729816867e-02f, -9.909276578e-03f, +4.450446421e-02f, -3.532635506e-02f, -1.297413000e-02f, +4.996998183e-02f, -3.570764766e-02f, -1.325136978e-02f, +4.406527396e-02f, -2.828265373e-02f, -1.051182933e-02f, +3.006101891e-02f, -1.710860485e-02f, -6.231089781e-03f, +1.502288459e-02f, -7.336849749e-03f, -2.460009399e-03f, +4.699663955e-03f, -1.780636391e-03f, -7.480162519e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +2.685306184e-05f, -1.519596632e-04f, +1.760720761e-04f, +2.133848905e-04f, -7.747425269e-04f, +5.078899367e-04f, +1.056428589e-03f, -2.305633509e-03f, +6.259085202e-04f, +3.667467789e-03f, -5.340871520e-03f, -1.003764677e-03f, +1.216800061e-02f, -1.223580090e-02f, -3.399429673e-02f, +5.010603072e-03f, +3.437345706e-02f, +5.071274913e-03f, -1.167016172e-02f, +3.792586585e-03f, +3.611381843e-03f, -4.120340294e-03f, +5.652322161e-04f, +1.818623406e-03f, -1.370176154e-03f, -7.980483913e-05f, +6.648056295e-04f, -3.303462436e-04f, -6.892978118e-05f, +1.307312654e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -2.685306184e-05f, +2.007290083e-04f, -3.637431385e-04f, +2.849917238e-05f, +9.105023451e-04f, -1.442834315e-03f, +2.528729306e-04f, +2.213529401e-03f, -3.233859346e-03f, +6.423743823e-04f, +3.768946506e-03f, -5.159434945e-03f, +1.065181453e-03f, +4.884366485e-03f, -6.306773198e-03f, +1.319799421e-03f, +4.962195739e-03f, -6.054025378e-03f, +1.274926019e-03f, +3.952208277e-03f, -4.545869262e-03f, +9.655624416e-04f, +2.395085426e-03f, -2.578160955e-03f, +5.596855127e-04f, +1.012712208e-03f, -1.001898222e-03f, +2.311650394e-04f, +2.217972983e-04f, -1.307312654e-04f, +0.000000000e+00f,
        /* 11,15 (32) */
        +0.000000000e+00f, -4.636589821e-04f, +4.926377895e-04f, +1.400991533e-03f, -3.625322507e-03f, +9.335598005e-04f, +7.557981204e-03f, -1.111921454e-02f, -2.551895963e-03f, +2.470358610e-02f, -2.312602249e-02f, -2.030430029e-02f, +6.756436799e-02f, -3.992776749e-02f, -1.045173965e-01f, +3.210582802e-01f, +6.337695601e-01f, +2.520939393e-01f, -1.217400715e-01f, -1.573970634e-02f, +6.261102195e-02f, -2.935334235e-02f, -1.520012436e-02f, +2.473308049e-02f, -6.730292225e-03f, -8.642765300e-03f, +8.141464414e-03f, -5.266463322e-04f, -3.067141127e-03f, +1.645273782e-03f, +2.055328905e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.636589821e-04f, -9.772621697e-04f, -9.682917474e-04f, +5.147964629e-03f, -5.413402059e-03f, -3.835592032e-03f, +1.591471492e-02f, -1.369485178e-02f, -8.998377082e-03f, +3.137879165e-02f, -2.352922217e-02f, -1.506871152e-02f, +4.556964567e-02f, -3.044198857e-02f, -1.928090320e-02f, +5.128978125e-02f, -3.074545192e-02f, -1.930539516e-02f, +4.534019998e-02f, -2.433044545e-02f, -1.505769859e-02f, +3.102658135e-02f, -1.471351943e-02f, -8.809250736e-03f, +1.558257011e-02f, -6.324137540e-03f, -3.461907621e-03f, +4.930828994e-03f, -1.558839093e-03f, -2.055328905e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.315285962e-05f, -1.471444736e-04f, +1.401057002e-04f, +2.595530007e-04f, -7.486225761e-04f, +3.634744702e-04f, +1.185826608e-03f, -2.170997092e-03f, +2.142409335e-04f, +3.887513846e-03f, -4.814598421e-03f, -2.010048142e-03f, +1.217880404e-02f, -9.809674830e-03f, -3.441971216e-02f, +1.675619045e-03f, +3.454462879e-02f, +7.413000132e-03f, -1.200925710e-02f, +2.943297891e-03f, +4.234443633e-03f, -4.038384288e-03f, +1.847465416e-04f, +2.007399170e-03f, -1.290622629e-03f, -2.200087399e-04f, +7.115835566e-04f, -2.986283797e-04f, -1.041765491e-04f, +1.399604254e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -3.315285962e-05f, +2.010311674e-04f, -3.191257033e-04f, -6.507439985e-05f, +9.605757532e-04f, -1.316518315e-03f, -2.989319289e-05f, +2.381896629e-03f, -2.998386549e-03f, +9.342864861e-05f, +4.105732234e-03f, -4.833429021e-03f, +2.775764127e-04f, +5.372316216e-03f, -5.957741012e-03f, +4.425173936e-04f, +5.506807710e-03f, -5.764277198e-03f, +5.070221017e-04f, +4.428304910e-03f, -4.365791338e-03f, +4.456389479e-04f, +2.716755794e-03f, -2.503704416e-03f, +3.022516193e-04f, +1.172027193e-03f, -9.909186848e-04f, +1.520612352e-04f, +2.714216420e-04f, -1.399604254e-04f, +0.000000000e+00f,
        /* 12, 0 (28) */
        +2.536797823e-04f, +1.717120723e-03f, -4.267889081e-03f, +2.769345327e-03f, +5.951433797e-03f, -1.603584821e-02f, +1.292106340e-02f, +1.223371165e-02f, -4.454238865e-02f, +4.565217930e-02f, +1.809825863e-02f, -1.393967437e-01f, +2.613999239e-01f, +6.871774778e-01f, +2.613999239e-01f, -1.393967437e-01f, +1.809825863e-02f, +4.565217930e-02f, -4.454238865e-02f, +1.223371165e-02f, +1.292106340e-02f, -1.603584821e-02f, +5.951433797e-03f, +2.769345327e-03f, -4.267889081e-03f, +1.717120723e-03f, +2.536797823e-04f, -4.307376863e-04f,
        -2.536797823e-04f, -1.150482282e-03f, +5.406716708e-03f, -7.717177369e-03f, +1.823839110e-03f, +1.228216497e-02f, -2.346784071e-02f, +1.698003719e-02f, +9.330273566e-03f, -3.702545451e-02f, +4.007418410e-02f, -9.979930894e-03f, -3.212484989e-02f, +5.173229864e-02f, -3.212484989e-02f, -9.979930894e-03f, +4.007418410e-02f, -3.702545451e-02f, +9.330273566e-03f, +1.698003719e-02f, -2.346784071e-02f, +1.228216497e-02f, +1.823839110e-03f, -7.717177369e-03f, +5.406716708e-03f, -1.150482282e-03f, -7.255512597e-04f, +4.307376863e-04f,
        -1.672450930e-04f, +1.465671445e-04f, +2.793351282e-04f, -9.520184531e-04f, +9.883710096e-04f, +4.963052456e-04f, -2.901502336e-03f, +3.592745340e-03f, +1.313477054e-04f, -7.371602801e-03f, +1.150223500e-02f, -1.648722934e-03f, -4.005143650e-02f, -2.118136438e-03f, +4.037745317e-02f, +4.437358614e-03f, -1.245638046e-02f, +6.843477163e-03f, +7.088661868e-04f, -3.980942495e-03f, +2.784145616e-03f, -2.108995370e-04f, -1.155933415e-03f, +9.530438450e-04f, -2.119531771e-04f, -1.944786008e-04f, +1.790200031e-04f, -5.388669386e-05f,
        +1.672450930e-04f, -3.563316182e-04f, +3.507095578e-05f, +9.171349744e-04f, -1.851701628e-03f, +1.487106137e-03f, +7.898709170e-04f, -3.683687954e-03f, +4.506693883e-03f, -1.602136959e-03f, -3.509133136e-03f, +6.798018892e-03f, -5.159910641e-03f, -5.150350710e-04f, +5.820531774e-03f, -6.650473100e-03f, +2.745747260e-03f, +2.373496510e-03f, -4.787026885e-03f, +3.430508774e-03f, -3.325370984e-04f, -1.796023473e-03f, +1.894732968e-03f, -8.005610926e-04f, -1.566113751e-04f, +4.126503215e-04f, -2.384888080e-04f, +5.388669386e-05f,
        /* 12, 1 (28) */
        +8.643468934e-05f, +1.863687867e-03f, -3.988553953e-03f, +1.817326873e-03f, +6.939804807e-03f, -1.553954296e-02f, +1.001956106e-02f, +1.582645699e-02f, -4.441104094e-02f, +3.828057650e-02f, +2.960049363e-02f, -1.410454666e-01f, +2.213484874e-01f, +6.850593414e-01f, +3.017773770e-01f, -1.349593851e-01f, +5.641878176e-03f, +5.249565646e-02f, -4.383352246e-02f, +8.252769153e-03f, +1.570520902e-02f, -1.624674774e-02f, +4.795500382e-03f, +3.722389172e-03f, -4.479842259e-03f, +1.522642122e-03f, +4.326997854e-04f, -4.846243802e-04f,
        -8.643468934e-05f, -1.506813900e-03f, +5.441787664e-03f, -6.800042395e-03f, -2.786251825e-05f, +1.376927111e-02f, -2.267796980e-02f, +1.329634923e-02f, +1.383696745e-02f, -3.862759146e-02f, +3.656505097e-02f, -3.181912001e-03f, -3.728476053e-02f, +5.121726357e-02f, -2.630431811e-02f, -1.663040399e-02f, +4.281993136e-02f, -3.465195799e-02f, +4.543246681e-03f, +2.041054596e-02f, -2.380037781e-02f, +1.048614150e-02f, +3.718572078e-03f, -8.517738462e-03f, +5.250105333e-03f, -7.378319605e-04f, -9.640400678e-04f, +4.846243802e-04f,
        -1.528675171e-04f, +9.918120421e-05f, +3.370925927e-04f, -9.329073693e-04f, +8.104906417e-04f, +7.595375484e-04f, -2.960317642e-03f, +3.154777852e-03f, +9.344874199e-04f, -7.744794862e-03f, +1.039523570e-02f, +9.827504653e-04f, -3.933565280e-02f, -6.330402493e-03f, +4.030106993e-02f, +7.351434413e-03f, -1.323318207e-02f, +6.163199623e-03f, +1.571925014e-03f, -4.309842171e-03f, +2.607950826e-03f, +9.210410746e-05f, -1.309301519e-03f, +9.349443780e-04f, -1.357598181e-04f, -2.418840628e-04f, +1.876710624e-04f, -4.876934512e-05f,
        +1.528675171e-04f, -2.960898091e-04f, -7.999774610e-05f, +1.008798007e-03f, -1.772390996e-03f, +1.158733635e-03f, +1.217757814e-03f, -3.856401374e-03f, +4.141252984e-03f, -8.106068270e-04f, -4.193209028e-03f, +6.807829665e-03f, -4.398061769e-03f, -1.534608595e-03f, +6.366053508e-03f, -6.367178107e-03f, +1.917844561e-03f, +3.108430015e-03f, -4.974732374e-03f, +3.100196905e-03f, +1.454339456e-04f, -2.078167116e-03f, +1.899015724e-03f, -6.604422352e-04f, -2.821751720e-04f, +4.633554639e-04f, -2.399358804e-04f, +4.876934512e-05f,
        /* 12, 2 (28) */
        -6.643282774e-05f, +1.962869071e-03f, -3.651461360e-03f, +8.844195042e-04f, +7.750295448e-03f, -1.478000541e-02f, +7.059243422e-03f, +1.898123484e-02f, -4.347655352e-02f, +3.053578164e-02f, +3.999572933e-02f, -1.400627162e-01f, +1.820128346e-01f, +6.787289389e-01f, +3.420784470e-01f, -1.276079507e-01f, -7.591303891e-03f, +5.865885609e-02f, -4.226159745e-02f, +3.942926982e-03f, +1.831315984e-02f, -1.615464364e-02f, +3.486198863e-03f, +4.657333550e-03f, -4.615602077e-03f, +1.280758059e-03f, +6.203708478e-04f, -5.333937253e-04f,
        +6.643282774e-05f, -1.802903709e-03f, +5.361789918e-03f, -5.791244388e-03f, -1.800253514e-03f, +1.492800474e-02f, -2.146021198e-02f, +9.439947860e-03f, +1.797822043e-02f, -3.943819829e-02f, +3.237184194e-02f, +3.625917663e-03f, -4.168282230e-02f, +4.968265498e-02f, -1.993826460e-02f, -2.299758210e-02f, +4.473777593e-02f, -3.154352798e-02f, -4.314856932e-04f, +2.351074287e-02f, -2.365494387e-02f, +8.407974380e-03f, +5.617587802e-03f, -9.178180697e-03f, +4.967930161e-03f, -2.744764966e-04f, -1.203975948e-03f, +5.333937253e-04f,
        -1.364293789e-04f, +5.327334902e-05f, +3.846551742e-04f, -8.970520968e-04f, +6.261839747e-04f, +9.966420220e-04f, -2.961968729e-03f, +2.677101059e-03f, +1.687552938e-03f, -7.963070332e-03f, +9.161257681e-03f, +3.428535877e-03f, -3.824758405e-02f, -1.047097869e-02f, +3.981474570e-02f, +1.035642549e-02f, -1.380998121e-02f, +5.336411535e-03f, +2.442586050e-03f, -4.570654653e-03f, +2.373753014e-03f, +4.075727485e-04f, -1.444694209e-03f, +8.970210369e-04f, -5.180731948e-05f, -2.876916247e-04f, +1.927125243e-04f, -4.156503346e-05f,
        +1.364293789e-04f, -2.336012648e-04f, -1.864253916e-04f, +1.074791326e-03f, -1.659948055e-03f, +8.183882287e-04f, +1.608253408e-03f, -3.947064486e-03f, +3.699837061e-03f, -1.533015969e-05f, -4.784980729e-03f, +6.680767782e-03f, -3.550887706e-03f, -2.522911013e-03f, +6.784932201e-03f, -5.952947159e-03f, +1.041725762e-03f, +3.791197237e-03f, -5.064095315e-03f, +2.697803545e-03f, +6.345344592e-04f, -2.326549693e-03f, +1.862840948e-03f, -4.987477213e-04f, -4.090791664e-04f, +5.067850506e-04f, -2.349977934e-04f, +4.156503346e-05f,
        /* 12, 3 (28) */
        -2.028622066e-04f, +2.016142420e-03f, -3.266806186e-03f, -1.263259257e-05f, +8.376479423e-03f, -1.378336339e-02f, +4.097274693e-03f, +2.165833590e-02f, -4.178900058e-02f, +2.257271131e-02f, +4.915698701e-02f, -1.366341803e-01f, +1.437652505e-01f, +6.682579602e-01f, +3.818931927e-01f, -1.172515252e-01f, -2.140128510e-02f, +6.399526762e-02f, -3.981901140e-02f, -6.277276711e-04f, +2.068691286e-02f, -1.574707089e-02f, +2.041504654e-03f, +5.554354587e-03f, -4.667409396e-03f, +9.930664343e-04f, +8.130833721e-04f, -5.749587588e-04f,
        +2.028622066e-04f, -2.036504974e-03f, +5.175364526e-03f, -4.716453062e-03f, -3.460201569e-03f, +1.574639297e-02f, -1.985195857e-02f, +5.492883374e-03f, +2.167805749e-02f, -3.945352845e-02f, +2.758686121e-02f, +1.030668545e-02f, -4.523371000e-02f, +4.715974396e-02f, -1.315333240e-02f, -2.895052926e-02f, +4.577950169e-02f, -2.775233074e-02f, -5.495581009e-03f, +2.620854641e-02f, -2.302040941e-02f, +6.081424687e-03f, +7.480428750e-03f, -9.676928418e-03f, +4.558850994e-03f, +2.323085540e-04f, -1.438973742e-03f, +5.749587588e-04f,
        -1.184796094e-04f, +9.701468837e-06f, +4.216933994e-04f, -8.460543928e-04f, +4.392813748e-04f, +1.204334264e-03f, -2.908843806e-03f, +2.170104102e-03f, +2.378959509e-03f, -8.029138375e-03f, +7.827105658e-03f, +5.663640924e-03f, -3.680924997e-02f, -1.449316874e-02f, +3.891620076e-02f, +1.341544975e-02f, -1.416637980e-02f, +4.371627002e-03f, +3.304835570e-03f, -4.755524983e-03f, +2.083549996e-03f, +7.298934870e-04f, -1.558507252e-03f, +8.389474878e-04f, +3.862181063e-05f, -3.307700679e-04f, +1.937086978e-04f, -3.226033240e-05f,
        +1.184796094e-04f, -1.704884162e-04f, -2.823571302e-04f, +1.114952786e-03f, -1.518102927e-03f, +4.735502866e-04f, +1.954422772e-03f, -3.955833740e-03f, +3.192970307e-03f, +7.674455337e-04f, -5.273503314e-03f, +6.420504488e-03f, -2.635983122e-03f, -3.459819432e-03f, +7.068201233e-03f, -5.415340130e-03f, +1.348725363e-04f, +4.406913867e-03f, -5.051361226e-03f, +2.230029491e-03f, +1.124745888e-03f, -2.534680436e-03f, +1.785328442e-03f, -3.180323831e-04f, -5.344574970e-04f, +5.413498220e-04f, -2.232547969e-04f, +3.226033240e-05f,
        /* 12, 4 (28) */
        -3.213418160e-04f, +2.025843889e-03f, -2.845112787e-03f, -8.586869854e-04f, +8.815760798e-03f, -1.257902913e-02f, +1.188430887e-03f, +2.382844000e-02f, -3.941004108e-02f, +1.454357293e-02f, +5.698409267e-02f, -1.309705394e-01f, +1.069560005e-01f, +6.537647915e-01f, +4.208093934e-01f, -1.038360754e-01f, -3.556766490e-02f, +6.836689462e-02f, -3.651417583e-02f, -5.383252654e-03f, +2.277046285e-02f, -1.501717740e-02f, +4.829974021e-04f, +6.393302074e-03f, -4.628787586e-03f, +6.622963664e-04f, +1.006792070e-03f, -6.072190912e-04f,
        +3.213418160e-04f, -2.206993390e-03f, +4.893007396e-03f, -3.601500275e-03f, -4.978304495e-03f, +1.621994326e-02f, -1.789753580e-02f, +1.537049634e-03f, +2.487102780e-02f, -3.868608292e-02f, +2.231335790e-02f, +1.672718993e-02f, -4.786969313e-02f, +4.369992453e-02f, -6.085131171e-03f, -3.436586939e-02f, +4.591437422e-02f, -2.334541688e-02f, -1.054694224e-02f, +2.843857590e-02f, -2.189566352e-02f, +3.546744251e-03f, +9.265757193e-03f, -9.994960801e-03f, +4.024393497e-03f, +7.736583760e-04f, -1.662228538e-03f, +6.072190912e-04f,
        -9.956061041e-05f, -3.078396433e-05f, +4.481120097e-04f, -7.817309753e-04f, +2.534799409e-04f, +1.380033903e-03f, -2.804256211e-03f, +1.644300113e-03f, +2.998691664e-03f, -7.948251601e-03f, +6.420056655e-03f, +7.666882257e-03f, -3.504683346e-02f, -1.835190421e-02f, +3.760850993e-02f, +1.648975863e-02f, -1.428464473e-02f, +3.280196285e-03f, +4.142154551e-03f, -4.857720099e-03f, +1.740511933e-03f, +1.053063922e-03f, -1.647395118e-03f, +7.607963719e-04f, +1.340293189e-04f, -3.699721402e-04f, +1.902883064e-04f, -2.089939228e-05f,
        +9.956061041e-05f, -1.082834395e-04f, -3.662789776e-04f, +1.129693607e-03f, -1.351064978e-03f, +1.315380212e-04f, +2.250458932e-03f, -3.884562122e-03f, +2.632321013e-03f, +1.521985524e-03f, -5.650085530e-03f, +6.033421815e-03f, -1.672261772e-03f, -4.326281524e-03f, +7.209666429e-03f, -4.764524008e-03f, -7.844076779e-04f, +4.941878812e-03f, -4.934852764e-03f, +1.705119170e-03f, +1.605742504e-03f, -2.696724853e-03f, +1.666478813e-03f, -1.214040926e-04f, -6.553208742e-04f, +5.655782016e-04f, -2.044425160e-04f, +2.089939228e-05f,
        /* 12, 5 (28) */
        -4.209024264e-04f, +1.995059925e-03f, -2.397000777e-03f, -1.640417961e-03f, +9.069240739e-03f, -1.119899522e-02f, -1.615825324e-03f, +2.547274011e-02f, -3.641134941e-02f, +6.595321331e-03f, +6.340414933e-02f, -1.233036571e-01f, +7.190916708e-02f, +6.354128872e-01f, +4.584179034e-01f, -8.734631679e-02f, -4.985230963e-02f, +7.164709091e-02f, -3.237202128e-02f, -1.024097275e-02f, +2.451097478e-02f, -1.396411348e-02f, -1.164397716e-03f, +7.154098446e-03f, -4.494758267e-03f, +2.923242262e-04f, +1.197080376e-03f, -6.281184835e-04f,
        +4.209024264e-04f, -2.315276830e-03f, +4.526728418e-03f, -2.471806669e-03f, -6.329369473e-03f, +1.635148128e-02f, -1.564707687e-02f, -2.347512488e-03f, +2.750334881e-02f, -3.716409739e-02f, +1.666327237e-02f, +2.276061175e-02f, -4.954195490e-02f, +3.937364301e-02f, +1.124535258e-03f, -3.913039340e-02f, +4.512996655e-02f, -1.840353806e-02f, -1.548179500e-02f, +3.014369507e-02f, -2.028992102e-02f, +8.500193977e-04f, +1.093223601e-02f, -1.011636489e-02f, +3.369072623e-03f, +1.339236578e-03f, -1.866671054e-03f, +6.281184835e-04f,
        -8.019590328e-05f, -6.754951886e-05f, +4.640386987e-04f, -7.060660982e-04f, +7.227741654e-05f, +1.521883592e-03f, -2.652344429e-03f, +1.110127461e-03f, +3.538423540e-03f, -7.728018921e-03f, +4.967408666e-03f, +9.421096864e-03f, -3.299024913e-02f, -2.200436071e-02f, +3.590011742e-02f, +1.953926632e-02f, -1.415008039e-02f, +2.076218682e-03f, +4.937803493e-03f, -4.871801814e-03f, +1.348968398e-03f, +1.370794279e-03f, -1.708351263e-03f, +6.630585029e-04f, +2.327212214e-04f, -4.041596167e-04f, +1.821582209e-04f, -7.587240552e-06f,
        +8.019590328e-05f, -4.839619892e-05f, -4.370348828e-04f, +1.119963043e-03f, -1.163412236e-03f, -2.006440347e-04f, +2.491773835e-03f, -3.736719578e-03f, +2.030434812e-03f, +2.233388187e-03f, -5.908444404e-03f, +5.528458220e-03f, -6.795572423e-04f, -5.104711725e-03f, +7.206043552e-03f, -4.013077245e-03f, -1.697358098e-03f, +5.383880813e-03f, -4.715043669e-03f, +1.132718703e-03f, +2.067107283e-03f, -2.807654841e-03f, +1.507207368e-03f, +8.752309076e-05f, -7.686218053e-04f, +5.781607922e-04f, -1.784699863e-04f, +7.587240552e-06f,
        /* 12, 6 (28) */
        -5.010983297e-04f, +1.927510406e-03f, -1.932962079e-03f, -2.346484059e-03f, +9.141518155e-03f, -9.677111632e-03f, -4.268169753e-03f, +2.658286758e-02f, -3.287292587e-02f, -1.132697590e-03f, +6.837155799e-02f, -1.138825602e-01f, +3.891891795e-02f, +6.134085265e-01f, +4.943180208e-01f, -6.780705047e-02f, -6.400239002e-02f, +7.372330959e-02f, -2.743421778e-02f, -1.511277457e-02f, +2.585994318e-02f, -1.259331920e-02f, -2.872748979e-03f, +7.817156949e-03f, -4.262037045e-03f, -1.118353905e-04f, +1.379238597e-03f, -6.357057240e-04f,
        +5.010983297e-04f, -2.363673029e-03f, +4.089693535e-03f, -1.351843626e-03f, -7.492781709e-03f, +1.615083724e-02f, -1.315530303e-02f, -6.084232066e-03f, +2.953378363e-02f, -3.493070921e-02f, +1.075482796e-02f, +2.828906997e-02f, -5.022151214e-02f, +3.426893128e-02f, +8.330578811e-03f, -4.314347064e-02f, +4.343260845e-02f, -1.301965725e-02f, -2.019683867e-02f, +3.127641377e-02f, -1.822281373e-02f, -1.957635444e-03f, +1.243944337e-02f, -1.002884180e-02f, +2.600450818e-03f, +1.917397370e-03f, -2.045141041e-03f, +6.357057240e-04f,
        -6.087901448e-05f, -1.000852694e-04f, +4.698087680e-04f, -6.211630663e-04f, -1.010869565e-04f, +1.628753225e-03f, -2.457960440e-03f, +5.777598635e-04f, +3.991604482e-03f, -7.378184422e-03f, +3.496042480e-03f, +1.091328689e-02f, -3.067266242e-02f, -2.541053987e-02f, +3.380477231e-02f, +2.252310953e-02f, -1.375136211e-02f, +7.764048675e-04f, +5.675121813e-03f, -4.793781863e-03f, +9.143723041e-04f, +1.676619631e-03f, -1.738785164e-03f, +5.466542178e-04f, +3.328331849e-04f, -4.322296692e-04f, +1.691161917e-04f, +7.508309613e-06f,
        +6.087901448e-05f, +7.912975028e-06f, -4.938345194e-04f, +1.087202388e-03f, -9.599768576e-04f, -5.164447487e-04f, +2.675060557e-03f, -3.517280806e-03f, +1.400454491e-03f, +2.887882799e-03f, -6.044807332e-03f, +4.916901678e-03f, +3.217939208e-04f, -5.779356234e-03f, +7.057034781e-03f, -3.175741825e-03f, -2.585162361e-03f, +5.722477479e-03f, -4.394587711e-03f, +5.237003713e-04f, +2.498555560e-03f, -2.863385525e-03f, +1.309358438e-03f, +3.046896352e-04f, -8.713244713e-04f, +5.779932491e-04f, -1.454340762e-04f, -7.508309613e-06f,
        /* 12, 7 (28) */
        -5.619773442e-04f, +1.827425137e-03f, -1.463153310e-03f, -2.967647125e-03f, +9.040431199e-03f, -8.048358407e-03f, -6.726130192e-03f, +2.716062744e-02f, -2.888132139e-02f, -8.510882012e-03f, +7.186760047e-02f, -1.029692733e-01f, +8.246255527e-03f, +5.879979867e-01f, +5.281227931e-01f, -4.528394094e-02f, -7.775375213e-02f, +7.449971446e-02f, -2.175909597e-02f, -1.990655643e-02f, +2.677431549e-02f, -1.091669957e-02f, -4.611534143e-03f, +8.363811167e-03f, -3.929203860e-03f, -5.440650596e-04f, +1.548354789e-03f, -6.281974144e-04f,
        +5.619773442e-04f, -2.355760054e-03f, +3.595859016e-03f, -2.646412378e-04f, -8.452758567e-03f, +1.563439249e-02f, -1.048024248e-02f, -9.601512872e-03f, +3.093423812e-02f, -3.204282641e-02f, +4.710020632e-03f, +3.320597165e-02f, -4.989971822e-02f, +2.848957505e-02f, +1.538761359e-02f, -4.631921247e-02f, +4.084744609e-02f, -7.297179773e-03f, -2.459142638e-02f, +3.180011415e-02f, -1.572425817e-02f, -4.821020969e-03f, +1.374880181e-02f, -9.724152168e-03f, +1.729126347e-03f, +2.495390619e-03f, -2.190575117e-03f, +6.281974144e-04f,
        -4.206378952e-05f, -1.280081378e-04f, +4.659462400e-04f, -5.291957358e-04f, -2.636837668e-04f, +1.700229892e-03f, -2.226548985e-03f, +5.692856926e-05f, +4.353509573e-03f, -6.910377116e-03f, +2.032003567e-03f, +1.213469698e-02f, -2.812996702e-02f, -2.853380828e-02f, +3.134138529e-02f, +2.540022944e-02f, -1.308082424e-02f, -6.001104200e-04f, +6.337836843e-03f, -4.621255387e-03f, +4.432405220e-04f, +1.964020391e-03f, -1.736594373e-03f, +4.129362652e-04f, +4.323609993e-04f, -4.531420109e-04f, +1.510622100e-04f, +2.415628070e-05f,
        +4.206378952e-05f, +5.955524529e-05f, -5.362520523e-04f, +1.033289823e-03f, -7.457293554e-04f, -8.098916005e-04f, +2.798326164e-03f, -3.232583630e-03f, +7.558326327e-04f, +3.473098805e-03f, -6.057960081e-03f, +4.212135032e-03f, +1.311377751e-03f, -6.336619084e-03f, +6.765342374e-03f, -2.269128000e-03f, -3.429339408e-03f, +5.949240323e-03f, -3.978301224e-03f, -1.100433959e-04f, +2.890161670e-03f, -2.860895344e-03f, +1.075699082e-03f, +5.256642457e-04f, -9.604777611e-04f, +5.642163449e-04f, -1.056296913e-04f, -2.415628070e-05f,
        /* 12, 8 (28) */
        -6.040411337e-04f, +1.699416999e-03f, -9.972070705e-04f, -3.496842861e-03f, +8.776747432e-03f, -6.348128516e-03f, -8.952679177e-03f, +2.721755601e-02f, -2.452781182e-02f, -1.542125913e-02f, +7.389960404e-02f, -9.083457637e-02f, -1.988371149e-02f, +5.594641784e-01f, +5.594641784e-01f, -1.988371149e-02f, -9.083457637e-02f, +7.389960404e-02f, -1.542125913e-02f, -2.452781182e-02f, +2.721755601e-02f, -8.952679177e-03f, -6.348128516e-03f, +8.776747432e-03f, -3.496842861e-03f, -9.972070705e-04f, +1.699416999e-03f, -6.040411337e-04f,
        +6.040411337e-04f, -2.296204808e-03f, +3.059606964e-03f, +7.686485855e-04f, -9.198487922e-03f, +1.482450089e-02f, -7.681916313e-03f, -1.283409650e-02f, +3.169007075e-02f, -2.856972760e-02f, -1.347939449e-03f, +3.741810668e-02f, -4.858834047e-02f, +2.215295597e-02f, +2.215295597e-02f, -4.858834047e-02f, +3.741810668e-02f, -1.347939449e-03f, -2.856972760e-02f, +3.169007075e-02f, -1.283409650e-02f, -7.681916313e-03f, +1.482450089e-02f, -9.198487922e-03f, +7.686485855e-04f, +3.059606964e-03f, -2.296204808e-03f, +6.040411337e-04f,
        -2.415628070e-05f, -1.510622100e-04f, +4.531420109e-04f, -4.323609993e-04f, -4.129362652e-04f, +1.736594373e-03f, -1.964020391e-03f, -4.432405220e-04f, +4.621255387e-03f, -6.337836843e-03f, +6.001104200e-04f, +1.308082424e-02f, -2.540022944e-02f, -3.134138529e-02f, +2.853380828e-02f, +2.812996702e-02f, -1.213469698e-02f, -2.032003567e-03f, +6.910377116e-03f, -4.353509573e-03f, -5.692856926e-05f, +2.226548985e-03f, -1.700229892e-03f, +2.636837668e-04f, +5.291957358e-04f, -4.659462400e-04f, +1.280081378e-04f, +4.206378952e-05f,
        +2.415628070e-05f, +1.056296913e-04f, -5.642163449e-04f, +9.604777611e-04f, -5.256642457e-04f, -1.075699082e-03f, +2.860895344e-03f, -2.890161670e-03f, +1.100433959e-04f, +3.978301224e-03f, -5.949240323e-03f, +3.429339408e-03f, +2.269128000e-03f, -6.765342374e-03f, +6.336619084e-03f, -1.311377751e-03f, -4.212135032e-03f, +6.057960081e-03f, -3.473098805e-03f, -7.558326327e-04f, +3.232583630e-03f, -2.798326164e-03f, +8.098916005e-04f, +7.457293554e-04f, -1.033289823e-03f, +5.362520523e-04f, -5.955524529e-05f, -4.206378952e-05f,
        /* 12, 9 (28) */
        -6.281974144e-04f, +1.548354789e-03f, -5.440650596e-04f, -3.929203860e-03f, +8.363811167e-03f, -4.611534143e-03f, -1.091669957e-02f, +2.677431549e-02f, -1.990655643e-02f, -2.175909597e-02f, +7.449971446e-02f, -7.775375213e-02f, -4.528394094e-02f, +5.281227931e-01f, +5.879979867e-01f, +8.246255527e-03f, -1.029692733e-01f, +7.186760047e-02f, -8.510882012e-03f, -2.888132139e-02f, +2.716062744e-02f, -6.726130192e-03f, -8.048358407e-03f, +9.040431199e-03f, -2.967647125e-03f, -1.463153310e-03f, +1.827425137e-03f, -5.619773442e-04f,
        +6.281974144e-04f, -2.190575117e-03f, +2.495390619e-03f, +1.729126347e-03f, -9.724152168e-03f, +1.374880181e-02f, -4.821020969e-03f, -1.572425817e-02f, +3.180011415e-02f, -2.459142638e-02f, -7.297179773e-03f, +4.084744609e-02f, -4.631921247e-02f, +1.538761359e-02f, +2.848957505e-02f, -4.989971822e-02f, +3.320597165e-02f, +4.710020632e-03f, -3.204282641e-02f, +3.093423812e-02f, -9.601512872e-03f, -1.048024248e-02f, +1.563439249e-02f, -8.452758567e-03f, -2.646412378e-04f, +3.595859016e-03f, -2.355760054e-03f, +5.619773442e-04f,
        -7.508309613e-06f, -1.691161917e-04f, +4.322296692e-04f, -3.328331849e-04f, -5.466542178e-04f, +1.738785164e-03f, -1.676619631e-03f, -9.143723041e-04f, +4.793781863e-03f, -5.675121813e-03f, -7.764048675e-04f, +1.375136211e-02f, -2.252310953e-02f, -3.380477231e-02f, +2.541053987e-02f, +3.067266242e-02f, -1.091328689e-02f, -3.496042480e-03f, +7.378184422e-03f, -3.991604482e-03f, -5.777598635e-04f, +2.457960440e-03f, -1.628753225e-03f, +1.010869565e-04f, +6.211630663e-04f, -4.698087680e-04f, +1.000852694e-04f, +6.087901448e-05f,
        +7.508309613e-06f, +1.454340762e-04f, -5.779932491e-04f, +8.713244713e-04f, -3.046896352e-04f, -1.309358438e-03f, +2.863385525e-03f, -2.498555560e-03f, -5.237003713e-04f, +4.394587711e-03f, -5.722477479e-03f, +2.585162361e-03f, +3.175741825e-03f, -7.057034781e-03f, +5.779356234e-03f, -3.217939208e-04f, -4.916901678e-03f, +6.044807332e-03f, -2.887882799e-03f, -1.400454491e-03f, +3.517280806e-03f, -2.675060557e-03f, +5.164447487e-04f, +9.599768576e-04f, -1.087202388e-03f, +4.938345194e-04f, -7.912975028e-06f, -6.087901448e-05f,
        /* 12,10 (28) */
        -6.357057240e-04f, +1.379238597e-03f, -1.118353905e-04f, -4.262037045e-03f, +7.817156949e-03f, -2.872748979e-03f, -1.259331920e-02f, +2.585994318e-02f, -1.511277457e-02f, -2.743421778e-02f, +7.372330959e-02f, -6.400239002e-02f, -6.780705047e-02f, +4.943180208e-01f, +6.134085265e-01f, +3.891891795e-02f, -1.138825602e-01f, +6.837155799e-02f, -1.132697590e-03f, -3.287292587e-02f, +2.658286758e-02f, -4.268169753e-03f, -9.677111632e-03f, +9.141518155e-03f, -2.346484059e-03f, -1.932962079e-03f, +1.927510406e-03f, -5.010983297e-04f,
        +6.357057240e-04f, -2.045141041e-03f, +1.917397370e-03f, +2.600450818e-03f, -1.002884180e-02f, +1.243944337e-02f, -1.957635444e-03f, -1.822281373e-02f, +3.127641377e-02f, -2.019683867e-02f, -1.301965725e-02f, +4.343260845e-02f, -4.314347064e-02f, +8.330578811e-03f, +3.426893128e-02f, -5.022151214e-02f, +2.828906997e-02f, +1.075482796e-02f, -3.493070921e-02f, +2.953378363e-02f, -6.084232066e-03f, -1.315530303e-02f, +1.615083724e-02f, -7.492781709e-03f, -1.351843626e-03f, +4.089693535e-03f, -2.363673029e-03f, +5.010983297e-04f,
        +7.587240552e-06f, -1.821582209e-04f, +4.041596167e-04f, -2.327212214e-04f, -6.630585029e-04f, +1.708351263e-03f, -1.370794279e-03f, -1.348968398e-03f, +4.871801814e-03f, -4.937803493e-03f, -2.076218682e-03f, +1.415008039e-02f, -1.953926632e-02f, -3.590011742e-02f, +2.200436071e-02f, +3.299024913e-02f, -9.421096864e-03f, -4.967408666e-03f, +7.728018921e-03f, -3.538423540e-03f, -1.110127461e-03f, +2.652344429e-03f, -1.521883592e-03f, -7.227741654e-05f, +7.060660982e-04f, -4.640386987e-04f, +6.754951886e-05f, +8.019590328e-05f,
        -7.587240552e-06f, +1.784699863e-04f, -5.781607922e-04f, +7.686218053e-04f, -8.752309076e-05f, -1.507207368e-03f, +2.807654841e-03f, -2.067107283e-03f, -1.132718703e-03f, +4.715043669e-03f, -5.383880813e-03f, +1.697358098e-03f, +4.013077245e-03f, -7.206043552e-03f, +5.104711725e-03f, +6.795572423e-04f, -5.528458220e-03f, +5.908444404e-03f, -2.233388187e-03f, -2.030434812e-03f, +3.736719578e-03f, -2.491773835e-03f, +2.006440347e-04f, +1.163412236e-03f, -1.119963043e-03f, +4.370348828e-04f, +4.839619892e-05f, -8.019590328e-05f,
        /* 12,11 (28) */
        -6.281184835e-04f, +1.197080376e-03f, +2.923242262e-04f, -4.494758267e-03f, +7.154098446e-03f, -1.164397716e-03f, -1.396411348e-02f, +2.451097478e-02f, -1.024097275e-02f, -3.237202128e-02f, +7.164709091e-02f, -4.985230963e-02f, -8.734631679e-02f, +4.584179034e-01f, +6.354128872e-01f, +7.190916708e-02f, -1.233036571e-01f, +6.340414933e-02f, +6.595321331e-03f, -3.641134941e-02f, +2.547274011e-02f, -1.615825324e-03f, -1.119899522e-02f, +9.069240739e-03f, -1.640417961e-03f, -2.397000777e-03f, +1.995059925e-03f, -4.209024264e-04f,
        +6.281184835e-04f, -1.866671054e-03f, +1.339236578e-03f, +3.369072623e-03f, -1.011636489e-02f, +1.093223601e-02f, +8.500193977e-04f, -2.028992102e-02f, +3.014369507e-02f, -1.548179500e-02f, -1.840353806e-02f, +4.512996655e-02f, -3.913039340e-02f, +1.124535258e-03f, +3.937364301e-02f, -4.954195490e-02f, +2.276061175e-02f, +1.666327237e-02f, -3.716409739e-02f, +2.750334881e-02f, -2.347512488e-03f, -1.564707687e-02f, +1.635148128e-02f, -6.329369473e-03f, -2.471806669e-03f, +4.526728418e-03f, -2.315276830e-03f, +4.209024264e-04f,
        +2.089939228e-05f, -1.902883064e-04f, +3.699721402e-04f, -1.340293189e-04f, -7.607963719e-04f, +1.647395118e-03f, -1.053063922e-03f, -1.740511933e-03f, +4.857720099e-03f, -4.142154551e-03f, -3.280196285e-03f, +1.428464473e-02f, -1.648975863e-02f, -3.760850993e-02f, +1.835190421e-02f, +3.504683346e-02f, -7.666882257e-03f, -6.420056655e-03f, +7.948251601e-03f, -2.998691664e-03f, -1.644300113e-03f, +2.804256211e-03f, -1.380033903e-03f, -2.534799409e-04f, +7.817309753e-04f, -4.481120097e-04f, +3.078396433e-05f, +9.956061041e-05f,
        -2.089939228e-05f, +2.044425160e-04f, -5.655782016e-04f, +6.553208742e-04f, +1.214040926e-04f, -1.666478813e-03f, +2.696724853e-03f, -1.605742504e-03f, -1.705119170e-03f, +4.934852764e-03f, -4.941878812e-03f, +7.844076779e-04f, +4.764524008e-03f, -7.209666429e-03f, +4.326281524e-03f, +1.672261772e-03f, -6.033421815e-03f, +5.650085530e-03f, -1.521985524e-03f, -2.632321013e-03f, +3.884562122e-03f, -2.250458932e-03f, -1.315380212e-04f, +1.351064978e-03f, -1.129693607e-03f, +3.662789776e-04f, +1.082834395e-04f, -9.956061041e-05f,
        /* 12,12 (28) */
        -6.072190912e-04f, +1.006792070e-03f, +6.622963664e-04f, -4.628787586e-03f, +6.393302074e-03f, +4.829974021e-04f, -1.501717740e-02f, +2.277046285e-02f, -5.383252654e-03f, -3.651417583e-02f, +6.836689462e-02f, -3.556766490e-02f, -1.038360754e-01f, +4.208093934e-01f, +6.537647915e-01f, +1.069560005e-01f, -1.309705394e-01f, +5.698409267e-02f, +1.454357293e-02f, -3.941004108e-02f, +2.382844000e-02f, +1.188430887e-03f, -1.257902913e-02f, +8.815760798e-03f, -8.586869854e-04f, -2.845112787e-03f, +2.025843889e-03f, -3.213418160e-04f,
        +6.072190912e-04f, -1.662228538e-03f, +7.736583760e-04f, +4.024393497e-03f, -9.994960801e-03f, +9.265757193e-03f, +3.546744251e-03f, -2.189566352e-02f, +2.843857590e-02f, -1.054694224e-02f, -2.334541688e-02f, +4.591437422e-02f, -3.436586939e-02f, -6.085131171e-03f, +4.369992453e-02f, -4.786969313e-02f, +1.672718993e-02f, +2.231335790e-02f, -3.868608292e-02f, +2.487102780e-02f, +1.537049634e-03f, -1.789753580e-02f, +1.621994326e-02f, -4.978304495e-03f, -3.601500275e-03f, +4.893007396e-03f, -2.206993390e-03f, +3.213418160e-04f,
        +3.226033240e-05f, -1.937086978e-04f, +3.307700679e-04f, -3.862181063e-05f, -8.389474878e-04f, +1.558507252e-03f, -7.298934870e-04f, -2.083549996e-03f, +4.755524983e-03f, -3.304835570e-03f, -4.371627002e-03f, +1.416637980e-02f, -1.341544975e-02f, -3.891620076e-02f, +1.449316874e-02f, +3.680924997e-02f, -5.663640924e-03f, -7.827105658e-03f, +8.029138375e-03f, -2.378959509e-03f, -2.170104102e-03f, +2.908843806e-03f, -1.204334264e-03f, -4.392813748e-04f, +8.460543928e-04f, -4.216933994e-04f, -9.701468837e-06f, +1.184796094e-04f,
        -3.226033240e-05f, +2.232547969e-04f, -5.413498220e-04f, +5.344574970e-04f, +3.180323831e-04f, -1.785328442e-03f, +2.534680436e-03f, -1.124745888e-03f, -2.230029491e-03f, +5.051361226e-03f, -4.406913867e-03f, -1.348725363e-04f, +5.415340130e-03f, -7.068201233e-03f, +3.459819432e-03f, +2.635983122e-03f, -6.420504488e-03f, +5.273503314e-03f, -7.674455337e-04f, -3.192970307e-03f, +3.955833740e-03f, -1.954422772e-03f, -4.735502866e-04f, +1.518102927e-03f, -1.114952786e-03f, +2.823571302e-04f, +1.704884162e-04f, -1.184796094e-04f,
        /* 12,13 (28) */
        -5.749587588e-04f, +8.130833721e-04f, +9.930664343e-04f, -4.667409396e-03f, +5.554354587e-03f, +2.041504654e-03f, -1.574707089e-02f, +2.068691286e-02f, -6.277276711e-04f, -3.981901140e-02f, +6.399526762e-02f, -2.140128510e-02f, -1.172515252e-01f, +3.818931927e-01f, +6.682579602e-01f, +1.437652505e-01f, -1.366341803e-01f, +4.915698701e-02f, +2.257271131e-02f, -4.178900058e-02f, +2.165833590e-02f, +4.097274693e-03f, -1.378336339e-02f, +8.376479423e-03f, -1.263259257e-05f, -3.266806186e-03f, +2.016142420e-03f, -2.028622066e-04f,
        +5.749587588e-04f, -1.438973742e-03f, +2.323085540e-04f, +4.558850994e-03f, -9.676928418e-03f, +7.480428750e-03f, +6.081424687e-03f, -2.302040941e-02f, +2.620854641e-02f, -5.495581009e-03f, -2.775233074e-02f, +4.577950169e-02f, -2.895052926e-02f, -1.315333240e-02f, +4.715974396e-02f, -4.523371000e-02f, +1.030668545e-02f, +2.758686121e-02f, -3.945352845e-02f, +2.167805749e-02f, +5.492883374e-03f, -1.985195857e-02f, +1.574639297e-02f, -3.460201569e-03f, -4.716453062e-03f, +5.175364526e-03f, -2.036504974e-03f, +2.028622066e-04f,
        +4.156503346e-05f, -1.927125243e-04f, +2.876916247e-04f, +5.180731948e-05f, -8.970210369e-04f, +1.444694209e-03f, -4.075727485e-04f, -2.373753014e-03f, +4.570654653e-03f, -2.442586050e-03f, -5.336411535e-03f, +1.380998121e-02f, -1.035642549e-02f, -3.981474570e-02f, +1.047097869e-02f, +3.824758405e-02f, -3.428535877e-03f, -9.161257681e-03f, +7.963070332e-03f, -1.687552938e-03f, -2.677101059e-03f, +2.961968729e-03f, -9.966420220e-04f, -6.261839747e-04f, +8.970520968e-04f, -3.846551742e-04f, -5.327334902e-05f, +1.364293789e-04f,
        -4.156503346e-05f, +2.349977934e-04f, -5.067850506e-04f, +4.090791664e-04f, +4.987477213e-04f, -1.862840948e-03f, +2.326549693e-03f, -6.345344592e-04f, -2.697803545e-03f, +5.064095315e-03f, -3.791197237e-03f, -1.041725762e-03f, +5.952947159e-03f, -6.784932201e-03f, +2.522911013e-03f, +3.550887706e-03f, -6.680767782e-03f, +4.784980729e-03f, +1.533015969e-05f, -3.699837061e-03f, +3.947064486e-03f, -1.608253408e-03f, -8.183882287e-04f, +1.659948055e-03f, -1.074791326e-03f, +1.864253916e-04f, +2.336012648e-04f, -1.364293789e-04f,
        /* 12,14 (28) */
        -5.333937253e-04f, +6.203708478e-04f, +1.280758059e-03f, -4.615602077e-03f, +4.657333550e-03f, +3.486198863e-03f, -1.615464364e-02f, +1.831315984e-02f, +3.942926982e-03f, -4.226159745e-02f, +5.865885609e-02f, -7.591303891e-03f, -1.276079507e-01f, +3.420784470e-01f, +6.787289389e-01f, +1.820128346e-01f, -1.400627162e-01f, +3.999572933e-02f, +3.053578164e-02f, -4.347655352e-02f, +1.898123484e-02f, +7.059243422e-03f, -1.478000541e-02f, +7.750295448e-03f, +8.844195042e-04f, -3.651461360e-03f, +1.962869071e-03f, -6.643282774e-05f,
        +5.333937253e-04f, -1.203975948e-03f, -2.744764966e-04f, +4.967930161e-03f, -9.178180697e-03f, +5.617587802e-03f, +8.407974380e-03f, -2.365494387e-02f, +2.351074287e-02f, -4.314856932e-04f, -3.154352798e-02f, +4.473777593e-02f, -2.299758210e-02f, -1.993826460e-02f, +4.968265498e-02f, -4.168282230e-02f, +3.625917663e-03f, +3.237184194e-02f, -3.943819829e-02f, +1.797822043e-02f, +9.439947860e-03f, -2.146021198e-02f, +1.492800474e-02f, -1.800253514e-03f, -5.791244388e-03f, +5.361789918e-03f, -1.802903709e-03f, +6.643282774e-05f,
        +4.876934512e-05f, -1.876710624e-04f, +2.418840628e-04f, +1.357598181e-04f, -9.349443780e-04f, +1.309301519e-03f, -9.210410746e-05f, -2.607950826e-03f, +4.309842171e-03f, -1.571925014e-03f, -6.163199623e-03f, +1.323318207e-02f, -7.351434413e-03f, -4.030106993e-02f, +6.330402493e-03f, +3.933565280e-02f, -9.827504653e-04f, -1.039523570e-02f, +7.744794862e-03f, -9.344874199e-04f, -3.154777852e-03f, +2.960317642e-03f, -7.595375484e-04f, -8.104906417e-04f, +9.329073693e-04f, -3.370925927e-04f, -9.918120421e-05f, +1.528675171e-04f,
        -4.876934512e-05f, +2.399358804e-04f, -4.633554639e-04f, +2.821751720e-04f, +6.604422352e-04f, -1.899015724e-03f, +2.078167116e-03f, -1.454339456e-04f, -3.100196905e-03f, +4.974732374e-03f, -3.108430015e-03f, -1.917844561e-03f, +6.367178107e-03f, -6.366053508e-03f, +1.534608595e-03f, +4.398061769e-03f, -6.807829665e-03f, +4.193209028e-03f, +8.106068270e-04f, -4.141252984e-03f, +3.856401374e-03f, -1.217757814e-03f, -1.158733635e-03f, +1.772390996e-03f, -1.008798007e-03f, +7.999774610e-05f, +2.960898091e-04f, -1.528675171e-04f,
        /* 12,15 (28) */
        -4.846243802e-04f, +4.326997854e-04f, +1.522642122e-03f, -4.479842259e-03f, +3.722389172e-03f, +4.795500382e-03f, -1.624674774e-02f, +1.570520902e-02f, +8.252769153e-03f, -4.383352246e-02f, +5.249565646e-02f, +5.641878176e-03f, -1.349593851e-01f, +3.017773770e-01f, +6.850593414e-01f, +2.213484874e-01f, -1.410454666e-01f, +2.960049363e-02f, +3.828057650e-02f, -4.441104094e-02f, +1.582645699e-02f, +1.001956106e-02f, -1.553954296e-02f, +6.939804807e-03f, +1.817326873e-03f, -3.988553953e-03f, +1.863687867e-03f, +8.643468934e-05f,
        +4.846243802e-04f, -9.640400678e-04f, -7.378319605e-04f, +5.250105333e-03f, -8.517738462e-03f, +3.718572078e-03f, +1.048614150e-02f, -2.380037781e-02f, +2.041054596e-02f, +4.543246681e-03f, -3.465195799e-02f, +4.281993136e-02f, -1.663040399e-02f, -2.630431811e-02f, +5.121726357e-02f, -3.728476053e-02f, -3.181912001e-03f, +3.656505097e-02f, -3.862759146e-02f, +1.383696745e-02f, +1.329634923e-02f, -2.267796980e-02f, +1.376927111e-02f, -2.786251825e-05f, -6.800042395e-03f, +5.441787664e-03f, -1.506813900e-03f, -8.643468934e-05f,
        +5.388669386e-05f, -1.790200031e-04f, +1.944786008e-04f, +2.119531771e-04f, -9.530438450e-04f, +1.155933415e-03f, +2.108995370e-04f, -2.784145616e-03f, +3.980942495e-03f, -7.088661868e-04f, -6.843477163e-03f, +1.245638046e-02f, -4.437358614e-03f, -4.037745317e-02f, +2.118136438e-03f, +4.005143650e-02f, +1.648722934e-03f, -1.150223500e-02f, +7.371602801e-03f, -1.313477054e-04f, -3.592745340e-03f, +2.901502336e-03f, -4.963052456e-04f, -9.883710096e-04f, +9.520184531e-04f, -2.793351282e-04f, -1.465671445e-04f, +1.672450930e-04f,
        -5.388669386e-05f, +2.384888080e-04f, -4.126503215e-04f, +1.566113751e-04f, +8.005610926e-04f, -1.894732968e-03f, +1.796023473e-03f, +3.325370984e-04f, -3.430508774e-03f, +4.787026885e-03f, -2.373496510e-03f, -2.745747260e-03f, +6.650473100e-03f, -5.820531774e-03f, +5.150350710e-04f, +5.159910641e-03f, -6.798018892e-03f, +3.509133136e-03f, +1.602136959e-03f, -4.506693883e-03f, +3.683687954e-03f, -7.898709170e-04f, -1.487106137e-03f, +1.851701628e-03f, -9.171349744e-04f, -3.507095578e-05f, +3.563316182e-04f, -1.672450930e-04f,
        /* 13, 0 (28) */
        +0.000000000e+00f, +5.666384406e-04f, +1.138827626e-03f, -4.947832042e-03f, +7.775272907e-03f, -3.753683238e-03f, -1.054677731e-02f, +2.921374884e-02f, -3.521211508e-02f, +8.626724797e-03f, +5.817244274e-02f, -1.493766746e-01f, +2.292750740e-01f, +7.389097765e-01f, +2.292750740e-01f, -1.493766746e-01f, +5.817244274e-02f, +8.626724797e-03f, -3.521211508e-02f, +2.921374884e-02f, -1.054677731e-02f, -3.753683238e-03f, +7.775272907e-03f, -4.947832042e-03f, +1.138827626e-03f, +5.666384406e-04f, -4.718714774e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -5.666384406e-04f, +1.805043397e-04f, +3.931653329e-03f, -1.009328495e-02f, +1.316547915e-02f, -6.922639574e-03f, -9.865401789e-03f, +2.934697745e-02f, -3.767009023e-02f, +2.481811038e-02f, +6.027636000e-03f, -3.812597854e-02f, +5.173229864e-02f, -3.812597854e-02f, +6.027636000e-03f, +2.481811038e-02f, -3.767009023e-02f, +2.934697745e-02f, -9.865401789e-03f, -6.922639574e-03f, +1.316547915e-02f, -1.009328495e-02f, +3.931653329e-03f, +1.805043397e-04f, -1.107043555e-03f, +4.718714774e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -2.097644736e-04f, +3.144060840e-04f, -3.488347878e-05f, -8.633306184e-04f, +1.983411383e-03f, -2.111631419e-03f, -9.094261349e-05f, +4.638041588e-03f, -8.973739761e-03f, +7.993101867e-03f, +5.149295958e-03f, -4.521134714e-02f, -2.633171509e-03f, +4.619798494e-02f, -2.213114486e-03f, -9.710633196e-03f, +9.216973673e-03f, -4.078160698e-03f, -5.504337213e-04f, +2.451608517e-03f, -2.006923010e-03f, +7.387995536e-04f, +1.524827524e-04f, -3.685645521e-04f, +2.181717207e-04f, -5.946880494e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +2.097644736e-04f, -5.386640945e-04f, +5.864237478e-04f, +6.267133557e-05f, -1.515500253e-03f, +3.078761555e-03f, -3.430546520e-03f, +1.549361071e-03f, +2.213291408e-03f, -5.907735770e-03f, +7.078790914e-03f, -4.533039716e-03f, -5.935089525e-04f, +5.429877442e-03f, -7.280540492e-03f, +5.412653288e-03f, -1.377455760e-03f, -2.272920446e-03f, +3.764398369e-03f, -3.025169814e-03f, +1.264416787e-03f, +1.822393881e-04f, -7.250456053e-04f, +5.797191266e-04f, -2.564322231e-04f, +5.946880494e-05f, +0.000000000e+00f,
        /* 13, 1 (28) */
        +0.000000000e+00f, +3.568739670e-04f, +1.453233711e-03f, -4.982715521e-03f, +6.911942288e-03f, -1.770271855e-03f, -1.265840873e-02f, +2.912280622e-02f, -3.057407349e-02f, -3.470149638e-04f, +6.616554460e-02f, -1.442273786e-01f, +1.840637268e-01f, +7.362766049e-01f, +2.754730589e-01f, -1.515897891e-01f, +4.846180954e-02f, +1.784369847e-02f, -3.929027578e-02f, +2.866331511e-02f, -8.095168796e-03f, -5.760606248e-03f, +8.514072460e-03f, -4.795349290e-03f, +7.702630743e-04f, +7.848101613e-04f, -5.313402824e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -3.568739670e-04f, -3.581597548e-04f, +4.518077077e-03f, -1.003061361e-02f, +1.164997889e-02f, -3.843878019e-03f, -1.329594831e-02f, +3.089633852e-02f, -3.545679882e-02f, +1.891037461e-02f, +1.310642691e-02f, -4.265901826e-02f, +5.113878969e-02f, -3.269610110e-02f, -1.252904492e-03f, +3.023076367e-02f, -3.904754599e-02f, +2.707405700e-02f, -6.101003420e-03f, -9.947809388e-03f, +1.442989593e-02f, -9.911045560e-03f, +3.206607724e-03f, +7.602234664e-04f, -1.363475778e-03f, +5.313402824e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.969086049e-04f, +2.570948466e-04f, +7.589063730e-05f, -9.619003544e-04f, +1.918271183e-03f, -1.742559828e-03f, -7.016235217e-04f, +5.075740404e-03f, -8.555401689e-03f, +6.202026669e-03f, +7.790580130e-03f, -4.373371457e-02f, -7.865011088e-03f, +4.666712344e-02f, +9.842563057e-04f, -1.131533751e-02f, +9.271629637e-03f, -3.402807360e-03f, -1.209645266e-03f, +2.753384771e-03f, -1.986063008e-03f, +5.897142049e-04f, +2.745021427e-04f, -4.179349901e-04f, +2.214714011e-04f, -5.226481803e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +1.969086049e-04f, -4.867890496e-04f, +4.418095209e-04f, +2.938279412e-04f, -1.720371530e-03f, +3.058478095e-03f, -3.026391735e-03f, +8.065505564e-04f, +2.982793047e-03f, -6.259498197e-03f, +6.714961298e-03f, -3.535159361e-03f, -1.766588182e-03f, +6.204121044e-03f, -7.314035106e-03f, +4.784107531e-03f, -4.940500910e-04f, -2.959375512e-03f, +4.017817410e-03f, -2.896437912e-03f, +9.714624842e-04f, +4.353067917e-04f, -8.535997808e-04f, +6.079668797e-04f, -2.449614229e-04f, +5.226481803e-05f, +0.000000000e+00f,
        /* 13, 2 (28) */
        +0.000000000e+00f, +1.599653621e-04f, +1.710328557e-03f, -4.906824884e-03f, +5.950041934e-03f, +1.479993283e-04f, -1.440096856e-02f, +2.842118270e-02f, -2.549833309e-02f, -8.902416653e-03f, +7.236757127e-02f, -1.364367985e-01f, +1.403300123e-01f, +7.284115939e-01f, +3.221401824e-01f, -1.506055328e-01f, +3.714647203e-02f, +2.711532811e-02f, -4.269308314e-02f, +2.745366985e-02f, -5.341784024e-03f, -7.746669256e-03f, +9.103786665e-03f, -4.520847147e-03f, +3.523280842e-04f, +1.006281562e-03f, -5.836051004e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.599653621e-04f, -8.449488044e-04f, +4.959886598e-03f, -9.736785672e-03f, +9.929607362e-03f, -7.853999246e-04f, -1.632234004e-02f, +3.170288907e-02f, -3.247400577e-02f, +1.265087641e-02f, +1.982138821e-02f, -4.619417762e-02f, +4.937220151e-02f, -2.649198006e-02f, -8.566939598e-03f, +3.501487120e-02f, -3.954159608e-02f, +2.411468149e-02f, -2.083186010e-03f, -1.284424730e-02f, +1.540135842e-02f, -9.475738768e-03f, +2.353007943e-03f, +1.368190346e-03f, -1.608437201e-03f, +5.836051004e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.803279158e-04f, +1.982297826e-04f, +1.777392293e-04f, -1.033764080e-03f, +1.815030251e-03f, -1.353715321e-03f, -1.269963427e-03f, +5.387389999e-03f, -7.978400491e-03f, +4.376276951e-03f, +1.010930366e-02f, -4.179847175e-02f, -1.299388970e-02f, +4.659967790e-02f, +4.403478335e-03f, -1.276825545e-02f, +9.127608772e-03f, -2.621509266e-03f, -1.872851108e-03f, +3.008287473e-03f, -1.918976945e-03f, +4.181467393e-04f, +3.982733156e-04f, -4.608864859e-04f, +2.190934259e-04f, -4.228526908e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +1.803279158e-04f, -4.262449191e-04f, +2.952059116e-04f, +5.062396848e-04f, -1.875992812e-03f, +2.967327785e-03f, -2.563469441e-03f, +6.240126125e-05f, +3.669102029e-03f, -6.461610334e-03f, +6.199014336e-03f, -2.460089821e-03f, -2.898186105e-03f, +6.837049515e-03f, -7.177068805e-03f, +4.035287579e-03f, +4.166820726e-04f, -3.591374182e-03f, +4.182370935e-03f, -2.693134488e-03f, +6.422219079e-04f, +6.904469727e-04f, -9.680474561e-04f, +6.216528191e-04f, -2.246658194e-04f, +4.228526908e-05f, +0.000000000e+00f,
        /* 13, 3 (28) */
        +0.000000000e+00f, -2.036255371e-05f, +1.908558340e-03f, -4.729085655e-03f, +4.916277854e-03f, +1.963029579e-03f, -1.575468388e-02f, +2.715121927e-02f, -2.011094309e-02f, -1.688081714e-02f, +7.674384822e-02f, -1.263274948e-01f, +9.853154051e-02f, +7.154177042e-01f, +3.687398603e-01f, -1.462020544e-01f, +2.437821658e-02f, +3.624293688e-02f, -4.531459241e-02f, +2.558081874e-02f, -2.333496551e-03f, -9.665646201e-03f, +9.521933405e-03f, -4.122573832e-03f, -1.085584017e-04f, +1.225374988e-03f, -6.258903695e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.036255371e-05f, -1.271193724e-03f, +5.255092509e-03f, -9.230545987e-03f, +8.053614551e-03f, +2.181927861e-03f, -1.888580949e-02f, +3.176529033e-02f, -2.880490374e-02f, +6.189266080e-03f, +2.602040255e-02f, -4.865426744e-02f, +4.647401540e-02f, -1.965493054e-02f, -1.574400840e-02f, +3.905015878e-02f, -3.912491400e-02f, +2.052330731e-02f, +2.099184926e-03f, -1.553738179e-02f, +1.604358032e-02f, -8.785291796e-03f, +1.384960487e-03f, +1.989843165e-03f, -1.833103021e-03f, +6.258903695e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.607869473e-04f, +1.393362692e-04f, +2.688983937e-04f, -1.078821552e-03f, +1.677884550e-03f, -9.544210337e-04f, -1.785729637e-03f, +5.571929816e-03f, -7.261692841e-03f, +2.553602345e-03f, +1.208414541e-02f, -3.944523309e-02f, -1.795298817e-02f, +4.598440199e-02f, +8.000109621e-03f, -1.403150726e-02f, +8.778540869e-03f, -1.746525657e-03f, -2.525495492e-03f, +3.208295884e-03f, -1.804786949e-03f, +2.268211904e-04f, +5.209151047e-04f, -4.958356864e-04f, +2.105797540e-04f, -2.954609909e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +1.607869473e-04f, -3.592765960e-04f, +1.504421647e-04f, +6.956218532e-04f, -1.980655016e-03f, +2.809931649e-03f, -2.054402099e-03f, -6.655491105e-04f, +4.257637282e-03f, -6.511374719e-03f, +5.544428988e-03f, -1.333404387e-03f, -3.961756046e-03f, +7.313234093e-03f, -6.871490347e-03f, +3.182436308e-03f, +1.333487281e-03f, -4.152504418e-03f, +4.251579924e-03f, -2.417707849e-03f, +2.834276143e-04f, +9.412283131e-04f, -1.064499817e-03f, +6.193214927e-04f, -1.953873470e-04f, +2.954609909e-05f, +0.000000000e+00f,
        /* 13, 4 (28) */
        +0.000000000e+00f, -1.811495010e-04f, +2.047894609e-03f, -4.460187261e-03f, +3.837456302e-03f, +3.640914129e-03f, -1.670910491e-02f, +2.536548964e-02f, -1.453901327e-02f, -2.414250999e-02f, +7.929745057e-02f, -1.142433494e-01f, +5.908630741e-02f, +6.974647160e-01f, +4.147242623e-01f, -1.382019448e-01f, +1.034670932e-02f, +4.502147775e-02f, -4.706111806e-02f, +2.305532325e-02f, +8.747993327e-04f, -1.147043315e-02f, +9.748754595e-03f, -3.601658727e-03f, -6.043940881e-04f, +1.435954742e-03f, -6.554364686e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.811495010e-04f, -1.630470320e-03f, +5.405534674e-03f, -8.534924134e-03f, +6.072959535e-03f, +4.991859510e-03f, -2.094021158e-02f, +3.109974122e-02f, -2.454726646e-02f, -3.221086391e-04f, +3.156483154e-02f, -4.998767183e-02f, +4.251225936e-02f, -1.234169645e-02f, -2.261549875e-02f, +4.223259509e-02f, -3.779142672e-02f, +1.637080289e-02f, +6.350764850e-03f, -1.795508964e-02f, +1.632700794e-02f, -7.844063483e-03f, +3.204606698e-04f, +2.609164658e-03f, -2.028490368e-03f, +6.554364686e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.390674038e-04f, +8.183303216e-05f, +3.479626316e-04f, -1.097585037e-03f, +1.511571924e-03f, -5.537972797e-04f, -2.240262009e-03f, +5.631012677e-03f, -6.426266076e-03f, +7.699711255e-04f, +1.370030407e-02f, -3.671909523e-02f, -2.267818574e-02f, +4.481817636e-02f, +1.172523462e-02f, -1.506905241e-02f, +8.222075097e-03f, -7.926982130e-04f, -3.152600929e-03f, +3.346254437e-03f, -1.643660931e-03f, +1.908369435e-05f, +6.393922793e-04f, -5.212915553e-04f, +1.956060614e-04f, -1.415420956e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +1.390674038e-04f, -2.881546255e-04f, +1.108215697e-05f, +8.584724805e-04f, -2.033968415e-03f, +2.592356683e-03f, -1.512562408e-03f, -1.360552734e-03f, +4.736405719e-03f, -6.409743387e-03f, +4.767846119e-03f, -1.817750317e-04f, -4.932384095e-03f, +7.620921646e-03f, -6.403190573e-03f, +2.244493509e-03f, +2.234604561e-03f, -4.627719115e-03f, +4.221133037e-03f, -2.074485332e-03f, -9.716869297e-05f, +1.181025763e-03f, -1.139333276e-03f, +5.998780408e-04f, -1.572390982e-04f, +1.415420956e-05f, +0.000000000e+00f,
        /* 13, 5 (28) */
        +0.000000000e+00f, -3.202169048e-04f, +2.129727641e-03f, -4.112224629e-03f, +2.739871266e-03f, +5.152486053e-03f, -1.726290219e-02f, +2.312522763e-02f, -8.908000598e-03f, -3.056877606e-02f, +8.006742169e-02f, -1.005430454e-01f, +2.236721218e-02f, +6.747865303e-01f, +4.595424386e-01f, -1.264767102e-01f, -4.722343086e-03f, +5.324355284e-02f, -4.785381628e-02f, +1.990272232e-02f, +4.221053770e-03f, -1.311409408e-02f, +9.767838289e-03f, -2.962266448e-03f, -1.125685643e-03f, +1.631560804e-03f, -6.695906781e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.202169048e-04f, -1.918624945e-03f, +5.416616831e-03f, -7.676451653e-03f, +4.038991121e-03f, +7.584216193e-03f, -2.245277399e-02f, +2.973918849e-02f, -1.981086074e-02f, -6.731852026e-03f, +3.633267766e-02f, -5.016944686e-02f, +3.757987526e-02f, -4.720774802e-03f, -2.901868932e-02f, +4.447708860e-02f, -3.555682216e-02f, +1.174308377e-02f, +1.057189789e-02f, -2.002957497e-02f, +1.622983925e-02f, -6.663037720e-03f, -8.188726058e-04f, +3.209042699e-03f, -2.185729466e-03f, +6.695906781e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.159457178e-04f, +2.700381581e-05f, +4.138969444e-04f, -1.091134819e-03f, +1.321239558e-03f, -1.605705936e-04f, -2.626592117e-03f, +5.568858352e-03f, -5.494630734e-03f, -9.410357382e-04f, +1.494955508e-02f, -3.366980638e-02f, -2.710907243e-02f, +4.310616097e-02f, +1.552618908e-02f, -1.584743849e-02f, +7.460099495e-03f, +2.227598241e-04f, -3.739083112e-03f, +3.416075681e-03f, -1.436860562e-03f, -2.011438953e-04f, +7.505815936e-04f, -5.359005839e-04f, +1.740011755e-04f, +3.688234506e-06f, +0.000000000e+00f,
        +0.000000000e+00f, +1.159457178e-04f, -2.151101387e-04f, -1.196554268e-04f, +9.921253878e-04f, -2.036820231e-03f, +2.321918514e-03f, -9.517271008e-04f, -2.007038392e-03f, +5.096244218e-03f, -6.161245796e-03f, +3.888640644e-03f, +9.676724522e-04f, -5.787385887e-03f, +7.752329968e-03f, -5.781990990e-03f, +1.242668571e-03f, +3.098288579e-03f, -5.003735911e-03f, +4.089051516e-03f, -1.669624549e-03f, -4.909564591e-04f, +1.403187127e-03f, -1.189303245e-03f, +5.626427737e-04f, -1.106214155e-04f, -3.688234506e-06f, +0.000000000e+00f,
        /* 13, 6 (28) */
        +0.000000000e+00f, -4.361626226e-04f, +2.156731457e-03f, -3.698327685e-03f, +1.648736446e-03f, +6.473725611e-03f, -1.742347279e-02f, +2.049863551e-02f, -3.339142246e-03f, -3.606340680e-02f, +7.912638596e-02f, -8.559349027e-02f, -1.130259419e-02f, +6.476774578e-01f, +5.026485996e-01f, -1.109505211e-01f, -2.056978157e-02f, +6.070365234e-02f, -4.763105645e-02f, +1.616363921e-02f, +7.637129450e-03f, -1.455095464e-02f, +9.566694394e-03f, -2.211684854e-03f, -1.661586227e-03f, +1.805561979e-03f, -6.659024436e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +4.361626226e-04f, -2.133735084e-03f, +5.296961404e-03f, -6.684326265e-03f, +2.002170890e-03f, +9.906134708e-03f, -2.340450109e-02f, +2.773215010e-02f, -1.471461652e-02f, -1.289309782e-02f, +4.022131830e-02f, -4.920177441e-02f, +3.179248938e-02f, +3.031555166e-03f, -3.480068031e-02f, +4.571975717e-02f, -3.245853358e-02f, +6.739347862e-03f, +1.466094940e-02f, -2.169919952e-02f, +1.573888279e-02f, -5.259850593e-03f, -2.008175851e-03f, +3.771685472e-03f, -2.296350881e-03f, +6.659024436e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -9.217229433e-05f, -2.402575133e-05f, +4.660393219e-04f, -1.061063814e-03f, +1.112308476e-03f, +2.171001174e-04f, -2.939520943e-03f, +5.392058972e-03f, -4.490301623e-03f, -2.548764852e-03f, +1.583018857e-02f, -3.035086850e-02f, -3.118989610e-02f, +4.086180709e-02f, +1.934736771e-02f, -1.633652447e-02f, +6.498882346e-03f, +1.280534103e-03f, -4.270081492e-03f, +3.412927864e-03f, -1.186765894e-03f, -4.294267254e-04f, +8.513438530e-04f, -5.384912864e-04f, +1.457635800e-04f, +2.368211550e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +9.217229433e-05f, -1.422747106e-04f, -2.389635186e-04f, +1.094779161e-03f, -1.991301498e-03f, +2.006959355e-03f, -3.857302377e-04f, -2.590960759e-03f, +5.330988405e-03f, -5.773830893e-03f, +2.928431315e-03f, +2.088011086e-03f, -6.506848761e-03f, +7.703847455e-03f, -5.021435586e-03f, +1.999524968e-04f, +3.903340830e-03f, -5.269401320e-03f, +3.855799559e-03f, -1.211016291e-03f, -8.886549225e-04f, +1.601207351e-03f, -1.211653197e-03f, +5.073968242e-04f, -5.623002535e-05f, -2.368211550e-05f, +0.000000000e+00f,
        /* 13, 7 (28) */
        +0.000000000e+00f, -5.283349169e-04f, +2.132705706e-03f, -3.232288363e-03f, +5.876726322e-04f, +7.586034087e-03f, -1.720637267e-02f, +1.755911457e-02f, +2.052916726e-03f, -4.055370842e-02f, +7.657762110e-02f, -6.976330170e-02f, -4.165346269e-02f, +6.164875617e-01f, +5.435104067e-01f, -9.160315340e-02f, -3.690630604e-02f, +6.720253469e-02f, -4.635052235e-02f, +1.189355772e-02f, +1.105005731e-02f, -1.573772054e-02f, +9.137267669e-03f, -1.360341001e-03f, -2.200077514e-03f, +1.951325559e-03f, -6.422203281e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.283349169e-04f, -2.276009794e-03f, +5.057997886e-03f, -5.589547104e-03f, +1.086939211e-05f, +1.191309406e-02f, -2.379023133e-02f, +2.514118934e-02f, -9.383628118e-03f, -1.866692872e-02f, +4.314974961e-02f, -4.711376332e-02f, +2.528564062e-02f, +1.073540262e-02f, -3.982211590e-02f, +4.591970966e-02f, -2.855519275e-02f, +1.469946542e-03f, +1.851674896e-02f, -2.291021581e-02f, +1.485022786e-02f, -3.658643241e-03f, -3.219829048e-03f, +4.279082297e-03f, -2.352580907e-03f, +6.422203281e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -6.845289247e-05f, -7.030581238e-05f, +5.040940874e-04f, -1.009413122e-03f, +8.903382910e-04f, +5.717771793e-04f, -3.175655060e-03f, +5.109342206e-03f, -3.437278311e-03f, -4.025956514e-03f, +1.634683201e-02f, -2.681858927e-02f, -3.487042737e-02f, +3.810672767e-02f, +2.313110144e-02f, -1.651016365e-02f, +5.349129903e-03f, +2.359535620e-03f, -4.731298783e-03f, +3.333402192e-03f, -8.968749533e-04f, -6.608952906e-04f, +9.386005109e-04f, -5.281167619e-04f, +1.110743340e-04f, +4.543251870e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +6.845289247e-05f, -7.162659364e-05f, -3.444985434e-04f, +1.165502340e-03f, -1.900606213e-03f, +1.656607659e-03f, +1.718753448e-04f, -3.100104401e-03f, +5.437565358e-03f, -5.258628319e-03f, +1.910540740e-03f, +3.153157097e-03f, -7.074106047e-03f, +7.476131947e-03f, -4.138490324e-03f, -8.594193102e-04f, +4.629635718e-03f, -5.416009303e-03f, +3.524335977e-03f, -7.081401769e-04f, -1.280526142e-03f, +1.768906421e-03f, -1.204215716e-03f, +4.344170456e-04f, +4.944518787e-06f, -4.543251870e-05f, +0.000000000e+00f,
        /* 13, 8 (28) */
        +0.000000000e+00f, -5.967878094e-04f, +2.062399893e-03f, -2.728194276e-03f, -4.217404900e-04f, +8.476372378e-03f, -1.663459549e-02f, +1.438345951e-02f, +7.162258932e-03f, -4.399098673e-02f, +7.255166459e-02f, -5.341646969e-02f, -6.847205196e-02f, +5.816171343e-01f, +5.816171343e-01f, -6.847205196e-02f, -5.341646969e-02f, +7.255166459e-02f, -4.399098673e-02f, +7.162258932e-03f, +1.438345951e-02f, -1.663459549e-02f, +8.476372378e-03f, -4.217404900e-04f, -2.728194276e-03f, +2.062399893e-03f, -5.967878094e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.967878094e-04f, -2.347636388e-03f, +4.713499342e-03f, -4.424044764e-03f, -1.889736821e-03f, +1.356970172e-02f, -2.361835599e-02f, +2.204108494e-02f, -3.946062761e-03f, -2.392555703e-02f, +4.506029035e-02f, -4.396060622e-02f, +1.821153457e-02f, +1.821153457e-02f, -4.396060622e-02f, +4.506029035e-02f, -2.392555703e-02f, -3.946062761e-03f, +2.204108494e-02f, -2.361835599e-02f, +1.356970172e-02f, -1.889736821e-03f, -4.424044764e-03f, +4.713499342e-03f, -2.347636388e-03f, +5.967878094e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -4.543251870e-05f, -1.110743340e-04f, +5.281167619e-04f, -9.386005109e-04f, +6.608952906e-04f, +8.968749533e-04f, -3.333402192e-03f, +4.731298783e-03f, -2.359535620e-03f, -5.349129903e-03f, +1.651016365e-02f, -2.313110144e-02f, -3.810672767e-02f, +3.487042737e-02f, +2.681858927e-02f, -1.634683201e-02f, +4.025956514e-03f, +3.437278311e-03f, -5.109342206e-03f, +3.175655060e-03f, -5.717771793e-04f, -8.903382910e-04f, +1.009413122e-03f, -5.040940874e-04f, +7.030581238e-05f, +6.845289247e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.543251870e-05f, -4.944518787e-06f, -4.344170456e-04f, +1.204215716e-03f, -1.768906421e-03f, +1.280526142e-03f, +7.081401769e-04f, -3.524335977e-03f, +5.416009303e-03f, -4.629635718e-03f, +8.594193102e-04f, +4.138490324e-03f, -7.476131947e-03f, +7.074106047e-03f, -3.153157097e-03f, -1.910540740e-03f, +5.258628319e-03f, -5.437565358e-03f, +3.100104401e-03f, -1.718753448e-04f, -1.656607659e-03f, +1.900606213e-03f, -1.165502340e-03f, +3.444985434e-04f, +7.162659364e-05f, -6.845289247e-05f, +0.000000000e+00f,
        /* 13, 9 (28) */
        +0.000000000e+00f, -6.422203281e-04f, +1.951325559e-03f, -2.200077514e-03f, -1.360341001e-03f, +9.137267669e-03f, -1.573772054e-02f, +1.105005731e-02f, +1.189355772e-02f, -4.635052235e-02f, +6.720253469e-02f, -3.690630604e-02f, -9.160315340e-02f, +5.435104067e-01f, +6.164875617e-01f, -4.165346269e-02f, -6.976330170e-02f, +7.657762110e-02f, -4.055370842e-02f, +2.052916726e-03f, +1.755911457e-02f, -1.720637267e-02f, +7.586034087e-03f, +5.876726322e-04f, -3.232288363e-03f, +2.132705706e-03f, -5.283349169e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +6.422203281e-04f, -2.352580907e-03f, +4.279082297e-03f, -3.219829048e-03f, -3.658643241e-03f, +1.485022786e-02f, -2.291021581e-02f, +1.851674896e-02f, +1.469946542e-03f, -2.855519275e-02f, +4.591970966e-02f, -3.982211590e-02f, +1.073540262e-02f, +2.528564062e-02f, -4.711376332e-02f, +4.314974961e-02f, -1.866692872e-02f, -9.383628118e-03f, +2.514118934e-02f, -2.379023133e-02f, +1.191309406e-02f, +1.086939211e-05f, -5.589547104e-03f, +5.057997886e-03f, -2.276009794e-03f, +5.283349169e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -2.368211550e-05f, -1.457635800e-04f, +5.384912864e-04f, -8.513438530e-04f, +4.294267254e-04f, +1.186765894e-03f, -3.412927864e-03f, +4.270081492e-03f, -1.280534103e-03f, -6.498882346e-03f, +1.633652447e-02f, -1.934736771e-02f, -4.086180709e-02f, +3.118989610e-02f, +3.035086850e-02f, -1.583018857e-02f, +2.548764852e-03f, +4.490301623e-03f, -5.392058972e-03f, +2.939520943e-03f, -2.171001174e-04f, -1.112308476e-03f, +1.061063814e-03f, -4.660393219e-04f, +2.402575133e-05f, +9.217229433e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +2.368211550e-05f, +5.623002535e-05f, -5.073968242e-04f, +1.211653197e-03f, -1.601207351e-03f, +8.886549225e-04f, +1.211016291e-03f, -3.855799559e-03f, +5.269401320e-03f, -3.903340830e-03f, -1.999524968e-04f, +5.021435586e-03f, -7.703847455e-03f, +6.506848761e-03f, -2.088011086e-03f, -2.928431315e-03f, +5.773830893e-03f, -5.330988405e-03f, +2.590960759e-03f, +3.857302377e-04f, -2.006959355e-03f, +1.991301498e-03f, -1.094779161e-03f, +2.389635186e-04f, +1.422747106e-04f, -9.217229433e-05f, +0.000000000e+00f,
        /* 13,10 (28) */
        +0.000000000e+00f, -6.659024436e-04f, +1.805561979e-03f, -1.661586227e-03f, -2.211684854e-03f, +9.566694394e-03f, -1.455095464e-02f, +7.637129450e-03f, +1.616363921e-02f, -4.763105645e-02f, +6.070365234e-02f, -2.056978157e-02f, -1.109505211e-01f, +5.026485996e-01f, +6.476774578e-01f, -1.130259419e-02f, -8.559349027e-02f, +7.912638596e-02f, -3.606340680e-02f, -3.339142246e-03f, +2.049863551e-02f, -1.742347279e-02f, +6.473725611e-03f, +1.648736446e-03f, -3.698327685e-03f, +2.156731457e-03f, -4.361626226e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +6.659024436e-04f, -2.296350881e-03f, +3.771685472e-03f, -2.008175851e-03f, -5.259850593e-03f, +1.573888279e-02f, -2.169919952e-02f, +1.466094940e-02f, +6.739347862e-03f, -3.245853358e-02f, +4.571975717e-02f, -3.480068031e-02f, +3.031555166e-03f, +3.179248938e-02f, -4.920177441e-02f, +4.022131830e-02f, -1.289309782e-02f, -1.471461652e-02f, +2.773215010e-02f, -2.340450109e-02f, +9.906134708e-03f, +2.002170890e-03f, -6.684326265e-03f, +5.296961404e-03f, -2.133735084e-03f, +4.361626226e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -3.688234506e-06f, -1.740011755e-04f, +5.359005839e-04f, -7.505815936e-04f, +2.011438953e-04f, +1.436860562e-03f, -3.416075681e-03f, +3.739083112e-03f, -2.227598241e-04f, -7.460099495e-03f, +1.584743849e-02f, -1.552618908e-02f, -4.310616097e-02f, +2.710907243e-02f, +3.366980638e-02f, -1.494955508e-02f, +9.410357382e-04f, +5.494630734e-03f, -5.568858352e-03f, +2.626592117e-03f, +1.605705936e-04f, -1.321239558e-03f, +1.091134819e-03f, -4.138969444e-04f, -2.700381581e-05f, +1.159457178e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +3.688234506e-06f, +1.106214155e-04f, -5.626427737e-04f, +1.189303245e-03f, -1.403187127e-03f, +4.909564591e-04f, +1.669624549e-03f, -4.089051516e-03f, +5.003735911e-03f, -3.098288579e-03f, -1.242668571e-03f, +5.781990990e-03f, -7.752329968e-03f, +5.787385887e-03f, -9.676724522e-04f, -3.888640644e-03f, +6.161245796e-03f, -5.096244218e-03f, +2.007038392e-03f, +9.517271008e-04f, -2.321918514e-03f, +2.036820231e-03f, -9.921253878e-04f, +1.196554268e-04f, +2.151101387e-04f, -1.159457178e-04f, +0.000000000e+00f,
        /* 13,11 (28) */
        +0.000000000e+00f, -6.695906781e-04f, +1.631560804e-03f, -1.125685643e-03f, -2.962266448e-03f, +9.767838289e-03f, -1.311409408e-02f, +4.221053770e-03f, +1.990272232e-02f, -4.785381628e-02f, +5.324355284e-02f, -4.722343086e-03f, -1.264767102e-01f, +4.595424386e-01f, +6.747865303e-01f, +2.236721218e-02f, -1.005430454e-01f, +8.006742169e-02f, -3.056877606e-02f, -8.908000598e-03f, +2.312522763e-02f, -1.726290219e-02f, +5.152486053e-03f, +2.739871266e-03f, -4.112224629e-03f, +2.129727641e-03f, -3.202169048e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +6.695906781e-04f, -2.185729466e-03f, +3.209042699e-03f, -8.188726058e-04f, -6.663037720e-03f, +1.622983925e-02f, -2.002957497e-02f, +1.057189789e-02f, +1.174308377e-02f, -3.555682216e-02f, +4.447708860e-02f, -2.901868932e-02f, -4.720774802e-03f, +3.757987526e-02f, -5.016944686e-02f, +3.633267766e-02f, -6.731852026e-03f, -1.981086074e-02f, +2.973918849e-02f, -2.245277399e-02f, +7.584216193e-03f, +4.038991121e-03f, -7.676451653e-03f, +5.416616831e-03f, -1.918624945e-03f, +3.202169048e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +1.415420956e-05f, -1.956060614e-04f, +5.212915553e-04f, -6.393922793e-04f, -1.908369435e-05f, +1.643660931e-03f, -3.346254437e-03f, +3.152600929e-03f, +7.926982130e-04f, -8.222075097e-03f, +1.506905241e-02f, -1.172523462e-02f, -4.481817636e-02f, +2.267818574e-02f, +3.671909523e-02f, -1.370030407e-02f, -7.699711255e-04f, +6.426266076e-03f, -5.631012677e-03f, +2.240262009e-03f, +5.537972797e-04f, -1.511571924e-03f, +1.097585037e-03f, -3.479626316e-04f, -8.183303216e-05f, +1.390674038e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -1.415420956e-05f, +1.572390982e-04f, -5.998780408e-04f, +1.139333276e-03f, -1.181025763e-03f, +9.716869297e-05f, +2.074485332e-03f, -4.221133037e-03f, +4.627719115e-03f, -2.234604561e-03f, -2.244493509e-03f, +6.403190573e-03f, -7.620921646e-03f, +4.932384095e-03f, +1.817750317e-04f, -4.767846119e-03f, +6.409743387e-03f, -4.736405719e-03f, +1.360552734e-03f, +1.512562408e-03f, -2.592356683e-03f, +2.033968415e-03f, -8.584724805e-04f, -1.108215697e-05f, +2.881546255e-04f, -1.390674038e-04f, +0.000000000e+00f,
        /* 13,12 (28) */
        +0.000000000e+00f, -6.554364686e-04f, +1.435954742e-03f, -6.043940881e-04f, -3.601658727e-03f, +9.748754595e-03f, -1.147043315e-02f, +8.747993327e-04f, +2.305532325e-02f, -4.706111806e-02f, +4.502147775e-02f, +1.034670932e-02f, -1.382019448e-01f, +4.147242623e-01f, +6.974647160e-01f, +5.908630741e-02f, -1.142433494e-01f, +7.929745057e-02f, -2.414250999e-02f, -1.453901327e-02f, +2.536548964e-02f, -1.670910491e-02f, +3.640914129e-03f, +3.837456302e-03f, -4.460187261e-03f, +2.047894609e-03f, -1.811495010e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +6.554364686e-04f, -2.028490368e-03f, +2.609164658e-03f, +3.204606698e-04f, -7.844063483e-03f, +1.632700794e-02f, -1.795508964e-02f, +6.350764850e-03f, +1.637080289e-02f, -3.779142672e-02f, +4.223259509e-02f, -2.261549875e-02f, -1.234169645e-02f, +4.251225936e-02f, -4.998767183e-02f, +3.156483154e-02f, -3.221086391e-04f, -2.454726646e-02f, +3.109974122e-02f, -2.094021158e-02f, +4.991859510e-03f, +6.072959535e-03f, -8.534924134e-03f, +5.405534674e-03f, -1.630470320e-03f, +1.811495010e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +2.954609909e-05f, -2.105797540e-04f, +4.958356864e-04f, -5.209151047e-04f, -2.268211904e-04f, +1.804786949e-03f, -3.208295884e-03f, +2.525495492e-03f, +1.746525657e-03f, -8.778540869e-03f, +1.403150726e-02f, -8.000109621e-03f, -4.598440199e-02f, +1.795298817e-02f, +3.944523309e-02f, -1.208414541e-02f, -2.553602345e-03f, +7.261692841e-03f, -5.571929816e-03f, +1.785729637e-03f, +9.544210337e-04f, -1.677884550e-03f, +1.078821552e-03f, -2.688983937e-04f, -1.393362692e-04f, +1.607869473e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -2.954609909e-05f, +1.953873470e-04f, -6.193214927e-04f, +1.064499817e-03f, -9.412283131e-04f, -2.834276143e-04f, +2.417707849e-03f, -4.251579924e-03f, +4.152504418e-03f, -1.333487281e-03f, -3.182436308e-03f, +6.871490347e-03f, -7.313234093e-03f, +3.961756046e-03f, +1.333404387e-03f, -5.544428988e-03f, +6.511374719e-03f, -4.257637282e-03f, +6.655491105e-04f, +2.054402099e-03f, -2.809931649e-03f, +1.980655016e-03f, -6.956218532e-04f, -1.504421647e-04f, +3.592765960e-04f, -1.607869473e-04f, +0.000000000e+00f,
        /* 13,13 (28) */
        +0.000000000e+00f, -6.258903695e-04f, +1.225374988e-03f, -1.085584017e-04f, -4.122573832e-03f, +9.521933405e-03f, -9.665646201e-03f, -2.333496551e-03f, +2.558081874e-02f, -4.531459241e-02f, +3.624293688e-02f, +2.437821658e-02f, -1.462020544e-01f, +3.687398603e-01f, +7.154177042e-01f, +9.853154051e-02f, -1.263274948e-01f, +7.674384822e-02f, -1.688081714e-02f, -2.011094309e-02f, +2.715121927e-02f, -1.575468388e-02f, +1.963029579e-03f, +4.916277854e-03f, -4.729085655e-03f, +1.908558340e-03f, -2.036255371e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +6.258903695e-04f, -1.833103021e-03f, +1.989843165e-03f, +1.384960487e-03f, -8.785291796e-03f, +1.604358032e-02f, -1.553738179e-02f, +2.099184926e-03f, +2.052330731e-02f, -3.912491400e-02f, +3.905015878e-02f, -1.574400840e-02f, -1.965493054e-02f, +4.647401540e-02f, -4.865426744e-02f, +2.602040255e-02f, +6.189266080e-03f, -2.880490374e-02f, +3.176529033e-02f, -1.888580949e-02f, +2.181927861e-03f, +8.053614551e-03f, -9.230545987e-03f, +5.255092509e-03f, -1.271193724e-03f, +2.036255371e-05f, +0.000000000e+00f,
        +0.000000000e+00f, +4.228526908e-05f, -2.190934259e-04f, +4.608864859e-04f, -3.982733156e-04f, -4.181467393e-04f, +1.918976945e-03f, -3.008287473e-03f, +1.872851108e-03f, +2.621509266e-03f, -9.127608772e-03f, +1.276825545e-02f, -4.403478335e-03f, -4.659967790e-02f, +1.299388970e-02f, +4.179847175e-02f, -1.010930366e-02f, -4.376276951e-03f, +7.978400491e-03f, -5.387389999e-03f, +1.269963427e-03f, +1.353715321e-03f, -1.815030251e-03f, +1.033764080e-03f, -1.777392293e-04f, -1.982297826e-04f, +1.803279158e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -4.228526908e-05f, +2.246658194e-04f, -6.216528191e-04f, +9.680474561e-04f, -6.904469727e-04f, -6.422219079e-04f, +2.693134488e-03f, -4.182370935e-03f, +3.591374182e-03f, -4.166820726e-04f, -4.035287579e-03f, +7.177068805e-03f, -6.837049515e-03f, +2.898186105e-03f, +2.460089821e-03f, -6.199014336e-03f, +6.461610334e-03f, -3.669102029e-03f, -6.240126125e-05f, +2.563469441e-03f, -2.967327785e-03f, +1.875992812e-03f, -5.062396848e-04f, -2.952059116e-04f, +4.262449191e-04f, -1.803279158e-04f, +0.000000000e+00f,
        /* 13,14 (28) */
        +0.000000000e+00f, -5.836051004e-04f, +1.006281562e-03f, +3.523280842e-04f, -4.520847147e-03f, +9.103786665e-03f, -7.746669256e-03f, -5.341784024e-03f, +2.745366985e-02f, -4.269308314e-02f, +2.711532811e-02f, +3.714647203e-02f, -1.506055328e-01f, +3.221401824e-01f, +7.284115939e-01f, +1.403300123e-01f, -1.364367985e-01f, +7.236757127e-02f, -8.902416653e-03f, -2.549833309e-02f, +2.842118270e-02f, -1.440096856e-02f, +1.479993283e-04f, +5.950041934e-03f, -4.906824884e-03f, +1.710328557e-03f, +1.599653621e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.836051004e-04f, -1.608437201e-03f, +1.368190346e-03f, +2.353007943e-03f, -9.475738768e-03f, +1.540135842e-02f, -1.284424730e-02f, -2.083186010e-03f, +2.411468149e-02f, -3.954159608e-02f, +3.501487120e-02f, -8.566939598e-03f, -2.649198006e-02f, +4.937220151e-02f, -4.619417762e-02f, +1.982138821e-02f, +1.265087641e-02f, -3.247400577e-02f, +3.170288907e-02f, -1.632234004e-02f, -7.853999246e-04f, +9.929607362e-03f, -9.736785672e-03f, +4.959886598e-03f, -8.449488044e-04f, -1.599653621e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.226481803e-05f, -2.214714011e-04f, +4.179349901e-04f, -2.745021427e-04f, -5.897142049e-04f, +1.986063008e-03f, -2.753384771e-03f, +1.209645266e-03f, +3.402807360e-03f, -9.271629637e-03f, +1.131533751e-02f, -9.842563057e-04f, -4.666712344e-02f, +7.865011088e-03f, +4.373371457e-02f, -7.790580130e-03f, -6.202026669e-03f, +8.555401689e-03f, -5.075740404e-03f, +7.016235217e-04f, +1.742559828e-03f, -1.918271183e-03f, +9.619003544e-04f, -7.589063730e-05f, -2.570948466e-04f, +1.969086049e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -5.226481803e-05f, +2.449614229e-04f, -6.079668797e-04f, +8.535997808e-04f, -4.353067917e-04f, -9.714624842e-04f, +2.896437912e-03f, -4.017817410e-03f, +2.959375512e-03f, +4.940500910e-04f, -4.784107531e-03f, +7.314035106e-03f, -6.204121044e-03f, +1.766588182e-03f, +3.535159361e-03f, -6.714961298e-03f, +6.259498197e-03f, -2.982793047e-03f, -8.065505564e-04f, +3.026391735e-03f, -3.058478095e-03f, +1.720371530e-03f, -2.938279412e-04f, -4.418095209e-04f, +4.867890496e-04f, -1.969086049e-04f, +0.000000000e+00f,
        /* 13,15 (28) */
        +0.000000000e+00f, -5.313402824e-04f, +7.848101613e-04f, +7.702630743e-04f, -4.795349290e-03f, +8.514072460e-03f, -5.760606248e-03f, -8.095168796e-03f, +2.866331511e-02f, -3.929027578e-02f, +1.784369847e-02f, +4.846180954e-02f, -1.515897891e-01f, +2.754730589e-01f, +7.362766049e-01f, +1.840637268e-01f, -1.442273786e-01f, +6.616554460e-02f, -3.470149638e-04f, -3.057407349e-02f, +2.912280622e-02f, -1.265840873e-02f, -1.770271855e-03f, +6.911942288e-03f, -4.982715521e-03f, +1.453233711e-03f, +3.568739670e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.313402824e-04f, -1.363475778e-03f, +7.602234664e-04f, +3.206607724e-03f, -9.911045560e-03f, +1.442989593e-02f, -9.947809388e-03f, -6.101003420e-03f, +2.707405700e-02f, -3.904754599e-02f, +3.023076367e-02f, -1.252904492e-03f, -3.269610110e-02f, +5.113878969e-02f, -4.265901826e-02f, +1.310642691e-02f, +1.891037461e-02f, -3.545679882e-02f, +3.089633852e-02f, -1.329594831e-02f, -3.843878019e-03f, +1.164997889e-02f, -1.003061361e-02f, +4.518077077e-03f, -3.581597548e-04f, -3.568739670e-04f, +0.000000000e+00f,
        +0.000000000e+00f, +5.946880494e-05f, -2.181717207e-04f, +3.685645521e-04f, -1.524827524e-04f, -7.387995536e-04f, +2.006923010e-03f, -2.451608517e-03f, +5.504337213e-04f, +4.078160698e-03f, -9.216973673e-03f, +9.710633196e-03f, +2.213114486e-03f, -4.619798494e-02f, +2.633171509e-03f, +4.521134714e-02f, -5.149295958e-03f, -7.993101867e-03f, +8.973739761e-03f, -4.638041588e-03f, +9.094261349e-05f, +2.111631419e-03f, -1.983411383e-03f, +8.633306184e-04f, +3.488347878e-05f, -3.144060840e-04f, +2.097644736e-04f, +0.000000000e+00f,
        +0.000000000e+00f, -5.946880494e-05f, +2.564322231e-04f, -5.797191266e-04f, +7.250456053e-04f, -1.822393881e-04f, -1.264416787e-03f, +3.025169814e-03f, -3.764398369e-03f, +2.272920446e-03f, +1.377455760e-03f, -5.412653288e-03f, +7.280540492e-03f, -5.429877442e-03f, +5.935089525e-04f, +4.533039716e-03f, -7.078790914e-03f, +5.907735770e-03f, -2.213291408e-03f, -1.549361071e-03f, +3.430546520e-03f, -3.078761555e-03f, +1.515500253e-03f, -6.267133557e-05f, -5.864237478e-04f, +5.386640945e-04f, -2.097644736e-04f, +0.000000000e+00f,
        /* 14, 0 (24) */
        +1.319331966e-03f, -1.016178713e-03f, -2.318012042e-03f, +9.411795907e-03f, -1.746941689e-02f, +1.934834705e-02f, -5.865137636e-03f, -2.904336543e-02f, +8.299055312e-02f, -1.433490386e-01f, +1.911490954e-01f, +7.906420751e-01f, +1.911490954e-01f, -1.433490386e-01f, +8.299055312e-02f, -2.904336543e-02f, -5.865137636e-03f, +1.934834705e-02f, -1.746941689e-02f, +9.411795907e-03f, -2.318012042e-03f, -1.016178713e-03f, +1.319331966e-03f, -5.404051147e-04f,
        -2.521351164e-03f, +4.422857262e-03f, -3.985881589e-03f, -1.343441160e-03f, +1.186209570e-02f, -2.390185965e-02f, +3.059439799e-02f, -2.544922973e-02f, +6.875499987e-03f, +1.945720767e-02f, -4.255924117e-02f, +5.173229864e-02f, -4.255924117e-02f, +1.945720767e-02f, +6.875499987e-03f, -2.544922973e-02f, +3.059439799e-02f, -2.390185965e-02f, +1.186209570e-02f, -1.343441160e-03f, -3.985881589e-03f, +4.422857262e-03f, -2.521351164e-03f, +7.211855688e-04f,
        -2.242580105e-04f, +5.515402691e-04f, -8.006592829e-04f, +4.679111297e-04f, +9.671301358e-04f, -3.521489134e-03f, +6.187402659e-03f, -6.760448353e-03f, +2.085366097e-03f, +1.222808687e-02f, -4.974438686e-02f, -3.226680462e-03f, +5.162786239e-02f, -9.493654979e-03f, -4.297979908e-03f, +7.839517914e-03f, -6.351081144e-03f, +3.213964647e-03f, -5.735612965e-04f, -7.425062231e-04f, +9.210389417e-04f, -5.725628529e-04f, +2.111545745e-04f, -3.826050238e-05f,
        +1.361148124e-04f, -6.078360122e-04f, +1.365871498e-03f, -2.021916039e-03f, +1.927534233e-03f, -5.492420567e-04f, -2.058145461e-03f, +5.025851749e-03f, -6.951055384e-03f, +6.618560623e-03f, -3.757759117e-03f, -6.671799512e-04f, +4.876258793e-03f, -7.186973906e-03f, +6.873936703e-03f, -4.460536991e-03f, +1.305886445e-03f, +1.201288539e-03f, -2.322748136e-03f, +2.158182611e-03f, -1.338999949e-03f, +5.283783837e-04f, -7.268521485e-05f, -3.959096234e-05f,
        /* 14, 1 (24) */
        +1.095073956e-03f, -4.646384443e-04f, -3.118671324e-03f, +9.879707037e-03f, -1.650228675e-02f, +1.582685791e-02f, +3.222650227e-04f, -3.580381378e-02f, +8.507591921e-02f, -1.311209517e-01f, +1.414047086e-01f, +7.874153946e-01f, +2.427769578e-01f, -1.528426936e-01f, +7.869257321e-02f, -2.120384752e-02f, -1.221621878e-02f, +2.256231169e-02f, -1.804297818e-02f, +8.669289684e-03f, -1.396973100e-03f, -1.588741566e-03f, +1.530486541e-03f, -5.786656170e-04f,
        -2.385236352e-03f, +3.815021250e-03f, -2.620010092e-03f, -3.365357199e-03f, +1.378962994e-02f, -2.445110171e-02f, +2.853625253e-02f, -2.042337798e-02f, -7.555539715e-05f, +2.607576830e-02f, -4.631700029e-02f, +5.106511869e-02f, -3.768298238e-02f, +1.227023377e-02f, +1.374943669e-02f, -2.990976672e-02f, +3.190028444e-02f, -2.270057111e-02f, +9.539347567e-03f, +8.147414509e-04f, -5.324881538e-03f, +4.951235646e-03f, -2.594036379e-03f, +6.815946065e-04f,
        -2.296942030e-04f, +5.177001582e-04f, -6.680724132e-04f, +1.978996535e-04f, +1.315918267e-03f, -3.728015257e-03f, +5.882290961e-03f, -5.572608642e-03f, -5.747152836e-05f, +1.450554143e-02f, -4.726887393e-02f, -9.631599269e-03f, +5.287124448e-02f, -6.329778800e-03f, -6.531229974e-03f, +8.777579547e-03f, -6.362182872e-03f, +2.808172144e-03f, -1.430531405e-04f, -1.014600524e-03f, +1.025020997e-03f, -5.790976380e-04f, +1.900318896e-04f, -2.349002182e-05f,
        +1.895983879e-04f, -6.647781197e-04f, +1.354460665e-03f, -1.838451667e-03f, +1.496872527e-03f, +9.670671648e-05f, -2.737850722e-03f, +5.449394323e-03f, -6.846417259e-03f, +5.883515895e-03f, -2.546845728e-03f, -1.983940869e-03f, +5.872327283e-03f, -7.572090831e-03f, +6.614500504e-03f, -3.765838378e-03f, +4.995911740e-04f, +1.841793810e-03f, -2.670171812e-03f, +2.241152524e-03f, -1.272400915e-03f, +4.272109316e-04f, -5.275240448e-07f, -7.300562037e-05f,
        /* 14, 2 (24) */
        +8.653797527e-04f, +5.306171384e-05f, -3.786743738e-03f, +1.007760669e-02f, -1.518636848e-02f, +1.209884266e-02f, +6.204555983e-03f, -4.137642242e-02f, +8.501844769e-02f, -1.166154103e-01f, +9.413583464e-02f, +7.777837954e-01f, +2.956482023e-01f, -1.591724724e-01f, +7.216134324e-02f, -1.242626797e-02f, -1.857840165e-02f, +2.537048384e-02f, -1.818603132e-02f, +7.654689160e-03f, -3.719521032e-04f, -2.167839204e-03f, +1.720518430e-03f, -6.021556389e-04f,
        -2.195637964e-03f, +3.150243130e-03f, -1.265549426e-03f, -5.203808866e-03f, +1.528650246e-02f, -2.435439499e-02f, +2.579840181e-02f, -1.497398365e-02f, -6.921972656e-03f, +3.195928419e-02f, -4.886384601e-02f, +4.908117782e-02f, -3.181065509e-02f, +4.698142935e-03f, +2.036393719e-02f, -3.367560509e-02f, +3.239987561e-02f, -2.085877730e-02f, +6.869175755e-03f, +3.055893975e-03f, -6.597282453e-03f, +5.378446577e-03f, -2.594563903e-03f, +6.085889861e-04f,
        -2.280151365e-04f, +4.729451409e-04f, -5.275243952e-04f, -6.096256087e-05f, +1.613612465e-03f, -3.833432868e-03f, +5.449791260e-03f, -4.309298463e-03f, -2.085333382e-03f, +1.630831799e-02f, -4.425856157e-02f, -1.589207580e-02f, +5.343672742e-02f, -2.773590470e-03f, -8.732967871e-03f, +9.544290844e-03f, -6.212883448e-03f, +2.309519827e-03f, +3.151529850e-04f, -1.276755037e-03f, +1.108593712e-03f, -5.697741405e-04f, +1.607663332e-04f, -5.572393499e-06f,
        +2.323296147e-04f, -6.991129623e-04f, +1.307215183e-03f, -1.614917439e-03f, +1.043612417e-03f, +7.196184886e-04f, -3.328879636e-03f, +5.722793198e-03f, -6.565411707e-03f, +5.002780468e-03f, -1.275853774e-03f, -3.248379155e-03f, +6.719086665e-03f, -7.762013897e-03f, +6.177097633e-03f, -2.957897070e-03f, -3.402831812e-04f, +2.452893712e-03f, -2.958341386e-03f, +2.265980518e-03f, -1.165729588e-03f, +3.058736760e-04f, +7.873939740e-05f, -1.082724704e-04f,
        /* 14, 3 (24) */
        +6.373646162e-04f, +5.260068547e-04f, -4.314268133e-03f, +1.001664413e-02f, -1.357275602e-02f, +8.265409788e-03f, +1.165434724e-02f, -4.568572089e-02f, +8.293311430e-02f, -1.003070923e-01f, +4.987727307e-02f, +7.618917196e-01f, +3.490849297e-01f, -1.619460628e-01f, +6.342837536e-02f, -2.881977125e-03f, -2.479128510e-02f, +2.768000367e-02f, -1.787087834e-02f, +6.377934123e-03f, +7.366416088e-04f, -2.737613345e-03f, +1.881284763e-03f, -6.077280324e-04f,
        -1.963308349e-03f, +2.451130168e-03f, +4.166575678e-05f, -6.818726304e-03f, +1.633011488e-02f, -2.363477650e-02f, +2.246952217e-02f, -9.251190455e-03f, -1.348738436e-02f, +3.696206466e-02f, -5.013969979e-02f, +4.583279867e-02f, -2.509156843e-02f, -3.063870962e-03f, +2.654103483e-02f, -3.663350216e-02f, +3.205959243e-02f, -1.840588359e-02f, +3.910834368e-03f, +5.321874493e-03f, -7.763012041e-03f, +5.684320253e-03f, -2.515824506e-03f, +5.003165157e-04f,
        -2.199403268e-04f, +4.193405584e-04f, -3.831996986e-04f, -3.027704652e-04f, +1.855510616e-03f, -3.840131736e-03f, +4.906380705e-03f, -3.004055559e-03f, -3.957772375e-03f, +1.762857440e-02f, -4.077863748e-02f, -2.191474422e-02f, +5.329763608e-02f, +1.128619274e-03f, -1.084907095e-02f, +1.011202815e-02f, -5.899030074e-03f, +1.726084432e-03f, +7.905880352e-04f, -1.521359334e-03f, +1.168049503e-03f, -5.435847123e-04f, +1.234858063e-04f, +1.519240704e-05f,
        +2.639103140e-04f, -7.114217783e-04f, +1.227463238e-03f, -1.359225931e-03f, +5.807375418e-04f, +1.303694875e-03f, -3.817883323e-03f, +5.841843140e-03f, -6.118043611e-03f, +4.000967587e-03f, +2.144504233e-05f, -4.427181083e-03f, +7.393538277e-03f, -7.749978225e-03f, +5.570939039e-03f, -2.056233880e-03f, -1.191860302e-03f, +3.016993660e-03f, -3.177030991e-03f, +2.229271926e-03f, -1.019810357e-03f, +1.666388914e-04f, +1.631210799e-04f, -1.441891318e-04f,
        /* 14, 4 (24) */
        +4.174242894e-04f, +9.453474131e-04f, -4.697467831e-03f, +9.713873664e-03f, -1.171724540e-02f, +4.425278052e-03f, +1.656072795e-02f, -4.868977645e-02f, +7.897534193e-02f, -8.267851789e-02f, +9.098635588e-03f, +7.399769753e-01f, +4.023825658e-01f, -1.608174436e-01f, +5.257930441e-02f, +7.230051025e-03f, -3.069031518e-02f, +2.940608810e-02f, -1.708029030e-02f, +4.856574789e-03f, +1.904691112e-03f, -3.281198057e-03f, +2.004770570e-03f, -5.925356253e-04f,
        -1.699398035e-03f, +1.739708389e-03f, +1.269128995e-03f, -8.177952236e-03f, +1.691085242e-02f, -2.233108163e-02f, +1.865163885e-02f, -3.409347315e-03f, -1.960542797e-02f, +4.096303225e-02f, -5.011825475e-02f, +4.140561758e-02f, -1.769803015e-02f, -1.081384919e-02f, +3.211197387e-02f, -3.868973605e-02f, +3.086773213e-02f, -1.538888993e-02f, +7.338033779e-04f, +7.551146419e-03f, -8.782822398e-03f, +5.850959145e-03f, -2.352703426e-03f, +3.561273839e-04f,
        -2.063215934e-04f, +3.590447885e-04f, -2.391125561e-04f, -5.223964905e-04f, +2.038559404e-03f, -3.752824417e-03f, +4.270459943e-03f, -1.689860357e-03f, -5.639772262e-03f, +1.846815019e-02f, -3.690087026e-02f, -2.761056983e-02f, +5.243909801e-02f, +5.322044051e-03f, -1.282455890e-02f, +1.045667966e-02f, -5.420417328e-03f, +1.068532108e-03f, +1.271769104e-03f, -1.740829624e-03f, +1.200109457e-03f, -4.999409963e-04f, +7.858648557e-05f, +3.836696312e-05f,
        +2.843338474e-04f, -7.028995985e-04f, +1.119271557e-03f, -1.079817832e-03f, +1.210024769e-04f, +1.834675153e-03f, -4.194580265e-03f, +5.806538111e-03f, -5.518597552e-03f, +2.905665496e-03f, +1.310758344e-03f, -5.489339666e-03f, +7.877199504e-03f, -7.534579195e-03f, +4.809909646e-03f, -1.083275426e-03f, -2.032417264e-03f, +3.517270216e-03f, -3.317589185e-03f, +2.129245120e-03f, -8.366734445e-04f, +1.248540587e-05f, +2.502874884e-04f, -1.794099129e-04f,
        /* 14, 5 (24) */
        +2.111026960e-04f, +1.304392202e-03f, -4.936580387e-03f, +9.191477174e-03f, -9.678686000e-03f, +6.724536350e-04f, +2.083118789e-02f, -5.037963680e-02f, +7.333556967e-02f, -6.421036770e-02f, -2.780223467e-02f, +7.123664055e-01f, +4.548216638e-01f, -1.554953995e-01f, +3.975474551e-02f, +1.768673068e-02f, -3.611073250e-02f, +3.047462021e-02f, -1.580852120e-02f, +3.115745165e-03f, +3.104800569e-03f, -3.781139053e-03f, +2.083357055e-03f, -5.541686622e-04f,
        -1.415064188e-03f, +1.036808791e-03f, +2.388400552e-03f, -9.257770068e-03f, +1.703185490e-02f, -2.049640647e-02f, +1.445705859e-02f, +2.397190796e-03f, -2.512402553e-02f, +4.386869774e-02f, -4.880749640e-02f, +3.591627792e-02f, -9.820830647e-03f, -1.834842838e-02f, +3.692188351e-02f, -3.977301147e-02f, +2.883531487e-02f, -1.187161971e-02f, -2.583785807e-03f, +9.680391539e-03f, -9.619495843e-03f, +5.863444550e-03f, -2.102415937e-03f, +1.767174710e-04f,
        -1.881063229e-04f, +2.942415176e-04f, -9.900943164e-05f, -7.155806731e-04f, +2.161347921e-03f, -3.578319218e-03f, +3.561819960e-03f, -3.983865162e-04f, -7.102281534e-03f, +1.883819573e-02f, -3.270213392e-02f, -3.289645832e-02f, +5.085849094e-02f, +9.744198089e-03f, -1.460476992e-02f, +1.055838807e-02f, -4.780976087e-03f, +3.499684045e-04f, +1.746451132e-03f, -1.927817022e-03f, +1.202043232e-03f, -4.387216515e-04f, +2.674218979e-05f, +6.337976002e-05f,
        +2.939567081e-04f, -6.752806722e-04f, +9.872889198e-04f, -7.854012498e-04f, -3.234111461e-04f, +2.300178650e-03f, -4.451958631e-03f, +5.620988892e-03f, -4.785190304e-03f, +1.746665795e-03f, +2.558198391e-03f, -6.406988049e-03f, +8.156619703e-03f, -7.119855075e-03f, +3.912250990e-03f, -6.379111213e-05f, -2.838994060e-03f, +3.938165215e-03f, -3.373241701e-03f, +1.965853133e-03f, -6.195565658e-04f, -1.529512225e-04f, +3.376273295e-04f, -2.124853822e-04f,
        /* 14, 6 (24) */
        +2.299637308e-05f, +1.598633719e-03f, -5.035589819e-03f, +8.475896501e-03f, -7.517338080e-03f, -2.905865583e-03f, +2.439300785e-02f, -5.077802332e-02f, +6.623328813e-02f, -4.537217197e-02f, -6.050436860e-02f, +6.794699472e-01f, +5.056801548e-01f, -1.457512014e-01f, +2.514997559e-02f, +2.824511876e-02f, -4.089170859e-02f, +3.082458861e-02f, -1.406207007e-02f, +1.187928143e-03f, +4.306843801e-03f, -4.219860705e-03f, +2.110099245e-03f, -4.907889022e-04f,
        -1.121107480e-03f, +3.615281186e-04f, +3.375689472e-03f, -1.004317132e-02f, +1.670844375e-02f, -1.819622782e-02f, +1.000509996e-02f, +8.018179688e-03f, -2.990921583e-02f, +4.561536354e-02f, -4.624929801e-02f, +2.950928987e-02f, -1.664210943e-03f, -2.546828346e-02f, +4.083413450e-02f, -3.983680258e-02f, +2.599632081e-02f, -7.933454500e-03f, -5.957027508e-03f, +1.164624467e-02f, -1.023905241e-02f, +5.710493328e-03f, -1.764788608e-03f, -3.576791121e-05f,
        -1.663004619e-04f, +2.270758033e-04f, +3.371534696e-05f, -8.789930218e-04f, +2.224059472e-03f, -3.325251180e-03f, +2.801098213e-03f, +8.406867828e-04f, -8.322595745e-03f, +1.875861989e-02f, -2.826285741e-02f, -3.769674486e-02f, +4.856565455e-02f, +1.432593212e-02f, -1.613657197e-02f, +1.040222318e-02f, -3.988867217e-03f, -4.142819333e-04f, +2.201911573e-03f, -2.075420816e-03f, +1.171780626e-03f, -3.603093442e-04f, -3.109446220e-05f, +8.953355461e-05f,
        +2.934599765e-04f, -6.307516765e-04f, +8.365804647e-04f, -4.846945877e-04f, -7.412100054e-04f, +2.689984773e-03f, -4.586383843e-03f, +5.293229868e-03f, -3.939225526e-03f, +5.551395866e-04f, +3.731191371e-03f, -7.156146625e-03f, +8.223760593e-03f, -6.515221178e-03f, +2.900119811e-03f, +9.757447888e-04f, -3.589023653e-03f, +4.265858037e-03f, -3.339350534e-03f, +1.740859169e-03f, -3.728699214e-04f, -3.254523762e-04f, +4.223156568e-04f, -2.419088112e-04f,
        /* 14, 7 (24) */
        -1.433040888e-04f, +1.825709523e-03f, -5.001874472e-03f, +7.596903479e-03f, -5.293278608e-03f, -6.231116763e-03f, +2.719410607e-02f, -4.993733654e-02f, +5.791069239e-02f, -2.661355209e-02f, -8.876722601e-02f, +6.417732023e-01f, +5.542458093e-01f, -1.314252693e-01f, +9.013403621e-03f, +3.864734193e-02f, -4.488057581e-02f, +3.041030668e-02f, -1.186015849e-02f, -8.874926734e-04f, +5.478624427e-03f, -4.580170049e-03f, +2.079004783e-03f, -4.012553476e-04f,
        -8.276475031e-04f, -2.692235579e-04f, +4.212269937e-03f, -1.052786591e-02f, +1.596723375e-02f, -1.550624305e-02f, +5.418716112e-03f, +1.331140956e-02f, -3.384844136e-02f, +4.617050312e-02f, -4.251810664e-02f, +2.235314324e-02f, +6.559549650e-03f, -3.198350464e-02f, +4.373425431e-02f, -3.886105779e-02f, +2.240729715e-02f, -3.667596463e-03f, -9.296378042e-03f, +1.338710384e-02f, -1.061192233e-02f, +5.385040952e-03f, -1.342472951e-03f, -2.776767224e-04f,
        -1.419324060e-04f, +1.595955440e-04f, +1.560892182e-04f, -1.010267922e-03f, +2.228384839e-03f, -3.003779716e-03f, +2.009237805e-03f, +2.000287046e-03f, -9.284584834e-03f, +1.825737275e-02f, -2.366543217e-02f, -4.194453342e-02f, +4.558285961e-02f, +1.899261112e-02f, -1.736958296e-02f, +9.978765621e-03f, -3.056473684e-03f, -1.206962806e-03f, +2.625262015e-03f, -2.177401096e-03f, +1.108011130e-03f, -2.656152047e-04f, -9.369971631e-05f, +1.160188528e-04f,
        +2.838025508e-04f, -5.718561002e-04f, +6.724581781e-04f, -1.861802865e-04f, -1.122267980e-03f, +2.996244631e-03f, -4.597610676e-03f, +4.834922423e-03f, -3.004767072e-03f, -6.372154555e-04f, +4.799345772e-03f, -7.717363403e-03f, +8.076230191e-03f, -5.735256233e-03f, +1.799033355e-03f, +2.007849367e-03f, -4.260965174e-03f, +4.488701900e-03f, -3.213620378e-03f, +1.457861926e-03f, -1.021238617e-04f, -5.003128371e-04f, +5.013932930e-04f, -2.661682299e-04f,
        /* 14, 8 (24) */
        -2.852364948e-04f, +1.985305067e-03f, -4.845785254e-03f, +6.586635557e-03f, -3.064893769e-03f, -9.234896479e-03f, +2.920334387e-02f, -4.793704949e-02f, +4.862610755e-02f, -8.356179335e-03f, -1.124326582e-01f, +5.998286689e-01f, +5.998286689e-01f, -1.124326582e-01f, -8.356179335e-03f, +4.862610755e-02f, -4.793704949e-02f, +2.920334387e-02f, -9.234896479e-03f, -3.064893769e-03f, +6.586635557e-03f, -4.845785254e-03f, +1.985305067e-03f, -2.852364948e-04f,
        -5.438449523e-04f, -8.410796581e-04f, +4.884728115e-03f, -1.071404619e-02f, +1.484496577e-02f, -1.250999842e-02f, +8.211054363e-04f, +1.814633198e-02f, -3.685320843e-02f, +4.553328767e-02f, -3.771876087e-02f, +1.463577984e-02f, +1.463577984e-02f, -3.771876087e-02f, +4.553328767e-02f, -3.685320843e-02f, +1.814633198e-02f, +8.211054363e-04f, -1.250999842e-02f, +1.484496577e-02f, -1.071404619e-02f, +4.884728115e-03f, -8.410796581e-04f, -5.438449523e-04f,
        -1.160188528e-04f, +9.369971631e-05f, +2.656152047e-04f, -1.108011130e-03f, +2.177401096e-03f, -2.625262015e-03f, +1.206962806e-03f, +3.056473684e-03f, -9.978765621e-03f, +1.736958296e-02f, -1.899261112e-02f, -4.558285961e-02f, +4.194453342e-02f, +2.366543217e-02f, -1.825737275e-02f, +9.284584834e-03f, -2.000287046e-03f, -2.009237805e-03f, +3.003779716e-03f, -2.228384839e-03f, +1.010267922e-03f, -1.560892182e-04f, -1.595955440e-04f, +1.419324060e-04f,
        +2.661682299e-04f, -5.013932930e-04f, +5.003128371e-04f, +1.021238617e-04f, -1.457861926e-03f, +3.213620378e-03f, -4.488701900e-03f, +4.260965174e-03f, -2.007849367e-03f, -1.799033355e-03f, +5.735256233e-03f, -8.076230191e-03f, +7.717363403e-03f, -4.799345772e-03f, +6.372154555e-04f, +3.004767072e-03f, -4.834922423e-03f, +4.597610676e-03f, -2.996244631e-03f, +1.122267980e-03f, +1.861802865e-04f, -6.724581781e-04f, +5.718561002e-04f, -2.838025508e-04f,
        /* 14, 9 (24) */
        -4.012553476e-04f, +2.079004783e-03f, -4.580170049e-03f, +5.478624427e-03f, -8.874926734e-04f, -1.186015849e-02f, +3.041030668e-02f, -4.488057581e-02f, +3.864734193e-02f, +9.013403621e-03f, -1.314252693e-01f, +5.542458093e-01f, +6.417732023e-01f, -8.876722601e-02f, -2.661355209e-02f, +5.791069239e-02f, -4.993733654e-02f, +2.719410607e-02f, -6.231116763e-03f, -5.293278608e-03f, +7.596903479e-03f, -5.001874472e-03f, +1.825709523e-03f, -1.433040888e-04f,
        -2.776767224e-04f, -1.342472951e-03f, +5.385040952e-03f, -1.061192233e-02f, +1.338710384e-02f, -9.296378042e-03f, -3.667596463e-03f, +2.240729715e-02f, -3.886105779e-02f, +4.373425431e-02f, -3.198350464e-02f, +6.559549650e-03f, +2.235314324e-02f, -4.251810664e-02f, +4.617050312e-02f, -3.384844136e-02f, +1.331140956e-02f, +5.418716112e-03f, -1.550624305e-02f, +1.596723375e-02f, -1.052786591e-02f, +4.212269937e-03f, -2.692235579e-04f, -8.276475031e-04f,
        -8.953355461e-05f, +3.109446220e-05f, +3.603093442e-04f, -1.171780626e-03f, +2.075420816e-03f, -2.201911573e-03f, +4.142819333e-04f, +3.988867217e-03f, -1.040222318e-02f, +1.613657197e-02f, -1.432593212e-02f, -4.856565455e-02f, +3.769674486e-02f, +2.826285741e-02f, -1.875861989e-02f, +8.322595745e-03f, -8.406867828e-04f, -2.801098213e-03f, +3.325251180e-03f, -2.224059472e-03f, +8.789930218e-04f, -3.371534696e-05f, -2.270758033e-04f, +1.663004619e-04f,
        +2.419088112e-04f, -4.223156568e-04f, +3.254523762e-04f, +3.728699214e-04f, -1.740859169e-03f, +3.339350534e-03f, -4.265858037e-03f, +3.589023653e-03f, -9.757447888e-04f, -2.900119811e-03f, +6.515221178e-03f, -8.223760593e-03f, +7.156146625e-03f, -3.731191371e-03f, -5.551395866e-04f, +3.939225526e-03f, -5.293229868e-03f, +4.586383843e-03f, -2.689984773e-03f, +7.412100054e-04f, +4.846945877e-04f, -8.365804647e-04f, +6.307516765e-04f, -2.934599765e-04f,
        /* 14,10 (24) */
        -4.907889022e-04f, +2.110099245e-03f, -4.219860705e-03f, +4.306843801e-03f, +1.187928143e-03f, -1.406207007e-02f, +3.082458861e-02f, -4.089170859e-02f, +2.824511876e-02f, +2.514997559e-02f, -1.457512014e-01f, +5.056801548e-01f, +6.794699472e-01f, -6.050436860e-02f, -4.537217197e-02f, +6.623328813e-02f, -5.077802332e-02f, +2.439300785e-02f, -2.905865583e-03f, -7.517338080e-03f, +8.475896501e-03f, -5.035589819e-03f, +1.598633719e-03f, +2.299637308e-05f,
        -3.576791121e-05f, -1.764788608e-03f, +5.710493328e-03f, -1.023905241e-02f, +1.164624467e-02f, -5.957027508e-03f, -7.933454500e-03f, +2.599632081e-02f, -3.983680258e-02f, +4.083413450e-02f, -2.546828346e-02f, -1.664210943e-03f, +2.950928987e-02f, -4.624929801e-02f, +4.561536354e-02f, -2.990921583e-02f, +8.018179688e-03f, +1.000509996e-02f, -1.819622782e-02f, +1.670844375e-02f, -1.004317132e-02f, +3.375689472e-03f, +3.615281186e-04f, -1.121107480e-03f,
        -6.337976002e-05f, -2.674218979e-05f, +4.387216515e-04f, -1.202043232e-03f, +1.927817022e-03f, -1.746451132e-03f, -3.499684045e-04f, +4.780976087e-03f, -1.055838807e-02f, +1.460476992e-02f, -9.744198089e-03f, -5.085849094e-02f, +3.289645832e-02f, +3.270213392e-02f, -1.883819573e-02f, +7.102281534e-03f, +3.983865162e-04f, -3.561819960e-03f, +3.578319218e-03f, -2.161347921e-03f, +7.155806731e-04f, +9.900943164e-05f, -2.942415176e-04f, +1.881063229e-04f,
        +2.124853822e-04f, -3.376273295e-04f, +1.529512225e-04f, +6.195565658e-04f, -1.965853133e-03f, +3.373241701e-03f, -3.938165215e-03f, +2.838994060e-03f, +6.379111213e-05f, -3.912250990e-03f, +7.119855075e-03f, -8.156619703e-03f, +6.406988049e-03f, -2.558198391e-03f, -1.746665795e-03f, +4.785190304e-03f, -5.620988892e-03f, +4.451958631e-03f, -2.300178650e-03f, +3.234111461e-04f, +7.854012498e-04f, -9.872889198e-04f, +6.752806722e-04f, -2.939567081e-04f,
        /* 14,11 (24) */
        -5.541686622e-04f, +2.083357055e-03f, -3.781139053e-03f, +3.104800569e-03f, +3.115745165e-03f, -1.580852120e-02f, +3.047462021e-02f, -3.611073250e-02f, +1.768673068e-02f, +3.975474551e-02f, -1.554953995e-01f, +4.548216638e-01f, +7.123664055e-01f, -2.780223467e-02f, -6.421036770e-02f, +7.333556967e-02f, -5.037963680e-02f, +2.083118789e-02f, +6.724536350e-04f, -9.678686000e-03f, +9.191477174e-03f, -4.936580387e-03f, +1.304392202e-03f, +2.111026960e-04f,
        +1.767174710e-04f, -2.102415937e-03f, +5.863444550e-03f, -9.619495843e-03f, +9.680391539e-03f, -2.583785807e-03f, -1.187161971e-02f, +2.883531487e-02f, -3.977301147e-02f, +3.692188351e-02f, -1.834842838e-02f, -9.820830647e-03f, +3.591627792e-02f, -4.880749640e-02f, +4.386869774e-02f, -2.512402553e-02f, +2.397190796e-03f, +1.445705859e-02f, -2.049640647e-02f, +1.703185490e-02f, -9.257770068e-03f, +2.388400552e-03f, +1.036808791e-03f, -1.415064188e-03f,
        -3.836696312e-05f, -7.858648557e-05f, +4.999409963e-04f, -1.200109457e-03f, +1.740829624e-03f, -1.271769104e-03f, -1.068532108e-03f, +5.420417328e-03f, -1.045667966e-02f, +1.282455890e-02f, -5.322044051e-03f, -5.243909801e-02f, +2.761056983e-02f, +3.690087026e-02f, -1.846815019e-02f, +5.639772262e-03f, +1.689860357e-03f, -4.270459943e-03f, +3.752824417e-03f, -2.038559404e-03f, +5.223964905e-04f, +2.391125561e-04f, -3.590447885e-04f, +2.063215934e-04f,
        +1.794099129e-04f, -2.502874884e-04f, -1.248540587e-05f, +8.366734445e-04f, -2.129245120e-03f, +3.317589185e-03f, -3.517270216e-03f, +2.032417264e-03f, +1.083275426e-03f, -4.809909646e-03f, +7.534579195e-03f, -7.877199504e-03f, +5.489339666e-03f, -1.310758344e-03f, -2.905665496e-03f, +5.518597552e-03f, -5.806538111e-03f, +4.194580265e-03f, -1.834675153e-03f, -1.210024769e-04f, +1.079817832e-03f, -1.119271557e-03f, +7.028995985e-04f, -2.843338474e-04f,
        /* 14,12 (24) */
        -5.925356253e-04f, +2.004770570e-03f, -3.281198057e-03f, +1.904691112e-03f, +4.856574789e-03f, -1.708029030e-02f, +2.940608810e-02f, -3.069031518e-02f, +7.230051025e-03f, +5.257930441e-02f, -1.608174436e-01f, +4.023825658e-01f, +7.399769753e-01f, +9.098635588e-03f, -8.267851789e-02f, +7.897534193e-02f, -4.868977645e-02f, +1.656072795e-02f, +4.425278052e-03f, -1.171724540e-02f, +9.713873664e-03f, -4.697467831e-03f, +9.453474131e-04f, +4.174242894e-04f,
        +3.561273839e-04f, -2.352703426e-03f, +5.850959145e-03f, -8.782822398e-03f, +7.551146419e-03f, +7.338033779e-04f, -1.538888993e-02f, +3.086773213e-02f, -3.868973605e-02f, +3.211197387e-02f, -1.081384919e-02f, -1.769803015e-02f, +4.140561758e-02f, -5.011825475e-02f, +4.096303225e-02f, -1.960542797e-02f, -3.409347315e-03f, +1.865163885e-02f, -2.233108163e-02f, +1.691085242e-02f, -8.177952236e-03f, +1.269128995e-03f, +1.739708389e-03f, -1.699398035e-03f,
        -1.519240704e-05f, -1.234858063e-04f, +5.435847123e-04f, -1.168049503e-03f, +1.521359334e-03f, -7.905880352e-04f, -1.726084432e-03f, +5.899030074e-03f, -1.011202815e-02f, +1.084907095e-02f, -1.128619274e-03f, -5.329763608e-02f, +2.191474422e-02f, +4.077863748e-02f, -1.762857440e-02f, +3.957772375e-03f, +3.004055559e-03f, -4.906380705e-03f, +3.840131736e-03f, -1.855510616e-03f, +3.027704652e-04f, +3.831996986e-04f, -4.193405584e-04f, +2.199403268e-04f,
        +1.441891318e-04f, -1.631210799e-04f, -1.666388914e-04f, +1.019810357e-03f, -2.229271926e-03f, +3.177030991e-03f, -3.016993660e-03f, +1.191860302e-03f, +2.056233880e-03f, -5.570939039e-03f, +7.749978225e-03f, -7.393538277e-03f, +4.427181083e-03f, -2.144504233e-05f, -4.000967587e-03f, +6.118043611e-03f, -5.841843140e-03f, +3.817883323e-03f, -1.303694875e-03f, -5.807375418e-04f, +1.359225931e-03f, -1.227463238e-03f, +7.114217783e-04f, -2.639103140e-04f,
        /* 14,13 (24) */
        -6.077280324e-04f, +1.881284763e-03f, -2.737613345e-03f, +7.366416088e-04f, +6.377934123e-03f, -1.787087834e-02f, +2.768000367e-02f, -2.479128510e-02f, -2.881977125e-03f, +6.342837536e-02f, -1.619460628e-01f, +3.490849297e-01f, +7.618917196e-01f, +4.987727307e-02f, -1.003070923e-01f, +8.293311430e-02f, -4.568572089e-02f, +1.165434724e-02f, +8.265409788e-03f, -1.357275602e-02f, +1.001664413e-02f, -4.314268133e-03f, +5.260068547e-04f, +6.373646162e-04f,
        +5.003165157e-04f, -2.515824506e-03f, +5.684320253e-03f, -7.763012041e-03f, +5.321874493e-03f, +3.910834368e-03f, -1.840588359e-02f, +3.205959243e-02f, -3.663350216e-02f, +2.654103483e-02f, -3.063870962e-03f, -2.509156843e-02f, +4.583279867e-02f, -5.013969979e-02f, +3.696206466e-02f, -1.348738436e-02f, -9.251190455e-03f, +2.246952217e-02f, -2.363477650e-02f, +1.633011488e-02f, -6.818726304e-03f, +4.166575678e-05f, +2.451130168e-03f, -1.963308349e-03f,
        +5.572393499e-06f, -1.607663332e-04f, +5.697741405e-04f, -1.108593712e-03f, +1.276755037e-03f, -3.151529850e-04f, -2.309519827e-03f, +6.212883448e-03f, -9.544290844e-03f, +8.732967871e-03f, +2.773590470e-03f, -5.343672742e-02f, +1.589207580e-02f, +4.425856157e-02f, -1.630831799e-02f, +2.085333382e-03f, +4.309298463e-03f, -5.449791260e-03f, +3.833432868e-03f, -1.613612465e-03f, +6.096256087e-05f, +5.275243952e-04f, -4.729451409e-04f, +2.280151365e-04f,
        +1.082724704e-04f, -7.873939740e-05f, -3.058736760e-04f, +1.165729588e-03f, -2.265980518e-03f, +2.958341386e-03f, -2.452893712e-03f, +3.402831812e-04f, +2.957897070e-03f, -6.177097633e-03f, +7.762013897e-03f, -6.719086665e-03f, +3.248379155e-03f, +1.275853774e-03f, -5.002780468e-03f, +6.565411707e-03f, -5.722793198e-03f, +3.328879636e-03f, -7.196184886e-04f, -1.043612417e-03f, +1.614917439e-03f, -1.307215183e-03f, +6.991129623e-04f, -2.323296147e-04f,
        /* 14,14 (24) */
        -6.021556389e-04f, +1.720518430e-03f, -2.167839204e-03f, -3.719521032e-04f, +7.654689160e-03f, -1.818603132e-02f, +2.537048384e-02f, -1.857840165e-02f, -1.242626797e-02f, +7.216134324e-02f, -1.591724724e-01f, +2.956482023e-01f, +7.777837954e-01f, +9.413583464e-02f, -1.166154103e-01f, +8.501844769e-02f, -4.137642242e-02f, +6.204555983e-03f, +1.209884266e-02f, -1.518636848e-02f, +1.007760669e-02f, -3.786743738e-03f, +5.306171384e-05f, +8.653797527e-04f,
        +6.085889861e-04f, -2.594563903e-03f, +5.378446577e-03f, -6.597282453e-03f, +3.055893975e-03f, +6.869175755e-03f, -2.085877730e-02f, +3.239987561e-02f, -3.367560509e-02f, +2.036393719e-02f, +4.698142935e-03f, -3.181065509e-02f, +4.908117782e-02f, -4.886384601e-02f, +3.195928419e-02f, -6.921972656e-03f, -1.497398365e-02f, +2.579840181e-02f, -2.435439499e-02f, +1.528650246e-02f, -5.203808866e-03f, -1.265549426e-03f, +3.150243130e-03f, -2.195637964e-03f,
        +2.349002182e-05f, -1.900318896e-04f, +5.790976380e-04f, -1.025020997e-03f, +1.014600524e-03f, +1.430531405e-04f, -2.808172144e-03f, +6.362182872e-03f, -8.777579547e-03f, +6.531229974e-03f, +6.329778800e-03f, -5.287124448e-02f, +9.631599269e-03f, +4.726887393e-02f, -1.450554143e-02f, +5.747152836e-05f, +5.572608642e-03f, -5.882290961e-03f, +3.728015257e-03f, -1.315918267e-03f, -1.978996535e-04f, +6.680724132e-04f, -5.177001582e-04f, +2.296942030e-04f,
        +7.300562037e-05f, +5.275240448e-07f, -4.272109316e-04f, +1.272400915e-03f, -2.241152524e-03f, +2.670171812e-03f, -1.841793810e-03f, -4.995911740e-04f, +3.765838378e-03f, -6.614500504e-03f, +7.572090831e-03f, -5.872327283e-03f, +1.983940869e-03f, +2.546845728e-03f, -5.883515895e-03f, +6.846417259e-03f, -5.449394323e-03f, +2.737850722e-03f, -9.670671648e-05f, -1.496872527e-03f, +1.838451667e-03f, -1.354460665e-03f, +6.647781197e-04f, -1.895983879e-04f,
        /* 14,15 (24) */
        -5.786656170e-04f, +1.530486541e-03f, -1.588741566e-03f, -1.396973100e-03f, +8.669289684e-03f, -1.804297818e-02f, +2.256231169e-02f, -1.221621878e-02f, -2.120384752e-02f, +7.869257321e-02f, -1.528426936e-01f, +2.427769578e-01f, +7.874153946e-01f, +1.414047086e-01f, -1.311209517e-01f, +8.507591921e-02f, -3.580381378e-02f, +3.222650227e-04f, +1.582685791e-02f, -1.650228675e-02f, +9.879707037e-03f, -3.118671324e-03f, -4.646384443e-04f, +1.095073956e-03f,
        +6.815946065e-04f, -2.594036379e-03f, +4.951235646e-03f, -5.324881538e-03f, +8.147414509e-04f, +9.539347567e-03f, -2.270057111e-02f, +3.190028444e-02f, -2.990976672e-02f, +1.374943669e-02f, +1.227023377e-02f, -3.768298238e-02f, +5.106511869e-02f, -4.631700029e-02f, +2.607576830e-02f, -7.555539715e-05f, -2.042337798e-02f, +2.853625253e-02f, -2.445110171e-02f, +1.378962994e-02f, -3.365357199e-03f, -2.620010092e-03f, +3.815021250e-03f, -2.385236352e-03f,
        +3.826050238e-05f, -2.111545745e-04f, +5.725628529e-04f, -9.210389417e-04f, +7.425062231e-04f, +5.735612965e-04f, -3.213964647e-03f, +6.351081144e-03f, -7.839517914e-03f, +4.297979908e-03f, +9.493654979e-03f, -5.162786239e-02f, +3.226680462e-03f, +4.974438686e-02f, -1.222808687e-02f, -2.085366097e-03f, +6.760448353e-03f, -6.187402659e-03f, +3.521489134e-03f, -9.671301358e-04f, -4.679111297e-04f, +8.006592829e-04f, -5.515402691e-04f, +2.242580105e-04f,
        +3.959096234e-05f, +7.268521485e-05f, -5.283783837e-04f, +1.338999949e-03f, -2.158182611e-03f, +2.322748136e-03f, -1.201288539e-03f, -1.305886445e-03f, +4.460536991e-03f, -6.873936703e-03f, +7.186973906e-03f, -4.876258793e-03f, +6.671799512e-04f, +3.757759117e-03f, -6.618560623e-03f, +6.951055384e-03f, -5.025851749e-03f, +2.058145461e-03f, +5.492420567e-04f, -1.927534233e-03f, +2.021916039e-03f, -1.365871498e-03f, +6.078360122e-04f, -1.361148124e-04f,
        /* 15, 0 (24) */
        -1.202019198e-03f, +3.406678548e-03f, -6.303893631e-03f, +8.068354747e-03f, -5.607321184e-03f, -4.553512604e-03f, +2.472926036e-02f, -5.449259515e-02f, +8.986605310e-02f, -1.238918309e-01f, +1.485898543e-01f, +8.423743737e-01f, +1.485898543e-01f, -1.238918309e-01f, +8.986605310e-02f, -5.449259515e-02f, +2.472926036e-02f, -4.553512604e-03f, -5.607321184e-03f, +8.068354747e-03f, -6.303893631e-03f, +3.406678548e-03f, -1.202019198e-03f, +1.807804541e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -8.814319808e-05f, -5.629574316e-05f, +5.652122150e-04f, -1.554004909e-03f, +2.894664369e-03f, -4.070731190e-03f, +4.129257199e-03f, -1.734596604e-03f, -4.865689287e-03f, +1.884664750e-02f, -5.350214598e-02f, -3.893860413e-03f, +5.650412118e-02f, -1.668062888e-02f, +2.575956794e-03f, +3.378980922e-03f, -5.045194700e-03f, +4.415253187e-03f, -2.896309433e-03f, +1.415676388e-03f, -4.179610069e-04f, -4.418446917e-05f, +1.384693596e-04f, -7.785146472e-05f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15, 1 (24) */
        -1.290162396e-03f, +3.350382805e-03f, -5.738681416e-03f, +6.514349838e-03f, -2.712656815e-03f, -8.624243794e-03f, +2.885851756e-02f, -5.622719176e-02f, +8.500036382e-02f, -1.050451834e-01f, +9.508770829e-02f, +8.384805133e-01f, +2.050939754e-01f, -1.405724598e-01f, +9.244200990e-02f, -5.111361423e-02f, +1.968406566e-02f, -1.382594172e-04f, -8.503630616e-03f, +9.484031135e-03f, -6.721854638e-03f, +3.362494079e-03f, -1.063549838e-03f, +1.029289894e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -4.009581509e-05f, -1.470779616e-04f, +6.863882519e-04f, -1.640552014e-03f, +2.812790794e-03f, -3.631308541e-03f, +3.144440238e-03f, -1.232143192e-04f, -6.903888787e-03f, +2.038905732e-02f, -4.981571966e-02f, -1.161554014e-02f, +5.874357177e-02f, -1.390186963e-02f, +8.327052965e-05f, +5.011741168e-03f, -5.862591698e-03f, +4.649965954e-03f, -2.813224953e-03f, +1.226552000e-03f, -2.473799188e-04f, -1.518867064e-04f, +1.895043655e-04f, -9.649564219e-05f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15, 2 (24) */
        -1.330258211e-03f, +3.203304844e-03f, -5.052293164e-03f, +4.873797825e-03f, +1.001339790e-04f, -1.225555233e-02f, +3.200295779e-02f, -5.635040608e-02f, +7.809647503e-02f, -8.465612610e-02f, +4.527198863e-02f, +8.268649732e-01f, +2.638375472e-01f, -1.544743294e-01f, +9.252528043e-02f, -4.610187306e-02f, +1.382147396e-02f, +4.511706537e-03f, -1.131685557e-02f, +1.071058314e-02f, -6.969234557e-03f, +3.210607373e-03f, -8.740454728e-04f, +6.433347233e-06f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +4.314478209e-06f, -2.261678214e-04f, +7.796907880e-04f, -1.675879999e-03f, +2.657224881e-03f, -3.113814380e-03f, +2.120911624e-03f, +1.413494736e-03f, -8.650745090e-03f, +2.131109846e-02f, -4.553441535e-02f, -1.914045496e-02f, +6.015581409e-02f, -1.053560437e-02f, -2.555870238e-03f, +6.586393774e-03f, -6.553166629e-03f, +4.762413539e-03f, -2.643188401e-03f, +9.892254810e-04f, -5.713587572e-05f, -2.639004645e-04f, +2.395057305e-04f, -1.138448639e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15, 3 (24) */
        -1.325943733e-03f, +2.977137022e-03f, -4.272602376e-03f, +3.197917825e-03f, +2.757358860e-03f, -1.536936671e-02f, +3.412386942e-02f, -5.493691134e-02f, +6.944572994e-02f, -6.334502763e-02f, -2.624267216e-04f, +8.077245182e-01f, +3.239933613e-01f, -1.650099338e-01f, +8.996941019e-02f, -3.951547929e-02f, +7.268307330e-03f, +9.274120075e-03f, -1.396004397e-02f, +1.169980862e-02f, -7.026370432e-03f, +2.946706908e-03f, -6.345397422e-04f, -1.074115167e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +4.396998716e-05f, -2.920812198e-04f, +8.442635397e-04f, -1.661996396e-03f, +2.436248157e-03f, -2.536436861e-03f, +1.088497382e-03f, +2.837787581e-03f, -1.007581599e-02f, +2.162954199e-02f, -4.075719244e-02f, -2.634192530e-02f, +6.069117436e-02f, -6.621358951e-03f, -5.278131914e-03f, +8.055794269e-03f, -7.090890376e-03f, +4.743078092e-03f, -2.386442955e-03f, +7.079125913e-04f, +1.482391463e-04f, -3.769458208e-04f, +2.866068862e-04f, -1.289967247e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15, 4 (24) */
        -1.281973746e-03f, +2.685055802e-03f, -3.428338836e-03f, +1.535921429e-03f, +5.193607018e-03f, -1.790580358e-02f, +3.521236680e-02f, -5.209912376e-02f, +5.936991395e-02f, -4.171548565e-02f, -4.101961916e-02f, +7.813825929e-01f, +3.846845357e-01f, -1.716312928e-01f, +8.469127828e-02f, -3.145968502e-02f, +1.774169543e-04f, +1.401719817e-02f, -1.634648693e-02f, +1.240772121e-02f, -6.878131286e-03f, +2.569761087e-03f, -3.479328561e-04f, -2.364082414e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +7.801225401e-05f, -3.438548100e-04f, +8.801590009e-04f, -1.602214322e-03f, +2.159561881e-03f, -1.918149264e-03f, +7.587967839e-05f, +4.116677753e-03f, -1.115836981e-02f, +2.137381569e-02f, -3.559011192e-02f, -3.309990950e-02f, +6.031629751e-02f, -2.212535144e-03f, -8.014649254e-03f, +9.373404232e-03f, -7.452834591e-03f, +4.585802324e-03f, -2.045820081e-03f, +3.884154965e-04f, +3.634360127e-04f, -4.874555904e-04f, +3.288739740e-04f, -1.410429498e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15, 5 (24) */
        -1.203961492e-03f, +2.341200992e-03f, -2.548179835e-03f, -6.629289359e-05f, +7.353168899e-03f, -1.982395284e-02f, +3.528824648e-02f, -4.798244601e-02f, +4.821154414e-02f, -2.034166996e-02f, -7.660973108e-02f, +7.482826834e-01f, +4.450008332e-01f, -1.738438279e-01f, +7.667662902e-02f, -2.208628079e-02f, -7.275417637e-03f, +1.860300049e-02f, -1.839230701e-02f, +1.279613670e-02f, -6.514695273e-03f, +2.082305497e-03f, -1.905888210e-05f, -3.774511912e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.058503852e-04f, -3.810391546e-04f, +8.882794882e-04f, -1.500981923e-03f, +1.837936775e-03f, -1.278140567e-03f, -8.901386714e-04f, +5.222602376e-03f, -1.188747184e-02f, +2.058486152e-02f, -3.014393553e-02f, -3.930344637e-02f, +5.901511065e-02f, +2.624343014e-03f, -1.069251893e-02f, +1.049459696e-02f, -7.619970147e-03f, +4.288133619e-03f, -1.626790569e-03f, +3.803611168e-05f, +5.824866660e-04f, -5.916728740e-04f, +3.643695193e-04f, -1.491056222e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15, 6 (24) */
        -1.098111107e-03f, +1.960161838e-03f, -1.659900347e-03f, -1.567274816e-03f, +9.191105673e-03f, -2.110209341e-02f, +3.439810781e-02f, -4.275984363e-02f, +3.632407230e-02f, +2.431915639e-04f, -1.067536666e-01f, +7.089792371e-01f, +5.040159438e-01f, -1.712194849e-01f, +6.598411010e-02f, -1.159168383e-02f, -1.489538778e-02f, +2.289113411e-02f, -2.001909758e-02f, +1.283417282e-02f, -5.932208607e-03f, +1.490632623e-03f, +3.453106372e-04f, -5.265568134e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.271595146e-04f, -4.036758732e-04f, +8.702958117e-04f, -1.363687610e-03f, +1.482849467e-03f, -6.352664072e-04f, -1.785285630e-03f, +6.133916651e-03f, -1.226182127e-02f, +1.931375947e-02f, -2.453166604e-02f, -4.485289149e-02f, +5.678941514e-02f, +7.810710943e-03f, -1.323645216e-02f, +1.137796797e-02f, -7.577890870e-03f, +3.851576103e-03f, -1.137438961e-03f, -3.345616471e-04f, +7.989107046e-04f, -6.857617204e-04f, +3.912211946e-04f, -1.523752566e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15, 7 (24) */
        -9.709515919e-04f, +1.556485965e-03f, -7.896045356e-04f, -2.930962426e-03f, +1.067395514e-02f, -2.173735981e-02f, +3.261282218e-02f, -3.662592698e-02f, +2.406225103e-02f, +1.955695104e-02f, -1.312853327e-01f, +6.641263456e-01f, +5.608053590e-01f, -1.634087739e-01f, +5.274765793e-02f, -2.137158612e-04f, -2.247327865e-02f, +2.674271021e-02f, -2.115653654e-02f, +1.249961117e-02f, -5.133297903e-03f, +8.048709026e-04f, +7.365318318e-04f, -6.789320700e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.418701448e-04f, -4.122605562e-04f, +8.285473963e-04f, -1.196448209e-03f, +1.106116859e-03f, -7.535085183e-06f, -2.588372871e-03f, +6.835209469e-03f, -1.228935191e-02f, +1.762015730e-02f, -1.886608640e-02f, -4.966189682e-02f, +5.365908981e-02f, +1.325735489e-02f, -1.557054960e-02f, +1.198661499e-02f, -7.317438857e-03f, +3.281739094e-03f, -5.883583626e-04f, -7.195391699e-04f, +1.005887268e-03f, -7.659280418e-04f, +4.076935767e-04f, -1.501493771e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15, 8 (24) */
        -8.290814471e-04f, +1.144225408e-03f, +3.894286075e-05f, -4.127410634e-03f, +1.178007200e-02f, -2.174489490e-02f, +3.002444931e-02f, -2.979071751e-02f, +1.177289913e-02f, +3.717710833e-02f, -1.501514191e-01f, +6.144644488e-01f, +6.144644488e-01f, -1.501514191e-01f, +3.717710833e-02f, +1.177289913e-02f, -2.979071751e-02f, +3.002444931e-02f, -2.174489490e-02f, +1.178007200e-02f, -4.127410634e-03f, +3.894286075e-05f, +1.144225408e-03f, -8.290814471e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.501493771e-04f, -4.076935767e-04f, +7.659280418e-04f, -1.005887268e-03f, +7.195391699e-04f, +5.883583626e-04f, -3.281739094e-03f, +7.317438857e-03f, -1.198661499e-02f, +1.557054960e-02f, -1.325735489e-02f, -5.365908981e-02f, +4.966189682e-02f, +1.886608640e-02f, -1.762015730e-02f, +1.228935191e-02f, -6.835209469e-03f, +2.588372871e-03f, +7.535085183e-06f, -1.106116859e-03f, +1.196448209e-03f, -8.285473963e-04f, +4.122605562e-04f, -1.418701448e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15, 9 (24) */
        -6.789320700e-04f, +7.365318318e-04f, +8.048709026e-04f, -5.133297903e-03f, +1.249961117e-02f, -2.115653654e-02f, +2.674271021e-02f, -2.247327865e-02f, -2.137158612e-04f, +5.274765793e-02f, -1.634087739e-01f, +5.608053590e-01f, +6.641263456e-01f, -1.312853327e-01f, +1.955695104e-02f, +2.406225103e-02f, -3.662592698e-02f, +3.261282218e-02f, -2.173735981e-02f, +1.067395514e-02f, -2.930962426e-03f, -7.896045356e-04f, +1.556485965e-03f, -9.709515919e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.523752566e-04f, -3.912211946e-04f, +6.857617204e-04f, -7.989107046e-04f, +3.345616471e-04f, +1.137438961e-03f, -3.851576103e-03f, +7.577890870e-03f, -1.137796797e-02f, +1.323645216e-02f, -7.810710943e-03f, -5.678941514e-02f, +4.485289149e-02f, +2.453166604e-02f, -1.931375947e-02f, +1.226182127e-02f, -6.133916651e-03f, +1.785285630e-03f, +6.352664072e-04f, -1.482849467e-03f, +1.363687610e-03f, -8.702958117e-04f, +4.036758732e-04f, -1.271595146e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15,10 (24) */
        -5.265568134e-04f, +3.453106372e-04f, +1.490632623e-03f, -5.932208607e-03f, +1.283417282e-02f, -2.001909758e-02f, +2.289113411e-02f, -1.489538778e-02f, -1.159168383e-02f, +6.598411010e-02f, -1.712194849e-01f, +5.040159438e-01f, +7.089792371e-01f, -1.067536666e-01f, +2.431915639e-04f, +3.632407230e-02f, -4.275984363e-02f, +3.439810781e-02f, -2.110209341e-02f, +9.191105673e-03f, -1.567274816e-03f, -1.659900347e-03f, +1.960161838e-03f, -1.098111107e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.491056222e-04f, -3.643695193e-04f, +5.916728740e-04f, -5.824866660e-04f, -3.803611168e-05f, +1.626790569e-03f, -4.288133619e-03f, +7.619970147e-03f, -1.049459696e-02f, +1.069251893e-02f, -2.624343014e-03f, -5.901511065e-02f, +3.930344637e-02f, +3.014393553e-02f, -2.058486152e-02f, +1.188747184e-02f, -5.222602376e-03f, +8.901386714e-04f, +1.278140567e-03f, -1.837936775e-03f, +1.500981923e-03f, -8.882794882e-04f, +3.810391546e-04f, -1.058503852e-04f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15,11 (24) */
        -3.774511912e-04f, -1.905888210e-05f, +2.082305497e-03f, -6.514695273e-03f, +1.279613670e-02f, -1.839230701e-02f, +1.860300049e-02f, -7.275417637e-03f, -2.208628079e-02f, +7.667662902e-02f, -1.738438279e-01f, +4.450008332e-01f, +7.482826834e-01f, -7.660973108e-02f, -2.034166996e-02f, +4.821154414e-02f, -4.798244601e-02f, +3.528824648e-02f, -1.982395284e-02f, +7.353168899e-03f, -6.629289359e-05f, -2.548179835e-03f, +2.341200992e-03f, -1.203961492e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.410429498e-04f, -3.288739740e-04f, +4.874555904e-04f, -3.634360127e-04f, -3.884154965e-04f, +2.045820081e-03f, -4.585802324e-03f, +7.452834591e-03f, -9.373404232e-03f, +8.014649254e-03f, +2.212535144e-03f, -6.031629751e-02f, +3.309990950e-02f, +3.559011192e-02f, -2.137381569e-02f, +1.115836981e-02f, -4.116677753e-03f, -7.587967839e-05f, +1.918149264e-03f, -2.159561881e-03f, +1.602214322e-03f, -8.801590009e-04f, +3.438548100e-04f, -7.801225401e-05f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15,12 (24) */
        -2.364082414e-04f, -3.479328561e-04f, +2.569761087e-03f, -6.878131286e-03f, +1.240772121e-02f, -1.634648693e-02f, +1.401719817e-02f, +1.774169543e-04f, -3.145968502e-02f, +8.469127828e-02f, -1.716312928e-01f, +3.846845357e-01f, +7.813825929e-01f, -4.101961916e-02f, -4.171548565e-02f, +5.936991395e-02f, -5.209912376e-02f, +3.521236680e-02f, -1.790580358e-02f, +5.193607018e-03f, +1.535921429e-03f, -3.428338836e-03f, +2.685055802e-03f, -1.281973746e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.289967247e-04f, -2.866068862e-04f, +3.769458208e-04f, -1.482391463e-04f, -7.079125913e-04f, +2.386442955e-03f, -4.743078092e-03f, +7.090890376e-03f, -8.055794269e-03f, +5.278131914e-03f, +6.621358951e-03f, -6.069117436e-02f, +2.634192530e-02f, +4.075719244e-02f, -2.162954199e-02f, +1.007581599e-02f, -2.837787581e-03f, -1.088497382e-03f, +2.536436861e-03f, -2.436248157e-03f, +1.661996396e-03f, -8.442635397e-04f, +2.920812198e-04f, -4.396998716e-05f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15,13 (24) */
        -1.074115167e-04f, -6.345397422e-04f, +2.946706908e-03f, -7.026370432e-03f, +1.169980862e-02f, -1.396004397e-02f, +9.274120075e-03f, +7.268307330e-03f, -3.951547929e-02f, +8.996941019e-02f, -1.650099338e-01f, +3.239933613e-01f, +8.077245182e-01f, -2.624267216e-04f, -6.334502763e-02f, +6.944572994e-02f, -5.493691134e-02f, +3.412386942e-02f, -1.536936671e-02f, +2.757358860e-03f, +3.197917825e-03f, -4.272602376e-03f, +2.977137022e-03f, -1.325943733e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +1.138448639e-04f, -2.395057305e-04f, +2.639004645e-04f, +5.713587572e-05f, -9.892254810e-04f, +2.643188401e-03f, -4.762413539e-03f, +6.553166629e-03f, -6.586393774e-03f, +2.555870238e-03f, +1.053560437e-02f, -6.015581409e-02f, +1.914045496e-02f, +4.553441535e-02f, -2.131109846e-02f, +8.650745090e-03f, -1.413494736e-03f, -2.120911624e-03f, +3.113814380e-03f, -2.657224881e-03f, +1.675879999e-03f, -7.796907880e-04f, +2.261678214e-04f, -4.314478209e-06f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15,14 (24) */
        +6.433347233e-06f, -8.740454728e-04f, +3.210607373e-03f, -6.969234557e-03f, +1.071058314e-02f, -1.131685557e-02f, +4.511706537e-03f, +1.382147396e-02f, -4.610187306e-02f, +9.252528043e-02f, -1.544743294e-01f, +2.638375472e-01f, +8.268649732e-01f, +4.527198863e-02f, -8.465612610e-02f, +7.809647503e-02f, -5.635040608e-02f, +3.200295779e-02f, -1.225555233e-02f, +1.001339790e-04f, +4.873797825e-03f, -5.052293164e-03f, +3.203304844e-03f, -1.330258211e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +9.649564219e-05f, -1.895043655e-04f, +1.518867064e-04f, +2.473799188e-04f, -1.226552000e-03f, +2.813224953e-03f, -4.649965954e-03f, +5.862591698e-03f, -5.011741168e-03f, -8.327052965e-05f, +1.390186963e-02f, -5.874357177e-02f, +1.161554014e-02f, +4.981571966e-02f, -2.038905732e-02f, +6.903888787e-03f, +1.232143192e-04f, -3.144440238e-03f, +3.631308541e-03f, -2.812790794e-03f, +1.640552014e-03f, -6.863882519e-04f, +1.470779616e-04f, +4.009581509e-05f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        /* 15,15 (24) */
        +1.029289894e-04f, -1.063549838e-03f, +3.362494079e-03f, -6.721854638e-03f, +9.484031135e-03f, -8.503630616e-03f, -1.382594172e-04f, +1.968406566e-02f, -5.111361423e-02f, +9.244200990e-02f, -1.405724598e-01f, +2.050939754e-01f, +8.384805133e-01f, +9.508770829e-02f, -1.050451834e-01f, +8.500036382e-02f, -5.622719176e-02f, +2.885851756e-02f, -8.624243794e-03f, -2.712656815e-03f, +6.514349838e-03f, -5.738681416e-03f, +3.350382805e-03f, -1.290162396e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +7.785146472e-05f, -1.384693596e-04f, +4.418446917e-05f, +4.179610069e-04f, -1.415676388e-03f, +2.896309433e-03f, -4.415253187e-03f, +5.045194700e-03f, -3.378980922e-03f, -2.575956794e-03f, +1.668062888e-02f, -5.650412118e-02f, +3.893860413e-03f, +5.350214598e-02f, -1.884664750e-02f, +4.865689287e-03f, +1.734596604e-03f, -4.129257199e-03f, +4.070731190e-03f, -2.894664369e-03f, +1.554004909e-03f, -5.652122150e-04f, +5.629574316e-05f, +8.814319808e-05f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
    }
};

/* This 11th order filter has a rejection of -40dB, yielding a transition width
 * of ~0.203 (normalized frequency). Order increases when downsampling to a
 * limit of one octave, after which the quality of the filter (transition
 * width) suffers to reduce the CPU cost. The bandlimiting will cut all sound
 * after downsampling by ~3.30 octaves.
 */
const BSincTable bsinc12 = {
    /* scaleBase */ 1.014703785e-01f, /* scaleRange */ 1.112929364e+00f,
    /* m */ { 24, 24, 24, 24, 24, 24, 24, 24, 20, 20, 16, 16, 16, 12, 12, 12 },
    /* filterOffset */ { 0, 1536, 3072, 4608, 6144, 7680, 9216, 10752, 12288, 13568, 14848, 15872, 16896, 17920, 18688, 19456 },

    /* Tab (20224 entries) */ {
        /*  0, 0 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +5.699079163e-03f, +9.391619165e-03f, +1.412003132e-02f, +1.978780700e-02f, +2.618766558e-02f, +3.300962293e-02f, +3.986250151e-02f, +4.630710150e-02f, +5.189752414e-02f, +5.622583743e-02f, +5.896461470e-02f, +5.990197477e-02f, +5.896461470e-02f, +5.622583743e-02f, +5.189752414e-02f, +4.630710150e-02f, +3.986250151e-02f, +3.300962293e-02f, +2.618766558e-02f, +1.978780700e-02f, +1.412003132e-02f, +9.391619165e-03f, +5.699079163e-03f, +3.033414355e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.960749141e-04f, -2.615442299e-04f, -3.246064176e-04f, -3.783813704e-04f, -4.160394191e-04f, -4.316573727e-04f, -4.210258335e-04f, -3.822915174e-04f, -3.163364871e-04f, -2.268299826e-04f, -1.199331400e-04f, -3.685685399e-06f, +1.128507582e-04f, +2.205828625e-04f, +3.113799387e-04f, +3.789424838e-04f, +4.194333165e-04f, +4.317940913e-04f, +4.177150854e-04f, +3.812749648e-04f, +3.283123126e-04f, +2.656253207e-04f, +2.001152905e-04f, +1.379910952e-04f,
        /*  0, 1 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +5.503004249e-03f, +9.130074935e-03f, +1.379542491e-02f, +1.940942563e-02f, +2.577162616e-02f, +3.257796556e-02f, +3.944147567e-02f, +4.592480998e-02f, +5.158118765e-02f, +5.599900745e-02f, +5.884468156e-02f, +5.989828908e-02f, +5.907746546e-02f, +5.644642030e-02f, +5.220890408e-02f, +4.668604398e-02f, +4.028193482e-02f, +3.344141702e-02f, +2.660538066e-02f, +2.016908197e-02f, +1.444834364e-02f, +9.657244486e-03f, +5.899194453e-03f, +3.171405450e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.920495797e-04f, -2.574539829e-04f, -3.208642311e-04f, -3.754245234e-04f, -4.142770958e-04f, -4.314173415e-04f, -4.225076726e-04f, -3.855333010e-04f, -3.212002155e-04f, -2.330085517e-04f, -1.269786586e-04f, -1.105591687e-05f, +1.057336668e-04f, +2.142689858e-04f, +3.063318181e-04f, +3.754867850e-04f, +4.177300107e-04f, +4.318267432e-04f, +4.193028253e-04f, +3.841037044e-04f, +3.319801912e-04f, +2.696956158e-04f, +2.041693330e-04f, +1.416741607e-04f,
        /*  0, 2 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +5.310954669e-03f, +8.872620952e-03f, +1.347456067e-02f, +1.903400111e-02f, +2.535734906e-02f, +3.214654822e-02f, +3.901896800e-02f, +4.553927668e-02f, +5.125998744e-02f, +5.576599890e-02f, +5.871770290e-02f, +5.988723317e-02f, +5.918319912e-02f, +5.666068928e-02f, +5.251523590e-02f, +4.706153077e-02f, +4.069966483e-02f, +3.387324377e-02f, +2.702468349e-02f, +2.055318567e-02f, +1.478032383e-02f, +9.926940101e-03f, +6.103363786e-03f, +3.313079611e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.880406414e-04f, -2.533562076e-04f, -3.170874784e-04f, -3.724060396e-04f, -4.124294112e-04f, -4.310747882e-04f, -4.238789874e-04f, -3.886672932e-04f, -3.259699149e-04f, -2.391168051e-04f, -1.339851768e-04f, -1.842273085e-05f, +9.858403415e-05f, +2.078901751e-04f, +3.011934115e-04f, +3.719250490e-04f, +4.159158478e-04f, +4.317546116e-04f, +4.208013970e-04f, +3.868660020e-04f, +3.356083300e-04f, +2.737534645e-04f, +2.082356450e-04f, +1.453890870e-04f,
        /*  0, 3 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +5.122914028e-03f, +8.619264745e-03f, +1.315747320e-02f, +1.866159507e-02f, +2.494491965e-02f, +3.171547343e-02f, +3.859508901e-02f, +4.515060939e-02f, +5.093401752e-02f, +5.552688209e-02f, +5.858371772e-02f, +5.986881044e-02f, +5.928178316e-02f, +5.686857946e-02f, +5.281642931e-02f, +4.743345582e-02f, +4.111558068e-02f, +3.430499838e-02f, +2.744548489e-02f, +2.094005167e-02f, +1.511593216e-02f, +1.020069357e-02f, +6.311599431e-03f, +3.458468698e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.840494321e-04f, -2.492525195e-04f, -3.132778847e-04f, -3.693275483e-04f, -4.104976870e-04f, -4.306305397e-04f, -4.251399738e-04f, -3.916929963e-04f, -3.306444157e-04f, -2.451530077e-04f, -1.409505737e-04f, -2.578385067e-05f, +9.140404286e-05f, +2.014482809e-04f, +2.959660430e-04f, +3.682579471e-04f, +4.139908027e-04f, +4.315770173e-04f, +4.222095865e-04f, +3.895602860e-04f, +3.391950078e-04f, +2.777972061e-04f, +2.123128096e-04f, +1.491348359e-04f,
        /*  0, 4 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +4.938864596e-03f, +8.370012225e-03f, +1.284419531e-02f, +1.829226752e-02f, +2.453442196e-02f, +3.128484289e-02f, +3.816994904e-02f, +4.475891639e-02f, +5.060337311e-02f, +5.528172909e-02f, +5.844276715e-02f, +5.984302658e-02f, +5.937318720e-02f, +5.707002774e-02f, +5.311239535e-02f, +4.780171377e-02f, +4.152957148e-02f, +3.473657539e-02f, +2.786769447e-02f, +2.132961196e-02f, +1.545512716e-02f, +1.047849077e-02f, +6.523912241e-03f, +3.607603534e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.800772619e-04f, -2.451445209e-04f, -3.094371743e-04f, -3.661906908e-04f, -4.084832700e-04f, -4.300854583e-04f, -4.262908700e-04f, -3.946099562e-04f, -3.352225880e-04f, -2.511154556e-04f, -1.478727465e-04f, -3.313700212e-05f, +8.419588858e-05f, +1.949451810e-04f, +2.906510740e-04f, +3.644861934e-04f, +4.119548933e-04f, +4.312933190e-04f, +4.235262086e-04f, +3.921850012e-04f, +3.427385065e-04f, +2.818251702e-04f, +2.163993902e-04f, +1.529103426e-04f,
        /*  0, 5 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +4.758787334e-03f, +8.124867704e-03f, +1.253475814e-02f, +1.792607683e-02f, +2.412593869e-02f, +3.085475743e-02f, +3.774365817e-02f, +4.436430644e-02f, +5.026815052e-02f, +5.503061363e-02f, +5.829489440e-02f, +5.980988958e-02f, +5.945738309e-02f, +5.726497292e-02f, +5.340304642e-02f, +4.816619996e-02f, +4.194152638e-02f, +3.516786871e-02f, +2.829122068e-02f, +2.172179696e-02f, +1.579786567e-02f, +1.076031594e-02f, +6.740311631e-03f, +3.760513876e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.761254183e-04f, -2.410338005e-04f, -3.055670693e-04f, -3.629971201e-04f, -4.063875313e-04f, -4.294404412e-04f, -4.273319557e-04f, -3.974177623e-04f, -3.397033418e-04f, -2.570024759e-04f, -1.547496110e-04f, -4.047991444e-05f, +7.696177919e-05f, +1.883827791e-04f, +2.852499031e-04f, +3.606105449e-04f, +4.098081809e-04f, +4.309029143e-04f, +4.247501074e-04f, +3.947386096e-04f, +3.462371119e-04f, +2.858356777e-04f, +2.204939308e-04f, +1.567145163e-04f,
        /*  0, 6 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +4.582661915e-03f, +7.883833904e-03f, +1.222919107e-02f, +1.756307971e-02f, +2.371955116e-02f, +3.042531699e-02f, +3.731632621e-02f, +4.396688867e-02f, +4.992844718e-02f, +5.477361115e-02f, +5.814014479e-02f, +5.976940967e-02f, +5.953434487e-02f, +5.745335570e-02f, +5.368829633e-02f, +4.852681050e-02f, +4.235133456e-02f, +3.559877163e-02f, +2.871597079e-02f, +2.211653557e-02f, +1.614410278e-02f, +1.104615162e-02f, +6.960805562e-03f, +3.917228392e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.721951657e-04f, -2.369219327e-04f, -3.016692895e-04f, -3.597484994e-04f, -4.042118656e-04f, -4.286964203e-04f, -4.282635524e-04f, -4.001160478e-04f, -3.440856280e-04f, -2.628124281e-04f, -1.615791025e-04f, -4.781032135e-05f, +6.970393379e-05f, +1.817630045e-04f, +2.797639649e-04f, +3.566318012e-04f, +4.075507701e-04f, +4.304052395e-04f, +4.258801573e-04f, +3.972195913e-04f, +3.496891145e-04f, +2.898270411e-04f, +2.245949568e-04f, +1.605462403e-04f,
        /*  0, 7 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +4.410466750e-03f, +7.646911971e-03f, +1.192752178e-02f, +1.720333121e-02f, +2.331533930e-02f, +2.999662057e-02f, +3.688806266e-02f, +4.356677263e-02f, +4.958436155e-02f, +5.451079873e-02f, +5.797856569e-02f, +5.972159935e-02f, +5.960404880e-02f, +5.763511870e-02f, +5.396806029e-02f, +4.888344231e-02f, +4.275888533e-02f, +3.602917687e-02f, +2.914185094e-02f, +2.251375516e-02f, +1.649379190e-02f, +1.133597866e-02f, +7.185400519e-03f, +4.077774633e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.682877448e-04f, -2.328104765e-04f, -2.977455511e-04f, -3.564465022e-04f, -4.019576904e-04f, -4.278543613e-04f, -4.290860228e-04f, -4.027044898e-04f, -3.483684379e-04f, -2.685437043e-04f, -1.683591769e-04f, -5.512596196e-05f, +6.242458181e-05f, +1.750878111e-04f, +2.741947301e-04f, +3.525508042e-04f, +4.051828091e-04f, +4.297997704e-04f, +4.269152631e-04f, +3.996264454e-04f, +3.530928104e-04f, +2.937975659e-04f, +2.287009755e-04f, +1.644043723e-04f,
        /*  0, 8 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +4.242179005e-03f, +7.414101494e-03f, +1.162977623e-02f, +1.684688471e-02f, +2.291338161e-02f, +2.956876621e-02f, +3.645897664e-02f, +4.316406814e-02f, +4.923599311e-02f, +5.424225502e-02f, +5.781020651e-02f, +5.966647338e-02f, +5.966647338e-02f, +5.781020651e-02f, +5.424225502e-02f, +4.923599311e-02f, +4.316406814e-02f, +3.645897664e-02f, +2.956876621e-02f, +2.291338161e-02f, +1.684688471e-02f, +1.162977623e-02f, +7.414101494e-03f, +4.242179005e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.644043723e-04f, -2.287009755e-04f, -2.937975659e-04f, -3.530928104e-04f, -3.996264454e-04f, -4.269152631e-04f, -4.297997704e-04f, -4.051828091e-04f, -3.525508042e-04f, -2.741947301e-04f, -1.750878111e-04f, -6.242458181e-05f, +5.512596196e-05f, +1.683591769e-04f, +2.685437043e-04f, +3.483684379e-04f, +4.027044898e-04f, +4.290860228e-04f, +4.278543613e-04f, +4.019576904e-04f, +3.564465022e-04f, +2.977455511e-04f, +2.328104765e-04f, +1.682877448e-04f,
        /*  0, 9 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +4.077774633e-03f, +7.185400519e-03f, +1.133597866e-02f, +1.649379190e-02f, +2.251375516e-02f, +2.914185094e-02f, +3.602917687e-02f, +4.275888533e-02f, +4.888344231e-02f, +5.396806029e-02f, +5.763511870e-02f, +5.960404880e-02f, +5.972159935e-02f, +5.797856569e-02f, +5.451079873e-02f, +4.958436155e-02f, +4.356677263e-02f, +3.688806266e-02f, +2.999662057e-02f, +2.331533930e-02f, +1.720333121e-02f, +1.192752178e-02f, +7.646911971e-03f, +4.410466750e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.605462403e-04f, -2.245949568e-04f, -2.898270411e-04f, -3.496891145e-04f, -3.972195913e-04f, -4.258801573e-04f, -4.304052395e-04f, -4.075507701e-04f, -3.566318012e-04f, -2.797639649e-04f, -1.817630045e-04f, -6.970393379e-05f, +4.781032135e-05f, +1.615791025e-04f, +2.628124281e-04f, +3.440856280e-04f, +4.001160478e-04f, +4.282635524e-04f, +4.286964203e-04f, +4.042118656e-04f, +3.597484994e-04f, +3.016692895e-04f, +2.369219327e-04f, +1.721951657e-04f,
        /*  0,10 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +3.917228392e-03f, +6.960805562e-03f, +1.104615162e-02f, +1.614410278e-02f, +2.211653557e-02f, +2.871597079e-02f, +3.559877163e-02f, +4.235133456e-02f, +4.852681050e-02f, +5.368829633e-02f, +5.745335570e-02f, +5.953434487e-02f, +5.976940967e-02f, +5.814014479e-02f, +5.477361115e-02f, +4.992844718e-02f, +4.396688867e-02f, +3.731632621e-02f, +3.042531699e-02f, +2.371955116e-02f, +1.756307971e-02f, +1.222919107e-02f, +7.883833904e-03f, +4.582661915e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.567145163e-04f, -2.204939308e-04f, -2.858356777e-04f, -3.462371119e-04f, -3.947386096e-04f, -4.247501074e-04f, -4.309029143e-04f, -4.098081809e-04f, -3.606105449e-04f, -2.852499031e-04f, -1.883827791e-04f, -7.696177919e-05f, +4.047991444e-05f, +1.547496110e-04f, +2.570024759e-04f, +3.397033418e-04f, +3.974177623e-04f, +4.273319557e-04f, +4.294404412e-04f, +4.063875313e-04f, +3.629971201e-04f, +3.055670693e-04f, +2.410338005e-04f, +1.761254183e-04f,
        /*  0,11 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +3.760513876e-03f, +6.740311631e-03f, +1.076031594e-02f, +1.579786567e-02f, +2.172179696e-02f, +2.829122068e-02f, +3.516786871e-02f, +4.194152638e-02f, +4.816619996e-02f, +5.340304642e-02f, +5.726497292e-02f, +5.945738309e-02f, +5.980988958e-02f, +5.829489440e-02f, +5.503061363e-02f, +5.026815052e-02f, +4.436430644e-02f, +3.774365817e-02f, +3.085475743e-02f, +2.412593869e-02f, +1.792607683e-02f, +1.253475814e-02f, +8.124867704e-03f, +4.758787334e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.529103426e-04f, -2.163993902e-04f, -2.818251702e-04f, -3.427385065e-04f, -3.921850012e-04f, -4.235262086e-04f, -4.312933190e-04f, -4.119548933e-04f, -3.644861934e-04f, -2.906510740e-04f, -1.949451810e-04f, -8.419588858e-05f, +3.313700212e-05f, +1.478727465e-04f, +2.511154556e-04f, +3.352225880e-04f, +3.946099562e-04f, +4.262908700e-04f, +4.300854583e-04f, +4.084832700e-04f, +3.661906908e-04f, +3.094371743e-04f, +2.451445209e-04f, +1.800772619e-04f,
        /*  0,12 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +3.607603534e-03f, +6.523912241e-03f, +1.047849077e-02f, +1.545512716e-02f, +2.132961196e-02f, +2.786769447e-02f, +3.473657539e-02f, +4.152957148e-02f, +4.780171377e-02f, +5.311239535e-02f, +5.707002774e-02f, +5.937318720e-02f, +5.984302658e-02f, +5.844276715e-02f, +5.528172909e-02f, +5.060337311e-02f, +4.475891639e-02f, +3.816994904e-02f, +3.128484289e-02f, +2.453442196e-02f, +1.829226752e-02f, +1.284419531e-02f, +8.370012225e-03f, +4.938864596e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.491348359e-04f, -2.123128096e-04f, -2.777972061e-04f, -3.391950078e-04f, -3.895602860e-04f, -4.222095865e-04f, -4.315770173e-04f, -4.139908027e-04f, -3.682579471e-04f, -2.959660430e-04f, -2.014482809e-04f, -9.140404286e-05f, +2.578385067e-05f, +1.409505737e-04f, +2.451530077e-04f, +3.306444157e-04f, +3.916929963e-04f, +4.251399738e-04f, +4.306305397e-04f, +4.104976870e-04f, +3.693275483e-04f, +3.132778847e-04f, +2.492525195e-04f, +1.840494321e-04f,
        /*  0,13 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +3.458468698e-03f, +6.311599431e-03f, +1.020069357e-02f, +1.511593216e-02f, +2.094005167e-02f, +2.744548489e-02f, +3.430499838e-02f, +4.111558068e-02f, +4.743345582e-02f, +5.281642931e-02f, +5.686857946e-02f, +5.928178316e-02f, +5.986881044e-02f, +5.858371772e-02f, +5.552688209e-02f, +5.093401752e-02f, +4.515060939e-02f, +3.859508901e-02f, +3.171547343e-02f, +2.494491965e-02f, +1.866159507e-02f, +1.315747320e-02f, +8.619264745e-03f, +5.122914028e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.453890870e-04f, -2.082356450e-04f, -2.737534645e-04f, -3.356083300e-04f, -3.868660020e-04f, -4.208013970e-04f, -4.317546116e-04f, -4.159158478e-04f, -3.719250490e-04f, -3.011934115e-04f, -2.078901751e-04f, -9.858403415e-05f, +1.842273085e-05f, +1.339851768e-04f, +2.391168051e-04f, +3.259699149e-04f, +3.886672932e-04f, +4.238789874e-04f, +4.310747882e-04f, +4.124294112e-04f, +3.724060396e-04f, +3.170874784e-04f, +2.533562076e-04f, +1.880406414e-04f,
        /*  0,14 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +3.313079611e-03f, +6.103363786e-03f, +9.926940101e-03f, +1.478032383e-02f, +2.055318567e-02f, +2.702468349e-02f, +3.387324377e-02f, +4.069966483e-02f, +4.706153077e-02f, +5.251523590e-02f, +5.666068928e-02f, +5.918319912e-02f, +5.988723317e-02f, +5.871770290e-02f, +5.576599890e-02f, +5.125998744e-02f, +4.553927668e-02f, +3.901896800e-02f, +3.214654822e-02f, +2.535734906e-02f, +1.903400111e-02f, +1.347456067e-02f, +8.872620952e-03f, +5.310954669e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.416741607e-04f, -2.041693330e-04f, -2.696956158e-04f, -3.319801912e-04f, -3.841037044e-04f, -4.193028253e-04f, -4.318267432e-04f, -4.177300107e-04f, -3.754867850e-04f, -3.063318181e-04f, -2.142689858e-04f, -1.057336668e-04f, +1.105591687e-05f, +1.269786586e-04f, +2.330085517e-04f, +3.212002155e-04f, +3.855333010e-04f, +4.225076726e-04f, +4.314173415e-04f, +4.142770958e-04f, +3.754245234e-04f, +3.208642311e-04f, +2.574539829e-04f, +1.920495797e-04f,
        /*  0,15 (24) */
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        +3.171405450e-03f, +5.899194453e-03f, +9.657244486e-03f, +1.444834364e-02f, +2.016908197e-02f, +2.660538066e-02f, +3.344141702e-02f, +4.028193482e-02f, +4.668604398e-02f, +5.220890408e-02f, +5.644642030e-02f, +5.907746546e-02f, +5.989828908e-02f, +5.884468156e-02f, +5.599900745e-02f, +5.158118765e-02f, +4.592480998e-02f, +3.944147567e-02f, +3.257796556e-02f, +2.577162616e-02f, +1.940942563e-02f, +1.379542491e-02f, +9.130074935e-03f, +5.503004249e-03f,
        +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f, +0.000000000e+00f,
        -1.379910952e-04f, -2.001152905e-04f, -2.656253207e-04f, -3.283123126e-04f, -3.812749648e-04f, -4.177150854e-04f, -4.317940913e-04f, -4.194333165e-04f, -3.789424838e-04f, -3.113799387e-04f, -2.205828625e-04f, -1.128507582e-04f, +3.685685399e-06f, +1.199331400e-04f, +2.268299826e-04f, +3.163364871e-04f, +3.822915174e-04f, +4.210258335e-04f, +4.316573727e-04f, +4.160394191e-04f, +3.783813704e-04f, +3.246064176e-04f, +2.615442299e-04f, +1.960749141e-04f,
        /*  1, 0 (24) */
        +5.699079163e-03f, +9.391619165e-03f, +1.412003132e-02f, +1.978780700e-02f, +2.618766558e-02f, +3.300962293e-02f, +3.986250151e-02f, +4.630710150e-02f, +5.189752414e-02f, +5.622583743e-02f, +5.896461470e-02f, +5.990197477e-02f, +5.896461470e-02f, +5.622583743e-02f, +5.189752414e-02f, +4.630710150e-02f, +3.986250151e-02f, +3.300962293e-02f, +2.618766558e-02f, +1.978780700e-02f, +1.412003132e-02f, +9.391619165e-03f, +5.699079163e-03f, +3.033414355e-03f,
        -1.115631698e-02f, -1.514091868e-02f, -1.758178327e-02f, -1.720553350e-02f, -1.305312300e-02f, -4.789667122e-03f, +7.097937791e-03f, +2.128379168e-02f, +3.579087813e-02f, +4.835456220e-02f, +5.688256345e-02f, +5.990197477e-02f, +5.688256345e-02f, +4.835456220e-02f, +3.579087813e-02f, +2.128379168e-02f, +7.097937791e-03f, -4.789667122e-03f, -1.305312300e-02f, -1.720553350e-02f, -1.758178327e-02f, -1.514091868e-02f, -1.115631698e-02f, -6.883255437e-03f,
        -1.960749141e-04f, -2.615442299e-04f, -3.246064176e-04f, -3.783813704e-04f, -4.160394191e-04f, -4.316573727e-04f, -4.210258335e-04f, -3.822915174e-04f, -3.163364871e-04f, -2.268299826e-04f, -1.199331400e-04f, -3.685685399e-06f, +1.128507582e-04f, +2.205828625e-04f, +3.113799387e-04f, +3.789424838e-04f, +4.194333165e-04f, +4.317940913e-04f, +4.177150854e-04f, +3.812749648e-04f, +3.283123126e-04f, +2.656253207e-04f, +2.001152905e-04f, +1.379910952e-04f,
        +2.705482644e-04f, +2.175833157e-04f, +8.236166666e-05f, -1.267651157e-04f, -3.803727076e-04f, -6.320839735e-04f, -8.279297007e-04f, -9.188817989e-04f, -8.733813231e-04f, -6.864407641e-04f, -3.826490473e-04f, -1.197181021e-05f, +3.608162026e-04f, +6.704699924e-04f, +8.657334732e-04f, +9.202342634e-04f, +8.371263083e-04f, +6.465221071e-04f, +3.967060483e-04f, +1.417231279e-04f, -7.125445421e-05f, -2.115618514e-04f, -2.695204175e-04f, -2.551871856e-04f,
        /*  1, 1 (24) */
        +5.503004249e-03f, +9.130074935e-03f, +1.379542491e-02f, +1.940942563e-02f, +2.577162616e-02f, +3.257796556e-02f, +3.944147567e-02f, +4.592480998e-02f, +5.158118765e-02f, +5.599900745e-02f, +5.884468156e-02f, +5.989828908e-02f, +5.907746546e-02f, +5.644642030e-02f, +5.220890408e-02f, +4.668604398e-02f, +4.028193482e-02f, +3.344141702e-02f, +2.660538066e-02f, +2.016908197e-02f, +1.444834364e-02f, +9.657244486e-03f, +5.899194453e-03f, +3.171405450e-03f,
        -1.088576871e-02f, -1.492333537e-02f, -1.749942161e-02f, -1.733229861e-02f, -1.343349571e-02f, -5.421751096e-03f, +6.270008090e-03f, +2.036490988e-02f, +3.491749681e-02f, +4.766812144e-02f, +5.649991440e-02f, +5.989000296e-02f, +5.724337965e-02f, +4.902503219e-02f, +3.665661161e-02f, +2.220402594e-02f, +7.935064099e-03f, -4.143145015e-03f, -1.265641695e-02f, -1.706381037e-02f, -1.765303773e-02f, -1.535248053e-02f, -1.142583740e-02f, -7.138442622e-03f,
        -1.920495797e-04f, -2.574539829e-04f, -3.208642311e-04f, -3.754245234e-04f, -4.142770958e-04f, -4.314173415e-04f, -4.225076726e-04f, -3.855333010e-04f, -3.212002155e-04f, -2.330085517e-04f, -1.269786586e-04f, -1.105591687e-05f, +1.057336668e-04f, +2.142689858e-04f, +3.063318181e-04f, +3.754867850e-04f, +4.177300107e-04f, +4.318267432e-04f, +4.193028253e-04f, +3.841037044e-04f, +3.319801912e-04f, +2.696956158e-04f, +2.041693330e-04f, +1.416741607e-04f,
        +2.712938608e-04f, +2.232769411e-04f, +9.317309612e-05f, -1.119865916e-04f, -3.640345662e-04f, -6.174260146e-04f, -8.183175346e-04f, -9.169874259e-04f, -8.804667570e-04f, -7.019465696e-04f, -4.042156479e-04f, -3.590702749e-05f, +3.387320427e-04f, +6.540440323e-04f, +8.575258695e-04f, +9.210401721e-04f, +8.458969541e-04f, +6.607270683e-04f, +4.130215719e-04f, +1.568508104e-04f, -5.985630987e-05f, -2.052121014e-04f, -2.682055987e-04f, -2.577951457e-04f,
        /*  1, 2 (24) */
        +5.310954669e-03f, +8.872620952e-03f, +1.347456067e-02f, +1.903400111e-02f, +2.535734906e-02f, +3.214654822e-02f, +3.901896800e-02f, +4.553927668e-02f, +5.125998744e-02f, +5.576599890e-02f, +5.871770290e-02f, +5.988723317e-02f, +5.918319912e-02f, +5.666068928e-02f, +5.251523590e-02f, +4.706153077e-02f, +4.069966483e-02f, +3.387324377e-02f, +2.702468349e-02f, +2.055318567e-02f, +1.478032383e-02f, +9.926940101e-03f, +6.103363786e-03f, +3.313079611e-03f,
        -1.061447485e-02f, -1.470005842e-02f, -1.740624851e-02f, -1.744428520e-02f, -1.379753027e-02f, -6.039177110e-03f, +5.451690556e-03f, +1.944792245e-02f, +3.403703005e-02f, +4.696617487e-02f, +5.609569875e-02f, +5.985409593e-02f, +5.758211169e-02f, +4.967907622e-02f, +3.751413748e-02f, +2.312506611e-02f, +8.780961054e-03f, -3.482417947e-03f, -1.224339538e-02f, -1.690695956e-02f, -1.771289404e-02f, -1.555769263e-02f, -1.169404300e-02f, -7.396237768e-03f,
        -1.880406414e-04f, -2.533562076e-04f, -3.170874784e-04f, -3.724060396e-04f, -4.124294112e-04f, -4.310747882e-04f, -4.238789874e-04f, -3.886672932e-04f, -3.259699149e-04f, -2.391168051e-04f, -1.339851768e-04f, -1.842273085e-05f, +9.858403415e-05f, +2.078901751e-04f, +3.011934115e-04f, +3.719250490e-04f, +4.159158478e-04f, +4.317546116e-04f, +4.208013970e-04f, +3.868660020e-04f, +3.356083300e-04f, +2.737534645e-04f, +2.082356450e-04f, +1.453890870e-04f,
        +2.717621372e-04f, +2.286434837e-04f, +1.036842282e-04f, -9.739710104e-05f, -3.477045164e-04f, -6.025616528e-04f, -8.083004890e-04f, -9.145562136e-04f, -8.869875835e-04f, -7.169780354e-04f, -4.255013118e-04f, -5.981704284e-05f, +3.164117194e-04f, +6.371730579e-04f, +8.487616438e-04f, +9.212953056e-04f, +8.542315214e-04f, +6.746855984e-04f, +4.293061488e-04f, +1.721380793e-04f, -4.817242024e-05f, -1.985339325e-04f, -2.665993037e-04f, -2.602051597e-04f,
        /*  1, 3 (24) */
        +5.122914028e-03f, +8.619264745e-03f, +1.315747320e-02f, +1.866159507e-02f, +2.494491965e-02f, +3.171547343e-02f, +3.859508901e-02f, +4.515060939e-02f, +5.093401752e-02f, +5.552688209e-02f, +5.858371772e-02f, +5.986881044e-02f, +5.928178316e-02f, +5.686857946e-02f, +5.281642931e-02f, +4.743345582e-02f, +4.111558068e-02f, +3.430499838e-02f, +2.744548489e-02f, +2.094005167e-02f, +1.511593216e-02f, +1.020069357e-02f, +6.311599431e-03f, +3.458468698e-03f,
        -1.034271272e-02f, -1.447141494e-02f, -1.730256428e-02f, -1.754168230e-02f, -1.414523479e-02f, -6.641738763e-03f, +4.643390067e-03f, +1.853336624e-02f, +3.315004247e-02f, +4.624919683e-02f, +5.567019744e-02f, +5.979427889e-02f, +5.789852341e-02f, +5.031624928e-02f, +3.836289912e-02f, +2.404636142e-02f, +9.635192575e-03f, -2.807732349e-03f, -1.181408923e-02f, -1.673482148e-02f, -1.776106646e-02f, -1.575622657e-02f, -1.196064230e-02f, -7.656442928e-03f,
        -1.840494321e-04f, -2.492525195e-04f, -3.132778847e-04f, -3.693275483e-04f, -4.104976870e-04f, -4.306305397e-04f, -4.251399738e-04f, -3.916929963e-04f, -3.306444157e-04f, -2.451530077e-04f, -1.409505737e-04f, -2.578385067e-05f, +9.140404286e-05f, +2.014482809e-04f, +2.959660430e-04f, +3.682579471e-04f, +4.139908027e-04f, +4.315770173e-04f, +4.222095865e-04f, +3.895602860e-04f, +3.391950078e-04f, +2.777972061e-04f, +2.123128096e-04f, +1.491348359e-04f,
        +2.719582255e-04f, +2.336840048e-04f, +1.138908863e-04f, -8.300591000e-05f, -3.313953148e-04f, -5.875043727e-04f, -7.978895069e-04f, -9.115936458e-04f, -8.929420818e-04f, -7.315261995e-04f, -4.464915949e-04f, -8.368507996e-05f, +2.938705940e-04f, +6.198676315e-04f, +8.394443961e-04f, +9.209958781e-04f, +8.621201918e-04f, +6.883845401e-04f, +4.455465481e-04f, +1.875745925e-04f, -3.620830577e-05f, -1.915275290e-04f, -2.646972525e-04f, -2.624103371e-04f,
        /*  1, 4 (24) */
        +4.938864596e-03f, +8.370012225e-03f, +1.284419531e-02f, +1.829226752e-02f, +2.453442196e-02f, +3.128484289e-02f, +3.816994904e-02f, +4.475891639e-02f, +5.060337311e-02f, +5.528172909e-02f, +5.844276715e-02f, +5.984302658e-02f, +5.937318720e-02f, +5.707002774e-02f, +5.311239535e-02f, +4.780171377e-02f, +4.152957148e-02f, +3.473657539e-02f, +2.786769447e-02f, +2.132961196e-02f, +1.545512716e-02f, +1.047849077e-02f, +6.523912241e-03f, +3.607603534e-03f,
        -1.007075449e-02f, -1.423773094e-02f, -1.718867340e-02f, -1.762468821e-02f, -1.447663011e-02f, -7.229243136e-03f, +3.845500560e-03f, +1.762177259e-02f, +3.225710039e-02f, +4.551767063e-02f, +5.522370585e-02f, +5.971059381e-02f, +5.819239401e-02f, +5.093611691e-02f, +3.920234351e-02f, +2.496735730e-02f, +1.049731277e-02f, -2.119347808e-03f, -1.136854268e-02f, -1.654724689e-02f, -1.779727476e-02f, -1.594775410e-02f, -1.222533955e-02f, -7.918853265e-03f,
        -1.800772619e-04f, -2.451445209e-04f, -3.094371743e-04f, -3.661906908e-04f, -4.084832700e-04f, -4.300854583e-04f, -4.262908700e-04f, -3.946099562e-04f, -3.352225880e-04f, -2.511154556e-04f, -1.478727465e-04f, -3.313700212e-05f, +8.419588858e-05f, +1.949451810e-04f, +2.906510740e-04f, +3.644861934e-04f, +4.119548933e-04f, +4.312933190e-04f, +4.235262086e-04f, +3.921850012e-04f, +3.427385065e-04f, +2.818251702e-04f, +2.163993902e-04f, +1.529103426e-04f,
        +2.718874504e-04f, +2.383998657e-04f, +1.237892318e-04f, -6.882199867e-05f, -3.151195712e-04f, -5.722677081e-04f, -7.870957839e-04f, -9.081056146e-04f, -8.983290016e-04f, -7.455825185e-04f, -4.671723146e-04f, -1.074944000e-04f, +2.711242241e-04f, +6.021386948e-04f, +8.295781937e-04f, +9.201385428e-04f, +8.695534551e-04f, +7.018108507e-04f, +4.617294493e-04f, +2.031497574e-04f, -2.396981877e-05f, -1.841933961e-04f, -2.624953972e-04f, -2.644038865e-04f,
        /*  1, 5 (24) */
        +4.758787334e-03f, +8.124867704e-03f, +1.253475814e-02f, +1.792607683e-02f, +2.412593869e-02f, +3.085475743e-02f, +3.774365817e-02f, +4.436430644e-02f, +5.026815052e-02f, +5.503061363e-02f, +5.829489440e-02f, +5.980988958e-02f, +5.945738309e-02f, +5.726497292e-02f, +5.340304642e-02f, +4.816619996e-02f, +4.194152638e-02f, +3.516786871e-02f, +2.829122068e-02f, +2.172179696e-02f, +1.579786567e-02f, +1.076031594e-02f, +6.740311631e-03f, +3.760513876e-03f,
        -9.798867041e-03f, -1.399933107e-02f, -1.706488416e-02f, -1.769351021e-02f, -1.479174968e-02f, -7.801510844e-03f, +3.058404776e-03f, +1.671366698e-02f, +3.135877139e-02f, +4.477208811e-02f, +5.475653353e-02f, +5.960309941e-02f, +5.846351823e-02f, +5.153825561e-02f, +4.003192171e-02f, +2.588749584e-02f, +1.136686622e-02f, -1.417536958e-03f, -1.090681323e-02f, -1.634409713e-02f, -1.782124458e-02f, -1.613194749e-02f, -1.248783495e-02f, -8.183257151e-03f,
        -1.761254183e-04f, -2.410338005e-04f, -3.055670693e-04f, -3.629971201e-04f, -4.063875313e-04f, -4.294404412e-04f, -4.273319557e-04f, -3.974177623e-04f, -3.397033418e-04f, -2.570024759e-04f, -1.547496110e-04f, -4.047991444e-05f, +7.696177919e-05f, +1.883827791e-04f, +2.852499031e-04f, +3.606105449e-04f, +4.098081809e-04f, +4.309029143e-04f, +4.247501074e-04f, +3.947386096e-04f, +3.462371119e-04f, +2.858356777e-04f, +2.204939308e-04f, +1.567145163e-04f,
        +2.715553220e-04f, +2.427927233e-04f, +1.333757646e-04f, -5.485405554e-05f, -2.988897381e-04f, -5.568652287e-04f, -7.759307559e-04f, -9.040984124e-04f, -9.031475626e-04f, -7.591388741e-04f, -4.875295623e-04f, -1.312283164e-04f, +2.481883498e-04f, +5.839975600e-04f, +8.191675683e-04f, +9.187203972e-04f, +8.765221205e-04f, +7.149516148e-04f, +4.778414546e-04f, +2.188527386e-04f, -1.146314106e-05f, -1.765323633e-04f, -2.599899292e-04f, -2.661791237e-04f,
        /*  1, 6 (24) */
        +4.582661915e-03f, +7.883833904e-03f, +1.222919107e-02f, +1.756307971e-02f, +2.371955116e-02f, +3.042531699e-02f, +3.731632621e-02f, +4.396688867e-02f, +4.992844718e-02f, +5.477361115e-02f, +5.814014479e-02f, +5.976940967e-02f, +5.953434487e-02f, +5.745335570e-02f, +5.368829633e-02f, +4.852681050e-02f, +4.235133456e-02f, +3.559877163e-02f, +2.871597079e-02f, +2.211653557e-02f, +1.614410278e-02f, +1.104615162e-02f, +6.960805562e-03f, +3.917228392e-03f,
        -9.527311719e-03f, -1.375653835e-02f, -1.693150840e-02f, -1.774836427e-02f, -1.509063942e-02f, -8.358376073e-03f, +2.282474020e-03f, +1.580956857e-02f, +3.045562382e-02f, +4.401294924e-02f, +5.426900397e-02f, +5.947187109e-02f, +5.871170658e-02f, +5.212225317e-02f, +4.085108928e-02f, +2.680621624e-02f, +1.224338834e-02f, -7.025853429e-04f, -1.042897178e-02f, -1.612524439e-02f, -1.783270772e-02f, -1.630847986e-02f, -1.274782488e-02f, -8.449436275e-03f,
        -1.721951657e-04f, -2.369219327e-04f, -3.016692895e-04f, -3.597484994e-04f, -4.042118656e-04f, -4.286964203e-04f, -4.282635524e-04f, -4.001160478e-04f, -3.440856280e-04f, -2.628124281e-04f, -1.615791025e-04f, -4.781032135e-05f, +6.970393379e-05f, +1.817630045e-04f, +2.797639649e-04f, +3.566318012e-04f, +4.075507701e-04f, +4.304052395e-04f, +4.258801573e-04f, +3.972195913e-04f, +3.496891145e-04f, +2.898270411e-04f, +2.245949568e-04f, +1.605462403e-04f,
        +2.709675269e-04f, +2.468645241e-04f, +1.426473226e-04f, -4.111047175e-05f, -2.827181000e-04f, -5.413105277e-04f, -7.644060876e-04f, -8.995787250e-04f, -9.073974534e-04f, -7.721875796e-04f, -5.075497148e-04f, -1.548702100e-04f, +2.250788795e-04f, +5.654559003e-04f, +8.082175138e-04f, +9.167389877e-04f, +8.830173267e-04f, +7.277940577e-04f, +4.938691005e-04f, +2.346724664e-04f, +1.305218783e-06f, -1.685455871e-04f, -2.571772862e-04f, -2.677294810e-04f,
        /*  1, 7 (24) */
        +4.410466750e-03f, +7.646911971e-03f, +1.192752178e-02f, +1.720333121e-02f, +2.331533930e-02f, +2.999662057e-02f, +3.688806266e-02f, +4.356677263e-02f, +4.958436155e-02f, +5.451079873e-02f, +5.797856569e-02f, +5.972159935e-02f, +5.960404880e-02f, +5.763511870e-02f, +5.396806029e-02f, +4.888344231e-02f, +4.275888533e-02f, +3.602917687e-02f, +2.914185094e-02f, +2.251375516e-02f, +1.649379190e-02f, +1.133597866e-02f, +7.185400519e-03f, +4.077774633e-03f,
        -9.256344192e-03f, -1.350967382e-02f, -1.678886108e-02f, -1.778947474e-02f, -1.537335752e-02f, -8.899686600e-03f, +1.518067933e-03f, +1.490998984e-02f, +2.954822637e-02f, +4.324076166e-02f, +5.376145426e-02f, +5.931700088e-02f, +5.893678546e-02f, +5.268770907e-02f, +4.165930679e-02f, +2.772295523e-02f, +1.312640567e-02f, +2.520871482e-05f, -9.935102679e-03f, -1.589057192e-02f, -1.783140250e-02f, -1.647702544e-02f, -1.300500216e-02f, -8.717165756e-03f,
        -1.682877448e-04f, -2.328104765e-04f, -2.977455511e-04f, -3.564465022e-04f, -4.019576904e-04f, -4.278543613e-04f, -4.290860228e-04f, -4.027044898e-04f, -3.483684379e-04f, -2.685437043e-04f, -1.683591769e-04f, -5.512596196e-05f, +6.242458181e-05f, +1.750878111e-04f, +2.741947301e-04f, +3.525508042e-04f, +4.051828091e-04f, +4.297997704e-04f, +4.269152631e-04f, +3.996264454e-04f, +3.530928104e-04f, +2.937975659e-04f, +2.287009755e-04f, +1.644043723e-04f,
        +2.701299199e-04f, +2.506174995e-04f, +1.516010816e-04f, -2.759933578e-05f, -2.666167631e-04f, -5.256172082e-04f, -7.525336599e-04f, -8.945536224e-04f, -9.110788299e-04f, -7.847213850e-04f, -5.272194464e-04f, -1.784035434e-04f, +2.018118763e-04f, +5.465257405e-04f, +7.967334832e-04f, +9.141923133e-04f, +8.890305516e-04f, +7.403255578e-04f, +5.097988707e-04f, +2.505976453e-04f, +1.432842854e-05f, -1.602345538e-04f, -2.540541594e-04f, -2.690485160e-04f,
        /*  1, 8 (24) */
        +4.242179005e-03f, +7.414101494e-03f, +1.162977623e-02f, +1.684688471e-02f, +2.291338161e-02f, +2.956876621e-02f, +3.645897664e-02f, +4.316406814e-02f, +4.923599311e-02f, +5.424225502e-02f, +5.781020651e-02f, +5.966647338e-02f, +5.966647338e-02f, +5.781020651e-02f, +5.424225502e-02f, +4.923599311e-02f, +4.316406814e-02f, +3.645897664e-02f, +2.956876621e-02f, +2.291338161e-02f, +1.684688471e-02f, +1.162977623e-02f, +7.414101494e-03f, +4.242179005e-03f,
        -8.986214272e-03f, -1.325905632e-02f, -1.663726000e-02f, -1.781707408e-02f, -1.563997428e-02f, -9.425303809e-03f, +7.655342726e-04f, +1.401543622e-02f, +2.863714754e-02f, +4.245604027e-02f, +5.323423481e-02f, +5.913859734e-02f, +5.913859734e-02f, +5.323423481e-02f, +4.245604027e-02f, +2.863714754e-02f, +1.401543622e-02f, +7.655342726e-04f, -9.425303809e-03f, -1.563997428e-02f, -1.781707408e-02f, -1.663726000e-02f, -1.325905632e-02f, -8.986214272e-03f,
        -1.644043723e-04f, -2.287009755e-04f, -2.937975659e-04f, -3.530928104e-04f, -3.996264454e-04f, -4.269152631e-04f, -4.297997704e-04f, -4.051828091e-04f, -3.525508042e-04f, -2.741947301e-04f, -1.750878111e-04f, -6.242458181e-05f, +5.512596196e-05f, +1.683591769e-04f, +2.685437043e-04f, +3.483684379e-04f, +4.027044898e-04f, +4.290860228e-04f, +4.278543613e-04f, +4.019576904e-04f, +3.564465022e-04f, +2.977455511e-04f, +2.328104765e-04f, +1.682877448e-04f,
        +2.690485160e-04f, +2.540541594e-04f, +1.602345538e-04f, -1.432842854e-05f, -2.505976453e-04f, -5.097988707e-04f, -7.403255578e-04f, -8.890305516e-04f, -9.141923133e-04f, -7.967334832e-04f, -5.465257405e-04f, -2.018118763e-04f, +1.784035434e-04f, +5.272194464e-04f, +7.847213850e-04f, +9.110788299e-04f, +8.945536224e-04f, +7.525336599e-04f, +5.256172082e-04f, +2.666167631e-04f, +2.759933578e-05f, -1.516010816e-04f, -2.506174995e-04f, -2.701299199e-04f,
        /*  1, 9 (24) */
        +4.077774633e-03f, +7.185400519e-03f, +1.133597866e-02f, +1.649379190e-02f, +2.251375516e-02f, +2.914185094e-02f, +3.602917687e-02f, +4.275888533e-02f, +4.888344231e-02f, +5.396806029e-02f, +5.763511870e-02f, +5.960404880e-02f, +5.972159935e-02f, +5.797856569e-02f, +5.451079873e-02f, +4.958436155e-02f, +4.356677263e-02f, +3.688806266e-02f, +2.999662057e-02f, +2.331533930e-02f, +1.720333121e-02f, +1.192752178e-02f, +7.646911971e-03f, +4.410466750e-03f,
        -8.717165756e-03f, -1.300500216e-02f, -1.647702544e-02f, -1.783140250e-02f, -1.589057192e-02f, -9.935102679e-03f, +2.520871482e-05f, +1.312640567e-02f, +2.772295523e-02f, +4.165930679e-02f, +5.268770907e-02f, +5.893678546e-02f, +5.931700088e-02f, +5.376145426e-02f, +4.324076166e-02f, +2.954822637e-02f, +1.490998984e-02f, +1.518067933e-03f, -8.899686600e-03f, -1.537335752e-02f, -1.778947474e-02f, -1.678886108e-02f, -1.350967382e-02f, -9.256344192e-03f,
        -1.605462403e-04f, -2.245949568e-04f, -2.898270411e-04f, -3.496891145e-04f, -3.972195913e-04f, -4.258801573e-04f, -4.304052395e-04f, -4.075507701e-04f, -3.566318012e-04f, -2.797639649e-04f, -1.817630045e-04f, -6.970393379e-05f, +4.781032135e-05f, +1.615791025e-04f, +2.628124281e-04f, +3.440856280e-04f, +4.001160478e-04f, +4.282635524e-04f, +4.286964203e-04f, +4.042118656e-04f, +3.597484994e-04f, +3.016692895e-04f, +2.369219327e-04f, +1.721951657e-04f,
        +2.677294810e-04f, +2.571772862e-04f, +1.685455871e-04f, -1.305218783e-06f, -2.346724664e-04f, -4.938691005e-04f, -7.277940577e-04f, -8.830173267e-04f, -9.167389877e-04f, -8.082175138e-04f, -5.654559003e-04f, -2.250788795e-04f, +1.548702100e-04f, +5.075497148e-04f, +7.721875796e-04f, +9.073974534e-04f, +8.995787250e-04f, +7.644060876e-04f, +5.413105277e-04f, +2.827181000e-04f, +4.111047175e-05f, -1.426473226e-04f, -2.468645241e-04f, -2.709675269e-04f,
        /*  1,10 (24) */
        +3.917228392e-03f, +6.960805562e-03f, +1.104615162e-02f, +1.614410278e-02f, +2.211653557e-02f, +2.871597079e-02f, +3.559877163e-02f, +4.235133456e-02f, +4.852681050e-02f, +5.368829633e-02f, +5.745335570e-02f, +5.953434487e-02f, +5.976940967e-02f, +5.814014479e-02f, +5.477361115e-02f, +4.992844718e-02f, +4.396688867e-02f, +3.731632621e-02f, +3.042531699e-02f, +2.371955116e-02f, +1.756307971e-02f, +1.222919107e-02f, +7.883833904e-03f, +4.582661915e-03f,
        -8.449436275e-03f, -1.274782488e-02f, -1.630847986e-02f, -1.783270772e-02f, -1.612524439e-02f, -1.042897178e-02f, -7.025853429e-04f, +1.224338834e-02f, +2.680621624e-02f, +4.085108928e-02f, +5.212225317e-02f, +5.871170658e-02f, +5.947187109e-02f, +5.426900397e-02f, +4.401294924e-02f, +3.045562382e-02f, +1.580956857e-02f, +2.282474020e-03f, -8.358376073e-03f, -1.509063942e-02f, -1.774836427e-02f, -1.693150840e-02f, -1.375653835e-02f, -9.527311719e-03f,
        -1.567145163e-04f, -2.204939308e-04f, -2.858356777e-04f, -3.462371119e-04f, -3.947386096e-04f, -4.247501074e-04f, -4.309029143e-04f, -4.098081809e-04f, -3.606105449e-04f, -2.852499031e-04f, -1.883827791e-04f, -7.696177919e-05f, +4.047991444e-05f, +1.547496110e-04f, +2.570024759e-04f, +3.397033418e-04f, +3.974177623e-04f, +4.273319557e-04f, +4.294404412e-04f, +4.063875313e-04f, +3.629971201e-04f, +3.055670693e-04f, +2.410338005e-04f, +1.761254183e-04f,
        +2.661791237e-04f, +2.599899292e-04f, +1.765323633e-04f, +1.146314106e-05f, -2.188527386e-04f, -4.778414546e-04f, -7.149516148e-04f, -8.765221205e-04f, -9.187203972e-04f, -8.191675683e-04f, -5.839975600e-04f, -2.481883498e-04f, +1.312283164e-04f, +4.875295623e-04f, +7.591388741e-04f, +9.031475626e-04f, +9.040984124e-04f, +7.759307559e-04f, +5.568652287e-04f, +2.988897381e-04f, +5.485405554e-05f, -1.333757646e-04f, -2.427927233e-04f, -2.715553220e-04f,
        /*  1,11 (24) */
        +3.760513876e-03f, +6.740311631e-03f, +1.076031594e-02f, +1.579786567e-02f, +2.172179696e-02f, +2.829122068e-02f, +3.516786871e-02f, +4.194152638e-02f, +4.816619996e-02f, +5.340304642e-02f, +5.726497292e-02f, +5.945738309e-02f, +5.980988958e-02f, +5.829489440e-02f, +5.503061363e-02f, +5.026815052e-02f, +4.436430644e-02f, +3.774365817e-02f, +3.085475743e-02f, +2.412593869e-02f, +1.792607683e-02f, +1.253475814e-02f, +8.124867704e-03f, +4.758787334e-03f,
        -8.183257151e-03f, -1.248783495e-02f, -1.613194749e-02f, -1.782124458e-02f, -1.634409713e-02f, -1.090681323e-02f, -1.417536958e-03f, +1.136686622e-02f, +2.588749584e-02f, +4.003192171e-02f, +5.153825561e-02f, +5.846351823e-02f, +5.960309941e-02f, +5.475653353e-02f, +4.477208811e-02f, +3.135877139e-02f, +1.671366698e-02f, +3.058404776e-03f, -7.801510844e-03f, -1.479174968e-02f, -1.769351021e-02f, -1.706488416e-02f, -1.399933107e-02f, -9.798867041e-03f,
        -1.529103426e-04f, -2.163993902e-04f, -2.818251702e-04f, -3.427385065e-04f, -3.921850012e-04f, -4.235262086e-04f, -4.312933190e-04f, -4.119548933e-04f, -3.644861934e-04f, -2.906510740e-04f, -1.949451810e-04f, -8.419588858e-05f, +3.313700212e-05f, +1.478727465e-04f, +2.511154556e-04f, +3.352225880e-04f, +3.946099562e-04f, +4.262908700e-04f, +4.300854583e-04f, +4.084832700e-04f, +3.661906908e-04f, +3.094371743e-04f, +2.451445209e-04f, +1.800772619e-04f,
        +2.644038865e-04f, +2.624953972e-04f, +1.841933961e-04f, +2.396981877e-05f, -2.031497574e-04f, -4.617294493e-04f, -7.018108507e-04f, -8.695534551e-04f, -9.201385428e-04f, -8.295781937e-04f, -6.021386948e-04f, -2.711242241e-04f, +1.074944000e-04f, +4.671723146e-04f, +7.455825185e-04f, +8.983290016e-04f, +9.081056146e-04f, +7.870957839e-04f, +5.722677081e-04f, +3.151195712e-04f, +6.882199867e-05f, -1.237892318e-04f, -2.383998657e-04f, -2.718874504e-04f,
        /*  1,12 (24) */
        +3.607603534e-03f, +6.523912241e-03f, +1.047849077e-02f, +1.545512716e-02f, +2.132961196e-02f, +2.786769447e-02f, +3.473657539e-02f, +4.152957148e-02f, +4.780171377e-02f, +5.311239535e-02f, +5.707002774e-02f, +5.937318720e-02f, +5.984302658e-02f, +5.844276715e-02f, +5.528172909e-02f, +5.060337311e-02f, +4.475891639e-02f, +3.816994904e-02f, +3.128484289e-02f, +2.453442196e-02f, +1.829226752e-02f, +1.284419531e-02f, +8.370012225e-03f, +4.938864596e-03f,
        -7.918853265e-03f, -1.222533955e-02f, -1.594775410e-02f, -1.779727476e-02f, -1.654724689e-02f, -1.136854268e-02f, -2.119347808e-03f, +1.049731277e-02f, +2.496735730e-02f, +3.920234351e-02f, +5.093611691e-02f, +5.819239401e-02f, +5.971059381e-02f, +5.522370585e-02f, +4.551767063e-02f, +3.225710039e-02f, +1.762177259e-02f, +3.845500560e-03f, -7.229243136e-03f, -1.447663011e-02f, -1.762468821e-02f, -1.718867340e-02f, -1.423773094e-02f, -1.007075449e-02f,
        -1.491348359e-04f, -2.123128096e-04f, -2.777972061e-04f, -3.391950078e-04f, -3.895602860e-04f, -4.222095865e-04f, -4.315770173e-04f, -4.139908027e-04f, -3.682579471e-04f, -2.959660430e-04f, -2.014482809e-04f, -9.140404286e-05f, +2.578385067e-05f, +1.409505737e-04f, +2.451530077e-04f, +3.306444157e-04f, +3.916929963e-04f, +4.251399738e-04f, +4.306305397e-04f, +4.104976870e-04f, +3.693275483e-04f, +3.132778847e-04f, +2.492525195e-04f, +1.840494321e-04f,
        +2.624103371e-04f, +2.646972525e-04f, +1.915275290e-04f, +3.620830577e-05f, -1.875745925e-04f, -4.455465481e-04f, -6.883845401e-04f, -8.621201918e-04f, -9.209958781e-04f, -8.394443961e-04f, -6.198676315e-04f, -2.938705940e-04f, +8.368507996e-05f, +4.464915949e-04f, +7.315261995e-04f, +8.929420818e-04f, +9.115936458e-04f, +7.978895069e-04f, +5.875043727e-04f, +3.313953148e-04f, +8.300591000e-05f, -1.138908863e-04f, -2.336840048e-04f, -2.719582255e-04f,
        /*  1,13 (24) */
        +3.458468698e-03f, +6.311599431e-03f, +1.020069357e-02f, +1.511593216e-02f, +2.094005167e-02f, +2.744548489e-02f, +3.430499838e-02f, +4.111558068e-02f, +4.743345582e-02f, +5.281642931e-02f, +5.686857946e-02f, +5.928178316e-02f, +5.986881044e-02f, +5.858371772e-02f, +5.552688209e-02f, +5.093401752e-02f, +4.515060939e-02f, +3.859508901e-02f, +3.171547343e-02f, +2.494491965e-02f, +1.866159507e-02f, +1.315747320e-02f, +8.619264745e-03f, +5.122914028e-03f,
        -7.656442928e-03f, -1.196064230e-02f, -1.575622657e-02f, -1.776106646e-02f, -1.673482148e-02f, -1.181408923e-02f, -2.807732349e-03f, +9.635192575e-03f, +2.404636142e-02f, +3.836289912e-02f, +5.031624928e-02f, +5.789852341e-02f, +5.979427889e-02f, +5.567019744e-02f, +4.624919683e-02f, +3.315004247e-02f, +1.853336624e-02f, +4.643390067e-03f, -6.641738763e-03f, -1.414523479e-02f, -1.754168230e-02f, -1.730256428e-02f, -1.447141494e-02f, -1.034271272e-02f,
        -1.453890870e-04f, -2.082356450e-04f, -2.737534645e-04f, -3.356083300e-04f, -3.868660020e-04f, -4.208013970e-04f, -4.317546116e-04f, -4.159158478e-04f, -3.719250490e-04f, -3.011934115e-04f, -2.078901751e-04f, -9.858403415e-05f, +1.842273085e-05f, +1.339851768e-04f, +2.391168051e-04f, +3.259699149e-04f, +3.886672932e-04f, +4.238789874e-04f, +4.310747882e-04f, +4.124294112e-04f, +3.724060396e-04f, +3.170874784e-04f, +2.533562076e-04f, +1.880406414e-04f,
        +2.602051597e-04f, +2.665993037e-04f, +1.985339325e-04f, +4.817242024e-05f, -1.721380793e-04f, -4.293061488e-04f, -6.746855984e-04f, -8.542315214e-04f, -9.212953056e-04f, -8.487616438e-04f, -6.371730579e-04f, -3.164117194e-04f, +5.981704284e-05f, +4.255013118e-04f, +7.169780354e-04f, +8.869875835e-04f, +9.145562136e-04f, +8.083004890e-04f, +6.025616528e-04f, +3.477045164e-04f, +9.739710104e-05f, -1.036842282e-04f, -2.286434837e-04f, -2.717621372e-04f,
        /*  1,14 (24) */
        +3.313079611e-03f, +6.103363786e-03f, +9.926940101e-03f, +1.478032383e-02f, +2.055318567e-02f, +2.702468349e-02f, +3.387324377e-02f, +4.069966483e-02f, +4.706153077e-02f, +5.251523590e-02f, +5.666068928e-02f, +5.918319912e-02f, +5.988723317e-02f, +5.871770290e-02f, +5.576599890e-02f, +5.125998744e-02f, +4.553927668e-02f, +3.901896800e-02f, +3.214654822e-02f, +2.535734906e-02f, +1.903400111e-02f, +1.347456067e-02f, +8.872620952e-03f, +5.310954669e-03f,
        -7.396237768e-03f, -1.169404300e-02f, -1.555769263e-02f, -1.771289404e-02f, -1.690695956e-02f, -1.224339538e-02f, -3.482417947e-03f, +8.780961054e-03f, +2.312506611e-02f, +3.751413748e-02f, +4.967907622e-02f, +5.758211169e-02f, +5.985409593e-02f, +5.609569875e-02f, +4.696617487e-02f, +3.403703005e-02f, +1.944792245e-02f, +5.451690556e-03f, -6.039177110e-03f, -1.379753027e-02f, -1.744428520e-02f, -1.740624851e-02f, -1.470005842e-02f, -1.061447485e-02f,
        -1.416741607e-04f, -2.041693330e-04f, -2.696956158e-04f, -3.319801912e-04f, -3.841037044e-04f, -4.193028253e-04f, -4.318267432e-04f, -4.177300107e-04f, -3.754867850e-04f, -3.063318181e-04f, -2.142689858e-04f, -1.057336668e-04f, +1.105591687e-05f, +1.269786586e-04f, +2.330085517e-04f, +3.212002155e-04f, +3.855333010e-04f, +4.225076726e-04f, +4.314173415e-04f, +4.142770958e-04f, +3.754245234e-04f, +3.208642311e-04f, +2.574539829e-04f, +1.920495797e-04f,
        +2.577951457e-04f, +2.682055987e-04f, +2.052121014e-04f, +5.985630987e-05f, -1.568508104e-04f, -4.130215719e-04f, -6.607270683e-04f, -8.458969541e-04f, -9.210401721e-04f, -8.575258695e-04f, -6.540440323e-04f, -3.387320427e-04f, +3.590702749e-05f, +4.042156479e-04f, +7.019465696e-04f, +8.804667570e-04f, +9.169874259e-04f, +8.183175346e-04f, +6.174260146e-04f, +3.640345662e-04f, +1.119865916e-04f, -9.317309612e-05f, -2.232769411e-04f, -2.712938608e-04f,
        /*  1,15 (24) */
        +3.171405450e-03f, +5.899194453e-03f, +9.657244486e-03f, +1.444834364e-02f, +2.016908197e-02f, +2.660538066e-02f, +3.344141702e-02f, +4.028193482e-02f, +4.668604398e-02f, +5.220890408e-02f, +5.644642030e-02f, +5.907746546e-02f, +5.989828908e-02f, +5.884468156e-02f, +5.599900745e-02f, +5.158118765e-02f, +4.592480998e-02f, +3.944147567e-02f, +3.257796556e-02f, +2.577162616e-02f, +1.940942563e-02f, +1.379542491e-02f, +9.130074935e-03f, +5.503004249e-03f,
        -7.138442622e-03f, -1.142583740e-02f, -1.535248053e-02f, -1.765303773e-02f, -1.706381037e-02f, -1.265641695e-02f, -4.143145015e-03f, +7.935064099e-03f, +2.220402594e-02f, +3.665661161e-02f, +4.902503219e-02f, +5.724337965e-02f, +5.989000296e-02f, +5.649991440e-02f, +4.766812144e-02f, +3.491749681e-02f, +2.036490988e-02f, +6.270008090e-03f, -5.421751096e-03f, -1.343349571e-02f, -1.733229861e-02f, -1.749942161e-02f, -1.492333537e-02f, -1.088576871e-02f,
        -1.379910952e-04f, -2.001152905e-04f, -2.656253207e-04f, -3.283123126e-04f, -3.812749648e-04f, -4.177150854e-04f, -4.317940913e-04f, -4.194333165e-04f, -3.789424838e-04f, -3.113799387e-04f, -2.205828625e-04f, -1.128507582e-04f, +3.685685399e-06f, +1.199331400e-04f, +2.268299826e-04f, +3.163364871e-04f, +3.822915174e-04f, +4.210258335e-04f, +4.316573727e-04f, +4.160394191e-04f, +3.783813704e-04f, +3.246064176e-04f, +2.615442299e-04f, +1.960749141e-04f,
        +2.551871856e-04f, +2.695204175e-04f, +2.115618514e-04f, +7.125445421e-05f, -1.417231279e-04f, -3.967060483e-04f, -6.465221071e-04f, -8.371263083e-04f, -9.202342634e-04f, -8.657334732e-04f, -6.704699924e-04f, -3.608162026e-04f, +1.197181021e-05f, +3.826490473e-04f, +6.864407641e-04f, +8.733813231e-04f, +9.188817989e-04f, +8.279297007e-04f, +6.320839735e-04f, +3.803727076e-04f, +1.267651157e-04f, -8.236166666e-05f, -2.175833157e-04f, -2.705482644e-04f,
        /*  2, 0 (24) */
        -5.457237816e-03f, -5.749299516e-03f, -3.461751951e-03f, +2.582273506e-03f, +1.313454258e-02f, +2.821995581e-02f, +4.696043930e-02f, +6.759089318e-02f, +8.768840227e-02f, +1.045803996e-01f, +1.158471781e-01f, +1.198039495e-01f, +1.158471781e-01f, +1.045803996e-01f, +8.768840227e-02f, +6.759089318e-02f, +4.696043930e-02f, +2.821995581e-02f, +1.313454258e-02f, +2.582273506e-03f, -3.461751951e-03f, -5.749299516e-03f, -5.457237816e-03f, -3.849841082e-03f,
        +4.983817699e-03f, -1.227513667e-04f, -9.809575408e-03f, -2.203309842e-02f, -3.273451869e-02f, -3.710431359e-02f, -3.150070121e-02f, -1.524079756e-02f, +8.576361107e-03f, +3.371394239e-02f, +5.279197856e-02f, +5.990197477e-02f, +5.279197856e-02f, +3.371394239e-02f, +8.576361107e-03f, -1.524079756e-02f, -3.150070121e-02f, -3.710431359e-02f, -3.273451869e-02f, -2.203309842e-02f, -9.809575408e-03f, -1.227513667e-04f, +4.983817699e-03f, +5.702431282e-03f,
        +7.447335023e-05f, -4.396091421e-05f, -2.422447510e-04f, -5.051464861e-04f, -7.964121267e-04f, -1.063741346e-03f, -1.248955534e-03f, -1.301173316e-03f, -1.189717810e-03f, -9.132707466e-04f, -5.025821872e-04f, -1.565749561e-05f, +4.736669608e-04f, +8.910528549e-04f, +1.177113412e-03f, +1.299176747e-03f, +1.256559625e-03f, +1.078316198e-03f, +8.144211337e-04f, +5.229980927e-04f, +2.570578584e-04f, +5.406346933e-05f, -6.940512698e-05f, -1.171960904e-04f,
        +1.610944214e-04f, +4.619052037e-04f, +7.126502117e-04f, +7.688324450e-04f, +5.316250007e-04f, +6.905729617e-06f, -6.740237072e-04f, -1.288481522e-03f, -1.602915254e-03f, -1.468219911e-03f, -8.881672048e-04f, -2.854291356e-05f, +8.401694814e-04f, +1.444053089e-03f, +1.608473031e-03f, +1.319082469e-03f, +7.169441422e-04f, +3.305666933e-05f, -5.065084646e-04f, -7.631614087e-04f, -7.232615691e-04f, -4.805646748e-04f, -1.787500512e-04f, +5.547479234e-05f,
        /*  2, 1 (24) */
        -5.382764466e-03f, -5.793260431e-03f, -3.703996702e-03f, +2.077127020e-03f, +1.233813045e-02f, +2.715621446e-02f, +4.571148376e-02f, +6.628971986e-02f, +8.649868446e-02f, +1.036671289e-01f, +1.153445960e-01f, +1.197882920e-01f, +1.163208451e-01f, +1.054714525e-01f, +8.886551568e-02f, +6.889006993e-02f, +4.821699892e-02f, +2.929827201e-02f, +1.394896371e-02f, +3.105271599e-03f, -3.204694092e-03f, -5.695236047e-03f, -5.526642943e-03f, -3.967037172e-03f,
        +5.144912120e-03f, +3.391538370e-04f, -9.096925196e-03f, -2.126426598e-02f, -3.220289369e-02f, -3.709740786e-02f, -3.217472492e-02f, -1.652927908e-02f, +6.973445853e-03f, +3.224572248e-02f, +5.190381135e-02f, +5.987343185e-02f, +5.363214804e-02f, +3.515799548e-02f, +1.018483414e-02f, -1.392171509e-02f, -3.078375707e-02f, -3.707125692e-02f, -3.324102715e-02f, -2.279625983e-02f, -1.053283698e-02f, -6.033160415e-04f, +4.805067648e-03f, +5.757906075e-03f,
        +7.924428113e-05f, -3.417704185e-05f, -2.276911350e-04f, -4.874111149e-04f, -7.783116620e-04f, -1.048843356e-03f, -1.240825207e-03f, -1.302520727e-03f, -1.201666972e-03f, -9.349551213e-04f, -5.311943066e-04f, -4.696294436e-05f, +4.444657095e-04f, +8.683130181e-04f, +1.163857688e-03f, +1.296526957e-03f, +1.263626965e-03f, +1.092553812e-03f, +8.323243973e-04f, +5.409545148e-04f, +2.721238813e-04f, +6.448351439e-05f, -6.403626576e-05f, -1.161209850e-04f,
        +1.437495025e-04f, +4.430579567e-04f, +7.012637304e-04f, +7.733217142e-04f, +5.555752224e-04f, +4.622611733e-05f, -6.308478599e-04f, -1.256679994e-03f, -1.595550745e-03f, -1.490591427e-03f, -9.350368534e-04f, -8.559205927e-05f, +7.911031327e-04f, +1.418114570e-03f, +1.612204906e-03f, +1.348431235e-03f, +7.595474433e-04f, +7.361331520e-05f, -4.802437219e-04f, -7.562953008e-04f, -7.330641614e-04f, -4.989997239e-04f, -1.966919200e-04f, +4.440305368e-05f,
        /*  2, 2 (24) */
        -5.303520185e-03f, -5.827437472e-03f, -3.931687837e-03f, +1.589715905e-03f, +1.155981879e-02f, +2.610737111e-02f, +4.447065856e-02f, +6.498719914e-02f, +8.529701749e-02f, +1.027321738e-01f, +1.148134017e-01f, +1.197413291e-01f, +1.167653108e-01f, +1.063397655e-01f, +9.002937337e-02f, +7.018659688e-02f, +4.948062589e-02f, +3.039082582e-02f, +1.478128811e-02f, +3.646226113e-03f, -2.932570211e-03f, -5.630752533e-03f, -5.590679209e-03f, -4.083158157e-03f,
        +5.288661623e-03f, +7.822117937e-04f, -8.395661465e-03f, -2.049094426e-02f, -3.164731846e-02f, -3.705118174e-02f, -3.280557278e-02f, -1.778595908e-02f, +5.377895108e-03f, +3.075513105e-02f, +5.096877450e-02f, +5.978783980e-02f, +5.442325117e-02f, +3.657611005e-02f, +1.179703904e-02f, -1.257328386e-02f, -3.002420963e-02f, -3.699764360e-02f, -3.372127087e-02f, -2.355255513e-02f, -1.126590114e-02f, -1.102315765e-03f, +4.608375728e-03f, +5.802309129e-03f,
        +8.372149579e-05f, -2.471272391e-05f, -2.134032501e-04f, -4.698031407e-04f, -7.601339276e-04f, -1.033636441e-03f, -1.232179476e-03f, -1.303223507e-03f, -1.212957498e-03f, -9.560948405e-04f, -5.594864885e-04f, -7.823977369e-05f, +4.149957535e-04f, +8.450632330e-04f, +1.149955055e-03f, +1.293220355e-03f, +1.270147369e-03f, +1.106440210e-03f, +8.501075458e-04f, +5.590040813e-04f, +2.874359097e-04f, +7.521953202e-05f, -5.836365872e-05f, -1.148160727e-04f,
        +1.267386733e-04f, +4.240592003e-04f, +6.891364809e-04f, +7.766442229e-04f, +5.783430865e-04f, +8.485825299e-05f, -5.874781133e-04f, -1.223730844e-03f, -1.586401168e-03f, -1.511146685e-03f, -9.807206967e-04f, -1.425312172e-04f, +7.410292380e-04f, +1.390430588e-03f, +1.614094247e-03f, +1.376477675e-03f, +8.017717782e-04f, +1.147149834e-04f, -4.528509384e-04f, -7.482225637e-04f, -7.420251329e-04f, -5.171733863e-04f, -2.148944892e-04f, +3.280060770e-05f,
        /*  2, 3 (24) */
        -5.219798689e-03f, -5.852150196e-03f, -4.145091087e-03f, +1.119912764e-03f, +1.079968486e-02f, +2.507373467e-02f, +4.323847908e-02f, +6.368397563e-02f, +8.408405999e-02f, +1.017760789e-01f, +1.142539152e-01f, +1.196630893e-01f, +1.171803066e-01f, +1.071848287e-01f, +9.117932843e-02f, +7.147981724e-02f, +5.075077326e-02f, +3.149726603e-02f, +1.563139565e-02f, +4.205230195e-03f, -2.645134301e-03f, -5.555533001e-03f, -5.649042868e-03f, -4.197974230e-03f,
        +5.415400296e-03f, +1.206270994e-03f, -7.706524985e-03f, -1.971430004e-02f, -3.106897538e-02f, -3.696632349e-02f, -3.339305089e-02f, -1.900968992e-02f, +3.791493940e-03f, +2.924398436e-02f, +4.998805380e-02f, +5.964530858e-02f, +5.516428041e-02f, +3.796654063e-02f, +1.341113329e-02f, -1.119680618e-02f, -2.922243785e-02f, -3.688292862e-02f, -3.417412181e-02f, -2.430077770e-02f, -1.200792627e-02f, -1.619489152e-03f, +4.393481238e-03f, +5.835109736e-03f,
        +8.790879338e-05f, -1.556851470e-05f, -1.993869984e-04f, -4.523334583e-04f, -7.418930018e-04f, -1.018134912e-03f, -1.223029481e-03f, -1.303286642e-03f, -1.223586498e-03f, -9.766792073e-04f, -5.874421685e-04f, -1.094689306e-04f, +3.852746369e-04f, +8.213159125e-04f, +1.135410439e-03f, +1.289253825e-03f, +1.276110995e-03f, +1.119961557e-03f, +8.677561346e-04f, +5.771348786e-04f, +3.029867020e-04f, +8.626967713e-05f, -5.238444285e-05f, -1.132755013e-04f,
        +1.100841935e-04f, +4.049447613e-04f, +6.763034625e-04f, +7.788166310e-04f, +5.999146171e-04f, +1.227574793e-04f, -5.439756757e-04f, -1.189688301e-03f, -1.575490638e-03f, -1.529867409e-03f, -1.025162808e-03f, -1.992872499e-04f, +6.900104146e-04f, +1.361029974e-03f, +1.614126997e-03f, +1.403173181e-03f, +8.435553022e-04f, +1.563110555e-04f, -4.243523280e-04f, -7.389334301e-04f, -7.501124831e-04f, -5.350484419e-04f, -2.333311836e-04f, +2.067529037e-05f,
        /*  2, 4 (24) */
        -5.131889896e-03f, -5.867718711e-03f, -4.344478085e-03f, +6.675793059e-04f, +1.005779186e-02f, +2.405559975e-02f, +4.201544960e-02f, +6.238068899e-02f, +8.286047349e-02f, +1.007993997e-01f, +1.136664730e-01f, +1.195536204e-01f, +1.175655812e-01f, +1.080061447e-01f, +9.231473886e-02f, +7.276907106e-02f, +5.202688425e-02f, +3.261722759e-02f, +1.649915179e-02f, +4.782365073e-03f, -2.342147599e-03f, -5.469263323e-03f, -5.701427310e-03f, -4.311249731e-03f,
        +5.525484490e-03f, +1.611215755e-03f, -7.030221522e-03f, -1.893548341e-02f, -3.046906076e-02f, -3.684356601e-02f, -3.393702657e-02f, -2.019937822e-02f, +2.216003302e-03f, +2.771411696e-02f, +4.896289099e-02f, +5.944602133e-02f, +5.585429082e-02f, +3.932757061e-02f, +1.502526029e-02f, -9.793633001e-03f, -2.837888255e-02f, -3.672661756e-02f, -3.459847414e-02f, -2.503971113e-02f, -1.275803875e-02f, -2.154537594e-03f, +4.160150055e-03f, +5.855785027e-03f,
        +9.181018856e-05f, -6.744655180e-06f, -1.856479425e-04f, -4.350126895e-04f, -7.236028412e-04f, -1.002353166e-03f, -1.213386654e-03f, -1.302715571e-03f, -1.233551590e-03f, -9.966979741e-04f, -6.150450611e-04f, -1.406314021e-04f, +3.553201127e-04f, +7.970838758e-04f, +1.120229268e-03f, +1.284624736e-03f, +1.281508348e-03f, +1.133104170e-03f, +8.852556579e-04f, +5.953347587e-04f, +3.187686877e-04f, +9.763177411e-05f, -4.609600695e-05f, -1.114935439e-04f,
        +9.380718275e-05f, +3.857499684e-04f, +6.628002469e-04f, +7.798572015e-04f, +6.202779047e-04f, +1.598807795e-04f, -5.004013551e-04f, -1.154607768e-03f, -1.562845666e-03f, -1.546738023e-03f, -1.068309149e-03f, -2.557873015e-04f, +6.381107241e-04f, +1.329944115e-03f, +1.612291711e-03f, +1.428470775e-03f, +8.848362575e-04f, +1.983495881e-04f, -3.947721387e-04f, -7.284199629e-04f, -7.572951362e-04f, -5.525874792e-04f, -2.519744239e-04f, +8.036155108e-06f,
        /*  2, 5 (24) */
        -5.040079707e-03f, -5.874463366e-03f, -4.530126028e-03f, +2.325666164e-04f, +9.334189017e-03f, +2.305324659e-02f, +4.080206294e-02f, +6.107797342e-02f, +8.162692190e-02f, +9.980270174e-02f, +1.130514279e-01f, +1.194129890e-01f, +1.179209013e-01f, +1.088032285e-01f, +9.343496813e-02f, +7.405369580e-02f, +5.330839260e-02f, +3.375033176e-02f, +1.738440745e-02f, +5.377699832e-03f, -2.023378911e-03f, -5.371631549e-03f, -5.747523317e-03f, -4.422743275e-03f,
        +5.619291672e-03f, +1.996965724e-03f, -6.367421275e-03f, -1.815562621e-02f, -2.984878286e-02f, -3.668368523e-02f, -3.443742792e-02f, -2.135398599e-02f, +6.531576364e-04f, +2.616737893e-02f, +4.789458185e-02f, +5.919023403e-02f, +5.649240155e-02f, +4.065751472e-02f, +1.663755200e-02f, -8.365162226e-03f, -2.749404629e-02f, -3.652826797e-02f, -3.499324628e-02f, -2.576813109e-02f, -1.351533389e-02f, -2.707125073e-03f, +3.908175631e-03f, +5.863821182e-03f,
        +9.542990372e-05f, +1.758922717e-06f, -1.721913048e-04f, -4.178511756e-04f, -7.052772694e-04f, -9.863056699e-04f, -1.203262712e-03f, -1.301516175e-03f, -1.242850904e-03f, -1.016141350e-03f, -6.422791733e-04f, -1.717082308e-04f, +3.251501290e-04f, +7.723803390e-04f, +1.104417471e-03f, +1.279330942e-03f, +1.286330301e-03f, +1.145854529e-03f, +9.025915620e-04f, +6.135913483e-04f, +3.347739708e-04f, +1.093033143e-04f, -3.949599835e-05f, -1.094646074e-04f,
        +7.792760007e-05f, +3.665095964e-04f, +6.486629068e-04f, +7.797857477e-04f, +6.394231019e-04f, +1.961868304e-04f, -4.568154653e-04f, -1.118545727e-03f, -1.548495109e-03f, -1.561745660e-03f, -1.110107646e-03f, -3.119589095e-04f, +5.853955751e-04f, +1.297206916e-03f, +1.608579579e-03f, +1.452325189e-03f, +9.255530727e-04f, +2.407773855e-04f, -3.641366350e-04f, -7.166760930e-04f, -7.635430099e-04f, -5.697529608e-04f, -2.707956610e-04f, -5.106521924e-06f,
        /*  2, 6 (24) */
        -4.944649803e-03f, -5.872704443e-03f, -4.702317332e-03f, -1.852845592e-04f, +8.628911748e-03f, +2.206694092e-02f, +3.959880023e-02f, +5.977645724e-02f, +8.038407100e-02f, +9.878656039e-02f, +1.124091488e-01f, +1.192412808e-01f, +1.182460515e-01f, +1.095756089e-01f, +9.453938560e-02f, +7.533302674e-02f, +5.459472290e-02f, +3.489618629e-02f, +1.828699901e-02f, +5.991291180e-03f, -1.688604941e-03f, -5.262328235e-03f, -5.787019316e-03f, -4.532207882e-03f,
        +5.697219272e-03f, +2.363475320e-03f, -5.718758368e-03f, -1.737584046e-02f, -2.920935975e-02f, -3.648749840e-02f, -3.489424339e-02f, -2.247253172e-02f, -8.953374729e-04f, +2.460563327e-02f, +4.678447420e-02f, +5.887827512e-02f, +5.707779712e-02f, +4.195472164e-02f, +1.824613158e-02f, -6.912837038e-03f, -2.656849322e-02f, -3.628749059e-02f, -3.535738291e-02f, -2.648480718e-02f, -1.427887690e-02f, -3.276878034e-03f, +3.637379970e-03f, +5.858714660e-03f,
        +9.877236116e-05f, +9.942591461e-06f, -1.590219669e-04f, -4.008589712e-04f, -6.869299656e-04f, -9.700069480e-04f, -1.192669640e-03f, -1.299694773e-03f, -1.251483081e-03f, -1.035000008e-03f, -6.691288173e-04f, -2.026805313e-04f, +2.947828133e-04f, +7.472189048e-04f, +1.087981479e-03f, +1.273370789e-03f, +1.290568097e-03f, +1.158199297e-03f, +9.197492578e-04f, +6.318920578e-04f, +3.509943333e-04f, +1.212814540e-04f, -3.258232942e-05f, -1.071832408e-04f,
        +6.246422727e-05f, +3.472578112e-04f, +6.339279443e-04f, +7.786235782e-04f, +6.573424148e-04f, +2.316360532e-04f, -4.132777339e-04f, -1.081559642e-03f, -1.532470114e-03f, -1.574880176e-03f, -1.150508270e-03f, -3.677301159e-04f, +5.319316244e-04f, +1.262854755e-03f, +1.602984462e-03f, +1.474692948e-03f, +9.656444630e-04f, +2.835400742e-04f, -3.324740767e-04f, -7.036976533e-04f, -7.688270825e-04f, -5.865072905e-04f, -2.897654137e-04f, -1.874123877e-05f,
        /*  2, 7 (24) */
        -4.845877442e-03f, -5.862761852e-03f, -4.861339299e-03f, -5.861435304e-04f, +7.941981782e-03f, +2.109693397e-02f, +3.840613059e-02f, +5.847676247e-02f, +7.913258792e-02f, +9.775156039e-02f, +1.117400199e-01f, +1.190386002e-01f, +1.185408343e-01f, +1.103228278e-01f, +9.562736708e-02f, +7.660639753e-02f, +5.588529100e-02f, +3.605438558e-02f, +1.920674827e-02f, +6.623183238e-03f, -1.337610607e-03f, -5.141046781e-03f, -5.819601645e-03f, -4.639391123e-03f,
        +5.759683500e-03f, +2.710733131e-03f, -5.084830424e-03f, -1.659721688e-02f, -2.855201734e-02f, -3.625586234e-02f, -3.530752112e-02f, -2.355409136e-02f, -2.427807587e-03f, +2.303075310e-02f, +4.563396593e-02f, +5.851054500e-02f, +5.760972875e-02f, +4.321757639e-02f, +1.984911604e-02f, -5.438144089e-03f, -2.560284875e-02f, -3.600395051e-02f, -3.568985699e-02f, -2.718850484e-02f, -1.504770398e-02f, -3.863385324e-03f, +3.347614556e-03f, +5.839973421e-03f,
        +1.018421751e-04f, +1.780702306e-05f, -1.461444695e-04f, -3.840458379e-04f, -6.685744535e-04f, -9.534715695e-04f, -1.181619683e-03f, -1.297258112e-03f, -1.259447268e-03f, -1.053265089e-03f, -6.955786233e-04f, -2.335295054e-04f, +2.642364581e-04f, +7.216135516e-04f, +1.070928213e-03f, +1.266743117e-03f, +1.294213361e-03f, +1.170125328e-03f, +9.367141338e-04f, +6.502240907e-04f, +3.674212390e-04f, +1.335630122e-04f, -2.535318391e-05f, -1.046441437e-04f,
        +4.743465426e-05f, +3.280281174e-04f, +6.186322196e-04f, +7.763934401e-04f, +6.740300923e-04f, +2.661906593e-04f, -3.698472109e-04f, -1.043707865e-03f, -1.514804050e-03f, -1.586134153e-03f, -1.189463108e-03f, -4.230295777e-04f, +4.777866761e-04f, +1.226926429e-03f, +1.595502904e-03f, +1.495532453e-03f, +1.005049531e-03f, +3.265821805e-04f, -2.998146942e-04f, -6.894824103e-04f, -7.731194598e-04f, -6.028128803e-04f, -3.088533075e-04f, -3.285526714e-05f,
        /*  2, 8 (24) */
        -4.744035267e-03f, -5.844954829e-03f, -5.007483769e-03f, -9.701893683e-04f, +7.273407329e-03f, +2.014346240e-02f, +3.722451091e-02f, +5.717950436e-02f, +7.787314065e-02f, +9.669829530e-02f, +1.110444413e-01f, +1.188050707e-01f, +1.188050707e-01f, +1.110444413e-01f, +9.669829530e-02f, +7.787314065e-02f, +5.717950436e-02f, +3.722451091e-02f, +2.014346240e-02f, +7.273407329e-03f, -9.701893683e-04f, -5.007483769e-03f, -5.844954829e-03f, -4.744035267e-03f,
        +5.807118154e-03f, +3.038761249e-03f, -4.466198204e-03f, -1.582082344e-02f, -2.787798725e-02f, -3.598967168e-02f, -3.567736833e-02f, -2.459779922e-02f, -3.942611637e-03f, +2.144461894e-02f, +4.444450282e-02f, +5.808751542e-02f, +5.808751542e-02f, +4.444450282e-02f, +2.144461894e-02f, -3.942611637e-03f, -2.459779922e-02f, -3.567736833e-02f, -3.598967168e-02f, -2.787798725e-02f, -1.582082344e-02f, -4.466198204e-03f, +3.038761249e-03f, +5.807118154e-03f,
        +1.046441437e-04f, +2.535318391e-05f, -1.335630122e-04f, -3.674212390e-04f, -6.502240907e-04f, -9.367141338e-04f, -1.170125328e-03f, -1.294213361e-03f, -1.266743117e-03f, -1.070928213e-03f, -7.216135516e-04f, -2.642364581e-04f, +2.335295054e-04f, +6.955786233e-04f, +1.053265089e-03f, +1.259447268e-03f, +1.297258112e-03f, +1.181619683e-03f, +9.534715695e-04f, +6.685744535e-04f, +3.840458379e-04f, +1.461444695e-04f, -1.780702306e-05f, -1.018421751e-04f,
        +3.285526714e-05f, +3.088533075e-04f, +6.028128803e-04f, +7.731194598e-04f, +6.894824103e-04f, +2.998146942e-04f, -3.265821805e-04f, -1.005049531e-03f, -1.495532453e-03f, -1.595502904e-03f, -1.226926429e-03f, -4.777866761e-04f, +4.230295777e-04f, +1.189463108e-03f, +1.586134153e-03f, +1.514804050e-03f, +1.043707865e-03f, +3.698472109e-04f, -2.661906593e-04f, -6.740300923e-04f, -7.763934401e-04f, -6.186322196e-04f, -3.280281174e-04f, -4.743465426e-05f,
        /*  2, 9 (24) */
        -4.639391123e-03f, -5.819601645e-03f, -5.141046781e-03f, -1.337610607e-03f, +6.623183238e-03f, +1.920674827e-02f, +3.605438558e-02f, +5.588529100e-02f, +7.660639753e-02f, +9.562736708e-02f, +1.103228278e-01f, +1.185408343e-01f, +1.190386002e-01f, +1.117400199e-01f, +9.775156039e-02f, +7.913258792e-02f, +5.847676247e-02f, +3.840613059e-02f, +2.109693397e-02f, +7.941981782e-03f, -5.861435304e-04f, -4.861339299e-03f, -5.862761852e-03f, -4.845877442e-03f,
        +5.839973421e-03f, +3.347614556e-03f, -3.863385324e-03f, -1.504770398e-02f, -2.718850484e-02f, -3.568985699e-02f, -3.600395051e-02f, -2.560284875e-02f, -5.438144089e-03f, +1.984911604e-02f, +4.321757639e-02f, +5.760972875e-02f, +5.851054500e-02f, +4.563396593e-02f, +2.303075310e-02f, -2.427807587e-03f, -2.355409136e-02f, -3.530752112e-02f, -3.625586234e-02f, -2.855201734e-02f, -1.659721688e-02f, -5.084830424e-03f, +2.710733131e-03f, +5.759683500e-03f,
        +1.071832408e-04f, +3.258232942e-05f, -1.212814540e-04f, -3.509943333e-04f, -6.318920578e-04f, -9.197492578e-04f, -1.158199297e-03f, -1.290568097e-03f, -1.273370789e-03f, -1.087981479e-03f, -7.472189048e-04f, -2.947828133e-04f, +2.026805313e-04f, +6.691288173e-04f, +1.035000008e-03f, +1.251483081e-03f, +1.299694773e-03f, +1.192669640e-03f, +9.700069480e-04f, +6.869299656e-04f, +4.008589712e-04f, +1.590219669e-04f, -9.942591461e-06f, -9.877236116e-05f,
        +1.874123877e-05f, +2.897654137e-04f, +5.865072905e-04f, +7.688270825e-04f, +7.036976533e-04f, +3.324740767e-04f, -2.835400742e-04f, -9.656444630e-04f, -1.474692948e-03f, -1.602984462e-03f, -1.262854755e-03f, -5.319316244e-04f, +3.677301159e-04f, +1.150508270e-03f, +1.574880176e-03f, +1.532470114e-03f, +1.081559642e-03f, +4.132777339e-04f, -2.316360532e-04f, -6.573424148e-04f, -7.786235782e-04f, -6.339279443e-04f, -3.472578112e-04f, -6.246422727e-05f,
        /*  2,10 (24) */
        -4.532207882e-03f, -5.787019316e-03f, -5.262328235e-03f, -1.688604941e-03f, +5.991291180e-03f, +1.828699901e-02f, +3.489618629e-02f, +5.459472290e-02f, +7.533302674e-02f, +9.453938560e-02f, +1.095756089e-01f, +1.182460515e-01f, +1.192412808e-01f, +1.124091488e-01f, +9.878656039e-02f, +8.038407100e-02f, +5.977645724e-02f, +3.959880023e-02f, +2.206694092e-02f, +8.628911748e-03f, -1.852845592e-04f, -4.702317332e-03f, -5.872704443e-03f, -4.944649803e-03f,
        +5.858714660e-03f, +3.637379970e-03f, -3.276878034e-03f, -1.427887690e-02f, -2.648480718e-02f, -3.535738291e-02f, -3.628749059e-02f, -2.656849322e-02f, -6.912837038e-03f, +1.824613158e-02f, +4.195472164e-02f, +5.707779712e-02f, +5.887827512e-02f, +4.678447420e-02f, +2.460563327e-02f, -8.953374729e-04f, -2.247253172e-02f, -3.489424339e-02f, -3.648749840e-02f, -2.920935975e-02f, -1.737584046e-02f, -5.718758368e-03f, +2.363475320e-03f, +5.697219272e-03f,
        +1.094646074e-04f, +3.949599835e-05f, -1.093033143e-04f, -3.347739708e-04f, -6.135913483e-04f, -9.025915620e-04f, -1.145854529e-03f, -1.286330301e-03f, -1.279330942e-03f, -1.104417471e-03f, -7.723803390e-04f, -3.251501290e-04f, +1.717082308e-04f, +6.422791733e-04f, +1.016141350e-03f, +1.242850904e-03f, +1.301516175e-03f, +1.203262712e-03f, +9.863056699e-04f, +7.052772694e-04f, +4.178511756e-04f, +1.721913048e-04f, -1.758922717e-06f, -9.542990372e-05f,
        +5.106521924e-06f, +2.707956610e-04f, +5.697529608e-04f, +7.635430099e-04f, +7.166760930e-04f, +3.641366350e-04f, -2.407773855e-04f, -9.255530727e-04f, -1.452325189e-03f, -1.608579579e-03f, -1.297206916e-03f, -5.853955751e-04f, +3.119589095e-04f, +1.110107646e-03f, +1.561745660e-03f, +1.548495109e-03f, +1.118545727e-03f, +4.568154653e-04f, -1.961868304e-04f, -6.394231019e-04f, -7.797857477e-04f, -6.486629068e-04f, -3.665095964e-04f, -7.792760007e-05f,
        /*  2,11 (24) */
        -4.422743275e-03f, -5.747523317e-03f, -5.371631549e-03f, -2.023378911e-03f, +5.377699832e-03f, +1.738440745e-02f, +3.375033176e-02f, +5.330839260e-02f, +7.405369580e-02f, +9.343496813e-02f, +1.088032285e-01f, +1.179209013e-01f, +1.194129890e-01f, +1.130514279e-01f, +9.980270174e-02f, +8.162692190e-02f, +6.107797342e-02f, +4.080206294e-02f, +2.305324659e-02f, +9.334189017e-03f, +2.325666164e-04f, -4.530126028e-03f, -5.874463366e-03f, -5.040079707e-03f,
        +5.863821182e-03f, +3.908175631e-03f, -2.707125073e-03f, -1.351533389e-02f, -2.576813109e-02f, -3.499324628e-02f, -3.652826797e-02f, -2.749404629e-02f, -8.365162226e-03f, +1.663755200e-02f, +4.065751472e-02f, +5.649240155e-02f, +5.919023403e-02f, +4.789458185e-02f, +2.616737893e-02f, +6.531576364e-04f, -2.135398599e-02f, -3.443742792e-02f, -3.668368523e-02f, -2.984878286e-02f, -1.815562621e-02f, -6.367421275e-03f, +1.996965724e-03f, +5.619291672e-03f,
        +1.114935439e-04f, +4.609600695e-05f, -9.763177411e-05f, -3.187686877e-04f, -5.953347587e-04f, -8.852556579e-04f, -1.133104170e-03f, -1.281508348e-03f, -1.284624736e-03f, -1.120229268e-03f, -7.970838758e-04f, -3.553201127e-04f, +1.406314021e-04f, +6.150450611e-04f, +9.966979741e-04f, +1.233551590e-03f, +1.302715571e-03f, +1.213386654e-03f, +1.002353166e-03f, +7.236028412e-04f, +4.350126895e-04f, +1.856479425e-04f, +6.744655180e-06f, -9.181018856e-05f,
        -8.036155108e-06f, +2.519744239e-04f, +5.525874792e-04f, +7.572951362e-04f, +7.284199629e-04f, +3.947721387e-04f, -1.983495881e-04f, -8.848362575e-04f, -1.428470775e-03f, -1.612291711e-03f, -1.329944115e-03f, -6.381107241e-04f, +2.557873015e-04f, +1.068309149e-03f, +1.546738023e-03f, +1.562845666e-03f, +1.154607768e-03f, +5.004013551e-04f, -1.598807795e-04f, -6.202779047e-04f, -7.798572015e-04f, -6.628002469e-04f, -3.857499684e-04f, -9.380718275e-05f,
        /*  2,12 (24) */
        -4.311249731e-03f, -5.701427310e-03f, -5.469263323e-03f, -2.342147599e-03f, +4.782365073e-03f, +1.649915179e-02f, +3.261722759e-02f, +5.202688425e-02f, +7.276907106e-02f, +9.231473886e-02f, +1.080061447e-01f, +1.175655812e-01f, +1.195536204e-01f, +1.136664730e-01f, +1.007993997e-01f, +8.286047349e-02f, +6.238068899e-02f, +4.201544960e-02f, +2.405559975e-02f, +1.005779186e-02f, +6.675793059e-04f, -4.344478085e-03f, -5.867718711e-03f, -5.131889896e-03f,
        +5.855785027e-03f, +4.160150055e-03f, -2.154537594e-03f, -1.275803875e-02f, -2.503971113e-02f, -3.459847414e-02f, -3.672661756e-02f, -2.837888255e-02f, -9.793633001e-03f, +1.502526029e-02f, +3.932757061e-02f, +5.585429082e-02f, +5.944602133e-02f, +4.896289099e-02f, +2.771411696e-02f, +2.216003302e-03f, -2.019937822e-02f, -3.393702657e-02f, -3.684356601e-02f, -3.046906076e-02f, -1.893548341e-02f, -7.030221522e-03f, +1.611215755e-03f, +5.525484490e-03f,
        +1.132755013e-04f, +5.238444285e-05f, -8.626967713e-05f, -3.029867020e-04f, -5.771348786e-04f, -8.677561346e-04f, -1.119961557e-03f, -1.276110995e-03f, -1.289253825e-03f, -1.135410439e-03f, -8.213159125e-04f, -3.852746369e-04f, +1.094689306e-04f, +5.874421685e-04f, +9.766792073e-04f, +1.223586498e-03f, +1.303286642e-03f, +1.223029481e-03f, +1.018134912e-03f, +7.418930018e-04f, +4.523334583e-04f, +1.993869984e-04f, +1.556851470e-05f, -8.790879338e-05f,
        -2.067529037e-05f, +2.333311836e-04f, +5.350484419e-04f, +7.501124831e-04f, +7.389334301e-04f, +4.243523280e-04f, -1.563110555e-04f, -8.435553022e-04f, -1.403173181e-03f, -1.614126997e-03f, -1.361029974e-03f, -6.900104146e-04f, +1.992872499e-04f, +1.025162808e-03f, +1.529867409e-03f, +1.575490638e-03f, +1.189688301e-03f, +5.439756757e-04f, -1.227574793e-04f, -5.999146171e-04f, -7.788166310e-04f, -6.763034625e-04f, -4.049447613e-04f, -1.100841935e-04f,
        /*  2,13 (24) */
        -4.197974230e-03f, -5.649042868e-03f, -5.555533001e-03f, -2.645134301e-03f, +4.205230195e-03f, +1.563139565e-02f, +3.149726603e-02f, +5.075077326e-02f, +7.147981724e-02f, +9.117932843e-02f, +1.071848287e-01f, +1.171803066e-01f, +1.196630893e-01f, +1.142539152e-01f, +1.017760789e-01f, +8.408405999e-02f, +6.368397563e-02f, +4.323847908e-02f, +2.507373467e-02f, +1.079968486e-02f, +1.119912764e-03f, -4.145091087e-03f, -5.852150196e-03f, -5.219798689e-03f,
        +5.835109736e-03f, +4.393481238e-03f, -1.619489152e-03f, -1.200792627e-02f, -2.430077770e-02f, -3.417412181e-02f, -3.688292862e-02f, -2.922243785e-02f, -1.119680618e-02f, +1.341113329e-02f, +3.796654063e-02f, +5.516428041e-02f, +5.964530858e-02f, +4.998805380e-02f, +2.924398436e-02f, +3.791493940e-03f, -1.900968992e-02f, -3.339305089e-02f, -3.696632349e-02f, -3.106897538e-02f, -1.971430004e-02f, -7.706524985e-03f, +1.206270994e-03f, +5.415400296e-03f,
        +1.148160727e-04f, +5.836365872e-05f, -7.521953202e-05f, -2.874359097e-04f, -5.590040813e-04f, -8.501075458e-04f, -1.106440210e-03f, -1.270147369e-03f, -1.293220355e-03f, -1.149955055e-03f, -8.450632330e-04f, -4.149957535e-04f, +7.823977369e-05f, +5.594864885e-04f, +9.560948405e-04f, +1.212957498e-03f, +1.303223507e-03f, +1.232179476e-03f, +1.033636441e-03f, +7.601339276e-04f, +4.698031407e-04f, +2.134032501e-04f, +2.471272391e-05f, -8.372149579e-05f,
        -3.280060770e-05f, +2.148944892e-04f, +5.171733863e-04f, +7.420251329e-04f, +7.482225637e-04f, +4.528509384e-04f, -1.147149834e-04f, -8.017717782e-04f, -1.376477675e-03f, -1.614094247e-03f, -1.390430588e-03f, -7.410292380e-04f, +1.425312172e-04f, +9.807206967e-04f, +1.511146685e-03f, +1.586401168e-03f, +1.223730844e-03f, +5.874781133e-04f, -8.485825299e-05f, -5.783430865e-04f, -7.766442229e-04f, -6.891364809e-04f, -4.240592003e-04f, -1.267386733e-04f,
        /*  2,14 (24) */
        -4.083158157e-03f, -5.590679209e-03f, -5.630752533e-03f, -2.932570211e-03f, +3.646226113e-03f, +1.478128811e-02f, +3.039082582e-02f, +4.948062589e-02f, +7.018659688e-02f, +9.002937337e-02f, +1.063397655e-01f, +1.167653108e-01f, +1.197413291e-01f, +1.148134017e-01f, +1.027321738e-01f, +8.529701749e-02f, +6.498719914e-02f, +4.447065856e-02f, +2.610737111e-02f, +1.155981879e-02f, +1.589715905e-03f, -3.931687837e-03f, -5.827437472e-03f, -5.303520185e-03f,
        +5.802309129e-03f, +4.608375728e-03f, -1.102315765e-03f, -1.126590114e-02f, -2.355255513e-02f, -3.372127087e-02f, -3.699764360e-02f, -3.002420963e-02f, -1.257328386e-02f, +1.179703904e-02f, +3.657611005e-02f, +5.442325117e-02f, +5.978783980e-02f, +5.096877450e-02f, +3.075513105e-02f, +5.377895108e-03f, -1.778595908e-02f, -3.280557278e-02f, -3.705118174e-02f, -3.164731846e-02f, -2.049094426e-02f, -8.395661465e-03f, +7.822117937e-04f, +5.288661623e-03f,
        +1.161209850e-04f, +6.403626576e-05f, -6.448351439e-05f, -2.721238813e-04f, -5.409545148e-04f, -8.323243973e-04f, -1.092553812e-03f, -1.263626965e-03f, -1.296526957e-03f, -1.163857688e-03f, -8.683130181e-04f, -4.444657095e-04f, +4.696294436e-05f, +5.311943066e-04f, +9.349551213e-04f, +1.201666972e-03f, +1.302520727e-03f, +1.240825207e-03f, +1.048843356e-03f, +7.783116620e-04f, +4.874111149e-04f, +2.276911350e-04f, +3.417704185e-05f, -7.924428113e-05f,
        -4.440305368e-05f, +1.966919200e-04f, +4.989997239e-04f, +7.330641614e-04f, +7.562953008e-04f, +4.802437219e-04f, -7.361331520e-05f, -7.595474433e-04f, -1.348431235e-03f, -1.612204906e-03f, -1.418114570e-03f, -7.911031327e-04f, +8.559205927e-05f, +9.350368534e-04f, +1.490591427e-03f, +1.595550745e-03f, +1.256679994e-03f, +6.308478599e-04f, -4.622611733e-05f, -5.555752224e-04f, -7.733217142e-04f, -7.012637304e-04f, -4.430579567e-04f, -1.437495025e-04f,
        /*  2,15 (24) */
        -3.967037172e-03f, -5.526642943e-03f, -5.695236047e-03f, -3.204694092e-03f, +3.105271599e-03f, +1.394896371e-02f, +2.929827201e-02f, +4.821699892e-02f, +6.889006993e-02f, +8.886551568e-02f, +1.054714525e-01f, +1.163208451e-01f, +1.197882920e-01f, +1.153445960e-01f, +1.036671289e-01f, +8.649868446e-02f, +6.628971986e-02f, +4.571148376e-02f, +2.715621446e-02f, +1.233813045e-02f, +2.077127020e-03f, -3.703996702e-03f, -5.793260431e-03f, -5.382764466e-03f,
        +5.757906075e-03f, +4.805067648e-03f, -6.033160415e-04f, -1.053283698e-02f, -2.279625983e-02f, -3.324102715e-02f, -3.707125692e-02f, -3.078375707e-02f, -1.392171509e-02f, +1.018483414e-02f, +3.515799548e-02f, +5.363214804e-02f, +5.987343185e-02f, +5.190381135e-02f, +3.224572248e-02f, +6.973445853e-03f, -1.652927908e-02f, -3.217472492e-02f, -3.709740786e-02f, -3.220289369e-02f, -2.126426598e-02f, -9.096925196e-03f, +3.391538370e-04f, +5.144912120e-03f,
        +1.171960904e-04f, +6.940512698e-05f, -5.406346933e-05f, -2.570578584e-04f, -5.229980927e-04f, -8.144211337e-04f, -1.078316198e-03f, -1.256559625e-03f, -1.299176747e-03f, -1.177113412e-03f, -8.910528549e-04f, -4.736669608e-04f, +1.565749561e-05f, +5.025821872e-04f, +9.132707466e-04f, +1.189717810e-03f, +1.301173316e-03f, +1.248955534e-03f, +1.063741346e-03f, +7.964121267e-04f, +5.051464861e-04f, +2.422447510e-04f, +4.396091421e-05f, -7.447335023e-05f,
        -5.547479234e-05f, +1.787500512e-04f, +4.805646748e-04f, +7.232615691e-04f, +7.631614087e-04f, +5.065084646e-04f, -3.305666933e-05f, -7.169441422e-04f, -1.319082469e-03f, -1.608473031e-03f, -1.444053089e-03f, -8.401694814e-04f, +2.854291356e-05f, +8.881672048e-04f, +1.468219911e-03f, +1.602915254e-03f, +1.288481522e-03f, +6.740237072e-04f, -6.905729617e-06f, -5.316250007e-04f, -7.688324450e-04f, -7.126502117e-04f, -4.619052037e-04f, -1.610944214e-04f,
        /*  3, 0 (24) */
        -4.734201172e-04f, -5.872050883e-03f, -1.327132736e-02f, -1.945082492e-02f, -1.959997611e-02f, -8.884357777e-03f, +1.545973808e-02f, +5.235009562e-02f, +9.626476338e-02f, +1.382943420e-01f, +1.686391567e-01f, +1.797059243e-01f, +1.686391567e-01f, +1.382943420e-01f, +9.626476338e-02f, +5.235009562e-02f, +1.545973808e-02f, -8.884357777e-03f, -1.959997611e-02f, -1.945082492e-02f, -1.327132736e-02f, -5.872050883e-03f, -4.734201172e-04f, +1.852590201e-03f,
        +6.383988391e-03f, +1.521606380e-02f, +1.998675788e-02f, +1.433025347e-02f, -3.365023479e-03f, -2.693084335e-02f, -4.420767028e-02f, -4.352960466e-02f, -2.129987080e-02f, +1.435357571e-02f, +4.683729932e-02f, +5.990197477e-02f, +4.683729932e-02f, +1.435357571e-02f, -2.129987080e-02f, -4.352960466e-02f, -4.420767028e-02f, -2.693084335e-02f, -3.365023479e-03f, +1.433025347e-02f, +1.998675788e-02f, +1.521606380e-02f, +6.383988391e-03f, -3.539537444e-04f,
        +2.355677716e-04f, +4.179442895e-04f, +4.704054608e-04f, +2.636859589e-04f, -2.647871259e-04f, -1.056835617e-03f, -1.922979241e-03f, -2.589654838e-03f, -2.792633064e-03f, -2.381490657e-03f, -1.390749392e-03f, -4.420040917e-05f, +1.313836442e-03f, +2.335105944e-03f, +2.785586443e-03f, +2.618259216e-03f, +1.973503767e-03f, +1.111372868e-03f, +3.079126691e-04f, -2.401633161e-04f, -4.662037107e-04f, -4.265012055e-04f, -2.481551782e-04f, -6.172129803e-05f,
        -5.307162707e-04f, -5.079300130e-04f, -4.486124072e-05f, +7.264197738e-04f, +1.381428286e-03f, +1.429080757e-03f, +6.481239362e-04f, -6.943321844e-04f, -1.923558464e-03f, -2.327398621e-03f, -1.597787307e-03f, -5.339670306e-05f, +1.518583567e-03f, +2.314926423e-03f, +1.979009750e-03f, +7.826531639e-04f, -5.751864623e-04f, -1.404413140e-03f, -1.406533530e-03f, -7.762001769e-04f, +2.500611640e-06f, +4.922146246e-04f, +5.402355369e-04f, +2.899658374e-04f,
        /*  3, 1 (24) */
        -2.378523456e-04f, -5.454106594e-03f, -1.280092190e-02f, -1.918713896e-02f, -1.986476324e-02f, -9.941193394e-03f, +1.353675884e-02f, +4.976044078e-02f, +9.347213031e-02f, +1.359128514e-01f, +1.672484073e-01f, +1.796617239e-01f, +1.699529931e-01f, +1.406294480e-01f, +9.905034982e-02f, +5.496835484e-02f, +1.743324185e-02f, -7.772984909e-03f, -1.929206344e-02f, -1.969098823e-02f, -1.373753107e-02f, -6.298552089e-03f, -7.215752954e-04f, +1.790868903e-03f,
        +5.853272120e-03f, +1.470813379e-02f, +1.994189664e-02f, +1.505667324e-02f, -1.983595193e-03f, -2.550176259e-02f, -4.355954634e-02f, -4.422393685e-02f, -2.322342926e-02f, +1.202617709e-02f, +4.523951201e-02f, +5.984857807e-02f, +4.835588289e-02f, +1.666850214e-02f, -1.932086105e-02f, -4.274695150e-02f, -4.478285674e-02f, -2.833525649e-02f, -4.771557009e-03f, +1.355405329e-02f, +1.998925849e-02f, +1.570827843e-02f, +6.924223928e-03f, -6.398790701e-05f,
        +2.229937837e-04f, +4.088809149e-04f, +4.735725955e-04f, +2.859105993e-04f, -2.227364395e-04f, -1.002617239e-03f, -1.871673067e-03f, -2.559200721e-03f, -2.797217717e-03f, -2.425546548e-03f, -1.466231160e-03f, -1.325550036e-04f, +1.235568842e-03f, +2.286427588e-03f, +2.776062594e-03f, +2.644958192e-03f, +2.023174408e-03f, +1.166167127e-03f, +3.520806754e-04f, -2.153407861e-04f, -4.609402801e-04f, -4.345162095e-04f, -2.607281858e-04f, -7.171793133e-05f,
        -5.200556115e-04f, -5.218232591e-04f, -8.591185626e-05f, +6.762124622e-04f, +1.353857631e-03f, +1.450338834e-03f, +7.187217155e-04f, -6.055847117e-04f, -1.864741531e-03f, -2.335221636e-03f, -1.673642119e-03f, -1.600766433e-04f, +1.436191554e-03f, +2.297809027e-03f, +2.030950215e-03f, +8.703490222e-04f, -5.000433397e-04f, -1.376339999e-03f, -1.429068254e-03f, -8.254212634e-04f, -4.109231554e-05f, +4.746690398e-04f, +5.485484257e-04f, +3.092517675e-04f,
        /*  3, 2 (24) */
        -1.485856194e-05f, -5.045225679e-03f, -1.232734930e-02f, -1.890122836e-02f, -2.008749968e-02f, -1.094381063e-02f, +1.166508578e-02f, +4.720124006e-02f, +9.067491260e-02f, +1.334873048e-01f, +1.657821762e-01f, +1.795291689e-01f, +1.711885620e-01f, +1.429158756e-01f, +1.018264124e-01f, +5.761331303e-02f, +1.945641626e-02f, -6.606817783e-03f, -1.893998277e-02f, -1.990632902e-02f, -1.419847135e-02f, -6.733068298e-03f, -9.823034812e-04f, +1.719150971e-03f,
        +5.333216509e-03f, +1.418631053e-02f, +1.985598479e-02f, +1.573288570e-02f, -6.297375625e-04f, -2.405142376e-02f, -4.284082463e-02f, -4.482952156e-02f, -2.508817080e-02f, +9.690955455e-03f, +4.356586989e-02f, +5.968850142e-02f, +4.979207444e-02f, +1.896631116e-02f, -1.728991084e-02f, -4.187660248e-02f, -4.528290008e-02f, -2.971159648e-02f, -6.200625263e-03f, +1.272863203e-02f, +1.994816618e-02f, +1.618294747e-02f, +7.472772354e-03f, +2.452638605e-04f,
        +2.104601690e-04f, +3.993464764e-04f, +4.757332307e-04f, +3.068410823e-04f, -1.817908411e-04f, -9.487781880e-04f, -1.819657590e-03f, -2.526954351e-03f, -2.799358667e-03f, -2.467241525e-03f, -1.540207185e-03f, -2.207709909e-04f, +1.156024991e-03f, +2.235493821e-03f, +2.764049302e-03f, +2.669698029e-03f, +2.071919147e-03f, +1.221155193e-03f, +3.972566074e-04f, -1.892184824e-04f, -4.545892232e-04f, -4.419538543e-04f, -2.732581479e-04f, -8.201546497e-05f,
        -5.083202561e-04f, -5.339073330e-04f, -1.255798718e-04f, +6.257092953e-04f, +1.323931112e-03f, +1.468191662e-03f, +7.868528144e-04f, -5.166085836e-04f, -1.802710912e-03f, -2.338402133e-03f, -1.745995343e-03f, -2.664164598e-04f, +1.350779544e-03f, +2.276061109e-03f, +2.079241865e-03f, +9.572208293e-04f, -4.228354067e-04f, -1.344873748e-03f, -1.448932127e-03f, -8.739496088e-04f, -8.583482063e-05f, +4.552902447e-04f, +5.555919034e-04f, +3.283795848e-04f,
        /*  3, 3 (24) */
        +1.956016071e-04f, -4.645879202e-03f, -1.185161607e-02f, -1.859438728e-02f, -2.026929052e-02f, -1.189258882e-02f, +9.845428186e-03f, +4.467428571e-02f, +8.787555393e-02f, +1.310200633e-01f, +1.642419690e-01f, +1.793083979e-01f, +1.723445870e-01f, +1.451513694e-01f, +1.045904617e-01f, +6.028301106e-02f, +2.152833541e-02f, -5.385662589e-03f, -1.854272616e-02f, -2.009554750e-02f, -1.465306057e-02f, -7.175022152e-03f, -1.255561629e-03f, +1.637135506e-03f,
        +4.824896253e-03f, +1.365240320e-02f, +1.973040491e-02f, +1.635859500e-02f, +6.941935492e-04f, -2.258323209e-02f, -4.205397181e-02f, -4.534613014e-02f, -2.689088171e-02f, +7.352553322e-03f, +4.181987455e-02f, +5.942208496e-02f, +5.114285398e-02f, +2.124237227e-02f, -1.521066897e-02f, -4.091938165e-02f, -4.570573549e-02f, -3.105647023e-02f, -7.649557389e-03f, +1.185468242e-02f, +1.986233136e-02f, +1.663823771e-02f, +8.028364257e-03f, +5.736434452e-04f,
        +1.979929869e-04f, +3.893762465e-04f, +4.769164640e-04f, +3.264831727e-04f, -1.419783847e-04f, -8.953774331e-04f, -1.767005156e-03f, -2.492974943e-03f, -2.799077135e-03f, -2.506546616e-03f, -1.612604977e-03f, -3.087561805e-04f, +1.075285051e-03f, +2.182345887e-03f, +2.749537436e-03f, +2.692427006e-03f, +2.119666297e-03f, +1.276272613e-03f, +4.434038066e-04f, -1.617985515e-04f, -4.471257811e-04f, -4.487787648e-04f, -2.857156265e-04f, -9.260021088e-05f,
        -4.955783754e-04f, -5.441999838e-04f, -1.637979372e-04f, +5.750396416e-04f, +1.291762365e-03f, +1.482651727e-03f, +8.523975536e-04f, -4.276003658e-04f, -1.737624939e-03f, -2.336957375e-03f, -1.814702668e-03f, -3.721903161e-04f, +1.262523044e-03f, +2.249708036e-03f, +2.123754270e-03f, +1.043069845e-03f, -3.437100063e-04f, -1.310035268e-03f, -1.466029931e-03f, -9.216511183e-04f, -1.316393194e-04f, +4.340803772e-04f, +5.613051227e-04f, +3.472813090e-04f,
        /*  3, 4 (24) */
        +3.935945940e-04f, -4.256502956e-03f, -1.137469961e-02f, -1.826790410e-02f, -2.041126890e-02f, -1.278796625e-02f, +8.078423030e-03f, +4.218131077e-02f, +8.507647679e-02f, +1.285135167e-01f, +1.626293640e-01f, +1.789996417e-01f, +1.734198720e-01f, +1.473337153e-01f, +1.073399992e-01f, +6.297543806e-02f, +2.364800170e-02f, -4.109389976e-03f, -1.809932235e-02f, -2.025734605e-02f, -1.510018635e-02f, -7.623800917e-03f, -1.541277256e-03f, +1.544535295e-03f,
        +4.329317877e-03f, +1.310820321e-02f, +1.956660698e-02f, +1.693363464e-02f, +1.985955914e-03f, -2.110058037e-02f, -4.120157426e-02f, -4.577373051e-02f, -2.862850665e-02f, +5.015595947e-03f, +4.000517188e-02f, +5.904989465e-02f, +5.240537703e-02f, +2.349208031e-02f, -1.308691470e-02f, -3.987631180e-02f, -4.604944549e-02f, -3.236650550e-02f, -9.115587320e-03f, +1.093303130e-02f, +1.973069204e-02f, +1.707231809e-02f, +8.589669380e-03f, +9.209247542e-04f,
        +1.856173713e-04f, +3.790053132e-04f, +4.771523044e-04f, +3.448445120e-04f, -1.033249365e-04f, -8.424723868e-04f, -1.713788009e-03f, -2.457323339e-03f, -2.796397255e-03f, -2.543435997e-03f, -1.683354210e-03f, -3.964187036e-04f, +9.934308368e-04f, +2.127027991e-03f, +2.732520978e-03f, +2.713095511e-03f, +2.166344606e-03f, +1.331453758e-03f, +4.904835192e-04f, -1.330852042e-04f, -4.385264485e-04f, -4.549557051e-04f, -2.980704308e-04f, -1.034573888e-04f,
        -4.818993757e-04f, -5.527235910e-04f, -2.005040300e-04f, +5.243308648e-04f, +1.257468758e-03f, +1.493739576e-03f, +9.152437854e-04f, -3.387548764e-04f, -1.669647890e-03f, -2.330915132e-03f, -1.879628459e-03f, -4.771737415e-04f, +1.171604375e-03f, +2.218785848e-03f, +2.164364927e-03f, +1.127698014e-03f, -2.628206788e-04f, -1.271853952e-03f, -1.480271883e-03f, -9.683913798e-04f, -1.784135208e-04f, +4.110468253e-04f, +5.656296573e-04f, +3.658877748e-04f,
        /*  3, 5 (24) */
        +5.792119653e-04f, -3.877497643e-03f, -1.089754730e-02f, -1.792305959e-02f, -2.051459384e-02f, -1.363043864e-02f, +6.364635021e-03f, +3.972398743e-02f, +8.228007954e-02f, +1.259700807e-01f, +1.609460098e-01f, +1.786032230e-01f, +1.744133029e-01f, +1.494607432e-01f, +1.100725201e-01f, +6.568853357e-02f, +2.581434631e-02f, -2.777936218e-03f, -1.760883883e-02f, -2.039043126e-02f, -1.553871280e-02f, -8.078756622e-03f, -1.839347686e-03f, +1.441077907e-03f,
        +3.847418502e-03f, +1.255547962e-02f, +1.936610295e-02f, +1.745796550e-02f, +3.243424672e-03f, -1.960684079e-02f, -4.028633047e-02f, -4.611248539e-02f, -3.029815454e-02f, +2.684680815e-03f, +3.812554342e-02f, +5.857272090e-02f, +5.357698140e-02f, +2.571086615e-02f, -1.092254977e-02f, -3.874861379e-02f, -4.631226617e-02f, -3.363835945e-02f, -1.059585920e-02f, +9.964639919e-03f, +1.955227852e-02f, +1.748336492e-02f, +9.155299037e-03f, +1.286812529e-03f,
        +1.733575038e-04f, +3.682685191e-04f, +4.764716021e-04f, +3.619345721e-04f, -6.585416757e-05f, -7.901188395e-04f, -1.660078177e-03f, -2.420061901e-03f, -2.791346014e-03f, -2.577887010e-03f, -1.752386819e-03f, -4.836671403e-04f, +9.105457041e-04f, +2.069587256e-03f, +2.712997051e-03f, +2.731656131e-03f, +2.211883374e-03f, +1.386631915e-03f, +5.384549270e-04f, -1.030847447e-04f, -4.287690391e-04f, -4.604496465e-04f, -3.102916594e-04f, -1.145711293e-04f,
        -4.673536613e-04f, -5.595050055e-04f, -2.356415290e-04f, +4.737080132e-04f, +1.221171030e-03f, +1.501483663e-03f, +9.752870969e-04f, -2.502647183e-04f, -1.598949545e-03f, -2.320313567e-03f, -1.940646067e-03f, -5.811441735e-04f, +1.078212250e-03f, +2.183341206e-03f, +2.200959607e-03f, +1.210908463e-03f, -1.803268347e-04f, -1.230367738e-03f, -1.491573948e-03f, -1.014036023e-03f, -2.260605998e-04f, +3.862023112e-04f, +5.685097329e-04f, +3.841288250e-04f,
        /*  3, 6 (24) */
        +7.525694691e-04f, -3.509229123e-03f, -1.042107570e-02f, -1.756112502e-02f, -2.058044801e-02f, -1.442055748e-02f, +4.704556844e-03f, +3.730392553e-02f, +7.948873353e-02f, +1.233921937e-01f, +1.591936230e-01f, +1.781195559e-01f, +1.753238486e-01f, +1.515303305e-01f, +1.127855172e-01f, +6.842018971e-02f, +2.802622968e-02f, -1.391304304e-03f, -1.707038391e-02f, -2.049351600e-02f, -1.596748184e-02f, -8.539206269e-03f, -2.149639346e-03f, +1.326506777e-03f,
        +3.380064841e-03f, +1.199597462e-02f, +1.913046142e-02f, +1.793167352e-02f, +4.464595702e-03f, -1.810535713e-02f, -3.931104338e-02f, -4.636275010e-02f, -3.189710408e-02f, +3.643672483e-04f, +3.618489736e-02f, +5.799157673e-02f, +5.465519365e-02f, +2.789420736e-02f, -8.721590167e-03f, -3.753770533e-02f, -4.649259301e-02f, -3.486872719e-02f, -1.208743315e-02f, +8.950603896e-03f, +1.932621792e-02f, +1.786956723e-02f, +9.723808770e-03f, +1.670941354e-03f,
        +1.612365884e-04f, +3.572004027e-04f, +4.749059774e-04f, +3.777646071e-04f, -2.958755077e-05f, -7.383708949e-04f, -1.605947374e-03f, -2.381254415e-03f, -2.783953195e-03f, -2.609880183e-03f, -1.819637087e-03f, -5.704106472e-04f, +8.267144377e-04f, +2.010073659e-03f, +2.690965941e-03f, +2.748063737e-03f, +2.256212560e-03f, +1.441739371e-03f, +5.872751810e-04f, -7.180559553e-05f, -4.178327492e-04f, -4.652258365e-04f, -3.223477431e-04f, -1.259244795e-04f,
        -4.520123982e-04f, -5.645753791e-04f, -2.691592719e-04f, +4.232935213e-04f, +1.182992926e-03f, +1.505920182e-03f, +1.032430991e-03f, -1.623198217e-04f, -1.525704742e-03f, -2.305201100e-03f, -1.997638108e-03f, -6.838814930e-04f, +9.825413188e-04f, +2.143431320e-03f, +2.233432674e-03f, +1.292505997e-03f, -9.639341054e-05f, -1.185623103e-03f, -1.499858136e-03f, -1.058451081e-03f, -2.744793865e-04f, +3.595649614e-04f, +5.698924546e-04f, +4.019335106e-04f,
        /*  3, 7 (24) */
        +9.138060575e-04f, -3.152028721e-03f, -9.946169723e-03f, -1.718336041e-02f, -2.061003556e-02f, -1.515892837e-02f, +3.098609470e-03f, +3.492267111e-02f, +7.670478033e-02f, +1.207823135e-01f, +1.573739859e-01f, +1.775491452e-01f, +1.761505630e-01f, +1.535404042e-01f, +1.154764831e-01f, +7.116825344e-02f, +3.028244224e-02f, +5.043506755e-05f, -1.648310872e-02f, -2.056532160e-02f, -1.638531459e-02f, -9.004432105e-03f, -2.471987089e-03f, +1.200582298e-03f,
        +2.928052442e-03f, +1.143139924e-02f, +1.886130215e-02f, +1.835496704e-02f, +5.647588627e-03f, -1.659943695e-02f, -3.827861238e-02f, -4.652506993e-02f, -3.342280882e-02f, -1.940833852e-03f, +3.418725925e-02f, +5.730769524e-02f, +5.563773497e-02f, +3.003763868e-02f, -6.488157493e-03f, -3.624519933e-02f, -4.658898642e-02f, -3.605435029e-02f, -1.358729129e-02f, +7.892152815e-03f, +1.905173853e-02f, +1.822913219e-02f, +1.029370122e-02f, +2.072874865e-03f,
        +1.492768294e-04f, +3.458351405e-04f, +4.724877501e-04f, +3.923476022e-04f, +5.455638806e-06f, -6.872809102e-04f, -1.551466894e-03f, -2.340965977e-03f, -2.774251318e-03f, -2.639399243e-03f, -1.885041731e-03f, -6.565590831e-04f, +7.420231342e-04f, +1.948539981e-03f, +2.666431117e-03f, +2.762275570e-03f, +2.299262891e-03f, +1.496707509e-03f, +6.368994396e-04f, -3.925831957e-05f, -4.056982208e-04f, -4.692498681e-04f, -3.342064914e-04f, -1.374994109e-04f,
        -4.359472801e-04f, -5.679699851e-04f, -3.010115957e-04f, +3.732069218e-04f, +1.143060823e-03f, +1.507092867e-03f, +1.086587045e-03f, -7.510699606e-05f, -1.450092909e-03f, -2.285636241e-03f, -2.050496729e-03f, -7.851685550e-04f, +8.847917105e-04f, +2.099123840e-03f, +2.261687400e-03f, +1.372297596e-03f, -1.119050572e-05f, -1.137675046e-03f, -1.505052791e-03f, -1.101503364e-03f, -3.235645709e-04f, +3.311583615e-04f, +5.697280296e-04f, +4.192302976e-04f,
        /*  3, 8 (24) */
        +1.063082887e-03f, -2.806193580e-03f, -9.473681973e-03f, -1.679101281e-02f, -2.060457992e-02f, -1.584620928e-02f, +1.547142576e-03f, +3.258170513e-02f, +7.393052901e-02f, +1.181429142e-01f, +1.554889441e-01f, +1.768925861e-01f, +1.768925861e-01f, +1.554889441e-01f, +1.181429142e-01f, +7.393052901e-02f, +3.258170513e-02f, +1.547142576e-03f, -1.584620928e-02f, -2.060457992e-02f, -1.679101281e-02f, -9.473681973e-03f, -2.806193580e-03f, +1.063082887e-03f,
        +2.492105162e-03f, +1.086342925e-02f, +1.856029055e-02f, +1.872817396e-02f, +6.790649451e-03f, -1.509234408e-02f, -3.719202534e-02f, -4.660017692e-02f, -3.487290173e-02f, -4.226470093e-03f, +3.213676252e-02f, +5.652252668e-02f, +5.652252668e-02f, +3.213676252e-02f, -4.226470093e-03f, -3.487290173e-02f, -4.660017692e-02f, -3.719202534e-02f, -1.509234408e-02f, +6.790649451e-03f, +1.872817396e-02f, +1.856029055e-02f, +1.086342925e-02f, +2.492105162e-03f,
        +1.374994109e-04f, +3.342064914e-04f, +4.692498681e-04f, +4.056982208e-04f, +3.925831957e-05f, -6.368994396e-04f, -1.496707509e-03f, -2.299262891e-03f, -2.762275570e-03f, -2.666431117e-03f, -1.948539981e-03f, -7.420231342e-04f, +6.565590831e-04f, +1.885041731e-03f, +2.639399243e-03f, +2.774251318e-03f, +2.340965977e-03f, +1.551466894e-03f, +6.872809102e-04f, -5.455638806e-06f, -3.923476022e-04f, -4.724877501e-04f, -3.458351405e-04f, -1.492768294e-04f,
        -4.192302976e-04f, -5.697280296e-04f, -3.311583615e-04f, +3.235645709e-04f, +1.101503364e-03f, +1.505052791e-03f, +1.137675046e-03f, +1.119050572e-05f, -1.372297596e-03f, -2.261687400e-03f, -2.099123840e-03f, -8.847917105e-04f, +7.851685550e-04f, +2.050496729e-03f, +2.285636241e-03f, +1.450092909e-03f, +7.510699606e-05f, -1.086587045e-03f, -1.507092867e-03f, -1.143060823e-03f, -3.732069218e-04f, +3.010115957e-04f, +5.679699851e-04f, +4.359472801e-04f,
        /*  3, 9 (24) */
        +1.200582298e-03f, -2.471987089e-03f, -9.004432105e-03f, -1.638531459e-02f, -2.056532160e-02f, -1.648310872e-02f, +5.043506755e-05f, +3.028244224e-02f, +7.116825344e-02f, +1.154764831e-01f, +1.535404042e-01f, +1.761505630e-01f, +1.775491452e-01f, +1.573739859e-01f, +1.207823135e-01f, +7.670478033e-02f, +3.492267111e-02f, +3.098609470e-03f, -1.515892837e-02f, -2.061003556e-02f, -1.718336041e-02f, -9.946169723e-03f, -3.152028721e-03f, +9.138060575e-04f,
        +2.072874865e-03f, +1.029370122e-02f, +1.822913219e-02f, +1.905173853e-02f, +7.892152815e-03f, -1.358729129e-02f, -3.605435029e-02f, -4.658898642e-02f, -3.624519933e-02f, -6.488157493e-03f, +3.003763868e-02f, +5.563773497e-02f, +5.730769524e-02f, +3.418725925e-02f, -1.940833852e-03f, -3.342280882e-02f, -4.652506993e-02f, -3.827861238e-02f, -1.659943695e-02f, +5.647588627e-03f, +1.835496704e-02f, +1.886130215e-02f, +1.143139924e-02f, +2.928052442e-03f,
        +1.259244795e-04f, +3.223477431e-04f, +4.652258365e-04f, +4.178327492e-04f, +7.180559553e-05f, -5.872751810e-04f, -1.441739371e-03f, -2.256212560e-03f, -2.748063737e-03f, -2.690965941e-03f, -2.010073659e-03f, -8.267144377e-04f, +5.704106472e-04f, +1.819637087e-03f, +2.609880183e-03f, +2.783953195e-03f, +2.381254415e-03f, +1.605947374e-03f, +7.383708949e-04f, +2.958755077e-05f, -3.777646071e-04f, -4.749059774e-04f, -3.572004027e-04f, -1.612365884e-04f,
        -4.019335106e-04f, -5.698924546e-04f, -3.595649614e-04f, +2.744793865e-04f, +1.058451081e-03f, +1.499858136e-03f, +1.185623103e-03f, +9.639341054e-05f, -1.292505997e-03f, -2.233432674e-03f, -2.143431320e-03f, -9.825413188e-04f, +6.838814930e-04f, +1.997638108e-03f, +2.305201100e-03f, +1.525704742e-03f, +1.623198217e-04f, -1.032430991e-03f, -1.505920182e-03f, -1.182992926e-03f, -4.232935213e-04f, +2.691592719e-04f, +5.645753791e-04f, +4.520123982e-04f,
        /*  3,10 (24) */
        +1.326506777e-03f, -2.149639346e-03f, -8.539206269e-03f, -1.596748184e-02f, -2.049351600e-02f, -1.707038391e-02f, -1.391304304e-03f, +2.802622968e-02f, +6.842018971e-02f, +1.127855172e-01f, +1.515303305e-01f, +1.753238486e-01f, +1.781195559e-01f, +1.591936230e-01f, +1.233921937e-01f, +7.948873353e-02f, +3.730392553e-02f, +4.704556844e-03f, -1.442055748e-02f, -2.058044801e-02f, -1.756112502e-02f, -1.042107570e-02f, -3.509229123e-03f, +7.525694691e-04f,
        +1.670941354e-03f, +9.723808770e-03f, +1.786956723e-02f, +1.932621792e-02f, +8.950603896e-03f, -1.208743315e-02f, -3.486872719e-02f, -4.649259301e-02f, -3.753770533e-02f, -8.721590167e-03f, +2.789420736e-02f, +5.465519365e-02f, +5.799157673e-02f, +3.618489736e-02f, +3.643672483e-04f, -3.189710408e-02f, -4.636275010e-02f, -3.931104338e-02f, -1.810535713e-02f, +4.464595702e-03f, +1.793167352e-02f, +1.913046142e-02f, +1.199597462e-02f, +3.380064841e-03f,
        +1.145711293e-04f, +3.102916594e-04f, +4.604496465e-04f, +4.287690391e-04f, +1.030847447e-04f, -5.384549270e-04f, -1.386631915e-03f, -2.211883374e-03f, -2.731656131e-03f, -2.712997051e-03f, -2.069587256e-03f, -9.105457041e-04f, +4.836671403e-04f, +1.752386819e-03f, +2.577887010e-03f, +2.791346014e-03f, +2.420061901e-03f, +1.660078177e-03f, +7.901188395e-04f, +6.585416757e-05f, -3.619345721e-04f, -4.764716021e-04f, -3.682685191e-04f, -1.733575038e-04f,
        -3.841288250e-04f, -5.685097329e-04f, -3.862023112e-04f, +2.260605998e-04f, +1.014036023e-03f, +1.491573948e-03f, +1.230367738e-03f, +1.803268347e-04f, -1.210908463e-03f, -2.200959607e-03f, -2.183341206e-03f, -1.078212250e-03f, +5.811441735e-04f, +1.940646067e-03f, +2.320313567e-03f, +1.598949545e-03f, +2.502647183e-04f, -9.752870969e-04f, -1.501483663e-03f, -1.221171030e-03f, -4.737080132e-04f, +2.356415290e-04f, +5.595050055e-04f, +4.673536613e-04f,
        /*  3,11 (24) */
        +1.441077907e-03f, -1.839347686e-03f, -8.078756622e-03f, -1.553871280e-02f, -2.039043126e-02f, -1.760883883e-02f, -2.777936218e-03f, +2.581434631e-02f, +6.568853357e-02f, +1.100725201e-01f, +1.494607432e-01f, +1.744133029e-01f, +1.786032230e-01f, +1.609460098e-01f, +1.259700807e-01f, +8.228007954e-02f, +3.972398743e-02f, +6.364635021e-03f, -1.363043864e-02f, -2.051459384e-02f, -1.792305959e-02f, -1.089754730e-02f, -3.877497643e-03f, +5.792119653e-04f,
        +1.286812529e-03f, +9.155299037e-03f, +1.748336492e-02f, +1.955227852e-02f, +9.964639919e-03f, -1.059585920e-02f, -3.363835945e-02f, -4.631226617e-02f, -3.874861379e-02f, -1.092254977e-02f, +2.571086615e-02f, +5.357698140e-02f, +5.857272090e-02f, +3.812554342e-02f, +2.684680815e-03f, -3.029815454e-02f, -4.611248539e-02f, -4.028633047e-02f, -1.960684079e-02f, +3.243424672e-03f, +1.745796550e-02f, +1.936610295e-02f, +1.255547962e-02f, +3.847418502e-03f,
        +1.034573888e-04f, +2.980704308e-04f, +4.549557051e-04f, +4.385264485e-04f, +1.330852042e-04f, -4.904835192e-04f, -1.331453758e-03f, -2.166344606e-03f, -2.713095511e-03f, -2.732520978e-03f, -2.127027991e-03f, -9.934308368e-04f, +3.964187036e-04f, +1.683354210e-03f, +2.543435997e-03f, +2.796397255e-03f, +2.457323339e-03f, +1.713788009e-03f, +8.424723868e-04f, +1.033249365e-04f, -3.448445120e-04f, -4.771523044e-04f, -3.790053132e-04f, -1.856173713e-04f,
        -3.658877748e-04f, -5.656296573e-04f, -4.110468253e-04f, +1.784135208e-04f, +9.683913798e-04f, +1.480271883e-03f, +1.271853952e-03f, +2.628206788e-04f, -1.127698014e-03f, -2.164364927e-03f, -2.218785848e-03f, -1.171604375e-03f, +4.771737415e-04f, +1.879628459e-03f, +2.330915132e-03f, +1.669647890e-03f, +3.387548764e-04f, -9.152437854e-04f, -1.493739576e-03f, -1.257468758e-03f, -5.243308648e-04f, +2.005040300e-04f, +5.527235910e-04f, +4.818993757e-04f,
        /*  3,12 (24) */
        +1.544535295e-03f, -1.541277256e-03f, -7.623800917e-03f, -1.510018635e-02f, -2.025734605e-02f, -1.809932235e-02f, -4.109389976e-03f, +2.364800170e-02f, +6.297543806e-02f, +1.073399992e-01f, +1.473337153e-01f, +1.734198720e-01f, +1.789996417e-01f, +1.626293640e-01f, +1.285135167e-01f, +8.507647679e-02f, +4.218131077e-02f, +8.078423030e-03f, -1.278796625e-02f, -2.041126890e-02f, -1.826790410e-02f, -1.137469961e-02f, -4.256502956e-03f, +3.935945940e-04f,
        +9.209247542e-04f, +8.589669380e-03f, +1.707231809e-02f, +1.973069204e-02f, +1.093303130e-02f, -9.115587320e-03f, -3.236650550e-02f, -4.604944549e-02f, -3.987631180e-02f, -1.308691470e-02f, +2.349208031e-02f, +5.240537703e-02f, +5.904989465e-02f, +4.000517188e-02f, +5.015595947e-03f, -2.862850665e-02f, -4.577373051e-02f, -4.120157426e-02f, -2.110058037e-02f, +1.985955914e-03f, +1.693363464e-02f, +1.956660698e-02f, +1.310820321e-02f, +4.329317877e-03f,
        +9.260021088e-05f, +2.857156265e-04f, +4.487787648e-04f, +4.471257811e-04f, +1.617985515e-04f, -4.434038066e-04f, -1.276272613e-03f, -2.119666297e-03f, -2.692427006e-03f, -2.749537436e-03f, -2.182345887e-03f, -1.075285051e-03f, +3.087561805e-04f, +1.612604977e-03f, +2.506546616e-03f, +2.799077135e-03f, +2.492974943e-03f, +1.767005156e-03f, +8.953774331e-04f, +1.419783847e-04f, -3.264831727e-04f, -4.769164640e-04f, -3.893762465e-04f, -1.979929869e-04f,
        -3.472813090e-04f, -5.613051227e-04f, -4.340803772e-04f, +1.316393194e-04f, +9.216511183e-04f, +1.466029931e-03f, +1.310035268e-03f, +3.437100063e-04f, -1.043069845e-03f, -2.123754270e-03f, -2.249708036e-03f, -1.262523044e-03f, +3.721903161e-04f, +1.814702668e-03f, +2.336957375e-03f, +1.737624939e-03f, +4.276003658e-04f, -8.523975536e-04f, -1.482651727e-03f, -1.291762365e-03f, -5.750396416e-04f, +1.637979372e-04f, +5.441999838e-04f, +4.955783754e-04f,
        /*  3,13 (24) */
        +1.637135506e-03f, -1.255561629e-03f, -7.175022152e-03f, -1.465306057e-02f, -2.009554750e-02f, -1.854272616e-02f, -5.385662589e-03f, +2.152833541e-02f, +6.028301106e-02f, +1.045904617e-01f, +1.451513694e-01f, +1.723445870e-01f, +1.793083979e-01f, +1.642419690e-01f, +1.310200633e-01f, +8.787555393e-02f, +4.467428571e-02f, +9.845428186e-03f, -1.189258882e-02f, -2.026929052e-02f, -1.859438728e-02f, -1.185161607e-02f, -4.645879202e-03f, +1.956016071e-04f,
        +5.736434452e-04f, +8.028364257e-03f, +1.663823771e-02f, +1.986233136e-02f, +1.185468242e-02f, -7.649557389e-03f, -3.105647023e-02f, -4.570573549e-02f, -4.091938165e-02f, -1.521066897e-02f, +2.124237227e-02f, +5.114285398e-02f, +5.942208496e-02f, +4.181987455e-02f, +7.352553322e-03f, -2.689088171e-02f, -4.534613014e-02f, -4.205397181e-02f, -2.258323209e-02f, +6.941935492e-04f, +1.635859500e-02f, +1.973040491e-02f, +1.365240320e-02f, +4.824896253e-03f,
        +8.201546497e-05f, +2.732581479e-04f, +4.419538543e-04f, +4.545892232e-04f, +1.892184824e-04f, -3.972566074e-04f, -1.221155193e-03f, -2.071919147e-03f, -2.669698029e-03f, -2.764049302e-03f, -2.235493821e-03f, -1.156024991e-03f, +2.207709909e-04f, +1.540207185e-03f, +2.467241525e-03f, +2.799358667e-03f, +2.526954351e-03f, +1.819657590e-03f, +9.487781880e-04f, +1.817908411e-04f, -3.068410823e-04f, -4.757332307e-04f, -3.993464764e-04f, -2.104601690e-04f,
        -3.283795848e-04f, -5.555919034e-04f, -4.552902447e-04f, +8.583482063e-05f, +8.739496088e-04f, +1.448932127e-03f, +1.344873748e-03f, +4.228354067e-04f, -9.572208293e-04f, -2.079241865e-03f, -2.276061109e-03f, -1.350779544e-03f, +2.664164598e-04f, +1.745995343e-03f, +2.338402133e-03f, +1.802710912e-03f, +5.166085836e-04f, -7.868528144e-04f, -1.468191662e-03f, -1.323931112e-03f, -6.257092953e-04f, +1.255798718e-04f, +5.339073330e-04f, +5.083202561e-04f,
        /*  3,14 (24) */
        +1.719150971e-03f, -9.823034812e-04f, -6.733068298e-03f, -1.419847135e-02f, -1.990632902e-02f, -1.893998277e-02f, -6.606817783e-03f, +1.945641626e-02f, +5.761331303e-02f, +1.018264124e-01f, +1.429158756e-01f, +1.711885620e-01f, +1.795291689e-01f, +1.657821762e-01f, +1.334873048e-01f, +9.067491260e-02f, +4.720124006e-02f, +1.166508578e-02f, -1.094381063e-02f, -2.008749968e-02f, -1.890122836e-02f, -1.232734930e-02f, -5.045225679e-03f, -1.485856194e-05f,
        +2.452638605e-04f, +7.472772354e-03f, +1.618294747e-02f, +1.994816618e-02f, +1.272863203e-02f, -6.200625263e-03f, -2.971159648e-02f, -4.528290008e-02f, -4.187660248e-02f, -1.728991084e-02f, +1.896631116e-02f, +4.979207444e-02f, +5.968850142e-02f, +4.356586989e-02f, +9.690955455e-03f, -2.508817080e-02f, -4.482952156e-02f, -4.284082463e-02f, -2.405142376e-02f, -6.297375625e-04f, +1.573288570e-02f, +1.985598479e-02f, +1.418631053e-02f, +5.333216509e-03f,
        +7.171793133e-05f, +2.607281858e-04f, +4.345162095e-04f, +4.609402801e-04f, +2.153407861e-04f, -3.520806754e-04f, -1.166167127e-03f, -2.023174408e-03f, -2.644958192e-03f, -2.776062594e-03f, -2.286427588e-03f, -1.235568842e-03f, +1.325550036e-04f, +1.466231160e-03f, +2.425546548e-03f, +2.797217717e-03f, +2.559200721e-03f, +1.871673067e-03f, +1.002617239e-03f, +2.227364395e-04f, -2.859105993e-04f, -4.735725955e-04f, -4.088809149e-04f, -2.229937837e-04f,
        -3.092517675e-04f, -5.485484257e-04f, -4.746690398e-04f, +4.109231554e-05f, +8.254212634e-04f, +1.429068254e-03f, +1.376339999e-03f, +5.000433397e-04f, -8.703490222e-04f, -2.030950215e-03f, -2.297809027e-03f, -1.436191554e-03f, +1.600766433e-04f, +1.673642119e-03f, +2.335221636e-03f, +1.864741531e-03f, +6.055847117e-04f, -7.187217155e-04f, -1.450338834e-03f, -1.353857631e-03f, -6.762124622e-04f, +8.591185626e-05f, +5.218232591e-04f, +5.200556115e-04f,
        /*  3,15 (24) */
        +1.790868903e-03f, -7.215752954e-04f, -6.298552089e-03f, -1.373753107e-02f, -1.969098823e-02f, -1.929206344e-02f, -7.772984909e-03f, +1.743324185e-02f, +5.496835484e-02f, +9.905034982e-02f, +1.406294480e-01f, +1.699529931e-01f, +1.796617239e-01f, +1.672484073e-01f, +1.359128514e-01f, +9.347213031e-02f, +4.976044078e-02f, +1.353675884e-02f, -9.941193394e-03f, -1.986476324e-02f, -1.918713896e-02f, -1.280092190e-02f, -5.454106594e-03f, -2.378523456e-04f,
        -6.398790701e-05f, +6.924223928e-03f, +1.570827843e-02f, +1.998925849e-02f, +1.355405329e-02f, -4.771557009e-03f, -2.833525649e-02f, -4.478285674e-02f, -4.274695150e-02f, -1.932086105e-02f, +1.666850214e-02f, +4.835588289e-02f, +5.984857807e-02f, +4.523951201e-02f, +1.202617709e-02f, -2.322342926e-02f, -4.422393685e-02f, -4.355954634e-02f, -2.550176259e-02f, -1.983595193e-03f, +1.505667324e-02f, +1.994189664e-02f, +1.470813379e-02f, +5.853272120e-03f,
        +6.172129803e-05f, +2.481551782e-04f, +4.265012055e-04f, +4.662037107e-04f, +2.401633161e-04f, -3.079126691e-04f, -1.111372868e-03f, -1.973503767e-03f, -2.618259216e-03f, -2.785586443e-03f, -2.335105944e-03f, -1.313836442e-03f, +4.420040917e-05f, +1.390749392e-03f, +2.381490657e-03f, +2.792633064e-03f, +2.589654838e-03f, +1.922979241e-03f, +1.056835617e-03f, +2.647871259e-04f, -2.636859589e-04f, -4.704054608e-04f, -4.179442895e-04f, -2.355677716e-04f,
        -2.899658374e-04f, -5.402355369e-04f, -4.922146246e-04f, -2.500611640e-06f, +7.762001769e-04f, +1.406533530e-03f, +1.404413140e-03f, +5.751864623e-04f, -7.826531639e-04f, -1.979009750e-03f, -2.314926423e-03f, -1.518583567e-03f, +5.339670306e-05f, +1.597787307e-03f, +2.327398621e-03f, +1.923558464e-03f, +6.943321844e-04f, -6.481239362e-04f, -1.429080757e-03f, -1.381428286e-03f, -7.264197738e-04f, +4.486124072e-05f, +5.079300130e-04f, +5.307162707e-04f,
        /*  4, 0 (24) */
        +5.910568274e-03f, +9.344012921e-03f, +6.715430524e-03f, -5.120571451e-03f, -2.296499959e-02f, -3.581520112e-02f, -2.874793219e-02f, +8.820490956e-03f, +7.496489258e-02f, +1.526479177e-01f, +2.154764560e-01f, +2.396078991e-01f, +2.154764560e-01f, +1.526479177e-01f, +7.496489258e-02f, +8.820490956e-03f, -2.874793219e-02f, -3.581520112e-02f, -2.296499959e-02f, -5.120571451e-03f, +6.715430524e-03f, +9.344012921e-03f, +5.910568274e-03f, +1.498636456e-03f,
        -1.109690051e-02f, -9.192118277e-03f, +4.909501427e-03f, +2.390317093e-02f, +3.104677588e-02f, +1.408111182e-02f, -2.057860987e-02f, -4.829599839e-02f, -4.456558545e-02f, -7.016204252e-03f, +3.922878654e-02f, +5.990197477e-02f, +3.922878654e-02f, -7.016204252e-03f, -4.456558545e-02f, -4.829599839e-02f, -2.057860987e-02f, +1.408111182e-02f, +3.104677588e-02f, +2.390317093e-02f, +4.909501427e-03f, -9.192118277e-03f, -1.109690051e-02f, -5.253212842e-03f,
        -2.951484991e-04f, -8.998572355e-05f, +4.255442201e-04f, +9.901057327e-04f, +1.116641160e-03f, +3.722451400e-04f, -1.274855305e-03f, -3.283987023e-03f, -4.716191528e-03f, -4.708889279e-03f, -2.988536699e-03f, -9.759711223e-05f, +2.832420010e-03f, +4.650032366e-03f, +4.764596193e-03f, +3.400912380e-03f, +1.398317305e-03f, -2.930402722e-04f, -1.098620861e-03f, -1.016363493e-03f, -4.637030991e-04f, +6.571341915e-05f, +2.920803586e-04f, +2.282445394e-04f,
        +2.266093497e-04f, -4.797135611e-04f, -1.166867229e-03f, -1.027593860e-03f, +2.064743435e-04f, +1.758635466e-03f, +2.269131010e-03f, +9.906663742e-04f, -1.352215341e-03f, -2.966279869e-03f, -2.456219733e-03f, -8.652974051e-05f, +2.349601620e-03f, +3.003693677e-03f, +1.494439848e-03f, -8.598194762e-04f, -2.242182210e-03f, -1.834582014e-03f, -3.074334988e-04f, +9.798976511e-04f, +1.189646801e-03f, +5.316786300e-04f, -1.951059247e-04f, -4.246522513e-04f,
        /*  4, 1 (24) */
        +5.615419775e-03f, +9.254027197e-03f, +7.140974744e-03f, -4.130465718e-03f, -2.184835843e-02f, -3.544295598e-02f, -3.002278750e-02f, +5.536503933e-03f, +7.024870105e-02f, +1.479390285e-01f, +2.124879193e-01f, +2.395103020e-01f, +2.183088760e-01f, +1.572979501e-01f, +7.972948877e-02f, +1.222140334e-02f, -2.734961489e-02f, -3.610824139e-02f, -2.406362045e-02f, -6.136934944e-03f, +6.251727425e-03f, +9.409726340e-03f, +6.202648633e-03f, +1.726880996e-03f,
        -1.087029116e-02f, -9.671831838e-03f, +3.742634198e-03f, +2.287557707e-02f, +3.125325023e-02f, +1.583974728e-02f, -1.830947886e-02f, -4.730533201e-02f, -4.591780079e-02f, -9.982484121e-03f, +3.677256680e-02f, +5.981544503e-02f, +4.157838816e-02f, -4.012510575e-03f, -4.307114560e-02f, -4.915581786e-02f, -2.282079208e-02f, +1.224652980e-02f, +3.073934238e-02f, +2.488306858e-02f, +6.099148229e-03f, -8.660439647e-03f, -1.129200643e-02f, -5.677865093e-03f,
        -2.970618278e-04f, -1.129423443e-04f, +3.876607392e-04f, +9.621230615e-04f, +1.131121191e-03f, +4.477215948e-04f, -1.152951352e-03f, -3.164785433e-03f, -4.661959248e-03f, -4.760768184e-03f, -3.139873279e-03f, -2.926316469e-04f, +2.671760396e-03f, +4.584236615e-03f, +4.807012809e-03f, +3.515307214e-03f, +1.523131068e-03f, -2.101728727e-04f, -1.076987578e-03f, -1.040762049e-03f, -5.020325956e-04f, +4.015283030e-05f, +2.878202400e-04f, +2.375338361e-04f,
        +2.558786752e-04f, -4.277888735e-04f, -1.140670631e-03f, -1.070625390e-03f, +1.069857010e-04f, +1.678405860e-03f, +2.288550536e-03f, +1.116953835e-03f, -1.207005506e-03f, -2.919959996e-03f, -2.555009560e-03f, -2.593092511e-04f, +2.235480908e-03f, +3.032033182e-03f, +1.633187849e-03f, -7.247999891e-04f, -2.207693370e-03f, -1.905912608e-03f, -4.095350395e-04f, +9.276022135e-04f, +1.208828944e-03f, +5.834744348e-04f, -1.614262971e-04f, -4.267160150e-04f,
        /*  4, 2 (24) */
        +5.318357947e-03f, +9.141084853e-03f, +7.528635483e-03f, -3.168342657e-03f, -2.071723724e-02f, -3.499523439e-02f, -3.117573885e-02f, +2.371718500e-03f, +6.558674180e-02f, +1.431782603e-01f, +2.093480460e-01f, +2.392176703e-01f, +2.209806364e-01f, +1.618821867e-01f, +8.453650158e-02f, +1.573671055e-02f, -2.582648382e-02f, -3.631841427e-02f, -2.514060803e-02f, -7.177696994e-03f, +5.749694829e-03f, +9.449879170e-03f, +6.490468873e-03f, +1.964414832e-03f,
        -1.061441248e-02f, -1.009962071e-02f, +2.601963567e-03f, +2.180495168e-02f, +3.136023593e-02f, +1.751815314e-02f, -1.602092833e-02f, -4.618837818e-02f, -4.712480630e-02f, -1.290244412e-02f, +3.421755724e-02f, +5.955613578e-02f, +4.381386906e-02f, -9.804773931e-04f, -4.143795775e-02f, -4.988061785e-02f, -2.502848545e-02f, +1.034061719e-02f, +3.032980734e-02f, +2.581067080e-02f, +7.307977172e-03f, -8.076965213e-03f, -1.145343273e-02f, -6.104581108e-03f,
        -2.978600871e-04f, -1.345608566e-04f, +3.501533590e-04f, +9.325503775e-04f, +1.142140271e-03f, +5.194134739e-04f, -1.032804775e-03f, -3.043562935e-03f, -4.602069579e-03f, -4.805643658e-03f, -3.286202528e-03f, -4.871874507e-04f, +2.506804536e-03f, +4.511554930e-03f, +4.843291167e-03f, +3.626918859e-03f, +1.649083741e-03f, -1.237185549e-04f, -1.051675519e-03f, -1.063168091e-03f, -5.404240438e-04f, +1.333639036e-05f, +2.823337555e-04f, +2.463641198e-04f,
        +2.828673928e-04f, -3.761084583e-04f, -1.111246460e-03f, -1.108945667e-03f, +9.284478218e-06f, +1.594236343e-03f, +2.300477815e-03f, +1.238314598e-03f, -1.059308148e-03f, -2.864931819e-03f, -2.645672812e-03f, -4.312498432e-04f, +2.114209588e-03f, +3.051160400e-03f, +1.767976602e-03f, -5.860131168e-04f, -2.165680325e-03f, -1.972306011e-03f, -5.124407003e-04f, +8.707919742e-04f, +1.224243239e-03f, +6.348863357e-04f, -1.256397887e-04f, -4.268311281e-04f,
        /*  4, 3 (24) */
        +5.020497860e-03f, +9.006523996e-03f, +7.878788842e-03f, -2.235792279e-03f, -1.957509697e-02f, -3.447582091e-02f, -3.220854363e-02f, -6.718444343e-04f, +6.098467222e-02f, +1.383726166e-01f, +2.060618435e-01f, +2.387304829e-01f, +2.234874410e-01f, +1.663937416e-01f, +8.937979275e-02f, +1.936362941e-02f, -2.417740008e-02f, -3.644213282e-02f, -2.619228355e-02f, -8.240865085e-03f, +5.209270785e-03f, +9.463215561e-03f, +6.772802628e-03f, +2.210778952e-03f,
        -1.033154509e-02f, -1.047572917e-02f, +1.490717107e-03f, +2.069600601e-02f, +3.136952040e-02f, +1.911238949e-02f, -1.372045051e-02f, -4.495006358e-02f, -4.818411445e-02f, -1.576737594e-02f, +3.157188443e-02f, +5.912488593e-02f, +4.592807865e-02f, +2.070683007e-03f, -3.966998115e-02f, -5.046663097e-02f, -2.719416578e-02f, +8.368311183e-03f, +2.981736664e-02f, +2.668146277e-02f, +8.532220411e-03f, -7.442078877e-03f, -1.157907252e-02f, -6.531412236e-03f,
        -2.975853885e-04f, -1.548237372e-04f, +3.131185268e-04f, +9.015228143e-04f, +1.149783980e-03f, +5.872742939e-04f, -9.146076028e-04f, -2.920575309e-03f, -4.536702075e-03f, -4.843503992e-03f, -3.427307645e-03f, -6.809464965e-04f, +2.337808095e-03f, +4.432053922e-03f, +4.873291706e-03f, +3.735496851e-03f, +1.775956290e-03f, -3.376265471e-05f, -1.022626124e-03f, -1.083449670e-03f, -5.787651005e-04f, -1.469838763e-05f, +2.755894962e-04f, +2.546810981e-04f,
        +3.075402963e-04f, -3.248697309e-04f, -1.078792266e-03f, -1.142526828e-03f, -8.632466115e-05f, +1.506478905e-03f, +2.304975695e-03f, +1.354402136e-03f, -9.096258639e-04f, -2.801421778e-03f, -2.727939590e-03f, -6.017955435e-04f, +1.986164759e-03f, +3.060968227e-03f, +1.898333598e-03f, -4.438811070e-04f, -2.116185752e-03f, -2.033454008e-03f, -6.158032162e-04f, +8.095703561e-04f, +1.235730167e-03f, +6.856954984e-04f, -8.782713262e-05f, -4.249196111e-04f,
        /*  4, 4 (24) */
        +4.722912471e-03f, +8.851700259e-03f, +8.191907369e-03f, -1.334269465e-03f, -1.842531299e-02f, -3.388854662e-02f, -3.312315123e-02f, -3.592419744e-03f, +5.644797015e-02f, +1.335291126e-01f, +2.026345359e-01f, +2.380495364e-01f, +2.258252491e-01f, +1.708257956e-01f, +9.425308445e-02f, +2.309912626e-02f, -2.240144379e-02f, -3.647589548e-02f, -2.721490967e-02f, -9.324314755e-03f, +4.630505685e-03f, +9.448517173e-03f, +7.048392124e-03f, +2.465460050e-03f,
        -1.002400480e-02f, -1.080059890e-02f, +4.119248402e-04f, +1.955347919e-02f, +3.128319574e-02f, +2.061886839e-02f, -1.141547482e-02f, -4.359566145e-02f, -4.909374031e-02f, -1.856879772e-02f, +2.884394484e-02f, +5.852309039e-02f, +4.791424341e-02f, +5.131651235e-03f, -3.777164755e-02f, -5.091051208e-02f, -2.931035153e-02f, +6.334857175e-03f, +2.920156343e-02f, +2.749103313e-02f, +9.767950579e-03f, -6.756383379e-03f, -1.166689965e-02f, -6.956331847e-03f,
        -2.962820044e-04f, -1.737182778e-04f, +2.766482744e-04f, +8.691753767e-04f, +1.154143821e-03f, +6.512671889e-04f, -7.985442235e-04f, -2.796078215e-03f, -4.466045145e-03f, -4.874351128e-03f, -3.562982669e-03f, -8.735924451e-04f, +2.165035212e-03f, +4.345813839e-03f, +4.896885906e-03f, +3.840793525e-03f, +1.903523927e-03f, +5.959980534e-05f, -9.897883643e-04f, -1.101476584e-03f, -6.169399693e-04f, -4.390887979e-05f, +2.675592264e-04f, +2.624303860e-04f,
        +3.298733464e-04f, -2.742629533e-04f, -1.043512724e-03f, -1.171359473e-03f, -1.795502555e-04f, +1.415492934e-03f, +2.302132318e-03f, +1.464891720e-03f, -7.584642122e-04f, -2.729684053e-03f, -2.801569278e-03f, -7.703953239e-04f, +1.851747335e-03f, +3.061380951e-03f, +2.023798326e-03f, -2.988418656e-04f, -2.059279315e-03f, -2.089062742e-03f, -7.192675144e-04f, +7.440597219e-04f, +1.243141989e-03f, +7.356797266e-04f, -4.808040719e-05f, -4.209105440e-04f,
        /*  4, 5 (24) */
        +4.426630467e-03f, +8.677981981e-03f, +8.468555643e-03f, -4.650940882e-04f, -1.727116917e-02f, -3.323727943e-02f, -3.392169545e-02f, -6.388497959e-03f, +5.198192500e-02f, +1.286547615e-01f, +1.990715532e-01f, +2.371759439e-01f, +2.279902843e-01f, +1.751716094e-01f, +9.914997036e-02f, +2.693991978e-02f, -2.049791986e-02f, -3.641629567e-02f, -2.820469804e-02f, -1.042579134e-02f, +4.013565716e-03f, +9.404608293e-03f, +7.315951351e-03f, +2.727890436e-03f,
        -9.694131449e-03f, -1.107486185e-02f, -6.315878842e-04f, +1.838211971e-02f, +3.110364549e-02f, +2.203436132e-02f, -9.113342497e-03f, -4.213076973e-02f, -4.985220452e-02f, -2.129848177e-02f, +2.604237556e-02f, +5.775269507e-02f, +4.976599075e-02f, +8.193032186e-03f, -3.574784923e-02f, -5.120935394e-02f, -3.136963085e-02f, +4.245794433e-03f, +2.848229591e-02f, +2.823509285e-02f, +1.101109257e-02f, -6.020703652e-03f, -1.171498006e-02f, -7.377242391e-03f,
        -2.939961575e-04f, -1.912364864e-04f, +2.408300730e-04f, +8.356425853e-04f, +1.155316863e-03f, +7.113648240e-04f, -6.847910800e-04f, -2.670326620e-03f, -4.390295559e-03f, -4.898200576e-03f, -3.693032886e-03f, -1.064811314e-03f, +1.988757954e-03f, +4.252928462e-03f, +4.913956657e-03f, +3.942564594e-03f, +2.031556539e-03f, +1.562641763e-04f, -9.531190211e-04f, -1.117120767e-03f, -6.548296388e-04f, -7.424733524e-05f, +2.582180735e-04f, +2.695576957e-04f,
        +3.498534893e-04f, -2.244706013e-04f, -1.005618652e-03f, -1.195452352e-03f, -2.701149383e-04f, +1.321643778e-03f, +2.292060497e-03f, +1.569481383e-03f, -6.063298797e-04f, -2.649999522e-03f, -2.866351311e-03f, -9.365050536e-04f, +1.711380664e-03f, +3.052354649e-03f, +2.143924008e-03f, -1.513474996e-04f, -1.995057703e-03f, -2.138854013e-03f, -8.224719531e-04f, +6.744012400e-04f, +1.246343594e-03f, +7.846143283e-04f, -6.502917124e-06f, -4.147405942e-04f,
        /*  4, 6 (24) */
        +4.132634310e-03f, +8.486745495e-03f, +8.709385716e-03f, +3.705484971e-04f, -1.611585230e-02f, -3.252591461e-02f, -3.460648653e-02f, -9.058824578e-03f, +4.759162944e-02f, +1.237565609e-01f, +1.953785203e-01f, +2.361111326e-01f, +2.299790422e-01f, +1.794245379e-01f, +1.040639270e-01f, +3.088248438e-02f, -1.846636332e-02f, -3.626003150e-02f, -2.915781706e-02f, -1.154291211e-02f, +3.358736077e-03f, +9.330360958e-03f, +7.574169424e-03f, +2.997448131e-03f,
        -9.344277959e-03f, -1.129933246e-02f, -1.637206536e-03f, +1.718666736e-02f, +3.083353055e-02f, +2.335600510e-02f, -6.821282000e-03f, -4.056128834e-02f, -5.045853440e-02f, -2.394848129e-02f, +2.317602425e-02f, +5.681619001e-02f, +5.147737141e-02f, +1.124538683e-02f, -3.360392522e-02f, -5.136070144e-02f, -3.336468855e-02f, +2.106940420e-03f, +2.765982396e-02f, +2.890949409e-02f, +1.225743616e-02f, -5.236089324e-03f, -1.172148298e-02f, -7.791982986e-03f,
        -2.907758097e-04f, -2.073749764e-04f, +2.057467055e-04f, +8.010581284e-04f, +1.153405375e-03f, +7.675492868e-04f, -5.735163829e-04f, -2.543574237e-03f, -4.309657937e-03f, -4.915081283e-03f, -3.817275195e-03f, -1.254292140e-03f, +1.809255757e-03f, +4.153504979e-03f, +4.924398615e-03f, +4.040569734e-03f, +2.159819149e-03f, +2.561162685e-04f, -9.125829546e-04f, -1.130256677e-03f, -6.923121357e-04f, -1.056608750e-04f, +2.475447115e-04f, +2.760090310e-04f,
        +3.674784300e-04f, -1.756667778e-04f, -9.653260198e-04f, -1.214831985e-03f, -3.577562621e-04f, +1.225301290e-03f, +2.274897005e-03f, +1.667892799e-03f, -4.537288554e-04f, -2.562674624e-03f, -2.922105845e-03f, -1.099589424e-03f, +1.565509063e-03f, +3.033877471e-03f, +2.258279288e-03f, -1.862795885e-06f, -1.923644569e-03f, -2.182566527e-03f, -9.250496052e-04f, +6.007546715e-04f, +1.245213312e-03f, +8.322730096e-04f, +3.679097804e-05f, -4.063545219e-04f,
        /*  4, 7 (24) */
        +3.841858500e-03f, +8.279370519e-03f, +8.915132422e-03f, +1.171606625e-03f, -1.496244693e-02f, -3.175836532e-02f, -3.518000291e-02f, -1.160239881e-02f, +4.328197151e-02f, +1.188414796e-01f, +1.915612451e-01f, +2.348568405e-01f, +2.317882980e-01f, +1.835780428e-01f, +1.089883256e-01f, +3.492305411e-02f, -1.630654417e-02f, -3.600391523e-02f, -3.007040001e-02f, -1.267316878e-02f, +2.666423941e-03f, +9.224700083e-03f, +7.821714136e-03f, +3.273457162e-03f,
        -8.976799529e-03f, -1.147499923e-02f, -2.602532556e-03f, +1.597183538e-02f, +3.047577429e-02f, +2.458130639e-02f, -4.546384995e-03f, -3.889339554e-02f, -5.091226326e-02f, -2.651115591e-02f, +2.025391841e-02f, +5.571660059e-02f, +5.304288047e-02f, +1.427926431e-02f, -3.134564593e-02f, -5.136256424e-02f, -3.528833312e-02f, -7.562610744e-05f, +2.673477435e-02f, +2.951024876e-02f, +1.350264947e-02f, -4.403816314e-03f, -1.168469200e-02f, -8.198337507e-03f,
        -2.866704507e-04f, -2.221348446e-04f, +1.714761543e-04f, +7.655545239e-04f, +1.148516462e-03f, +8.198119566e-04f, -4.648798487e-04f, -2.416072973e-03f, -4.224344227e-03f, -4.925035484e-03f, -3.935538460e-03f, -1.441727638e-03f, +1.626814845e-03f, +4.047663820e-03f, +4.928118518e-03f, +4.134573166e-03f, +2.288072386e-03f, +3.590324632e-04f, -8.681533514e-04f, -1.140761684e-03f, -7.292627917e-04f, -1.380915066e-04f, +2.355215382e-04f, +2.817308867e-04f,
        +3.827563625e-04f, -1.280166756e-04f, -9.228549643e-04f, -1.229542213e-03f, -4.422274506e-04f, +1.126838381e-03f, +2.250801790e-03f, +1.759872062e-03f, -3.011646206e-04f, -2.468040139e-03f, -2.968684302e-03f, -1.259123840e-03f, +1.414596274e-03f, +3.005969800e-03f, +2.366449877e-03f, +1.491363604e-04f, -1.845190363e-03f, -2.219957098e-03f, -1.026629580e-03f, +5.232980778e-04f, +1.239643690e-03f, +8.784287942e-04f, +8.167608907e-05f, -3.957056594e-04f,
        /*  4, 8 (24) */
        +3.555188049e-03f, +8.057235674e-03f, +9.086608576e-03f, +1.937161149e-03f, -1.381393047e-02f, -3.093855336e-02f, -3.564488276e-02f, -1.401847179e-02f, +3.905762728e-02f, +1.139164441e-01f, +1.876257067e-01f, +2.334151128e-01f, +2.334151128e-01f, +1.876257067e-01f, +1.139164441e-01f, +3.905762728e-02f, -1.401847179e-02f, -3.564488276e-02f, -3.093855336e-02f, -1.381393047e-02f, +1.937161149e-03f, +9.086608576e-03f, +8.057235674e-03f, +3.555188049e-03f,
        -8.594043167e-03f, -1.160301591e-02f, -3.525387520e-03f, +1.474229316e-02f, +3.003354684e-02f, +2.570814477e-02f, -2.295583205e-03f, -3.713352348e-02f, -5.121342788e-02f, -2.897919605e-02f, +1.728523411e-02f, +5.445747675e-02f, +5.445747675e-02f, +1.728523411e-02f, -2.897919605e-02f, -5.121342788e-02f, -3.713352348e-02f, -2.295583205e-03f, +2.570814477e-02f, +3.003354684e-02f, +1.474229316e-02f, -3.525387520e-03f, -1.160301591e-02f, -8.594043167e-03f,
        -2.817308867e-04f, -2.355215382e-04f, +1.380915066e-04f, +7.292627917e-04f, +1.140761684e-03f, +8.681533514e-04f, -3.590324632e-04f, -2.288072386e-03f, -4.134573166e-03f, -4.928118518e-03f, -4.047663820e-03f, -1.626814845e-03f, +1.441727638e-03f, +3.935538460e-03f, +4.925035484e-03f, +4.224344227e-03f, +2.416072973e-03f, +4.648798487e-04f, -8.198119566e-04f, -1.148516462e-03f, -7.655545239e-04f, -1.714761543e-04f, +2.221348446e-04f, +2.866704507e-04f,
        +3.957056594e-04f, -8.167608907e-05f, -8.784287942e-04f, -1.239643690e-03f, -5.232980778e-04f, +1.026629580e-03f, +2.219957098e-03f, +1.845190363e-03f, -1.491363604e-04f, -2.366449877e-03f, -3.005969800e-03f, -1.414596274e-03f, +1.259123840e-03f, +2.968684302e-03f, +2.468040139e-03f, +3.011646206e-04f, -1.759872062e-03f, -2.250801790e-03f, -1.126838381e-03f, +4.422274506e-04f, +1.229542213e-03f, +9.228549643e-04f, +1.280166756e-04f, -3.827563625e-04f,
        /*  4, 9 (24) */
        +3.273457162e-03f, +7.821714136e-03f, +9.224700083e-03f, +2.666423941e-03f, -1.267316878e-02f, -3.007040001e-02f, -3.600391523e-02f, -1.630654417e-02f, +3.492305411e-02f, +1.089883256e-01f, +1.835780428e-01f, +2.317882980e-01f, +2.348568405e-01f, +1.915612451e-01f, +1.188414796e-01f, +4.328197151e-02f, -1.160239881e-02f, -3.518000291e-02f, -3.175836532e-02f, -1.496244693e-02f, +1.171606625e-03f, +8.915132422e-03f, +8.279370519e-03f, +3.841858500e-03f,
        -8.198337507e-03f, -1.168469200e-02f, -4.403816314e-03f, +1.350264947e-02f, +2.951024876e-02f, +2.673477435e-02f, -7.562610744e-05f, -3.528833312e-02f, -5.136256424e-02f, -3.134564593e-02f, +1.427926431e-02f, +5.304288047e-02f, +5.571660059e-02f, +2.025391841e-02f, -2.651115591e-02f, -5.091226326e-02f, -3.889339554e-02f, -4.546384995e-03f, +2.458130639e-02f, +3.047577429e-02f, +1.597183538e-02f, -2.602532556e-03f, -1.147499923e-02f, -8.976799529e-03f,
        -2.760090310e-04f, -2.475447115e-04f, +1.056608750e-04f, +6.923121357e-04f, +1.130256677e-03f, +9.125829546e-04f, -2.561162685e-04f, -2.159819149e-03f, -4.040569734e-03f, -4.924398615e-03f, -4.153504979e-03f, -1.809255757e-03f, +1.254292140e-03f, +3.817275195e-03f, +4.915081283e-03f, +4.309657937e-03f, +2.543574237e-03f, +5.735163829e-04f, -7.675492868e-04f, -1.153405375e-03f, -8.010581284e-04f, -2.057467055e-04f, +2.073749764e-04f, +2.907758097e-04f,
        +4.063545219e-04f, -3.679097804e-05f, -8.322730096e-04f, -1.245213312e-03f, -6.007546715e-04f, +9.250496052e-04f, +2.182566527e-03f, +1.923644569e-03f, +1.862795885e-06f, -2.258279288e-03f, -3.033877471e-03f, -1.565509063e-03f, +1.099589424e-03f, +2.922105845e-03f, +2.562674624e-03f, +4.537288554e-04f, -1.667892799e-03f, -2.274897005e-03f, -1.225301290e-03f, +3.577562621e-04f, +1.214831985e-03f, +9.653260198e-04f, +1.756667778e-04f, -3.674784300e-04f,
        /*  4,10 (24) */
        +2.997448131e-03f, +7.574169424e-03f, +9.330360958e-03f, +3.358736077e-03f, -1.154291211e-02f, -2.915781706e-02f, -3.626003150e-02f, -1.846636332e-02f, +3.088248438e-02f, +1.040639270e-01f, +1.794245379e-01f, +2.299790422e-01f, +2.361111326e-01f, +1.953785203e-01f, +1.237565609e-01f, +4.759162944e-02f, -9.058824578e-03f, -3.460648653e-02f, -3.252591461e-02f, -1.611585230e-02f, +3.705484971e-04f, +8.709385716e-03f, +8.486745495e-03f, +4.132634310e-03f,
        -7.791982986e-03f, -1.172148298e-02f, -5.236089324e-03f, +1.225743616e-02f, +2.890949409e-02f, +2.765982396e-02f, +2.106940420e-03f, -3.336468855e-02f, -5.136070144e-02f, -3.360392522e-02f, +1.124538683e-02f, +5.147737141e-02f, +5.681619001e-02f, +2.317602425e-02f, -2.394848129e-02f, -5.045853440e-02f, -4.056128834e-02f, -6.821282000e-03f, +2.335600510e-02f, +3.083353055e-02f, +1.718666736e-02f, -1.637206536e-03f, -1.129933246e-02f, -9.344277959e-03f,
        -2.695576957e-04f, -2.582180735e-04f, +7.424733524e-05f, +6.548296388e-04f, +1.117120767e-03f, +9.531190211e-04f, -1.562641763e-04f, -2.031556539e-03f, -3.942564594e-03f, -4.913956657e-03f, -4.252928462e-03f, -1.988757954e-03f, +1.064811314e-03f, +3.693032886e-03f, +4.898200576e-03f, +4.390295559e-03f, +2.670326620e-03f, +6.847910800e-04f, -7.113648240e-04f, -1.155316863e-03f, -8.356425853e-04f, -2.408300730e-04f, +1.912364864e-04f, +2.939961575e-04f,
        +4.147405942e-04f, +6.502917124e-06f, -7.846143283e-04f, -1.246343594e-03f, -6.744012400e-04f, +8.224719531e-04f, +2.138854013e-03f, +1.995057703e-03f, +1.513474996e-04f, -2.143924008e-03f, -3.052354649e-03f, -1.711380664e-03f, +9.365050536e-04f, +2.866351311e-03f, +2.649999522e-03f, +6.063298797e-04f, -1.569481383e-03f, -2.292060497e-03f, -1.321643778e-03f, +2.701149383e-04f, +1.195452352e-03f, +1.005618652e-03f, +2.244706013e-04f, -3.498534893e-04f,
        /*  4,11 (24) */
        +2.727890436e-03f, +7.315951351e-03f, +9.404608293e-03f, +4.013565716e-03f, -1.042579134e-02f, -2.820469804e-02f, -3.641629567e-02f, -2.049791986e-02f, +2.693991978e-02f, +9.914997036e-02f, +1.751716094e-01f, +2.279902843e-01f, +2.371759439e-01f, +1.990715532e-01f, +1.286547615e-01f, +5.198192500e-02f, -6.388497959e-03f, -3.392169545e-02f, -3.323727943e-02f, -1.727116917e-02f, -4.650940882e-04f, +8.468555643e-03f, +8.677981981e-03f, +4.426630467e-03f,
        -7.377242391e-03f, -1.171498006e-02f, -6.020703652e-03f, +1.101109257e-02f, +2.823509285e-02f, +2.848229591e-02f, +4.245794433e-03f, -3.136963085e-02f, -5.120935394e-02f, -3.574784923e-02f, +8.193032186e-03f, +4.976599075e-02f, +5.775269507e-02f, +2.604237556e-02f, -2.129848177e-02f, -4.985220452e-02f, -4.213076973e-02f, -9.113342497e-03f, +2.203436132e-02f, +3.110364549e-02f, +1.838211971e-02f, -6.315878842e-04f, -1.107486185e-02f, -9.694131449e-03f,
        -2.624303860e-04f, -2.675592264e-04f, +4.390887979e-05f, +6.169399693e-04f, +1.101476584e-03f, +9.897883643e-04f, -5.959980534e-05f, -1.903523927e-03f, -3.840793525e-03f, -4.896885906e-03f, -4.345813839e-03f, -2.165035212e-03f, +8.735924451e-04f, +3.562982669e-03f, +4.874351128e-03f, +4.466045145e-03f, +2.796078215e-03f, +7.985442235e-04f, -6.512671889e-04f, -1.154143821e-03f, -8.691753767e-04f, -2.766482744e-04f, +1.737182778e-04f, +2.962820044e-04f,
        +4.209105440e-04f, +4.808040719e-05f, -7.356797266e-04f, -1.243141989e-03f, -7.440597219e-04f, +7.192675144e-04f, +2.089062742e-03f, +2.059279315e-03f, +2.988418656e-04f, -2.023798326e-03f, -3.061380951e-03f, -1.851747335e-03f, +7.703953239e-04f, +2.801569278e-03f, +2.729684053e-03f, +7.584642122e-04f, -1.464891720e-03f, -2.302132318e-03f, -1.415492934e-03f, +1.795502555e-04f, +1.171359473e-03f, +1.043512724e-03f, +2.742629533e-04f, -3.298733464e-04f,
        /*  4,12 (24) */
        +2.465460050e-03f, +7.048392124e-03f, +9.448517173e-03f, +4.630505685e-03f, -9.324314755e-03f, -2.721490967e-02f, -3.647589548e-02f, -2.240144379e-02f, +2.309912626e-02f, +9.425308445e-02f, +1.708257956e-01f, +2.258252491e-01f, +2.380495364e-01f, +2.026345359e-01f, +1.335291126e-01f, +5.644797015e-02f, -3.592419744e-03f, -3.312315123e-02f, -3.388854662e-02f, -1.842531299e-02f, -1.334269465e-03f, +8.191907369e-03f, +8.851700259e-03f, +4.722912471e-03f,
        -6.956331847e-03f, -1.166689965e-02f, -6.756383379e-03f, +9.767950579e-03f, +2.749103313e-02f, +2.920156343e-02f, +6.334857175e-03f, -2.931035153e-02f, -5.091051208e-02f, -3.777164755e-02f, +5.131651235e-03f, +4.791424341e-02f, +5.852309039e-02f, +2.884394484e-02f, -1.856879772e-02f, -4.909374031e-02f, -4.359566145e-02f, -1.141547482e-02f, +2.061886839e-02f, +3.128319574e-02f, +1.955347919e-02f, +4.119248402e-04f, -1.080059890e-02f, -1.002400480e-02f,
        -2.546810981e-04f, -2.755894962e-04f, +1.469838763e-05f, +5.787651005e-04f, +1.083449670e-03f, +1.022626124e-03f, +3.376265471e-05f, -1.775956290e-03f, -3.735496851e-03f, -4.873291706e-03f, -4.432053922e-03f, -2.337808095e-03f, +6.809464965e-04f, +3.427307645e-03f, +4.843503992e-03f, +4.536702075e-03f, +2.920575309e-03f, +9.146076028e-04f, -5.872742939e-04f, -1.149783980e-03f, -9.015228143e-04f, -3.131185268e-04f, +1.548237372e-04f, +2.975853885e-04f,
        +4.249196111e-04f, +8.782713262e-05f, -6.856954984e-04f, -1.235730167e-03f, -8.095703561e-04f, +6.158032162e-04f, +2.033454008e-03f, +2.116185752e-03f, +4.438811070e-04f, -1.898333598e-03f, -3.060968227e-03f, -1.986164759e-03f, +6.017955435e-04f, +2.727939590e-03f, +2.801421778e-03f, +9.096258639e-04f, -1.354402136e-03f, -2.304975695e-03f, -1.506478905e-03f, +8.632466115e-05f, +1.142526828e-03f, +1.078792266e-03f, +3.248697309e-04f, -3.075402963e-04f,
        /*  4,13 (24) */
        +2.210778952e-03f, +6.772802628e-03f, +9.463215561e-03f, +5.209270785e-03f, -8.240865085e-03f, -2.619228355e-02f, -3.644213282e-02f, -2.417740008e-02f, +1.936362941e-02f, +8.937979275e-02f, +1.663937416e-01f, +2.234874410e-01f, +2.387304829e-01f, +2.060618435e-01f, +1.383726166e-01f, +6.098467222e-02f, -6.718444343e-04f, -3.220854363e-02f, -3.447582091e-02f, -1.957509697e-02f, -2.235792279e-03f, +7.878788842e-03f, +9.006523996e-03f, +5.020497860e-03f,
        -6.531412236e-03f, -1.157907252e-02f, -7.442078877e-03f, +8.532220411e-03f, +2.668146277e-02f, +2.981736664e-02f, +8.368311183e-03f, -2.719416578e-02f, -5.046663097e-02f, -3.966998115e-02f, +2.070683007e-03f, +4.592807865e-02f, +5.912488593e-02f, +3.157188443e-02f, -1.576737594e-02f, -4.818411445e-02f, -4.495006358e-02f, -1.372045051e-02f, +1.911238949e-02f, +3.136952040e-02f, +2.069600601e-02f, +1.490717107e-03f, -1.047572917e-02f, -1.033154509e-02f,
        -2.463641198e-04f, -2.823337555e-04f, -1.333639036e-05f, +5.404240438e-04f, +1.063168091e-03f, +1.051675519e-03f, +1.237185549e-04f, -1.649083741e-03f, -3.626918859e-03f, -4.843291167e-03f, -4.511554930e-03f, -2.506804536e-03f, +4.871874507e-04f, +3.286202528e-03f, +4.805643658e-03f, +4.602069579e-03f, +3.043562935e-03f, +1.032804775e-03f, -5.194134739e-04f, -1.142140271e-03f, -9.325503775e-04f, -3.501533590e-04f, +1.345608566e-04f, +2.978600871e-04f,
        +4.268311281e-04f, +1.256397887e-04f, -6.348863357e-04f, -1.224243239e-03f, -8.707919742e-04f, +5.124407003e-04f, +1.972306011e-03f, +2.165680325e-03f, +5.860131168e-04f, -1.767976602e-03f, -3.051160400e-03f, -2.114209588e-03f, +4.312498432e-04f, +2.645672812e-03f, +2.864931819e-03f, +1.059308148e-03f, -1.238314598e-03f, -2.300477815e-03f, -1.594236343e-03f, -9.284478218e-06f, +1.108945667e-03f, +1.111246460e-03f, +3.761084583e-04f, -2.828673928e-04f,
        /*  4,14 (24) */
        +1.964414832e-03f, +6.490468873e-03f, +9.449879170e-03f, +5.749694829e-03f, -7.177696994e-03f, -2.514060803e-02f, -3.631841427e-02f, -2.582648382e-02f, +1.573671055e-02f, +8.453650158e-02f, +1.618821867e-01f, +2.209806364e-01f, +2.392176703e-01f, +2.093480460e-01f, +1.431782603e-01f, +6.558674180e-02f, +2.371718500e-03f, -3.117573885e-02f, -3.499523439e-02f, -2.071723724e-02f, -3.168342657e-03f, +7.528635483e-03f, +9.141084853e-03f, +5.318357947e-03f,
        -6.104581108e-03f, -1.145343273e-02f, -8.076965213e-03f, +7.307977172e-03f, +2.581067080e-02f, +3.032980734e-02f, +1.034061719e-02f, -2.502848545e-02f, -4.988061785e-02f, -4.143795775e-02f, -9.804773931e-04f, +4.381386906e-02f, +5.955613578e-02f, +3.421755724e-02f, -1.290244412e-02f, -4.712480630e-02f, -4.618837818e-02f, -1.602092833e-02f, +1.751815314e-02f, +3.136023593e-02f, +2.180495168e-02f, +2.601963567e-03f, -1.009962071e-02f, -1.061441248e-02f,
        -2.375338361e-04f, -2.878202400e-04f, -4.015283030e-05f, +5.020325956e-04f, +1.040762049e-03f, +1.076987578e-03f, +2.101728727e-04f, -1.523131068e-03f, -3.515307214e-03f, -4.807012809e-03f, -4.584236615e-03f, -2.671760396e-03f, +2.926316469e-04f, +3.139873279e-03f, +4.760768184e-03f, +4.661959248e-03f, +3.164785433e-03f, +1.152951352e-03f, -4.477215948e-04f, -1.131121191e-03f, -9.621230615e-04f, -3.876607392e-04f, +1.129423443e-04f, +2.970618278e-04f,
        +4.267160150e-04f, +1.614262971e-04f, -5.834744348e-04f, -1.208828944e-03f, -9.276022135e-04f, +4.095350395e-04f, +1.905912608e-03f, +2.207693370e-03f, +7.247999891e-04f, -1.633187849e-03f, -3.032033182e-03f, -2.235480908e-03f, +2.593092511e-04f, +2.555009560e-03f, +2.919959996e-03f, +1.207005506e-03f, -1.116953835e-03f, -2.288550536e-03f, -1.678405860e-03f, -1.069857010e-04f, +1.070625390e-03f, +1.140670631e-03f, +4.277888735e-04f, -2.558786752e-04f,
        /*  4,15 (24) */
        +1.726880996e-03f, +6.202648633e-03f, +9.409726340e-03f, +6.251727425e-03f, -6.136934944e-03f, -2.406362045e-02f, -3.610824139e-02f, -2.734961489e-02f, +1.222140334e-02f, +7.972948877e-02f, +1.572979501e-01f, +2.183088760e-01f, +2.395103020e-01f, +2.124879193e-01f, +1.479390285e-01f, +7.024870105e-02f, +5.536503933e-03f, -3.002278750e-02f, -3.544295598e-02f, -2.184835843e-02f, -4.130465718e-03f, +7.140974744e-03f, +9.254027197e-03f, +5.615419775e-03f,
        -5.677865093e-03f, -1.129200643e-02f, -8.660439647e-03f, +6.099148229e-03f, +2.488306858e-02f, +3.073934238e-02f, +1.224652980e-02f, -2.282079208e-02f, -4.915581786e-02f, -4.307114560e-02f, -4.012510575e-03f, +4.157838816e-02f, +5.981544503e-02f, +3.677256680e-02f, -9.982484121e-03f, -4.591780079e-02f, -4.730533201e-02f, -1.830947886e-02f, +1.583974728e-02f, +3.125325023e-02f, +2.287557707e-02f, +3.742634198e-03f, -9.671831838e-03f, -1.087029116e-02f,
        -2.282445394e-04f, -2.920803586e-04f, -6.571341915e-05f, +4.637030991e-04f, +1.016363493e-03f, +1.098620861e-03f, +2.930402722e-04f, -1.398317305e-03f, -3.400912380e-03f, -4.764596193e-03f, -4.650032366e-03f, -2.832420010e-03f, +9.759711223e-05f, +2.988536699e-03f, +4.708889279e-03f, +4.716191528e-03f, +3.283987023e-03f, +1.274855305e-03f, -3.722451400e-04f, -1.116641160e-03f, -9.901057327e-04f, -4.255442201e-04f, +8.998572355e-05f, +2.951484991e-04f,
        +4.246522513e-04f, +1.951059247e-04f, -5.316786300e-04f, -1.189646801e-03f, -9.798976511e-04f, +3.074334988e-04f, +1.834582014e-03f, +2.242182210e-03f, +8.598194762e-04f, -1.494439848e-03f, -3.003693677e-03f, -2.349601620e-03f, +8.652974051e-05f, +2.456219733e-03f, +2.966279869e-03f, +1.352215341e-03f, -9.906663742e-04f, -2.269131010e-03f, -1.758635466e-03f, -2.064743435e-04f, +1.027593860e-03f, +1.166867229e-03f, +4.797135611e-04f, -2.266093497e-04f,
        /*  5, 0 (24) */
        -5.186332235e-03f, +1.518946434e-04f, +1.162493195e-02f, +1.878259948e-02f, +8.081776293e-03f, -2.173408931e-02f, -4.932654206e-02f, -3.947550743e-02f, +3.039930713e-02f, +1.456317135e-01f, +2.547052426e-01f, +2.995098738e-01f, +2.547052426e-01f, +1.456317135e-01f, +3.039930713e-02f, -3.947550743e-02f, -4.932654206e-02f, -2.173408931e-02f, +8.081776293e-03f, +1.878259948e-02f, +1.162493195e-02f, +1.518946434e-04f, -5.186332235e-03f, -3.754576386e-03f,
        +4.242013348e-03f, -9.588893426e-03f, -2.119040083e-02f, -1.121093231e-02f, +1.893667489e-02f, +3.896879828e-02f, +1.996482241e-02f, -2.696432742e-02f, -5.400015650e-02f, -2.740375830e-02f, +3.023509818e-02f, +5.990197477e-02f, +3.023509818e-02f, -2.740375830e-02f, -5.400015650e-02f, -2.696432742e-02f, +1.996482241e-02f, +3.896879828e-02f, +1.893667489e-02f, -1.121093231e-02f, -2.119040083e-02f, -9.588893426e-03f, +4.242013348e-03f, +7.021039821e-03f,
        -6.853914940e-05f, -5.696992846e-04f, -7.413230094e-04f, -3.748812743e-05f, +1.323115503e-03f, +2.130880606e-03f, +9.942757047e-04f, -2.293320649e-03f, -6.068406868e-03f, -7.675169148e-03f, -5.444756432e-03f, -1.841268527e-04f, +5.182021629e-03f, +7.653726044e-03f, +6.259036041e-03f, +2.541092904e-03f, -8.438649054e-04f, -2.127622286e-03f, -1.406054360e-03f, -3.646584188e-05f, +7.259437023e-04f, +5.973920492e-04f, +9.697443390e-05f, -1.964077119e-04f,
        +5.374915272e-04f, +1.017778343e-03f, +2.436272238e-04f, -1.397678832e-03f, -1.990629293e-03f, -2.634004448e-04f, +2.374588747e-03f, +2.905843317e-03f, +2.220752786e-04f, -3.102308260e-03f, -3.394742513e-03f, -1.279374424e-04f, +3.274975965e-03f, +3.237786595e-03f, +9.010092975e-06f, -2.823196934e-03f, -2.498183523e-03f, +9.573325739e-05f, +1.951245075e-03f, +1.487925287e-03f, -1.516704686e-04f, -1.012001821e-03f, -5.873543182e-04f, +1.452572160e-04f,
        /*  5, 1 (24) */
        -5.254871384e-03f, -4.178046412e-04f, +1.088360894e-02f, +1.874511135e-02f, +9.404891796e-03f, -1.960320870e-02f, -4.833226636e-02f, -4.176882808e-02f, +2.433090026e-02f, +1.379565443e-01f, +2.492604861e-01f, +2.993257470e-01f, +2.598872642e-01f, +1.532854395e-01f, +3.665834317e-02f, -3.693441453e-02f, -5.017040697e-02f, -2.386171159e-02f, +6.675721933e-03f, +1.874613364e-02f, +1.235087565e-02f, +7.492866926e-04f, -5.089357801e-03f, -3.950984098e-03f,
        +4.779504875e-03f, -8.571115083e-03f, -2.094677361e-02f, -1.260861114e-02f, +1.694604560e-02f, +3.870539783e-02f, +2.233941116e-02f, -2.405848410e-02f, -5.377808122e-02f, -3.050606656e-02f, +2.684035567e-02f, +5.977403733e-02f, +3.351007415e-02f, -2.416597170e-02f, -5.399114641e-02f, -2.978752435e-02f, +1.746663889e-02f, +3.906453154e-02f, +2.088791997e-02f, -9.723007024e-03f, -2.134207130e-02f, -1.060089525e-02f, +3.654659030e-03f, +7.166297037e-03f,
        -4.118315267e-05f, -5.407312178e-04f, -7.530098918e-04f, -1.085023281e-04f, +1.238106892e-03f, +2.126127454e-03f, +1.135599185e-03f, -2.047831598e-03f, -5.868964755e-03f, -7.680728180e-03f, -5.694882839e-03f, -5.519408980e-04f, +4.907241304e-03f, +7.616269797e-03f, +6.440200658e-03f, +2.790507225e-03f, -6.845623020e-04f, -2.116085481e-03f, -1.486522618e-03f, -1.131598359e-04f, +7.067963479e-04f, +6.236272651e-04f, +1.263939429e-04f, -1.891821789e-04f,
        +4.868326252e-04f, +1.018121641e-03f, +3.315723436e-04f, -1.303129426e-03f, -2.019914373e-03f, -4.268501547e-04f, +2.242057320e-03f, +2.974500897e-03f, +4.502080806e-04f, -2.953783155e-03f, -3.499075769e-03f, -3.832212247e-04f, +3.140289727e-03f, +3.359518155e-03f, +2.419900705e-04f, -2.726798420e-03f, -2.612125139e-03f, -7.540916074e-05f, +1.901747710e-03f, +1.573302243e-03f, -5.607367513e-05f, -1.000641246e-03f, -6.360907922e-04f, +1.119438402e-04f,
        /*  5, 2 (24) */
        -5.296054537e-03f, -9.585358590e-04f, +1.013059905e-02f, +1.863660902e-02f, +1.064299869e-02f, -1.747708125e-02f, -4.719666718e-02f, -4.381665968e-02f, +1.846193550e-02f, +1.302758162e-01f, +2.435656033e-01f, +2.987738061e-01f, +2.647945055e-01f, +1.609017093e-01f, +4.309854382e-02f, -3.414390730e-02f, -5.085496927e-02f, -2.597779707e-02f, +5.189199315e-03f, +1.863297380e-02f, +1.305767200e-02f, +1.372913958e-03f, -4.962963858e-03f, -4.140166276e-03f,
        +5.266337501e-03f, -7.552993442e-03f, -2.061520126e-02f, -1.391174057e-02f, +1.492613123e-02f, +3.827854768e-02f, +2.458146848e-02f, -2.108398320e-02f, -5.332787314e-02f, -3.345984971e-02f, +2.334127990e-02f, +5.939081610e-02f, +3.665036387e-02f, -2.080645355e-02f, -5.374915634e-02f, -3.251432277e-02f, +1.485451375e-02f, +3.898912237e-02f, +2.278966768e-02f, -8.149704780e-03f, -2.139814497e-02f, -1.160153649e-02f, +3.018568238e-03f, +7.278240878e-03f,
        -1.499269425e-05f, -5.106693149e-04f, -7.610931012e-04f, -1.763952895e-04f, +1.151424749e-03f, +2.113649817e-03f, +1.267673040e-03f, -1.805248337e-03f, -5.661377727e-03f, -7.670575477e-03f, -5.931875340e-03f, -9.184372939e-04f, +4.621014124e-03f, +7.562715330e-03f, +6.611267769e-03f, +3.040905742e-03f, -5.165965845e-04f, -2.096024566e-03f, -1.564116219e-03f, -1.923761170e-04f, +6.838191950e-04f, +6.482227261e-04f, +1.566939668e-04f, -1.804670083e-04f,
        +4.357017427e-04f, +1.013208586e-03f, +4.151652822e-04f, -1.204853345e-03f, -2.039165191e-03f, -5.853729931e-04f, +2.101340124e-03f, +3.029003320e-03f, +6.743527600e-04f, -2.792970240e-03f, -3.587537314e-03f, -6.367346213e-04f, +2.991270227e-03f, +3.466865657e-03f, +4.757894207e-04f, -2.616954258e-03f, -2.715735564e-03f, -2.492550854e-04f, +1.842175043e-03f, +1.653256174e-03f, +4.276187297e-05f, -9.835734075e-04f, -6.833665337e-04f, +7.610423209e-05f,
        /*  5, 3 (24) */
        -5.311047231e-03f, -1.469205174e-03f, +9.369505949e-03f, +1.846021373e-02f, +1.179442344e-02f, -1.536343143e-02f, -4.592899414e-02f, -4.562190802e-02f, +1.280055778e-02f, +1.226052407e-01f, +2.376337280e-01f, +2.978553688e-01f, +2.694155196e-01f, +1.684644246e-01f, +4.970981159e-02f, -3.110300156e-02f, -5.137156586e-02f, -2.807382164e-02f, +3.625083096e-03f, +1.844059768e-02f, +1.374149120e-02f, +2.021136684e-03f, -4.806269891e-03f, -4.320633285e-03f,
        +5.702039243e-03f, -6.539784856e-03f, -2.020003598e-02f, -1.511659391e-02f, +1.288696603e-02f, +3.769317469e-02f, +2.668280860e-02f, -1.805497988e-02f, -5.265352038e-02f, -3.625281995e-02f, +1.975374259e-02f, +5.875408148e-02f, +3.964163410e-02f, -1.733958789e-02f, -5.327336691e-02f, -3.513127703e-02f, +1.213877818e-02f, +3.873986729e-02f, +2.463184272e-02f, -6.496448606e-03f, -2.135538310e-02f, -1.258510990e-02f, +2.335201704e-03f, +7.354345110e-03f,
        +9.954907849e-06f, -4.796934681e-04f, -7.656737396e-04f, -2.410040137e-04f, +1.063459319e-03f, +2.093753199e-03f, +1.390368093e-03f, -1.566173173e-03f, -5.446327939e-03f, -7.644925770e-03f, -6.155247235e-03f, -1.282742040e-03f, +4.323972854e-03f, +7.493022150e-03f, +6.771625305e-03f, +3.291615744e-03f, -3.402294621e-04f, -2.067216663e-03f, -1.638429341e-03f, -2.738793138e-04f, +6.569650669e-04f, +6.709971107e-04f, +1.877623636e-04f, -1.702385130e-04f,
        +3.844151532e-04f, +1.003240387e-03f, +4.940977046e-04f, -1.103433293e-03f, -2.048496253e-03f, -7.382955736e-04f, +1.953218183e-03f, +3.069254691e-03f, +8.935011650e-04f, -2.620683371e-03f, -3.659765892e-03f, -8.873071002e-04f, +2.828573971e-03f, +3.559258001e-03f, +7.093209057e-04f, -2.494039861e-03f, -2.808379188e-03f, -4.250068959e-04f, +1.772617490e-03f, +1.727249866e-03f, +1.444067703e-04f, -9.607041710e-04f, -7.288448583e-04f, +3.786197773e-05f,
        /*  5, 4 (24) */
        -5.301092324e-03f, -1.948898642e-03f, +8.603832209e-03f, +1.821920972e-02f, +1.285788276e-02f, -1.326967823e-02f, -4.453862604e-02f, -4.718808119e-02f, +7.354229837e-03f, +1.149603149e-01f, +2.314784807e-01f, +2.965726268e-01f, +2.737394925e-01f, +1.759574468e-01f, +5.648143690e-02f, -2.781138582e-02f, -5.171179532e-02f, -3.014103830e-02f, +1.986653755e-03f, +1.816671837e-02f, +1.439845626e-02f, +2.692133794e-03f, -4.618507528e-03f, -4.490871798e-03f,
        +6.086454396e-03f, -5.536544469e-03f, -1.970593828e-02f, -1.622002721e-02f, +1.083846978e-02f, +3.695487911e-02f, +2.863602678e-02f, -1.498572519e-02f, -5.176001921e-02f, -3.887350333e-02f, +1.609397669e-02f, +5.786677438e-02f, +4.247020807e-02f, -1.378032989e-02f, -5.256404601e-02f, -3.762531689e-02f, +9.330398994e-03f, +3.831486039e-02f, +2.640446021e-02f, -4.769198741e-03f, -2.121097633e-02f, -1.354581407e-02f, +1.606356846e-03f, +7.392207087e-03f,
        +3.359134204e-05f, -4.479812312e-04f, -7.668644500e-04f, -3.021840960e-04f, +9.745935658e-04f, +2.066760123e-03f, +1.503588095e-03f, -1.331186495e-03f, -5.224509357e-03f, -7.604035182e-03f, -6.364551947e-03f, -1.643987769e-03f, +4.016782547e-03f, +7.407194790e-03f, +6.920684232e-03f, +3.541951659e-03f, -1.557553883e-04f, -2.029462937e-03f, -1.709055879e-03f, -3.574168621e-04f, +6.262020199e-04f, +6.917708468e-04f, +2.194788192e-04f, -1.584801580e-04f,
        +3.332795848e-04f, +9.884407955e-04f, +5.680944390e-04f, -9.994551411e-04f, -2.048070203e-03f, -8.849834373e-04f, +1.798498320e-03f, +3.095229353e-03f, +1.106677360e-03f, -2.437786994e-03f, -3.715478990e-03f, -1.133782663e-03f, +2.652924440e-03f, +3.636193412e-03f, +9.414906444e-04f, -2.358498330e-03f, -2.889466587e-03f, -6.018448430e-04f, +1.693218472e-03f, +1.794765679e-03f, +2.484052497e-04f, -9.319697936e-04f, -7.721888174e-04f, -2.639140442e-06f,
        /*  5, 5 (24) */
        -5.267500982e-03f, -2.396879873e-03f, +7.836967759e-03f, +1.791702563e-02f, +1.383247632e-02f, -1.120291811e-02f, -4.303503795e-02f, -4.851926768e-02f, +2.129720480e-03f, +1.073562797e-01f, +2.251139288e-01f, +2.949286390e-01f, +2.777562750e-01f, +1.833646416e-01f, +6.340212113e-02f, -2.426943416e-02f, -5.186755071e-02f, -3.217050124e-02f, +2.775978765e-04f, +1.780930151e-02f, +1.502465828e-02f, +3.383904641e-03f, -4.399028709e-03f, -4.649351956e-03f,
        +6.419733981e-03f, -4.548103674e-03f, -1.913784384e-02f, -1.721948235e-02f, +8.790399578e-03f, +3.606989567e-02f, +3.043452510e-02f, -1.189049584e-02f, -5.065334185e-02f, -4.131129032e-02f, +1.237849770e-02f, +5.673299172e-02f, +4.512313251e-02f, -1.014413648e-02f, -5.162255536e-02f, -3.998381522e-02f, +6.440932407e-03f, +3.771301555e-02f, +2.809767868e-02f, -2.974433062e-03f, -2.096257108e-02f, -1.447778387e-02f, +8.341680284e-04f, +7.389567947e-03f,
        +5.585733180e-05f, -4.157070877e-04f, -7.647885786e-04f, -3.598097665e-04f, +8.852019243e-04f, +2.033008602e-03f, +1.607269417e-03f, -1.100845237e-03f, -4.996625439e-03f, -7.548200098e-03f, -6.559384197e-03f, -2.001316367e-03f, +3.700138618e-03f, +7.305283111e-03f, +7.057880665e-03f, +3.791217094e-03f, +3.649883589e-05f, -1.982589837e-03f, -1.775590974e-03f, -4.427195273e-04f, +5.915139548e-04f, +7.103669930e-04f, +2.517151564e-04f, -1.451828985e-04f,
        +2.825906333e-04f, +9.690542132e-04f, +6.369142213e-04f, -8.935047057e-04f, -2.038096100e-03f, -1.024843725e-03f, +1.638008733e-03f, +3.106971295e-03f, +1.312942243e-03f, -2.245191588e-03f, -3.754474007e-03f, -1.375025553e-03f, +2.465108642e-03f, +3.697242238e-03f, +1.171203543e-03f, -2.210838844e-03f, -2.958458089e-03f, -7.789309878e-04f, +1.604174580e-03f, +1.855308757e-03f, +3.542771309e-04f, -8.973380884e-04f, -8.130632555e-04f, -4.523544693e-05f,
        /*  5, 6 (24) */
        -5.211643650e-03f, -2.812586961e-03f, +7.072179181e-03f, +1.755721586e-02f, +1.471767825e-02f, -9.169909503e-03f, -4.142776853e-02f, -4.962011292e-02f, -2.866904959e-03f, +9.980807962e-02f, +2.185545446e-01f, +2.929273226e-01f, +2.814564136e-01f, +1.906699247e-01f, +7.046000180e-02f, -2.047821706e-02f, -5.183105187e-02f, -3.415309108e-02f, -1.497993098e-03f, +1.736658198e-02f, +1.561617224e-02f, +4.094271634e-03f, -4.147313552e-03f, -4.794534854e-03f,
        +6.702324615e-03f, -3.579049461e-03f, -1.850092962e-02f, -1.811298705e-02f, +6.752303478e-03f, +3.504505195e-02f, +3.207253384e-02f, -8.783524544e-03f, -4.934039961e-02f, -4.355648191e-02f, +8.624023698e-03f, +5.535796616e-02f, +4.758824115e-02f, -6.446894241e-03f, -5.045135182e-02f, -4.219465407e-02f, +3.482474317e-03f, +3.693408456e-02f, +2.970185326e-02f, -1.119124305e-03f, -2.060829395e-02f, -1.537512195e-02f, +2.110477292e-05f, +7.344332500e-03f,
        +7.670262023e-05f, -3.830417542e-04f, -7.595793143e-04f, -4.137738564e-04f, +7.956491128e-04f, +1.992850577e-03f, +1.701380622e-03f, -8.756814373e-04f, -4.763386793e-03f, -7.477755907e-03f, -6.739381041e-03f, -2.353881564e-03f, +3.374764820e-03f, +7.187382450e-03f, +7.182677903e-03f, +4.038706938e-03f, +2.361745800e-04f, -1.926450259e-03f, -1.837632560e-03f, -5.295020055e-04f, +5.529011764e-04f, +7.266121346e-04f, +2.843356895e-04f, -1.303454908e-04f,
        +2.326312842e-04f, +9.453437237e-04f, +7.003502290e-04f, -7.861645888e-04f, -2.018827472e-03f, -1.157327590e-03f, +1.472594509e-03f, +3.104593217e-03f, +1.511397935e-03f, -2.043848905e-03f, -3.776629019e-03f, -1.609925854e-03f, +2.265973321e-03f, +3.742049389e-03f, +1.397368767e-03f, -2.051634698e-03f, -3.014867117e-03f, -9.554132892e-04f, +1.505735444e-03f, +1.908410172e-03f, +4.615199501e-04f, -8.568094310e-04f, -8.511369096e-04f, -8.974381342e-05f,
        /*  5, 7 (24) */
        -5.134941029e-03f, -3.195628715e-03f, +6.312599866e-03f, +1.714344200e-02f, +1.551332736e-02f, -7.177058927e-03f, -3.972638791e-02f, -5.049579436e-02f, -7.630291751e-03f, +9.233032372e-02f, +2.118151635e-01f, +2.905734411e-01f, +2.848311785e-01f, +1.978573071e-01f, +7.764267970e-02f, -1.643951013e-02f, -5.159487729e-02f, -3.607954133e-02f, -3.335625657e-03f, +1.683707998e-02f, +1.616907341e-02f, +4.820883769e-03f, -3.862977863e-03f, -4.924880345e-03f,
        +6.934955899e-03f, -2.633705737e-03f, -1.780057939e-02f, -1.889915164e-02f, +4.733476006e-03f, +3.388772436e-02f, +3.354512835e-02f, -5.678931327e-03f, -4.782900168e-02f, -4.560033081e-02f, +4.847394679e-03f, +5.374804031e-02f, +4.985421448e-02f, -2.704844852e-03f, -4.905398305e-02f, -4.424628876e-02f, +4.676072000e-04f, +3.597867127e-02f, +3.120758871e-02f, +7.892858666e-04f, -2.014677400e-02f, -1.623193138e-02f, -8.300321367e-04f, +7.254588687e-03f,
        +9.608591183e-05f, -3.501515202e-04f, -7.513788099e-04f, -4.639876892e-04f, +7.062890113e-04f, +1.946650338e-03f, +1.785921941e-03f, -6.562009107e-04f, -4.525508848e-03f, -7.393075623e-03f, -6.904222762e-03f, -2.700851479e-03f, +3.041411119e-03f, +7.053633621e-03f, +7.294568394e-03f, +4.283709527e-03f, +4.428820227e-04f, -1.860924634e-03f, -1.894782932e-03f, -6.174636061e-04f, +5.103808984e-04f, +7.403372875e-04f, +3.171976273e-04f, -1.139747727e-04f,
        +1.836705515e-04f, +9.175890628e-04f, +7.582304082e-04f, -6.780110980e-04f, -1.990560162e-03f, -1.281932341e-03f, +1.303113105e-03f, +3.088275241e-03f, +1.701191931e-03f, -1.834747021e-03f, -3.781903129e-03f, -1.837404960e-03f, +2.056420874e-03f, +3.770336402e-03f, +1.618905221e-03f, -1.881520982e-03f, -3.058263286e-03f, -1.130429823e-03f, +1.398203313e-03f, +1.953629977e-03f, +5.696112611e-04f, -8.104175945e-04f, -8.860845375e-04f, -1.359622363e-04f,
        /*  5, 8 (24) */
        -5.038855118e-03f, -3.545780235e-03f, +5.561221056e-03f, +1.667945431e-02f, +1.621961637e-02f, -5.230408589e-03f, -3.794046597e-02f, -5.115199527e-02f, -1.215580060e-02f, +8.493724809e-02f, +2.049109408e-01f, +2.878725896e-01f, +2.878725896e-01f, +2.049109408e-01f, +8.493724809e-02f, -1.215580060e-02f, -5.115199527e-02f, -3.794046597e-02f, -5.230408589e-03f, +1.621961637e-02f, +1.667945431e-02f, +5.561221056e-03f, -3.545780235e-03f, -5.038855118e-03f,
        +7.118626450e-03f, -1.716116674e-03f, -1.704234898e-02f, -1.957716274e-02f, +2.742915844e-03f, +3.260579202e-02f, +3.484824145e-02f, -2.590656086e-03f, -4.612780975e-02f, -4.743507783e-02f, +1.065491550e-03f, +5.191063535e-02f, +5.191063535e-02f, +1.065491550e-03f, -4.743507783e-02f, -4.612780975e-02f, -2.590656086e-03f, +3.484824145e-02f, +3.260579202e-02f, +2.742915844e-03f, -1.957716274e-02f, -1.704234898e-02f, -1.716116674e-03f, +7.118626450e-03f,
        +1.139747727e-04f, -3.171976273e-04f, -7.403372875e-04f, -5.103808984e-04f, +6.174636061e-04f, +1.894782932e-03f, +1.860924634e-03f, -4.428820227e-04f, -4.283709527e-03f, -7.294568394e-03f, -7.053633621e-03f, -3.041411119e-03f, +2.700851479e-03f, +6.904222762e-03f, +7.393075623e-03f, +4.525508848e-03f, +6.562009107e-04f, -1.785921941e-03f, -1.946650338e-03f, -7.062890113e-04f, +4.639876892e-04f, +7.513788099e-04f, +3.501515202e-04f, -9.608591183e-05f,
        +1.359622363e-04f, +8.860845375e-04f, +8.104175945e-04f, -5.696112611e-04f, -1.953629977e-03f, -1.398203313e-03f, +1.130429823e-03f, +3.058263286e-03f, +1.881520982e-03f, -1.618905221e-03f, -3.770336402e-03f, -2.056420874e-03f, +1.837404960e-03f, +3.781903129e-03f, +1.834747021e-03f, -1.701191931e-03f, -3.088275241e-03f, -1.303113105e-03f, +1.281932341e-03f, +1.990560162e-03f, +6.780110980e-04f, -7.582304082e-04f, -9.175890628e-04f, -1.836705515e-04f,
        /*  5, 9 (24) */
        -4.924880345e-03f, -3.862977863e-03f, +4.820883769e-03f, +1.616907341e-02f, +1.683707998e-02f, -3.335625657e-03f, -3.607954133e-02f, -5.159487729e-02f, -1.643951013e-02f, +7.764267970e-02f, +1.978573071e-01f, +2.848311785e-01f, +2.905734411e-01f, +2.118151635e-01f, +9.233032372e-02f, -7.630291751e-03f, -5.049579436e-02f, -3.972638791e-02f, -7.177058927e-03f, +1.551332736e-02f, +1.714344200e-02f, +6.312599866e-03f, -3.195628715e-03f, -5.134941029e-03f,
        +7.254588687e-03f, -8.300321367e-04f, -1.623193138e-02f, -2.014677400e-02f, +7.892858666e-04f, +3.120758871e-02f, +3.597867127e-02f, +4.676072000e-04f, -4.424628876e-02f, -4.905398305e-02f, -2.704844852e-03f, +4.985421448e-02f, +5.374804031e-02f, +4.847394679e-03f, -4.560033081e-02f, -4.782900168e-02f, -5.678931327e-03f, +3.354512835e-02f, +3.388772436e-02f, +4.733476006e-03f, -1.889915164e-02f, -1.780057939e-02f, -2.633705737e-03f, +6.934955899e-03f,
        +1.303454908e-04f, -2.843356895e-04f, -7.266121346e-04f, -5.529011764e-04f, +5.295020055e-04f, +1.837632560e-03f, +1.926450259e-03f, -2.361745800e-04f, -4.038706938e-03f, -7.182677903e-03f, -7.187382450e-03f, -3.374764820e-03f, +2.353881564e-03f, +6.739381041e-03f, +7.477755907e-03f, +4.763386793e-03f, +8.756814373e-04f, -1.701380622e-03f, -1.992850577e-03f, -7.956491128e-04f, +4.137738564e-04f, +7.595793143e-04f, +3.830417542e-04f, -7.670262023e-05f,
        +8.974381342e-05f, +8.511369096e-04f, +8.568094310e-04f, -4.615199501e-04f, -1.908410172e-03f, -1.505735444e-03f, +9.554132892e-04f, +3.014867117e-03f, +2.051634698e-03f, -1.397368767e-03f, -3.742049389e-03f, -2.265973321e-03f, +1.609925854e-03f, +3.776629019e-03f, +2.043848905e-03f, -1.511397935e-03f, -3.104593217e-03f, -1.472594509e-03f, +1.157327590e-03f, +2.018827472e-03f, +7.861645888e-04f, -7.003502290e-04f, -9.453437237e-04f, -2.326312842e-04f,
        /*  5,10 (24) */
        -4.794534854e-03f, -4.147313552e-03f, +4.094271634e-03f, +1.561617224e-02f, +1.736658198e-02f, -1.497993098e-03f, -3.415309108e-02f, -5.183105187e-02f, -2.047821706e-02f, +7.046000180e-02f, +1.906699247e-01f, +2.814564136e-01f, +2.929273226e-01f, +2.185545446e-01f, +9.980807962e-02f, -2.866904959e-03f, -4.962011292e-02f, -4.142776853e-02f, -9.169909503e-03f, +1.471767825e-02f, +1.755721586e-02f, +7.072179181e-03f, -2.812586961e-03f, -5.211643650e-03f,
        +7.344332500e-03f, +2.110477292e-05f, -1.537512195e-02f, -2.060829395e-02f, -1.119124305e-03f, +2.970185326e-02f, +3.693408456e-02f, +3.482474317e-03f, -4.219465407e-02f, -5.045135182e-02f, -6.446894241e-03f, +4.758824115e-02f, +5.535796616e-02f, +8.624023698e-03f, -4.355648191e-02f, -4.934039961e-02f, -8.783524544e-03f, +3.207253384e-02f, +3.504505195e-02f, +6.752303478e-03f, -1.811298705e-02f, -1.850092962e-02f, -3.579049461e-03f, +6.702324615e-03f,
        +1.451828985e-04f, -2.517151564e-04f, -7.103669930e-04f, -5.915139548e-04f, +4.427195273e-04f, +1.775590974e-03f, +1.982589837e-03f, -3.649883589e-05f, -3.791217094e-03f, -7.057880665e-03f, -7.305283111e-03f, -3.700138618e-03f, +2.001316367e-03f, +6.559384197e-03f, +7.548200098e-03f, +4.996625439e-03f, +1.100845237e-03f, -1.607269417e-03f, -2.033008602e-03f, -8.852019243e-04f, +3.598097665e-04f, +7.647885786e-04f, +4.157070877e-04f, -5.585733180e-05f,
        +4.523544693e-05f, +8.130632555e-04f, +8.973380884e-04f, -3.542771309e-04f, -1.855308757e-03f, -1.604174580e-03f, +7.789309878e-04f, +2.958458089e-03f, +2.210838844e-03f, -1.171203543e-03f, -3.697242238e-03f, -2.465108642e-03f, +1.375025553e-03f, +3.754474007e-03f, +2.245191588e-03f, -1.312942243e-03f, -3.106971295e-03f, -1.638008733e-03f, +1.024843725e-03f, +2.038096100e-03f, +8.935047057e-04f, -6.369142213e-04f, -9.690542132e-04f, -2.825906333e-04f,
        /*  5,11 (24) */
        -4.649351956e-03f, -4.399028709e-03f, +3.383904641e-03f, +1.502465828e-02f, +1.780930151e-02f, +2.775978765e-04f, -3.217050124e-02f, -5.186755071e-02f, -2.426943416e-02f, +6.340212113e-02f, +1.833646416e-01f, +2.777562750e-01f, +2.949286390e-01f, +2.251139288e-01f, +1.073562797e-01f, +2.129720480e-03f, -4.851926768e-02f, -4.303503795e-02f, -1.120291811e-02f, +1.383247632e-02f, +1.791702563e-02f, +7.836967759e-03f, -2.396879873e-03f, -5.267500982e-03f,
        +7.389567947e-03f, +8.341680284e-04f, -1.447778387e-02f, -2.096257108e-02f, -2.974433062e-03f, +2.809767868e-02f, +3.771301555e-02f, +6.440932407e-03f, -3.998381522e-02f, -5.162255536e-02f, -1.014413648e-02f, +4.512313251e-02f, +5.673299172e-02f, +1.237849770e-02f, -4.131129032e-02f, -5.065334185e-02f, -1.189049584e-02f, +3.043452510e-02f, +3.606989567e-02f, +8.790399578e-03f, -1.721948235e-02f, -1.913784384e-02f, -4.548103674e-03f, +6.419733981e-03f,
        +1.584801580e-04f, -2.194788192e-04f, -6.917708468e-04f, -6.262020199e-04f, +3.574168621e-04f, +1.709055879e-03f, +2.029462937e-03f, +1.557553883e-04f, -3.541951659e-03f, -6.920684232e-03f, -7.407194790e-03f, -4.016782547e-03f, +1.643987769e-03f, +6.364551947e-03f, +7.604035182e-03f, +5.224509357e-03f, +1.331186495e-03f, -1.503588095e-03f, -2.066760123e-03f, -9.745935658e-04f, +3.021840960e-04f, +7.668644500e-04f, +4.479812312e-04f, -3.359134204e-05f,
        +2.639140442e-06f, +7.721888174e-04f, +9.319697936e-04f, -2.484052497e-04f, -1.794765679e-03f, -1.693218472e-03f, +6.018448430e-04f, +2.889466587e-03f, +2.358498330e-03f, -9.414906444e-04f, -3.636193412e-03f, -2.652924440e-03f, +1.133782663e-03f, +3.715478990e-03f, +2.437786994e-03f, -1.106677360e-03f, -3.095229353e-03f, -1.798498320e-03f, +8.849834373e-04f, +2.048070203e-03f, +9.994551411e-04f, -5.680944390e-04f, -9.884407955e-04f, -3.332795848e-04f,
        /*  5,12 (24) */
        -4.490871798e-03f, -4.618507528e-03f, +2.692133794e-03f, +1.439845626e-02f, +1.816671837e-02f, +1.986653755e-03f, -3.014103830e-02f, -5.171179532e-02f, -2.781138582e-02f, +5.648143690e-02f, +1.759574468e-01f, +2.737394925e-01f, +2.965726268e-01f, +2.314784807e-01f, +1.149603149e-01f, +7.354229837e-03f, -4.718808119e-02f, -4.453862604e-02f, -1.326967823e-02f, +1.285788276e-02f, +1.821920972e-02f, +8.603832209e-03f, -1.948898642e-03f, -5.301092324e-03f,
        +7.392207087e-03f, +1.606356846e-03f, -1.354581407e-02f, -2.121097633e-02f, -4.769198741e-03f, +2.640446021e-02f, +3.831486039e-02f, +9.330398994e-03f, -3.762531689e-02f, -5.256404601e-02f, -1.378032989e-02f, +4.247020807e-02f, +5.786677438e-02f, +1.609397669e-02f, -3.887350333e-02f, -5.176001921e-02f, -1.498572519e-02f, +2.863602678e-02f, +3.695487911e-02f, +1.083846978e-02f, -1.622002721e-02f, -1.970593828e-02f, -5.536544469e-03f, +6.086454396e-03f,
        +1.702385130e-04f, -1.877623636e-04f, -6.709971107e-04f, -6.569650669e-04f, +2.738793138e-04f, +1.638429341e-03f, +2.067216663e-03f, +3.402294621e-04f, -3.291615744e-03f, -6.771625305e-03f, -7.493022150e-03f, -4.323972854e-03f, +1.282742040e-03f, +6.155247235e-03f, +7.644925770e-03f, +5.446327939e-03f, +1.566173173e-03f, -1.390368093e-03f, -2.093753199e-03f, -1.063459319e-03f, +2.410040137e-04f, +7.656737396e-04f, +4.796934681e-04f, -9.954907849e-06f,
        -3.786197773e-05f, +7.288448583e-04f, +9.607041710e-04f, -1.444067703e-04f, -1.727249866e-03f, -1.772617490e-03f, +4.250068959e-04f, +2.808379188e-03f, +2.494039861e-03f, -7.093209057e-04f, -3.559258001e-03f, -2.828573971e-03f, +8.873071002e-04f, +3.659765892e-03f, +2.620683371e-03f, -8.935011650e-04f, -3.069254691e-03f, -1.953218183e-03f, +7.382955736e-04f, +2.048496253e-03f, +1.103433293e-03f, -4.940977046e-04f, -1.003240387e-03f, -3.844151532e-04f,
        /*  5,13 (24) */
        -4.320633285e-03f, -4.806269891e-03f, +2.021136684e-03f, +1.374149120e-02f, +1.844059768e-02f, +3.625083096e-03f, -2.807382164e-02f, -5.137156586e-02f, -3.110300156e-02f, +4.970981159e-02f, +1.684644246e-01f, +2.694155196e-01f, +2.978553688e-01f, +2.376337280e-01f, +1.226052407e-01f, +1.280055778e-02f, -4.562190802e-02f, -4.592899414e-02f, -1.536343143e-02f, +1.179442344e-02f, +1.846021373e-02f, +9.369505949e-03f, -1.469205174e-03f, -5.311047231e-03f,
        +7.354345110e-03f, +2.335201704e-03f, -1.258510990e-02f, -2.135538310e-02f, -6.496448606e-03f, +2.463184272e-02f, +3.873986729e-02f, +1.213877818e-02f, -3.513127703e-02f, -5.327336691e-02f, -1.733958789e-02f, +3.964163410e-02f, +5.875408148e-02f, +1.975374259e-02f, -3.625281995e-02f, -5.265352038e-02f, -1.805497988e-02f, +2.668280860e-02f, +3.769317469e-02f, +1.288696603e-02f, -1.511659391e-02f, -2.020003598e-02f, -6.539784856e-03f, +5.702039243e-03f,
        +1.804670083e-04f, -1.566939668e-04f, -6.482227261e-04f, -6.838191950e-04f, +1.923761170e-04f, +1.564116219e-03f, +2.096024566e-03f, +5.165965845e-04f, -3.040905742e-03f, -6.611267769e-03f, -7.562715330e-03f, -4.621014124e-03f, +9.184372939e-04f, +5.931875340e-03f, +7.670575477e-03f, +5.661377727e-03f, +1.805248337e-03f, -1.267673040e-03f, -2.113649817e-03f, -1.151424749e-03f, +1.763952895e-04f, +7.610931012e-04f, +5.106693149e-04f, +1.499269425e-05f,
        -7.610423209e-05f, +6.833665337e-04f, +9.835734075e-04f, -4.276187297e-05f, -1.653256174e-03f, -1.842175043e-03f, +2.492550854e-04f, +2.715735564e-03f, +2.616954258e-03f, -4.757894207e-04f, -3.466865657e-03f, -2.991270227e-03f, +6.367346213e-04f, +3.587537314e-03f, +2.792970240e-03f, -6.743527600e-04f, -3.029003320e-03f, -2.101340124e-03f, +5.853729931e-04f, +2.039165191e-03f, +1.204853345e-03f, -4.151652822e-04f, -1.013208586e-03f, -4.357017427e-04f,
        /*  5,14 (24) */
        -4.140166276e-03f, -4.962963858e-03f, +1.372913958e-03f, +1.305767200e-02f, +1.863297380e-02f, +5.189199315e-03f, -2.597779707e-02f, -5.085496927e-02f, -3.414390730e-02f, +4.309854382e-02f, +1.609017093e-01f, +2.647945055e-01f, +2.987738061e-01f, +2.435656033e-01f, +1.302758162e-01f, +1.846193550e-02f, -4.381665968e-02f, -4.719666718e-02f, -1.747708125e-02f, +1.064299869e-02f, +1.863660902e-02f, +1.013059905e-02f, -9.585358590e-04f, -5.296054537e-03f,
        +7.278240878e-03f, +3.018568238e-03f, -1.160153649e-02f, -2.139814497e-02f, -8.149704780e-03f, +2.278966768e-02f, +3.898912237e-02f, +1.485451375e-02f, -3.251432277e-02f, -5.374915634e-02f, -2.080645355e-02f, +3.665036387e-02f, +5.939081610e-02f, +2.334127990e-02f, -3.345984971e-02f, -5.332787314e-02f, -2.108398320e-02f, +2.458146848e-02f, +3.827854768e-02f, +1.492613123e-02f, -1.391174057e-02f, -2.061520126e-02f, -7.552993442e-03f, +5.266337501e-03f,
        +1.891821789e-04f, -1.263939429e-04f, -6.236272651e-04f, -7.067963479e-04f, +1.131598359e-04f, +1.486522618e-03f, +2.116085481e-03f, +6.845623020e-04f, -2.790507225e-03f, -6.440200658e-03f, -7.616269797e-03f, -4.907241304e-03f, +5.519408980e-04f, +5.694882839e-03f, +7.680728180e-03f, +5.868964755e-03f, +2.047831598e-03f, -1.135599185e-03f, -2.126127454e-03f, -1.238106892e-03f, +1.085023281e-04f, +7.530098918e-04f, +5.407312178e-04f, +4.118315267e-05f,
        -1.119438402e-04f, +6.360907922e-04f, +1.000641246e-03f, +5.607367513e-05f, -1.573302243e-03f, -1.901747710e-03f, +7.540916074e-05f, +2.612125139e-03f, +2.726798420e-03f, -2.419900705e-04f, -3.359518155e-03f, -3.140289727e-03f, +3.832212247e-04f, +3.499075769e-03f, +2.953783155e-03f, -4.502080806e-04f, -2.974500897e-03f, -2.242057320e-03f, +4.268501547e-04f, +2.019914373e-03f, +1.303129426e-03f, -3.315723436e-04f, -1.018121641e-03f, -4.868326252e-04f,
        /*  5,15 (24) */
        -3.950984098e-03f, -5.089357801e-03f, +7.492866926e-04f, +1.235087565e-02f, +1.874613364e-02f, +6.675721933e-03f, -2.386171159e-02f, -5.017040697e-02f, -3.693441453e-02f, +3.665834317e-02f, +1.532854395e-01f, +2.598872642e-01f, +2.993257470e-01f, +2.492604861e-01f, +1.379565443e-01f, +2.433090026e-02f, -4.176882808e-02f, -4.833226636e-02f, -1.960320870e-02f, +9.404891796e-03f, +1.874511135e-02f, +1.088360894e-02f, -4.178046412e-04f, -5.254871384e-03f,
        +7.166297037e-03f, +3.654659030e-03f, -1.060089525e-02f, -2.134207130e-02f, -9.723007024e-03f, +2.088791997e-02f, +3.906453154e-02f, +1.746663889e-02f, -2.978752435e-02f, -5.399114641e-02f, -2.416597170e-02f, +3.351007415e-02f, +5.977403733e-02f, +2.684035567e-02f, -3.050606656e-02f, -5.377808122e-02f, -2.405848410e-02f, +2.233941116e-02f, +3.870539783e-02f, +1.694604560e-02f, -1.260861114e-02f, -2.094677361e-02f, -8.571115083e-03f, +4.779504875e-03f,
        +1.964077119e-04f, -9.697443390e-05f, -5.973920492e-04f, -7.259437023e-04f, +3.646584188e-05f, +1.406054360e-03f, +2.127622286e-03f, +8.438649054e-04f, -2.541092904e-03f, -6.259036041e-03f, -7.653726044e-03f, -5.182021629e-03f, +1.841268527e-04f, +5.444756432e-03f, +7.675169148e-03f, +6.068406868e-03f, +2.293320649e-03f, -9.942757047e-04f, -2.130880606e-03f, -1.323115503e-03f, +3.748812743e-05f, +7.413230094e-04f, +5.696992846e-04f, +6.853914940e-05f,
        -1.452572160e-04f, +5.873543182e-04f, +1.012001821e-03f, +1.516704686e-04f, -1.487925287e-03f, -1.951245075e-03f, -9.573325739e-05f, +2.498183523e-03f, +2.823196934e-03f, -9.010092975e-06f, -3.237786595e-03f, -3.274975965e-03f, +1.279374424e-04f, +3.394742513e-03f, +3.102308260e-03f, -2.220752786e-04f, -2.905843317e-03f, -2.374588747e-03f, +2.634004448e-04f, +1.990629293e-03f, +1.397678832e-03f, -2.436272238e-04f, -1.017778343e-03f, -5.374915272e-04f,
        /*  6, 0 (24) */
        -9.443188869e-04f, -9.436998782e-03f, -9.565468880e-03f, +7.571667169e-03f, +2.701845118e-02f, +1.723470897e-02f, -2.936171966e-02f, -6.643983485e-02f, -2.360084937e-02f, +1.182279552e-01f, +2.849403407e-01f, +3.594118486e-01f, +2.849403407e-01f, +1.182279552e-01f, -2.360084937e-02f, -6.643983485e-02f, -2.936171966e-02f, +1.723470897e-02f, +2.701845118e-02f, +7.571667169e-03f, -9.565468880e-03f, -9.436998782e-03f, -9.443188869e-04f, +3.266463436e-03f,
        +9.443188869e-04f, +1.280596256e-02f, +1.051077168e-03f, -2.198035832e-02f, -1.993238995e-02f, +1.659489883e-02f, +4.037674484e-02f, +8.960064052e-03f, -4.280330062e-02f, -4.102451787e-02f, +1.852929662e-02f, +5.568401311e-02f, +1.852929662e-02f, -4.102451787e-02f, -4.280330062e-02f, +8.960064052e-03f, +4.037674484e-02f, +1.659489883e-02f, -1.993238995e-02f, -2.198035832e-02f, +1.051077168e-03f, +1.280596256e-02f, +5.134169749e-03f, -3.266463436e-03f,
        +4.689523778e-04f, +4.480790583e-04f, -4.976957856e-04f, -1.435166959e-03f, -6.675137897e-04f, +1.867480161e-03f, +3.368864452e-03f, +6.125226686e-04f, -5.846331590e-03f, -1.077747741e-02f, -8.839498946e-03f, -3.120642952e-04f, +8.456997594e-03f, +1.089151264e-02f, +6.268046134e-03f, -2.821040306e-04f, -3.342048428e-03f, -2.031889028e-03f, +5.451907148e-04f, +1.451459445e-03f, +5.742732337e-04f, -4.146097723e-04f, -4.903798843e-04f, -5.115049594e-05f,
        -4.689523778e-04f, -4.227197977e-05f, +1.361609930e-03f, +1.087593793e-03f, -1.354652652e-03f, -2.582317601e-03f, +7.593408284e-06f, +3.335003672e-03f, +2.283427491e-03f, -2.324348697e-03f, -4.046850226e-03f, -1.663399353e-04f, +3.948113578e-03f, +2.584849287e-03f, -2.046402663e-03f, -3.431446366e-03f, -2.546153717e-04f, +2.531961778e-03f, +1.513057151e-03f, -9.797168079e-04f, -1.418296556e-03f, -4.419126328e-05f, +7.132215359e-04f, +5.115049594e-05f,
        /*  6, 1 (24) */
        -4.753665091e-04f, -8.988919724e-03f, -1.006316467e-02f, +6.136500210e-03f, +2.635093739e-02f, +1.910218913e-02f, -2.599285520e-02f, -6.582731218e-02f, -2.944718096e-02f, +1.074504778e-01f, +2.761008418e-01f, +3.590997843e-01f, +2.933973383e-01f, +1.291194678e-01f, -1.733280324e-02f, -6.672193888e-02f, -3.270376808e-02f, +1.520281994e-02f, +2.756364190e-02f, +9.023126614e-03f, -8.991195646e-03f, -9.851608555e-03f, -1.434698771e-03f, +3.215312940e-03f,
        +4.753665091e-04f, +1.276369058e-02f, +2.412687098e-03f, -2.089276453e-02f, -2.128704260e-02f, +1.401258123e-02f, +4.038433825e-02f, +1.229506772e-02f, -4.051987313e-02f, -4.334886656e-02f, +1.448244640e-02f, +5.551767318e-02f, +2.247741020e-02f, -3.843966858e-02f, -4.484970329e-02f, +5.528617686e-03f, +4.012212947e-02f, +1.912686061e-02f, -1.841933280e-02f, -2.296007513e-02f, -3.672193874e-04f, +1.276177130e-02f, +5.847391285e-03f, -3.215312940e-03f,
        +4.456494725e-04f, +4.773904234e-04f, -4.214375482e-04f, -1.411631754e-03f, -7.818074808e-04f, +1.699277300e-03f, +3.377656505e-03f, +9.266692994e-04f, -5.418756674e-03f, -1.063451134e-02f, -9.193958608e-03f, -9.351621227e-04f, +8.047531031e-03f, +1.097578795e-02f, +6.682190728e-03f, +6.370880484e-05f, -3.296687441e-03f, -2.191494642e-03f, +4.152250918e-04f, +1.460142407e-03f, +6.507226728e-04f, -3.770139812e-04f, -5.096968493e-04f, -7.723833868e-05f,
        -4.456494725e-04f, -1.249700912e-04f, +1.297655864e-03f, +1.185350537e-03f, -1.191293312e-03f, -2.615423134e-03f, -2.356121632e-04f, +3.219058461e-03f, +2.504202414e-03f, -2.051090559e-03f, -4.120371452e-03f, -4.979644176e-04f, +3.824717377e-03f, +2.830855480e-03f, -1.794508537e-03f, -3.507530360e-03f, -5.038930094e-04f, +2.464367746e-03f, +1.665319635e-03f, -8.621996611e-04f, -1.467073881e-03f, -1.338987788e-04f, +7.100536365e-04f, +7.723833868e-05f,
        /*  6, 2 (24) */
        -2.971703658e-05f, -8.511529301e-03f, -1.048460221e-02f, +4.724868456e-03f, +2.556912991e-02f, +2.080146643e-02f, -2.261519870e-02f, -6.490064288e-02f, -3.486593764e-02f, +9.681596644e-02f, +2.669068832e-01f, +3.581646222e-01f, +3.014448694e-01f, +1.400952558e-01f, -1.065061251e-02f, -6.665823007e-02f, -3.600045553e-02f, +1.301132530e-02f, +2.797886699e-02f, +1.048326902e-02f, -8.340472973e-03f, -1.022862254e-02f, -1.944395621e-03f, +3.138074601e-03f,
        +2.971703658e-05f, +1.263872049e-02f, +3.710342963e-03f, -1.970741399e-02f, -2.247833591e-02f, +1.139715810e-02f, +4.014872608e-02f, +1.551412618e-02f, -3.801567072e-02f, -4.539995712e-02f, +1.036207495e-02f, +5.501970876e-02f, +2.630212758e-02f, -3.560881310e-02f, -4.664421182e-02f, +2.021087326e-03f, +3.961823646e-02f, +2.159122835e-02f, -1.675401316e-02f, -2.382227479e-02f, -1.834293269e-03f, +1.262787252e-02f, +6.557444921e-03f, -3.138074601e-03f,
        +4.207090484e-04f, +5.025392707e-04f, -3.459278189e-04f, -1.381248634e-03f, -8.877404424e-04f, +1.528276824e-03f, +3.369013164e-03f, +1.223754983e-03f, -4.987024967e-03f, -1.046354572e-02f, -9.519412653e-03f, -1.555171915e-03f, +7.612284351e-03f, +1.102958099e-02f, +7.087057190e-03f, +4.239514835e-04f, -3.232332149e-03f, -2.345279652e-03f, +2.780588239e-04f, +1.460880057e-03f, +7.265810680e-04f, -3.353506814e-04f, -5.266725668e-04f, -1.043627762e-04f,
        -4.207090484e-04f, -2.034277110e-04f, +1.227110830e-03f, +1.272589899e-03f, -1.024175495e-03f, -2.631382834e-03f, -4.734884070e-04f, +3.084585875e-03f, +2.707464954e-03f, -1.766885327e-03f, -4.168287358e-03f, -8.264297989e-04f, +3.677380173e-03f, +3.060716126e-03f, -1.529235425e-03f, -3.562525570e-03f, -7.538279918e-04f, +2.379665972e-03f, +1.810270836e-03f, -7.356037323e-04f, -1.507340486e-03f, -2.262870104e-04f, +7.010865730e-04f, +1.043627762e-04f,
        /*  6, 3 (24) */
        +3.909920118e-04f, -8.008990030e-03f, -1.083053003e-02f, +3.343619821e-03f, +2.468138947e-02f, +2.232974326e-02f, -1.924618554e-02f, -6.367688790e-02f, -3.985296260e-02f, +8.635242072e-02f, +2.573874705e-01f, +3.566094503e-01f, +3.090571537e-01f, +1.511248368e-01f, -3.563555321e-03f, -6.623427859e-02f, -3.923278767e-02f, +1.066604565e-02f, +2.825692581e-02f, +1.194414908e-02f, -7.613891905e-03f, -1.056397322e-02f, -2.471068187e-03f, +3.033711825e-03f,
        -3.909920118e-04f, +1.243529278e-02f, +4.937453793e-03f, -1.843482409e-02f, -2.350251141e-02f, +8.765775262e-03f, +3.967523768e-02f, +1.859871206e-02f, -3.530820576e-02f, -4.716684245e-02f, +6.193787588e-03f, +5.419327896e-02f, +2.997950775e-02f, -3.254809697e-02f, -4.817344725e-02f, -1.541438244e-03f, +3.886440847e-02f, +2.397089433e-02f, -1.494374233e-02f, -2.455787852e-02f, -3.341633754e-03f, +1.240158551e-02f, +7.258531494e-03f, -3.033711825e-03f,
        +3.943700611e-04f, +5.235469186e-04f, -2.715760351e-04f, -1.344437307e-03f, -9.850369344e-04f, +1.355457625e-03f, +3.343586276e-03f, +1.503081518e-03f, -4.552826774e-03f, -1.026560914e-02f, -9.815013127e-03f, -2.170049140e-03f, +7.152546825e-03f, +1.105228015e-02f, +7.480946210e-03f, +7.975758828e-04f, -3.148608650e-03f, -2.492223559e-03f, +1.341881493e-04f, +1.453370552e-03f, +8.013718372e-04f, -2.897070603e-04f, -5.410824947e-04f, -1.323765352e-04f,
        -3.943700611e-04f, -2.772173487e-04f, +1.150679967e-03f, +1.348998650e-03f, -8.544961206e-04f, -2.630415027e-03f, -7.045798734e-04f, +2.932672115e-03f, +2.892078306e-03f, -1.473604520e-03f, -4.190376164e-03f, -1.149653509e-03f, +3.506978773e-03f, +3.272877333e-03f, -1.252174097e-03f, -3.595834350e-03f, -1.002794943e-03f, +2.278106348e-03f, +1.946768151e-03f, -6.005694260e-04f, -1.538541034e-03f, -3.207529261e-04f, +6.861465987e-04f, +1.323765352e-04f,
        /*  6, 4 (24) */
        +7.853620729e-04f, -7.485443112e-03f, -1.110210607e-02f, +1.999182515e-03f, +2.369635254e-02f, +2.368520088e-02f, -1.590259926e-02f, -6.217380638e-02f, -4.440578938e-02f, +7.608681158e-02f, +2.475724574e-01f, +3.544394011e-01f, +3.162097005e-01f, +1.621771169e-01f, +3.917390889e-03f, -6.543670271e-02f, -4.238139633e-02f, +8.173822091e-03f, +2.839111396e-02f, +1.339751963e-02f, -6.812520068e-03f, -1.085368028e-02f, -3.012150682e-03f, +2.901335290e-03f,
        -7.853620729e-04f, +1.215807543e-02f, +6.088133760e-03f, -1.708582544e-02f, -2.435700753e-02f, +6.135360235e-03f, +3.897065780e-02f, +2.153138417e-02f, -3.241612746e-02f, -4.864044697e-02f, +2.003411424e-03f, +5.304362545e-02f, +3.348648653e-02f, -2.927521964e-02f, -4.942562134e-02f, -5.137272594e-03f, +3.786161352e-02f, +2.624900067e-02f, -1.299697418e-02f, -2.515844795e-02f, -4.880174789e-03f, +1.208083258e-02f, +7.944678093e-03f, -2.901335290e-03f,
        +3.668709269e-04f, +5.404595643e-04f, -1.987700110e-04f, -1.301639237e-03f, -1.073476637e-03f, +1.181776686e-03f, +3.302086415e-03f, +1.764042857e-03f, -4.117831997e-03f, -1.004182218e-02f, -1.008003094e-02f, -2.777770432e-03f, +6.669706987e-03f, +1.104338820e-02f, +7.862174877e-03f, +1.183453329e-03f, -3.045221976e-03f, -2.631307780e-03f, -1.583740675e-05f, +1.437348816e-03f, +8.746072696e-04f, -2.401989468e-04f, -5.527099981e-04f, -1.611192984e-04f,
        -3.668709269e-04f, -3.459613134e-04f, +1.069091052e-03f, +1.414347823e-03f, -6.834441848e-04f, -2.612848491e-03f, -9.274977734e-04f, +2.764505845e-03f, +3.057037956e-03f, -1.173167834e-03f, -4.186585198e-03f, -1.465588051e-03f, +3.314542726e-03f, +3.465893416e-03f, -9.650057653e-04f, -3.606996957e-03f, -1.249152335e-03f, +2.160058380e-03f, +2.073704357e-03f, -4.578132493e-04f, -1.560171705e-03f, -4.166576427e-04f, +6.651030470e-04f, +1.611192984e-04f,
        /*  6, 5 (24) */
        +1.152233000e-03f, -6.944983547e-03f, -1.130087608e-02f, +6.975432775e-04f, +2.262287590e-02f, +2.486697757e-02f, -1.260051284e-02f, -6.040976352e-02f, -4.852362137e-02f, +6.604498940e-02f, +2.374924265e-01f, +3.516616307e-01f, +3.228794075e-01f, +1.732205051e-01f, +1.177956577e-02f, -6.425324938e-02f, -4.542661830e-02f, +5.542514312e-03f, +2.837527656e-02f, +1.483486845e-02f, -5.937912799e-03f, -1.109387922e-02f, -3.564860680e-03f, +2.740215991e-03f,
        -1.152233000e-03f, +1.181211412e-02f, +7.157224812e-03f, -1.567147762e-02f, -2.504045171e-02f, +3.522511744e-03f, +3.804316003e-02f, +2.429589002e-02f, -2.935908950e-02f, -4.981361480e-02f, -2.183173774e-03f, +5.157803740e-02f, +3.680102925e-02f, -2.580932622e-02f, -5.039062711e-02f, -8.744269551e-03f, +3.661246119e-02f, +2.840905905e-02f, -1.092326982e-02f, -2.561626120e-02f, -6.440346494e-03f, +1.166417494e-02f, +8.609781140e-03f, -2.740215991e-03f,
        +3.384479650e-04f, +5.533471255e-04f, -1.278743573e-04f, -1.253314472e-03f, -1.152894176e-03f, +1.008164877e-03f, +3.245278149e-03f, +2.006126058e-03f, -3.683683195e-03f, -9.793391686e-03f, -1.031385820e-02f, -3.376341920e-03f, +6.165247259e-03f, +1.100252535e-02f, +8.229084209e-03f, +1.580378250e-03f, -2.921959254e-03f, -2.761520825e-03f, -1.714163939e-04f, +1.412589230e-03f, +9.457910857e-04f, -1.869710954e-04f, -5.613480991e-04f, -1.904183455e-04f,
        -3.384479650e-04f, -4.093331982e-04f, +9.830884486e-04f, +1.468492415e-03f, -5.121924999e-04f, -2.579118290e-03f, -1.140928566e-03f, +2.581368987e-03f, +3.201477334e-03f, -8.675299851e-04f, -4.157030724e-03f, -1.772234684e-03f, +3.101247748e-03f, +3.638437143e-03f, -6.694913730e-04f, -3.595696109e-03f, -1.491253623e-03f, +2.026010514e-03f, +2.190016218e-03f, -3.081242579e-04f, -1.571785345e-03f, -5.133304347e-04f, +6.378708070e-04f, +1.904183455e-04f,
        /*  6, 6 (24) */
        +1.490680965e-03f, -6.391636422e-03f, -1.142875044e-02f, -5.557711946e-04f, +2.146998172e-02f, +2.587514245e-02f, -9.355234695e-03f, -5.840363747e-02f, -5.220730457e-02f, +5.625159772e-02f, +2.271785683e-01f, +3.482852888e-01f, +3.290446548e-01f, +1.842230305e-01f, +2.000864997e-02f, -6.267287113e-02f, -4.834857755e-02f, +2.780993487e-03f, +2.820386016e-02f, +1.624745768e-02f, -4.992121713e-03f, -1.128085032e-02f, -4.126208779e-03f, +2.549797646e-03f,
        -1.490680965e-03f, +1.140278092e-02f, +8.140313261e-03f, -1.420298520e-02f, -2.555264421e-02f, +9.433934541e-04f, +3.690223147e-02f, +2.687725901e-02f, -2.615761217e-02f, -5.068114479e-02f, -6.340204498e-03f, +4.980580271e-02f, +3.990227700e-02f, -2.217088908e-02f, -5.106011848e-02f, -1.233996566e-02f, +3.512120757e-02f, +3.043506957e-02f, -8.733253600e-03f, -2.592438545e-02f, -8.012131839e-03f, +1.115084451e-02f, +9.247651947e-03f, -2.549797646e-03f,
        +3.093339044e-04f, +5.623019695e-04f, -5.922908536e-05f, -1.199938445e-03f, -1.223178360e-03f, +8.355229870e-04f, +3.173975131e-03f, +2.228911780e-03f, -3.251988858e-03f, -9.521604813e-03f, -1.051601006e-02f, -3.963807418e-03f, +5.640738141e-03f, +1.092943184e-02f, +8.580046670e-03f, +1.987072240e-03f, -2.778692537e-03f, -2.881863548e-03f, -3.318971155e-04f, +1.378908166e-03f, +1.014421126e-03f, -1.301972964e-04f, -5.668012201e-04f, -2.200893043e-04f,
        -3.093339044e-04f, -4.670589181e-04f, +8.934270684e-04f, +1.511370483e-03f, -3.418897025e-04f, -2.529760927e-03f, -1.343641901e-03f, +2.384626953e-03f, +3.324672468e-03f, -5.586673905e-04f, -4.101996605e-03f, -2.067656769e-03f, +2.868408124e-03f, +3.789309220e-03f, -3.674602494e-04f, -3.561760585e-03f, -1.727458567e-03f, +1.876568606e-03f, +2.294692934e-03f, -1.523598840e-04f, -1.572996310e-03f, -6.100731019e-04f, +6.044124905e-04f, +2.200893043e-04f,
        /*  6, 7 (24) */
        +1.800014869e-03f, -5.829334452e-03f, -1.148797952e-02f, -1.755709640e-03f, +2.024680336e-02f, +2.671066543e-02f, -6.181259565e-03f, -5.617472569e-02f, -5.545929343e-02f, +4.672999290e-02f, +2.166625582e-01f, +3.443214814e-01f, +3.346853929e-01f, +1.951524623e-01f, +2.858869664e-02f, -6.068579889e-02f, -5.112727009e-02f, -1.008700610e-04f, +2.787196305e-02f, +1.762636584e-02f, -3.977700586e-03f, -1.141104762e-02f, -4.693009999e-03f, +2.329708342e-03f,
        -1.800014869e-03f, +1.093572200e-02f, +9.033740329e-03f, -1.269161472e-02f, -2.589453391e-02f, -1.586367473e-03f, +3.555858956e-02f, +2.926188596e-02f, -2.283293970e-02f, -5.123981218e-02f, -1.044220110e-02f, +4.773814595e-02f, +4.277068512e-02f, -1.838157986e-02f, -5.142757873e-02f, -1.590172625e-02f, +3.339374900e-02f, +3.231163817e-02f, -6.438560666e-03f, -2.607674534e-02f, -9.585128149e-03f, +1.054077141e-02f, +9.852064438e-03f, -2.329708342e-03f,
        +2.797564633e-04f, +5.674375425e-04f, +6.851598321e-06f, -1.141998787e-03f, -1.284271150e-03f, +6.647179963e-04f, +3.089035046e-03f, +2.432074331e-03f, -2.824316917e-03f, -9.227822644e-03f, -1.068612589e-02f, -4.538256439e-03f, +5.097831993e-03f, +1.082397002e-02f, +8.913473616e-03f, +2.402188545e-03f, -2.615381263e-03f, -2.991354457e-03f, -4.965796190e-04f, +1.336166371e-03f, +1.079992159e-03f, -7.008030702e-05f, -5.688869102e-04f, -2.499370090e-04f,
        -2.797564633e-04f, -5.189173045e-04f, +8.008664045e-04f, +1.543001633e-03f, -1.736525899e-04f, -2.465408847e-03f, -1.534497869e-03f, +2.175718408e-03f, +3.426045613e-03f, -2.485647717e-04f, -4.021931833e-03f, -2.349992672e-03f, +2.617468151e-03f, +3.917446923e-03f, -6.079821749e-05f, -3.505167843e-03f, -1.956144632e-03f, +1.712453521e-03f, +2.386784346e-03f, +8.558833165e-06f, -1.563484939e-03f, -7.061646718e-04f, +5.647402610e-04f, +2.499370090e-04f,
        /*  6, 8 (24) */
        +2.079771333e-03f, -5.261896910e-03f, -1.148112792e-02f, -2.897708427e-03f, +1.896253221e-02f, +2.737538343e-02f, -3.092224518e-03f, -5.374265135e-02f, -5.828361034e-02f, +3.750217026e-02f, +2.059764323e-01f, +3.397832249e-01f, +3.397832249e-01f, +2.059764323e-01f, +3.750217026e-02f, -5.828361034e-02f, -5.374265135e-02f, -3.092224518e-03f, +2.737538343e-02f, +1.896253221e-02f, -2.897708427e-03f, -1.148112792e-02f, -5.261896910e-03f, +2.079771333e-03f,
        -2.079771333e-03f, +1.041680470e-02f, +9.834606734e-03f, -1.114861309e-02f, -2.606818650e-02f, -4.051776320e-03f, +3.402409170e-02f, +3.143760437e-02f, -1.940689409e-02f, -5.148837695e-02f, -1.446413294e-02f, +4.538815327e-02f, +4.538815327e-02f, -1.446413294e-02f, -5.148837695e-02f, -1.940689409e-02f, +3.143760437e-02f, +3.402409170e-02f, -4.051776320e-03f, -2.606818650e-02f, -1.114861309e-02f, +9.834606734e-03f, +1.041680470e-02f, -2.079771333e-03f,
        +2.499370090e-04f, +5.688869102e-04f, +7.008030702e-05f, -1.079992159e-03f, -1.336166371e-03f, +4.965796190e-04f, +2.991354457e-03f, +2.615381263e-03f, -2.402188545e-03f, -8.913473616e-03f, -1.082397002e-02f, -5.097831993e-03f, +4.538256439e-03f, +1.068612589e-02f, +9.227822644e-03f, +2.824316917e-03f, -2.432074331e-03f, -3.089035046e-03f, -6.647179963e-04f, +1.284271150e-03f, +1.141998787e-03f, -6.851598321e-06f, -5.674375425e-04f, -2.797564633e-04f,
        -2.499370090e-04f, -5.647402610e-04f, +7.061646718e-04f, +1.563484939e-03f, -8.558833165e-06f, -2.386784346e-03f, -1.712453521e-03f, +1.956144632e-03f, +3.505167843e-03f, +6.079821749e-05f, -3.917446923e-03f, -2.617468151e-03f, +2.349992672e-03f, +4.021931833e-03f, +2.485647717e-04f, -3.426045613e-03f, -2.175718408e-03f, +1.534497869e-03f, +2.465408847e-03f, +1.736525899e-04f, -1.543001633e-03f, -8.008664045e-04f, +5.189173045e-04f, +2.797564633e-04f,
        /*  6, 9 (24) */
        +2.329708342e-03f, -4.693009999e-03f, -1.141104762e-02f, -3.977700586e-03f, +1.762636584e-02f, +2.787196305e-02f, -1.008700610e-04f, -5.112727009e-02f, -6.068579889e-02f, +2.858869664e-02f, +1.951524623e-01f, +3.346853929e-01f, +3.443214814e-01f, +2.166625582e-01f, +4.672999290e-02f, -5.545929343e-02f, -5.617472569e-02f, -6.181259565e-03f, +2.671066543e-02f, +2.024680336e-02f, -1.755709640e-03f, -1.148797952e-02f, -5.829334452e-03f, +1.800014869e-03f,
        -2.329708342e-03f, +9.852064438e-03f, +1.054077141e-02f, -9.585128149e-03f, -2.607674534e-02f, -6.438560666e-03f, +3.231163817e-02f, +3.339374900e-02f, -1.590172625e-02f, -5.142757873e-02f, -1.838157986e-02f, +4.277068512e-02f, +4.773814595e-02f, -1.044220110e-02f, -5.123981218e-02f, -2.283293970e-02f, +2.926188596e-02f, +3.555858956e-02f, -1.586367473e-03f, -2.589453391e-02f, -1.269161472e-02f, +9.033740329e-03f, +1.093572200e-02f, -1.800014869e-03f,
        +2.200893043e-04f, +5.668012201e-04f, +1.301972964e-04f, -1.014421126e-03f, -1.378908166e-03f, +3.318971155e-04f, +2.881863548e-03f, +2.778692537e-03f, -1.987072240e-03f, -8.580046670e-03f, -1.092943184e-02f, -5.640738141e-03f, +3.963807418e-03f, +1.051601006e-02f, +9.521604813e-03f, +3.251988858e-03f, -2.228911780e-03f, -3.173975131e-03f, -8.355229870e-04f, +1.223178360e-03f, +1.199938445e-03f, +5.922908536e-05f, -5.623019695e-04f, -3.093339044e-04f,
        -2.200893043e-04f, -6.044124905e-04f, +6.100731019e-04f, +1.572996310e-03f, +1.523598840e-04f, -2.294692934e-03f, -1.876568606e-03f, +1.727458567e-03f, +3.561760585e-03f, +3.674602494e-04f, -3.789309220e-03f, -2.868408124e-03f, +2.067656769e-03f, +4.101996605e-03f, +5.586673905e-04f, -3.324672468e-03f, -2.384626953e-03f, +1.343641901e-03f, +2.529760927e-03f, +3.418897025e-04f, -1.511370483e-03f, -8.934270684e-04f, +4.670589181e-04f, +3.093339044e-04f,
        /*  6,10 (24) */
        +2.549797646e-03f, -4.126208779e-03f, -1.128085032e-02f, -4.992121713e-03f, +1.624745768e-02f, +2.820386016e-02f, +2.780993487e-03f, -4.834857755e-02f, -6.267287113e-02f, +2.000864997e-02f, +1.842230305e-01f, +3.290446548e-01f, +3.482852888e-01f, +2.271785683e-01f, +5.625159772e-02f, -5.220730457e-02f, -5.840363747e-02f, -9.355234695e-03f, +2.587514245e-02f, +2.146998172e-02f, -5.557711946e-04f, -1.142875044e-02f, -6.391636422e-03f, +1.490680965e-03f,
        -2.549797646e-03f, +9.247651947e-03f, +1.115084451e-02f, -8.012131839e-03f, -2.592438545e-02f, -8.733253600e-03f, +3.043506957e-02f, +3.512120757e-02f, -1.233996566e-02f, -5.106011848e-02f, -2.217088908e-02f, +3.990227700e-02f, +4.980580271e-02f, -6.340204498e-03f, -5.068114479e-02f, -2.615761217e-02f, +2.687725901e-02f, +3.690223147e-02f, +9.433934541e-04f, -2.555264421e-02f, -1.420298520e-02f, +8.140313261e-03f, +1.140278092e-02f, -1.490680965e-03f,
        +1.904183455e-04f, +5.613480991e-04f, +1.869710954e-04f, -9.457910857e-04f, -1.412589230e-03f, +1.714163939e-04f, +2.761520825e-03f, +2.921959254e-03f, -1.580378250e-03f, -8.229084209e-03f, -1.100252535e-02f, -6.165247259e-03f, +3.376341920e-03f, +1.031385820e-02f, +9.793391686e-03f, +3.683683195e-03f, -2.006126058e-03f, -3.245278149e-03f, -1.008164877e-03f, +1.152894176e-03f, +1.253314472e-03f, +1.278743573e-04f, -5.533471255e-04f, -3.384479650e-04f,
        -1.904183455e-04f, -6.378708070e-04f, +5.133304347e-04f, +1.571785345e-03f, +3.081242579e-04f, -2.190016218e-03f, -2.026010514e-03f, +1.491253623e-03f, +3.595696109e-03f, +6.694913730e-04f, -3.638437143e-03f, -3.101247748e-03f, +1.772234684e-03f, +4.157030724e-03f, +8.675299851e-04f, -3.201477334e-03f, -2.581368987e-03f, +1.140928566e-03f, +2.579118290e-03f, +5.121924999e-04f, -1.468492415e-03f, -9.830884486e-04f, +4.093331982e-04f, +3.384479650e-04f,
        /*  6,11 (24) */
        +2.740215991e-03f, -3.564860680e-03f, -1.109387922e-02f, -5.937912799e-03f, +1.483486845e-02f, +2.837527656e-02f, +5.542514312e-03f, -4.542661830e-02f, -6.425324938e-02f, +1.177956577e-02f, +1.732205051e-01f, +3.228794075e-01f, +3.516616307e-01f, +2.374924265e-01f, +6.604498940e-02f, -4.852362137e-02f, -6.040976352e-02f, -1.260051284e-02f, +2.486697757e-02f, +2.262287590e-02f, +6.975432775e-04f, -1.130087608e-02f, -6.944983547e-03f, +1.152233000e-03f,
        -2.740215991e-03f, +8.609781140e-03f, +1.166417494e-02f, -6.440346494e-03f, -2.561626120e-02f, -1.092326982e-02f, +2.840905905e-02f, +3.661246119e-02f, -8.744269551e-03f, -5.039062711e-02f, -2.580932622e-02f, +3.680102925e-02f, +5.157803740e-02f, -2.183173774e-03f, -4.981361480e-02f, -2.935908950e-02f, +2.429589002e-02f, +3.804316003e-02f, +3.522511744e-03f, -2.504045171e-02f, -1.567147762e-02f, +7.157224812e-03f, +1.181211412e-02f, -1.152233000e-03f,
        +1.611192984e-04f, +5.527099981e-04f, +2.401989468e-04f, -8.746072696e-04f, -1.437348816e-03f, +1.583740675e-05f, +2.631307780e-03f, +3.045221976e-03f, -1.183453329e-03f, -7.862174877e-03f, -1.104338820e-02f, -6.669706987e-03f, +2.777770432e-03f, +1.008003094e-02f, +1.004182218e-02f, +4.117831997e-03f, -1.764042857e-03f, -3.302086415e-03f, -1.181776686e-03f, +1.073476637e-03f, +1.301639237e-03f, +1.987700110e-04f, -5.404595643e-04f, -3.668709269e-04f,
        -1.611192984e-04f, -6.651030470e-04f, +4.166576427e-04f, +1.560171705e-03f, +4.578132493e-04f, -2.073704357e-03f, -2.160058380e-03f, +1.249152335e-03f, +3.606996957e-03f, +9.650057653e-04f, -3.465893416e-03f, -3.314542726e-03f, +1.465588051e-03f, +4.186585198e-03f, +1.173167834e-03f, -3.057037956e-03f, -2.764505845e-03f, +9.274977734e-04f, +2.612848491e-03f, +6.834441848e-04f, -1.414347823e-03f, -1.069091052e-03f, +3.459613134e-04f, +3.668709269e-04f,
        /*  6,12 (24) */
        +2.901335290e-03f, -3.012150682e-03f, -1.085368028e-02f, -6.812520068e-03f, +1.339751963e-02f, +2.839111396e-02f, +8.173822091e-03f, -4.238139633e-02f, -6.543670271e-02f, +3.917390889e-03f, +1.621771169e-01f, +3.162097005e-01f, +3.544394011e-01f, +2.475724574e-01f, +7.608681158e-02f, -4.440578938e-02f, -6.217380638e-02f, -1.590259926e-02f, +2.368520088e-02f, +2.369635254e-02f, +1.999182515e-03f, -1.110210607e-02f, -7.485443112e-03f, +7.853620729e-04f,
        -2.901335290e-03f, +7.944678093e-03f, +1.208083258e-02f, -4.880174789e-03f, -2.515844795e-02f, -1.299697418e-02f, +2.624900067e-02f, +3.786161352e-02f, -5.137272594e-03f, -4.942562134e-02f, -2.927521964e-02f, +3.348648653e-02f, +5.304362545e-02f, +2.003411424e-03f, -4.864044697e-02f, -3.241612746e-02f, +2.153138417e-02f, +3.897065780e-02f, +6.135360235e-03f, -2.435700753e-02f, -1.708582544e-02f, +6.088133760e-03f, +1.215807543e-02f, -7.853620729e-04f,
        +1.323765352e-04f, +5.410824947e-04f, +2.897070603e-04f, -8.013718372e-04f, -1.453370552e-03f, -1.341881493e-04f, +2.492223559e-03f, +3.148608650e-03f, -7.975758828e-04f, -7.480946210e-03f, -1.105228015e-02f, -7.152546825e-03f, +2.170049140e-03f, +9.815013127e-03f, +1.026560914e-02f, +4.552826774e-03f, -1.503081518e-03f, -3.343586276e-03f, -1.355457625e-03f, +9.850369344e-04f, +1.344437307e-03f, +2.715760351e-04f, -5.235469186e-04f, -3.943700611e-04f,
        -1.323765352e-04f, -6.861465987e-04f, +3.207529261e-04f, +1.538541034e-03f, +6.005694260e-04f, -1.946768151e-03f, -2.278106348e-03f, +1.002794943e-03f, +3.595834350e-03f, +1.252174097e-03f, -3.272877333e-03f, -3.506978773e-03f, +1.149653509e-03f, +4.190376164e-03f, +1.473604520e-03f, -2.892078306e-03f, -2.932672115e-03f, +7.045798734e-04f, +2.630415027e-03f, +8.544961206e-04f, -1.348998650e-03f, -1.150679967e-03f, +2.772173487e-04f, +3.943700611e-04f,
        /*  6,13 (24) */
        +3.033711825e-03f, -2.471068187e-03f, -1.056397322e-02f, -7.613891905e-03f, +1.194414908e-02f, +2.825692581e-02f, +1.066604565e-02f, -3.923278767e-02f, -6.623427859e-02f, -3.563555321e-03f, +1.511248368e-01f, +3.090571537e-01f, +3