/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns;

import de.measite.minidns.InvalidDNSNameException;
import de.measite.minidns.idna.MiniDnsIdna;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;

public class DNSName
implements CharSequence,
Serializable,
Comparable<DNSName> {
    private static final long serialVersionUID = 1L;
    private static final String LABEL_SEP_REGEX = "[.\u3002\uff0e\uff61]";
    static final int MAX_DNSNAME_LENGTH_IN_OCTETS = 255;
    static final int MAX_LABEL_LENGTH_IN_OCTETS = 63;
    public static final int MAX_LABELS = 128;
    public static final DNSName EMPTY = new DNSName("", false);
    public static final DNSName ROOT = new DNSName(".", false);
    public static boolean VALIDATE = true;
    public final String ace;
    private transient byte[] bytes;
    private transient String idn;
    private transient String domainpart;
    private transient String hostpart;
    private transient String[] labels;
    private transient int hashCode;
    private int size = -1;

    private DNSName(String name) {
        this(name, true);
    }

    private DNSName(String name, boolean inIdnForm) {
        this.ace = inIdnForm ? MiniDnsIdna.toASCII(name) : name.toLowerCase(Locale.US);
        if (!VALIDATE) {
            return;
        }
        this.setBytesIfRequired();
        if (this.bytes.length > 255) {
            throw new InvalidDNSNameException.DNSNameTooLongException(name, this.bytes);
        }
        this.setLabelsIfRequired();
        for (String label : this.labels) {
            if (label.length() <= 63) continue;
            throw new InvalidDNSNameException.LabelTooLongException(name, label);
        }
    }

    private DNSName(String[] labels) {
        this.labels = labels;
        int size = 0;
        for (String label : labels) {
            size += label.length() + 1;
        }
        StringBuilder sb = new StringBuilder(size);
        for (int i = labels.length - 1; i >= 0; --i) {
            sb.append(labels[i]).append('.');
        }
        sb.setLength(sb.length() - 1);
        this.ace = sb.toString();
    }

    public void writeToStream(OutputStream os) throws IOException {
        this.setBytesIfRequired();
        os.write(this.bytes);
    }

    public byte[] getBytes() {
        this.setBytesIfRequired();
        return (byte[])this.bytes.clone();
    }

    private void setBytesIfRequired() {
        if (this.bytes != null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
        this.setLabelsIfRequired();
        for (int i = this.labels.length - 1; i >= 0; --i) {
            byte[] buffer = this.labels[i].getBytes();
            baos.write(buffer.length);
            baos.write(buffer, 0, buffer.length);
        }
        baos.write(0);
        assert (baos.size() <= 255);
        this.bytes = baos.toByteArray();
    }

    private void setLabelsIfRequired() {
        if (this.labels != null) {
            return;
        }
        if (this.isRootLabel()) {
            this.labels = new String[0];
            return;
        }
        this.labels = this.ace.split(LABEL_SEP_REGEX, 128);
        for (int i = 0; i < this.labels.length / 2; ++i) {
            String t = this.labels[i];
            int j = this.labels.length - i - 1;
            this.labels[i] = this.labels[j];
            this.labels[j] = t;
        }
    }

    public String asIdn() {
        if (this.idn != null) {
            return this.idn;
        }
        this.idn = MiniDnsIdna.toUnicode(this.ace);
        return this.idn;
    }

    public String getDomainpart() {
        this.setHostnameAndDomainpartIfRequired();
        return this.domainpart;
    }

    public String getHostpart() {
        this.setHostnameAndDomainpartIfRequired();
        return this.hostpart;
    }

    private void setHostnameAndDomainpartIfRequired() {
        if (this.hostpart != null) {
            return;
        }
        String[] parts = this.ace.split(LABEL_SEP_REGEX, 2);
        this.hostpart = parts[0];
        this.domainpart = parts.length > 1 ? parts[1] : "";
    }

    public int size() {
        if (this.size < 0) {
            this.size = this.isRootLabel() ? 1 : this.ace.length() + 2;
        }
        return this.size;
    }

    @Override
    public int length() {
        return this.ace.length();
    }

    @Override
    public char charAt(int index) {
        return this.ace.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.ace.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.ace;
    }

    public static DNSName from(CharSequence name) {
        return DNSName.from(name.toString());
    }

    public static DNSName from(String name) {
        return new DNSName(name, true);
    }

    public static DNSName from(DNSName left, DNSName right) {
        left.setLabelsIfRequired();
        right.setLabelsIfRequired();
        String[] labels = new String[left.labels.length + right.labels.length];
        System.arraycopy(right.labels, 0, labels, 0, right.labels.length);
        System.arraycopy(left.labels, 0, labels, right.labels.length, left.labels.length);
        return new DNSName(labels);
    }

    public static DNSName parse(DataInputStream dis, byte[] data) throws IOException {
        int c = dis.readUnsignedByte();
        if ((c & 0xC0) == 192) {
            c = ((c & 0x3F) << 8) + dis.readUnsignedByte();
            HashSet<Integer> jumps = new HashSet<Integer>();
            jumps.add(c);
            return DNSName.parse(data, c, jumps);
        }
        if (c == 0) {
            return EMPTY;
        }
        byte[] b = new byte[c];
        dis.readFully(b);
        String s = MiniDnsIdna.toUnicode(new String(b));
        DNSName t = DNSName.parse(dis, data);
        if (t.length() > 0) {
            s = s + "." + t;
        }
        return new DNSName(s);
    }

    private static DNSName parse(byte[] data, int offset, HashSet<Integer> jumps) throws IllegalStateException {
        int c = data[offset] & 0xFF;
        if ((c & 0xC0) == 192) {
            if (jumps.contains(c = ((c & 0x3F) << 8) + (data[offset + 1] & 0xFF))) {
                throw new IllegalStateException("Cyclic offsets detected.");
            }
            jumps.add(c);
            return DNSName.parse(data, c, jumps);
        }
        if (c == 0) {
            return EMPTY;
        }
        String s = new String(data, offset + 1, c);
        DNSName t = DNSName.parse(data, offset + 1 + c, jumps);
        if (t.length() > 0) {
            s = s + "." + t;
        }
        return new DNSName(s);
    }

    @Override
    public int compareTo(DNSName other) {
        return this.ace.compareTo(other.ace);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof DNSName) {
            DNSName otherDnsName = (DNSName)other;
            this.setBytesIfRequired();
            otherDnsName.setBytesIfRequired();
            return Arrays.equals(this.bytes, otherDnsName.bytes);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0 && !this.isRootLabel()) {
            this.setBytesIfRequired();
            this.hashCode = Arrays.hashCode(this.bytes);
        }
        return this.hashCode;
    }

    public boolean isDirectChildOf(DNSName parent) {
        this.setLabelsIfRequired();
        parent.setLabelsIfRequired();
        int parentLabelsCount = parent.labels.length;
        if (this.labels.length - 1 != parentLabelsCount) {
            return false;
        }
        for (int i = 0; i < parent.labels.length; ++i) {
            if (this.labels[i].equals(parent.labels[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isChildOf(DNSName parent) {
        this.setLabelsIfRequired();
        parent.setLabelsIfRequired();
        if (this.labels.length < parent.labels.length) {
            return false;
        }
        for (int i = 0; i < parent.labels.length; ++i) {
            if (this.labels[i].equals(parent.labels[i])) continue;
            return false;
        }
        return true;
    }

    public int getLabelCount() {
        this.setLabelsIfRequired();
        return this.labels.length;
    }

    public DNSName stripToLabels(int labelCount) {
        this.setLabelsIfRequired();
        if (labelCount > this.labels.length) {
            throw new IllegalArgumentException();
        }
        if (labelCount == this.labels.length) {
            return this;
        }
        if (labelCount == 0) {
            return EMPTY;
        }
        String[] stripedLabels = new String[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            stripedLabels[i] = this.labels[i];
        }
        return new DNSName(stripedLabels);
    }

    public DNSName getParent() {
        if (this.isRootLabel()) {
            return EMPTY;
        }
        return this.stripToLabels(this.getLabelCount() - 1);
    }

    public boolean isRootLabel() {
        return this.ace.isEmpty() || this.ace.equals(".");
    }
}

