/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo.appstore.common.utils.httpdownload;

import android.content.Context;
import android.os.Environment;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import com.qihoo.appstore.common.utils.h;
import com.qihoo.appstore.common.utils.httpdownload.StopRequest;
import com.qihoo.appstore.common.utils.httpdownload.a;
import com.qihoo.appstore.common.utils.httpdownload.b;
import com.qihoo.appstore.common.utils.httpdownload.e;
import com.qihoo.appstore.common.utils.k;
import com.qihoo.appstore.common.utils.p;
import com.qihoo.appstore.common.utils.r;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;

public class c
implements Runnable {
    private e a;
    private final a b;
    private final Context c;
    private boolean d;

    public c(Context context, a a2, e e2) {
        this.b = a2;
        this.c = context.getApplicationContext();
        this.a = e2;
    }

    private static long a(URLConnection uRLConnection, String string, long l2) {
        try {
            return Long.parseLong(uRLConnection.getHeaderField(string));
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        PowerManager.WakeLock wakeLock = null;
        PowerManager powerManager = (PowerManager)this.c.getSystemService("power");
        try {
            wakeLock = powerManager.newWakeLock(1, "HttpDownloadThread");
            wakeLock.acquire();
            h.d(new File(this.b.n));
            this.b.o = 192;
            if (this.a != null && !this.a.a(this.b)) {
                k.b("HttpDownloadThread", "run before executeDownload() " + this.b.n);
                this.a();
            }
            this.d = true;
        }
        catch (StopRequest stopRequest) {
            stopRequest.printStackTrace();
            k.b("HttpDownloadThread", "run catch (StopRequest e) " + stopRequest.getFinalStatus() + " " + stopRequest.toString());
            this.b.o = stopRequest.getFinalStatus();
            this.b.q = stopRequest.getMessage();
            this.d = false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            k.b(false);
            k.b("HttpDownloadThread", "run catch (Throwable t) " + throwable.toString());
            this.b.o = 491;
            this.b.q = throwable.toString();
            this.d = false;
        }
        finally {
            if (wakeLock != null) {
                wakeLock.release();
            }
            if (this.a != null) {
                this.a.a(this.b, this.d);
            }
            k.b("HttpDownloadThread", "run after executeDownload()");
        }
    }

    private void a() throws StopRequest {
        URL uRL;
        try {
            uRL = new URL(this.b.m);
        }
        catch (MalformedURLException malformedURLException) {
            k.b("HttpDownloadThread", "executeDownload new URL MalformedURLException " + malformedURLException.toString());
            throw new StopRequest(400, (Throwable)malformedURLException);
        }
        int n2 = 0;
        block19: while (n2++ < 5) {
            HttpURLConnection httpURLConnection = null;
            try {
                this.b();
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setInstanceFollowRedirects(false);
                httpURLConnection.setConnectTimeout(20000);
                httpURLConnection.setReadTimeout(20000);
                boolean bl = this.b.u != 0L;
                this.a(httpURLConnection, bl);
                int n3 = httpURLConnection.getResponseCode();
                k.b("HttpDownloadThread", "executeDownload responseCode " + n3 + " " + n2);
                switch (n3) {
                    case 200: {
                        this.a(httpURLConnection);
                        k.b(!bl);
                        this.b(httpURLConnection);
                        return;
                    }
                    case 206: {
                        k.b(bl);
                        this.b(httpURLConnection);
                        return;
                    }
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: {
                        String string = httpURLConnection.getHeaderField("Location");
                        uRL = new URL(uRL, string);
                        if (n3 != 301) continue block19;
                        this.b.m = uRL.toString();
                        continue block19;
                    }
                    case 412: {
                        k.b("HttpDownloadThread", "executeDownload StopRequest HTTP_PRECON_FAILED ");
                        throw new StopRequest(489, "Precondition failed");
                    }
                    case 416: {
                        k.b("HttpDownloadThread", "executeDownload StopRequest HTTP_REQUESTED_RANGE_NOT_SATISFIABLE ");
                        throw new StopRequest(489, "Requested range not satisfiable");
                    }
                    case 503: {
                        k.b("HttpDownloadThread", "executeDownload StopRequest HTTP_UNAVAILABLE ");
                        throw new StopRequest(503, httpURLConnection.getResponseMessage());
                    }
                    case 500: {
                        k.b("HttpDownloadThread", "executeDownload StopRequest HTTP_INTERNAL_ERROR ");
                        throw new StopRequest(500, httpURLConnection.getResponseMessage());
                    }
                }
                k.b("HttpDownloadThread", "executeDownload StopRequest default ");
                StopRequest.throwUnhandledHttpError(n3, httpURLConnection.getResponseMessage());
            }
            catch (IOException iOException) {
                if (iOException instanceof ProtocolException && iOException.getMessage().startsWith("Unexpected status line")) {
                    k.b("HttpDownloadThread", "executeDownload StopRequest ProtocolException ");
                    throw new StopRequest(494, (Throwable)iOException);
                }
                k.b("HttpDownloadThread", "executeDownload StopRequest STATUS_HTTP_DATA_ERROR ");
                throw new StopRequest(495, (Throwable)iOException);
            }
            finally {
                if (httpURLConnection == null) continue;
                httpURLConnection.disconnect();
            }
        }
        k.b("HttpDownloadThread", "executeDownload StopRequest STATUS_TOO_MANY_REDIRECTS ");
        throw new StopRequest(497, "Too many redirects");
    }

    private void b() throws StopRequest {
        boolean bl = com.qihoo.appstore.common.utils.d.a.d();
        if (!bl) {
            k.b("HttpDownloadThread", "executeDownload StopRequest checkConnectivity ");
            throw new StopRequest(10495, "checkConnectivity");
        }
    }

    private void a(HttpURLConnection httpURLConnection, boolean bl) throws StopRequest {
        if (bl) {
            if (!TextUtils.isEmpty((CharSequence)this.b.v)) {
                httpURLConnection.addRequestProperty("If-Match", this.b.v);
            }
            httpURLConnection.addRequestProperty("Range", "bytes=" + this.b.u + "-");
            k.b("HttpDownloadThread", "addRequestHeaders range " + this.b.u);
        }
        if (httpURLConnection.getRequestProperty("User-Agent") == null) {
            httpURLConnection.addRequestProperty("User-Agent", System.getProperty("http.agent"));
        }
        httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
        httpURLConnection.setRequestProperty("Connection", "close");
    }

    private void a(HttpURLConnection httpURLConnection) throws StopRequest {
        String string = httpURLConnection.getHeaderField("Content-Disposition");
        String string2 = httpURLConnection.getHeaderField("Content-Location");
        this.b.w = p.a(httpURLConnection.getContentType());
        String string3 = httpURLConnection.getHeaderField("Transfer-Encoding");
        long l2 = 0L;
        this.b.t = string3 == null ? (l2 = com.qihoo.appstore.common.utils.httpdownload.c.a(httpURLConnection, "Content-Length", -1L)) : -1L;
        this.b.v = httpURLConnection.getHeaderField("ETag");
        this.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b(HttpURLConnection httpURLConnection) throws StopRequest {
        boolean bl;
        boolean bl2 = this.b.t != -1L;
        boolean bl3 = "close".equalsIgnoreCase(httpURLConnection.getHeaderField("Connection"));
        boolean bl4 = "chunked".equalsIgnoreCase(httpURLConnection.getHeaderField("Transfer-Encoding"));
        boolean bl5 = bl = bl2 || bl3 || bl4;
        if (!bl) {
            k.b("HttpDownloadThread", "transferData StopRequest STATUS_CANNOT_RESUME ");
            throw new StopRequest(489, "can't know size of download, giving up");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            try {
                inputStream = httpURLConnection.getInputStream();
            }
            catch (IOException iOException) {
                k.b("HttpDownloadThread", "transferData StopRequest STATUS_HTTP_DATA_ERROR ");
                throw new StopRequest(495, (Throwable)iOException);
            }
            try {
                File file = new File(this.b.n);
                if (!r.a(this.c, file)) {
                    k.b("HttpDownloadThread", "transferData StopRequest STATUS_FILE_ERROR isFilenameValid");
                    throw new StopRequest(492, "inValid file path = " + file.getAbsolutePath());
                }
                outputStream = new FileOutputStream(file, true);
            }
            catch (IOException iOException) {
                k.b("HttpDownloadThread", "transferData StopRequest STATUS_FILE_ERROR IOException");
                throw new StopRequest(492, (Throwable)iOException);
            }
            this.a(inputStream, outputStream);
            return;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    private void a(InputStream inputStream, OutputStream outputStream) throws StopRequest {
        byte[] byArray = new byte[com.qihoo.appstore.common.utils.httpdownload.b.a];
        while (true) {
            int n2;
            this.c();
            try {
                n2 = inputStream.read(byArray);
            }
            catch (IOException iOException) {
                k.b("HttpDownloadThread", "transferDataImp StopRequest HTTP_PRECON_FAILED ");
                throw new StopRequest(495, "Failed reading response: " + iOException, iOException);
            }
            if (n2 == -1) break;
            try {
                outputStream.write(byArray, 0, n2);
                this.b.u += (long)n2;
                if (this.a == null) continue;
                this.a.b(this.b);
            }
            catch (IOException iOException) {
                this.a(iOException, this.b.n, n2);
                k.b("HttpDownloadThread", "transferDataImp StopRequest STATUS_FILE_ERROR ");
                throw new StopRequest(492, (Throwable)iOException);
            }
        }
        if (this.b.t != -1L && this.b.u != this.b.t) {
            k.b("HttpDownloadThread", "transferDataImp StopRequest STATUS_HTTP_DATA_ERROR ");
            throw new StopRequest(495, "Content length mismatch");
        }
    }

    private void c() throws StopRequest {
        StopRequest stopRequest = null;
        int n2 = this.b.p;
        if (n2 == 2) {
            this.b.o = 196;
            if (this.a != null) {
                this.a.b(this.b);
            }
            stopRequest = new StopRequest(193, "download paused by owner");
        } else if (n2 == 3) {
            this.b.o = 187;
            if (this.a != null) {
                this.a.b(this.b);
            }
            stopRequest = new StopRequest(490, "download canceled by owner");
        }
        if (stopRequest != null) {
            throw stopRequest;
        }
        this.b();
    }

    private void a(IOException iOException, String string, int n2) throws StopRequest {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            k.b("HttpDownloadThread", "handlerAvailableSpaceException StopRequest STATUS_DEVICE_NOT_FOUND_ERROR ");
            throw new StopRequest(487, "external media not mounted while writing destination file");
        }
        if (!h.a(r.a(string), (long)n2)) {
            k.b("HttpDownloadThread", "handlerAvailableSpaceException StopRequest STATUS_INSUFFICIENT_SPACE_ERROR ");
            throw new StopRequest(488, "insufficient space while writing destination file", iOException);
        }
        k.b("HttpDownloadThread", "handlerAvailableSpaceException StopRequest STATUS_FILE_ERROR ");
        throw new StopRequest(492, "while writing destination file: " + iOException.toString(), iOException);
    }
}

