/*
 * Decompiled with CFR 0.152.
 */
package de.measite.minidns;

import de.measite.minidns.DNSName;
import de.measite.minidns.Record;
import de.measite.minidns.edns.EDNSOption;
import de.measite.minidns.edns.NSID;
import de.measite.minidns.edns.UnknownEDNSOption;
import de.measite.minidns.record.Data;
import de.measite.minidns.record.OPT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EDNS {
    public static final int FLAG_DNSSEC_OK = 32768;
    public final int udpPayloadSize;
    public final int extendedRcode;
    public final int version;
    public final int flags;
    public final List<EDNSOption> variablePart;
    public final boolean dnssecOk;
    private Record<OPT> optRecord;
    private String terminalOutputCache;

    public EDNS(Record<OPT> optRecord) {
        assert (optRecord.type == Record.TYPE.OPT);
        this.udpPayloadSize = optRecord.clazzValue;
        this.extendedRcode = (int)(optRecord.ttl >> 8 & 0xFFL);
        this.version = (int)(optRecord.ttl >> 16 & 0xFFL);
        this.flags = (int)optRecord.ttl & 0xFFFF;
        this.dnssecOk = (optRecord.ttl & 0x8000L) > 0L;
        OPT opt = (OPT)optRecord.payloadData;
        this.variablePart = opt.variablePart;
        this.optRecord = optRecord;
    }

    public EDNS(Builder builder) {
        this.udpPayloadSize = builder.udpPayloadSize;
        this.extendedRcode = builder.extendedRcode;
        this.version = builder.version;
        int flags = 0;
        if (builder.dnssecOk) {
            flags |= 0x8000;
        }
        this.dnssecOk = builder.dnssecOk;
        this.flags = flags;
        this.variablePart = builder.variablePart != null ? builder.variablePart : Collections.emptyList();
    }

    public <O extends EDNSOption> O getEdnsOption(OptionCode optionCode) {
        for (EDNSOption o : this.variablePart) {
            if (!o.getOptionCode().equals((Object)optionCode)) continue;
            return (O)o;
        }
        return null;
    }

    public Record<OPT> asRecord() {
        if (this.optRecord == null) {
            long optFlags = this.flags;
            optFlags |= (long)(this.extendedRcode << 8);
            this.optRecord = new Record<OPT>(DNSName.EMPTY, Record.TYPE.OPT, this.udpPayloadSize, optFlags |= (long)(this.version << 16), new OPT(this.variablePart));
        }
        return this.optRecord;
    }

    public String asTerminalOutput() {
        if (this.terminalOutputCache == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("EDNS: version: ").append(this.version).append(", flags:");
            if (this.dnssecOk) {
                sb.append(" do");
            }
            sb.append("; udp: ").append(this.udpPayloadSize);
            if (!this.variablePart.isEmpty()) {
                sb.append('\n');
                Iterator<EDNSOption> it = this.variablePart.iterator();
                while (it.hasNext()) {
                    EDNSOption edns = it.next();
                    sb.append((Object)edns.getOptionCode()).append(": ");
                    sb.append(edns.asTerminalOutput());
                    if (!it.hasNext()) continue;
                    sb.append('\n');
                }
            }
            this.terminalOutputCache = sb.toString();
        }
        return this.terminalOutputCache;
    }

    public String toString() {
        return this.asTerminalOutput();
    }

    public static EDNS fromRecord(Record<? extends Data> record) {
        if (record.type != Record.TYPE.OPT) {
            return null;
        }
        Record<? extends Data> optRecord = record;
        return new EDNS(optRecord);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int udpPayloadSize;
        private int extendedRcode;
        private int version;
        private boolean dnssecOk;
        private List<EDNSOption> variablePart;

        private Builder() {
        }

        public Builder setUdpPayloadSize(int udpPayloadSize) {
            if (udpPayloadSize > 65535) {
                throw new IllegalArgumentException("UDP payload size must not be greater than 65536, was " + udpPayloadSize);
            }
            this.udpPayloadSize = udpPayloadSize;
            return this;
        }

        public Builder setDnssecOk(boolean dnssecOk) {
            this.dnssecOk = dnssecOk;
            return this;
        }

        public Builder setDnssecOk() {
            this.dnssecOk = true;
            return this;
        }

        public Builder addEdnsOption(EDNSOption ednsOption) {
            if (this.variablePart == null) {
                this.variablePart = new ArrayList<EDNSOption>(4);
            }
            this.variablePart.add(ednsOption);
            return this;
        }

        public EDNS build() {
            return new EDNS(this);
        }
    }

    public static enum OptionCode {
        UNKNOWN(-1, UnknownEDNSOption.class),
        NSID(3, NSID.class);

        private static Map<Integer, OptionCode> INVERSE_LUT;
        public final int asInt;
        public final Class<? extends EDNSOption> clazz;

        private OptionCode(int optionCode, Class<? extends EDNSOption> clazz) {
            this.asInt = optionCode;
            this.clazz = clazz;
        }

        public static OptionCode from(int optionCode) {
            OptionCode res = INVERSE_LUT.get(optionCode);
            if (res == null) {
                res = UNKNOWN;
            }
            return res;
        }

        static {
            INVERSE_LUT = new HashMap<Integer, OptionCode>(OptionCode.values().length);
            for (OptionCode optionCode : OptionCode.values()) {
                INVERSE_LUT.put(optionCode.asInt, optionCode);
            }
        }
    }
}

